/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.body.abstractTypes.AbstractFluidType;
import com.lilithsthrone.game.character.body.valueEnums.FluidFlavour;
import com.lilithsthrone.game.character.body.valueEnums.FluidModifier;
import com.lilithsthrone.game.character.body.valueEnums.FluidTypeBase;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FluidType {
    public static AbstractFluidType CUM_HUMAN;
    public static AbstractFluidType CUM_DOLL;
    public static AbstractFluidType CUM_ANGEL;
    public static AbstractFluidType CUM_DEMON;
    public static AbstractFluidType CUM_DOG_MORPH;
    public static AbstractFluidType CUM_WOLF_MORPH;
    public static AbstractFluidType CUM_FOX_MORPH;
    public static AbstractFluidType CUM_CAT_MORPH;
    public static AbstractFluidType CUM_SQUIRREL_MORPH;
    public static AbstractFluidType CUM_RAT_MORPH;
    public static AbstractFluidType CUM_RABBIT_MORPH;
    public static AbstractFluidType CUM_BAT_MORPH;
    public static AbstractFluidType CUM_ALLIGATOR_MORPH;
    public static AbstractFluidType CUM_HORSE_MORPH;
    public static AbstractFluidType CUM_REINDEER_MORPH;
    public static AbstractFluidType CUM_COW_MORPH;
    public static AbstractFluidType CUM_HARPY;
    public static AbstractFluidType GIRL_CUM_HUMAN;
    public static AbstractFluidType GIRL_CUM_DOLL;
    public static AbstractFluidType GIRL_CUM_ANGEL;
    public static AbstractFluidType GIRL_CUM_DEMON;
    public static AbstractFluidType GIRL_CUM_DOG_MORPH;
    public static AbstractFluidType GIRL_CUM_WOLF_MORPH;
    public static AbstractFluidType GIRL_CUM_FOX_MORPH;
    public static AbstractFluidType GIRL_CUM_CAT_MORPH;
    public static AbstractFluidType GIRL_CUM_SQUIRREL_MORPH;
    public static AbstractFluidType GIRL_CUM_RAT_MORPH;
    public static AbstractFluidType GIRL_CUM_RABBIT_MORPH;
    public static AbstractFluidType GIRL_CUM_BAT_MORPH;
    public static AbstractFluidType GIRL_CUM_ALLIGATOR_MORPH;
    public static AbstractFluidType GIRL_CUM_HORSE_MORPH;
    public static AbstractFluidType GIRL_CUM_REINDEER_MORPH;
    public static AbstractFluidType GIRL_CUM_COW_MORPH;
    public static AbstractFluidType GIRL_CUM_HARPY;
    public static AbstractFluidType MILK_HUMAN;
    public static AbstractFluidType MILK_DOLL;
    public static AbstractFluidType MILK_ANGEL;
    public static AbstractFluidType MILK_COW_MORPH;
    public static AbstractFluidType MILK_DEMON;
    public static AbstractFluidType MILK_DOG_MORPH;
    public static AbstractFluidType MILK_WOLF_MORPH;
    public static AbstractFluidType MILK_FOX_MORPH;
    public static AbstractFluidType MILK_CAT_MORPH;
    public static AbstractFluidType MILK_SQUIRREL_MORPH;
    public static AbstractFluidType MILK_RAT_MORPH;
    public static AbstractFluidType MILK_RABBIT_MORPH;
    public static AbstractFluidType MILK_BAT_MORPH;
    public static AbstractFluidType MILK_ALLIGATOR_MORPH;
    public static AbstractFluidType MILK_HORSE_MORPH;
    public static AbstractFluidType MILK_REINDEER_MORPH;
    public static AbstractFluidType MILK_HARPY;
    private static List<AbstractFluidType> allFluidTypes;
    private static Map<AbstractFluidType, String> fluidToIdMap;
    private static Map<String, AbstractFluidType> idToFluidMap;
    private static Map<AbstractRace, List<AbstractFluidType>> typesMap;

    public static AbstractFluidType getFluidTypeFromId(String id) {
        if (id.equals("CUM_IMP")) {
            id = "CUM_DEMON";
        } else if (id.equals("GIRL_CUM_IMP")) {
            id = "GIRL_CUM_DEMON";
        } else if (id.equals("MILK_IMP")) {
            id = "MILK_DEMON";
        } else if (id.equals("MILK_DEMON_COMMON")) {
            id = "MILK_DEMON";
        }
        id = Util.getClosestStringMatch(id, idToFluidMap.keySet());
        return idToFluidMap.get(id);
    }

    public static String getIdFromFluidType(AbstractFluidType fluidType) {
        return fluidToIdMap.get(fluidType);
    }

    public static List<AbstractFluidType> getAllFluidTypes() {
        return allFluidTypes;
    }

    public static List<AbstractFluidType> getFluidTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractFluidType> types = new ArrayList<AbstractFluidType>();
        for (AbstractFluidType type : FluidType.getAllFluidTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        typesMap.put(r, types);
        return types;
    }

    static {
        Field[] fieldArray;
        CUM_HUMAN = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.HUMAN, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_DOLL = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.DOLL, Util.newArrayListOfValues("\u73a9\u5076"), Util.newArrayListOfValues("\u73a9\u5076"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.SLIMY, FluidModifier.MINERAL_OIL)){

            @Override
            public float getValueModifier() {
                return 0.25f;
            }
        };
        CUM_ANGEL = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.ANGEL, Util.newArrayListOfValues("\u5929\u4f7f"), Util.newArrayListOfValues("\u5929\u4f7f"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_DEMON = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.DEMON, Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_DOG_MORPH = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.DOG_MORPH, Util.newArrayListOfValues("\u72ac", "\u72ac\u7c7b"), Util.newArrayListOfValues("\u72ac", "\u72ac\u7c7b"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_WOLF_MORPH = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.WOLF_MORPH, Util.newArrayListOfValues("\u72fc"), Util.newArrayListOfValues("\u72fc"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.MUSKY, FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_FOX_MORPH = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.FOX_MORPH, Util.newArrayListOfValues("\u72d0\u72f8"), Util.newArrayListOfValues("\u72d0\u72f8"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_CAT_MORPH = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.CAT_MORPH, Util.newArrayListOfValues("\u732b", "\u732b\u7c7b"), Util.newArrayListOfValues("\u732b", "\u732b\u7c7b"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_SQUIRREL_MORPH = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.SQUIRREL_MORPH, Util.newArrayListOfValues("\u677e\u9f20", "\u556e\u9f7f\u52a8\u7269"), Util.newArrayListOfValues("\u677e\u9f20", "\u556e\u9f7f\u52a8\u7269"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_RAT_MORPH = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.RAT_MORPH, Util.newArrayListOfValues("\u9f20", "\u556e\u9f7f\u52a8\u7269"), Util.newArrayListOfValues("\u9f20", "\u556e\u9f7f\u52a8\u7269"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_RABBIT_MORPH = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.RABBIT_MORPH, Util.newArrayListOfValues("\u5154\u5b50"), Util.newArrayListOfValues("\u5154\u5b50"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_BAT_MORPH = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.BAT_MORPH, Util.newArrayListOfValues("\u8759\u8760"), Util.newArrayListOfValues("\u8759\u8760"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_ALLIGATOR_MORPH = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.ALLIGATOR_MORPH, Util.newArrayListOfValues("\u9cc4\u9c7c", "\u722c\u884c\u52a8\u7269"), Util.newArrayListOfValues("\u9cc4\u9c7c", "\u722c\u884c\u52a8\u7269"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_HORSE_MORPH = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.HORSE_MORPH, Util.newArrayListOfValues("\u9a6c", "\u9a6c\u7c7b"), Util.newArrayListOfValues("\u9a6c", "\u9a6c\u7c7b"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.MUSKY, FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_REINDEER_MORPH = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.REINDEER_MORPH, Util.newArrayListOfValues("\u9a6f\u9e7f"), Util.newArrayListOfValues("\u9a6f\u9e7f"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.MUSKY, FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_COW_MORPH = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.COW_MORPH, Util.newArrayListOfValues("\u725b", "\u725b\u7c7b"), Util.newArrayListOfValues("\u725b", "\u725b\u7c7b"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.MUSKY, FluidModifier.STICKY, FluidModifier.SLIMY)){};
        CUM_HARPY = new AbstractFluidType(FluidTypeBase.CUM, FluidFlavour.CUM, Race.HARPY, Util.newArrayListOfValues("\u54c8\u6bd4", "\u9e1f"), Util.newArrayListOfValues("\u54c8\u6bd4", "\u9e1f"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.STICKY, FluidModifier.SLIMY)){};
        GIRL_CUM_HUMAN = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.HUMAN, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_DOLL = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.DOLL, Util.newArrayListOfValues("\u73a9\u5076"), Util.newArrayListOfValues("\u73a9\u5076"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.SLIMY, FluidModifier.MINERAL_OIL)){

            @Override
            public float getValueModifier() {
                return 0.25f;
            }
        };
        GIRL_CUM_ANGEL = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.ANGEL, null, null, Util.newArrayListOfValues("\u5929\u4f7f"), Util.newArrayListOfValues("\u5929\u4f7f"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_DEMON = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.DEMON, null, null, Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_DOG_MORPH = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.DOG_MORPH, null, null, Util.newArrayListOfValues("\u72ac\u7c7b"), Util.newArrayListOfValues("\u72ac\u7c7b"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_WOLF_MORPH = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.WOLF_MORPH, null, null, Util.newArrayListOfValues("\u72fc\u7c7b"), Util.newArrayListOfValues("\u72fc\u7c7b"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_FOX_MORPH = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.FOX_MORPH, null, null, Util.newArrayListOfValues("\u72d0\u72f8"), Util.newArrayListOfValues("\u72d0\u72f8"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_CAT_MORPH = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.CAT_MORPH, null, null, Util.newArrayListOfValues("\u732b\u7c7b"), Util.newArrayListOfValues("\u732b\u7c7b"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_SQUIRREL_MORPH = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.SQUIRREL_MORPH, null, null, Util.newArrayListOfValues("\u677e\u9f20"), Util.newArrayListOfValues("\u677e\u9f20"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_RAT_MORPH = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.RAT_MORPH, null, null, Util.newArrayListOfValues("\u8001\u9f20"), Util.newArrayListOfValues("\u8001\u9f20"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_RABBIT_MORPH = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.RABBIT_MORPH, null, null, Util.newArrayListOfValues("\u5154\u5b50"), Util.newArrayListOfValues("\u5154\u5b50"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_BAT_MORPH = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.BAT_MORPH, null, null, Util.newArrayListOfValues("\u8759\u8760"), Util.newArrayListOfValues("\u8759\u8760"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_ALLIGATOR_MORPH = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.ALLIGATOR_MORPH, null, null, Util.newArrayListOfValues("\u9cc4\u9c7c"), Util.newArrayListOfValues("\u9cc4\u9c7c"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_HORSE_MORPH = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.HORSE_MORPH, null, null, Util.newArrayListOfValues("\u9a6c\u7c7b"), Util.newArrayListOfValues("\u9a6c\u7c7b"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_REINDEER_MORPH = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.REINDEER_MORPH, null, null, Util.newArrayListOfValues("\u9a6f\u9e7f"), Util.newArrayListOfValues("\u9a6f\u9e7f"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_COW_MORPH = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.COW_MORPH, null, null, Util.newArrayListOfValues("\u725b\u7c7b"), Util.newArrayListOfValues("\u725b\u7c7b"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        GIRL_CUM_HARPY = new AbstractFluidType(FluidTypeBase.GIRLCUM, FluidFlavour.GIRL_CUM, Race.HARPY, null, null, Util.newArrayListOfValues("\u9e1f\u7c7b"), Util.newArrayListOfValues("\u9e1f\u7c7b"), Util.newArrayListOfValues(FluidModifier.SLIMY)){};
        MILK_HUMAN = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.HUMAN, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_DOLL = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.DOLL, Util.newArrayListOfValues("\u73a9\u5076"), Util.newArrayListOfValues("\u73a9\u5076"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(FluidModifier.SLIMY, FluidModifier.MINERAL_OIL)){

            @Override
            public float getValueModifier() {
                return 0.25f;
            }
        };
        MILK_ANGEL = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.ANGEL, null, null, Util.newArrayListOfValues("\u5929\u4f7f"), Util.newArrayListOfValues("\u5929\u4f7f"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_COW_MORPH = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.COW_MORPH, null, null, Util.newArrayListOfValues("\u725b\u7c7b"), Util.newArrayListOfValues("\u725b\u7c7b"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_DEMON = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.DEMON, null, null, Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_DOG_MORPH = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.DOG_MORPH, null, null, Util.newArrayListOfValues("\u72ac\u7c7b"), Util.newArrayListOfValues("\u72ac\u7c7b"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_WOLF_MORPH = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.WOLF_MORPH, null, null, Util.newArrayListOfValues("\u72fc\u7c7b"), Util.newArrayListOfValues("\u72fc\u7c7b"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_FOX_MORPH = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.FOX_MORPH, null, null, Util.newArrayListOfValues("\u72d0\u72f8"), Util.newArrayListOfValues("\u72d0\u72f8"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_CAT_MORPH = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.CAT_MORPH, null, null, Util.newArrayListOfValues("\u732b\u7c7b"), Util.newArrayListOfValues("\u732b\u7c7b"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_SQUIRREL_MORPH = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.SQUIRREL_MORPH, null, null, Util.newArrayListOfValues("\u677e\u9f20"), Util.newArrayListOfValues("\u677e\u9f20"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_RAT_MORPH = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.RAT_MORPH, null, null, Util.newArrayListOfValues("\u8001\u9f20"), Util.newArrayListOfValues("\u8001\u9f20"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_RABBIT_MORPH = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.RABBIT_MORPH, null, null, Util.newArrayListOfValues("\u5154\u5b50"), Util.newArrayListOfValues("\u5154\u5b50"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_BAT_MORPH = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.BAT_MORPH, null, null, Util.newArrayListOfValues("\u8759\u8760"), Util.newArrayListOfValues("\u8759\u8760"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_ALLIGATOR_MORPH = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.ALLIGATOR_MORPH, null, null, Util.newArrayListOfValues("\u9cc4\u9c7c"), Util.newArrayListOfValues("\u9cc4\u9c7c"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_HORSE_MORPH = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.HORSE_MORPH, null, null, Util.newArrayListOfValues("\u9a6c\u7c7b"), Util.newArrayListOfValues("\u9a6c\u7c7b"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_REINDEER_MORPH = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.REINDEER_MORPH, null, null, Util.newArrayListOfValues("\u9a6f\u9e7f"), Util.newArrayListOfValues("\u9a6f\u9e7f"), Util.newArrayListOfValues(new FluidModifier[0])){};
        MILK_HARPY = new AbstractFluidType(FluidTypeBase.MILK, FluidFlavour.MILK, Race.HARPY, null, null, Util.newArrayListOfValues("\u9e1f\u7c7b"), Util.newArrayListOfValues("\u9e1f\u7c7b"), Util.newArrayListOfValues(new FluidModifier[0])){};
        fluidToIdMap = new HashMap<AbstractFluidType, String>();
        idToFluidMap = new HashMap<String, AbstractFluidType>();
        allFluidTypes = new ArrayList<AbstractFluidType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("fluid")) continue;
                try {
                    AbstractFluidType type = new AbstractFluidType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allFluidTypes.add(type);
                    fluidToIdMap.put(type, id);
                    idToFluidMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("fluid")) continue;
                try {
                    AbstractFluidType type = new AbstractFluidType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allFluidTypes.add(type);
                    fluidToIdMap.put(type, id);
                    idToFluidMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = FluidType.class.getFields()) {
            if (!AbstractFluidType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractFluidType ct = (AbstractFluidType)f.get(null);
                fluidToIdMap.put(ct, f.getName());
                idToFluidMap.put(f.getName(), ct);
                allFluidTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        typesMap = new HashMap<AbstractRace, List<AbstractFluidType>>();
    }
}

