/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractHairType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HairType {
    public static AbstractHairType HUMAN;
    public static AbstractHairType ANGEL;
    public static AbstractHairType DEMON;
    public static AbstractHairType DOG_MORPH;
    public static AbstractHairType WOLF_MORPH;
    public static AbstractHairType FOX_MORPH;
    public static AbstractHairType CAT_MORPH;
    public static AbstractHairType CAT_MORPH_SIDEFLUFF;
    public static AbstractHairType COW_MORPH;
    public static AbstractHairType ALLIGATOR_MORPH;
    public static AbstractHairType SQUIRREL_MORPH;
    public static AbstractHairType RAT_MORPH;
    public static AbstractHairType RABBIT_MORPH;
    public static AbstractHairType BAT_MORPH;
    public static AbstractHairType HORSE_MORPH;
    public static AbstractHairType REINDEER_MORPH;
    public static AbstractHairType HARPY;
    private static List<AbstractHairType> allHairTypes;
    private static Map<AbstractHairType, String> hairToIdMap;
    private static Map<String, AbstractHairType> idToHairMap;
    private static Map<AbstractRace, List<AbstractHairType>> typesMap;

    public static AbstractHairType getHairTypeFromId(String id) {
        if (id.equals("IMP") || id.equals("DEMON_COMMON")) {
            return DEMON;
        }
        if (id.equals("LYCAN")) {
            return WOLF_MORPH;
        }
        id = Util.getClosestStringMatch(id, idToHairMap.keySet());
        return idToHairMap.get(id);
    }

    public static String getIdFromHairType(AbstractHairType hairType) {
        return hairToIdMap.get(hairType);
    }

    public static List<AbstractHairType> getAllHairTypes() {
        return allHairTypes;
    }

    public static List<AbstractHairType> getHairTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractHairType> types = new ArrayList<AbstractHairType>();
        for (AbstractHairType type : HairType.getAllHairTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        typesMap.put(r, types);
        return types;
    }

    static {
        Field[] fieldArray;
        HUMAN = new AbstractHairType(BodyCoveringType.HAIR_HUMAN, Race.HUMAN, "\u4eba\u7c7b", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues(""), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u4eba\u7c7b\u6837\u5b50\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldHuman(\u4eba\u7c7b\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer][npc.hairColour(true)]\u7684\u4eba\u7c7b[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        ANGEL = new AbstractHairType(BodyCoveringType.HAIR_ANGEL, Race.ANGEL, "\u5929\u4f7f", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues(""), Util.newArrayListOfValues("\u4e1d\u7ef8\u822c", "\u67d4\u8f6f", "\u9634\u67d4"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u5929\u4f7f\u6837\u5b50\u7684\u67d4\u987a\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldAngel(\u5929\u4f7f\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer][npc.hairColour(true)]\u7684\u5929\u4f7f[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        DEMON = new AbstractHairType(BodyCoveringType.HAIR_DEMON, Race.DEMON, "\u6076\u9b54", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues(""), Util.newArrayListOfValues("\u4e1d\u7ef8\u822c", "\u67d4\u8f6f", "\u9634\u67d4"), "#IF(npc.isShortStature())\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u5c0f\u6076\u9b54\u6837\u5b50\u7684\u67d4\u987a\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldImp(\u5c0f\u6076\u9b54\u5934\u53d1)]\u3002#ELSE\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u6076\u9b54\u6837\u5b50\u7684\u67d4\u987a\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldDemon(\u6076\u9b54\u5934\u53d1)]\u3002#ENDIF", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer][npc.hairColour(true)]\u7684#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        DOG_MORPH = new AbstractHairType(BodyCoveringType.HAIR_CANINE_FUR, Race.DOG_MORPH, "\u72ac", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u76ae\u6bdb\u822c\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldDogMorph(\u72ac\u4e00\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u72ac\u4e00\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        WOLF_MORPH = new AbstractHairType(BodyCoveringType.HAIR_LYCAN_FUR, Race.WOLF_MORPH, "\u72fc", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u76ae\u6bdb\u822c\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldWolfMorph(\u72fc\u4e00\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u72fc\u4e00\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){

            @Override
            public boolean isNeckFluffRequiresGreater() {
                return true;
            }

            @Override
            public double getNeckFluffChance() {
                return 0.25;
            }
        };
        FOX_MORPH = new AbstractHairType(BodyCoveringType.HAIR_FOX_FUR, Race.FOX_MORPH, "\u72d0\u72f8", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u76ae\u6bdb\u822c\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldFoxMorph(\u72d0\u72f8\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u72d0\u72f8\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){

            @Override
            public boolean isNeckFluffRequiresGreater() {
                return true;
            }

            @Override
            public double getNeckFluffChance() {
                return 0.25;
            }
        };
        CAT_MORPH = new AbstractHairType(BodyCoveringType.HAIR_FELINE_FUR, Race.CAT_MORPH, "\u732b", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u76ae\u6bdb\u822c\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldCatMorph(\u732b\u4e00\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u732b\u4e00\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        CAT_MORPH_SIDEFLUFF = new AbstractHairType(BodyCoveringType.HAIR_FELINE_FUR, Race.CAT_MORPH, "\u732b(\u8138\u988a\u7ed2)", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u76ae\u6bdb\u822c\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldCatMorph(\u732b\u4e00\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u732b\u4e00\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1\uff0c\u5728\u9762\u988a\u4e24\u8fb9\u8fd8\u6709\u6bdb\u8338\u8338\u7684\u67d4\u8f6f\u76ae\u6bdb", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        COW_MORPH = new AbstractHairType(BodyCoveringType.HAIR_BOVINE_FUR, Race.COW_MORPH, "\u725b", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u76ae\u6bdb\u822c\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldCowMorph(\u725b\u4e00\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u725b\u4e00\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        ALLIGATOR_MORPH = new AbstractHairType(BodyCoveringType.HAIR_SCALES_ALLIGATOR, Race.ALLIGATOR_MORPH, "\u9cc4\u9c7c", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u7c97\u7cd9"), Util.newArrayListOfValues("\u7c97\u7cd9"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u9cc4\u9c7c\u6837\u5b50\u7684\u7c97\u7cd9\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldAlligatorMorph(\u9cc4\u9c7c\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u9cc4\u9c7c\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        SQUIRREL_MORPH = new AbstractHairType(BodyCoveringType.HAIR_SQUIRREL_FUR, Race.SQUIRREL_MORPH, "\u677e\u9f20", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u76ae\u6bdb\u822c\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldSquirrelMorph(\u677e\u9f20\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u677e\u9f20\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        RAT_MORPH = new AbstractHairType(BodyCoveringType.HAIR_RAT_FUR, Race.RAT_MORPH, "\u8001\u9f20", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u76ae\u6bdb\u822c\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldRatMorph(\u8001\u9f20\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u8001\u9f20\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        RABBIT_MORPH = new AbstractHairType(BodyCoveringType.HAIR_RABBIT_FUR, Race.RABBIT_MORPH, "\u5154\u5b50", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u76ae\u6bdb\u822c\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldRabbitMorph(\u5154\u5b50\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u5154\u5b50\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        BAT_MORPH = new AbstractHairType(BodyCoveringType.HAIR_BAT_FUR, Race.BAT_MORPH, "\u8759\u8760", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u76ae\u6bdb\u822c\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldBatMorph(\u8759\u8760\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u8759\u8760\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        HORSE_MORPH = new AbstractHairType(BodyCoveringType.HAIR_HORSE_HAIR, Race.HORSE_MORPH, "\u9a6c", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u76ae\u6bdb\u822c\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldHorseMorph(\u9a6c\u4e00\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u9a6c\u4e00\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX, BodyPartTag.HAIR_NATURAL_MANE)){};
        REINDEER_MORPH = new AbstractHairType(BodyCoveringType.HAIR_REINDEER_FUR, Race.REINDEER_MORPH, "\u9a6f\u9e7f", "\u5934\u53d1", "\u5934\u53d1", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u76ae\u6bdb\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u4fbf\u5f97\u5230\u4e86\u76ae\u6bdb\u822c\u7684\u5934\u53d1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldReindeerMorph(\u9a6f\u9e7f\u822c\u7684\u5934\u53d1)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u9a6f\u9e7f\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u53d1", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){};
        HARPY = new AbstractHairType(BodyCoveringType.HAIR_HARPY, Race.HARPY, "\u54c8\u6bd4", "\u51a0\u7fbd", "\u51a0\u7fbd", Util.newArrayListOfValues("\u4f18\u7f8e", "\u9e1f\u4e00\u822c"), Util.newArrayListOfValues("\u4f18\u7f8e", "\u9e1f\u4e00\u822c"), "\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u5934\u53d1\u539f\u672c\u7684\u4f4d\u7f6e\u4fbf\u5f97\u5230\u4e86\u4e00\u7c07\u51a0\u7fbd\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hairColour]\u7684[style.boldHarpy(\u54c8\u6bd4\u7fbd\u6bdb)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.hairDeterminer]\u9e1f\u4e00\u822c[npc.hairColour(true)]\u7684[npc.hairLength]\u51a0\u7fbd", Util.newArrayListOfValues(BodyPartTag.HAIR_HANDLES_IN_SEX)){

            @Override
            public boolean isDefaultPlural(GameCharacter gc) {
                return true;
            }

            @Override
            public String getDeterminer(GameCharacter gc) {
                return "\u4e00\u7c07";
            }
        };
        hairToIdMap = new HashMap<AbstractHairType, String>();
        idToHairMap = new HashMap<String, AbstractHairType>();
        allHairTypes = new ArrayList<AbstractHairType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("hair")) continue;
                try {
                    AbstractHairType type = new AbstractHairType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allHairTypes.add(type);
                    hairToIdMap.put(type, id);
                    idToHairMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("hair")) continue;
                try {
                    AbstractHairType type = new AbstractHairType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allHairTypes.add(type);
                    hairToIdMap.put(type, id);
                    idToHairMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = HairType.class.getFields()) {
            if (!AbstractHairType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractHairType ct = (AbstractHairType)f.get(null);
                hairToIdMap.put(ct, f.getName());
                idToHairMap.put(f.getName(), ct);
                allHairTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allHairTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractHairType>>();
    }
}

