/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.body.abstractTypes.AbstractHornType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HornType {
    public static final AbstractHornType NONE;
    public static final AbstractHornType REINDEER_RACK;
    public static final AbstractHornType HORSE_STRAIGHT;
    public static final AbstractHornType ANTLERS;
    public static final AbstractHornType CURLED;
    public static final AbstractHornType SPIRAL;
    public static final AbstractHornType CURVED;
    public static final AbstractHornType SWEPT_BACK;
    public static final AbstractHornType STRAIGHT;
    private static List<AbstractHornType> allHornTypes;
    private static Map<AbstractHornType, String> hornToIdMap;
    private static Map<String, AbstractHornType> idToHornMap;
    private static Map<AbstractRace, List<AbstractHornType>> typesMap;

    public static AbstractHornType getHornTypeFromId(String id) {
        if (id.equals("BOVINE_CURVED")) {
            return CURVED;
        }
        if (id.equals("BOVINE_STRAIGHT")) {
            return STRAIGHT;
        }
        id = Util.getClosestStringMatch(id, idToHornMap.keySet());
        return idToHornMap.get(id);
    }

    public static String getIdFromHornType(AbstractHornType hornType) {
        return hornToIdMap.get(hornType);
    }

    public static List<AbstractHornType> getAllHornTypes() {
        return allHornTypes;
    }

    public static List<AbstractHornType> getHornTypes(AbstractRace race, boolean retainNone) {
        if (!typesMap.containsKey(race)) {
            ArrayList<AbstractHornType> allTypes = new ArrayList<AbstractHornType>();
            for (AbstractHornType type : HornType.getAllHornTypes()) {
                if (type.getRace() != race) continue;
                allTypes.add(type);
            }
            if (allTypes.isEmpty()) {
                allTypes.add(NONE);
                for (AbstractHornType type : HornType.getAllHornTypes()) {
                    if (!type.isGeneric()) continue;
                    allTypes.add(type);
                }
            }
            typesMap.put(race, allTypes);
        }
        ArrayList<AbstractHornType> types = new ArrayList<AbstractHornType>((Collection)typesMap.get(race));
        if (!retainNone) {
            types.remove(NONE);
        }
        return types;
    }

    static {
        Field[] fieldArray;
        NONE = new AbstractHornType(BodyCoveringType.HORN, Race.NONE, 2, "\u65e0", "\u89d2", "\u89d2", (List)new ArrayList(), (List)new ArrayList(), "<br/>[npc.Name]\u73b0\u5728[style.boldTfGeneric(\u6ca1\u6709\u89d2)]\u3002", ""){};
        REINDEER_RACK = new AbstractHornType(BodyCoveringType.ANTLER, Race.REINDEER_MORPH, 2, "\u5206\u6748", "\u9e7f\u89d2", "\u9e7f\u89d2", Util.newArrayListOfValues("\u5206\u6748", "\u9a6f\u9e7f"), Util.newArrayListOfValues("\u5206\u6748", "\u9a6f\u9e7f"), "\u591a\u5206\u6748\u7684[npc.horn]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hornsDeterminer][style.boldTfGeneric(\u9a6f\u9e7f\u822c\u7684#IFnpc.getTotalHorns()==1#THEN[npc.horn]#ELSE[npc.horns]#ENDIF)]\u3002", "[npc.HornsDeterminer]\u5448[npc.hornColour(true)]\uff0c\u591a\u5206\u6748\u4e14[npc.hornSize]\u7684[npc.horn]\u4ece[npc.her]\u7684\u524d\u989d#IFnpc.getHornsPerRow()==1#THEN\u4e2d\u95f4#ELSE\u9876\u7aef#ENDIF\u751f\u957f\u51fa\u6765\u3002"){};
        HORSE_STRAIGHT = new AbstractHornType(BodyCoveringType.HORN, Race.HORSE_MORPH, 1, "\u72ec\u89d2", "\u89d2", "\u89d2", Util.newArrayListOfValues("\u7ad6\u76f4", "\u87ba\u65cb", "\u72ec"), Util.newArrayListOfValues("\u7ad6\u76f4", "\u87ba\u65cb", "\u72ec"), "\u7ad6\u76f4\u5411\u4e0a\uff0c\u5e26\u87ba\u65cb\u7eb9\u7684\u72ec[npc.horn]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hornsDeterminer][style.boldTfGeneric(\u72ec[npc.horn])]\u3002", "[npc.HornsDeterminer]\u5448[npc.hornColour(true)]\uff0c[npc.hornSize]\u7684\u72ec[npc.horns]\u4ece[npc.her]\u7684\u524d\u989d#IFnpc.getHornsPerRow()==1#THEN\u4e2d\u95f4#ELSE\u9876\u7aef#ENDIF\u751f\u957f\u51fa\u6765\u3002"){};
        ANTLERS = new AbstractHornType(BodyCoveringType.ANTLER, Race.NONE, 2, "\u5206\u6748", "\u9e7f\u89d2", "\u9e7f\u89d2", Util.newArrayListOfValues("\u5206\u6748"), Util.newArrayListOfValues("\u5206\u6748"), "\u591a\u5206\u6748\u7684[npc.horn]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hornsDeterminer][style.boldTfGeneric(\u5206\u6748\u7684[npc.horn])]\u3002", "[npc.HornsDeterminer]\u5448[npc.hornColour(true)]\uff0c\u5206\u6748\u4e14[npc.hornSize]\u7684[npc.horn]\u4ece[npc.her]\u7684\u524d\u989d#IFnpc.getHornsPerRow()==1#THEN\u4e2d\u95f4#ELSE\u9876\u7aef#ENDIF\u751f\u957f\u51fa\u6765\u3002"){

            @Override
            public boolean isGeneric() {
                return true;
            }
        };
        CURLED = new AbstractHornType(BodyCoveringType.HORN, Race.NONE, 2, "\u76d8\u7ed5", "\u89d2", "\u89d2", Util.newArrayListOfValues("\u76d8\u7ed5"), Util.newArrayListOfValues("\u76d8\u7ed5", "\u5149\u6ed1"), "\u76d8\u7ed5\u7684[npc.horn]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hornsDeterminer][style.boldTfGeneric(\u76d8\u7ed5\u7684[npc.horn])]\u3002", "[npc.HornsDeterminer]\u5448[npc.hornColour(true)]\uff0c\u76d8\u7ed5\u4e14[npc.hornSize]\u7684[npc.horn]\u4ece[npc.her]\u7684\u524d\u989d#IFnpc.getHornsPerRow()==1#THEN\u4e2d\u95f4#ELSE\u9876\u7aef#ENDIF\u751f\u957f\u51fa\u6765\u3002"){

            @Override
            public boolean isGeneric() {
                return true;
            }
        };
        SPIRAL = new AbstractHornType(BodyCoveringType.HORN, Race.NONE, 2, "\u87ba\u65cb\u72b6", "\u89d2", "\u89d2", Util.newArrayListOfValues("\u87ba\u65cb\u72b6"), Util.newArrayListOfValues("\u87ba\u65cb\u72b6", "\u5149\u6ed1"), "\u66f2\u6298\u87ba\u65cb\u7684[npc.horn]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hornsDeterminer][style.boldTfGeneric(\u87ba\u65cb\u72b6\u7684#IFnpc.getTotalHorns()==1#THEN[npc.horn]#ELSE[npc.horns]#ENDIF)]\u3002", "[npc.HornsDeterminer]\u5448[npc.hornColour(true)]\uff0c\u87ba\u65cb\u72b6\u4e14[npc.hornSize]\u7684[npc.horn]\u4ece[npc.her]\u7684\u524d\u989d#IFnpc.getHornsPerRow()==1#THEN\u4e2d\u95f4#ELSE\u9876\u7aef#ENDIF\u751f\u957f\u51fa\u6765\u3002"){

            @Override
            public boolean isGeneric() {
                return true;
            }
        };
        CURVED = new AbstractHornType(BodyCoveringType.HORN, Race.NONE, 2, "\u5f2f\u66f2", "\u89d2", "\u89d2", Util.newArrayListOfValues("\u5f2f\u66f2"), Util.newArrayListOfValues("\u5f2f\u66f2", "\u5149\u6ed1"), "\u7565\u5fae\u5f2f\u66f2\u7684[npc.horn]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(\u5f2f\u66f2\u7684#IFnpc.getTotalHorns()==1#THEN[npc.horn]#ELSE[npc.horns]#ENDIF)]\u3002", "[npc.HornsDeterminer]\u5448[npc.hornColour(true)]\uff0c\u5f2f\u66f2\u4e14[npc.hornSize]\u7684[npc.horn]\u4ece[npc.her]\u7684\u524d\u989d#IFnpc.getHornsPerRow()==1#THEN\u4e2d\u95f4#ELSE\u9876\u7aef#ENDIF\u751f\u957f\u51fa\u6765\u3002"){

            @Override
            public boolean isGeneric() {
                return true;
            }
        };
        SWEPT_BACK = new AbstractHornType(BodyCoveringType.HORN, Race.NONE, 2, "\u53cd\u6298", "\u89d2", "\u89d2", Util.newArrayListOfValues("\u53cd\u6298"), Util.newArrayListOfValues("\u53cd\u6298", "\u5149\u6ed1"), "\u5149\u6ed1\u7684[npc.horn]\uff0c\u4e0a\u7aef\u5411\u540e\u5f2f\u6298\uff0c\u63a0\u8fc7\u5934\u9876\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hornsDeterminer][style.boldTfGeneric(\u53cd\u6298\u7684#IFnpc.getTotalHorns()==1#THEN[npc.horn]#ELSE[npc.horns]#ENDIF)]\u3002", "[npc.HornsDeterminer]\u5448[npc.hornColour(true)]\uff0c\u53cd\u6298\u7684[npc.hornSize]\u7684[npc.horn]\u4ece[npc.her]\u7684\u524d\u989d#IFnpc.getHornsPerRow()==1#THEN\u4e2d\u95f4#ELSE\u9876\u7aef#ENDIF\u751f\u957f\u51fa\u6765\u3002"){

            @Override
            public boolean isGeneric() {
                return true;
            }
        };
        STRAIGHT = new AbstractHornType(BodyCoveringType.HORN, Race.NONE, 2, "\u7ad6\u76f4", "\u89d2", "\u89d2", Util.newArrayListOfValues("\u7ad6\u76f4"), Util.newArrayListOfValues("\u7ad6\u76f4", "\u5149\u6ed1"), "\u5341\u5206\u5149\u6ed1\uff0c\u7ad6\u76f4\u5411\u4e0a\u7684[npc.horn]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.hornsDeterminer][style.boldTfGeneric(\u7ad6\u76f4\u5411\u4e0a\u7684#IFnpc.getTotalHorns()==1#THEN[npc.horn]#ELSE[npc.horns]#ENDIF)]\u3002", "[npc.HornsDeterminer]\u5448[npc.hornColour(true)]\uff0c\u7ad6\u76f4\u5411\u4e0a\u7684[npc.hornSize]\u7684[npc.horn]\u4ece[npc.her]\u7684\u524d\u989d#IFnpc.getHornsPerRow()==1#THEN\u4e2d\u95f4#ELSE\u9876\u7aef#ENDIF\u751f\u957f\u51fa\u6765\u3002"){

            @Override
            public boolean isGeneric() {
                return true;
            }
        };
        hornToIdMap = new HashMap<AbstractHornType, String>();
        idToHornMap = new HashMap<String, AbstractHornType>();
        allHornTypes = new ArrayList<AbstractHornType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("horn")) continue;
                try {
                    AbstractHornType type = new AbstractHornType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allHornTypes.add(type);
                    hornToIdMap.put(type, id);
                    idToHornMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("horn")) continue;
                try {
                    AbstractHornType type = new AbstractHornType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allHornTypes.add(type);
                    hornToIdMap.put(type, id);
                    idToHornMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = HornType.class.getFields()) {
            if (!AbstractHornType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractHornType ct = (AbstractHornType)f.get(null);
                hornToIdMap.put(ct, f.getName());
                idToHornMap.put(f.getName(), ct);
                allHornTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allHornTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractHornType>>();
    }
}

