/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractLegType;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractTentacleType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.FootType;
import com.lilithsthrone.game.character.body.types.TentacleType;
import com.lilithsthrone.game.character.body.valueEnums.FootStructure;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LegType {
    public static AbstractLegType HUMAN;
    public static AbstractLegType ANGEL;
    public static AbstractLegType DEMON_COMMON;
    public static AbstractLegType DEMON_HOOFED;
    public static AbstractLegType DEMON_HORSE_HOOFED;
    public static AbstractLegType DEMON_SNAKE;
    public static AbstractLegType DEMON_SPIDER;
    public static AbstractLegType DEMON_OCTOPUS;
    public static AbstractLegType DEMON_FISH;
    public static AbstractLegType DEMON_EAGLE;
    public static AbstractLegType COW_MORPH;
    public static AbstractLegType DOG_MORPH;
    public static AbstractLegType WOLF_MORPH;
    public static AbstractLegType FOX_MORPH;
    public static AbstractLegType SQUIRREL_MORPH;
    public static AbstractLegType RAT_MORPH;
    public static AbstractLegType RABBIT_MORPH;
    public static AbstractLegType BAT_MORPH;
    public static AbstractLegType CAT_MORPH;
    public static AbstractLegType ALLIGATOR_MORPH;
    public static AbstractLegType HORSE_MORPH;
    public static AbstractLegType REINDEER_MORPH;
    public static AbstractLegType HARPY;
    private static List<AbstractLegType> allLegTypes;
    private static Map<AbstractLegType, String> legToIdMap;
    private static Map<String, AbstractLegType> idToLegMap;
    private static Map<AbstractRace, List<AbstractLegType>> typesMap;

    public static AbstractLegType getLegTypeFromId(String id) {
        if (id.equals("IMP")) {
            return DEMON_COMMON;
        }
        if (id.equals("LYCAN")) {
            return WOLF_MORPH;
        }
        id = Util.getClosestStringMatch(id, idToLegMap.keySet());
        return idToLegMap.get(id);
    }

    public static String getIdFromLegType(AbstractLegType legType) {
        return legToIdMap.get(legType);
    }

    public static List<AbstractLegType> getAllLegTypes() {
        return allLegTypes;
    }

    public static List<AbstractLegType> getLegTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractLegType> types = new ArrayList<AbstractLegType>();
        for (AbstractLegType type : LegType.getAllLegTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        typesMap.put(r, types);
        return types;
    }

    static {
        Field[] fieldArray;
        HUMAN = new AbstractLegType(BodyCoveringType.HUMAN, Race.HUMAN, FootStructure.PLANTIGRADE, FootType.HUMANOID, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a"), Util.newArrayListOfValues("\u9634\u67d4"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u8fc5\u901f\u8f6c\u5316\u4e3a\u4e86\u6b63\u5e38\u7684\u4eba\u7c7b\u817f\u90e8\uff0c\u8fd8\u5e26\u7740\u4eba\u7c7b\u7684\u811a\u3002<br/>[npc.She]\u73b0\u5728\u6709\u7740[style.boldHuman(\u4eba\u7c7b\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f\u548c\u811a\u662f\u4eba\u7c7b\u5f62\u6001\uff0c[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL), false){};
        ANGEL = new AbstractLegType(BodyCoveringType.ANGEL, Race.ANGEL, FootStructure.PLANTIGRADE, FootType.HUMANOID, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u7ea2\u6da6", "\u5929\u4f7f"), Util.newArrayListOfValues("\u9634\u67d4", "\u7ea2\u6da6", "\u5929\u4f7f"), Util.newArrayListOfValues("\u5929\u4f7f"), Util.newArrayListOfValues("\u5929\u4f7f"), Util.newArrayListOfValues("\u5929\u4f7f"), Util.newArrayListOfValues("\u5929\u4f7f"), "\u8fc5\u901f\u8f6c\u5316\u4e3a\u4e86\u4e00\u53cc\u5149\u6ed1\u3001\u7ea4\u7ec6\u7684\u817f\uff0c\u65e0\u6687\u7684\u5929\u4f7f\u76ae\u80a4\u8fc5\u901f\u8986\u76d6\u5176\u4e0a\uff0c[npc.she]\u4e0d\u7981\u60ca\u53f9\u4e00\u58f0\u3002\u8fd9\u90e8\u5206\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.her]\u811a\u4e0a\u7684\u9aa8\u5934\u4e5f\u5f00\u59cb\u53d8\u5f62\u91cd\u6784\uff0c\u5bb3\u5f97[npc.she]\u5dee\u70b9\u5931\u53bb\u5e73\u8861\u3002\u8fc7\u4e86\u4e00\u6bb5\u65f6\u95f4\uff0c\u4fbf\u5316\u6210\u50cf\u4eba\u4e00\u6837\u7ea4\u7ec6\u7684\u811a\uff0c\u811a\u8dbe\u67d4\u8f6f\u4e14\u7ec6\u817b\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldAngel(\u5929\u4f7f\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f\u548c\u811a\u5f62\u72b6\u4e0a\u4e0e\u4eba\u7c7b\u65e0\u5f02\uff0c\u4f46[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL), false){};
        DEMON_COMMON = new AbstractLegType(BodyCoveringType.DEMON_COMMON, Race.DEMON, FootStructure.PLANTIGRADE, FootType.HUMANOID, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u6076\u9b54"), Util.newArrayListOfValues("\u9634\u67d4", "\u65e0\u6687", "\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), "-", "[npc.Her]\u7684\u817f\u548c\u811a\u5f62\u72b6\u4e0a\u4e0e\u4eba\u7c7b\u65e0\u5f02\uff0c\u4f46[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL), false){

            @Override
            public String getTransformationDescription(GameCharacter owner) {
                if (!owner.isShortStature()) {
                    return UtilText.parse(owner, "\u8fc5\u901f\u8f6c\u5316\u4e3a\u4e86\u4e00\u53cc\u5149\u6ed1\u3001\u7ea4\u7ec6\u7684\u817f\uff0c\u65e0\u6687\u7684\u6076\u9b54\u76ae\u80a4\u8fc5\u901f\u8986\u76d6\u5176\u4e0a\uff0c[npc.she]\u4e0d\u7981\u60ca\u53f9\u4e00\u58f0\u3002\u8fd9\u90e8\u5206\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.her]\u811a\u4e0a\u7684\u9aa8\u5934\u4e5f\u5f00\u59cb\u53d8\u5f62\u91cd\u6784\uff0c\u5bb3\u5f97[npc.she]\u5dee\u70b9\u5931\u53bb\u5e73\u8861\u3002\u8fc7\u4e86\u4e00\u6bb5\u65f6\u95f4\uff0c\u4fbf\u5316\u6210\u50cf\u4eba\u4e00\u6837\u7ea4\u7ec6\u7684\u811a\uff0c\u811a\u8dbe\u67d4\u8f6f\u4e14\u7ec6\u817b\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldDemon(\u6076\u9b54\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "\u8fc5\u901f\u8f6c\u5316\u4e3a\u4e86\u4e00\u53cc\u5149\u6ed1\u3001\u7ea4\u7ec6\u7684\u817f\uff0c\u65e0\u6687\u7684\u5c0f\u6076\u9b54\u76ae\u80a4\u8fc5\u901f\u8986\u76d6\u5176\u4e0a\uff0c[npc.she]\u4e0d\u7981\u60ca\u53f9\u4e00\u58f0\u3002\u8fd9\u90e8\u5206\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.her]\u811a\u4e0a\u7684\u9aa8\u5934\u4e5f\u5f00\u59cb\u53d8\u5f62\u91cd\u6784\uff0c\u5bb3\u5f97[npc.she]\u5dee\u70b9\u5931\u53bb\u5e73\u8861\u3002\u8fc7\u4e86\u4e00\u6bb5\u65f6\u95f4\uff0c\u4fbf\u5316\u6210\u50cf\u4eba\u4e00\u6837\u7ea4\u7ec6\u7684\u811a\uff0c\u811a\u8dbe\u67d4\u8f6f\u4e14\u7ec6\u817b\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldImp(\u5c0f\u6076\u9b54\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002</p>", new ParserTag[0]);
            }
        };
        DEMON_HOOFED = new AbstractLegType(BodyCoveringType.DEMON_COMMON, Race.DEMON, FootStructure.UNGULIGRADE, FootType.HOOFS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u6076\u9b54"), Util.newArrayListOfValues("\u9634\u67d4", "\u65e0\u6687", "\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), "-", "[npc.Her]\u6076\u9b54\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u786c\u8d28\u7684\u8e44\u5b50\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL), false){

            @Override
            public String getTransformationDescription(GameCharacter owner) {
                if (!owner.isShortStature()) {
                    return UtilText.parse(owner, "\u8fc5\u901f\u8f6c\u5316\u4e3a\u4e86\u4e00\u53cc\u5149\u6ed1\u3001\u7ea4\u7ec6\u7684\u817f\uff0c\u65e0\u6687\u7684\u6076\u9b54\u76ae\u80a4\u8fc5\u901f\u8986\u76d6\u5176\u4e0a\uff0c[npc.she]\u4e0d\u7981\u60ca\u53f9\u4e00\u58f0\u3002\u65b0\u751f\u7684\u76ae\u80a4\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c[npc.she]\u5ffd\u7136\u5927\u53eb\u4e00\u58f0\uff0c\u539f\u6765\u662f\u811a\u8dbe\u5e76\u5728\u4e86\u4e00\u8d77\uff0c\u4e00\u5757\u539a\u5b9e\u7684\u8e44\u5b50\u822c\u7684\u6307\u7532\u5728\u539f\u5904\u751f\u957f\u51fa\u6765\uff0c\u8fc5\u901f\u5c06[npc.her]\u7684\u811a\u8f6c\u5316\u4e3a\u786c\u8d28\u7684\u6076\u9b54\u8e44\u5b50\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u80a4\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.NameIsFull]\u6709\u7740[style.boldDemon(\u6076\u9b54\u7684\u817f\u548c\u8e44\u72b6\u7684\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "\u8fc5\u901f\u8f6c\u5316\u4e3a\u4e86\u4e00\u53cc\u5149\u6ed1\u3001\u7ea4\u7ec6\u7684\u817f\uff0c\u65e0\u6687\u7684\u5c0f\u6076\u9b54\u76ae\u80a4\u8fc5\u901f\u8986\u76d6\u5176\u4e0a\uff0c[npc.she]\u4e0d\u7981\u60ca\u53f9\u4e00\u58f0\u3002\u65b0\u751f\u7684\u76ae\u80a4\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c[npc.she]\u5ffd\u7136\u5927\u53eb\u4e00\u58f0\uff0c\u539f\u6765\u662f\u811a\u8dbe\u5e76\u5728\u4e86\u4e00\u8d77\uff0c\u4e00\u5757\u539a\u5b9e\u7684\u8e44\u5b50\u822c\u7684\u6307\u7532\u5728\u539f\u5904\u751f\u957f\u51fa\u6765\uff0c\u8fc5\u901f\u5c06[npc.her]\u7684\u811a\u8f6c\u5316\u4e3a\u786c\u8d28\u7684\u6076\u9b54\u8e44\u5b50\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u80a4\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldImp(\u5c0f\u6076\u9b54\u7684\u817f\u548c\u8e44\u72b6\u7684\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002</p>", new ParserTag[0]);
            }

            @Override
            public String getTransformName() {
                return "\u6076\u9b54\u8e44";
            }
        };
        DEMON_HORSE_HOOFED = new AbstractLegType(BodyCoveringType.HORSE_HAIR, Race.DEMON, FootStructure.UNGULIGRADE, FootType.HOOFS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u8986\u76d6\u6bdb\u53d1", "\u6076\u9b54\u9a6c\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u8986\u76d6\u6bdb\u53d1", "\u6076\u9b54\u9a6c\u822c"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), "-", "[npc.Her]\u6076\u9b54\u5316\u9a6c\u4e00\u822c\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u786c\u8d28\u7684\u8e44\u5b50\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.QUADRUPEDAL), false){

            @Override
            public String getTransformationDescription(GameCharacter owner) {
                return UtilText.parse(owner, "\u5728[npc.her]\u7684\u6076\u9b54\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u9a6c\u4e00\u822c\u7684\u7c97\u77ed\u6bdb\u53d1\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u6bdb\u53d1\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c[npc.her]\u5ffd\u7136\u5927\u53eb\u4e00\u58f0\uff0c\u539f\u6765\u662f\u811a\u8dbe\u5e76\u5728\u4e86\u4e00\u8d77\uff0c\u4e00\u5757\u539a\u5b9e\u7684\u8e44\u5b50\u822c\u7684\u6307\u7532\u5728\u539f\u5904\u751f\u957f\u51fa\u6765\uff0c\u8fc5\u901f\u5c06[npc.her]\u7684\u811a\u8f6c\u5316\u4e3a\u786c\u8d28\u7684\u6076\u9b54\u8e44\u5b50\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u6bdb\u53d1\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709" + (!owner.isShortStature() ? "[style.boldDemon(\u6076\u9b54\u5316\u52a8\u7269\u822c\u7684\u817f\u548c\u8e44\u72b6\u7684\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002" : "[style.boldImp(\u5c0f\u6076\u9b54\u5316\u52a8\u7269\u822c\u7684\u817f\u548c\u8e44\u72b6\u7684\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002"), new ParserTag[0]);
            }

            @Override
            public String getTransformName() {
                return "\u6076\u9b54\u9a6c";
            }
        };
        DEMON_SNAKE = new AbstractLegType(BodyCoveringType.SNAKE_SCALES, Race.DEMON, FootStructure.NONE, FootType.NONE, "\u4e00\u6761", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u9633\u521a", "\u9cde\u7247\u8986\u76d6", "\u6076\u9b54\u86c7"), Util.newArrayListOfValues("\u9634\u67d4", "\u9cde\u7247\u8986\u76d6", "\u6076\u9b54\u86c7"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), "-", "[npc.Her]\u6076\u9b54\u5316\u86c7\u4e00\u822c\u7684\u4e0b\u80a2[npc.materialCompositionDescriptor][npc.legFullDescription(true)]", Util.newArrayListOfValues(LegConfiguration.TAIL_LONG), false){

            @Override
            public boolean isDefaultPlural(GameCharacter gc) {
                return false;
            }

            @Override
            public String getTransformationDescription(GameCharacter owner) {
                return UtilText.parse(owner, "\u5728[npc.her]\u7684\u6076\u9b54\u817f\u8f6c\u53d8\u86c7\u7684\u6837\u8c8c\u65f6\uff0c\u4e00\u5c42\u5149\u6ed1\u7684\u9cde\u7247\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u8f6c\u5316\u5f88\u5feb\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.Name]\u5927\u817f\u5904\u65b0\u751f\u7684\u9cde\u7247\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709" + (!owner.isShortStature() ? "[style.boldDemon(\u6076\u9b54\u5316\u86c7\u4e00\u822c\u7684\u817f)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002" : "[style.boldImp(\u5c0f\u6076\u9b54\u5316\u86c7\u4e00\u822c\u7684\u817f)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002"), new ParserTag[0]);
            }

            @Override
            public String getTransformName() {
                return "\u6076\u9b54\u86c7";
            }

            @Override
            public boolean isAvailableForSelfTransformMenu(GameCharacter gc) {
                return gc.hasPerkAnywhereInTree(Perk.POWER_OF_LYXIAS_6);
            }
        };
        DEMON_SPIDER = new AbstractLegType(BodyCoveringType.SPIDER_CHITIN, Race.DEMON, FootStructure.DIGITIGRADE, FootType.ARACHNID, "\u4e00\u6761", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u86db\u5f62", "\u6076\u9b54\u86db"), Util.newArrayListOfValues("\u9634\u67d4", "\u86db\u5f62", "\u6076\u9b54\u86db"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), "-", "[npc.Her]\u6076\u9b54\u5316\u8718\u86db\u822c\u7684\u4e0b\u80a2[npc.materialCompositionDescriptor][npc.legFullDescription(true)]", Util.newArrayListOfValues(LegConfiguration.ARACHNID), true){

            @Override
            public String getTransformationDescription(GameCharacter owner) {
                return UtilText.parse(owner, "\u5728[npc.her]\u7684\u6076\u9b54\u817f\u8f6c\u53d8\u4e3a\u8718\u86db\u6837\u8c8c\u65f6\uff0c\u4e00\u5c42\u5149\u6ed1\u7684\u51e0\u4e01\u8d28\u5916\u58f3\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u8f6c\u5316\u5f88\u5feb\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.Name]\u5927\u817f\u5904\u65b0\u751f\u7684\u5149\u6ed1\u51e0\u4e01\u8d28\u5916\u58f3\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709" + (!owner.isShortStature() ? "[style.boldDemon(\u6076\u9b54\u5316\u8718\u86db\u822c\u7684\u817f)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002" : "[style.boldImp(\u5c0f\u6076\u9b54\u5316\u8718\u86db\u822c\u7684\u817f)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002"), new ParserTag[0]);
            }

            @Override
            public String getTransformName() {
                return "\u6076\u9b54\u86db";
            }

            @Override
            public boolean isAvailableForSelfTransformMenu(GameCharacter gc) {
                return gc.hasPerkAnywhereInTree(Perk.POWER_OF_LUNETTE_5);
            }
        };
        DEMON_OCTOPUS = new AbstractLegType(BodyCoveringType.OCTOPUS_SKIN, Race.DEMON, FootStructure.TENTACLED, FootType.TENTACLE, "\u4e00\u6839", "\u89e6\u624b", "\u89e6\u624b", Util.newArrayListOfValues("\u9633\u521a", "\u5934\u8db3\u7c7b", "\u6076\u9b54\u7ae0\u9c7c"), Util.newArrayListOfValues("\u9634\u67d4", "\u5934\u8db3\u7c7b", "\u6076\u9b54\u7ae0\u9c7c"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), "-", "[npc.Her]\u6076\u9b54\u5316\u7ae0\u9c7c\u822c\u7684\u4e0b\u80a2[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\u3002", Util.newArrayListOfValues(LegConfiguration.CEPHALOPOD), false){

            @Override
            public String getTransformationDescription(GameCharacter owner) {
                return UtilText.parse(owner, "\u5728[npc.her]\u7684\u6076\u9b54\u817f\u8f6c\u53d8\u4e3a\u89e6\u624b\u72b6\u6837\u8c8c\u65f6\uff0c\u4e00\u5c42\u5149\u6ed1\u7684\u76ae\u80a4\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u8f6c\u5316\u5f88\u5feb\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.Name]\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u80a4\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709" + (!owner.isShortStature() ? "[style.boldDemon(\u6076\u9b54\u5316\u7ae0\u9c7c\u822c\u7684\u817f)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002" : "[style.boldImp(\u5c0f\u6076\u9b54\u5316\u7ae0\u9c7c\u822c\u7684\u817f)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002"), new ParserTag[0]);
            }

            @Override
            public String getTransformName() {
                return "\u6076\u9b54\u7ae0\u9c7c";
            }

            @Override
            public AbstractTentacleType getTentacleType() {
                return TentacleType.LEG_DEMON_OCTOPUS;
            }

            @Override
            public int getTentacleCount() {
                return 8;
            }

            @Override
            public boolean isAvailableForSelfTransformMenu(GameCharacter gc) {
                return gc.hasPerkAnywhereInTree(Perk.POWER_OF_LIRECEA_1);
            }
        };
        DEMON_FISH = new AbstractLegType(BodyCoveringType.FISH_SCALES, Race.DEMON, FootStructure.NONE, FootType.NONE, "\u4e00\u6761", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u9633\u521a", "\u9cde\u7247\u8986\u76d6", "\u6076\u9b54\u9c7c"), Util.newArrayListOfValues("\u9634\u67d4", "\u9cde\u7247\u8986\u76d6", "\u6076\u9b54\u9c7c"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), "-", "[npc.Her]\u6076\u9b54\u5316\u9c7c\u4e00\u822c\u7684\u4e0b\u80a2[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\u3002", Util.newArrayListOfValues(LegConfiguration.TAIL), false){

            @Override
            public boolean isDefaultPlural(GameCharacter gc) {
                return gc.hasStatusEffect(StatusEffect.AQUATIC_NEGATIVE);
            }

            @Override
            public String getNameSingular(GameCharacter gc) {
                if (gc.hasStatusEffect(StatusEffect.AQUATIC_NEGATIVE)) {
                    return "\u817f";
                }
                return "\u5c3e\u5df4";
            }

            @Override
            public String getNamePlural(GameCharacter gc) {
                if (gc.hasStatusEffect(StatusEffect.AQUATIC_NEGATIVE)) {
                    return "\u817f";
                }
                return "\u5c3e\u5df4";
            }

            @Override
            public String getTransformationDescription(GameCharacter owner) {
                return UtilText.parse(owner, "\u5728[npc.her]\u7684\u6076\u9b54\u817f\u8f6c\u53d8\u4e3a\u9c7c\u7684\u6837\u8c8c\u65f6\uff0c\u5149\u6ed1\u7684\u9cde\u7247\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u8f6c\u5316\u5f88\u5feb\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.Name]\u5927\u817f\u5904\u65b0\u751f\u7684\u9cde\u7247\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709" + (!owner.isShortStature() ? "[style.boldDemon(\u6076\u9b54\u5316\u9c7c\u4e00\u822c\u7684\u817f)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002" : "[style.boldImp(\u5c0f\u6076\u9b54\u5316\u9c7c\u4e00\u822c\u7684\u817f)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002"), new ParserTag[0]);
            }

            @Override
            public String getTransformName() {
                return "\u6076\u9b54\u9c7c";
            }

            @Override
            public boolean isAvailableForSelfTransformMenu(GameCharacter gc) {
                return gc.hasPerkAnywhereInTree(Perk.POWER_OF_LIRECEA_1);
            }
        };
        DEMON_EAGLE = new AbstractLegType(BodyCoveringType.FEATHERS, Race.DEMON, FootStructure.DIGITIGRADE, FootType.TALONS, "\u4e00\u6761", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u5e26\u722a", "\u9e1f\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u5e26\u722a", "\u9e1f\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), "-", "[npc.Her]\u6076\u9b54\u5316\u9e1f\u4e00\u822c\u7684\u4e0b\u80a2[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\u3002", Util.newArrayListOfValues(LegConfiguration.AVIAN), false){

            @Override
            public String getTransformationDescription(GameCharacter owner) {
                return UtilText.parse(owner, "\u5728[npc.her]\u7684\u6076\u9b54\u817f\u8f6c\u53d8\u4e3a\u9e1f\u7684\u6837\u8c8c\u65f6\uff0c\u4e00\u5c42\u7fbd\u6bdb\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u8f6c\u5316\u5f88\u5feb\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.Name]\u5927\u817f\u5904\u65b0\u751f\u7684\u7fbd\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709" + (!owner.isShortStature() ? "[style.boldDemon(\u6076\u9b54\u5316\u9e1f\u4e00\u822c\u7684\u817f)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002" : "[style.boldImp(\u5c0f\u6076\u9b54\u5316\u9e1f\u4e00\u822c\u7684\u817f)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002"), new ParserTag[0]);
            }

            @Override
            public String getTransformName() {
                return "\u6076\u9b54\u9e70";
            }

            @Override
            public boolean isAvailableForSelfTransformMenu(GameCharacter gc) {
                return gc.hasPerkAnywhereInTree(Perk.POWER_OF_LISOPHIA_7);
            }
        };
        COW_MORPH = new AbstractLegType(BodyCoveringType.BOVINE_FUR, Race.COW_MORPH, FootStructure.UNGULIGRADE, FootType.HOOFS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u8e44\u72b6", "\u6bdb\u8338\u8338", "\u8986\u76d6\u6bdb\u76ae", "\u725b\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u8e44\u72b6", "\u6bdb\u8338\u8338", "\u8986\u76d6\u6bdb\u76ae", "\u725b\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u725b\u4e00\u822c", "\u725b\u7c7b"), Util.newArrayListOfValues("\u725b\u4e00\u822c", "\u725b\u7c7b"), Util.newArrayListOfValues("\u725b\u4e00\u822c", "\u725b\u7c7b"), Util.newArrayListOfValues("\u725b\u4e00\u822c", "\u725b\u7c7b"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u725b\u4e00\u822c\u7684\u7c97\u77ed\u6bdb\u53d1\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u6bdb\u76ae\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c[npc.she]\u5ffd\u7136\u5927\u53eb\u4e00\u58f0\uff0c\u539f\u6765\u662f\u811a\u8dbe\u5e76\u5728\u4e86\u4e00\u8d77\uff0c\u4e00\u5757\u539a\u5b9e\u7684\u8e44\u5b50\u822c\u7684\u6307\u7532\u5728\u539f\u5904\u751f\u957f\u51fa\u6765\uff0c\u8fc5\u901f\u5c06[npc.her]\u7684\u811a\u8f6c\u5316\u4e3a\u725b\u4e00\u822c\u7684\u786c\u8d28\u8e44\u5b50\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldCowMorph(\u725b\u4e00\u822c\u7684\u817f\u548c\u8e44\u72b6\u7684\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u62df\u4eba\u7684\u725b\u8e44\u5b50\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.QUADRUPEDAL), false){};
        DOG_MORPH = new AbstractLegType(BodyCoveringType.CANINE_FUR, Race.DOG_MORPH, FootStructure.DIGITIGRADE, FootType.PAWS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u6bdb\u8338\u8338", "\u8986\u76d6\u6bdb\u76ae", "\u72ac\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u6bdb\u76ae", "\u72ac\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u72ac\u4e00\u822c", "\u72ac\u7c7b"), Util.newArrayListOfValues("\u72ac\u4e00\u822c", "\u72ac\u7c7b"), Util.newArrayListOfValues("\u72ac\u4e00\u822c", "\u72ac\u7c7b"), Util.newArrayListOfValues("\u72ac\u4e00\u822c", "\u72ac\u7c7b"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u4e00\u5c42\u72ac\u4e00\u822c\u7684\u76ae\u6bdb\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u6bdb\u76ae\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c\u6307\u7532\u589e\u539a\u53d8\u6210\u4e86\u5706\u949d\u7684\u5c0f\u722a\u5b50\uff0c\u76ae\u8d28\u7684\u8089\u57ab\u8986\u76d6\u4e86\u811a\u638c\uff0c\u7ed9[npc.herHim]\u7559\u4e0b\u4e86\u811a\u722a\u822c\u7684\u811a\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldDogMorph(\u72ac\u4e00\u822c\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u62df\u4eba\u7684\u72ac\u811a\u722a\uff0c\u957f\u7740\u5706\u949d\u7684\u5c0f\u722a\u5b50\u548c\u76ae\u8d28\u7684\u8089\u57ab\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.QUADRUPEDAL), false){};
        WOLF_MORPH = new AbstractLegType(BodyCoveringType.LYCAN_FUR, Race.WOLF_MORPH, FootStructure.DIGITIGRADE, FootType.PAWS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u6bdb\u8338\u8338", "\u8986\u76d6\u6bdb\u76ae", "\u72fc\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u72fc\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u72fc\u4e00\u822c", "\u72fc\u7c7b"), Util.newArrayListOfValues("\u72fc\u4e00\u822c", "\u72fc\u7c7b"), Util.newArrayListOfValues("\u72fc\u4e00\u822c", "\u72fc\u7c7b"), Util.newArrayListOfValues("\u72fc\u4e00\u822c", "\u72fc\u7c7b"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u4e00\u5c42\u72fc\u4e00\u822c\u7684\u76ae\u6bdb\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u6bdb\u76ae\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c\u6307\u7532\u589e\u539a\u53d8\u6210\u4e86\u950b\u5229\u7684\u722a\u5b50\uff0c\u7c97\u7cd9\u7684\u76ae\u8d28\u8089\u57ab\u8986\u76d6\u4e86\u811a\u638c\uff0c\u7ed9[npc.herHim]\u7559\u4e0b\u4e86\u811a\u722a\u822c\u7684\u811a\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldWolfMorph(\u72fc\u4e00\u822c\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u62df\u4eba\u7684\u72fc\u811a\u722a\uff0c\u957f\u7740\u950b\u5229\u7684\u722a\u5b50\u548c\u76ae\u8d28\u7684\u8089\u57ab\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.QUADRUPEDAL), false){};
        FOX_MORPH = new AbstractLegType(BodyCoveringType.FOX_FUR, Race.FOX_MORPH, FootStructure.DIGITIGRADE, FootType.PAWS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u6bdb\u8338\u8338", "\u8986\u76d6\u6bdb\u76ae", "\u72d0\u72f8\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u72d0\u72f8\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u72d0\u72f8\u822c", "\u72d0\u7c7b"), Util.newArrayListOfValues("\u72d0\u72f8\u822c", "\u72d0\u7c7b"), Util.newArrayListOfValues("\u72d0\u72f8\u822c", "\u72d0\u7c7b"), Util.newArrayListOfValues("\u72d0\u72f8\u822c", "\u72d0\u7c7b"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u4e00\u5c42\u72d0\u72f8\u822c\u7684\u76ae\u6bdb\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u6bdb\u76ae\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c\u6307\u7532\u589e\u539a\u53d8\u6210\u4e86\u950b\u5229\u7684\u722a\u5b50\uff0c\u5c0f\u5de7\u7684\u8089\u57ab\u8986\u76d6\u4e86\u811a\u638c\uff0c\u7ed9[npc.herHim]\u7559\u4e0b\u4e86\u811a\u722a\u822c\u7684\u811a\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002</br>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldFoxMorph(\u72d0\u72f8\u822c\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u62df\u4eba\u7684\u72d0\u72f8\u811a\u722a\uff0c\u957f\u7740\u950b\u5229\u7684\u722a\u5b50\u548c\u5c0f\u5de7\u7684\u8089\u57ab\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.QUADRUPEDAL), false){};
        SQUIRREL_MORPH = new AbstractLegType(BodyCoveringType.SQUIRREL_FUR, Race.SQUIRREL_MORPH, FootStructure.PLANTIGRADE, FootType.PAWS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u6bdb\u8338\u8338", "\u8986\u76d6\u6bdb\u76ae", "\u677e\u9f20\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u677e\u9f20\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u677e\u9f20\u822c"), Util.newArrayListOfValues("\u677e\u9f20\u822c"), Util.newArrayListOfValues("\u677e\u9f20\u822c"), Util.newArrayListOfValues("\u677e\u9f20\u822c"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u4e00\u5c42\u677e\u9f20\u822c\u7684\u76ae\u6bdb\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u6bdb\u76ae\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c\u6307\u7532\u589e\u539a\u53d8\u6210\u4e86\u950b\u5229\u7684\u722a\u5b50\uff0c\u5c0f\u5de7\u7684\u7c89\u8272\u8089\u57ab\u8986\u76d6\u4e86\u811a\u638c\uff0c\u7ed9[npc.herHim]\u7559\u4e0b\u4e86\u811a\u722a\u822c\u7684\u811a\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldSquirrelMorph(\u677e\u9f20\u822c\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u62df\u4eba\u7684\u677e\u9f20\u811a\u722a\uff0c\u957f\u7740\u722a\u5b50\u548c\u7c89\u8272\u7684\u8089\u57ab\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.QUADRUPEDAL), false){};
        RAT_MORPH = new AbstractLegType(BodyCoveringType.RAT_FUR, Race.RAT_MORPH, FootStructure.PLANTIGRADE, FootType.PAWS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u6bdb\u8338\u8338", "\u8986\u76d6\u6bdb\u76ae", "\u8001\u9f20\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u8001\u9f20\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u8001\u9f20\u822c"), Util.newArrayListOfValues("\u8001\u9f20\u822c"), Util.newArrayListOfValues("\u8001\u9f20\u822c"), Util.newArrayListOfValues("\u8001\u9f20\u822c"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u4e00\u5c42\u8001\u9f20\u822c\u7684\u76ae\u6bdb\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u6bdb\u76ae\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c\u6307\u7532\u589e\u539a\u53d8\u6210\u4e86\u950b\u5229\u7684\u722a\u5b50\uff0c\u5c0f\u5de7\u7684\u7c89\u8272\u8089\u57ab\u8986\u76d6\u4e86\u811a\u638c\uff0c\u7ed9[npc.herHim]\u7559\u4e0b\u4e86\u811a\u722a\u822c\u7684\u811a\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldRatMorph(\u8001\u9f20\u822c\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u62df\u4eba\u7684\u8001\u9f20\u811a\u722a\uff0c\u957f\u7740\u722a\u5b50\u548c\u7c89\u8272\u7684\u8089\u57ab\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.QUADRUPEDAL), false){};
        RABBIT_MORPH = new AbstractLegType(BodyCoveringType.RABBIT_FUR, Race.RABBIT_MORPH, FootStructure.PLANTIGRADE, FootType.PAWS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u6bdb\u8338\u8338", "\u8986\u76d6\u6bdb\u76ae", "\u5154\u5b50\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u5154\u5b50\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u5154\u5b50\u822c"), Util.newArrayListOfValues("\u5154\u5b50\u822c"), Util.newArrayListOfValues("\u5154\u5b50\u822c"), Util.newArrayListOfValues("\u5154\u5b50\u822c"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u4e00\u5c42\u5154\u5b50\u822c\u7684\u76ae\u6bdb\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u6bdb\u76ae\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c\u6307\u7532\u589e\u539a\u53d8\u6210\u4e86\u5706\u949d\u7684\u722a\u5b50\uff0c\u5c0f\u5de7\u67d4\u8f6f\u7684\u8089\u57ab\u8986\u76d6\u4e86\u811a\u638c\uff0c\u7ed9[npc.herHim]\u7559\u4e0b\u4e86\u811a\u722a\u822c\u7684\u811a\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldRabbitMorph(\u5154\u822c\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u62df\u4eba\u7684\u5154\u5b50\u811a\u722a\uff0c\u957f\u7740\u5706\u949d\u7684\u722a\u5b50\u548c\u67d4\u8f6f\u7684\u8089\u57ab\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.QUADRUPEDAL), false){};
        BAT_MORPH = new AbstractLegType(BodyCoveringType.BAT_FUR, Race.BAT_MORPH, FootStructure.DIGITIGRADE, FootType.PAWS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u6bdb\u8338\u8338", "\u8986\u76d6\u6bdb\u76ae", "\u8759\u8760\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u8759\u8760\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u8759\u8760\u822c"), Util.newArrayListOfValues("\u8759\u8760\u822c"), Util.newArrayListOfValues("\u8759\u8760\u822c"), Util.newArrayListOfValues("\u8759\u8760\u822c"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u4e00\u5c42\u8759\u8760\u822c\u7684\u76ae\u6bdb\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u6bdb\u76ae\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c\u6307\u7532\u589e\u539a\u53d8\u6210\u4e86\u950b\u5229\u7684\u722a\u5b50\uff0c\u5c0f\u5de7\u7684\u7c89\u8272\u8089\u57ab\u8986\u76d6\u4e86\u811a\u638c\uff0c\u7ed9[npc.herHim]\u7559\u4e0b\u4e86\u811a\u722a\u822c\u7684\u811a\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldBatMorph(\u8759\u8760\u822c\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u62df\u4eba\u7684\u8759\u8760\u811a\u722a\uff0c\u957f\u7740\u722a\u5b50\u548c\u7c89\u8272\u7684\u8089\u57ab\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL), false){};
        CAT_MORPH = new AbstractLegType(BodyCoveringType.FELINE_FUR, Race.CAT_MORPH, FootStructure.DIGITIGRADE, FootType.PAWS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u6bdb\u8338\u8338", "\u8986\u76d6\u6bdb\u76ae", "\u732b\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u732b\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u732b\u4e00\u822c", "\u732b\u7c7b"), Util.newArrayListOfValues("\u732b\u4e00\u822c", "\u732b\u7c7b"), Util.newArrayListOfValues("\u732b\u4e00\u822c", "\u732b\u7c7b"), Util.newArrayListOfValues("\u732b\u4e00\u822c", "\u732b\u7c7b"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u4e00\u5c42\u732b\u4e00\u822c\u7684\u76ae\u6bdb\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u6bdb\u76ae\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c\u6307\u7532\u589e\u539a\u53d8\u6210\u4e86\u53ef\u6536\u7f29\u7684\u950b\u5229\u722a\u5b50\uff0c\u5c0f\u5de7\u7684\u7c89\u8272\u8089\u57ab\u8986\u76d6\u4e86\u811a\u638c\uff0c\u7ed9[npc.herHim]\u7559\u4e0b\u4e86\u811a\u722a\u822c\u7684\u811a\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldCatMorph(\u732b\u4e00\u822c\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u62df\u4eba\u7684\u732b\u811a\u722a\uff0c\u957f\u7740\u53ef\u6536\u7f29\u7684\u722a\u5b50\u548c\u7c89\u8272\u7684\u8089\u57ab\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.QUADRUPEDAL), false){};
        ALLIGATOR_MORPH = new AbstractLegType(BodyCoveringType.ALLIGATOR_SCALES, Race.ALLIGATOR_MORPH, FootStructure.PLANTIGRADE, FootType.HUMANOID, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u8986\u76d6\u9cde\u7247", "\u722c\u884c\u7c7b", "\u9cc4\u9c7c\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u8986\u76d6\u9cde\u7247", "\u722c\u884c\u7c7b", "\u9cc4\u9c7c\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9cc4\u9c7c\u822c", "\u8986\u76d6\u9cde\u7247", "\u722c\u884c\u7c7b"), Util.newArrayListOfValues("\u9cc4\u9c7c\u822c", "\u8986\u76d6\u9cde\u7247", "\u722c\u884c\u7c7b"), Util.newArrayListOfValues("\u9cc4\u9c7c\u822c", "\u8986\u76d6\u9cde\u7247", "\u722c\u884c\u7c7b"), Util.newArrayListOfValues("\u9cc4\u9c7c\u822c", "\u8986\u76d6\u9cde\u7247", "\u722c\u884c\u7c7b"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u4e00\u5c42\u9cc4\u9c7c\u822c\u7684\u9cde\u7247\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u6bdb\u76ae\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c\u6307\u7532\u589e\u539a\u53d8\u6210\u4e86\u950b\u5229\u7684\u722a\u5b50\uff0c\u7ec6\u5c0f\u7684\u9cde\u7247\u8986\u76d6\u4e86\u811a\u638c\uff0c\u7ed9[npc.herHim]\u7559\u4e0b\u9cc4\u9c7c\u822c\u7684\u811a\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u9cde\u7247\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldGatorMorph(\u9cc4\u9c7c\u822c\u7684\u817f\u548c\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u9cc4\u9c7c\u822c\u62df\u4eba\u7684\u811a\uff0c\u957f\u7740\u950b\u5229\u7684\u722a\u5b50\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.QUADRUPEDAL), false){};
        HORSE_MORPH = new AbstractLegType(BodyCoveringType.HORSE_HAIR, Race.HORSE_MORPH, FootStructure.UNGULIGRADE, FootType.HOOFS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u8986\u76d6\u6bdb\u53d1", "\u9a6c\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u8986\u76d6\u6bdb\u53d1", "\u9a6c\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9a6c\u4e00\u822c", "\u9a6c\u7c7b"), Util.newArrayListOfValues("\u9a6c\u4e00\u822c", "\u9a6c\u7c7b"), Util.newArrayListOfValues("\u9a6c\u4e00\u822c", "\u9a6c\u7c7b"), Util.newArrayListOfValues("\u9a6c\u4e00\u822c", "\u9a6c\u7c7b"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u9a6c\u4e00\u822c\u7684\u7c97\u77ed\u6bdb\u53d1\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u6bdb\u76ae\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c[npc.she]\u5ffd\u7136\u5927\u53eb\u4e00\u58f0\uff0c\u539f\u6765\u662f\u811a\u8dbe\u5e76\u5728\u4e86\u4e00\u8d77\uff0c\u4e00\u5757\u539a\u5b9e\u7684\u8e44\u5b50\u822c\u7684\u6307\u7532\u5728\u539f\u5904\u751f\u957f\u51fa\u6765\uff0c\u8fc5\u901f\u5c06[npc.her]\u7684\u811a\u8f6c\u5316\u4e3a\u9a6c\u4e00\u822c\u7684\u786c\u8d28\u8e44\u5b50\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u6bdb\u53d1\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldHorseMorph(\u9a6c\u4e00\u822c\u7684\u817f\u548c\u8e44\u72b6\u7684\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u62df\u4eba\u7684\u9a6c\u8e44\u5b50\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.QUADRUPEDAL), false){};
        REINDEER_MORPH = new AbstractLegType(BodyCoveringType.REINDEER_FUR, Race.REINDEER_MORPH, FootStructure.UNGULIGRADE, FootType.HOOFS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u8986\u76d6\u6bdb\u76ae", "\u9a6f\u9e7f\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u8986\u76d6\u6bdb\u76ae", "\u9a6f\u9e7f\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9a6f\u9e7f\u822c"), Util.newArrayListOfValues("\u9a6f\u9e7f\u822c"), Util.newArrayListOfValues("\u9a6f\u9e7f\u822c"), Util.newArrayListOfValues("\u9a6f\u9e7f\u822c"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u9a6f\u9e7f\u822c\u6bdb\u8338\u8338\u7684\u6bdb\u53d1\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u6bdb\u76ae\u4e00\u76f4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c[npc.she]\u5ffd\u7136\u5927\u53eb\u4e00\u58f0\uff0c\u539f\u6765\u662f\u811a\u8dbe\u5e76\u5728\u4e86\u4e00\u8d77\uff0c\u4e00\u5757\u65b0\u6708\u5f62\u5206\u6210\u4e24\u74e3\u7684\u8e44\u5b50\u5728\u539f\u5904\u751f\u957f\u51fa\u6765\uff0c\u8fc5\u901f\u5c06[npc.her]\u7684\u811a\u8f6c\u5316\u4e3a\u9a6f\u9e7f\u822c\u7684\u8e44\u5b50\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldReindeerMorph(\u9a6f\u9e7f\u822c\u7684\u817f\u548c\u8e44\u72b6\u7684\u811a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u811a\u5374\u53d8\u6210\u4e86\u62df\u4eba\u7684\u9a6f\u9e7f\u8e44\u5b50\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.QUADRUPEDAL), false){};
        HARPY = new AbstractLegType(BodyCoveringType.HARPY_SKIN, Race.HARPY, FootStructure.DIGITIGRADE, FootType.TALONS, "\u4e00\u53cc", "\u817f", "\u817f", Util.newArrayListOfValues("\u9633\u521a", "\u5e26\u722a", "\u9e1f\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9634\u67d4", "\u5e26\u722a", "\u9e1f\u4e00\u822c\u62df\u4eba"), Util.newArrayListOfValues("\u9e1f\u4e00\u822c"), Util.newArrayListOfValues("\u9e1f\u4e00\u822c"), Util.newArrayListOfValues("\u9e1f\u4e00\u822c"), Util.newArrayListOfValues("\u9e1f\u4e00\u822c"), "\u5728[npc.her]\u7684\u817f\u8f6c\u53d8\u5f62\u6001\u65f6\uff0c\u9e1f\u4e00\u822c\u7684\u7c97\u7cd9\u76ae\u80a4\u8fc5\u901f\u751f\u957f\u4e8e\u5176\u4e0a\u3002\u65b0\u751f\u7684\u76ae\u8d28\u76ae\u80a4\u5ef6\u4f38\u5230\u811a\u8dbe\uff0c\u800c[npc.her]\u7684\u811a\u5219\u6b63\u5728\u7ecf\u5386\u5de8\u53d8\u3002[npc.Her]\u7684\u811a\u8dbe\u805a\u5408\u5728\u4e00\u8d77\uff0c\u91cd\u65b0\u5316\u6210\u4e86\u4e09\u6839\u5411\u524d\u7684\u9e1f\u722a\uff0c\u800c\u7b2c\u56db\u6839\u62c7\u6307\u6837\u7684\u5229\u722a\u5219\u4f4d\u4e8e\u540e\u65b9\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u817f\u5904\u65b0\u751f\u7684\u76ae\u8d28\u76ae\u80a4\u8fc5\u901f\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4eba\u5f62\u7684[style.boldHarpy(\u9e1f\u4e00\u822c\u7684\u817f\u548c\u66ff\u4ee3\u4e86\u811a\u7684\u5229\u722a)]\uff0c[npc.materialDescriptor][npc.legFullDescription]\u3002", "[npc.Her]\u9e1f\u4e00\u822c\u7684\u817f[npc.materialCompositionDescriptor][npc.legFullDescription(true)]\uff0c\u81ea\u5927\u817f\u5904\u8fc5\u901f\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002\u5728\u6bcf\u6761[npc.legs]\u7684\u672b\u7aef\uff0c\u90fd\u6709\u7740\u9e1f\u4e00\u822c\u950b\u5229\u7684\u5229\u722a\u3002", Util.newArrayListOfValues(LegConfiguration.BIPEDAL, LegConfiguration.AVIAN), false){};
        legToIdMap = new HashMap<AbstractLegType, String>();
        idToLegMap = new HashMap<String, AbstractLegType>();
        allLegTypes = new ArrayList<AbstractLegType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("leg")) continue;
                try {
                    AbstractLegType type = new AbstractLegType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allLegTypes.add(type);
                    legToIdMap.put(type, id);
                    idToLegMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("leg")) continue;
                try {
                    AbstractLegType type = new AbstractLegType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allLegTypes.add(type);
                    legToIdMap.put(type, id);
                    idToLegMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = LegType.class.getFields()) {
            if (!AbstractLegType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractLegType ct = (AbstractLegType)f.get(null);
                legToIdMap.put(ct, f.getName());
                idToLegMap.put(f.getName(), ct);
                allLegTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allLegTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractLegType>>();
    }
}

