/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.valueEnums.Capacity;
import com.lilithsthrone.game.character.body.valueEnums.OrificeDepth;
import com.lilithsthrone.game.character.body.valueEnums.OrificeElasticity;
import com.lilithsthrone.game.character.body.valueEnums.OrificeModifier;
import com.lilithsthrone.game.character.body.valueEnums.OrificePlasticity;
import com.lilithsthrone.game.character.body.valueEnums.Wetness;

public interface OrificeInterface {
    public Wetness getWetness(GameCharacter var1);

    public String setWetness(GameCharacter var1, int var2);

    public Capacity getCapacity();

    public float getRawCapacityValue();

    public String setCapacity(GameCharacter var1, float var2, boolean var3);

    public float getStretchedCapacity();

    public boolean setStretchedCapacity(float var1);

    default public OrificeDepth getMinimumDepthForSizeComfortable(GameCharacter owner, int insertionSize) {
        OrificeDepth depth = OrificeDepth.ONE_SHALLOW;
        while (this.getMaximumPenetrationDepthComfortable(owner, depth) < insertionSize) {
            if (depth == OrificeDepth.SEVEN_FATHOMLESS) {
                return depth;
            }
            depth = OrificeDepth.getDepthFromInt(depth.getValue() + 1);
        }
        return depth;
    }

    default public OrificeDepth getMinimumDepthForSizeUncomfortable(GameCharacter owner, int insertionSize) {
        OrificeDepth depth = OrificeDepth.ONE_SHALLOW;
        while (this.getMaximumPenetrationDepthUncomfortable(owner, depth) < insertionSize) {
            if (depth == OrificeDepth.SEVEN_FATHOMLESS) {
                return depth;
            }
            depth = OrificeDepth.getDepthFromInt(depth.getValue() + 1);
        }
        return depth;
    }

    default public int getMaximumPenetrationDepthComfortable(GameCharacter owner) {
        return this.getMaximumPenetrationDepthComfortable(owner, this.getDepth(owner));
    }

    public int getMaximumPenetrationDepthComfortable(GameCharacter var1, OrificeDepth var2);

    default public int getMaximumPenetrationDepthUncomfortable(GameCharacter owner) {
        return this.getMaximumPenetrationDepthUncomfortable(owner, this.getDepth(owner));
    }

    public int getMaximumPenetrationDepthUncomfortable(GameCharacter var1, OrificeDepth var2);

    public OrificeDepth getDepth(GameCharacter var1);

    public String setDepth(GameCharacter var1, int var2);

    public OrificeElasticity getElasticity();

    public String setElasticity(GameCharacter var1, int var2);

    public OrificePlasticity getPlasticity();

    public String setPlasticity(GameCharacter var1, int var2);

    public boolean isVirgin();

    public void setVirgin(boolean var1);

    public boolean hasOrificeModifier(OrificeModifier var1);

    public String addOrificeModifier(GameCharacter var1, OrificeModifier var2);

    public String removeOrificeModifier(GameCharacter var1, OrificeModifier var2);
}

