/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.body.abstractTypes.AbstractTentacleType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.valueEnums.PenetrationGirth;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TentacleType {
    public static final AbstractTentacleType NONE;
    public static final AbstractTentacleType DEMON_COMMON;
    public static final AbstractTentacleType LEG_DEMON_OCTOPUS;
    private static List<AbstractTentacleType> allTentacleTypes;
    private static Map<AbstractTentacleType, String> tentacleToIdMap;
    private static Map<String, AbstractTentacleType> idToTentacleMap;
    private static Map<AbstractRace, List<AbstractTentacleType>> typesMap;

    public static AbstractTentacleType getTentacleTypeFromId(String id) {
        id = Util.getClosestStringMatch(id, idToTentacleMap.keySet());
        return idToTentacleMap.get(id);
    }

    public static String getIdFromTentacleType(AbstractTentacleType tentacleType) {
        return tentacleToIdMap.get(tentacleType);
    }

    public static List<AbstractTentacleType> getAllTentacleTypes() {
        return allTentacleTypes;
    }

    public static List<AbstractTentacleType> getTentacleTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractTentacleType> types = new ArrayList<AbstractTentacleType>();
        for (AbstractTentacleType type : TentacleType.getAllTentacleTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        if (types.isEmpty()) {
            types.add(NONE);
        }
        typesMap.put(r, types);
        return types;
    }

    public static List<AbstractTentacleType> getTentacleTypesSuitableForTransformation(List<AbstractTentacleType> options) {
        if (!options.contains(NONE)) {
            return options;
        }
        ArrayList<AbstractTentacleType> duplicatedOptions = new ArrayList<AbstractTentacleType>(options);
        duplicatedOptions.remove(NONE);
        return duplicatedOptions;
    }

    static {
        Field[] fieldArray;
        NONE = new AbstractTentacleType(null, Race.NONE, PenetrationGirth.THREE_AVERAGE, 0.0f, "\u65e0", "", "", "\u89e6\u624b", "\u89e6\u624b", Util.newArrayListOfValues(new String[0]), Util.newArrayListOfValues(new String[0]), "", "", Util.newArrayListOfValues(new String[0]), Util.newArrayListOfValues(new String[0]), "#IF(npc.getTentacleCount()==1)\u5f53[npc.She]\u611f\u5230[npc.tentacle]\u9010\u6e10\u7f29\u5c0f\uff0c\u5e76\u6d88\u5931\u5728[npc.her]\u4f53\u5185\u65f6\uff0c[npc.She]\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\u3002#ELSE\u5f53[npc.She]\u611f\u5230[npc.tentacle]\u9010\u6e10\u7f29\u5c0f\uff0c\u5e76\u6d88\u5931\u5728[npc.her]\u4f53\u5185\u65f6\uff0c[npc.She]\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\u3002#ENDIF<br/>[npc.Name]\u73b0\u5728[style.boldTfGeneric(\u6ca1\u6709\u89e6\u624b)]\u3002", "[style.colourDisabled([npc.She]\u6ca1\u6709\u89e6\u624b\u3002)]", Util.newArrayListOfValues(new BodyPartTag[0])){};
        DEMON_COMMON = new AbstractTentacleType(BodyCoveringType.DEMON_COMMON, Race.DEMON, PenetrationGirth.ONE_SLENDER, 1.0f, "\u6076\u9b54", "", "", "\u89e6\u624b", "\u89e6\u624b", Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), "\u5c16\u7aef", "\u5c3e\u5c16", Util.newArrayListOfValues("\u5706\u6da6"), Util.newArrayListOfValues("\u5706\u6da6"), "#IF(npc.getTentacleCount()==1)\u4e00\u6761\u6076\u9b54\u89e6\u624b\u4ece\u80cc\u90e8\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tentacleLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u968f\u5fc3\u6240\u6b32\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u4eff\u4f5b\u62e5\u6709\u4e86\u989d\u5916\u7684\u80a2\u4f53\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709#IF(npc.isShortStature())\u4e00\u6761[style.boldImp(\u5c0f\u6076\u9b54\u89e6\u624b)]#ELSE\u4e00\u6761[style.boldDemon(\u6076\u9b54\u89e6\u624b)]#ENDIF\uff0c[npc.materialDescriptor][npc.tentacleFullDescription(true)]\u3002#ELSE[npc.TentacleCount]\u6761\u6076\u9b54\u89e6\u624b\u4ece\u80cc\u90e8\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tentacleLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230[npc.she]\u80fd\u591f\u968f\u5fc3\u6240\u6b32\u5730\u63a7\u5236\u5b83\u4eec\uff0c\u5c31\u50cf\u62e5\u6709\u4e86\u989d\u5916\u7684\u80a2\u4f53\u4e00\u6837\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tentacleCount]\u6761#IF(npc.isShortStature())[style.boldImp(\u5c0f\u6076\u9b54\u89e6\u624b)]#ELSE[style.boldDemon(\u6076\u9b54\u89e6\u624b)]#ENDIF\uff0c[npc.materialDescriptor][npc.tentacleFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u80cc\u90e8\u957f\u51fa#IF(npc.getTentacleCount()==1)\u4e00\u6761\u6843\u5fc3\u72b6\u7684[npc.tentacleColour(true)]#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u89e6\u624b\u3002[npc.sheHasFull]\u80fd\u81ea\u5982\u5730\u638c\u63a7\u5176\u8fd0\u52a8\uff0c\u5e2e\u52a9[npc.herHim]\u6293\u63e1\u7269\u4f53\u3002#ELSE[npc.sheHasFull]\u62e5\u6709[npc.tentacleCount]\u6761\u6843\u5fc3\u72b6\u7684\uff0c[npc.tentacleColour(true)]#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u89e6\u624b\u3002\u5b83\u4eec\u6d3b\u52a8\u81ea\u5982\uff0c\u80fd\u591f\u5e2e\u52a9[npc.herHim]\u6293\u53d6\u5e76\u63e1\u4f4f\u7269\u4f53\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_PREHENSILE, BodyPartTag.TAIL_SUITABLE_FOR_PENETRATION, BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TAPERING_NONE)){};
        LEG_DEMON_OCTOPUS = new AbstractTentacleType(BodyCoveringType.OCTOPUS_SKIN, Race.DEMON, PenetrationGirth.FOUR_GIRTHY, 2.5f, "\u6076\u9b54\u7ae0\u9c7c", "", "", "\u89e6\u624b", "\u89e6\u624b", Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), "\u5c3e\u5c16", "\u5c3e\u5c16", Util.newArrayListOfValues("\u5706\u6da6"), Util.newArrayListOfValues("\u5706\u6da6"), "", "\u5728\u817f\u7684\u4f4d\u7f6e\u4e0a\uff0c[npc.sheHasFull]\u957f\u51fa\u4e86[npc.tentacleCount]\u6761[npc.tentacleColour(true)]\uff0c\u7ae0\u9c7c\u4e00\u6837\u7684\u89e6\u624b\u3002\u5b83\u4eec\u6d3b\u52a8\u81ea\u5982\uff0c\u80fd\u591f\u5e2e\u52a9[npc.herHim]\u6293\u53d6\u5e76\u63e1\u4f4f\u7269\u4f53\u3002", Util.newArrayListOfValues(BodyPartTag.TAIL_PREHENSILE, BodyPartTag.TAIL_SUITABLE_FOR_PENETRATION, BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TAPERING_NONE)){};
        tentacleToIdMap = new HashMap<AbstractTentacleType, String>();
        idToTentacleMap = new HashMap<String, AbstractTentacleType>();
        allTentacleTypes = new ArrayList<AbstractTentacleType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("tentacle")) continue;
                try {
                    AbstractTentacleType type = new AbstractTentacleType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allTentacleTypes.add(type);
                    tentacleToIdMap.put(type, id);
                    idToTentacleMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("tentacle")) continue;
                try {
                    AbstractTentacleType type = new AbstractTentacleType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allTentacleTypes.add(type);
                    tentacleToIdMap.put(type, id);
                    idToTentacleMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = TentacleType.class.getFields()) {
            if (!AbstractTentacleType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractTentacleType ct = (AbstractTentacleType)f.get(null);
                tentacleToIdMap.put(ct, f.getName());
                idToTentacleMap.put(f.getName(), ct);
                allTentacleTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allTentacleTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractTentacleType>>();
    }
}

