/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.body.abstractTypes.AbstractWingType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WingType {
    public static final AbstractWingType NONE;
    public static final AbstractWingType ANGEL;
    public static final AbstractWingType DEMON_COMMON;
    public static final AbstractWingType DEMON_FEATHERED;
    public static final AbstractWingType LEATHERY;
    public static final AbstractWingType FEATHERED;
    public static final AbstractWingType INSECT;
    private static List<AbstractWingType> allWingTypes;
    private static Map<AbstractWingType, String> wingToIdMap;
    private static Map<String, AbstractWingType> idToWingMap;
    private static Map<AbstractRace, List<AbstractWingType>> typesMap;

    public static AbstractWingType getWingTypeFromId(String id) {
        if (id.equals("IMP")) {
            return DEMON_COMMON;
        }
        if (id.equals("PEGASUS")) {
            return FEATHERED;
        }
        id = Util.getClosestStringMatch(id, idToWingMap.keySet());
        return idToWingMap.get(id);
    }

    public static String getIdFromWingType(AbstractWingType wingType) {
        return wingToIdMap.get(wingType);
    }

    public static List<AbstractWingType> getAllWingTypes() {
        return allWingTypes;
    }

    public static List<AbstractWingType> getWingTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractWingType> types = new ArrayList<AbstractWingType>();
        for (AbstractWingType type : WingType.getAllWingTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        if (types.isEmpty()) {
            for (AbstractWingType type : WingType.getAllWingTypes()) {
                if (!type.isGeneric()) continue;
                types.add(type);
            }
        }
        typesMap.put(r, types);
        return types;
    }

    static {
        Field[] fieldArray;
        NONE = new AbstractWingType(null, Race.NONE, false, "\u65e0", "\u7fc5\u8180", "\u7fc5\u8180", (List)new ArrayList(), (List)new ArrayList(), "#IF(npc.getLegConfiguration().isWingsOnLegConfiguration())\u4f34\u968f\u7740\u5f3a\u70c8\u7684\u62c9\u626f\u611f\uff0c[npc.her]\u7684[npc.wings]\u9010\u6e10\u7f29\u5c0f\uff0c\u6d88\u5931\u5728[npc.legConfiguration]\u8eab\u4f53\u7684\u4e24\u4fa7\u3002#ELSE\u4f34\u968f\u7740\u5f3a\u70c8\u7684\u62c9\u626f\u611f\uff0c[npc.her]\u7684[npc.wings]\u9010\u6e10\u7f29\u5c0f\uff0c\u4ece\u80cc\u4e0a\u6d88\u5931\u4e86\u3002#ENDIF<br/>[npc.Name]\u73b0\u5728[style.boldTfGeneric(\u6ca1\u6709\u7fc5\u8180)]\u3002", ""){};
        ANGEL = new AbstractWingType(BodyCoveringType.ANGEL_FEATHER, Race.ANGEL, true, "\u5929\u4f7f(\u8986\u7fbd)", "\u7fc5\u8180", "\u7fc5\u8180", Util.newArrayListOfValues("\u5929\u4f7f", "\u7fbd\u6bdb\u8986\u76d6"), Util.newArrayListOfValues("\u5929\u4f7f", "\u7fbd\u6bdb\u8986\u76d6"), "#IF(npc.getLegConfiguration().isWingsOnLegConfiguration())[npc.She]\u7d27\u54ac\u4e0b\u5507\uff0c\u5e0c\u671b\u80fd\u538b\u6291\u4f4f\u59cb\u6599\u672a\u53ca\u7684\u6109\u60a6\u547b\u541f\uff0c\u4e00\u5bf9\u8986\u76d6\u7740\u7fbd\u6bdb\u7684[npc.wingSize]\u5929\u4f7f\u7fc5\u8180\u968f\u4e4b\u4ece[npc.her][npc.legConfiguration]\u8eab\u4f53\u7684\u4e24\u4fa7\u957f\u4e86\u51fa\u6765\u3002#ELSE[npc.She]\u7d27\u54ac\u4e0b\u5507\uff0c\u5e0c\u671b\u80fd\u538b\u6291\u4f4f\u59cb\u6599\u672a\u53ca\u7684\u6109\u60a6\u547b\u541f\uff0c\u4e00\u5bf9\u8986\u76d6\u7740\u7fbd\u6bdb\u7684[npc.wingSize]\u5929\u4f7f\u7fc5\u8180\u968f\u4e4b\u4ece[npc.her]\u7684\u80a9\u80db\u9aa8\u4f4d\u7f6e\u957f\u4e86\u51fa\u6765\u3002#ENDIF<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldAngel(\u7fbd\u6bdb\u8986\u76d6\u7684\u5929\u4f7f\u7fc5\u8180)]\u3002", "[npc.sheHasFull]\u62e5\u6709\u4e00\u5bf9\u7fbd\u6bdb\u8986\u76d6\u7684[npc.wingSize]\u5929\u4f7f\u7fc5\u8180\uff0c[npc.materialDescriptor][npc.wingFullDescription(true)]\u3002"){};
        DEMON_COMMON = new AbstractWingType(BodyCoveringType.DEMON_COMMON, Race.DEMON, true, "\u6076\u9b54(\u76ae\u8d28)", "\u7fc5\u8180", "\u7fc5\u8180", Util.newArrayListOfValues("\u6076\u9b54", "\u76ae\u8d28"), Util.newArrayListOfValues("\u6076\u9b54", "\u76ae\u8d28"), "#IF(npc.getLegConfiguration().isWingsOnLegConfiguration())[npc.She]\u7d27\u54ac\u4e0b\u5507\uff0c\u5e0c\u671b\u80fd\u538b\u6291\u4f4f\u59cb\u6599\u672a\u53ca\u7684\u6109\u60a6\u547b\u541f\uff0c\u4e00\u5bf9\u8986\u76d6\u6709\u76ae\u819c\u7684[npc.wingSize]\u6076\u9b54\u7fc5\u8180\u968f\u4e4b\u4ece[npc.her][npc.legConfiguration]\u8eab\u4f53\u7684\u4e24\u4fa7\u957f\u4e86\u51fa\u6765\u3002#ELSE[npc.She]\u7d27\u54ac\u4e0b\u5507\uff0c\u5e0c\u671b\u80fd\u538b\u6291\u4f4f\u59cb\u6599\u672a\u53ca\u7684\u6109\u60a6\u547b\u541f\uff0c\u4e00\u5bf9\u8986\u76d6\u6709\u76ae\u819c\u7684[npc.wingSize]\u6076\u9b54\u7fc5\u8180\u968f\u4e4b\u4ece[npc.her]\u7684\u80a9\u80db\u9aa8\u4f4d\u7f6e\u957f\u4e86\u51fa\u6765\u3002#ENDIF<br/>#IF(npc.isShortStature())[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldImp(\u8986\u76d6\u6709\u76ae\u819c\u7684\u5c0f\u6076\u9b54\u7fc5\u8180)]\u3002#ELSE[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldDemon(\u8986\u76d6\u6709\u76ae\u819c\u7684\u6076\u9b54\u7fc5\u8180)]\u3002#ENDIF", "[npc.sheHasFull]\u62e5\u6709\u4e00\u5bf9\u8986\u76d6\u6709\u76ae\u819c\u7684[npc.wingSize]\u6076\u9b54\u7fc5\u8180\uff0c[npc.materialDescriptor][npc.wingFullDescription(true)]\u3002"){};
        DEMON_FEATHERED = new AbstractWingType(BodyCoveringType.DEMON_FEATHER, Race.DEMON, true, "\u6076\u9b54(\u8986\u7fbd)", "\u7fc5\u8180", "\u7fc5\u8180", Util.newArrayListOfValues("\u6076\u9b54", "\u7fbd\u6bdb\u8986\u76d6"), Util.newArrayListOfValues("\u6076\u9b54", "\u7fbd\u6bdb\u8986\u76d6"), "#IF(npc.getLegConfiguration().isWingsOnLegConfiguration())[npc.She]\u7d27\u54ac\u4e0b\u5507\uff0c\u5e0c\u671b\u80fd\u538b\u6291\u4f4f\u59cb\u6599\u672a\u53ca\u7684\u6109\u60a6\u547b\u541f\uff0c\u4e00\u5bf9\u8986\u76d6\u7740\u7fbd\u6bdb\u7684[npc.wingSize]\u6076\u9b54\u7fc5\u8180\u968f\u4e4b\u4ece[npc.her]\u7684\u80a9\u80db\u9aa8\u4f4d\u7f6e\u957f\u4e86\u51fa\u6765\u3002#ELSE[npc.She]\u7d27\u54ac\u4e0b\u5507\uff0c\u5e0c\u671b\u80fd\u538b\u6291\u4f4f\u59cb\u6599\u672a\u53ca\u7684\u6109\u60a6\u547b\u541f\uff0c\u4e00\u5bf9\u8986\u76d6\u7740\u7fbd\u6bdb\u7684[npc.wingSize]\u6076\u9b54\u7fc5\u8180\u968f\u4e4b\u4ece[npc.her]\u7684\u80a9\u80db\u9aa8\u4f4d\u7f6e\u957f\u4e86\u51fa\u6765\u3002#ENDIF<br/>#IF(npc.isShortStature())[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldImp(\u7fbd\u6bdb\u8986\u76d6\u7684\u5c0f\u6076\u9b54\u7fc5\u8180)]\u3002#ELSE[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldDemon(\u7fbd\u6bdb\u8986\u76d6\u7684\u6076\u9b54\u7fc5\u8180)]\u3002#ENDIF", "[npc.sheHasFull]\u62e5\u6709\u4e00\u5bf9\u7fbd\u6bdb\u8986\u76d6\u7684[npc.wingSize]\u6076\u9b54\u7fc5\u8180\uff0c[npc.materialDescriptor][npc.wingFullDescription(true)]\u3002"){};
        LEATHERY = new AbstractWingType(BodyCoveringType.WING_LEATHER, Race.NONE, true, "\u76ae\u8d28", "\u7fc5\u8180", "\u7fc5\u8180", Util.newArrayListOfValues("\u76ae\u8d28"), Util.newArrayListOfValues("\u76ae\u8d28"), "#IF(npc.getLegConfiguration().isWingsOnLegConfiguration())[npc.She]\u7d27\u54ac\u4e0b\u5507\uff0c\u5e0c\u671b\u80fd\u538b\u6291\u4f4f\u59cb\u6599\u672a\u53ca\u7684\u6109\u60a6\u547b\u541f\uff0c\u4e00\u5bf9\u8986\u76d6\u6709\u76ae\u819c\u7684[npc.wingSize]\u7fc5\u8180\u968f\u4e4b\u4ece[npc.her][npc.legConfiguration]\u8eab\u4f53\u7684\u4e24\u4fa7\u957f\u4e86\u51fa\u6765\u3002#ELSE[npc.She]\u7d27\u54ac\u4e0b\u5507\uff0c\u5e0c\u671b\u80fd\u538b\u6291\u4f4f\u59cb\u6599\u672a\u53ca\u7684\u6109\u60a6\u547b\u541f\uff0c\u4e00\u5bf9\u8986\u76d6\u6709\u76ae\u819c\u7684[npc.wingSize]\u7fc5\u8180\u968f\u4e4b\u4ece[npc.her]\u7684\u80a9\u80db\u9aa8\u4f4d\u7f6e\u957f\u4e86\u51fa\u6765\u3002#ENDIF<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(\u8986\u76d6\u6709\u76ae\u819c\u7684\u7fc5\u8180)]\u3002", "[npc.sheHasFull]\u62e5\u6709\u4e00\u5bf9\u8986\u76d6\u6709\u76ae\u819c\u7684[npc.wingSize]\u7fc5\u8180\uff0c[npc.materialDescriptor][npc.wingFullDescription(true)]\u3002"){

            @Override
            public boolean isGeneric() {
                return true;
            }
        };
        FEATHERED = new AbstractWingType(BodyCoveringType.FEATHERS, Race.NONE, true, "\u7fbd\u6bdb", "\u7fc5\u8180", "\u7fc5\u8180", Util.newArrayListOfValues("\u7fbd\u6bdb\u8986\u76d6"), Util.newArrayListOfValues("\u7fbd\u6bdb\u8986\u76d6"), "#IF(npc.getLegConfiguration().isWingsOnLegConfiguration())[npc.She]\u7d27\u54ac\u4e0b\u5507\uff0c\u5e0c\u671b\u80fd\u538b\u6291\u4f4f\u59cb\u6599\u672a\u53ca\u7684\u6109\u60a6\u547b\u541f\uff0c\u4e00\u5bf9\u8986\u76d6\u7740\u7fbd\u6bdb\u7684[npc.wingSize]\u7fc5\u8180\u968f\u4e4b\u4ece[npc.her][npc.legConfiguration]\u8eab\u4f53\u7684\u4e24\u4fa7\u957f\u4e86\u51fa\u6765\u3002#ELSE[npc.She]\u7d27\u54ac\u4e0b\u5507\uff0c\u5e0c\u671b\u80fd\u538b\u6291\u4f4f\u59cb\u6599\u672a\u53ca\u7684\u6109\u60a6\u547b\u541f\uff0c\u4e00\u5bf9\u8986\u76d6\u7740\u7fbd\u6bdb\u7684[npc.wingSize]\u7fc5\u8180\u968f\u4e4b\u4ece[npc.her]\u7684\u80a9\u80db\u9aa8\u4f4d\u7f6e\u957f\u4e86\u51fa\u6765\u3002#ENDIF<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(\u7fbd\u6bdb\u8986\u76d6\u7684\u7fc5\u8180)]\u3002", "[npc.sheHasFull]\u62e5\u6709\u4e00\u5bf9\u7fbd\u6bdb\u8986\u76d6\u7684[npc.wingSize]\u7fc5\u8180\uff0c[npc.materialDescriptor][npc.wingFullDescription(true)]\u3002"){

            @Override
            public boolean isGeneric() {
                return true;
            }
        };
        INSECT = new AbstractWingType(BodyCoveringType.WING_CHITIN, Race.NONE, true, "\u6606\u866b", "\u7fc5\u8180", "\u7fc5\u8180", Util.newArrayListOfValues("\u51e0\u4e01\u8d28"), Util.newArrayListOfValues("\u51e0\u4e01\u8d28"), "#IF(npc.getLegConfiguration().isWingsOnLegConfiguration())[npc.She]\u7d27\u54ac\u4e0b\u5507\uff0c\u5e0c\u671b\u80fd\u538b\u6291\u4f4f\u59cb\u6599\u672a\u53ca\u7684\u6109\u60a6\u547b\u541f\uff0c\u4e00\u5bf9\u6606\u866b\u822c\u7684[npc.wingSize]\u7fc5\u8180\u968f\u4e4b\u4ece[npc.her][npc.legConfiguration]\u8eab\u4f53\u7684\u4e24\u4fa7\u957f\u4e86\u51fa\u6765\u3002#ELSE[npc.She]\u7d27\u54ac\u4e0b\u5507\uff0c\u5e0c\u671b\u80fd\u538b\u6291\u4f4f\u59cb\u6599\u672a\u53ca\u7684\u6109\u60a6\u547b\u541f\uff0c\u4e00\u5bf9\u6606\u866b\u822c\u7684[npc.wingSize]\u7fc5\u8180\u968f\u4e4b\u4ece[npc.her]\u7684\u80a9\u80db\u9aa8\u4f4d\u7f6e\u957f\u4e86\u51fa\u6765\u3002#ENDIF<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(\u6606\u866b\u822c\u7684\u7fc5\u8180)]\u3002", "[npc.sheHasFull]\u62e5\u6709\u4e00\u5bf9\u6606\u866b\u822c\u7684[npc.wingSize]\u7fc5\u8180\uff0c[npc.materialDescriptor][npc.wingFullDescription(true)]\u3002"){

            @Override
            public boolean isGeneric() {
                return true;
            }
        };
        wingToIdMap = new HashMap<AbstractWingType, String>();
        idToWingMap = new HashMap<String, AbstractWingType>();
        allWingTypes = new ArrayList<AbstractWingType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("wing")) continue;
                try {
                    AbstractWingType type = new AbstractWingType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allWingTypes.add(type);
                    wingToIdMap.put(type, id);
                    idToWingMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("wing")) continue;
                try {
                    AbstractWingType type = new AbstractWingType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allWingTypes.add(type);
                    wingToIdMap.put(type, id);
                    idToWingMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = WingType.class.getFields()) {
            if (!AbstractWingType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractWingType ct = (AbstractWingType)f.get(null);
                wingToIdMap.put(ct, f.getName());
                idToWingMap.put(f.getName(), ct);
                allWingTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allWingTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractWingType>>();
    }
}

