/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Affinity {
    AQUATIC,
    AMPHIBIOUS,
    TERRESTRIAL;

    public static final List<Affinity> allAffinities;
    public static final Map<Affinity, String> affinityToIdMap;
    public static final Map<String, Affinity> idToAffinityMap;

    public static List<Affinity> getAllAffinities() {
        return allAffinities;
    }

    public static Affinity getAffinityFromId(String id) {
        id = Util.getClosestStringMatch(id, idToAffinityMap.keySet());
        return idToAffinityMap.get(id);
    }

    public static String getIdFromAffinity(Affinity a) {
        return affinityToIdMap.get((Object)a);
    }

    static {
        allAffinities = new ArrayList<Affinity>();
        affinityToIdMap = new HashMap<Affinity, String>();
        idToAffinityMap = new HashMap<String, Affinity>();
        for (Affinity a : Affinity.values()) {
            allAffinities.add(a);
            affinityToIdMap.put(a, a.toString());
            idToAffinityMap.put(a.toString(), a);
        }
    }
}

