/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ClitorisSize {
    ZERO_AVERAGE("\u5fae\u5c0f", 0, 1, PresetColour.GENERIC_SIZE_ONE){

        @Override
        public boolean isPseudoPenisSize() {
            return false;
        }
    }
    ,
    ONE_BIG("\u7a0d\u5927", 1, 5, PresetColour.GENERIC_SIZE_TWO){

        @Override
        public boolean isPseudoPenisSize() {
            return false;
        }
    }
    ,
    TWO_LARGE("\u8f83\u5927", 5, 10, PresetColour.GENERIC_SIZE_THREE),
    THREE_HUGE("\u6781\u5927", 10, 25, PresetColour.GENERIC_SIZE_FOUR),
    FOUR_MASSIVE("\u7855\u5927", 25, 40, PresetColour.GENERIC_SIZE_FIVE),
    FIVE_ENORMOUS("\u5de8\u5927", 40, 50, PresetColour.GENERIC_SIZE_SIX),
    SIX_GIGANTIC("\u5e9e\u5927", 50, 60, PresetColour.GENERIC_SIZE_SEVEN),
    SEVEN_STALLION("\u5927\u5230\u79bb\u8c31", 60, 100, PresetColour.GENERIC_SIZE_EIGHT);

    private int minimumValue;
    private int maximumValue;
    private String descriptor;
    private Colour colour;

    private ClitorisSize(String descriptor, int minimumValue, int maximumValue, Colour colour) {
        this.descriptor = descriptor;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
    }

    public static ClitorisSize getMinimumClitorisSizeForPseudoPenis() {
        return TWO_LARGE;
    }

    public boolean isPseudoPenisSize() {
        return true;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return this.minimumValue + (this.maximumValue - this.minimumValue) / 2;
    }

    public static ClitorisSize getClitorisSizeFromInt(int cm) {
        for (ClitorisSize cs : ClitorisSize.values()) {
            if (cm < cs.getMinimumValue() || cm >= cs.getMaximumValue()) continue;
            return cs;
        }
        return SEVEN_STALLION;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Colour getColour() {
        return this.colour;
    }
}

