/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.game.character.body.valueEnums.Wetness;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum CumProduction {
    ZERO_NONE("\u65e0", "\u6ca1\u6709", 0, 1, 100, Wetness.ZERO_DRY, PresetColour.GENERIC_SIZE_ONE, 0),
    ONE_TRICKLE("\u5fae\u91cf", "\u51e0\u6ef4", 1, 3, 75, Wetness.ONE_SLIGHTLY_MOIST, PresetColour.GENERIC_SIZE_TWO, 0),
    TWO_SMALL_AMOUNT("\u5c11\u91cf", "\u5c11\u91cf", 3, 6, 50, Wetness.TWO_MOIST, PresetColour.GENERIC_SIZE_THREE, 0),
    THREE_AVERAGE("\u5e73\u5747", "\u5e73\u5747\u91cf", 6, 16, 25, Wetness.THREE_WET, PresetColour.GENERIC_SIZE_FOUR, 0),
    FOUR_LARGE("\u5927\u91cf", "\u5927\u91cf", 16, 30, 5, Wetness.FOUR_SLIMY, PresetColour.GENERIC_SIZE_FIVE, 0),
    FIVE_HUGE("\u5de8\u91cf", "\u5de8\u91cf", 30, 100, 0, Wetness.FIVE_SLOPPY, PresetColour.GENERIC_SIZE_SIX, 1),
    SIX_EXTREME("\u6781\u5de8\u91cf", "\u6781\u5de8\u91cf", 100, 1000, 0, Wetness.SIX_SOPPING_WET, PresetColour.GENERIC_SIZE_SEVEN, 3),
    SEVEN_MONSTROUS("\u6050\u6016\u91cf", "\u6050\u6016\u91cf", 1000, 10000, 0, Wetness.SEVEN_DROOLING, PresetColour.GENERIC_SIZE_EIGHT, 8);

    private String name;
    private String descriptor;
    private int minimumValue;
    private int maximumValue;
    private int arousalNeededToStartPreCumming;
    private Wetness associatedWetness;
    private Colour colour;
    private int additionalSlotsDirtiedUponOrgasm;

    private CumProduction(String name, String descriptor, int minimumValue, int maximumValue, int arousalNeededToStartPreCumming, Wetness associatedWetness, Colour colour, int additionalSlotsDirtiedUponOrgasm) {
        this.name = name;
        this.descriptor = descriptor;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.arousalNeededToStartPreCumming = arousalNeededToStartPreCumming;
        this.associatedWetness = associatedWetness;
        this.colour = colour;
        this.additionalSlotsDirtiedUponOrgasm = additionalSlotsDirtiedUponOrgasm;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return this.minimumValue + (this.maximumValue - this.minimumValue) / 2;
    }

    public int getArousalNeededToStartPreCumming() {
        return this.arousalNeededToStartPreCumming;
    }

    public static CumProduction getCumProductionFromInt(int cumProduction) {
        for (CumProduction cp : CumProduction.values()) {
            if (cumProduction < cp.getMinimumValue() || cumProduction >= cp.getMaximumValue()) continue;
            return cp;
        }
        return SEVEN_MONSTROUS;
    }

    public Wetness getAssociatedWetness() {
        return this.associatedWetness;
    }

    public Colour getColour() {
        return this.colour;
    }

    public int getAdditionalSlotsDirtiedUponOrgasm() {
        return this.additionalSlotsDirtiedUponOrgasm;
    }
}

