/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum HairLength {
    ZERO_BALD("\u79c3\u5934", 0, 1, PresetColour.GENERIC_SIZE_ONE, false),
    ONE_VERY_SHORT("\u5bf8\u957f", 1, 8, PresetColour.GENERIC_SIZE_TWO, false),
    TWO_SHORT("\u77ed", 8, 15, PresetColour.GENERIC_SIZE_THREE, true),
    THREE_SHOULDER_LENGTH("\u53ca\u80a9\u77ed", 15, 30, PresetColour.GENERIC_SIZE_FOUR, true),
    FOUR_MID_BACK("\u957f", 30, 60, PresetColour.GENERIC_SIZE_FIVE, true),
    FIVE_ABOVE_ASS("\u53ca\u8170\u957f", 60, 100, PresetColour.GENERIC_SIZE_SIX, true),
    SIX_BELOW_ASS("\u8fc7\u819d\u957f", 100, 180, PresetColour.GENERIC_SIZE_SEVEN, true),
    SEVEN_TO_FLOOR("\u62d6\u5730\u957f", 180, 350, PresetColour.GENERIC_SIZE_EIGHT, true);

    private int minimumValue;
    private int maximumValue;
    private String descriptor;
    private Colour colour;
    private boolean suitableForPulling;

    private HairLength(String descriptor, int minimumValue, int maximumValue, Colour colour, boolean suitableForPulling) {
        this.descriptor = descriptor;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
        this.suitableForPulling = suitableForPulling;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return this.minimumValue + (this.maximumValue - this.minimumValue) / 2;
    }

    public static HairLength getShorter(int currentHairLength) {
        if (currentHairLength <= HairLength.ZERO_BALD.maximumValue) {
            return ZERO_BALD;
        }
        if (currentHairLength <= HairLength.ONE_VERY_SHORT.maximumValue) {
            return ZERO_BALD;
        }
        if (currentHairLength <= HairLength.TWO_SHORT.maximumValue) {
            return ONE_VERY_SHORT;
        }
        if (currentHairLength <= HairLength.THREE_SHOULDER_LENGTH.maximumValue) {
            return TWO_SHORT;
        }
        if (currentHairLength <= HairLength.FOUR_MID_BACK.maximumValue) {
            return THREE_SHOULDER_LENGTH;
        }
        if (currentHairLength <= HairLength.FIVE_ABOVE_ASS.maximumValue) {
            return FOUR_MID_BACK;
        }
        if (currentHairLength <= HairLength.SIX_BELOW_ASS.maximumValue) {
            return FIVE_ABOVE_ASS;
        }
        return SIX_BELOW_ASS;
    }

    public static HairLength getLonger(int currentHairLength) {
        if (currentHairLength <= HairLength.ZERO_BALD.maximumValue) {
            return ONE_VERY_SHORT;
        }
        if (currentHairLength <= HairLength.ONE_VERY_SHORT.maximumValue) {
            return TWO_SHORT;
        }
        if (currentHairLength <= HairLength.TWO_SHORT.maximumValue) {
            return THREE_SHOULDER_LENGTH;
        }
        if (currentHairLength <= HairLength.THREE_SHOULDER_LENGTH.maximumValue) {
            return FOUR_MID_BACK;
        }
        if (currentHairLength <= HairLength.FOUR_MID_BACK.maximumValue) {
            return FIVE_ABOVE_ASS;
        }
        if (currentHairLength <= HairLength.FIVE_ABOVE_ASS.maximumValue) {
            return SIX_BELOW_ASS;
        }
        if (currentHairLength <= HairLength.SIX_BELOW_ASS.maximumValue) {
            return SEVEN_TO_FLOOR;
        }
        return SEVEN_TO_FLOOR;
    }

    public static HairLength getHairLengthFromInt(int hairLength) {
        for (HairLength hl : HairLength.values()) {
            if (hairLength < hl.getMinimumValue() || hairLength >= hl.getMaximumValue()) continue;
            return hl;
        }
        return SEVEN_TO_FLOOR;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Colour getColour() {
        return this.colour;
    }

    public boolean isSuitableForPulling() {
        return this.suitableForPulling;
    }
}

