/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum HipSize {
    ZERO_NO_HIPS("\u5e72\u762a", 0, PresetColour.GENERIC_SIZE_ONE),
    ONE_VERY_NARROW("\u975e\u5e38\u5e73\u5766", 1, PresetColour.GENERIC_SIZE_TWO),
    TWO_NARROW("\u5e73\u5766", 2, PresetColour.GENERIC_SIZE_THREE),
    THREE_GIRLY("\u7fd8\u633a", 3, PresetColour.GENERIC_SIZE_FOUR),
    FOUR_WOMANLY("\u4e30\u6ee1", 4, PresetColour.GENERIC_SIZE_FIVE),
    FIVE_VERY_WIDE("\u5bbd\u5927", 5, PresetColour.GENERIC_SIZE_SIX),
    SIX_EXTREMELY_WIDE("\u975e\u5e38\u5bbd\u5927", 6, PresetColour.GENERIC_SIZE_SEVEN),
    SEVEN_ABSURDLY_WIDE("\u5bbd\u5927\u5f97\u79bb\u8c31", 7, PresetColour.GENERIC_SIZE_EIGHT);

    private String descriptor;
    private int size;
    private Colour colour;

    private HipSize(String descriptor, int hipSize, Colour colour) {
        this.descriptor = descriptor;
        this.size = hipSize;
        this.colour = colour;
    }

    public static HipSize getHipSizeFromInt(int hipSize) {
        for (HipSize hs : HipSize.values()) {
            if (hipSize != hs.getValue()) continue;
            return hs;
        }
        return SEVEN_ABSURDLY_WIDE;
    }

    public String getDescriptor() {
        if (Main.game.isSillyModeEnabled()) {
            switch (this) {
                case FIVE_VERY_WIDE: {
                    return "\u80a5\u80a5";
                }
                case SIX_EXTREMELY_WIDE: {
                    return "\u8d85\u7ea7\u80a5\u80a5";
                }
                case SEVEN_ABSURDLY_WIDE: {
                    return "\u8352\u5510\u80a5\u80a5";
                }
            }
        }
        return this.descriptor;
    }

    public int getValue() {
        return this.size;
    }

    public Colour getColour() {
        return this.colour;
    }
}

