/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum HornLength {
    ZERO_TINY("\u5fae\u5c0f", 0, 5, PresetColour.GENERIC_SIZE_ONE, false),
    ONE_SMALL("\u77ed\u5c0f", 5, 15, PresetColour.GENERIC_SIZE_THREE, true),
    TWO_LONG("\u4fee\u957f", 15, 30, PresetColour.GENERIC_SIZE_FIVE, true),
    THREE_HUGE("\u6781\u5927", 30, 50, PresetColour.GENERIC_SIZE_SEVEN, true),
    FOUR_MASSIVE("\u5de8\u5927", 50, 75, PresetColour.GENERIC_SIZE_NINE, true);

    private int minimumValue;
    private int maximumValue;
    private String descriptor;
    private Colour colour;
    private boolean suitableAsHandles;

    private HornLength(String descriptor, int minimumValue, int maximumValue, Colour colour, boolean suitableAsHandles) {
        this.descriptor = descriptor;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
        this.suitableAsHandles = suitableAsHandles;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return (this.minimumValue + this.maximumValue) / 2;
    }

    public int getRandomValue() {
        return this.minimumValue + Util.random.nextInt(this.maximumValue - this.minimumValue);
    }

    public static HornLength getLengthFromInt(int cm) {
        for (HornLength ps : HornLength.values()) {
            if (cm < ps.getMinimumValue() || cm >= ps.getMaximumValue()) continue;
            return ps;
        }
        return FOUR_MASSIVE;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Colour getColour() {
        return this.colour;
    }

    public boolean isSuitableAsHandles() {
        return this.suitableAsHandles;
    }
}

