/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.game.character.body.valueEnums.Wetness;

public enum Lactation {
    ZERO_NONE("\u65e0", "\u6ca1\u6709", 0, 1, Wetness.ZERO_DRY),
    ONE_TRICKLE("\u5fae\u91cf", "\u5fae\u91cf", 1, 30, Wetness.ONE_SLIGHTLY_MOIST),
    TWO_SMALL_AMOUNT("\u5c11\u91cf", "\u5c11\u91cf", 30, 100, Wetness.TWO_MOIST),
    THREE_DECENT_AMOUNT("\u9002\u91cf", "\u9002\u91cf", 100, 600, Wetness.THREE_WET),
    FOUR_LARGE_AMOUNT("\u5927\u91cf", "\u5927\u91cf", 600, 1000, Wetness.FOUR_SLIMY),
    FIVE_VERY_LARGE_DROOLING("\u5de8\u91cf", "\u5de8\u91cf", 1000, 2000, Wetness.FIVE_SLOPPY),
    SIX_EXTREME_AMOUNT_DRIPPING("\u6781\u5de8\u91cf", "\u6781\u5de8\u91cf", 2000, 10000, Wetness.SIX_SOPPING_WET),
    SEVEN_MONSTROUS_AMOUNT_POURING("\u6050\u6016\u91cf", "\u6050\u6016\u91cf", 10000, 100000, Wetness.SEVEN_DROOLING);

    private String name;
    private String descriptor;
    private int minimumValue;
    private int maximumValue;
    private Wetness associatedWetness;

    private Lactation(String name, String descriptor, int minimumValue, int maximumValue, Wetness associatedWetness) {
        this.name = name;
        this.descriptor = descriptor;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.associatedWetness = associatedWetness;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return this.minimumValue + (this.maximumValue - this.minimumValue) / 2;
    }

    public static Lactation getLactationFromInt(int milkProduction) {
        for (Lactation l : Lactation.values()) {
            if (milkProduction < l.getMinimumValue() || milkProduction >= l.getMaximumValue()) continue;
            return l;
        }
        return SEVEN_MONSTROUS_AMOUNT_POURING;
    }

    public Wetness getAssociatedWetness() {
        return this.associatedWetness;
    }
}

