/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum Wetness {
    ZERO_DRY("\u5e72\u71e5", 0, 101, 101, PresetColour.GENERIC_WETNESS_ONE),
    ONE_SLIGHTLY_MOIST("\u5fae\u6f6e", 1, 100, 100, PresetColour.GENERIC_WETNESS_TWO),
    TWO_MOIST("\u6f6e\u6e7f", 2, 50, 50, PresetColour.GENERIC_WETNESS_THREE),
    THREE_WET("\u6e7f\u6da6", 3, 25, 25, PresetColour.GENERIC_WETNESS_FOUR),
    FOUR_SLIMY("\u7c98\u6ed1", 4, 0, 0, PresetColour.GENERIC_WETNESS_FIVE),
    FIVE_SLOPPY("\u6e7f\u6ed1", 5, 0, 0, PresetColour.GENERIC_WETNESS_SIX),
    SIX_SOPPING_WET("\u6e7f\u900f", 6, 0, 0, PresetColour.GENERIC_WETNESS_SEVEN),
    SEVEN_DROOLING("\u6ef4\u6c34", 7, 0, 0, PresetColour.GENERIC_WETNESS_EIGHT);

    private int wetness;
    private int arousalNeededToGetVaginaWet;
    private int arousalNeededToGetAssWet;
    private String descriptor;
    private Colour colour;

    private Wetness(String descriptor, int wetness, int arousalNeededToGetVaginaWet, int arousalNeededToGetAssWet, Colour colour) {
        this.descriptor = descriptor;
        this.wetness = wetness;
        this.arousalNeededToGetVaginaWet = arousalNeededToGetVaginaWet;
        this.arousalNeededToGetAssWet = arousalNeededToGetAssWet;
        this.colour = colour;
    }

    public static Wetness valueOf(int wetness) {
        for (Wetness w : Wetness.values()) {
            if (wetness != w.getValue()) continue;
            return w;
        }
        return SEVEN_DROOLING;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public int getValue() {
        return this.wetness;
    }

    public int getArousalNeededToGetVaginaWet() {
        return this.arousalNeededToGetVaginaWet;
    }

    public int getArousalNeededToGetAssWet() {
        return this.arousalNeededToGetAssWet;
    }

    public Colour getColour() {
        return this.colour;
    }
}

