/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum WingSize {
    ZERO_TINY(0, "\u5fae\u578b", PresetColour.GENERIC_SIZE_ONE),
    ONE_SMALL(1, "\u5c0f\u578b", PresetColour.GENERIC_SIZE_TWO),
    TWO_AVERAGE(2, "\u4e2d\u578b", PresetColour.GENERIC_SIZE_THREE),
    THREE_LARGE(3, "\u5927\u578b", PresetColour.GENERIC_SIZE_FOUR),
    FOUR_HUGE(4, "\u5de8\u578b", PresetColour.GENERIC_SIZE_FIVE);

    private int value;
    private String descriptor;
    private Colour colour;

    private WingSize(int value, String descriptor, Colour colour) {
        this.value = value;
        this.descriptor = descriptor;
        this.colour = colour;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.descriptor;
    }

    public static WingSize getWingSizeFromInt(int size) {
        for (WingSize ls : WingSize.values()) {
            if (size != ls.getValue()) continue;
            return ls;
        }
        return ZERO_TINY;
    }

    public static int getLargest() {
        int largest = WingSize.ZERO_TINY.value;
        for (WingSize ls : WingSize.values()) {
            largest = Math.max(largest, ls.value);
        }
        return largest;
    }

    public Colour getColour() {
        return this.colour;
    }
}

