/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.effects;

import java.util.ArrayList;
import java.util.List;

public class TreeEntry<T, S> {
    private int row;
    private List<TreeEntry<T, S>> links;
    private T category;
    private S entry;

    public TreeEntry(T category, int row, S perk) {
        this.category = category;
        this.row = row;
        this.links = new ArrayList<TreeEntry<T, S>>();
        this.entry = perk;
    }

    public boolean equals(Object o) {
        if (o instanceof TreeEntry) {
            try {
                if (((TreeEntry)o).getRow() == this.getRow() && ((TreeEntry)o).getCategory() == this.getCategory() && ((TreeEntry)o).getEntry().equals(this.getEntry())) {
                    return true;
                }
            }
            catch (Exception ex) {
                return false;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getRow();
        result = 31 * result + this.getCategory().hashCode();
        result = 31 * result + this.getEntry().hashCode();
        return result;
    }

    public T getCategory() {
        return this.category;
    }

    public int getRow() {
        return this.row;
    }

    public List<TreeEntry<T, S>> getParentLinks() {
        ArrayList<TreeEntry<T, S>> parentLinks = new ArrayList<TreeEntry<T, S>>(this.links);
        parentLinks.removeIf(e -> e.getRow() >= this.getRow());
        return parentLinks;
    }

    public List<TreeEntry<T, S>> getChildLinks() {
        ArrayList<TreeEntry<T, S>> childLinks = new ArrayList<TreeEntry<T, S>>(this.links);
        childLinks.removeIf(e -> e.getRow() <= this.getRow());
        return childLinks;
    }

    public List<TreeEntry<T, S>> getSiblingLinks() {
        ArrayList<TreeEntry<T, S>> siblingLinks = new ArrayList<TreeEntry<T, S>>(this.links);
        siblingLinks.removeIf(e -> e.getRow() != this.getRow());
        return siblingLinks;
    }

    public List<TreeEntry<T, S>> getLinks() {
        return this.links;
    }

    public void setLinks(List<TreeEntry<T, S>> links) {
        this.links = new ArrayList<TreeEntry<T, S>>(links);
    }

    public void addLink(TreeEntry<T, S> entry) {
        if (!this.getLinks().contains(entry)) {
            this.links.add(entry);
        }
        if (!entry.getLinks().contains(this)) {
            entry.addLink(this);
        }
    }

    public S getEntry() {
        return this.entry;
    }
}

