/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.markings;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.markings.ScarType;
import com.lilithsthrone.utils.XMLSaving;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Scar
implements XMLSaving {
    private ScarType type;
    private boolean plural;

    public Scar(ScarType type, boolean plural) {
        this.type = type;
        this.plural = plural;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof Scar && ((Scar)o).getType() == this.type && ((Scar)o).isPlural() == this.plural;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.plural ? 1 : 0);
        return result;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("scar");
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "type", this.getType().toString());
        XMLUtil.addAttribute(doc, element, "plural", String.valueOf(this.isPlural()));
        return element;
    }

    public static Scar loadFromXML(Element parentElement, Document doc) {
        try {
            return new Scar(ScarType.getScarTypeFromString(parentElement.getAttribute("type")), Boolean.valueOf(parentElement.getAttribute("plural")));
        }
        catch (Exception ex) {
            System.err.println("Warning: An instance of Scar was unable to be imported!");
            return null;
        }
    }

    public String getName() {
        if (this.isPlural()) {
            return this.getType().getNamePlural();
        }
        return this.getType().getName();
    }

    public ScarType getType() {
        return this.type;
    }

    public boolean isPlural() {
        return this.plural;
    }
}

