/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.markings;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.markings.AbstractTattooType;
import com.lilithsthrone.game.character.markings.TattooCountType;
import com.lilithsthrone.game.character.markings.TattooCounter;
import com.lilithsthrone.game.character.markings.TattooCounterType;
import com.lilithsthrone.game.character.markings.TattooType;
import com.lilithsthrone.game.character.markings.TattooWriting;
import com.lilithsthrone.game.character.markings.TattooWritingStyle;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.utils.comparators.ItemEffectComparator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Tattoo
extends AbstractCoreItem
implements XMLSaving {
    private AbstractTattooType type;
    private Colour primaryColour;
    private Colour secondaryColour;
    private Colour tertiaryColour;
    private boolean glowing;
    private TattooWriting writing;
    private TattooCounter counter;
    protected List<ItemEffect> effects;
    protected Map<AbstractAttribute, Integer> attributeModifiers;
    private static Map<Colour, String> SVGGlowMap = new HashMap<Colour, String>();
    private int effectsHashCode = -1;

    public Tattoo(Tattoo tattooToCopy) {
        this(tattooToCopy.type, tattooToCopy.primaryColour, tattooToCopy.secondaryColour, tattooToCopy.tertiaryColour, tattooToCopy.glowing, tattooToCopy.writing == null ? new TattooWriting("", PresetColour.BASE_GREY, false, new TattooWritingStyle[0]) : new TattooWriting(tattooToCopy.writing), tattooToCopy.counter == null ? new TattooCounter(TattooCounterType.NONE, TattooCountType.NUMBERS, PresetColour.BASE_GREY, false, 0) : new TattooCounter(tattooToCopy.counter));
        this.effects = new ArrayList<ItemEffect>(tattooToCopy.effects);
        this.attributeModifiers = new HashMap<AbstractAttribute, Integer>(tattooToCopy.attributeModifiers);
    }

    public Tattoo(String typeId, boolean glowing, TattooWriting writing, TattooCounter counter) {
        this(TattooType.getTattooTypeFromId(typeId), TattooType.getTattooTypeFromId(typeId).getDefaultPrimaryColour(), TattooType.getTattooTypeFromId(typeId).getDefaultSecondaryColour(), TattooType.getTattooTypeFromId(typeId).getDefaultTertiaryColour(), glowing, writing, counter);
    }

    public Tattoo(String typeId, Colour allThreeColours, boolean glowing, TattooWriting writing, TattooCounter counter) {
        this(TattooType.getTattooTypeFromId(typeId), allThreeColours, allThreeColours, allThreeColours, glowing, writing, counter);
    }

    public Tattoo(String typeId, Colour primaryColour, Colour secondaryColour, Colour tertiaryColour, boolean glowing, TattooWriting writing, TattooCounter counter) {
        this(TattooType.getTattooTypeFromId(typeId), primaryColour, secondaryColour, tertiaryColour, glowing, writing, counter);
    }

    public Tattoo(AbstractTattooType type, boolean glowing, TattooWriting writing, TattooCounter counter) {
        this(type, type.getDefaultPrimaryColour(), type.getDefaultSecondaryColour(), type.getDefaultTertiaryColour(), glowing, writing, counter);
    }

    public Tattoo(AbstractTattooType type, Colour primaryColour, Colour secondaryColour, Colour tertiaryColour, boolean glowing, TattooWriting writing, TattooCounter counter) {
        super(type.getName(), type.getName(), type.getPathName(), primaryColour, Rarity.COMMON, null);
        this.type = type;
        this.primaryColour = primaryColour;
        this.secondaryColour = secondaryColour;
        this.tertiaryColour = tertiaryColour;
        this.glowing = glowing;
        this.writing = writing;
        this.counter = counter;
        this.effects = new ArrayList<ItemEffect>();
        this.attributeModifiers = new HashMap<AbstractAttribute, Integer>();
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof Tattoo && ((Tattoo)o).getType() == this.type && ((Tattoo)o).getPrimaryColour() == this.primaryColour && ((Tattoo)o).getPrimaryColour() == this.secondaryColour && ((Tattoo)o).getPrimaryColour() == this.tertiaryColour && ((Tattoo)o).isGlowing() == this.glowing && ((Tattoo)o).getWriting().equals(this.getWriting()) && ((Tattoo)o).getCounter().equals(this.getCounter()) && ((Tattoo)o).getEffects().equals(this.getEffects());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.getPrimaryColour().hashCode();
        if (this.getSecondaryColour() != null) {
            result = 31 * result + this.getSecondaryColour().hashCode();
        }
        if (this.getTertiaryColour() != null) {
            result = 31 * result + this.getTertiaryColour().hashCode();
        }
        result = 31 * result + (this.isGlowing() ? 1 : 0);
        result = 31 * result + this.getWriting().hashCode();
        result = 31 * result + this.getCounter().hashCode();
        result = 31 * result + this.getEffects().hashCode();
        return result;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("tattoo");
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "id", TattooType.getIdFromTattooType(this.getType()));
        XMLUtil.addAttribute(doc, element, "name", this.getName());
        XMLUtil.addAttribute(doc, element, "primaryColour", this.getPrimaryColour().getId());
        if (this.getSecondaryColour() != null) {
            XMLUtil.addAttribute(doc, element, "secondaryColour", this.getSecondaryColour().getId());
        }
        if (this.getTertiaryColour() != null) {
            XMLUtil.addAttribute(doc, element, "tertiaryColour", this.getTertiaryColour().getId());
        }
        XMLUtil.addAttribute(doc, element, "glowing", String.valueOf(this.isGlowing()));
        if (this.getWriting() != null) {
            this.getWriting().saveAsXML(element, doc);
        }
        if (this.getCounter() != null) {
            this.getCounter().saveAsXML(element, doc);
        }
        Element innerElement = doc.createElement("effects");
        element.appendChild(innerElement);
        for (ItemEffect ie : this.getEffects()) {
            ie.saveAsXML(innerElement, doc);
        }
        return element;
    }

    public static Tattoo loadFromXML(Element parentElement, Document doc) {
        try {
            TattooWriting writing = null;
            if (parentElement.getElementsByTagName("tattooWriting").item(0) != null) {
                writing = TattooWriting.loadFromXML((Element)parentElement.getElementsByTagName("tattooWriting").item(0), doc);
            }
            TattooCounter counter = null;
            if (parentElement.getElementsByTagName("tattooCounter").item(0) != null) {
                counter = TattooCounter.loadFromXML((Element)parentElement.getElementsByTagName("tattooCounter").item(0), doc);
            }
            Tattoo tat = new Tattoo(TattooType.getTattooTypeFromId(parentElement.getAttribute("id")), PresetColour.getColourFromId(parentElement.getAttribute("primaryColour")), parentElement.getAttribute("secondaryColour").isEmpty() ? null : PresetColour.getColourFromId(parentElement.getAttribute("secondaryColour")), parentElement.getAttribute("tertiaryColour").isEmpty() ? null : PresetColour.getColourFromId(parentElement.getAttribute("tertiaryColour")), (boolean)Boolean.valueOf(parentElement.getAttribute("glowing")), writing, counter);
            try {
                tat.setName(parentElement.getAttribute("name"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (parentElement.getElementsByTagName("effects").item(0) != null) {
                Element element = (Element)parentElement.getElementsByTagName("effects").item(0);
                NodeList nodeList = element.getElementsByTagName("effect");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element e = (Element)nodeList.item(i);
                    ItemEffect ie = ItemEffect.loadFromXML(e, doc);
                    if (ie == null) continue;
                    tat.addEffect(ie);
                }
            }
            return tat;
        }
        catch (Exception ex) {
            System.err.println("Warning: An instance of Tattoo was unable to be imported!");
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getSVGString() {
        return this.getSVGImage(Main.game.getPlayer());
    }

    public String getSVGImage(GameCharacter character) {
        if (this.isGlowing()) {
            return this.getSVGGlow() + "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;padding:0;margin:0'>" + this.type.getSVGImage(character, this.primaryColour, this.secondaryColour, this.tertiaryColour) + "</div>";
        }
        return this.type.getSVGImage(character, this.primaryColour, this.secondaryColour, this.tertiaryColour);
    }

    private String getSVGGlow() {
        String stringFromMap = SVGGlowMap.get(this.getPrimaryColour());
        if (stringFromMap != null) {
            return stringFromMap;
        }
        try {
            InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/tattoos/glow.svg");
            String s = Util.inputStreamToString(is);
            is.close();
            s = SvgUtil.colourReplacement("tattooGlow" + this.getPrimaryColour().getId(), this.getPrimaryColour(), this.getPrimaryColour(), this.getPrimaryColour(), s);
            SVGGlowMap.put(this.getPrimaryColour(), s);
            return s;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public Rarity getRarity() {
        if (this.effects.isEmpty()) {
            return Rarity.COMMON;
        }
        if (this.effects.size() <= 1) {
            return Rarity.UNCOMMON;
        }
        if (this.effects.size() <= 3) {
            return Rarity.RARE;
        }
        if (this.effects.size() <= 5) {
            return Rarity.EPIC;
        }
        return Rarity.LEGENDARY;
    }

    @Override
    public String getDisplayName(boolean withRarityColour) {
        String baseName = this.getName();
        if (baseName.trim().isEmpty()) {
            baseName = this.getType().getName();
        }
        if (!baseName.replaceAll("\u00a0", " ").equalsIgnoreCase(this.getType().getName().replaceAll("\u00a0", " "))) {
            return withRarityColour ? "<span style='color: " + this.getRarity().getColour().toWebHexString() + ";'>" + baseName + "</span>" : baseName;
        }
        return Util.capitaliseSentence(this.getPrimaryColour().getName()) + (String)(withRarityColour ? "<span style='color: " + this.getRarity().getColour().toWebHexString() + ";'>" : "") + (String)(this.getType() == TattooType.getTattooTypeFromId("innoxia_misc_none") ? "\u7eb9\u8eab" : baseName + "\u7eb9\u8eab") + (withRarityColour ? "</span>" : "") + (!this.getEffects().isEmpty() ? this.getEnchantmentPostfix(withRarityColour, "b") : "");
    }

    public String getEnchantmentPostfix(boolean coloured, String tag) {
        Iterator<ItemEffect> iterator;
        if (!this.getEffects().isEmpty() && (iterator = this.getEffects().iterator()).hasNext()) {
            ItemEffect ie = iterator.next();
            if (ie.getSecondaryModifier() == TFModifier.CLOTHING_ENSLAVEMENT) {
                return "(" + (String)(coloured ? "<" + tag + " style='color:" + TFModifier.CLOTHING_ENSLAVEMENT.getColour().toWebHexString() + ";'>\u5974\u5f79</" + tag + ">" : "\u5974\u5f79") + "\u9644\u9b54)";
            }
            if (ie.getSecondaryModifier() == TFModifier.CLOTHING_SERVITUDE) {
                return "(" + (String)(coloured ? "<" + tag + " style='color:" + TFModifier.CLOTHING_SERVITUDE.getColour().toWebHexString() + ";'>\u4ec6\u5f79</" + tag + ">" : "\u4ec6\u5f79") + "\u9644\u9b54)";
            }
            if (ie.getPrimaryModifier() == TFModifier.TF_MOD_FETISH_BEHAVIOUR || ie.getPrimaryModifier() == TFModifier.TF_MOD_FETISH_BODY_PART) {
                return "(" + (String)(coloured ? "<" + tag + " style='color:" + PresetColour.FETISH.toWebHexString() + ";'>" + ie.getSecondaryModifier().getDescriptor() + "</" + tag + ">" : ie.getSecondaryModifier().getDescriptor()) + "\u9644\u9b54)";
            }
            if (ie.getPrimaryModifier() == TFModifier.CLOTHING_ATTRIBUTE) {
                String name = this.isBadEnchantment() ? this.getCoreEnchantment().getNegativeEnchantment() : this.getCoreEnchantment().getPositiveEnchantment();
                return "(" + (String)(coloured ? "<" + tag + " style='color:" + this.getCoreEnchantment().getColour().toWebHexString() + ";'>" + name + "</" + tag + ">" : name) + "\u9644\u9b54)";
            }
            if (ie.getSecondaryModifier() == TFModifier.CLOTHING_SEALING) {
                return "(" + (String)(coloured ? "<" + tag + " style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u5c01\u5370</" + tag + ">" : "\u5c01\u5370") + "\u9644\u9b54)";
            }
            if (ie.getPrimaryModifier() == TFModifier.CLOTHING_CREAMPIE_RETENTION) {
                return "(" + (String)(coloured ? "<" + tag + " style='color:" + PresetColour.CUM.toWebHexString() + ";'>\u5c01\u5835</" + tag + ">" : "\u5c01\u5835") + "\u9644\u9b54)";
            }
            return "(" + (String)(coloured ? "<" + tag + " style='color:" + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u8f6c\u5316</" + tag + ">" : "\u8f6c\u5316") + "\u9644\u9b54)";
        }
        return "";
    }

    public AbstractAttribute getCoreEnchantment() {
        AbstractAttribute att = Attribute.MAJOR_PHYSIQUE;
        int max = 0;
        for (Map.Entry<AbstractAttribute, Integer> entry : this.getAttributeModifiers().entrySet()) {
            if (entry.getValue() <= max) continue;
            att = entry.getKey();
            max = entry.getValue();
        }
        return att;
    }

    public boolean isBadEnchantment() {
        return this.getEffects().stream().mapToInt(e -> (e.getPrimaryModifier() == TFModifier.CLOTHING_ATTRIBUTE || e.getPrimaryModifier() == TFModifier.CLOTHING_MAJOR_ATTRIBUTE ? e.getPotency().getClothingBonusValue() * (e.getSecondaryModifier() == TFModifier.CORRUPTION ? -1 : 1) : 0) + (e.getSecondaryModifier() == TFModifier.CLOTHING_SEALING ? -10 : 0) + (e.getSecondaryModifier() == TFModifier.CLOTHING_SERVITUDE ? -10 : 0)).sum() < 0;
    }

    public boolean isSelfTransformationInhibiting() {
        return this.getEffects().stream().anyMatch(e -> e.getSecondaryModifier() == TFModifier.CLOTHING_SERVITUDE);
    }

    public boolean isJinxRemovalInhibiting() {
        return this.getEffects().stream().anyMatch(e -> e.getSecondaryModifier() == TFModifier.CLOTHING_SERVITUDE);
    }

    @Override
    public Map<AbstractAttribute, Integer> getAttributeModifiers() {
        this.attributeModifiers.clear();
        for (ItemEffect ie : this.getEffects()) {
            if (ie.getPrimaryModifier() != TFModifier.CLOTHING_ATTRIBUTE && ie.getPrimaryModifier() != TFModifier.CLOTHING_MAJOR_ATTRIBUTE) continue;
            if (this.attributeModifiers.containsKey(ie.getSecondaryModifier().getAssociatedAttribute())) {
                this.attributeModifiers.put(ie.getSecondaryModifier().getAssociatedAttribute(), this.attributeModifiers.get(ie.getSecondaryModifier().getAssociatedAttribute()) + ie.getPotency().getClothingBonusValue());
                continue;
            }
            this.attributeModifiers.put(ie.getSecondaryModifier().getAssociatedAttribute(), ie.getPotency().getClothingBonusValue());
        }
        return this.attributeModifiers;
    }

    public int getEnchantmentCapacityCost() {
        HashMap noCorruption = new HashMap();
        this.attributeModifiers.entrySet().stream().filter(ent -> ent.getKey() != Attribute.MAJOR_CORRUPTION && ent.getKey() != Attribute.FERTILITY && ent.getKey() != Attribute.VIRILITY).forEach(ent -> noCorruption.put((AbstractAttribute)ent.getKey(), (Integer)ent.getValue()));
        return noCorruption.values().stream().reduce(0, (a, b) -> a + Math.max(0, b));
    }

    public AbstractTattooType getType() {
        return this.type;
    }

    private void sortEffects() {
        Collections.sort(this.effects, new ItemEffectComparator());
    }

    @Override
    public List<ItemEffect> getEffects() {
        if (this.effects.hashCode() != this.effectsHashCode) {
            this.sortEffects();
            this.effectsHashCode = this.effects.hashCode();
        }
        return this.effects;
    }

    public void setEffects(List<ItemEffect> effects) {
        this.effects = new ArrayList<ItemEffect>(effects);
    }

    public void addEffect(ItemEffect effect) {
        this.effects.add(effect);
    }

    public Colour getPrimaryColour() {
        return this.primaryColour;
    }

    public Colour getSecondaryColour() {
        return this.secondaryColour;
    }

    public Colour getTertiaryColour() {
        return this.tertiaryColour;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public TattooWriting getWriting() {
        return this.writing;
    }

    public void setWriting(TattooWriting writing) {
        this.writing = writing;
    }

    public void setWriting(String text, Colour colour, boolean glow, TattooWritingStyle ... styles) {
        this.writing = new TattooWriting(text, colour, glow, styles);
    }

    public String getFormattedWritingOutput() {
        return this.getFormattedWritingOutput(this.getWriting().getText());
    }

    public String getFormattedWritingOutput(String input) {
        StringBuilder sb = new StringBuilder();
        if (this.getWriting().getStyles().contains((Object)TattooWritingStyle.BOLD)) {
            sb.append("<b>");
        }
        if (this.getWriting().getStyles().contains((Object)TattooWritingStyle.ITALICISED)) {
            sb.append("<i>");
        }
        sb.append("<span style='color:" + this.getWriting().getColour().toWebHexString() + ";'>");
        sb.append(this.getWriting().isGlow() ? UtilText.applyGlow(input, this.getWriting().getColour()) : input);
        sb.append("</span>");
        if (this.getWriting().getStyles().contains((Object)TattooWritingStyle.ITALICISED)) {
            sb.append("</i>");
        }
        if (this.getWriting().getStyles().contains((Object)TattooWritingStyle.BOLD)) {
            sb.append("</b>");
        }
        return sb.toString();
    }

    public TattooCounter getCounter() {
        return this.counter;
    }

    public void setCounter(TattooCounter counter) {
        this.counter = counter;
    }

    public void setCounter(TattooCounterType type, TattooCountType countType, Colour colour, boolean glow, int retroactiveApplicationOffset) {
        this.counter = new TattooCounter(type, countType, colour, glow, retroactiveApplicationOffset);
    }

    public void setCounter(TattooCounterType type, TattooCountType countType, Colour colour, boolean glow, GameCharacter bearer) {
        this.counter = new TattooCounter(type, countType, colour, glow, bearer);
    }

    public String getFormattedCounterOutput(int input) {
        return "<span style='color:" + this.getCounter().getColour().toWebHexString() + ";'>" + (this.getCounter().isGlow() ? UtilText.applyGlow(this.getCounter().getCountType().convertInt(input), this.getCounter().getColour()) : this.getCounter().getCountType().convertInt(input)) + "</span>";
    }

    public String getFormattedCounterOutput(GameCharacter equippedToCharacter) {
        String convertedInt = this.getCounter().getCountType().convertInt(this.getCounter().getType().getCount(equippedToCharacter) + this.getCounter().getRetroactiveApplicationOffset());
        return "<span style='color:" + this.getCounter().getColour().toWebHexString() + ";'>" + (this.getCounter().isGlow() ? UtilText.applyGlow(convertedInt, this.getCounter().getColour()) : convertedInt) + "</span>";
    }

    public void setType(AbstractTattooType type) {
        this.type = type;
    }

    public void setPrimaryColour(Colour primaryColour) {
        this.primaryColour = primaryColour;
    }

    public void setSecondaryColour(Colour secondaryColour) {
        this.secondaryColour = secondaryColour;
    }

    public void setTertiaryColour(Colour tertiaryColour) {
        this.tertiaryColour = tertiaryColour;
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
    }

    @Override
    public String getDescription(GameCharacter characterEquippedOn) {
        return UtilText.parse(characterEquippedOn, this.getType().getDescription(), new ParserTag[0]);
    }

    public String getBodyOverviewDescription() {
        return this.getType().getBodyOverviewDescription();
    }

    @Override
    public int getValue() {
        return this.getType().getValue();
    }

    @Override
    public int getEnchantmentLimit() {
        return this.getType().getEnchantmentLimit();
    }

    @Override
    public AbstractItemEffectType getEnchantmentEffect() {
        return ItemEffectType.TATTOO;
    }

    @Override
    public AbstractTattooType getEnchantmentItemType(List<ItemEffect> effects) {
        return this.getType();
    }
}

