/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.markings;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.markings.AbstractTattooType;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TattooType {
    private static Map<AbstractTattooType, String> tattooToIdMap;
    private static Map<String, AbstractTattooType> idToTattooMap;

    public static AbstractTattooType getTattooTypeFromId(String id) {
        if (id.equalsIgnoreCase("NONE")) {
            id = "innoxia_misc_none";
        } else if (id.equalsIgnoreCase("FLOWERS")) {
            id = "innoxia_plant_flowers";
        } else if (id.equalsIgnoreCase("TRIBAL")) {
            id = "innoxia_symbol_tribal";
        } else if (id.equalsIgnoreCase("BUTTERFLIES")) {
            id = "innoxia_animal_butterflies";
        } else if (id.equalsIgnoreCase("LINES")) {
            id = "innoxia_symbol_lines";
        }
        id = Util.getClosestStringMatch(id, idToTattooMap.keySet());
        return idToTattooMap.get(id);
    }

    public static String getIdFromTattooType(AbstractTattooType tattooType) {
        return tattooToIdMap.get(tattooType);
    }

    public static List<AbstractTattooType> getConditionalTattooTypes(GameCharacter target) {
        List<AbstractTattooType> tattoos = TattooType.getAllTattooTypes();
        tattoos.removeIf(tattoo -> !tattoo.isAvailable(target));
        return tattoos;
    }

    public static List<AbstractTattooType> getAllTattooTypes() {
        ArrayList<AbstractTattooType> allTattoos = new ArrayList<AbstractTattooType>(tattooToIdMap.keySet());
        AbstractTattooType typeNone = TattooType.getTattooTypeFromId("innoxia_misc_none");
        allTattoos.sort((t1, t2) -> t1.equals(t2) ? 0 : (t1.equals(typeNone) ? -1 : (t2.equals(typeNone) ? 1 : t1.getId().compareTo(t2.getId()))));
        return allTattoos;
    }

    static {
        Field[] fieldArray;
        tattooToIdMap = new HashMap<AbstractTattooType, String>();
        idToTattooMap = new HashMap<String, AbstractTattooType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/items/tattoos");
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                try {
                    AbstractTattooType tattoo = new AbstractTattooType(innerEntry.getValue()){};
                    tattooToIdMap.put(tattoo, innerEntry.getKey());
                    idToTattooMap.put(innerEntry.getKey(), tattoo);
                }
                catch (Exception ex) {
                    System.err.println("Loading modded tattoo failed at 'TattooType'. File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/tattoos");
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                try {
                    AbstractTattooType tattoo = new AbstractTattooType(innerEntry.getValue()){};
                    tattooToIdMap.put(tattoo, innerEntry.getKey());
                    idToTattooMap.put(innerEntry.getKey(), tattoo);
                }
                catch (Exception ex) {
                    System.err.println("Loading tattoo failed at 'TattooType'. File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = TattooType.class.getFields()) {
            if (!AbstractTattooType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractTattooType ct = (AbstractTattooType)f.get(null);
                tattooToIdMap.put(ct, f.getName());
                idToTattooMap.put(f.getName(), ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

