/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.Game;
import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.PlayerCharacter;
import com.lilithsthrone.game.character.attributes.AffectionLevel;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.attributes.CorruptionLevel;
import com.lilithsthrone.game.character.attributes.ObedienceLevel;
import com.lilithsthrone.game.character.attributes.ObedienceLevelBasic;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.types.AntennaType;
import com.lilithsthrone.game.character.body.types.BreastType;
import com.lilithsthrone.game.character.body.types.HornType;
import com.lilithsthrone.game.character.body.types.PenisType;
import com.lilithsthrone.game.character.body.types.TailType;
import com.lilithsthrone.game.character.body.types.VaginaType;
import com.lilithsthrone.game.character.body.types.WingType;
import com.lilithsthrone.game.character.body.valueEnums.AssSize;
import com.lilithsthrone.game.character.body.valueEnums.BodyMaterial;
import com.lilithsthrone.game.character.body.valueEnums.BodySize;
import com.lilithsthrone.game.character.body.valueEnums.CumProduction;
import com.lilithsthrone.game.character.body.valueEnums.CupSize;
import com.lilithsthrone.game.character.body.valueEnums.Femininity;
import com.lilithsthrone.game.character.body.valueEnums.HipSize;
import com.lilithsthrone.game.character.body.valueEnums.LipSize;
import com.lilithsthrone.game.character.body.valueEnums.Muscle;
import com.lilithsthrone.game.character.body.valueEnums.OrificeModifier;
import com.lilithsthrone.game.character.body.valueEnums.PenisLength;
import com.lilithsthrone.game.character.body.valueEnums.TesticleSize;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.fetishes.FetishDesire;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.gender.PronounType;
import com.lilithsthrone.game.character.npc.NPCFlagValue;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.npc.dominion.ReindeerOverseer;
import com.lilithsthrone.game.character.npc.misc.Elemental;
import com.lilithsthrone.game.character.npc.misc.GenericAndrogynousNPC;
import com.lilithsthrone.game.character.npc.misc.GenericFemaleNPC;
import com.lilithsthrone.game.character.npc.misc.GenericMaleNPC;
import com.lilithsthrone.game.character.npc.misc.NPCOffspring;
import com.lilithsthrone.game.character.npc.misc.PrologueFemale;
import com.lilithsthrone.game.character.npc.misc.PrologueMale;
import com.lilithsthrone.game.character.persona.NameTriplet;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.persona.Relationship;
import com.lilithsthrone.game.character.pregnancy.Litter;
import com.lilithsthrone.game.character.pregnancy.PregnancyPossibility;
import com.lilithsthrone.game.character.race.AbstractRacialBody;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.FurryPreference;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.SetBonus;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.PossibleItemEffect;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.AbstractPotion;
import com.lilithsthrone.game.inventory.item.FetishPotion;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.item.TransformativePotion;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJob;
import com.lilithsthrone.game.settings.ForcedTFTendency;
import com.lilithsthrone.game.sex.SexAreaOrifice;
import com.lilithsthrone.game.sex.SexAreaPenetration;
import com.lilithsthrone.game.sex.SexControl;
import com.lilithsthrone.game.sex.SexPace;
import com.lilithsthrone.game.sex.SexType;
import com.lilithsthrone.game.sex.positions.AbstractSexPosition;
import com.lilithsthrone.game.sex.positions.slots.SexSlot;
import com.lilithsthrone.game.sex.positions.slots.SexSlotGeneric;
import com.lilithsthrone.game.sex.sexActions.SexAction;
import com.lilithsthrone.game.sex.sexActions.SexActionInterface;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class NPC
extends GameCharacter
implements XMLSaving {
    protected long lastTimeEncountered = -1L;
    protected int playerSurrenderCount = 0;
    protected float buyModifier;
    protected float sellModifier;
    protected boolean addedToContacts;
    public Set<NPCFlagValue> NPCFlagValues;
    protected Set<SexSlot> sexPositionPreferences;
    protected Gender genderPreference = null;
    protected AbstractSubspecies subspeciesPreference = null;
    protected RaceStage raceStagePreference = null;
    protected boolean generateExtraItems;
    protected boolean generateDisposableClothing;
    protected boolean generateExtraClothing;
    private TransformativePotion potion = null;
    private FetishPotion fetishPotion = null;

    protected NPC(boolean isImported, NameTriplet nameTriplet, String surname, String description, int age, Month birthMonth, int birthDay, int level, Gender startingGender, AbstractSubspecies startingSubspecies, RaceStage stage, CharacterInventory inventory, AbstractWorldType worldLocation, AbstractPlaceType startingPlace, boolean addedToContacts, NPCGenerationFlag ... generationFlags) {
        super(nameTriplet, surname, description, level, age < 18 ? LocalDateTime.of(Main.game.getStartingDate().getYear() - age, birthMonth, birthMonth == Month.FEBRUARY && birthDay == 29 ? 28 : birthDay, 12, 0) : LocalDateTime.of(Main.game.getStartingDate().getYear() - (age - 18), birthMonth, birthMonth == Month.FEBRUARY && birthDay == 29 ? 28 : birthDay, 12, 0), startingGender, startingSubspecies, stage, inventory, worldLocation, startingPlace);
        List<NPCGenerationFlag> flags = Arrays.asList(generationFlags);
        this.addedToContacts = addedToContacts;
        this.generateExtraItems = false;
        this.generateDisposableClothing = false;
        this.generateExtraClothing = false;
        this.sexPositionPreferences = new HashSet<SexSlot>();
        this.buyModifier = 0.75f;
        this.sellModifier = 1.5f;
        this.NPCFlagValues = new HashSet<NPCFlagValue>();
        if (!isImported) {
            this.setStartingBody(true);
            if (!flags.contains((Object)NPCGenerationFlag.NO_CLOTHING_EQUIP) && this.getBody() != null) {
                this.equipClothing(EquipClothingSetting.getAllClothingSettings());
            }
        }
        if (this.getBody() != null) {
            if (this.getLocation().equals(Main.game.getPlayer().getLocation()) && this.getWorldLocation() == Main.game.getPlayer().getWorldLocation()) {
                for (CoverableArea ca : CoverableArea.values()) {
                    if (!this.isCoverableAreaVisible(ca) || ca == CoverableArea.MOUTH) continue;
                    this.setAreaKnownByCharacter(ca, Main.game.getPlayer(), true);
                }
            }
            if (!isImported || Main.isVersionOlderThan(Game.loadingVersion, "0.3.3.5")) {
                this.setStartingCombatMoves();
            }
            this.loadImages();
        }
    }

    public void setStartingCombatMoves() {
        this.resetDefaultMoves();
    }

    public abstract void setStartingBody(boolean var1);

    public final void equipClothing() {
        this.equipClothing(new ArrayList<EquipClothingSetting>());
    }

    public void equipClothing(List<EquipClothingSetting> settings) {
        Main.game.getCharacterUtils().equipClothingFromOutfit(this, null, settings);
    }

    protected void resetBodyAfterVersion_2_10_5() {
        CupSize size = this.getBreastSize();
        float milkStorage = this.getBreastRawMilkStorageValue();
        float milkStored = this.getBreastRawStoredMilkValue();
        this.setStartingBody(true);
        this.equipClothing(EquipClothingSetting.getAllClothingSettings());
        this.setBreastSize(size.getMeasurement());
        this.setBreastMilkStorage((int)milkStorage);
        this.setBreastStoredMilk(milkStored);
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element properties = super.saveAsXML(parentElement, doc);
        Element npcSpecific = doc.createElement("npcSpecific");
        properties.appendChild(npcSpecific);
        XMLUtil.createXMLElementWithValue(doc, npcSpecific, "lastTimeEncountered", String.valueOf(this.lastTimeEncountered));
        XMLUtil.createXMLElementWithValue(doc, npcSpecific, "buyModifier", String.valueOf(this.buyModifier));
        XMLUtil.createXMLElementWithValue(doc, npcSpecific, "sellModifier", String.valueOf(this.sellModifier));
        XMLUtil.createXMLElementWithValue(doc, npcSpecific, "playerSurrenderCount", String.valueOf(this.playerSurrenderCount));
        XMLUtil.createXMLElementWithValue(doc, npcSpecific, "addedToContacts", String.valueOf(this.addedToContacts));
        XMLUtil.createXMLElementWithValue(doc, npcSpecific, "generateExtraItems", String.valueOf(this.generateExtraItems));
        XMLUtil.createXMLElementWithValue(doc, npcSpecific, "generateDisposableClothing", String.valueOf(this.generateDisposableClothing));
        XMLUtil.createXMLElementWithValue(doc, npcSpecific, "generateExtraClothing", String.valueOf(this.generateExtraClothing));
        Element valuesElement = doc.createElement("NPCValues");
        npcSpecific.appendChild(valuesElement);
        for (NPCFlagValue value : this.NPCFlagValues) {
            XMLUtil.createXMLElementWithValue(doc, valuesElement, "NPCValue", value.toString());
        }
        if (this.genderPreference != null) {
            XMLUtil.createXMLElementWithValue(doc, npcSpecific, "genderPreference", String.valueOf((Object)this.genderPreference));
            XMLUtil.createXMLElementWithValue(doc, npcSpecific, "subspeciesPreference", Subspecies.getIdFromSubspecies(this.subspeciesPreference));
            XMLUtil.createXMLElementWithValue(doc, npcSpecific, "raceStagePreference", String.valueOf((Object)this.raceStagePreference));
        }
        return properties;
    }

    public abstract void loadFromXML(Element var1, Document var2, CharacterImportSetting ... var3);

    public static void loadNPCVariablesFromXML(NPC npc, StringBuilder log, Element parentElement, Document doc, CharacterImportSetting ... settings) {
        GameCharacter.loadGameCharacterVariablesFromXML(npc, log, parentElement, doc, settings);
        Element npcSpecificElement = (Element)parentElement.getElementsByTagName("npcSpecific").item(0);
        if (npcSpecificElement != null) {
            npc.setLastTimeEncountered(Long.valueOf(((Element)npcSpecificElement.getElementsByTagName("lastTimeEncountered").item(0)).getAttribute("value")));
            npc.setBuyModifier(Float.valueOf(((Element)npcSpecificElement.getElementsByTagName("buyModifier").item(0)).getAttribute("value")).floatValue());
            npc.setSellModifier(Float.valueOf(((Element)npcSpecificElement.getElementsByTagName("sellModifier").item(0)).getAttribute("value")).floatValue());
            if ((Element)npcSpecificElement.getElementsByTagName("playerSurrenderCount").item(0) != null) {
                npc.playerSurrenderCount = Integer.valueOf(((Element)npcSpecificElement.getElementsByTagName("playerSurrenderCount").item(0)).getAttribute("value"));
            }
            npc.addedToContacts = Boolean.valueOf(((Element)npcSpecificElement.getElementsByTagName("addedToContacts").item(0)).getAttribute("value"));
            if ((Element)npcSpecificElement.getElementsByTagName("generateExtraItems").item(0) != null) {
                npc.generateExtraItems = Boolean.valueOf(((Element)npcSpecificElement.getElementsByTagName("generateExtraItems").item(0)).getAttribute("value"));
            }
            if ((Element)npcSpecificElement.getElementsByTagName("generateDisposableClothing").item(0) != null) {
                npc.generateDisposableClothing = Boolean.valueOf(((Element)npcSpecificElement.getElementsByTagName("generateDisposableClothing").item(0)).getAttribute("value"));
            }
            if ((Element)npcSpecificElement.getElementsByTagName("generateExtraClothing").item(0) != null) {
                npc.generateExtraClothing = Boolean.valueOf(((Element)npcSpecificElement.getElementsByTagName("generateExtraClothing").item(0)).getAttribute("value"));
            }
            NodeList npcValues = ((Element)npcSpecificElement.getElementsByTagName("NPCValues").item(0)).getElementsByTagName("NPCValue");
            for (int i = 0; i < npcValues.getLength(); ++i) {
                Element e = (Element)npcValues.item(i);
                try {
                    npc.NPCFlagValues.add(NPCFlagValue.valueOf(e.getAttribute("value")));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                npc.genderPreference = Gender.valueOf(((Element)npcSpecificElement.getElementsByTagName("genderPreference").item(0)).getAttribute("value"));
                npc.subspeciesPreference = Subspecies.getSubspeciesFromId(((Element)npcSpecificElement.getElementsByTagName("subspeciesPreference").item(0)).getAttribute("value"));
                npc.raceStagePreference = RaceStage.valueOf(((Element)npcSpecificElement.getElementsByTagName("raceStagePreference").item(0)).getAttribute("value"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        npc.getBody().setFleshSubspecies(null);
    }

    public void resetSlaveFlags() {
        for (NPCFlagValue flag : NPCFlagValue.getSlaveFlags()) {
            this.NPCFlagValues.remove((Object)flag);
        }
    }

    public void resetOccupantFlags() {
        for (NPCFlagValue flag : NPCFlagValue.getOccupantFlags()) {
            this.NPCFlagValues.remove((Object)flag);
        }
    }

    public void dailyUpdate() {
    }

    public void hourlyUpdate() {
        this.hourlyUpdate(Main.game.getHourOfDay());
    }

    public void hourlyUpdate(int hour) {
    }

    public void turnUpdate() {
    }

    public abstract void changeFurryLevel();

    public abstract DialogueNode getEncounterDialogue();

    public int getPlayerSurrenderCount() {
        return this.playerSurrenderCount;
    }

    public void setPlayerSurrenderCount(int playerSurrenderCount) {
        this.playerSurrenderCount = playerSurrenderCount;
    }

    public void incrementPlayerSurrenderCount(int increment) {
        this.setPlayerSurrenderCount(this.getPlayerSurrenderCount() + increment);
    }

    public boolean isClothingStealable() {
        return false;
    }

    public Util.Value<Boolean, String> isInventoryEquipAllowed(AbstractClothing clothing, InventorySlot slotToEquipTo) {
        if (this.isSlave() && this.getOwner().isPlayer() || clothing.isCondom(slotToEquipTo)) {
            return new Util.Value<Boolean, String>(true, "");
        }
        if (this.isUnique() && !clothing.isCondom(slotToEquipTo)) {
            return new Util.Value<Boolean, CallSite>(false, (CallSite)((Object)("\u7531\u4e8e[npc.name]\u662f\u7279\u6b8a\u89d2\u8272\uff0c\u4e0d\u80fd\u6210\u4e3a\u4f60\u7684\u5974\u96b6\uff0c\u4f60\u65e0\u6cd5\u5f3a\u5236[npc.herHim]\u88c5\u5907" + clothing.getName() + "\uff01")));
        }
        if (Main.game.isInSex() && (Main.sex.isDom(this) || Main.sex.isSubHasEqualControl())) {
            return new Util.Value<Boolean, CallSite>(false, (CallSite)((Object)("[npc.Name]\u5bf9\u4e8e\u88c5\u5907" + clothing.getName() + "\u5e76\u4e0d\u611f\u5174\u8da3\uff01")));
        }
        return new Util.Value<Boolean, String>(true, "");
    }

    public String getPresentInTileDescription(boolean inHiding) {
        StringBuilder tileSB = new StringBuilder();
        tileSB.append("<p style='text-align:center;'><i>");
        if (!this.isRaceConcealed()) {
            tileSB.append((this.isPlayerKnowsName() ? "[npc.Name]\uff0c[npc.a_femininity(true)]\u7684[npc.raceStage(true)][npc.race(true)]\uff0c" : "[npc.A_femininity(true)]\u7684[npc.raceStage(true)][npc.race(true)]") + "\u6b63" + (inHiding ? "[style.boldBad(\u6f5c\u4f0f)]" : "\u6e38\u8361") + "\u4e8e\u8be5\u533a\u57df\uff01");
        } else {
            tileSB.append("\u67d0\u4eba\u6216\u67d0\u7269\u6b63" + (inHiding ? "[style.boldBad(\u9690\u85cf)]" : "\u6e38\u8361") + "\u4e8e\u8be5\u533a\u57df\uff01");
        }
        if (this.getFoughtPlayerCount() > 0) {
            tileSB.append("<br/>");
            tileSB.append("\u4f60\u5df2\u7ecf[style.colourCombat(\u4e0e[npc.herHim]\u6218\u6597\u8fc7" + Util.intToCount(this.getFoughtPlayerCount()) + ")]");
            if (this.getFoughtPlayerCount() == this.getLostCombatCount()) {
                if (this.getLostCombatCount() == 1) {
                    tileSB.append("\uff0c\u5e76\u4e14[style.colourGood(\u80dc\u5229\u4e86)]\u3002");
                } else if (this.getLostCombatCount() == 2) {
                    tileSB.append("\uff0c\u4f60[style.colourMinorGood(\u4e24\u6b21)][style.colourGood(\u90fd\u80dc\u5229\u4e86)]\u3002");
                } else {
                    tileSB.append("\uff0c\u4f60[style.colourMinorGood(\u6bcf\u6b21)][style.colourGood(\u90fd\u80dc\u5229\u4e86)]\u3002");
                }
            } else if (this.getFoughtPlayerCount() == this.getWonCombatCount()) {
                if (this.getWonCombatCount() == 1) {
                    tileSB.append("\u5e76\u4e14[style.colourBad(\u6218\u8d25\u4e86)]\u3002");
                } else if (this.getWonCombatCount() == 2) {
                    tileSB.append("[style.colourMinorBad(\u4e24\u6b21)][style.colourBad(\u90fd\u6218\u8d25\u4e86)]\u3002");
                } else {
                    tileSB.append("[style.colourMinorBad(\u6bcf\u6b21)][style.colourBad(\u90fd\u6218\u8d25\u4e86)]\u3002");
                }
            } else {
                tileSB.append("\uff0c\u4f60[style.colourGood(\u6218\u80dc\u4e86)][style.colourMinorGood(" + Util.intToCount(this.getLostCombatCount()) + ")]");
                tileSB.append("\u4e14[style.colourBad(\u6218\u8d25\u4e86)][style.colourMinorBad(" + Util.intToCount(this.getWonCombatCount()) + ")]\u3002");
            }
        }
        if (this.getTotalTimesHadSex(Main.game.getPlayer()) > 0) {
            if (this.getSexAsDomCount(Main.game.getPlayer()) > 0) {
                tileSB.append("<br/>");
                tileSB.append("\u4f60\u5df2\u7ecf\u8ddf[npc.herHim]\u8fdb\u884c\u8fc7<span style='color:" + PresetColour.GENERIC_SEX.toWebHexString() + ";'>\u670d\u4ece\u578b\u6027\u7231</span>");
                tileSB.append(Util.intToCount(this.getSexAsDomCount(Main.game.getPlayer())) + "\u3002");
            }
            if (this.getSexAsSubCount(Main.game.getPlayer()) > 0) {
                tileSB.append("<br/>");
                tileSB.append("\u4f60\u5df2\u7ecf\u8ddf[npc.herHim]\u8fdb\u884c\u8fc7<span style='color:" + PresetColour.GENERIC_SEX_AS_DOM.toWebHexString() + ";'>\u652f\u914d\u578b\u6027\u7231</span>");
                tileSB.append(Util.intToCount(this.getSexAsSubCount(Main.game.getPlayer())) + "\u3002");
            }
        }
        if (this.getPlayerSurrenderCount() == 3) {
            tileSB.append("<br/>");
            tileSB.append("[npc.She]\u4e0b\u6b21\u518d\u89c1\u5230\u4f60\u65f6\uff0c\u4f1a\u8981\u6c42\u4f60<span style='color:" + PresetColour.GENERIC_SEX.toWebHexString() + ";'>\u5411[npc.her]\u81e3\u670d\u5e76\u4e14\u505a[npc.her]\u7684\u6bcd\u72d7</span>\uff01");
        } else if (this.getPlayerSurrenderCount() > 3) {
            tileSB.append("<br/>");
            tileSB.append("\u4f60\u5df2\u7ecf<span style='color:" + PresetColour.GENERIC_SEX.toWebHexString() + ";'>\u5411[npc.her]\u81e3\u670d\uff0c\u5e76\u4e14\u505a\u4e86[npc.her]\u7684\u6bcd\u72d7</span>\uff01");
        }
        tileSB.append("</i></p>");
        return UtilText.parse((GameCharacter)this, tileSB.toString(), new ParserTag[0]);
    }

    public String getPresentInTileDescription() {
        return this.getPresentInTileDescription(false);
    }

    public String getPlayerRelationStatusDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.isRelatedTo(Main.game.getPlayer(), new Relationship[0])) {
            sb.append("<p style='text-align:center;'><i>");
            AffectionLevel al = this.getAffectionLevel(Main.game.getPlayer());
            switch (al) {
                case NEGATIVE_FIVE_LOATHE: 
                case NEGATIVE_FOUR_HATE: 
                case NEGATIVE_THREE_STRONG_DISLIKE: 
                case NEGATIVE_TWO_DISLIKE: 
                case NEGATIVE_ONE_ANNOYED: 
                case ZERO_NEUTRAL: {
                    break;
                }
                case POSITIVE_ONE_FRIENDLY: {
                    if (this.isAttractedTo(Main.game.getPlayer()) && Main.game.isIncestEnabled()) {
                        sb.append("\u5bf9\u4e8e\u4f60\uff0c[npc.Name]\u6446\u51fa\u4e00\u526f<i style='color:" + al.getColour().toWebHexString() + ";'>\u53cb\u5584</i>\u3001[style.italicsSex(\u6311\u9017)]\u7684\u59ff\u6001\u3002");
                        break;
                    }
                    sb.append("\u5bf9\u4e8e\u4f60\uff0c[npc.Name]\u6446\u51fa\u4e00\u526f<i style='color:" + al.getColour().toWebHexString() + ";'>\u53cb\u5584</i>\u7684\u59ff\u6001\u3002");
                    break;
                }
                case POSITIVE_TWO_LIKE: {
                    if (this.isAttractedTo(Main.game.getPlayer()) && Main.game.isIncestEnabled()) {
                        sb.append("[npc.Name]\u5f88\u660e\u663e<i style='color:" + al.getColour().toWebHexString() + ";'>\u559c\u6b22\u4f60</i>\uff0c\u800c\u4e14[style.italicsSex(\u4e0d\u4ec5\u4ec5\u5c06\u4f60\u89c6\u4f5c[npc.her]\u7684[pc.relation(npc)])]\u3002");
                        break;
                    }
                    sb.append("[npc.Name]\u5f88\u660e\u663e<i style='color:" + al.getColour().toWebHexString() + ";'>\u559c\u6b22\u4f60</i>\uff0c\u800c\u4e14\u5f88\u9ad8\u5174\u6709\u4f60\u8fd9\u6837\u4e00\u4e2a[pc.relation(npc)]\u3002");
                    break;
                }
                case POSITIVE_THREE_CARING: {
                    if (this.isAttractedTo(Main.game.getPlayer()) && Main.game.isIncestEnabled()) {
                        sb.append("[npc.Name]\u660e\u663e<i style='color:" + al.getColour().toWebHexString() + ";'>\u5f88\u5728\u4e4e\u4f60</i>\uff0c\u88ab\u4f60[style.italicsSex(\u6df1\u6df1\u5438\u5f15)]\u3002");
                        break;
                    }
                    sb.append("[npc.Name]\u660e\u663e<i style='color:" + al.getColour().toWebHexString() + ";'>\u5f88\u5728\u4e4e\u4f60</i>\uff0c\u5e76\u4e14\u4e0d\u6562\u5962\u6c42\u6bd4\u4f60\u66f4\u597d\u7684[pc.relation(npc)]\u4e86\u3002");
                    break;
                }
                case POSITIVE_FOUR_LOVE: {
                    if (this.isAttractedTo(Main.game.getPlayer()) && Main.game.isIncestEnabled()) {
                        sb.append("\u4ece[npc.Name]\u7684\u884c\u4e3a\u4e0a\u6765\u770b\uff0c[npc.she]\u5f88\u660e\u663e<i style='color:" + al.getColour().toWebHexString() + ";'>\u7231\u4e0a\u4e86\u4f60</i>\uff0c\u4ea7\u751f\u4e86[style.italicsSex(\u7231\u60c5)]\u3002");
                        break;
                    }
                    sb.append("\u4ece[npc.Name]\u7684\u884c\u4e3a\u4e0a\u6765\u770b\uff0c[npc.she]\u5f88\u660e\u663e<i style='color:" + al.getColour().toWebHexString() + ";'>\u559c\u7231\u7740\u4f60</i>\uff0c\u800c\u4e14\u53ea\u53ef\u80fd\u662f\u8eab\u4e3a[npc.a_relation(pc)]\u624d\u80fd\u62e5\u6709\u7684\u60c5\u611f\u3002");
                    break;
                }
                case POSITIVE_FIVE_WORSHIP: {
                    if (this.isAttractedTo(Main.game.getPlayer()) && Main.game.isIncestEnabled()) {
                        sb.append("[npc.Name]<i style='color:" + al.getColour().toWebHexString() + ";'>\u7231\u6155\u4f60</i>\uff0c\u5df2\u7ecf[style.italicsSex(\u6b7b\u5fc3\u584c\u5730\u5730)]\u7231\u4e0a\u4e86\u4f60\u3002");
                        break;
                    }
                    sb.append("[npc.Name]<i style='color:" + al.getColour().toWebHexString() + ";'>\u4ef0\u6155\u4f60</i>\uff0c\u65e0\u8bba\u4f60\u8bf7\u6c42\u4ec0\u4e48\u4e8b\u60c5[npc.herHim]\u90fd\u4f1a\u5c3d\u529b\u5b8c\u6210\u3002");
                }
            }
            if (Main.game.isIncestEnabled()) {
                sb.append("<br/>");
                if (this.isAttractedTo(Main.game.getPlayer())) {
                    sb.append("\u4f60\u6ce8\u610f\u5230[npc.namePos]\u7684\u89c6\u7ebf\u8eb2\u95ea\u7740\uff0c\u4f3c\u4e4e\u662f\u5728\u5077\u7784\u4f60\u7684\u8eab\u4f53\u3002\u770b\u5230[npc.her][npc.eyes]\u4e2d\u9965\u6e34\u7684\u795e\u60c5\uff0c[style.italicsSex(\u4f60\u6562\u8bf4[npc.sheIs]\u5df2\u7ecf\u8ff7\u4e0a\u4e86\u4f60)]\u2026\u2026");
                } else {
                    sb.append("[npc.Name][style.italicsMinorBad(\u6ca1\u6709\u4efb\u4f55\u53d7\u4f60\u5438\u5f15\u7684\u8ff9\u8c61)]\uff0c[npc.she]\u8868\u73b0\u51fa\u6765\u7684\u559c\u7231\u5355\u7eaf\u662f\u7531\u4e8e\u4f60\u4eec[pc.mother][npc.daughter]\u7684\u5173\u7cfb\u3002");
                }
            }
            sb.append("</i></p>");
        } else {
            sb.append("<p style='text-align:center;'><i>");
            AffectionLevel al = this.getAffectionLevel(Main.game.getPlayer());
            switch (al) {
                case NEGATIVE_FIVE_LOATHE: {
                    if (this.isAttractedTo(Main.game.getPlayer())) {
                        sb.append("\u5c3d\u7ba1[npc.name]\u770b\u4e0a\u53bb<i style='color:" + al.getColour().toWebHexString() + ";'>\u6781\u5176\u618e\u6076</i>\u4f60\uff0c\u4f46\u4f60\u770b\u5f97\u51fa[npc.sheIs]\u8fd8\u662f\u5f88\u5bf9\u4f60\u7740\u8ff7\u3002");
                        break;
                    }
                    sb.append("[npc.Name]\u770b\u4e0a\u53bb<i style='color:" + al.getColour().toWebHexString() + ";'>\u6781\u5176\u618e\u6076</i>\u4f60\u3002");
                    break;
                }
                case NEGATIVE_FOUR_HATE: {
                    if (this.isAttractedTo(Main.game.getPlayer())) {
                        sb.append("\u5c3d\u7ba1[npc.name]\u770b\u4e0a\u53bb<i style='color:" + al.getColour().toWebHexString() + ";'>\u5f88\u538c\u6076</i>\u4f60\uff0c\u4f46\u4f60\u770b\u5f97\u51fa[npc.sheIs]\u8fd8\u662f\u5f88\u5bf9\u4f60\u7740\u8ff7\u3002");
                        break;
                    }
                    sb.append("[npc.Name]\u770b\u4e0a\u53bb<i style='color:" + al.getColour().toWebHexString() + ";'>\u5f88\u538c\u6076</i>\u4f60\u3002");
                    break;
                }
                case NEGATIVE_THREE_STRONG_DISLIKE: {
                    if (this.isAttractedTo(Main.game.getPlayer())) {
                        sb.append("\u5c3d\u7ba1[npc.name]\u770b\u4e0a\u53bb<i style='color:" + al.getColour().toWebHexString() + ";'>\u975e\u5e38\u8ba8\u538c</i>\u4f60\uff0c\u4f46\u4f60\u770b\u5f97\u51fa[npc.sheIs]\u8fd8\u662f\u5f88\u5bf9\u4f60\u7740\u8ff7\u3002");
                        break;
                    }
                    sb.append("[npc.Name]\u770b\u4e0a\u53bb<i style='color:" + al.getColour().toWebHexString() + ";'>\u975e\u5e38\u8ba8\u538c</i>\u4f60\u3002");
                    break;
                }
                case NEGATIVE_TWO_DISLIKE: {
                    if (this.isAttractedTo(Main.game.getPlayer())) {
                        sb.append("\u5c3d\u7ba1[npc.name]\u770b\u4e0a\u53bb<i style='color:" + al.getColour().toWebHexString() + ";'>\u8ba8\u538c</i>\u4f60\uff0c\u4f46\u4f60\u770b\u5f97\u51fa[npc.sheIs]\u8fd8\u662f\u5f88\u5bf9\u4f60\u7740\u8ff7\u3002");
                        break;
                    }
                    sb.append("[npc.Name]\u770b\u4e0a\u53bb<i style='color:" + al.getColour().toWebHexString() + ";'>\u8ba8\u538c</i>\u4f60\u3002");
                    break;
                }
                case NEGATIVE_ONE_ANNOYED: {
                    if (this.isAttractedTo(Main.game.getPlayer())) {
                        sb.append("\u5c3d\u7ba1[npc.name]\u770b\u4e0a\u53bb<i style='color:" + al.getColour().toWebHexString() + ";'>\u5bf9\u4f60\u611f\u5230\u607c\u706b</i>\uff0c\u4f46\u4f60\u770b\u5f97\u51fa[npc.sheIs]\u8fd8\u662f\u5f88\u5bf9\u4f60\u7740\u8ff7\u3002");
                        break;
                    }
                    sb.append("[npc.Name]\u770b\u4e0a\u53bb<i style='color:" + al.getColour().toWebHexString() + ";'>\u5bf9\u4f60\u611f\u5230\u607c\u706b</i>\u3002");
                    break;
                }
                case ZERO_NEUTRAL: {
                    if (this.isAttractedTo(Main.game.getPlayer())) {
                        sb.append("\u5bf9\u4e8e\u4f60\uff0c[npc.Name]\u6446\u51fa\u4e00\u526f<i style='color:" + al.getColour().toWebHexString() + ";'>\u53cb\u597d\u3001\u6311\u9017</i>\u7684\u59ff\u6001\u3002");
                        break;
                    }
                    sb.append("\u5bf9\u4e8e\u4f60\uff0c[npc.Name]\u6446\u51fa\u4e00\u526f<i style='color:" + al.getColour().toWebHexString() + ";'>\u53cb\u597d</i>\u7684\u59ff\u6001\u3002");
                    break;
                }
                case POSITIVE_ONE_FRIENDLY: {
                    if (this.isAttractedTo(Main.game.getPlayer())) {
                        sb.append("\u5bf9\u4e8e\u4f60\uff0c[npc.Name]\u6446\u51fa\u4e00\u526f<i style='color:" + al.getColour().toWebHexString() + ";'>\u53cb\u5584\u3001\u6311\u9017</i>\u7684\u59ff\u6001\u3002");
                        break;
                    }
                    sb.append("\u5bf9\u4e8e\u4f60\uff0c[npc.Name]\u6446\u51fa\u4e00\u526f<i style='color:" + al.getColour().toWebHexString() + ";'>\u53cb\u5584</i>\u7684\u59ff\u6001\u3002");
                    break;
                }
                case POSITIVE_TWO_LIKE: {
                    if (this.isAttractedTo(Main.game.getPlayer())) {
                        sb.append("[npc.Name]\u5f88\u660e\u663e<i style='color:" + al.getColour().toWebHexString() + ";'>\u559c\u6b22\u4f60</i>\uff0c\u800c\u4e14\u4e0d\u4ec5\u4ec5\u5c06\u4f60\u89c6\u4f5c\u670b\u53cb\u3002");
                        break;
                    }
                    sb.append("[npc.Name]\u5f88\u660e\u663e<i style='color:" + al.getColour().toWebHexString() + ";'>\u559c\u6b22\u4f60</i>\uff0c\u800c\u4e14\u5c06\u4f60\u89c6\u4f5c\u4e00\u4f4d\u597d\u670b\u53cb\u3002");
                    break;
                }
                case POSITIVE_THREE_CARING: {
                    if (this.isAttractedTo(Main.game.getPlayer())) {
                        sb.append("[npc.Name]\u660e\u663e<i style='color:" + al.getColour().toWebHexString() + ";'>\u5f88\u5728\u4e4e\u4f60</i>\uff0c\u800c\u4e14\u88ab\u4f60\u6df1\u6df1\u5438\u5f15\u3002");
                        break;
                    }
                    sb.append("[npc.Name]\u660e\u663e<i style='color:" + al.getColour().toWebHexString() + ";'>\u5f88\u5728\u4e4e\u4f60</i>\uff0c\u800c\u4e14\u8ba4\u4e3a\u4f60\u662f[npc.her]\u6700\u597d\u7684\u670b\u53cb\u3002");
                    break;
                }
                case POSITIVE_FOUR_LOVE: {
                    if (this.isAttractedTo(Main.game.getPlayer())) {
                        sb.append("\u4ece[npc.Name]\u7684\u884c\u4e3a\u4e0a\u6765\u770b\uff0c[npc.she]\u5f88\u660e\u663e<i style='color:" + al.getColour().toWebHexString() + ";'>\u7231\u4e0a\u4e86\u4f60</i>\u3002");
                        break;
                    }
                    sb.append("\u4ece[npc.Name]\u7684\u884c\u4e3a\u4e0a\u6765\u770b\uff0c[npc.she]\u5f88\u660e\u663e<i style='color:" + al.getColour().toWebHexString() + ";'>\u559c\u7231\u7740\u4f60</i>\uff0c\u4e00\u79cd\u67cf\u62c9\u56fe\u5f0f\u7684\u53cb\u8c0a\u3002");
                    break;
                }
                case POSITIVE_FIVE_WORSHIP: {
                    if (this.isAttractedTo(Main.game.getPlayer())) {
                        sb.append("[npc.Name]<i style='color:" + al.getColour().toWebHexString() + ";'>\u7231\u6155\u4f60</i>\uff0c\u5df2\u7ecf\u6b7b\u5fc3\u584c\u5730\u5730\u7231\u4e0a\u4e86\u4f60\u3002");
                        break;
                    }
                    sb.append("[npc.Name]<i style='color:" + al.getColour().toWebHexString() + ";'>\u4ef0\u6155\u4f60</i>\uff0c\u65e0\u8bba\u4f60\u8bf7\u6c42\u4ec0\u4e48\u4e8b\u60c5[npc.herHim]\u90fd\u4f1a\u5c3d\u529b\u5b8c\u6210\u3002");
                }
            }
            sb.append("</i></p>");
        }
        return UtilText.parse((GameCharacter)this, sb.toString(), new ParserTag[0]);
    }

    public String getTraderDescription() {
        return UtilText.parse((GameCharacter)this, "<p>\u4f60\u770b\u4e86\u770b[npc.name]\u6709\u4ec0\u4e48\u5356\u3002</p>", new ParserTag[0]);
    }

    public boolean isTrader() {
        return false;
    }

    public boolean willBuy(AbstractCoreItem item) {
        return false;
    }

    public float getBuyModifier() {
        return this.buyModifier;
    }

    public void setBuyModifier(float buyModifier) {
        this.buyModifier = buyModifier;
    }

    public float getSellModifier(AbstractCoreItem item) {
        float base = this.sellModifier;
        if (item instanceof AbstractItem && ((AbstractItem)item).getItemType() == ItemType.getItemTypeFromId("innoxia_pills_sterility")) {
            base *= 10.0f;
        }
        return Math.max(this.getBuyModifier(), base * (Main.game.getPlayer().hasTrait(Perk.JOB_STUDENT, true) ? 0.75f : 1.0f));
    }

    public void setSellModifier(float sellModifier) {
        this.sellModifier = sellModifier;
    }

    public void applyItemTransactionEffects(AbstractCoreItem itemSold, int quantity, int individualPrice, boolean soldToPlayer) {
    }

    private List<Spell> getSpellsAbleToCast() {
        ArrayList<Spell> spellsAbleToCast = new ArrayList<Spell>();
        for (Spell spell : this.getAllSpells()) {
            if (!(this.getMana() > spell.getModifiedCost(this))) continue;
            if (this.isElemental()) {
                if (spell == Spell.ELEMENTAL_AIR || spell == Spell.ELEMENTAL_ARCANE || spell == Spell.ELEMENTAL_EARTH || spell == Spell.ELEMENTAL_FIRE || spell == Spell.ELEMENTAL_WATER) continue;
                spellsAbleToCast.add(spell);
                continue;
            }
            spellsAbleToCast.add(spell);
        }
        return spellsAbleToCast;
    }

    public Map<Spell, Integer> getWeightedSpellsAvailable(GameCharacter target) {
        HashMap<Spell, Integer> weightedSpellMap = new HashMap<Spell, Integer>();
        for (Spell spell : this.getSpellsAbleToCast()) {
            switch (spell) {
                case ARCANE_AROUSAL: 
                case FIREBALL: 
                case ICE_SHARD: 
                case POISON_VAPOURS: 
                case SLAM: 
                case VACUUM: 
                case ARCANE_LIGHTNING_SUPERBOLT: {
                    if (!Main.combat.isOpponent(this, target)) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case ARCANE_CHAIN_LIGHTNING: {
                    if (Main.combat.getEnemies(this).size() <= 1) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case ARCANE_CLOUD: {
                    if (!Main.combat.isOpponent(this, target) || target.hasStatusEffect(StatusEffect.ARCANE_CLOUD) || target.hasStatusEffect(StatusEffect.ARCANE_CLOUD_ARCANE_LIGHTNING) || target.hasStatusEffect(StatusEffect.ARCANE_CLOUD_ARCANE_THUNDER) || target.hasStatusEffect(StatusEffect.ARCANE_CLOUD_LOCALISED_STORM)) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case CLOAK_OF_FLAMES: {
                    if (Main.combat.isOpponent(this, target) || target.hasStatusEffect(StatusEffect.CLOAK_OF_FLAMES) || target.hasStatusEffect(StatusEffect.CLOAK_OF_FLAMES_1) || target.hasStatusEffect(StatusEffect.CLOAK_OF_FLAMES_2) || target.hasStatusEffect(StatusEffect.CLOAK_OF_FLAMES_3)) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case PROTECTIVE_GUSTS: {
                    if (Main.combat.isOpponent(this, target) || target.hasStatusEffect(StatusEffect.PROTECTIVE_GUSTS) || target.hasStatusEffect(StatusEffect.PROTECTIVE_GUSTS_FOCUSED_BLAST) || target.hasStatusEffect(StatusEffect.PROTECTIVE_GUSTS_GUIDING_WIND)) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case RAIN_CLOUD: {
                    if (!Main.combat.isOpponent(this, target) || target.hasStatusEffect(StatusEffect.RAIN_CLOUD) || target.hasStatusEffect(StatusEffect.RAIN_CLOUD_CLOUDBURST) || target.hasStatusEffect(StatusEffect.RAIN_CLOUD_DEEP_CHILL) || target.hasStatusEffect(StatusEffect.RAIN_CLOUD_DOWNPOUR) || target.hasStatusEffect(StatusEffect.RAIN_CLOUD_DOWNPOUR_FOR_CLOUDBURST)) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case SOOTHING_WATERS: {
                    if (Main.combat.isOpponent(this, target) || !(target.getHealthPercentage() < 0.8f)) break;
                    weightedSpellMap.put(spell, (int)(1.0f - target.getHealthPercentage() * 10.0f) / 2);
                    break;
                }
                case STONE_SHELL: {
                    if (Main.combat.isOpponent(this, target) || target.hasStatusEffect(StatusEffect.STONE_SHELL) || target.hasStatusEffect(StatusEffect.STONE_SHELL_EXPLOSIVE_FINISH) || target.hasStatusEffect(StatusEffect.STONE_SHELL_HARDENED_CARAPACE) || target.hasStatusEffect(StatusEffect.STONE_SHELL_SHIFTING_SANDS)) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case TELEKENETIC_SHOWER: {
                    if (!Main.combat.isOpponent(this, target) || target.hasStatusEffect(StatusEffect.TELEKENETIC_SHOWER) || target.hasStatusEffect(StatusEffect.TELEKENETIC_SHOWER_PRECISION_STRIKES) || target.hasStatusEffect(StatusEffect.TELEKENETIC_SHOWER_UNSEEN_FORCE)) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case TELEPATHIC_COMMUNICATION: {
                    if (Main.combat.isOpponent(this, target) || target.hasStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION) || target.hasStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION) || target.hasStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION_TARGETED) || target.hasStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_PROJECTED_TOUCH)) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case TELEPORT: {
                    if (Main.combat.isOpponent(this, target) || target.hasStatusEffect(StatusEffect.TELEPORT) || target.hasStatusEffect(StatusEffect.TELEPORT_ARCANE_ARRIVAL)) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case WITCH_CHARM: {
                    if (Main.combat.isOpponent(this, target) || target.hasStatusEffect(StatusEffect.WITCH_CHARM)) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case FLASH: 
                case WITCH_SEAL: {
                    if (!Main.combat.isOpponent(this, target) || !(target.getAttributeValue(Attribute.ACTION_POINTS) >= 3.0f)) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case CLEANSE: {
                    break;
                }
                case LILITHS_COMMAND: {
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case STEAL: {
                    weightedSpellMap.put(spell, 1);
                    break;
                }
                case ELEMENTAL_AIR: 
                case ELEMENTAL_ARCANE: 
                case ELEMENTAL_EARTH: 
                case ELEMENTAL_FIRE: 
                case ELEMENTAL_WATER: {
                    if (this.isElemental() || this.isElementalSummoned()) break;
                    weightedSpellMap.put(spell, 1);
                    break;
                }
            }
        }
        return weightedSpellMap;
    }

    public void applyEscapeCombatEffects() {
    }

    public Response endCombat(boolean applyEffects, boolean playerVictory) {
        return null;
    }

    public Response interruptCombatSpecialCase() {
        return null;
    }

    public int getEscapeChance() {
        return (int)(30.0f * (this.hasTrait(Perk.JOB_BOUNTY_HUNTER, true) ? 0.5f : 1.0f));
    }

    public boolean isSurrendersAtZeroMana() {
        return true;
    }

    public int getProstitutePrice() {
        float prostitutePrice = 1.0f;
        if (this.isFeminine()) {
            prostitutePrice += 0.5f;
        }
        prostitutePrice += (float)(this.getBody().getBreast().getRawSizeValue() - 7) * 0.02f;
        if (this.hasVagina()) {
            prostitutePrice += 0.15f;
        }
        if (this.hasPenis()) {
            prostitutePrice += Math.min((float)(this.getBody().getPenis().getRawLengthValue() - 5) * 0.01f, 0.1f);
        }
        if (this.isBreastFuckableNipplePenetration()) {
            prostitutePrice += 0.15f;
        }
        if (this.isVisiblyPregnant()) {
            prostitutePrice *= 0.5f;
        }
        return Math.max(150, (int)((prostitutePrice += (float)this.getTrueLevel() * 0.05f) * 50.0f) * 10);
    }

    public int getExperienceFromVictory() {
        return this.getLevel() * 2;
    }

    public int getLootMoney() {
        return (int)((double)(this.getLevel() * 25) * (1.0 + Math.random() - 0.5));
    }

    public boolean isLootingPlayerAfterCombat() {
        return true;
    }

    public List<AbstractCoreItem> getLootItems() {
        double rnd = Math.random();
        if (rnd <= 0.05) {
            return Util.newArrayListOfValues(Main.game.getItemGen().generateItem(ItemType.FETISH_UNREFINED));
        }
        if (rnd <= 0.1) {
            return Util.newArrayListOfValues(Main.game.getItemGen().generateItem(ItemType.ADDICTION_REMOVAL));
        }
        AbstractItemType raceIngredient = this.getSubspecies().getAttributeItem(this);
        AbstractItemType raceTFIngredient = this.getSubspecies().getTransformativeItem(this);
        AbstractItemType book = this.getSubspecies().getBook();
        if (rnd < 0.6 && raceTFIngredient != null) {
            return Util.newArrayListOfValues(Main.game.getItemGen().generateItem(raceTFIngredient));
        }
        if (rnd <= 0.8 && !Main.game.getPlayer().getRacesDiscoveredFromBook().contains(this.getSubspecies())) {
            return Util.newArrayListOfValues(Main.game.getItemGen().generateItem(book));
        }
        if (raceIngredient != null) {
            return Util.newArrayListOfValues(Main.game.getItemGen().generateItem(raceIngredient));
        }
        return Util.newArrayListOfValues(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH));
    }

    public int getLootEssenceDrops() {
        return Util.random.nextInt(this.getLevel()) + 1;
    }

    public boolean isGenerateExtraItems() {
        return this.generateExtraItems;
    }

    public void setGenerateExtraItems(boolean generateExtraItems) {
        this.generateExtraItems = generateExtraItems;
    }

    public boolean isGenerateDisposableClothing() {
        return this.generateDisposableClothing;
    }

    public void setGenerateDisposableClothing(boolean generateDisposableClothing) {
        this.generateDisposableClothing = generateDisposableClothing;
    }

    public boolean isGenerateExtraClothing() {
        return this.generateExtraClothing;
    }

    public void setGenerateExtraClothing(boolean generateExtraClothing) {
        this.generateExtraClothing = generateExtraClothing;
    }

    public float getHourlyAffectionChange(int hour) {
        SlaveJob job = this.getSlaveJob(hour);
        if (this.getSlaveJob(hour) == SlaveJob.IDLE) {
            return (float)Math.round(this.getHomeLocationPlace().getHourlyAffectionChange() * 100.0f) / 100.0f;
        }
        float overworkedPenalty = 1.0f;
        if (StatusEffect.OVERWORKED_1.isConditionsMet(this)) {
            overworkedPenalty = 0.5f;
        } else if (StatusEffect.OVERWORKED_2.isConditionsMet(this)) {
            overworkedPenalty = 0.2f;
        } else if (StatusEffect.OVERWORKED_3.isConditionsMet(this)) {
            overworkedPenalty = 0.0f;
        }
        float affectionGain = (float)Math.round(job.getAffectionGain(this) * 100.0f) / 100.0f;
        return Math.min(affectionGain, affectionGain * overworkedPenalty);
    }

    public float getDailyAffectionChange() {
        float totalAffectionChange = 0.0f;
        for (int hour = 0; hour < 24; ++hour) {
            totalAffectionChange += this.getHourlyAffectionChange(hour);
        }
        if (StatusEffect.OVERWORKED_1.isConditionsMet(this)) {
            totalAffectionChange -= 12.0f;
        } else if (StatusEffect.OVERWORKED_2.isConditionsMet(this)) {
            totalAffectionChange -= 24.0f;
        } else if (StatusEffect.OVERWORKED_3.isConditionsMet(this)) {
            totalAffectionChange -= 48.0f;
        }
        return (float)Math.round(totalAffectionChange * 100.0f) / 100.0f;
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return false;
    }

    @Override
    public boolean isAbleToBeEgged() {
        return (!this.isUnique() || this.isSlave() && this.getOwner().isPlayer()) && !this.hasPerkAnywhereInTree(Perk.DOLL_PHYSICAL_2);
    }

    public boolean isReadyToBeDeleted() {
        if (this.isUnique() || this instanceof Elemental || this instanceof ReindeerOverseer || this instanceof GenericFemaleNPC || this instanceof GenericMaleNPC || this instanceof GenericAndrogynousNPC || this instanceof PrologueFemale || this instanceof PrologueMale || this instanceof NPCOffspring) {
            return false;
        }
        for (Litter litter : this.getIncubatingLitters().values()) {
            if ((litter.getMother() == null || !litter.getMother().isPlayer()) && (litter.getFather() == null || !litter.getFather().isPlayer())) continue;
            return false;
        }
        for (Litter litter : Main.game.getPlayer().getIncubatingLitters().values()) {
            if ((litter.getMother() == null || !litter.getMother().equals(this)) && (litter.getFather() == null || !litter.getFather().equals(this))) continue;
            return false;
        }
        if (this.getPregnantLitter() != null && this.getPregnantLitter().getFather() != null && this.getPregnantLitter().getFather().isPlayer() || Main.game.getPlayer().getPregnantLitter() != null && Main.game.getPlayer().getPregnantLitter().getFather() != null && Main.game.getPlayer().getPregnantLitter().isFather(this)) {
            return false;
        }
        for (PregnancyPossibility possibility : this.getPotentialPartnersAsMother()) {
            if ((possibility.getMother() == null || !possibility.getMother().isPlayer()) && (possibility.getFather() == null || !possibility.getFather().isPlayer())) continue;
            return false;
        }
        for (PregnancyPossibility possibility : this.getPotentialPartnersAsFather()) {
            if ((possibility.getMother() == null || !possibility.getMother().isPlayer()) && (possibility.getFather() == null || !possibility.getFather().isPlayer())) continue;
            return false;
        }
        for (PregnancyPossibility possibility : Main.game.getPlayer().getPotentialPartnersAsMother()) {
            if ((possibility.getMother() == null || !possibility.getMother().equals(this)) && (possibility.getFather() == null || !possibility.getFather().equals(this))) continue;
            return false;
        }
        for (PregnancyPossibility possibility : Main.game.getPlayer().getPotentialPartnersAsFather()) {
            if ((possibility.getMother() == null || !possibility.getMother().equals(this)) && (possibility.getFather() == null || !possibility.getFather().equals(this))) continue;
            return false;
        }
        return true;
    }

    public boolean hasFlag(NPCFlagValue flag) {
        return this.NPCFlagValues.contains((Object)flag);
    }

    public boolean addFlag(NPCFlagValue flag) {
        return this.NPCFlagValues.add(flag);
    }

    public boolean removeFlag(NPCFlagValue flag) {
        return this.NPCFlagValues.remove((Object)flag);
    }

    public boolean setFlag(NPCFlagValue flag, boolean value) {
        if (value) {
            return this.addFlag(flag);
        }
        return this.removeFlag(flag);
    }

    public boolean isPostCombatNoSex() {
        return (!this.isAttractedTo(Main.game.getPlayer()) || this.hasFlag(NPCFlagValue.genericNPCBetrayedByPlayer)) && !Main.game.isNonConEnabled();
    }

    public boolean isPostCombatWantsSex() {
        return this.isAttractedTo(Main.game.getPlayer()) && !this.hasFlag(NPCFlagValue.genericNPCBetrayedByPlayer) || !Main.game.isNonConEnabled();
    }

    public boolean isPostCombatRapePlay() {
        return this.isAttractedTo(Main.game.getPlayer()) && !this.hasFlag(NPCFlagValue.genericNPCBetrayedByPlayer) && this.hasFetish(Fetish.FETISH_NON_CON_SUB) && Main.game.isNonConEnabled() && Main.getProperties().hasValue(PropertyValue.rapePlayAtSexStart);
    }

    public boolean isKnowsPlayerGender() {
        return this.NPCFlagValues.contains((Object)NPCFlagValue.knowsPlayerGender);
    }

    public void setKnowsPlayerGender(boolean knowsPlayerGender) {
        if (knowsPlayerGender) {
            this.NPCFlagValues.add(NPCFlagValue.knowsPlayerGender);
        } else {
            this.NPCFlagValues.remove((Object)NPCFlagValue.knowsPlayerGender);
        }
    }

    public boolean isIntroducedToPlayer() {
        return this.NPCFlagValues.contains((Object)NPCFlagValue.introducedToPlayer);
    }

    public void setIntroducedToPlayer(boolean introducedToPlayer) {
        if (introducedToPlayer) {
            this.NPCFlagValues.add(NPCFlagValue.introducedToPlayer);
        } else {
            this.NPCFlagValues.remove((Object)NPCFlagValue.introducedToPlayer);
        }
    }

    public boolean isPendingClothingDressing() {
        return this.NPCFlagValues.contains((Object)NPCFlagValue.pendingClothingDressing);
    }

    public void setPendingClothingDressing(boolean pendingClothingDressing) {
        if (pendingClothingDressing) {
            this.NPCFlagValues.add(NPCFlagValue.pendingClothingDressing);
        } else {
            this.NPCFlagValues.remove((Object)NPCFlagValue.pendingClothingDressing);
        }
    }

    public boolean isPendingTransformationToGenderIdentity() {
        return this.getGender() != this.getGenderIdentity() && !this.isElemental() && !this.isPregnant() && this.getIncubatingLitters().isEmpty() && !this.isUnique() && !this.isSlave() && !Main.game.getPlayer().getFriendlyOccupants().contains(this.getId()) && this.isAbleToSelfTransform();
    }

    public void setBodyToGenderIdentity(boolean completeReset) {
        if (completeReset) {
            boolean assVirgin = this.isAssVirgin();
            boolean faceVirgin = this.isFaceVirgin();
            boolean nippleVirgin = this.isNippleVirgin();
            boolean penisVirgin = this.isPenisVirgin();
            boolean urethraVirgin = this.isUrethraVirgin();
            boolean vaginaVirgin = this.isVaginaVirgin();
            boolean vaginaUrethraVirgin = this.isVaginaUrethraVirgin();
            BodyMaterial material = this.getBodyMaterial();
            this.setBody(this.getGenderIdentity(), this.getBody().getFleshSubspecies(), this.getBody().getRaceStageFromPartWeighting(), false);
            this.setBodyMaterial(material);
            Main.game.getCharacterUtils().randomiseBody(this, false);
            this.setAssVirgin(assVirgin);
            this.setFaceVirgin(faceVirgin);
            this.setNippleVirgin(nippleVirgin);
            this.setPenisVirgin(penisVirgin);
            this.setUrethraVirgin(urethraVirgin);
            this.setVaginaVirgin(vaginaVirgin);
            this.setVaginaUrethraVirgin(vaginaUrethraVirgin);
        } else {
            AbstractRacialBody racialBody = RacialBody.valueOfRace(this.getBody().getFleshSubspecies().getRace());
            if (this.getGenderIdentity().getType() == PronounType.FEMININE) {
                this.setFemininity(racialBody.getFemaleFemininity());
            } else if (this.getGenderIdentity().getType() == PronounType.NEUTRAL) {
                this.setFemininity(50);
            } else {
                this.setFemininity(racialBody.getMaleFemininity());
            }
            if (this.getGenderIdentity().getGenderName().isHasBreasts()) {
                this.setBreastSize(racialBody.getBreastSize());
            } else {
                this.setBreastSize(racialBody.getNoBreastSize());
            }
            boolean largeGenitals = this.isTaur();
            if (this.getGenderIdentity().getGenderName().isHasPenis()) {
                this.setPenisType(racialBody.getPenisType());
                this.setPenisSize((int)((float)racialBody.getPenisSize() * (largeGenitals ? 2.5f : 1.0f)));
                this.setPenisGirth(racialBody.getPenisGirth() + (largeGenitals ? 1 : 0));
                this.setPenisCumStorage(racialBody.getCumProduction() * (largeGenitals ? 10 : 1));
                this.setTesticleSize(racialBody.getTesticleSize() + (largeGenitals ? 1 : 0));
                this.setTesticleCount(racialBody.getTesticleQuantity());
            } else {
                this.setPenisType(PenisType.NONE);
            }
            if (this.getGenderIdentity().getGenderName().isHasVagina()) {
                this.setVaginaType(racialBody.getVaginaType());
                this.setVaginaWetness(racialBody.getVaginaWetness());
            } else {
                this.setVaginaType(VaginaType.NONE);
            }
        }
    }

    public boolean hasEncounteredBefore() {
        return this.lastTimeEncountered != -1L;
    }

    public long getLastTimeEncountered() {
        return this.lastTimeEncountered;
    }

    public void setLastTimeEncountered(long minutesPassed) {
        this.lastTimeEncountered = minutesPassed;
    }

    @Override
    public void setPlayerKnowsName(boolean playerKnowsName) {
        super.setPlayerKnowsName(playerKnowsName);
        if (this.isAddedToContacts() && playerKnowsName && Main.game.isStarted() && Main.game.getPlayer() != null && !Main.game.getPlayer().getCharactersEncountered().contains(this.getId())) {
            Main.game.getPlayer().addCharacterEncountered(this);
        }
    }

    public boolean isAddedToContacts() {
        return this.addedToContacts;
    }

    public void applyPlayerPregnancyReactions() {
        if (this.isVisiblyPregnant()) {
            this.setCharacterReactedToPregnancy(Main.game.getPlayer(), true);
        }
        if (Main.game.getPlayer().isVisiblyPregnant()) {
            Main.game.getPlayer().setCharacterReactedToPregnancy(this, true);
        }
    }

    public boolean isUsingForcedTransform(GameCharacter target) {
        return this.hasFetish(Fetish.FETISH_TRANSFORMATION_GIVING) && target.getRace() != Race.ELEMENTAL && target.getSubspeciesOverride() == null;
    }

    public boolean isUsingForcedFetish(GameCharacter target) {
        return this.hasFetish(Fetish.FETISH_KINK_GIVING);
    }

    public boolean isApplyingPostCombatTransformations() {
        return this.isApplyingPostCombatTransformations(true, true);
    }

    public boolean isApplyingPostCombatTransformations(boolean checkForBodyTransform, boolean checkForFetishTransform) {
        return checkForBodyTransform && this.isUsingForcedTransform(Main.game.getPlayer()) && this.getPostCombatPotion() != null || checkForFetishTransform && this.isUsingForcedFetish(Main.game.getPlayer()) && this.getPostCombatFetishPotion() != null;
    }

    public void generatePostCombatPotions() {
        if (Main.game.getPlayer().isAbleToAccessCoverableArea(CoverableArea.MOUTH, true)) {
            this.potion = this.generateTransformativePotion(Main.game.getPlayer());
            this.fetishPotion = this.generateFetishPotion(Main.game.getPlayer(), true);
        } else {
            this.potion = null;
            this.fetishPotion = null;
        }
    }

    public TransformativePotion getPostCombatPotion() {
        return this.potion;
    }

    public FetishPotion getPostCombatFetishPotion() {
        return this.fetishPotion;
    }

    public String applyPostCombatTransformation() {
        PlayerCharacter target = Main.game.getPlayer();
        boolean forcedTF = this.isUsingForcedTransform(target);
        TransformativePotion potion = this.getPostCombatPotion();
        FetishPotion fetishPotion = this.getPostCombatFetishPotion();
        boolean forcedFetish = this.isUsingForcedFetish(target);
        StringBuilder sb = new StringBuilder();
        if (potion != null && forcedTF) {
            sb.append(this.applyPotion(potion, target));
        }
        if (fetishPotion != null && forcedFetish) {
            sb.append(this.applyPotion(fetishPotion, target));
        }
        return sb.toString();
    }

    public String getPreferredBodyDescription(String tag) {
        boolean cannotTransformPreference = this.getSubspeciesPreference().getRace() == Race.DEMON;
        return "<" + tag + " style='color:" + this.getGenderPreference().getColour().toWebHexString() + ";'>" + this.getGenderPreference().getName() + "</" + tag + ">" + (String)(cannotTransformPreference ? "" : "<" + tag + " style='color:" + this.getSubspeciesPreference().getColour(null).toWebHexString() + ";'>" + this.getSubspeciesPreference().getName(null) + "</" + tag + ">");
    }

    public Gender getGenderPreference() {
        if (this.genderPreference == null) {
            this.generatePartnerPreferences();
        }
        return this.genderPreference;
    }

    public AbstractSubspecies getSubspeciesPreference() {
        if (this.subspeciesPreference == null) {
            this.generatePartnerPreferences();
        }
        return this.subspeciesPreference;
    }

    public RaceStage getRaceStagePreference() {
        if (this.raceStagePreference == null) {
            this.generatePartnerPreferences();
        }
        return this.raceStagePreference;
    }

    public boolean isAffectionHighEnoughToInviteHome() {
        if (this.isRelatedTo(Main.game.getPlayer(), new Relationship[0])) {
            return this.getAffection(Main.game.getPlayer()) >= (float)AffectionLevel.NEGATIVE_TWO_DISLIKE.getMinimumValue();
        }
        return this.getAffection(Main.game.getPlayer()) >= (float)AffectionLevel.POSITIVE_THREE_CARING.getMinimumValue();
    }

    public boolean isAllowingPlayerToManageInventory() {
        return Main.game.getPlayer().getFriendlyOccupants().contains(this.getId()) || this.isSlave() && this.getOwner().isPlayer();
    }

    public AbstractItemEffectType getItemEnchantmentEffect(AbstractItemType itemType, BodyPartInterface bodyPart) {
        if (Util.newArrayListOfValues(Race.HUMAN, Race.NONE).contains(bodyPart.getType().getRace())) {
            return ItemEffectType.getRacialEffectType(Race.HUMAN);
        }
        return itemType.getEnchantmentEffect();
    }

    public TransformativePotion generateTransformativePotion(GameCharacter target) {
        Body body;
        AbstractSubspecies transformationItemSubspecies;
        boolean cannotTransformPreference;
        ArrayList<PossibleItemEffect> possibleEffects = new ArrayList<PossibleItemEffect>();
        AbstractItemType itemType = ItemType.getItemTypeFromId("innoxia_race_human_bread_roll");
        int numberOfTransformations = (2 + Util.random.nextInt(4)) * (target.hasFetish(Fetish.FETISH_TRANSFORMATION_RECEIVING) ? 2 : 1);
        boolean bl = cannotTransformPreference = this.getSubspeciesPreference().getRace() == Race.DEMON || this.getSubspeciesPreference().getRace() == Race.ANGEL;
        if (this.getSubspeciesPreference() == Subspecies.SLIME && target.getBodyMaterial() != BodyMaterial.SLIME) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(ItemEffectType.RACE_SLIME_TF_UTIL_EFFECT, TFModifier.NONE, TFModifier.NONE, TFPotency.MINOR_BOOST, 1), "\u4f60\u4f1a\u7231\u4e0a\u53d8\u6210\u53f2\u83b1\u59c6\u7684\u611f\u89c9\u7684\uff01"));
            return new TransformativePotion(itemType, possibleEffects);
        }
        if (Main.getProperties().getForcedTFPreference() != FurryPreference.HUMAN && ((itemType = (transformationItemSubspecies = cannotTransformPreference ? target.getSubspecies() : this.getSubspeciesPreference()).getTransformativeItem(this)) == null || transformationItemSubspecies == Subspecies.SLIME)) {
            itemType = ItemType.getItemTypeFromId("innoxia_race_human_bread_roll");
        }
        AbstractItemType genitalsItemType = itemType;
        boolean skipGenitalsTF = false;
        Util.random = new Random(this.getId().hashCode());
        if (cannotTransformPreference) {
            body = Main.game.getCharacterUtils().generateBody(null, this.getGenderPreference(), target.getSubspecies(), target.getRaceStage());
        } else {
            RaceStage targetedRaceStage = this.getRaceStagePreference();
            switch (Main.getProperties().getForcedTFPreference()) {
                case HUMAN: {
                    targetedRaceStage = RaceStage.HUMAN;
                    break;
                }
                case MINIMUM: {
                    if (targetedRaceStage == RaceStage.HUMAN) break;
                    targetedRaceStage = RaceStage.PARTIAL_FULL;
                    break;
                }
                case REDUCED: {
                    if (targetedRaceStage == RaceStage.HUMAN || targetedRaceStage == RaceStage.PARTIAL_FULL) break;
                    targetedRaceStage = RaceStage.LESSER;
                    break;
                }
            }
            body = Main.game.getCharacterUtils().generateBody(null, this.getGenderPreference(), this.getSubspeciesPreference(), targetedRaceStage);
        }
        Util.random = new Random();
        if (body.getBodyMaterial() == BodyMaterial.SLIME) {
            genitalsItemType = itemType = body.getFleshSubspecies().getTransformativeItem(this);
        }
        boolean vaginaSet = target.getVaginaType() == body.getVagina().getType();
        boolean penisSet = target.getPenisType() == body.getPenis().getType();
        boolean humanGenitals = false;
        boolean applyingCrotchBoobTF = Main.game.isUdderContentEnabled();
        if (Main.getProperties().getForcedTFPreference() == FurryPreference.HUMAN || Main.getProperties().getForcedTFPreference() == FurryPreference.MINIMUM) {
            humanGenitals = true;
            genitalsItemType = ItemType.getItemTypeFromId("innoxia_race_human_bread_roll");
            vaginaSet = body.getVagina().getType() != VaginaType.NONE == target.hasVagina();
            penisSet = body.getPenis().getType() != PenisType.NONE == target.hasPenisIgnoreDildo();
            boolean bl2 = skipGenitalsTF = vaginaSet && penisSet;
        }
        if (!skipGenitalsTF) {
            if (!vaginaSet) {
                if (body.getVagina().getType() == VaginaType.NONE) {
                    if (!target.isHasAnyPregnancyEffects()) {
                        possibleEffects.add(new PossibleItemEffect(new ItemEffect(genitalsItemType.getEnchantmentEffect(), TFModifier.TF_VAGINA, TFModifier.REMOVAL, TFPotency.MINOR_BOOST, 1), "\u5411\u4f60\u7684\u5c0f\u7f1d\u8bf4\u62dc\u62dc\uff1b\u4f60\u4e0d\u518d\u9700\u8981\u8fd9\u4e1c\u897f\u4e86\uff01"));
                    }
                } else {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(genitalsItemType, body.getVagina()), TFModifier.TF_VAGINA, TFModifier.NONE, TFPotency.MINOR_BOOST, 1), "\u6765\u7ed9\u4f60\u4e2a\u6f02\u4eae\u7684" + (humanGenitals ? "\u4eba\u7c7b" : body.getVagina().getType().getTransformName()) + "\u5c0f\u7a74\u5427\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                }
            }
            if (!penisSet) {
                if (body.getPenis().getType() == PenisType.NONE) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(genitalsItemType.getEnchantmentEffect(), TFModifier.TF_PENIS, TFModifier.REMOVAL, TFPotency.MINOR_BOOST, 1), "\u662f\u65f6\u5019\u8ddf\u4f60\u7684\u9e21\u5df4\u8bf4\u518d\u89c1\u4e86\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                } else {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(genitalsItemType, body.getPenis()), TFModifier.TF_PENIS, TFModifier.NONE, TFPotency.MINOR_BOOST, 1), "\u6765\u7ed9\u4f60\u4e2a\u6f02\u4eae\u7684" + (humanGenitals ? "\u4eba\u7c7b" : body.getPenis().getType().getTransformName()) + "\u9e21\u5df4\u5427\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                }
            }
        }
        if (Main.getProperties().getForcedTFPreference() != FurryPreference.HUMAN && !cannotTransformPreference) {
            if (possibleEffects.isEmpty() || Math.random() > (double)0.33f) {
                if (target.getAntennaType() != body.getAntenna().getType()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getAntenna()), TFModifier.TF_ANTENNA, TFModifier.NONE, TFPotency.MINOR_BOOST, 1), body.getAntenna().getType() == AntennaType.NONE ? UtilText.parse(target, "\u6211\u4e0d\u60f3\u518d\u8ba9\u4f60\u957f\u7740\u90a3\u4e9b[npc.antennae]\u4e86\uff01", new ParserTag[0]) : "\u8be5\u957f\u70b9\u89e6\u987b\u73a9\u73a9\u4e86\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                }
                if (Main.getProperties().getForcedTFPreference() != FurryPreference.MINIMUM) {
                    if (target.getAssType() != body.getAss().getType()) {
                        possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getAss()), TFModifier.TF_ASS, TFModifier.NONE, TFPotency.MINOR_BOOST, 1), "\u770b\u6211\u53d8\u4e86\u4f60\u7684\u5c41\u80a1\uff01"));
                        if (possibleEffects.size() >= numberOfTransformations) {
                            return new TransformativePotion(itemType, possibleEffects, body);
                        }
                    }
                    if (target.getBreastType() != body.getBreast().getType()) {
                        possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getBreast()), TFModifier.TF_BREASTS, TFModifier.NONE, TFPotency.MINOR_BOOST, 1), "\u4f60\u7684\u80f8\u4e5f\u9003\u4e0d\u4e86\uff01"));
                        if (possibleEffects.size() >= numberOfTransformations) {
                            return new TransformativePotion(itemType, possibleEffects, body);
                        }
                    }
                    if (applyingCrotchBoobTF && target.getBreastCrotchType() != body.getBreastCrotch().getType() && body.getBreastCrotch().getType() != BreastType.NONE) {
                        possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getBreastCrotch()), TFModifier.TF_BREASTS_CROTCH, TFModifier.NONE, TFPotency.MINOR_BOOST, 1), "\u4f60\u8fd8\u5f97\u591a\u957f\u70b9\u80ef\u4e73\uff01"));
                        if (possibleEffects.size() >= numberOfTransformations) {
                            return new TransformativePotion(itemType, possibleEffects, body);
                        }
                    }
                }
                if (target.getEarType() != body.getEar().getType()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getEar()), TFModifier.TF_EARS, body.getEar().getType().getTFModifier(), TFPotency.MINOR_BOOST, 1), "\u4f60\u7684\u8033\u6735\u8fd8\u5f97\u6539\u9020\u4e00\u4e0b\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                }
                if (target.getEyeType() != body.getEye().getType()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getEye()), TFModifier.TF_EYES, TFModifier.NONE, TFPotency.MINOR_BOOST, 1), "\u662f\u65f6\u5019\u8f6c\u5316\u4e00\u4e0b\u773c\u775b\u4e86\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                }
                if (target.getHairType() != body.getHair().getType()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getHair()), TFModifier.TF_HAIR, body.getHair().getType().getTFModifier(), TFPotency.MINOR_BOOST, 1), "\u53ef\u80fd\u6709\u70b9\u75bc\u54e6\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                }
                if (target.getHornType() != body.getHorn().getType()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getHorn()), TFModifier.TF_HORNS, body.getHorn().getType().getTFModifier(), TFPotency.MINOR_BOOST, 1), body.getHorn().getType() == HornType.NONE ? "\u6765\u628a\u8fd9\u4e9b\u89d2\u9664\u53bb\u5427\u2026\u2026" : "\u51c6\u5907\u597d\u957f\u89d2\u4e86\u5417\uff1f"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                } else if (target.getHornType() != HornType.NONE) {
                    if (target.getHornLengthValue() + 3 < body.getHorn().getHornLengthValue()) {
                        possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_HORNS, TFModifier.TF_MOD_SIZE, TFPotency.BOOST, 1), "\u8ba9\u4f60\u7684\u89d2\u518d\u957f\u70b9\u5427\uff01"));
                        if (possibleEffects.size() >= numberOfTransformations) {
                            return new TransformativePotion(itemType, possibleEffects, body);
                        }
                    } else if (target.getHornLengthValue() - 3 > body.getHorn().getHornLengthValue()) {
                        possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_HORNS, TFModifier.TF_MOD_SIZE, TFPotency.DRAIN, 1), "\u8ba9\u4f60\u7684\u89d2\u518d\u77ed\u70b9\u5427\uff01"));
                        if (possibleEffects.size() >= numberOfTransformations) {
                            return new TransformativePotion(itemType, possibleEffects, body);
                        }
                    }
                }
                if (target.getTailType() != body.getTail().getType() && target.getTailType() != TailType.FOX_MORPH_MAGIC && body.getTail().getType() != TailType.FOX_MORPH_MAGIC) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getTail()), TFModifier.TF_TAIL, body.getTail().getType().getTFModifier(), TFPotency.MINOR_BOOST, 1), body.getTail().getType() == TailType.NONE ? "\u4f60\u90a3\u5c3e\u5df4\u592a\u788d\u4e8b\u4e86\uff01" : "\u662f\u65f6\u5019\u957f\u6761\u65b0\u5c3e\u5df4\u4e86\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                }
                if (target.getWingType() != body.getWing().getType()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getWing()), TFModifier.TF_WINGS, body.getWing().getType().getTFModifier(), TFPotency.MINOR_BOOST, 1), body.getWing().getType() == WingType.NONE ? "\u6765\u628a\u4f60\u7684\u7fc5\u8180\u9664\u53bb\u5427\u2026\u2026" : "\u51c6\u5907\u597d\u957f\u7fc5\u8180\u4e86\u5417\uff1f"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                }
            }
            if (Main.getProperties().getForcedTFPreference() != FurryPreference.MINIMUM && possibleEffects.isEmpty()) {
                if (target.getArmType() != body.getArm().getType()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getArm()), TFModifier.TF_ARMS, TFModifier.NONE, TFPotency.MINOR_BOOST, 1), "\u4f60\u7684\u80f3\u818a\u5f97\u53d8\u53d8\u6837\uff01"));
                }
                if (target.getLegType() != body.getLeg().getType()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getLeg()), TFModifier.TF_LEGS, TFModifier.NONE, TFPotency.MINOR_BOOST, 1), "\u4f60\u7684\u817f\u4e5f\u8981\u53d8\u4e00\u4e0b\uff01"));
                }
                if (target.getLegConfiguration() != body.getLeg().getLegConfiguration()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getLeg()), TFModifier.TF_LEGS, body.getLeg().getLegConfiguration().getTFModifier(), TFPotency.MINOR_BOOST, 1), "\u6211\u8981\u8ba9\u4f60\u957f\u51fa" + UtilText.generateSingularDeterminer(body.getLeg().getLegConfiguration().getName()) + " " + body.getLeg().getLegConfiguration().getName() + "\u7684\u8eab\u4f53\uff01"));
                }
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            }
            if ((Main.getProperties().getForcedTFPreference() == FurryPreference.NORMAL || Main.getProperties().getForcedTFPreference() == FurryPreference.MAXIMUM) && possibleEffects.isEmpty()) {
                if (target.getTorsoType() != body.getTorso().getType()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getTorso()), TFModifier.TF_SKIN, TFModifier.NONE, TFPotency.MINOR_BOOST, 1), "\u8fd9\u6837\u4e00\u5b9a\u4e0d\u9519\uff01"));
                }
                if (target.getFaceType() != body.getFace().getType()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getFace()), TFModifier.TF_FACE, body.getFace().getType().getTFModifier(), TFPotency.MINOR_BOOST, 1), "\u6211\u7b49\u4e0d\u53ca\u60f3\u770b\u770b\u4f60\u7684\u6837\u5b50\u4e86\uff01"));
                }
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            }
        }
        if (this.hasFetish(Fetish.FETISH_ANAL_GIVING)) {
            if (this.getAttributeValue(Attribute.MAJOR_CORRUPTION) >= (float)CorruptionLevel.THREE_DIRTY.getMinimumValue()) {
                body.getAss().getAnus().getOrificeAnus().addOrificeModifier(null, OrificeModifier.RIBBED);
                body.getAss().getAnus().getOrificeAnus().addOrificeModifier(null, OrificeModifier.MUSCLE_CONTROL);
                body.getAss().getAnus().getOrificeAnus().addOrificeModifier(null, OrificeModifier.PUFFY);
            }
            if (this.getAttributeValue(Attribute.MAJOR_CORRUPTION) >= (float)CorruptionLevel.FOUR_LUSTFUL.getMinimumValue()) {
                body.getAss().getAnus().getOrificeAnus().addOrificeModifier(null, OrificeModifier.TENTACLED);
            }
            body.getAss().setAssSize(null, AssSize.FIVE_HUGE.getValue());
            body.getAss().setHipSize(null, HipSize.FIVE_VERY_WIDE.getValue());
        }
        if (this.hasFetish(Fetish.FETISH_BREASTS_OTHERS) && this.getGenderPreference().getGenderName().isHasBreasts()) {
            body.getBreast().setSize(null, (int)((float)body.getBreast().getRawSizeValue() * 1.5f));
        }
        if (applyingCrotchBoobTF && target.getBreastCrotchType() != body.getBreastCrotch().getType() && body.getBreastCrotch().getType() == BreastType.NONE) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(this.getItemEnchantmentEffect(itemType, body.getBreastCrotch()), TFModifier.TF_BREASTS_CROTCH, TFModifier.REMOVAL, TFPotency.MINOR_BOOST, 1), "\u8fd9\u4e9b\u6076\u5fc3\u7684\u80ef\u4e73\u8d76\u7d27\u6d88\u5931\u5427\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        }
        if (this.hasFetish(Fetish.FETISH_ORAL_RECEIVING)) {
            body.getFace().getMouth().getOrificeMouth().addOrificeModifier(null, OrificeModifier.PUFFY);
            body.getFace().getMouth().setLipSize(null, LipSize.FOUR_HUGE.getValue());
            if (this.getAttributeValue(Attribute.MAJOR_CORRUPTION) >= (float)CorruptionLevel.THREE_DIRTY.getMinimumValue()) {
                body.getFace().getMouth().getOrificeMouth().addOrificeModifier(null, OrificeModifier.RIBBED);
                body.getFace().getMouth().getOrificeMouth().addOrificeModifier(null, OrificeModifier.MUSCLE_CONTROL);
            }
            if (this.getAttributeValue(Attribute.MAJOR_CORRUPTION) >= (float)CorruptionLevel.FOUR_LUSTFUL.getMinimumValue()) {
                body.getFace().getMouth().getOrificeMouth().addOrificeModifier(null, OrificeModifier.TENTACLED);
            }
        }
        if (body.getPenis().getType() != PenisType.NONE && this.getGenderPreference() == Gender.F_P_TRAP) {
            body.getPenis().setPenisLength(null, PenisLength.ONE_TINY.getMedianValue());
            body.getPenis().getTesticle().setTesticleSize(null, TesticleSize.ONE_TINY.getValue());
            body.getPenis().getTesticle().setCumStorage(null, CumProduction.ONE_TRICKLE.getMedianValue());
        }
        if (body.getVagina().getType() != VaginaType.NONE) {
            if (this.getAttributeValue(Attribute.MAJOR_CORRUPTION) >= (float)CorruptionLevel.THREE_DIRTY.getMinimumValue()) {
                body.getVagina().getOrificeVagina().addOrificeModifier(null, OrificeModifier.RIBBED);
                body.getVagina().getOrificeVagina().addOrificeModifier(null, OrificeModifier.MUSCLE_CONTROL);
            }
            if (this.getAttributeValue(Attribute.MAJOR_CORRUPTION) >= (float)CorruptionLevel.FOUR_LUSTFUL.getMinimumValue()) {
                body.getVagina().getOrificeVagina().addOrificeModifier(null, OrificeModifier.TENTACLED);
            }
        }
        if (target.getHeightValue() + 10 < body.getHeightValue()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_CORE, TFModifier.TF_MOD_SIZE, TFPotency.MAJOR_BOOST, 1), "\u6765\u8ba9\u4f60\u957f\u9ad8\u70b9\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        } else if (target.getHeightValue() - 10 > body.getHeightValue()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_CORE, TFModifier.TF_MOD_SIZE, TFPotency.MAJOR_DRAIN, 1), "\u6765\u8ba9\u4f60\u53d8\u77ee\u70b9\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        }
        if (target.getMuscleValue() > body.getMuscle() && target.getMuscle() != Muscle.valueOf(body.getMuscle())) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_CORE, TFModifier.TF_MOD_SIZE_SECONDARY, TFPotency.MAJOR_DRAIN, 1), "\u4f60\u808c\u8089\u592a\u591a\u4e86\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        } else if (target.getMuscleValue() < body.getMuscle() && target.getMuscle() != Muscle.valueOf(body.getMuscle())) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_CORE, TFModifier.TF_MOD_SIZE_SECONDARY, TFPotency.MAJOR_BOOST, 1), "\u4f60\u8fd8\u5f97\u591a\u957f\u70b9\u808c\u8089\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        }
        if (target.getBodySizeValue() > body.getBodySize() && target.getBodySize() != BodySize.valueOf(body.getBodySize())) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_CORE, TFModifier.TF_MOD_SIZE_TERTIARY, TFPotency.MAJOR_DRAIN, 1), "\u4f60\u5f97\u53d8\u7626\u70b9\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        } else if (target.getBodySizeValue() < body.getBodySize() && target.getBodySize() != BodySize.valueOf(body.getBodySize())) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_CORE, TFModifier.TF_MOD_SIZE_TERTIARY, TFPotency.MAJOR_BOOST, 1), "\u4f60\u592a\u7626\u4e86\uff0c\u6211\u4e0d\u559c\u6b22\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        }
        if (target.getFemininityValue() < body.getFemininity() && Femininity.valueOf(target.getFemininityValue()) != Femininity.valueOf(body.getFemininity())) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_CORE, TFModifier.TF_MOD_FEMININITY, TFPotency.MAJOR_BOOST, 1), "\u6211\u5f97\u8ba9\u4f60\u66f4\u6709\u5973\u4eba\u5473\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        } else if (target.getFemininityValue() > body.getFemininity() && Femininity.valueOf(target.getFemininityValue()) != Femininity.valueOf(body.getFemininity()) && !Femininity.valueOf(body.getFemininity()).isFeminine()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_CORE, TFModifier.TF_MOD_FEMININITY, TFPotency.MAJOR_DRAIN, 1), "\u6211\u5f97\u8ba9\u4f60\u66f4\u50cf\u4e2a\u7537\u4eba\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        }
        if (target.getBreastSize().getMeasurement() + 3 <= body.getBreast().getSize().getMeasurement()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_BREASTS, TFModifier.TF_MOD_SIZE, TFPotency.MAJOR_BOOST, 1), "\u4f60\u7684\u80f8\u8fd8\u592a\u5c0f\u4e86\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        } else if (target.getBreastSize().getMeasurement() + 2 <= body.getBreast().getSize().getMeasurement()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_BREASTS, TFModifier.TF_MOD_SIZE, TFPotency.BOOST, 1), "\u4f60\u7684\u80f8\u8fd8\u4e0d\u591f\u5927\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        } else if (target.getBreastSize().getMeasurement() + 1 <= body.getBreast().getSize().getMeasurement()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_BREASTS, TFModifier.TF_MOD_SIZE, TFPotency.MINOR_BOOST, 1), "\u4f60\u7684\u80f8\u8fd8\u5f97\u7a0d\u5927\u4e00\u70b9\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        } else if (target.getBreastSize().getMeasurement() > 0) {
            if (target.getBreastSize().getMeasurement() - 3 >= body.getBreast().getSize().getMeasurement()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_BREASTS, TFModifier.TF_MOD_SIZE, TFPotency.MAJOR_DRAIN, 1), "\u4f60\u7684\u80f8\u592a\u5927\u4e86\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            } else if (target.getBreastSize().getMeasurement() - 2 >= body.getBreast().getSize().getMeasurement()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_BREASTS, TFModifier.TF_MOD_SIZE, TFPotency.DRAIN, 1), "\u4f60\u7684\u80f8\u592a\u5927\u4e86\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            } else if (target.getBreastSize().getMeasurement() - 1 >= body.getBreast().getSize().getMeasurement()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_BREASTS, TFModifier.TF_MOD_SIZE, TFPotency.MINOR_DRAIN, 1), "\u4f60\u7684\u80f8\u90e8\u6709\u70b9\u592a\u5927\u4e86\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            }
        }
        if (applyingCrotchBoobTF && body.getBreastCrotch().getType() != BreastType.NONE) {
            if (target.getBreastCrotchSize().getMeasurement() + 3 <= body.getBreastCrotch().getSize().getMeasurement()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_BREASTS_CROTCH, TFModifier.TF_MOD_SIZE, TFPotency.MAJOR_BOOST, 1), "\u4f60\u7684\u80ef\u4e73\u8fd8\u592a\u5c0f\u4e86\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            } else if (target.getBreastCrotchSize().getMeasurement() + 2 <= body.getBreastCrotch().getSize().getMeasurement()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_BREASTS_CROTCH, TFModifier.TF_MOD_SIZE, TFPotency.BOOST, 1), "\u4f60\u7684\u80ef\u4e73\u4e0d\u591f\u5927\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            } else if (target.getBreastCrotchSize().getMeasurement() + 1 <= body.getBreastCrotch().getSize().getMeasurement()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_BREASTS_CROTCH, TFModifier.TF_MOD_SIZE, TFPotency.MINOR_BOOST, 1), "\u4f60\u7684\u80ef\u4e73\u8fd8\u5f97\u7a0d\u5927\u4e00\u70b9\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            } else if (target.getBreastCrotchSize().getMeasurement() > 0) {
                if (target.getBreastCrotchSize().getMeasurement() - 3 >= body.getBreastCrotch().getSize().getMeasurement()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_BREASTS_CROTCH, TFModifier.TF_MOD_SIZE, TFPotency.MAJOR_DRAIN, 1), "\u4f60\u7684\u80ef\u4e73\u592a\u5927\u4e86\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                } else if (target.getBreastCrotchSize().getMeasurement() - 2 >= body.getBreastCrotch().getSize().getMeasurement()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_BREASTS_CROTCH, TFModifier.TF_MOD_SIZE, TFPotency.DRAIN, 1), "\u4f60\u7684\u80ef\u4e73\u592a\u5927\u4e86\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                } else if (target.getBreastCrotchSize().getMeasurement() - 1 >= body.getBreastCrotch().getSize().getMeasurement()) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_BREASTS_CROTCH, TFModifier.TF_MOD_SIZE, TFPotency.MINOR_DRAIN, 1), "\u4f60\u7684\u80ef\u4e73\u6709\u70b9\u592a\u5927\u4e86\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                }
            }
        }
        if (target.getAssSize().getValue() + 1 < body.getAss().getAssSize().getValue()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_ASS, TFModifier.TF_MOD_SIZE, TFPotency.BOOST, 1), "\u4f60\u7684\u5c41\u80a1\u8fd8\u5f97\u518d\u5927\u70b9\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        } else if (target.getAssSize().getValue() - 1 > body.getAss().getAssSize().getValue()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_ASS, TFModifier.TF_MOD_SIZE, TFPotency.DRAIN, 1), "\u4f60\u7684\u5c41\u80a1\u592a\u5927\u4e86\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        }
        if (target.getAssRawCapacityValue() + 10.0f < body.getAss().getAnus().getOrificeAnus().getRawCapacityValue()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_ASS, TFModifier.TF_MOD_CAPACITY, TFPotency.BOOST, 1), "\u4f60\u7684\u5c41\u80a1\u592a\u7d27\u4e86\uff0c\u6211\u4e0d\u559c\u6b22\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        } else if (target.getAssRawCapacityValue() - 20.0f > body.getAss().getAnus().getOrificeAnus().getRawCapacityValue()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_ASS, TFModifier.TF_MOD_CAPACITY, TFPotency.MAJOR_DRAIN, 1), "\u4f60\u540e\u9762\u4e5f\u592a\u677e\u4e86\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        }
        if (target.getAssWetness().getValue() < body.getAss().getAnus().getOrificeAnus().getWetness(null).getValue()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_ASS, TFModifier.TF_MOD_WETNESS, TFPotency.MINOR_BOOST, 1), "\u4f60\u7684\u5c41\u80a1\u592a\u5e72\u4e86\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        }
        if (target.getHipSize().getValue() + 1 < body.getAss().getHipSize().getValue()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_ASS, TFModifier.TF_MOD_SIZE_SECONDARY, TFPotency.BOOST, 1), "\u81c0\u90e8\u5e94\u8be5\u518d\u5bbd\u4e00\u70b9\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        } else if (target.getHipSize().getValue() - 1 > body.getAss().getHipSize().getValue()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_ASS, TFModifier.TF_MOD_SIZE_SECONDARY, TFPotency.DRAIN, 1), "\u4f60\u7684\u81c0\u90e8\u592a\u5bbd\u4e86\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        }
        boolean doubleApplication = Math.abs(target.getHairRawLengthValue() - body.getHair().getRawLengthValue()) > 20;
        for (int i = 0; i < (doubleApplication ? 2 : 1); ++i) {
            boolean majorChange;
            boolean bl3 = majorChange = Math.abs(target.getHairRawLengthValue() - body.getHair().getRawLengthValue()) > (i == 0 && doubleApplication ? 30 : 15);
            if (target.getHairRawLengthValue() + 6 < body.getHair().getRawLengthValue()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_HAIR, TFModifier.TF_MOD_SIZE, majorChange ? TFPotency.MAJOR_BOOST : TFPotency.BOOST, 1), i == 0 ? "\u4f60\u7684[pc.hair(true)]\u600e\u4e48\u8fd9\u4e48\u77ed\uff01" : "\u8ba9\u4f60\u7684[pc.hair(true)]\u66f4\u957f\u4e9b\u5427\uff01"));
                continue;
            }
            if (target.getHairRawLengthValue() <= body.getHair().getRawLengthValue()) continue;
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_HAIR, TFModifier.TF_MOD_SIZE, majorChange ? TFPotency.MAJOR_DRAIN : TFPotency.DRAIN, 1), i == 0 ? "\u4f60\u7684[pc.hair(true)]\u4e5f\u592a\u957f\u4e86\uff01" : "\u8ba9\u4f60\u7684[pc.hair(true)]\u66f4\u77ed\u4e9b\u5427\uff01"));
        }
        if (possibleEffects.size() >= numberOfTransformations) {
            return new TransformativePotion(itemType, possibleEffects, body);
        }
        if (target.getLipSize().getValue() + 1 < body.getFace().getMouth().getLipSize().getValue()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_FACE, TFModifier.TF_MOD_SIZE, TFPotency.BOOST, 1), "\u4f60\u7684\u820c\u5934[pc.lips]\u592a\u5c0f\u4e86\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        } else if (target.getLipSize().getValue() - 1 > body.getFace().getMouth().getLipSize().getValue()) {
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_FACE, TFModifier.TF_MOD_SIZE, TFPotency.DRAIN, 1), "\u4f60[pc.lips]\u592a\u5927\u4e86\uff01"));
            if (possibleEffects.size() >= numberOfTransformations) {
                return new TransformativePotion(itemType, possibleEffects, body);
            }
        }
        if (target.getPenisType() != PenisType.NONE && body.getPenis().getType() != PenisType.NONE) {
            if (target.getPenisRawCumStorageValue() < body.getPenis().getTesticle().getRawCumStorageValue()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_CUM, TFModifier.TF_MOD_WETNESS, TFPotency.MAJOR_BOOST, 1), "\u55ef\u55ef\u55ef\uff01\u4f60\u4f1a\u7ed9\u6211\u5236\u9020\u5f88\u591a\u7cbe\u6db2\u7684\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            }
            if (target.getPenisRawSizeValue() < body.getPenis().getRawLengthValue()) {
                if (body.getPenis().getRawLengthValue() - target.getPenisRawSizeValue() > 5) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_PENIS, TFModifier.TF_MOD_SIZE, TFPotency.BOOST, 1), "\u4f60\u7684\u9e21\u5df4\u8fd8\u5f97\u5927\u4e0d\u5c11\u624d\u884c\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                } else {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_PENIS, TFModifier.TF_MOD_SIZE, TFPotency.MINOR_BOOST, 1), "\u4f60\u7684\u4e0b\u9762\u8fd8\u5f97\u518d\u5927\u70b9\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                }
            } else if (target.getPenisRawSizeValue() > body.getPenis().getRawLengthValue()) {
                if (target.getPenisRawSizeValue() - body.getPenis().getRawLengthValue() > 5) {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_PENIS, TFModifier.TF_MOD_SIZE, TFPotency.DRAIN, 1), "\u4f60\u7684\u9e21\u5df4\u5f97\u591a\u7f29\u5c0f\u4e9b\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                } else {
                    possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_PENIS, TFModifier.TF_MOD_SIZE, TFPotency.MINOR_DRAIN, 1), "\u4f60\u7684\u4e0b\u9762\u5c0f\u70b9\u66f4\u597d\uff01"));
                    if (possibleEffects.size() >= numberOfTransformations) {
                        return new TransformativePotion(itemType, possibleEffects, body);
                    }
                }
            }
            if (target.getPenisRawGirthValue() < body.getPenis().getRawGirthValue()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_PENIS, TFModifier.TF_MOD_SIZE_SECONDARY, TFPotency.MINOR_BOOST, 1), "\u6211\u60f3\u8ba9\u4f60\u7684\u9e21\u5df4\u518d\u591a\u7c97\u58ee\u4e9b\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            } else if (target.getPenisRawGirthValue() > body.getPenis().getRawGirthValue()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_PENIS, TFModifier.TF_MOD_SIZE_SECONDARY, TFPotency.MINOR_DRAIN, 1), "\u4f60\u7684\u5c4c\u4e5f\u592a\u7c97\u4e86\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            }
            if (target.getTesticleSize().getValue() < body.getPenis().getTesticle().getTesticleSize().getValue()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_PENIS, TFModifier.TF_MOD_SIZE_TERTIARY, TFPotency.MINOR_BOOST, 1), "\u4f60\u7684\u86cb\u86cb\u8fd8\u4e0d\u591f\u5927\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            } else if (target.getTesticleSize().getValue() > body.getPenis().getTesticle().getTesticleSize().getValue()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_PENIS, TFModifier.TF_MOD_SIZE_TERTIARY, TFPotency.MINOR_DRAIN, 1), "\u4f60\u7684\u86cb\u86cb\u53ef\u4e0d\u80fd\u8fd9\u4e48\u5927\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            }
        }
        if (target.getVaginaType() != VaginaType.NONE && body.getVagina().getType() != VaginaType.NONE) {
            if (target.getVaginaRawCapacityValue() + 10.0f < body.getVagina().getOrificeVagina().getRawCapacityValue()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_VAGINA, TFModifier.TF_MOD_CAPACITY, TFPotency.BOOST, 1), "\u4f60\u7684\u5c0f\u7a74\u592a\u7d27\u4e86\uff0c\u6211\u4e0d\u559c\u6b22\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            } else if (target.getVaginaRawCapacityValue() - 20.0f > body.getVagina().getOrificeVagina().getRawCapacityValue()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_VAGINA, TFModifier.TF_MOD_CAPACITY, TFPotency.MAJOR_DRAIN, 1), "\u4f60\u5c0f\u7a74\u4e5f\u592a\u677e\u4e86\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            }
            if (target.getVaginaWetness().getValue() < body.getVagina().getOrificeVagina().getWetness(null).getValue()) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), TFModifier.TF_VAGINA, TFModifier.TF_MOD_WETNESS, TFPotency.MINOR_BOOST, 1), "\u4f60\u7684\u5c0f\u7a74\u8fd8\u4e0d\u591f\u6e7f\uff01"));
                if (possibleEffects.size() >= numberOfTransformations) {
                    return new TransformativePotion(itemType, possibleEffects, body);
                }
            }
        }
        if (possibleEffects.isEmpty()) {
            return null;
        }
        return new TransformativePotion(itemType, possibleEffects, body);
    }

    public String applyPotion(AbstractPotion potion, GameCharacter target) {
        StringBuilder sb = new StringBuilder();
        potion.getEffects().forEach(e -> sb.append(UtilText.parse((GameCharacter)this, (String)(!this.isMute() && e.getMessage() != null && !e.getMessage().isEmpty() ? "<p>[npc.speech(" + e.getMessage() + ")]</p>" : "") + e.getEffect().applyEffect(this, target, 1), new ParserTag[0])));
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void generatePartnerPreferences() {
        void var6_31;
        void var5_16;
        Gender preferredGender = Gender.N_P_V_B_HERMAPHRODITE;
        HashMap<Gender, Integer> desiredGenders = new HashMap<Gender, Integer>();
        switch (this.getSexualOrientation()) {
            case AMBIPHILIC: {
                if (this.isFeminine() && Main.getProperties().getForcedTFTendency() != ForcedTFTendency.FEMININE && Main.getProperties().getForcedTFTendency() != ForcedTFTendency.FEMININE_HEAVY) {
                    desiredGenders.put(Gender.M_P_MALE, 14);
                    desiredGenders.put(Gender.M_P_V_HERMAPHRODITE, 2);
                    desiredGenders.put(Gender.M_V_CUNTBOY, 2);
                    desiredGenders.put(Gender.F_P_TRAP, 2);
                    break;
                }
                desiredGenders.put(Gender.F_V_B_FEMALE, 14);
                if (this.hasVagina() && this.hasFetish(Fetish.FETISH_PREGNANCY)) {
                    desiredGenders.put(Gender.F_P_V_B_FUTANARI, 4);
                    desiredGenders.put(Gender.F_P_B_SHEMALE, 4);
                    desiredGenders.put(Gender.F_P_TRAP, 4);
                } else {
                    desiredGenders.put(Gender.F_P_V_B_FUTANARI, 2);
                    desiredGenders.put(Gender.F_P_B_SHEMALE, 2);
                    desiredGenders.put(Gender.F_P_TRAP, 2);
                }
                if (Main.getProperties().getForcedTFTendency() != ForcedTFTendency.MASCULINE_HEAVY) break;
                desiredGenders.put(Gender.M_P_V_HERMAPHRODITE, 4);
                desiredGenders.put(Gender.M_V_CUNTBOY, 4);
                desiredGenders.put(Gender.F_P_TRAP, 4);
                desiredGenders.put(Gender.M_V_B_BUTCH, 4);
                break;
            }
            case ANDROPHILIC: {
                if (Main.getProperties().getForcedTFTendency() != ForcedTFTendency.FEMININE_HEAVY) {
                    desiredGenders.put(Gender.M_P_MALE, 14);
                }
                desiredGenders.put(Gender.M_P_V_HERMAPHRODITE, 2);
                desiredGenders.put(Gender.M_V_CUNTBOY, 2);
                if (Main.getProperties().getForcedTFTendency() != ForcedTFTendency.FEMININE && Main.getProperties().getForcedTFTendency() != ForcedTFTendency.FEMININE_HEAVY) break;
                desiredGenders.put(Gender.F_P_V_B_FUTANARI, 2);
                desiredGenders.put(Gender.F_P_B_SHEMALE, 2);
                desiredGenders.put(Gender.F_P_TRAP, 2);
                desiredGenders.put(Gender.M_V_B_BUTCH, 2);
                break;
            }
            case GYNEPHILIC: {
                if (this.hasVagina() && this.hasFetish(Fetish.FETISH_PREGNANCY)) {
                    desiredGenders.put(Gender.F_P_V_B_FUTANARI, 2);
                    desiredGenders.put(Gender.F_P_B_SHEMALE, 2);
                    desiredGenders.put(Gender.F_P_TRAP, 2);
                } else if (Main.getProperties().getForcedTFTendency() == ForcedTFTendency.MASCULINE_HEAVY) {
                    desiredGenders.put(Gender.F_V_B_FEMALE, 4);
                } else {
                    desiredGenders.put(Gender.F_V_B_FEMALE, 14);
                }
                if (Main.getProperties().getForcedTFTendency() != ForcedTFTendency.MASCULINE && Main.getProperties().getForcedTFTendency() != ForcedTFTendency.MASCULINE_HEAVY) break;
                desiredGenders.put(Gender.M_P_V_HERMAPHRODITE, 2);
                desiredGenders.put(Gender.M_V_CUNTBOY, 2);
                desiredGenders.put(Gender.M_V_B_BUTCH, 2);
                desiredGenders.put(Gender.F_P_TRAP, 2);
            }
        }
        int total = 0;
        for (Map.Entry entry : desiredGenders.entrySet()) {
            total += ((Integer)entry.getValue()).intValue();
        }
        int count = Util.random.nextInt(total) + 1;
        total = 0;
        for (Map.Entry entry : desiredGenders.entrySet()) {
            if (total < count && total + (Integer)entry.getValue() >= count) {
                preferredGender = (Gender)((Object)entry.getKey());
                break;
            }
            total += ((Integer)entry.getValue()).intValue();
        }
        this.genderPreference = preferredGender;
        AbstractSubspecies abstractSubspecies = this.getSubspecies();
        RaceStage raceStage = this.getRaceStage();
        if (Main.getProperties().getForcedTFPreference() == FurryPreference.HUMAN) {
            AbstractSubspecies abstractSubspecies2 = Subspecies.HUMAN;
            RaceStage raceStage2 = RaceStage.HUMAN;
        } else {
            ArrayList<AbstractSubspecies> availableRaces;
            if (this.getRace() == Race.CAT_MORPH && Math.random() > (double)0.8f) {
                AbstractSubspecies abstractSubspecies3 = Subspecies.HARPY;
            }
            if ((this.getRace() == Race.WOLF_MORPH || this.getRace() == Race.DOG_MORPH) && Math.random() > (double)0.8f) {
                availableRaces = new ArrayList<AbstractSubspecies>();
                availableRaces.add(Subspecies.CAT_MORPH);
                availableRaces.add(Subspecies.HARPY);
                availableRaces.add(Subspecies.COW_MORPH);
                availableRaces.add(Subspecies.SQUIRREL_MORPH);
                AbstractSubspecies abstractSubspecies4 = (AbstractSubspecies)availableRaces.get(Util.random.nextInt(availableRaces.size()));
            }
            if (Math.random() <= (double)Main.getProperties().getRandomRacePercentage()) {
                availableRaces = new ArrayList();
                availableRaces.add(Subspecies.CAT_MORPH);
                availableRaces.add(Subspecies.DOG_MORPH);
                availableRaces.add(Subspecies.HARPY);
                availableRaces.add(Subspecies.HORSE_MORPH);
                availableRaces.add(Subspecies.HUMAN);
                availableRaces.add(Subspecies.SQUIRREL_MORPH);
                availableRaces.add(Subspecies.COW_MORPH);
                availableRaces.add(Subspecies.WOLF_MORPH);
                AbstractSubspecies abstractSubspecies5 = (AbstractSubspecies)availableRaces.get(Util.random.nextInt(availableRaces.size()));
            }
            if (preferredGender.isFeminine()) {
                switch (Main.getProperties().getSubspeciesFeminineFurryPreferencesMap().get(var5_15)) {
                    case HUMAN: {
                        RaceStage raceStage3 = RaceStage.HUMAN;
                        break;
                    }
                    case MAXIMUM: {
                        RaceStage raceStage4 = RaceStage.GREATER;
                        break;
                    }
                    case MINIMUM: {
                        RaceStage raceStage5 = RaceStage.PARTIAL_FULL;
                        break;
                    }
                    case NORMAL: {
                        RaceStage raceStage6 = RaceStage.GREATER;
                        break;
                    }
                    case REDUCED: {
                        RaceStage raceStage7 = RaceStage.LESSER;
                    }
                }
            } else {
                switch (Main.getProperties().getSubspeciesMasculineFurryPreferencesMap().get(var5_15)) {
                    case HUMAN: {
                        RaceStage raceStage8 = RaceStage.HUMAN;
                        break;
                    }
                    case MAXIMUM: {
                        RaceStage raceStage9 = RaceStage.GREATER;
                        break;
                    }
                    case MINIMUM: {
                        RaceStage raceStage10 = RaceStage.PARTIAL_FULL;
                        break;
                    }
                    case NORMAL: {
                        RaceStage raceStage11 = RaceStage.GREATER;
                        break;
                    }
                    case REDUCED: {
                        RaceStage raceStage12 = RaceStage.LESSER;
                    }
                }
            }
        }
        this.subspeciesPreference = var5_16;
        this.raceStagePreference = var6_31;
    }

    /*
     * WARNING - void declaration
     */
    public FetishPotion generateFetishPotion(GameCharacter target, Boolean pairedFetishesOnly) {
        String selectedEffectString;
        void var29_31;
        ItemEffect selectedEffect = null;
        ArrayList<PossibleItemEffect> possibleEffects = new ArrayList<PossibleItemEffect>();
        AbstractItemType itemType = ItemType.FETISH_UNREFINED;
        AbstractFetish currentTopFetish = null;
        AbstractFetish currentBottomFetish = null;
        TFModifier currentTopModifier = null;
        TFModifier currentBottomModifier = null;
        TFPotency currentTopPotency = null;
        TFPotency currentBottomPotency = null;
        TFPotency currentTopRemovePotency = null;
        TFPotency currentBottomRemovePotency = null;
        int baseTopChance = 5;
        int baseBottomChance = 5;
        int baseTopRemoveChance = 0;
        int baseBottomRemoveChance = 0;
        int currentTopChance = 0;
        int currentBottomChance = 0;
        int currentTopRemoveChance = 0;
        int currentBottomRemoveChance = 0;
        int pairedFetishMultiplier = 5;
        int matchedFetishDecrement = 8;
        int matchedFetishRemoveIncrement = 1;
        int desiredFetishIncrement = 2;
        int expFetishIncrement = 1;
        switch (Main.getProperties().getForcedFetishTendency()) {
            case NEUTRAL: {
                baseTopChance = 5;
                baseBottomChance = 5;
                baseTopRemoveChance = 2;
                baseBottomRemoveChance = 2;
                break;
            }
            case BOTTOM: {
                baseTopChance = 1;
                baseBottomChance = 8;
                baseTopRemoveChance = 3;
                baseBottomRemoveChance = 0;
                break;
            }
            case BOTTOM_HEAVY: {
                baseTopChance = -2;
                baseBottomChance = 10;
                baseTopRemoveChance = 4;
                baseBottomRemoveChance = -1;
                break;
            }
            case TOP: {
                baseTopChance = 8;
                baseBottomChance = 1;
                baseTopRemoveChance = 0;
                baseBottomRemoveChance = 3;
                break;
            }
            case TOP_HEAVY: {
                baseTopChance = 10;
                baseBottomChance = -2;
                baseTopRemoveChance = -1;
                baseBottomRemoveChance = 4;
            }
        }
        for (AbstractFetish abstractFetish : Fetish.getAllFetishes()) {
            int n;
            if (abstractFetish.getOpposite() == null || !abstractFetish.getFetishesForAutomaticUnlock().isEmpty() || abstractFetish.equals(Fetish.FETISH_TRANSFORMATION_GIVING) || abstractFetish.equals(Fetish.FETISH_KINK_GIVING)) continue;
            currentTopFetish = abstractFetish;
            currentBottomFetish = abstractFetish.getOpposite();
            currentTopModifier = TFModifier.valueOf("TF_MOD_" + Fetish.getIdFromFetish(currentTopFetish));
            currentBottomModifier = TFModifier.valueOf("TF_MOD_" + Fetish.getIdFromFetish(currentBottomFetish));
            currentTopPotency = TFPotency.MINOR_BOOST;
            currentBottomPotency = TFPotency.MINOR_BOOST;
            currentTopRemovePotency = TFPotency.MINOR_DRAIN;
            currentBottomRemovePotency = TFPotency.MINOR_DRAIN;
            currentTopChance = baseTopChance;
            currentBottomChance = baseBottomChance;
            currentTopRemoveChance = baseTopRemoveChance;
            currentBottomRemoveChance = baseBottomRemoveChance;
            switch (this.getFetishDesire(currentBottomFetish)) {
                case THREE_LIKE: {
                    currentTopChance += desiredFetishIncrement;
                    break;
                }
                case FOUR_LOVE: {
                    currentTopChance += desiredFetishIncrement * 2;
                    break;
                }
                case ONE_DISLIKE: {
                    currentTopChance -= desiredFetishIncrement;
                    break;
                }
                case ZERO_HATE: {
                    currentTopChance = 0;
                    break;
                }
            }
            switch (this.getFetishDesire(currentTopFetish)) {
                case THREE_LIKE: {
                    currentBottomChance += desiredFetishIncrement;
                    break;
                }
                case FOUR_LOVE: {
                    currentBottomChance += desiredFetishIncrement * 2;
                    break;
                }
                case ONE_DISLIKE: {
                    currentBottomChance -= desiredFetishIncrement;
                    break;
                }
                case ZERO_HATE: {
                    currentBottomChance = 0;
                    break;
                }
            }
            switch (this.getFetishLevel(currentBottomFetish)) {
                case ONE_AMATEUR: {
                    currentTopChance += expFetishIncrement;
                    break;
                }
                case TWO_EXPERIENCED: {
                    currentTopChance += expFetishIncrement * 2;
                    break;
                }
                case THREE_EXPERT: {
                    currentTopChance += expFetishIncrement * 3;
                    break;
                }
                case FOUR_MASTERFUL: {
                    currentTopChance += expFetishIncrement * 4;
                    break;
                }
            }
            switch (this.getFetishLevel(currentTopFetish)) {
                case ONE_AMATEUR: {
                    currentBottomChance += expFetishIncrement;
                    break;
                }
                case TWO_EXPERIENCED: {
                    currentBottomChance += expFetishIncrement * 2;
                    break;
                }
                case THREE_EXPERT: {
                    currentBottomChance += expFetishIncrement * 3;
                    break;
                }
                case FOUR_MASTERFUL: {
                    currentBottomChance += expFetishIncrement * 4;
                    break;
                }
            }
            if (this.hasFetish(currentTopFetish)) {
                currentBottomChance *= pairedFetishMultiplier;
                currentTopChance -= matchedFetishDecrement;
                currentBottomRemoveChance = 0;
                if (!pairedFetishesOnly.booleanValue()) {
                    currentTopRemoveChance += matchedFetishRemoveIncrement;
                }
            } else if (pairedFetishesOnly.booleanValue()) {
                currentBottomChance = 0;
                currentTopRemoveChance = 0;
                currentBottomRemoveChance = 0;
            }
            if (this.hasFetish(currentBottomFetish)) {
                currentTopChance *= pairedFetishMultiplier;
                currentBottomChance -= matchedFetishDecrement;
                currentTopRemoveChance = 0;
                if (!pairedFetishesOnly.booleanValue()) {
                    currentBottomRemoveChance += matchedFetishRemoveIncrement;
                }
            } else if (pairedFetishesOnly.booleanValue()) {
                currentTopChance = 0;
                currentTopRemoveChance = 0;
                currentBottomRemoveChance = 0;
            }
            if (target.getFetishDesire(currentBottomFetish) == FetishDesire.THREE_LIKE || target.getFetishDesire(currentBottomFetish) == FetishDesire.FOUR_LOVE) {
                currentBottomPotency = TFPotency.BOOST;
            } else if (target.getFetishDesire(currentBottomFetish) == FetishDesire.TWO_NEUTRAL) {
                n = Util.random.nextInt(100);
                if (this.hasFetish(currentTopFetish) && n < 30) {
                    currentBottomPotency = TFPotency.BOOST;
                }
            } else {
                currentBottomRemoveChance = 0;
            }
            if (target.hasFetish(currentBottomFetish)) {
                currentBottomChance = 0;
                currentBottomRemovePotency = TFPotency.DRAIN;
            }
            if (target.getFetishDesire(currentTopFetish) == FetishDesire.THREE_LIKE || target.getFetishDesire(currentTopFetish) == FetishDesire.FOUR_LOVE) {
                currentTopPotency = TFPotency.BOOST;
            } else if (target.getFetishDesire(currentTopFetish) == FetishDesire.TWO_NEUTRAL) {
                n = Util.random.nextInt(100);
                if (this.hasFetish(currentBottomFetish) && n < 30) {
                    currentTopPotency = TFPotency.BOOST;
                }
            } else {
                currentTopRemoveChance = 0;
            }
            if (target.hasFetish(currentTopFetish)) {
                currentTopChance = 0;
                currentTopRemovePotency = TFPotency.DRAIN;
            }
            if (currentTopChance < 0) {
                currentTopChance = 0;
            }
            if (currentBottomChance < 0) {
                currentBottomChance = 0;
            }
            if (currentTopRemoveChance < 0) {
                currentTopRemoveChance = 0;
            }
            if (currentBottomRemoveChance < 0) {
                currentBottomRemoveChance = 0;
            }
            if (currentTopChance > 0) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), currentTopFetish.getAssociatedTFModifier(), currentTopModifier, currentTopPotency, 1), currentTopChance));
            }
            if (currentTopRemoveChance > 0) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), currentTopFetish.getAssociatedTFModifier(), currentTopModifier, currentTopRemovePotency, 1), currentTopRemoveChance));
            }
            if (currentBottomChance > 0) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), currentBottomFetish.getAssociatedTFModifier(), currentBottomModifier, currentBottomPotency, 1), currentBottomChance));
            }
            if (currentBottomRemoveChance <= 0) continue;
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), currentBottomFetish.getAssociatedTFModifier(), currentBottomModifier, currentBottomRemovePotency, 1), currentBottomRemoveChance));
        }
        HashMap<AbstractFetish, Boolean> unpairedFetishMap = new HashMap<AbstractFetish, Boolean>();
        unpairedFetishMap.put(Fetish.FETISH_BIMBO, true);
        unpairedFetishMap.put(Fetish.FETISH_CROSS_DRESSER, true);
        unpairedFetishMap.put(Fetish.FETISH_INCEST, true);
        unpairedFetishMap.put(Fetish.FETISH_MASTURBATION, true);
        for (Map.Entry entry : unpairedFetishMap.entrySet()) {
            currentTopFetish = (AbstractFetish)entry.getKey();
            Boolean bl = (Boolean)entry.getValue();
            currentTopModifier = TFModifier.valueOf("TF_MOD_" + Fetish.getIdFromFetish(currentTopFetish));
            currentTopPotency = TFPotency.MINOR_BOOST;
            currentTopRemovePotency = TFPotency.MINOR_DRAIN;
            currentTopChance = baseTopChance;
            currentTopRemoveChance = baseTopRemoveChance;
            if (bl.booleanValue()) {
                switch (this.getFetishDesire(currentTopFetish)) {
                    case THREE_LIKE: {
                        currentTopChance += desiredFetishIncrement;
                        break;
                    }
                    case FOUR_LOVE: {
                        currentTopChance += desiredFetishIncrement * 2;
                        break;
                    }
                    case ONE_DISLIKE: {
                        currentTopChance -= desiredFetishIncrement;
                        break;
                    }
                    case ZERO_HATE: {
                        currentTopChance = 0;
                        break;
                    }
                }
                switch (this.getFetishLevel(currentTopFetish)) {
                    case ONE_AMATEUR: {
                        currentTopChance += expFetishIncrement;
                        break;
                    }
                    case TWO_EXPERIENCED: {
                        currentTopChance += expFetishIncrement * 2;
                        break;
                    }
                    case THREE_EXPERT: {
                        currentTopChance += expFetishIncrement * 3;
                        break;
                    }
                    case FOUR_MASTERFUL: {
                        currentTopChance += expFetishIncrement * 4;
                        break;
                    }
                }
            }
            if (this.hasFetish(currentTopFetish)) {
                if (bl.booleanValue()) {
                    currentTopChance *= pairedFetishMultiplier;
                    currentTopRemoveChance = 0;
                } else if (pairedFetishesOnly.booleanValue()) {
                    currentTopChance = 0;
                } else {
                    currentTopChance -= matchedFetishDecrement;
                    currentTopRemoveChance += matchedFetishRemoveIncrement;
                }
            } else if (pairedFetishesOnly.booleanValue() && bl.booleanValue()) {
                currentTopChance = 0;
                currentTopRemoveChance = 0;
            }
            if (target.getFetishDesire(currentTopFetish) == FetishDesire.THREE_LIKE || target.getFetishDesire(currentTopFetish) == FetishDesire.FOUR_LOVE) {
                currentTopPotency = TFPotency.BOOST;
            } else if (target.getFetishDesire(currentTopFetish) == FetishDesire.TWO_NEUTRAL) {
                int rand = Util.random.nextInt(100);
                if (bl.booleanValue() && this.hasFetish(currentBottomFetish) && rand < 30) {
                    currentTopPotency = TFPotency.BOOST;
                }
            } else {
                currentTopRemoveChance = 0;
            }
            if (target.hasFetish(currentTopFetish)) {
                currentTopChance = 0;
                currentTopRemovePotency = TFPotency.DRAIN;
            }
            if (currentTopChance < 0) {
                currentTopChance = 0;
            }
            if (currentTopRemoveChance < 0) {
                currentTopRemoveChance = 0;
            }
            if (currentTopChance > 0) {
                possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), currentTopFetish.getAssociatedTFModifier(), currentTopModifier, currentTopPotency, 1), currentTopChance));
            }
            if (currentTopRemoveChance <= 0) continue;
            possibleEffects.add(new PossibleItemEffect(new ItemEffect(itemType.getEnchantmentEffect(), currentTopFetish.getAssociatedTFModifier(), currentTopModifier, currentTopRemovePotency, 1), currentTopRemoveChance));
        }
        boolean bl = false;
        for (PossibleItemEffect possibleItemEffect : possibleEffects) {
            var29_31 += possibleItemEffect.getChance();
        }
        if (var29_31 == false) {
            return null;
        }
        int n = Util.random.nextInt((int)var29_31) + 1;
        boolean bl2 = false;
        for (PossibleItemEffect entry : possibleEffects) {
            void var29_33;
            if (var29_33 < n && var29_33 + entry.getChance() >= n) {
                selectedEffect = entry.getEffect();
                break;
            }
            var29_33 += entry.getChance();
        }
        if (selectedEffect == null) {
            return null;
        }
        HashMap<TFModifier, String> hashMap = new HashMap<TFModifier, String>();
        HashMap<TFModifier, String> fetishRemoveFlavorText = new HashMap<TFModifier, String>();
        String defaultFetishAddFlavorText = "\u4e3a\u4ec0\u4e48\u4e0d\u773c\u754c\u5bbd\u9614\u70b9\uff0c\u55ef\uff1f";
        String defaultFetishRemoveFlavorText = "\u8fd9\u4e9b\u4e0d\u5f97\u4e86\u7684\u73a9\u610f\uff0c\u4f60\u8fd8\u662f\u51b7\u9759\u4e00\u4e0b\u5427\uff0c\u55ef\uff1f";
        hashMap.put(TFModifier.TF_MOD_FETISH_PENIS_GIVING, "\u4f60\u4f1a\u559c\u6b22\u4e0a\u7528\u80ef\u4e0b\u90a3\u6839\u8089\u68d2\u7684\uff01");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_PENIS_GIVING, "\u662f\u65f6\u5019\u522b\u8fd9\u4e48\u6c89\u8ff7\u4e8e\u4f60\u90a3\u6839\u8089\u68d2\u4e86\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_PENIS_RECEIVING, "\u7ed9\u6211\u559c\u6b22\u4e0a\u53c8\u7c97\u53c8\u5927\u7684\u9e21\u5df4\u5427\uff01");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_PENIS_RECEIVING, "\u522b\u518d\u90a3\u4e48\u559c\u6b22\u8089\u68d2\u4e86\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_ANAL_GIVING, "\u4ece\u6b64\u4e4b\u540e\u4f60\u4f1a\u7231\u4e0a\u83ca\u82b1\u7684\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_ANAL_GIVING, "\u51b7\u9759\u4e00\u4e0b\uff0c\u522b\u6ee1\u8111\u5b50\u60f3\u64cd\u522b\u4eba\u5c41\u80a1\u4e86\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_ANAL_RECEIVING, "\u4f60\u4f1a\u559c\u6b22\u628a\u5b83\u5403\u8fdb\u83ca\u82b1\u7684\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_ANAL_RECEIVING, "\u4e5f\u8bb8\u4f60\u5e94\u8be5\u5bf9\u88ab\u64cd\u83ca\u82b1\u7684\u4e8b\u51b7\u9759\u70b9\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_BREASTS_OTHERS, "\u4f60\u96be\u9053\u4e0d\u559c\u6b22\u6f02\u4eae\u7684\u5976\u5b50\u5417\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_BREASTS_OTHERS, "\u4f60\u592a\u559c\u6b22\u80f8\u90e8\u4e86\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_BREASTS_SELF, "\u4f60\u4e0d\u60f3\u597d\u597d\u5229\u7528\u4e00\u4e0b\u4f60\u7684\u80f8\u90e8\u5417\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_BREASTS_SELF, "\u4f60\u592a\u559c\u6b22\u4f60\u7684\u80f8\u90e8\u4e86\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_ORAL_GIVING, "\u4f60\u90a3\u5f20\u6f02\u4eae\u7684\u5634\u8981\u6d3e\u4e0a\u7528\u573a\u4e86\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_ORAL_GIVING, "\u4f60\u6ca1\u5fc5\u8981\u89c1\u5230\u9e21\u5df4\u5c31\u8214\uff0c\u4e0d\u662f\u5417\uff1f");
        hashMap.put(TFModifier.TF_MOD_FETISH_ORAL_RECEIVING, "\u4f60\u4e0d\u662f\u5f88\u559c\u6b22\u63a5\u53d7\u53e3\u4ea4\u5417\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_ORAL_RECEIVING, "\u6ca1\u4eba\u559c\u6b22\u88ab\u64cd\u8fdb\u5634\u91cc\uff0c\u4f60\u77e5\u9053\u7684\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_VAGINAL_GIVING, "\u6ca1\u4ec0\u4e48\u6bd4\u5f97\u4e0a\u53bb\u64cd\u4e2a\u6e7f\u4e4e\u4e4e\u7684\u5c0f\u7a74\uff0c\u662f\u5427\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_VAGINAL_GIVING, "\u6027\u7231\u4e0d\u4ec5\u9650\u4e8e\u5c0f\u7a74\u3002\u62d3\u5c55\u4e00\u4e0b\u4f60\u7684\u89c6\u91ce\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_VAGINAL_RECEIVING, "\u8bf4\u767d\u4e86\u4f60\u5c31\u662f\u60f3\u88ab\u64cd\u903c\uff0c\u5bf9\u5427\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_VAGINAL_RECEIVING, "\u6027\u7231\u4e0d\u4ec5\u9650\u4e8e\u5c0f\u7a74\u3002\u62d3\u5c55\u4e00\u4e0b\u4f60\u7684\u89c6\u91ce\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_LEG_LOVER, "\u4e00\u53cc\u7f8e\u817f\u771f\u7684\u80fd\u8ba9\u4e00\u5207\u53d8\u5f97\u4e0d\u540c\uff0c\u5bf9\u5427\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_LEG_LOVER, "\u4e5f\u8bb8\u5e94\u8be5\u591a\u5173\u6ce8\u4e00\u4e0b\u8170\u4ee5\u4e0a\u7684\u8eab\u4f53\u2014\u2014\u6216\u8005\u81f3\u5c11\u662f\u81c0\u90e8\u5468\u56f4\u7684\u8eab\u4f53\uff1f");
        hashMap.put(TFModifier.TF_MOD_FETISH_STRUTTER, "\u4f60\u6709\u7740\u8ba9\u4eba\u6b32\u7f62\u4e0d\u80fd\u7684\u7f8e\u817f\u2014\u2014\u4f60\u771f\u8be5\u597d\u597d\u5229\u7528\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_STRUTTER, "\u4e5f\u8bb8\u5e94\u8be5\u591a\u5173\u6ce8\u4e00\u4e0b\u8170\u4ee5\u4e0a\u7684\u8eab\u4f53\u2014\u2014\u6216\u8005\u81f3\u5c11\u662f\u81c0\u90e8\u5468\u56f4\u7684\u8eab\u4f53\uff1f");
        hashMap.put(TFModifier.TF_MOD_FETISH_FOOT_GIVING, "\u4f60\u68a6\u5bd0\u4ee5\u6c42\u7740\u4f7f\u7528\u4f60\u7684\u53cc\u811a\uff01");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_FOOT_GIVING, "\u6211\u89c9\u5f97\u4f60\u5df2\u7ecf\u53d7\u591f\u7528\u811a\u8e29\u4eba\u4e86\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_FOOT_RECEIVING, "\u4e4b\u540e\u4f60\u4f1a\u559c\u6b22\u4e3a\u522b\u4eba\u7684\u811a\u670d\u52a1\u7684\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_FOOT_RECEIVING, "\u662f\u65f6\u5019\u505c\u6b62\u7ea0\u7ed3\u522b\u4eba\u7684\u811a\u4e86\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_ARMPIT_RECEIVING, "\u4f60\u65f6\u65f6\u523b\u523b\u60f3\u8ba9\u4f60\u7684\u814b\u7a9d\u88ab\u73a9\u5f04\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_ARMPIT_RECEIVING, "\u5fd8\u8bb0\u4f7f\u7528\u4f60\u7684\u814b\u7a9d\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_ARMPIT_GIVING, "\u814b\u7a9d\u6bd4\u5c41\u80a1\u3001\u5c0f\u7a74\u6216\u9e21\u5df4\u597d\u591a\u4e86\u3002\u81f3\u5c11\uff0c\u4f60\u4f1a\u8fd9\u4e48\u60f3\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_ARMPIT_GIVING, "\u4f60\u6ca1\u5fc5\u8981\u8fd9\u4e48\u7ea0\u7ed3\u4e8e\u814b\u7a9d\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_DOMINANT, "\u4f60\u4e0d\u89c9\u5f97\u4f60\u5e94\u8be5\u662f\u652f\u914d\u8005\u5417\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_DOMINANT, "\u4f60\u771f\u7684\u6ca1\u6709\u4f60\u60f3\u7684\u90a3\u4e48\u5413\u4eba\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_SUBMISSIVE, "\u5c48\u670d\u5427\uff0c\u627f\u8ba4\u4f60\u53ea\u60f3\u505a\u6211\u7684\u73a9\u7269\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_SUBMISSIVE, "\u6709\u65f6\u5019\u5f97\u5230\u4f60\u60f3\u8981\u7684\u4e5f\u5f88\u597d\uff0c\u5bf9\u5427\uff1f");
        hashMap.put(TFModifier.TF_MOD_FETISH_CUM_STUD, "\u6ca1\u6709\u4ec0\u4e48\u6bd4\u7528\u4f60\u7684\u5b50\u79cd\u6c41\u704c\u51fa\u4e00\u4e2a\u6ce1\u8299\u66f4\u597d\u4e86\uff0c\u5bf9\u5427\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_CUM_STUD, "\u6027\u7231\u5e94\u8be5\u4eab\u53d7\u8fc7\u7a0b\uff0c\u522b\u770b\u91cd\u76ee\u7684\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_CUM_ADDICT, "\u6211\u4e00\u773c\u5c31\u80fd\u770b\u51fa\u6765\u8fd9\u662f\u4e2a\u80ae\u810f\u7684\u7cbe\u6db2\u5783\u573e\u7bb1\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_CUM_ADDICT, "\u5982\u679c\u4f60\u613f\u610f\u7684\u8bdd\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4ec5\u662f\u522b\u4eba\u7684\u5b50\u79cd\u6c41\u5bb9\u5668\uff0c\u4f60\u77e5\u9053\u7684\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_LACTATION_SELF, "\u4f60\u4f1a\u559c\u6b22\u88ab\u69a8\u4e73\u7684\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_LACTATION_SELF, "\u4f60\u77e5\u9053\uff0c\u751f\u6d3b\u4e2d\u6709\u6bd4\u88ab\u69a8\u4e73\u66f4\u91cd\u8981\u7684\u4e8b\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_LACTATION_OTHERS, "\u4f60\u6e34\u671b\u4e73\u6c41\u7684\u5473\u9053\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_LACTATION_OTHERS, "\u603b\u60f3\u559d\u5976\u5976\u662f\u4e0d\u5bf9\u7684\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_DEFLOWERING, "\u62d4\u5f97\u5934\u7b79\u7684\u611f\u89c9\u5f88\u7279\u522b\uff0c\u5bf9\u5427\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_DEFLOWERING, "\u76f8\u4fe1\u6211\uff0c\u627e\u90a3\u4e9b\u7ecf\u9a8c\u4e30\u5bcc\u7684\u4f1a\u66f4\u6709\u8da3\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_PURE_VIRGIN, "\u4f60\u5e94\u8be5\u73cd\u60dc\u4f60\u5b88\u4f4f\u7684\u8d1e\u6d01\uff0c\u8d81\u5b83\u8fd8\u5728\u7684\u65f6\u5019\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_PURE_VIRGIN, "\u53bb\u4ed6\u5988\u7684\u8d1e\u64cd\u3002\u6ca1\u4e86\u6d3b\u5f97\u66f4\u900d\u9065\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_IMPREGNATION, "\u4f60\u8fd9\u79cd\u79cd\u9a6c\u5c31\u8be5\u72e0\u72e0\u5730\u7ed9\u90a3\u7fa4\u5a4a\u5b50\u914d\u79cd\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_IMPREGNATION, "\u7ba1\u597d\u4f60\u81ea\u5df1\u3002\u6ca1\u4eba\u60f3\u8981\u4f60\u7684\u5b69\u5b50\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_PREGNANCY, "\u88ab\u5e72\u56fa\u7136\u68d2\uff0c\u4f46\u88ab\u6388\u79cd\u8981\u66f4\u597d\uff0c\u662f\u4e0d\u662f\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_PREGNANCY, "\u6000\u4e0a\u5b69\u5b50\u5f88\u7d2f\u7684\uff0c\u4f60\u4e0d\u89c9\u5f97\u5417\uff1f");
        hashMap.put(TFModifier.TF_MOD_FETISH_SADIST, "\u770b\u7740\u5bf9\u65b9\u88ab\u4f60\u6298\u78e8\u5374\u53cd\u800c\u6c42\u4e4b\u4e0d\u5f97\u7684\u611f\u89c9\uff0c\u96be\u9053\u4e0d\u662f\u5f88\u7f8e\u5999\u5417\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_SADIST, "\u4e0d\u662f\u8c01\u90fd\u60f3\u5f53\u4f60\u7684\u6c99\u5305\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_MASOCHIST, "\u662f\u65f6\u5019\u62e5\u62b1\u82e6\u75db\u4e86\u3002\u4f60\u4f1a\u611f\u6069\u6211\u7684\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_MASOCHIST, "\u591a\u5173\u5fc3\u4e00\u4e0b\u81ea\u5df1\u7684\u8eab\u4f53\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_NON_CON_DOM, "\u4ed6\u4eec\u6073\u6c42\u4f60\u505c\u4e0b\u6765\u7684\u58f0\u97f3\u8ba9\u4f60\u8fd1\u4e4e\u75af\u72c2\uff0c\u662f\u4e0d\u662f\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_NON_CON_DOM, "\u5927\u591a\u6570\u60c5\u51b5\u4e0b\uff0c\u8bf4\u4e0d\u5c31\u662f\u62d2\u7edd\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_NON_CON_SUB, "\u6bcf\u5f53\u4f60\u8bf4\u201c\u4e0d\u8981\u201d\uff0c\u773c\u4e2d\u5374\u6ee1\u662f\u201c\u7ee7\u7eed\u7528\u529b\u64cd\u201d\uff0c\u6211\u770b\u5f97\u5230\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_NON_CON_SUB, "\u4e0d\u7ba1\u4f60\u4fe1\u4e0d\u4fe1\uff0c\u5176\u5b9e\u4e0d\u88ab\u5f3a\u8feb\u4e5f\u53ef\u4ee5\u5f88\u8212\u670d\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_DENIAL, "\u6bd4\u9ad8\u6f6e\u66f4\u7f8e\u5999\u7684\u5c31\u662f\uff0c\u544a\u8bc9\u5bf9\u65b9\u4e0d\u80fd\u9ad8\u6f6e\uff0c\u5bf9\u5417\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_DENIAL, "\u5982\u679c\u6709\u4eba\u60f3\u8ddf\u4f60\u641e\uff0c\u81f3\u5c11\u8fd8\u662f\u8ba9\u4ed6\u4eec\u9ad8\u6f6e\u4e00\u6b21\u6bd4\u8f83\u597d\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_DENIAL_SELF, "\u9ad8\u6f6e\u5230\u5e95\u6709\u610f\u601d\u5728\u54ea\u5462\uff1f\u4f60\u4e0d\u60f3\u597d\u597d\u54c1\u5473\u8fc7\u7a0b\u5417\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_DENIAL_SELF, "\u5982\u679c\u4f60\u4e0d\u53bb\u4e00\u6b21\uff0c\u505a\u8fd9\u4e9b\u7684\u610f\u4e49\u5728\u54ea\uff1f");
        hashMap.put(TFModifier.TF_MOD_FETISH_VOYEURIST, "\u6709\u65f6\u5019\u53ea\u662f\u770b\u7740\u4e5f\u5f88\u6709\u8da3\uff0c\u4e0d\u662f\u5417\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_VOYEURIST, "\u8bf7\u5c0a\u91cd\u4ed6\u4eba\u9690\u79c1\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_EXHIBITIONIST, "\u65e2\u7136\u660e\u767d\uff0c\u90a3\u5c31\u597d\u597d\u5c55\u73b0\u51fa\u6765\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_EXHIBITIONIST, "\u4e0d\u662f\u8c01\u90fd\u60f3\u770b\u900f\u4f60\u7684\u4e00\u5207\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_BONDAGE_APPLIER, "\u770b\u5230\u522b\u4eba\u88ab\u7ed1\u8d77\u6765\u7948\u6c42\u4f60\u7684\u539f\u8c05\uff0c\u5f88\u68d2\u4e0d\u662f\u5417\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_BONDAGE_APPLIER, "\u4e0d\u662f\u8c01\u90fd\u559c\u6b22\u88ab\u7ed1\u8d77\u6765\u7684\uff0c\u4f60\u660e\u767d\u5427\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_BONDAGE_VICTIM, "\u4f60\u80af\u5b9a\u4f1a\u559c\u6b22\u88ab\u675f\u7f1a\u8d77\u6765\uff0c\u7136\u540e\u628a\u94a5\u5319\u4e22\u6389\u5427\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_BONDAGE_VICTIM, "\u5982\u679c\u4f60\u80fd\u52a8\u80af\u5b9a\u66f4\u6709\u610f\u601d\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_BIMBO, "\u662f\u65f6\u5019\u62e5\u62b1\u4f60\u5fc3\u4e2d\u90a3\u4e2a\u65e0\u8111\u7684\u9a9a\u8d27\u4e86\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_BIMBO, "\u6216\u8bb8\u8fd8\u662f\u7ed9\u81ea\u5df1\u7559\u70b9\u81ea\u5c0a\uff1f");
        hashMap.put(TFModifier.TF_MOD_FETISH_CROSS_DRESSER, "\u4f60\u60f3\u7a7f\u4ec0\u4e48\u5c31\u7a7f\u4ec0\u4e48\uff0c\u5c3d\u60c5\u4eab\u53d7\u5427\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_CROSS_DRESSER, "\u7a0d\u5fae\u4fdd\u5b88\u4e00\u70b9\u6b7b\u4e0d\u4e86\u4eba\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_MASTURBATION, "\u8c01\u90fd\u4e0d\u53ef\u80fd\u6bd4\u4f60\u66f4\u4e86\u89e3\u81ea\u5df1\uff0c\u5bf9\u4e0d\u5bf9\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_MASTURBATION, "\u4e5f\u8bb8\u4f60\u5e94\u8be5\u8003\u8651\u4e00\u4e0b\uff0c\u5076\u5c14\u4e5f\u62ff\u522b\u4eba\u7684\u5783\u573e\u5f00\u5f00\u773c\u754c\uff1f");
        hashMap.put(TFModifier.TF_MOD_FETISH_INCEST, "\u8981\u77e5\u9053\uff0c\u5982\u679c\u6ca1\u6709\u4e00\u70b9\u4e50\u8da3\uff0c\u90a3\u600e\u4e48\u6210\u4e3a\u7981\u5fcc\u5462\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_INCEST, "\u4f60\u5e72\u5565\uff1f\u6076\u5fc3\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_TRANSFORMATION_GIVING, "\u5728\u6211\u770b\u6765\uff0c\u4f60\u5e94\u8be5\u6210\u4e3a\u53d8\u9769\u7684\u63a8\u52a8\u8005\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_TRANSFORMATION_GIVING, "\u8ba9\u4eba\u4eec\u4fdd\u6301\u539f\u6837\u5427\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_TRANSFORMATION_RECEIVING, "\u4f60\u5f88\u559c\u6b22\u53d8\u6210\u522b\u7684\u6837\u5b50\uff0c\u5bf9\u4e0d\u5bf9\uff1f");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_TRANSFORMATION_RECEIVING, "\u6211\u89c9\u5f97\u4f60\u73b0\u5728\u7684\u6837\u5b50\u5c31\u5f88\u4e0d\u9519\u4e86\u3002");
        hashMap.put(TFModifier.TF_MOD_FETISH_KINK_GIVING, "\u4f60\u771f\u662f\u89c1\u591a\u8bc6\u5e7f\uff0c\u5e94\u8be5\u591a\u591a\u5206\u4eab\u624d\u662f\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_KINK_GIVING, "\u522b\u4eba\u559c\u6b22\u4ec0\u4e48\u4f60\u5c31\u8ba9\u4ed6\u4eec\u559c\u6b22\u5c31\u597d\uff0c\u53ef\u4ee5\u5417\uff1f");
        hashMap.put(TFModifier.TF_MOD_FETISH_KINK_RECEIVING, "\u5728\u6211\u770b\u6765\uff0c\u4f60\u786e\u5b9e\u5e94\u8be5\u591a\u63a5\u53d7\u4e9b\u65b0\u9c9c\u4e8b\u7269\u3002");
        fetishRemoveFlavorText.put(TFModifier.TF_MOD_FETISH_KINK_RECEIVING, "\u6211\u89c9\u5f97\u4f60\u5df2\u7ecf\u8db3\u591f\u6709\u6fc0\u60c5\u4e86\u3002");
        if (selectedEffect.getPotency() == TFPotency.MINOR_BOOST || selectedEffect.getPotency() == TFPotency.BOOST) {
            selectedEffectString = defaultFetishAddFlavorText;
            if (hashMap.get((Object)selectedEffect.getSecondaryModifier()) != null) {
                selectedEffectString = (String)hashMap.get((Object)selectedEffect.getSecondaryModifier());
            }
        } else {
            selectedEffectString = defaultFetishRemoveFlavorText;
            if (fetishRemoveFlavorText.get((Object)selectedEffect.getSecondaryModifier()) != null) {
                selectedEffectString = (String)fetishRemoveFlavorText.get((Object)selectedEffect.getSecondaryModifier());
            }
        }
        return new FetishPotion(itemType, Util.newArrayListOfValues(new PossibleItemEffect(selectedEffect, selectedEffectString)));
    }

    public String getSpecialPlayerVirginityLoss(GameCharacter penetratingCharacter, SexAreaPenetration penetrating, GameCharacter receivingCharacter, SexAreaOrifice penetrated) {
        return null;
    }

    public String getSpecialPlayerPureVirginityLoss(GameCharacter penetratingCharacter, SexAreaPenetration penetrating) {
        return null;
    }

    public void endSex() {
    }

    public boolean isWantingToEquipCondom(GameCharacter partner) {
        boolean wantingToEquip = this.getFetishDesire(Fetish.FETISH_CUM_STUD).isNegative() || partner.hasVagina() && !partner.isVisiblyPregnant() && this.getFetishDesire(Fetish.FETISH_IMPREGNATION).isNegative();
        return wantingToEquip;
    }

    public boolean isWantingToEquipCondomOnPartner(GameCharacter partner) {
        if (!partner.hasPenisIgnoreDildo()) {
            return false;
        }
        return this.getFetishDesire(Fetish.FETISH_CUM_ADDICT).isNegative() || this.hasVagina() && !this.isVisiblyPregnant() && this.getFetishDesire(Fetish.FETISH_PREGNANCY).isNegative();
    }

    public Util.Value<AbstractClothing, String> getSexClothingToSelfEquip(GameCharacter partner, boolean inQuickSex) {
        if (Main.game.isInSex() && (inQuickSex || !Main.sex.getInitialSexManager().isPartnerWantingToStopSex(this)) && this.hasPenisIgnoreDildo() && this.getClothingInSlot(InventorySlot.PENIS) == null && this.isWantingToEquipCondom(partner)) {
            AbstractClothing condom = null;
            for (AbstractClothing clothing : this.getAllClothingInInventory().keySet()) {
                if (!clothing.isCondom()) continue;
                condom = clothing;
                break;
            }
            if (condom != null && this.isAbleToEquip(condom, inQuickSex, this)) {
                return new Util.Value<AbstractClothing, String>(condom, UtilText.parse((GameCharacter)this, "[npc.Name]\u4ece\u7269\u54c1\u680f\u6c47\u603b\u62ff\u51fa\u4e00\u4e2a" + condom.getName() + "\u2026\u2026", new ParserTag[0]));
            }
        }
        return null;
    }

    public Util.Value<AbstractClothing, String> getSexClothingToEquip(GameCharacter partner, boolean inQuickSex) {
        if (Main.game.isInSex() && (inQuickSex || !Main.sex.getInitialSexManager().isPartnerWantingToStopSex(this))) {
            if (Main.sex.getSexPositionSlot(partner) == SexSlotGeneric.MISC_WATCHING) {
                return null;
            }
            if (partner.hasPenisIgnoreDildo() && partner.getClothingInSlot(InventorySlot.PENIS) == null && this.isWantingToEquipCondomOnPartner(partner)) {
                AbstractClothing condom = null;
                for (AbstractClothing abstractClothing : this.getAllClothingInInventory().keySet()) {
                    if (!abstractClothing.isCondom()) continue;
                    condom = abstractClothing;
                    break;
                }
                if (condom != null && partner.isAbleToEquip(condom, inQuickSex || !Main.sex.isInForeplay(this), this)) {
                    return new Util.Value<AbstractClothing, String>(condom, UtilText.parse((GameCharacter)this, "[npc.Name]\u4ece\u7269\u54c1\u680f\u6c47\u603b\u62ff\u51fa\u4e00\u4e2a" + condom.getName() + "\u2026\u2026", new ParserTag[0]));
                }
            }
            if (Main.sex.isDom(this) && !Main.sex.isDom(partner)) {
                HashMap<AbstractClothing, Integer> availableClothingInInventory = new HashMap<AbstractClothing, Integer>(this.getAllClothingInInventory());
                for (Map.Entry entry : Main.sex.getClothingPreSexMap().get(this).entrySet()) {
                    for (AbstractClothing clothing : ((Map)entry.getValue()).keySet()) {
                        for (AbstractClothing c : new HashSet(availableClothingInInventory.keySet())) {
                            if (!c.equalsWithoutEquippedSlot(clothing) || (Integer)availableClothingInInventory.get(c) != 1) continue;
                            availableClothingInInventory.remove(c);
                        }
                    }
                }
                for (AbstractClothing abstractClothing : availableClothingInInventory.keySet()) {
                    boolean wantsToEquip = false;
                    if (abstractClothing.getClothingType().getDefaultItemTags().contains((Object)ItemTag.ENABLE_SEX_EQUIP)) {
                        if (abstractClothing.getBlockedPartsMap(partner, abstractClothing.getClothingType().getEquipSlots().get(0)).stream().anyMatch(bp -> bp.blockedBodyParts.contains((Object)CoverableArea.PENIS)) && partner.hasPenisIgnoreDildo()) {
                            if (this.getMainSexPreference(partner) != null && this.getMainSexPreference(partner).getTargetedSexArea() == SexAreaPenetration.PENIS) continue;
                            wantsToEquip = true;
                        } else if (abstractClothing.getBlockedPartsMap(partner, abstractClothing.getClothingType().getEquipSlots().get(0)).stream().anyMatch(bp -> bp.blockedBodyParts.contains((Object)CoverableArea.VAGINA)) && partner.hasVagina()) {
                            if (this.getMainSexPreference(partner) != null && this.getMainSexPreference(partner).getTargetedSexArea() == SexAreaOrifice.VAGINA) continue;
                            wantsToEquip = true;
                        } else if (abstractClothing.getBlockedPartsMap(partner, abstractClothing.getClothingType().getEquipSlots().get(0)).stream().anyMatch(bp -> bp.blockedBodyParts.contains((Object)CoverableArea.ANUS)) && Main.game.isAnalContentEnabled()) {
                            if (this.getMainSexPreference(partner) != null && this.getMainSexPreference(partner).getTargetedSexArea() == SexAreaOrifice.ANUS) continue;
                            wantsToEquip = true;
                        } else if (abstractClothing.getBlockedPartsMap(partner, abstractClothing.getClothingType().getEquipSlots().get(0)).stream().anyMatch(bp -> bp.blockedBodyParts.contains((Object)CoverableArea.NIPPLES))) {
                            if (this.getMainSexPreference(partner) != null && this.getMainSexPreference(partner).getTargetedSexArea() == SexAreaOrifice.NIPPLE) continue;
                            wantsToEquip = true;
                        } else if (abstractClothing.getBlockedPartsMap(partner, abstractClothing.getClothingType().getEquipSlots().get(0)).stream().anyMatch(bp -> bp.blockedBodyParts.contains((Object)CoverableArea.MOUTH))) {
                            if (this.getMainSexPreference(partner) != null && this.getMainSexPreference(partner).getTargetedSexArea() == SexAreaOrifice.MOUTH) continue;
                            wantsToEquip = true;
                        }
                        if (abstractClothing.getClothingType().getClothingSet() == SetBonus.getSetBonusFromId("innoxia_bdsm") || abstractClothing.getClothingType().getClothingSet() == SetBonus.getSetBonusFromId("sage_ltxset")) {
                            wantsToEquip = this.getFetishDesire(Fetish.FETISH_BONDAGE_APPLIER).isPositive();
                        }
                        if (abstractClothing.getItemTags().contains((Object)ItemTag.CHASTITY)) {
                            wantsToEquip = this.getFetishDesire(Fetish.FETISH_DENIAL).isPositive();
                        }
                    }
                    InventorySlot defaultSlot = abstractClothing.getClothingType().getEquipSlots().get(0);
                    if (!wantsToEquip || !Main.sex.isClothingEquipAvailable(partner, defaultSlot, abstractClothing) || !abstractClothing.isAbleToBeEquippedDuringSex(defaultSlot).getKey().booleanValue() || partner.getClothingInSlot(defaultSlot) != null || !partner.isAbleToEquip(abstractClothing, inQuickSex, this)) continue;
                    return new Util.Value<AbstractClothing, String>(abstractClothing, UtilText.parse((GameCharacter)this, "[npc.Name]\u4ece\u7269\u54c1\u680f\u4e2d\u62ff\u51fa" + abstractClothing.getName(true, true) + "\u2026\u2026", new ParserTag[0]));
                }
            }
        }
        return null;
    }

    public Util.Value<AbstractItem, String> getSexItemToUse(GameCharacter partner) {
        if (Main.game.isInSex() && !Main.sex.isCharacterInanimateFromImmobilisation(this)) {
            ArrayList<GameCharacter> charactersPenetratingThisNpc = new ArrayList<GameCharacter>(Main.sex.getOngoingCharactersUsingAreas(this, SexAreaOrifice.VAGINA, SexAreaPenetration.PENIS));
            ArrayList<GameCharacter> charactersThisNpcIsPenetrating = new ArrayList<GameCharacter>(Main.sex.getOngoingCharactersUsingAreas(this, SexAreaPenetration.PENIS, SexAreaOrifice.VAGINA));
            if (this.equals(partner)) {
                if (!charactersPenetratingThisNpc.isEmpty() && charactersPenetratingThisNpc.stream().anyMatch(c -> c.hasPenisIgnoreDildo()) && this.isAbleToAccessCoverableArea(CoverableArea.MOUTH, false)) {
                    if (!(!this.getFetishDesire(Fetish.FETISH_PREGNANCY).isNegative() && (this.getHistory() != Occupation.NPC_PROSTITUTE || this.isSlave()) || this.isPregnant() || this.hasIncubationLitter(SexAreaOrifice.VAGINA) || this.hasStatusEffect(StatusEffect.PROMISCUITY_PILL) || !this.hasItemType(ItemType.getItemTypeFromId("innoxia_pills_sterility")) || Main.sex.getItemUseDenials(this, partner).contains(ItemType.getItemTypeFromId("innoxia_pills_sterility")))) {
                        return new Util.Value<AbstractItem, String>(Main.game.getItemGen().generateItem("innoxia_pills_sterility"), UtilText.parse((GameCharacter)this, (GameCharacter)charactersPenetratingThisNpc.get(0), "[npc.name]\u4ece\u7269\u54c1\u680f\u91cc\u62ff\u51fa\u4e00\u5c0f\u7247\u84dd\u8272\u7684\u201c[#ITEM_innoxia_pills_sterility.getName(false)]\u201d\uff0c\u89e3\u5f00\u5305\u88c5\u540e\u4fbf\u653e\u8fdb\u5634\u91cc\uff0c\u54bd\u4e86\u4e0b\u53bb\u3002" + (this.isMute() ? "\u786e\u8ba4\u81ea\u5df1\u751f\u80b2\u80fd\u529b\u5927\u5e45\u964d\u4f4e\uff0c\u4e0d\u592a\u53ef\u80fd\u518d\u6000\u5b55\u540e\uff0c[npc.Name]\u957f\u8212\u4e00\u53e3\u6c14\u2026\u2026" : "\u786e\u8ba4\u81ea\u5df1\u751f\u80b2\u80fd\u529b\u5927\u5e45\u964d\u4f4e\uff0c\u4e0d\u592a\u53ef\u80fd\u518d\u6000\u5b55\u540e\uff0c[npc.name][npc.moansVerb]\u8d77\u6765\uff0c[npc.speech(\u6211\u4e00\u70b9\u4e5f\u4e0d\u60f3\u6000\u5b55\u2026\u2026)]"), new ParserTag[0]));
                    }
                    if (this.getFetishDesire(Fetish.FETISH_PREGNANCY).isPositive() && (this.getHistory() != Occupation.NPC_PROSTITUTE || this.isSlave()) && this.hasVagina() && partner.hasPenisIgnoreDildo() && !this.isPregnant() && !this.hasIncubationLitter(SexAreaOrifice.VAGINA) && (Main.sex.getSexPace(this) != SexPace.SUB_RESISTING || this.hasFetish(Fetish.FETISH_NON_CON_SUB)) && !this.hasStatusEffect(StatusEffect.VIXENS_VIRILITY) && this.hasItemType(ItemType.getItemTypeFromId("innoxia_pills_fertility")) && !Main.sex.getItemUseDenials(this, partner).contains(ItemType.getItemTypeFromId("innoxia_pills_fertility"))) {
                        return new Util.Value<AbstractItem, String>(Main.game.getItemGen().generateItem("innoxia_pills_fertility"), UtilText.parse((GameCharacter)this, (GameCharacter)charactersPenetratingThisNpc.get(0), "[npc.name]\u4ece\u7269\u54c1\u680f\u91cc\u62ff\u51fa\u4e00\u5c0f\u7247\u7c89\u8272\u7684\u201c[#ITEM_innoxia_pills_fertility.getName(false)]\u201d\uff0c\u89e3\u5f00\u5305\u88c5\u540e\u4fbf\u653e\u8fdb\u5634\u91cc\uff0c\u54bd\u4e86\u4e0b\u53bb\u3002" + (this.isMute() ? "\u5f53[npc.sheIs]\u60f3\u8c61[npc2.name]\u5728[npc.herHim]\u4f53\u5185\u5c04\u7cbe\u5e76\u8ba9[npc.herHim]\u6000\u5b55\u65f6\uff0c[npc.name]\u77e5\u9053\u81ea\u5df1\u7684\u751f\u80b2\u529b\u5f3a\u5316\u4e86\uff0c\u53d1\u51fa\u4e86[npc.a_moan+]\u2026\u2026" : "[npc.name]\u77e5\u9053\u81ea\u5df1\u751f\u80b2\u529b\u5f3a\u5316\u4e86\uff0c\u53d1\u51fa[npc.a_moan+]\u5e76\u6073\u6c42\u9053\uff0c[npc.speech(\u5728\u6211\u4f53\u5185\u4e2d\u51fa\uff01\u6211\u8981\u4f60\u628a\u6211\u5f04\u6000\u5b55\uff01)]"), new ParserTag[0]));
                    }
                }
                if (!charactersThisNpcIsPenetrating.isEmpty() && this.hasPenisIgnoreDildo() && this.isAbleToAccessCoverableArea(CoverableArea.MOUTH, false)) {
                    if (this.getFetishDesire(Fetish.FETISH_IMPREGNATION).isNegative() && !partner.isPregnant() && !partner.hasIncubationLitter(SexAreaOrifice.VAGINA) && !this.hasStatusEffect(StatusEffect.PROMISCUITY_PILL) && this.hasItemType(ItemType.getItemTypeFromId("innoxia_pills_sterility")) && !Main.sex.getItemUseDenials(this, partner).contains(ItemType.getItemTypeFromId("innoxia_pills_sterility"))) {
                        return new Util.Value<AbstractItem, String>(Main.game.getItemGen().generateItem("innoxia_pills_sterility"), UtilText.parse((GameCharacter)this, (GameCharacter)charactersThisNpcIsPenetrating.get(0), "[npc.name]\u4ece\u7269\u54c1\u680f\u91cc\u62ff\u51fa\u4e00\u5c0f\u7247\u84dd\u8272\u7684\u201c[#ITEM_innoxia_pills_sterility.getName(false)]\u201d\uff0c\u89e3\u5f00\u5305\u88c5\u540e\u4fbf\u653e\u8fdb\u5634\u91cc\uff0c\u54bd\u4e86\u4e0b\u53bb\u3002" + (this.isMute() ? "[npc.sheIs]\u77e5\u9053[npc.sheIs]\u73b0\u5728\u9633\u6c14\u5927\u51cf\uff0c\u51e0\u4e4e\u4e0d\u53ef\u80fd\u628a[npc2.name]\u641e\u5927\u809a\u5b50\uff0c\u4e8e\u662f\u53d1\u51fa\u4e86\u4e00\u58f0\u5982\u91ca\u91cd\u8d1f\u7684[npc.moan]\u2026\u2026" : "\u4e86\u89e3\u5230[npc.sheIs]\u73b0\u5728\u7684\u9633\u521a\u4e4b\u6c14\u5df2\u7ecf\u5927\u4e0d\u5982\u524d\uff0c\u6781\u4e0d\u53ef\u80fd\u628a[npc2.name]\u641e\u5927\u809a\u5b50\uff0c[npc.name][npc.moansVerb]\u9053\uff0c[npc.speech(\u8fd9\u6837\u5c31\u597d\u591a\u4e86\uff01\u6211\u73b0\u5728\u4e0d\u4f1a\u8ba9\u4f60\u6000\u5b55\u4e86\uff01)]"), new ParserTag[0]));
                    }
                    if (this.getFetishDesire(Fetish.FETISH_IMPREGNATION).isPositive() && partner.hasVagina() && this.hasPenisIgnoreDildo() && !partner.isPregnant() && !partner.hasIncubationLitter(SexAreaOrifice.VAGINA) && (Main.sex.getSexPace(this) != SexPace.SUB_RESISTING || this.hasFetish(Fetish.FETISH_NON_CON_SUB)) && !this.hasStatusEffect(StatusEffect.VIXENS_VIRILITY) && this.hasItemType(ItemType.getItemTypeFromId("innoxia_pills_fertility")) && !Main.sex.getItemUseDenials(this, partner).contains(ItemType.getItemTypeFromId("innoxia_pills_fertility"))) {
                        return new Util.Value<AbstractItem, String>(Main.game.getItemGen().generateItem("innoxia_pills_fertility"), UtilText.parse((GameCharacter)this, (GameCharacter)charactersThisNpcIsPenetrating.get(0), "[npc.name]\u4ece\u7269\u54c1\u680f\u91cc\u62ff\u51fa\u4e00\u5c0f\u7247\u7c89\u8272\u7684\u201c[#ITEM_innoxia_pills_fertility.getName(false)]\u201d\uff0c\u89e3\u5f00\u5305\u88c5\u540e\u4fbf\u653e\u8fdb\u5634\u91cc\uff0c\u54bd\u4e86\u4e0b\u53bb\u3002" + (this.isMute() ? "[npc.Name]\u77e5\u9053\u81ea\u5df1\u7684\u751f\u6b96\u529b\u66f4\u5f3a\u4e86\uff0c\u8111\u5185\u4e0d\u7981\u51fa\u73b0\u4e86\u704c\u6ee1[npc2.herHim]\u4f53\u5185\uff0c\u8ba9[npc2.herHim]\u6000\u4e0a\u5b69\u5b50\u7684\u666f\u8c61\uff0c\u4e00\u58f0[npc.a_moan+]\u4ece\u53e3\u4e2d\u6f0f\u51fa\u2026\u2026" : "[npc.Name]\u77e5\u9053\u81ea\u5df1\u751f\u6b96\u529b\u66f4\u5f3a\u4e86\uff0c\u4e8e\u662f\u4fbf\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\uff0c\u8c03\u620f\u9053\uff0c[npc.speech(\u6211\u4e00\u5b9a\u4f1a\u7ed9\u4f60\u704c\u6210\u6ce1\u8299\uff0c\u8ba9\u4f60\u6000\u4e0a\u7684\uff01)]"), new ParserTag[0]));
                    }
                }
            } else {
                if (charactersPenetratingThisNpc.contains(partner) && charactersPenetratingThisNpc.stream().anyMatch(c -> c.hasPenisIgnoreDildo()) && partner.isAbleToAccessCoverableArea(CoverableArea.MOUTH, false)) {
                    if (!(Main.sex.getItemUseDenials(this, partner).contains(ItemType.getItemTypeFromId("innoxia_pills_sterility")) || !this.getFetishDesire(Fetish.FETISH_PREGNANCY).isNegative() && (this.getHistory() != Occupation.NPC_PROSTITUTE || this.isSlave()) || partner.isPregnant() || partner.hasIncubationLitter(SexAreaOrifice.VAGINA) || Main.sex.getSexPace(this) == SexPace.SUB_RESISTING && !this.hasFetish(Fetish.FETISH_NON_CON_SUB) || partner.hasStatusEffect(StatusEffect.PROMISCUITY_PILL) || !this.hasItemType(ItemType.getItemTypeFromId("innoxia_pills_sterility")) || Main.sex.getItemUseDenials(this, partner).contains(ItemType.getItemTypeFromId("innoxia_pills_sterility")))) {
                        if (partner.isPlayer()) {
                            if (Main.sex.isForcingItemUse(this, partner)) {
                                return new Util.Value<AbstractItem, CallSite>(Main.game.getItemGen().generateItem("innoxia_pills_sterility"), (CallSite)((Object)("[npc.name]\u4ece\u7269\u54c1\u680f\u91cc\u62ff\u51fa\u4e00\u5c0f\u7247\u84dd\u8272\u7684\u201c[#ITEM_innoxia_pills_sterility.getName(false)]\u201d\uff0c\u6253\u5f00\u5305\u88c5\u540e\u4fbf\u5582\u5230\u4e86\u4f60\u5634\u91cc\u3002\u968f\u540e\u634f\u4f4f\u4e86\u4f60\u7684[pc.lips]\uff0c\u9632\u6b62\u4f60\u5077\u5077\u5410\u51fa\u6765\uff0c" + (this.isMute() ? "[npc.name]\u53d1\u51fa\u4e00\u58f0\u6bcb\u5eb8\u7f6e\u7591\u7684\u4f4e\u543c\uff0c\u4e00\u76f4\u7b49\u5230\u4f60\u54bd\u4e86\u4e0b\u53bb\u2026\u2026" : "[npc.name]\u5f3a\u8feb\u4f60\u54bd\u4e86\u4e0b\u53bb\uff0c\u968f\u540e\u4f4e\u543c\u9053\uff0c[npc.speech(\u6211\u53ef\u4e0d\u60f3\u8ba9\u4f60\u7ed9\u6211\u5f04\u6000\u4e0a\u4e86\uff01)]"))));
                            }
                            return new Util.Value<AbstractItem, CallSite>(Main.game.getItemGen().generateItem("innoxia_pills_sterility"), (CallSite)((Object)("[npc.Name]\u4ece\u7269\u54c1\u680f\u91cc\u62ff\u51fa\u4e00\u5c0f\u7247\u84dd\u8272\u7684\u201c[#ITEM_innoxia_pills_sterility.getName(false)]\u201d\uff0c\u9012\u7ed9\u4e86\u4f60" + (this.isMute() ? "\uff0c\u5feb\u8981\u54ed\u51fa\u6765\u4f3c\u7684\u592e\u6c42\u7740\uff0c\u60f3\u8ba9\u4f60\u5403\u4e0b\u53bb\u2026\u2026" : "\uff0c\u8bf7\u6c42\u9053\uff0c[npc.speech(\u6c42\u4f60\u5403\u4e0b\u8fd9\u4e2a\u5427\uff1b\u6211\u4e0d\u60f3\u6000\u4e0a\u4f60\u7684\u5b69\u5b50\uff01)]"))));
                        }
                        return new Util.Value<AbstractItem, String>(Main.game.getItemGen().generateItem("innoxia_pills_sterility"), "");
                    }
                    if (!(!this.getFetishDesire(Fetish.FETISH_PREGNANCY).isPositive() || this.getHistory() == Occupation.NPC_PROSTITUTE && !this.isSlave() || partner.isPregnant() || partner.hasIncubationLitter(SexAreaOrifice.VAGINA) || Main.sex.getSexPace(this) == SexPace.SUB_RESISTING && !this.hasFetish(Fetish.FETISH_NON_CON_SUB) || partner.hasStatusEffect(StatusEffect.VIXENS_VIRILITY) || !this.hasItemType(ItemType.getItemTypeFromId("innoxia_pills_fertility")) || Main.sex.getItemUseDenials(this, partner).contains(ItemType.getItemTypeFromId("innoxia_pills_fertility")))) {
                        if (partner.isPlayer()) {
                            if (Main.sex.isForcingItemUse(this, partner)) {
                                return new Util.Value<AbstractItem, CallSite>(Main.game.getItemGen().generateItem("innoxia_pills_fertility"), (CallSite)((Object)("[npc.name]\u4ece\u7269\u54c1\u680f\u91cc\u62ff\u51fa\u4e00\u5c0f\u7247\u7c89\u8272\u7684\u201c[#ITEM_innoxia_pills_fertility.getName(false)]\u201d\uff0c\u6253\u5f00\u5305\u88c5\u540e\u4fbf\u5582\u5230\u4e86\u4f60\u5634\u91cc\u3002\u968f\u540e\u634f\u4f4f\u4e86\u4f60\u7684[pc.lips]\uff0c\u9632\u6b62\u4f60\u5077\u5077\u5410\u51fa\u6765\uff0c" + (this.isMute() ? "[npc.name]\u53d1\u51fa\u4e00\u58f0\u6bcb\u5eb8\u7f6e\u7591\u7684\u4f4e\u543c\uff0c\u4e00\u76f4\u7b49\u5230\u4f60\u54bd\u4e86\u4e0b\u53bb\u2026\u2026" : "[npc.name]\u5f3a\u8feb\u4f60\u54bd\u4e86\u4e0b\u53bb\uff0c\u968f\u540e\u4f4e\u543c\u9053\uff0c[npc.speech(\u6211\u6b63\u60f3\u8ba9\u4f60\u641e\u5927\u6211\u7684\u809a\u5b50\u5462\uff01)]"))));
                            }
                            return new Util.Value<AbstractItem, CallSite>(Main.game.getItemGen().generateItem("innoxia_pills_fertility"), (CallSite)((Object)("[npc.Name]\u4ece\u7269\u54c1\u680f\u91cc\u62ff\u51fa\u4e00\u5c0f\u7247\u7c89\u8272\u7684\u201c[#ITEM_innoxia_pills_fertility.getName(false)]\u201d\uff0c\u9012\u7ed9\u4e86\u4f60" + (this.isMute() ? "\uff0c\u5feb\u8981\u54ed\u51fa\u6765\u4f3c\u7684\u592e\u6c42\u7740\uff0c\u60f3\u8ba9\u4f60\u5403\u4e0b\u53bb\u2026\u2026" : "\uff0c\u8bf7\u6c42\u9053\uff0c[npc.speech(\u6c42\u4f60\u5403\u4e0b\u8fd9\u4e2a\u5427\uff1b\u6211\u60f3\u6000\u4e0a\u4f60\u7684\u5b69\u5b50\uff01)]"))));
                        }
                        return new Util.Value<AbstractItem, String>(Main.game.getItemGen().generateItem("innoxia_pills_fertility"), "");
                    }
                }
                if (charactersThisNpcIsPenetrating.contains(partner) && this.hasPenisIgnoreDildo() && partner.isAbleToAccessCoverableArea(CoverableArea.MOUTH, false)) {
                    if (!(!this.getFetishDesire(Fetish.FETISH_IMPREGNATION).isNegative() || partner.isPregnant() || partner.hasIncubationLitter(SexAreaOrifice.VAGINA) || Main.sex.getSexPace(this) == SexPace.SUB_RESISTING && !this.hasFetish(Fetish.FETISH_NON_CON_SUB) || partner.hasStatusEffect(StatusEffect.PROMISCUITY_PILL) || !this.hasItemType(ItemType.getItemTypeFromId("innoxia_pills_sterility")) || Main.sex.getItemUseDenials(this, partner).contains(ItemType.getItemTypeFromId("innoxia_pills_sterility")))) {
                        if (partner.isPlayer()) {
                            if (Main.sex.isForcingItemUse(this, partner)) {
                                return new Util.Value<AbstractItem, CallSite>(Main.game.getItemGen().generateItem("innoxia_pills_sterility"), (CallSite)((Object)("[npc.name]\u4ece\u7269\u54c1\u680f\u91cc\u62ff\u51fa\u4e00\u5c0f\u7247\u84dd\u8272\u7684\u201c[#ITEM_innoxia_pills_sterility.getName(false)]\u201d\uff0c\u6253\u5f00\u5305\u88c5\u540e\u4fbf\u5582\u5230\u4e86\u4f60\u5634\u91cc\u3002\u968f\u540e\u634f\u4f4f\u4e86\u4f60\u7684[pc.lips]\uff0c\u9632\u6b62\u4f60\u5077\u5077\u5410\u51fa\u6765\uff0c" + (this.isMute() ? "[npc.name]\u53d1\u51fa\u4e00\u58f0\u6bcb\u5eb8\u7f6e\u7591\u7684\u4f4e\u543c\uff0c\u4e00\u76f4\u7b49\u5230\u4f60\u54bd\u4e86\u4e0b\u53bb\u2026\u2026" : "[npc.name]\u5f3a\u8feb\u4f60\u54bd\u4e86\u4e0b\u53bb\uff0c\u968f\u540e\u4f4e\u543c\u9053\uff0c[npc.speech(\u6211\u53ef\u4e0d\u60f3\u641e\u5927\u4f60\u7684\u809a\u5b50\uff01)]"))));
                            }
                            return new Util.Value<AbstractItem, CallSite>(Main.game.getItemGen().generateItem("innoxia_pills_sterility"), (CallSite)((Object)("[npc.Name]\u4ece\u7269\u54c1\u680f\u91cc\u62ff\u51fa\u4e00\u5c0f\u7247\u84dd\u8272\u7684\u201c[#ITEM_innoxia_pills_sterility.getName(false)]\u201d\uff0c\u9012\u7ed9\u4e86\u4f60" + (this.isMute() ? "\uff0c\u5feb\u8981\u54ed\u51fa\u6765\u4f3c\u7684\u592e\u6c42\u7740\uff0c\u60f3\u8ba9\u4f60\u5403\u4e0b\u53bb\u2026\u2026" : "\uff0c\u8bf7\u6c42\u9053\uff0c[npc.speech(\u6c42\u4f60\u5403\u4e0b\u8fd9\u4e2a\u5427\uff1b\u6211\u4e0d\u60f3\u8ba9\u4f60\u6000\u4e0a\uff01)]"))));
                        }
                        return new Util.Value<AbstractItem, String>(Main.game.getItemGen().generateItem("innoxia_pills_sterility"), "");
                    }
                    if (!(!this.getFetishDesire(Fetish.FETISH_IMPREGNATION).isPositive() || partner.isPregnant() || partner.hasIncubationLitter(SexAreaOrifice.VAGINA) || Main.sex.getSexPace(this) == SexPace.SUB_RESISTING && !this.hasFetish(Fetish.FETISH_NON_CON_SUB) || partner.hasStatusEffect(StatusEffect.VIXENS_VIRILITY) || !this.hasItemType(ItemType.getItemTypeFromId("innoxia_pills_fertility")) || Main.sex.getItemUseDenials(this, partner).contains(ItemType.getItemTypeFromId("innoxia_pills_fertility")))) {
                        if (partner.isPlayer()) {
                            if (Main.sex.isForcingItemUse(this, partner)) {
                                return new Util.Value<AbstractItem, CallSite>(Main.game.getItemGen().generateItem("innoxia_pills_fertility"), (CallSite)((Object)("[npc.name]\u4ece\u7269\u54c1\u680f\u91cc\u62ff\u51fa\u4e00\u5c0f\u7247\u7c89\u8272\u7684\u201c[#ITEM_innoxia_pills_fertility.getName(false)]\u201d\uff0c\u6253\u5f00\u5305\u88c5\u540e\u4fbf\u5582\u5230\u4e86\u4f60\u5634\u91cc\u3002\u968f\u540e\u634f\u4f4f\u4e86\u4f60\u7684[pc.lips]\uff0c\u9632\u6b62\u4f60\u5077\u5077\u5410\u51fa\u6765\uff0c" + (this.isMute() ? "[npc.name]\u53d1\u51fa\u4e00\u58f0\u6bcb\u5eb8\u7f6e\u7591\u7684\u4f4e\u543c\uff0c\u4e00\u76f4\u7b49\u5230\u4f60\u54bd\u4e86\u4e0b\u53bb\u2026\u2026" : "[npc.name]\u5f3a\u8feb\u4f60\u54bd\u4e86\u4e0b\u53bb\uff0c\u968f\u540e\u4f4e\u543c\u9053\uff0c[npc.speech(\u6211\u6b63\u60f3\u8ba9\u4f60\u6000\u4e0a\u6211\u7684\u5b69\u5b50\u5462\uff01)]"))));
                            }
                            return new Util.Value<AbstractItem, CallSite>(Main.game.getItemGen().generateItem("innoxia_pills_fertility"), (CallSite)((Object)("[npc.Name]\u4ece\u7269\u54c1\u680f\u91cc\u62ff\u51fa\u4e00\u5c0f\u7247\u7c89\u8272\u7684\u201c[#ITEM_innoxia_pills_fertility.getName(false)]\u201d\uff0c\u9012\u7ed9\u4e86\u4f60" + (this.isMute() ? "\uff0c\u5feb\u8981\u54ed\u51fa\u6765\u4f3c\u7684\u592e\u6c42\u7740\uff0c\u60f3\u8ba9\u4f60\u5403\u4e0b\u53bb\u2026\u2026" : "\uff0c\u8bf7\u6c42\u9053\uff0c[npc.speech(\u6c42\u4f60\u5403\u4e0b\u8fd9\u4e2a\u5427\uff1b\u6211\u60f3\u8ba9\u4f60\u6000\u4e0a\uff01)]"))));
                        }
                        return new Util.Value<AbstractItem, String>(Main.game.getItemGen().generateItem("innoxia_pills_fertility"), "");
                    }
                }
            }
        }
        return null;
    }

    public boolean getSexBehaviourDeniesRequests(GameCharacter requestingCharacter) {
        return this.getSexBehaviourDeniesRequests(requestingCharacter, null);
    }

    public boolean getSexBehaviourDeniesRequests(GameCharacter requestingCharacter, SexType sexTypeRequest) {
        if (requestingCharacter.hasTraitActivated(Perk.CONVINCING_REQUESTS)) {
            return false;
        }
        if (Main.game.isInSex() && Main.sex.getSexControl(requestingCharacter).getValue() <= SexControl.ONGOING_PLUS_LIMITED_PENETRATIONS.getValue() && Main.sex.getSexPace(this) == SexPace.DOM_ROUGH) {
            return true;
        }
        int weight = 0;
        if (sexTypeRequest != null) {
            weight = this.calculateSexTypeWeighting(sexTypeRequest, requestingCharacter, null);
        }
        return weight < 0 || this.hasFetish(Fetish.FETISH_SADIST);
    }

    public boolean isHappyToBeInSlot(AbstractSexPosition position, SexSlot slot, SexSlot targetSlot, GameCharacter target) {
        SexType targetSexPreference = Main.sex.getForeplayPreference(this, target);
        if (!Main.sex.isInForeplay(this)) {
            targetSexPreference = Main.sex.getMainSexPreference(this, target);
        }
        if (targetSexPreference == null) {
            return true;
        }
        return slot.isMeetsPreferenceCriteria(this, position, targetSlot, targetSexPreference);
    }

    public boolean isHappyToBeInSlot(AbstractSexPosition position, SexSlot slot, GameCharacter target) {
        return this.isHappyToBeInSlot(position, slot, null, target);
    }

    public SexPace getSexPaceSubPreference(GameCharacter character) {
        return null;
    }

    public SexPace getTheoreticalSexPaceSubPreference(GameCharacter character) {
        if (!this.isAttractedTo(character) || this.hasFetish(Fetish.FETISH_NON_CON_SUB)) {
            if (Main.game.isNonConEnabled()) {
                if (this.isSlave()) {
                    if (this.getObedienceValue() >= (float)ObedienceLevel.POSITIVE_FIVE_SUBSERVIENT.getMinimumValue()) {
                        return SexPace.SUB_EAGER;
                    }
                    if (this.getObedienceValue() >= (float)ObedienceLevel.POSITIVE_TWO_OBEDIENT.getMinimumValue()) {
                        return SexPace.SUB_NORMAL;
                    }
                }
                if (this.getHistory() == Occupation.NPC_PROSTITUTE && Main.sex.isConsensual()) {
                    return SexPace.SUB_NORMAL;
                }
                return SexPace.SUB_RESISTING;
            }
            return SexPace.SUB_NORMAL;
        }
        if (this.hasStatusEffect(StatusEffect.WEATHER_STORM_VULNERABLE)) {
            return SexPace.SUB_EAGER;
        }
        if (this.hasFetish(Fetish.FETISH_SUBMISSIVE) || this.hasFetish(Fetish.FETISH_PREGNANCY) && character.hasPenisIgnoreDildo() && this.hasVagina() || this.hasFetish(Fetish.FETISH_IMPREGNATION) && character.hasVagina() && this.hasPenisIgnoreDildo()) {
            return SexPace.SUB_EAGER;
        }
        return SexPace.SUB_NORMAL;
    }

    public SexPace getSexPaceDomPreference() {
        return null;
    }

    public SexPace getTheoreticalSexPaceDomPreference() {
        if (this.hasStatusEffect(StatusEffect.FETISH_PURE_VIRGIN) || this.hasFetish(Fetish.FETISH_SUBMISSIVE) && !this.hasFetish(Fetish.FETISH_DOMINANT)) {
            return SexPace.DOM_GENTLE;
        }
        if (this.hasFetish(Fetish.FETISH_SADIST) || this.hasFetish(Fetish.FETISH_DOMINANT)) {
            return SexPace.DOM_ROUGH;
        }
        return SexPace.DOM_NORMAL;
    }

    public List<Class<?>> getUniqueSexClasses() {
        return new ArrayList();
    }

    public List<SexActionInterface> getLimitedSexClasses() {
        return null;
    }

    protected List<SexActionInterface> getSexActionInterfacesFromClass(Class<?> classToAddSexActionsFrom) {
        Field[] fields;
        ArrayList<SexActionInterface> actions = new ArrayList<SexActionInterface>();
        for (Field f : fields = classToAddSexActionsFrom.getFields()) {
            if (!SexAction.class.isAssignableFrom(f.getType())) continue;
            try {
                SexAction action = (SexAction)f.get(null);
                actions.add(action);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return actions;
    }

    public Util.Value<Boolean, String> getItemUseEffects(AbstractItem item, GameCharacter itemOwner, GameCharacter user, GameCharacter target) {
        if (!user.equals(target)) {
            boolean isItemOrdinary;
            boolean bl = isItemOrdinary = !item.getItemType().isTransformative() && !item.getItemType().isFetishGiving();
            if (target.isElemental()) {
                if (item.getItemType().isTransformative()) {
                    return new Util.Value<Boolean, CallSite>(true, (CallSite)((Object)(UtilText.parse(user, target, "<p>[npc2.speech(\u6211\u968f\u65f6\u90fd\u53ef\u4ee5\u81ea\u7531\u8f6c\u5316\uff0c\u7ed9\u6211" + item.getItemType().getUseName() + "\u90a3\u4e2a\u6050\u6015\u6d6a\u8d39\u4e86\uff0c)][npc2.name]\u53f9\u4e86\u53e3\u6c14\uff0c\u4f46\u5374\u8fd8\u662f\u7167\u7740\u5bf9\u65b9\u7684\u6307\u793a\uff0c" + item.getItemType().getUseName() + "\u4e86" + item.getName() + "\u3002</p>", new ParserTag[0]) + itemOwner.useItem(item, target, false))));
                }
                return new Util.Value<Boolean, String>(true, itemOwner.useItem(item, target, false));
            }
            if (isItemOrdinary || !target.isUnique() && !Main.game.isInCombat() && Main.combat.getAllCombatants(true).contains(user) && Main.combat.isCharacterVictory(user) && Main.combat.getEnemies(user).contains(target) || target.isSlave() && target.getOwner() != null && target.getOwner().equals(user)) {
                return new Util.Value<Boolean, String>(true, this.getItemUseEffectsAllowingUse(item, itemOwner, user, target));
            }
            if (!target.isUnique() && (target.hasStatusEffect(StatusEffect.DRUNK_5) || target.hasStatusEffect(StatusEffect.DRUNK_4) || target.hasStatusEffect(StatusEffect.PSYCHOACTIVE) || target.getAffectionLevel(user) == AffectionLevel.POSITIVE_FIVE_WORSHIP || target.getFetishDesire(Fetish.FETISH_TRANSFORMATION_RECEIVING).isPositive() && item.getItemType().isTransformative() || target.getFetishDesire(Fetish.FETISH_KINK_RECEIVING).isPositive() && item.getItemType().isFetishGiving() || Main.game.isInSex() && !Main.sex.isConsensual() && Main.sex.isDom(user) && !Main.sex.isDom(target))) {
                return new Util.Value<Boolean, String>(true, this.getItemUseEffectsAllowingUse(item, itemOwner, user, target));
            }
            if (item.getItemType().isTransformative()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(user, target, "<p>[npc.Name]\u51c6\u5907\u5c06\u81ea\u5df1\u7684" + item.getName() + "\u7ed9[npc2.name]\uff0c\u4f46[npc2.she]\u5374\u53ea\u662f\u77a7\u4e86\u4e00\u773c\uff0c\u4fbf\u7b11\u9053\uff0c[npc2.speech(\u54c8\uff01\u6709\u60f3\u6cd5\uff01\u4f46\u4f60\u4e0d\u4f1a\u771f\u89c9\u5f97\u8fd9\u79cd\u968f\u4fbf\u4ec0\u4e48\u836f\u6c34\uff0c\u6211\u5c31\u4f1a\u559d\u5427\uff1f\uff01)]<br/>[npc.Name]\u4e0d\u60c5\u613f\u5730\u628a" + item.getName() + "\u653e\u56de\u7269\u54c1\u680f\u4e2d\uff0c\u6ca1\u60f3\u5230[npc2.nameIsFull]\u7adf\u5bf9\u6b64\u6beb\u65e0\u5174\u8da3\u3002</p>", new ParserTag[0]));
            }
            return new Util.Value<Boolean, String>(false, UtilText.parse(user, target, "<p>[npc.Name]\u51c6\u5907\u5c06\u81ea\u5df1\u7684" + item.getName() + "\u4ea4\u7ed9[npc2.name]\uff0c\u4f46[npc2.she]\u5374\u62d2\u7edd\u4e86\u3002[npc.Name]\u53ea\u597d\u4e0d\u60c5\u613f\u5730\u628a" + item.getName() + "\u653e\u56de\u7269\u54c1\u680f\u4e2d\u3002</p>", new ParserTag[0]));
        }
        return new Util.Value<Boolean, String>(true, itemOwner.useItem(item, target, false));
    }

    protected String getItemUseEffectsAllowingUse(AbstractItem item, GameCharacter itemOwner, GameCharacter user, GameCharacter target) {
        boolean isObedientSlave;
        StringBuilder sb = new StringBuilder();
        boolean bl = isObedientSlave = target.isSlave() && target.getObedienceBasic() == ObedienceLevelBasic.OBEDIENT;
        if (!user.equals(target)) {
            if (item.getItemType().equals(ItemType.getItemTypeFromId("innoxia_pills_sterility"))) {
                sb.append(UtilText.parse(user, target, "<p>[npc.Name]\u62ff\u51fa\u4e00\u7247\u201c[#ITEM_innoxia_pills_sterility.getName(false)]\u201d\u7ed9\u4e86[npc2.name]\uff0c\u544a\u8bc9[npc2.herHim]\u5403\u4e0b\u53bb\u4e4b\u540e\u5c31\u4e0d\u7528\u62c5\u5fc3\u610f\u5916\u6000\u5b55\u4e86\u3002", new ParserTag[0]));
                if (isObedientSlave) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u987a\u4ece\u5730\u542c\u4ece\u4e86\u8981\u6c42\uff0c\u6b23\u7136\u63a5\u4e0b\u4e86\u836f\u7247\uff0c\u7acb\u9a6c\u62c6\u5f00\u5305\u88c5\uff0c\u54bd\u4e86\u4e0b\u53bb\u3002", new ParserTag[0]));
                } else if (target.hasFetish(Fetish.FETISH_IMPREGNATION) && target.hasPenis() || target.hasFetish(Fetish.FETISH_PREGNANCY) && target.hasVagina()) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u61ca\u607c\u5730\u53f9\u4e86\u4e00\u58f0\uff0c\u4f46\u8fd8\u662f\u63a5\u4e0b\u4e86\u836f\u7247\uff0c\u62c6\u5f00\u5305\u88c5\u54bd\u4e86\u4e0b\u53bb\uff0c\u968f\u540e\u545c\u54bd\u9053\uff0c[npc2.speech(\u6ca1\u4eba\u4f1a\u6000\u4e0a\u7684\u8bdd\uff0c\u641e\u8fd9\u4e2a\u8fd8\u6709\u4ec0\u4e48\u610f\u4e49\u5462\uff1f)]", new ParserTag[0]));
                } else {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u542c\u540e\u677e\u4e86\u53e3\u6c14\uff0c\u6b23\u7136\u63a5\u4e0b\u4e86\u836f\u7247\uff0c\u7acb\u9a6c\u62c6\u5f00\u5305\u88c5\u54bd\u4e86\u4e0b\u53bb\u3002", new ParserTag[0]));
                }
                sb.append("</p>");
                sb.append(itemOwner.useItem(item, target, false, true));
                return sb.toString();
            }
            if (item.getItemType().equals(ItemType.getItemTypeFromId("innoxia_pills_fertility"))) {
                sb.append(UtilText.parse(user, target, "<p>[npc.Name]\u62ff\u51fa\u4e00\u7247\u201c[#ITEM_innoxia_pills_fertility.getName(false)]\u201d\u7ed9\u4e86[npc2.name]\uff0c\u544a\u8bc9[npc2.herHim]\u5403\u4e0b\u53bb\u4e4b\u540e\u5c31\u66f4\u5bb9\u6613\u6000\u5b55\u4e86\u3002", new ParserTag[0]));
                if (isObedientSlave) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u987a\u4ece\u5730\u542c\u4ece\u4e86\u8981\u6c42\uff0c\u6b23\u7136\u63a5\u4e0b\u4e86\u836f\u7247\uff0c\u7acb\u9a6c\u62c6\u5f00\u5305\u88c5\uff0c\u54bd\u4e86\u4e0b\u53bb\u3002", new ParserTag[0]));
                } else if (target.hasFetish(Fetish.FETISH_IMPREGNATION) && target.hasPenis() || target.hasFetish(Fetish.FETISH_PREGNANCY) && target.hasVagina()) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u4e50\u5f97\u53eb\u4e86\u8d77\u6765\uff0c\u8feb\u4e0d\u53ca\u5f85\u5730\u4e00\u628a\u6293\u8fc7\u836f\u7247\uff0c\u62c6\u5f00\u4e86\u5305\u88c5\uff0c\u8fde\u5fd9\u54bd\u4e86\u4e0b\u53bb\uff0c\u9ad8\u558a\u9053\uff0c[npc2.speech(\u4e00\u8d77\u6765\u9020\u5b69\u5b50\u5427\uff01)]", new ParserTag[0]));
                } else {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u72b9\u8c6b\u5730\u53f9\u4e86\u4e00\u58f0\uff0c\uff0c\u4f46\u8fd8\u662f\u63a5\u4e0b\u4e86\u836f\u7247\uff0c\u62c6\u5f00\u5305\u88c5\u54bd\u4e86\u4e0b\u53bb\u3002", new ParserTag[0]));
                }
                sb.append("</p>");
                sb.append(itemOwner.useItem(item, target, false, true));
                return sb.toString();
            }
            if (item.getItemType().equals(ItemType.getItemTypeFromId("innoxia_pills_broodmother"))) {
                sb.append(UtilText.parse(user, target, "<p>[npc.Name]\u62ff\u51fa\u4e00\u7247\u201c[#ITEM_innoxia_pills_broodmother.getName(false)]\u201d\u7ed9\u4e86[npc2.name]\uff0c\u544a\u8bc9[npc2.herHim]\u5403\u4e0b\u53bb\u4e4b\u540e\u5c31\u66f4\u5bb9\u6613\u6000\u5b55\u4e86\u3002", new ParserTag[0]));
                if (isObedientSlave) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u987a\u4ece\u5730\u542c\u4ece\u4e86\u8981\u6c42\uff0c\u6b23\u7136\u63a5\u4e0b\u4e86\u836f\u7247\uff0c\u7acb\u9a6c\u62c6\u5f00\u5305\u88c5\uff0c\u54bd\u4e86\u4e0b\u53bb\u3002", new ParserTag[0]));
                } else if (target.hasFetish(Fetish.FETISH_IMPREGNATION) && target.hasPenis() || target.hasFetish(Fetish.FETISH_PREGNANCY) && target.hasVagina()) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u4e50\u5f97\u53eb\u4e86\u8d77\u6765\uff0c\u8feb\u4e0d\u53ca\u5f85\u5730\u4e00\u628a\u6293\u8fc7\u836f\u7247\uff0c\u62c6\u5f00\u4e86\u5305\u88c5\uff0c\u8fde\u5fd9\u54bd\u4e86\u4e0b\u53bb\uff0c\u9ad8\u558a\u9053\uff0c[npc2.speech(\u4e00\u8d77\u6574\u51e0\u4e2a\u5b69\u5b50\u51fa\u6765\u5427\uff01)]", new ParserTag[0]));
                } else {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u72b9\u8c6b\u5730\u53f9\u4e86\u4e00\u58f0\uff0c\uff0c\u4f46\u8fd8\u662f\u63a5\u4e0b\u4e86\u836f\u7247\uff0c\u62c6\u5f00\u5305\u88c5\u54bd\u4e86\u4e0b\u53bb\u3002", new ParserTag[0]));
                }
                sb.append("</p>");
                sb.append(itemOwner.useItem(item, target, false, true));
                return sb.toString();
            }
            if (item.getItemType().equals(ItemType.getItemTypeFromId("innoxia_pills_lubrication"))) {
                sb.append(UtilText.parse(user, target, "<p>[npc.name]\u62ff\u51fa\u4e00\u7247\u201c[#ITEM_innoxia_pills_lubrication.getName(false)]\u201d\u7ed9\u4e86[npc2.name]\uff0c\u544a\u8bc9[npc2.herHim]\u5403\u4e0b\u53bb\u80fd\u8ba9[npc2.herHim]\u53d8\u5f97\u66f4\u6da6\u6ed1\u3002", new ParserTag[0]));
                if (isObedientSlave) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u987a\u4ece\u5730\u542c\u4ece\u4e86\u8981\u6c42\uff0c\u6b23\u7136\u63a5\u4e0b\u4e86\u836f\u7247\uff0c\u7acb\u9a6c\u62c6\u5f00\u5305\u88c5\uff0c\u54bd\u4e86\u4e0b\u53bb\u3002", new ParserTag[0]));
                } else {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u89c1\u8fd9[#ITEM_innoxia_pills_lubrication.getName(false)]\u5403\u4e86\u4e5f\u6ca1\u4ec0\u4e48\u574f\u5904\uff0c\u4fbf\u4ece[npc.namePos]\u7684[npc.hand]\u91cc\u63a5\u4e86\u8fc7\u6765\uff0c\u7136\u540e\u8fc5\u901f\u5265\u5f00\u5305\u88c5\u4e00\u53e3\u541e\u4e0b\u3002", new ParserTag[0]));
                }
                sb.append("</p>");
                sb.append(itemOwner.useItem(item, target, false, true));
                return sb.toString();
            }
            if (item.getItemType().equals(ItemType.ELIXIR)) {
                sb.append(UtilText.parse(user, target, "<p>[npc.Name]\u4ece\u7269\u54c1\u680f\u53d6\u51fa" + item.getName() + "\uff0c\u9012\u7ed9\u4e86[npc2.name]\u3002", new ParserTag[0]));
                if (isObedientSlave) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u987a\u4ece\u5730\u542c\u4ece\u4e86\u8981\u6c42\uff0c\u6b23\u7136\u4ece[npc.Name]\u90a3\u91cc\u63a5\u4e0b\u4e86\u88c5\u6709\u8f6c\u5316\u6db2\u4f53\u7684\u74f6\u5b50\uff0c\u8bf4\u9053\uff0c[npc2.speech(\u6211\u81ea\u7136\u4f1a\u5fe0\u4e8e\u804c\u5b88\uff0c\u6309\u60a8\u7684\u559c\u597d\u8fdb\u884c\u8f6c\u5316\u2026\u2026)]</p><p>[npc2.she]\u4e3a\u4e86\u53d6\u60a6\u4e3b\u4eba\uff0c\u8fde\u5fd9\u8d77\u5f00\u4e86\u74f6\u585e\uff0c\u4fbf\u8feb\u4e0d\u53ca\u5f85\u5730\u9001\u5230[npc2.lips]\u8fb9\uff0c\u5927\u53e3\u5927\u53e3\u5730\u8c6a\u996e\u8d77\u6765\u3002\u559d\u5b8c\u540e[npc2.She]\u54b3\u55fd\u4e86\u4e00\u9635\u5b50\uff0c\u4fbf\u611f\u5230\u6db2\u4f53\u7684\u6548\u679c\u6b63\u5728\u5176\u8eab\u4f53\u6df1\u5904\u8d77\u6548\uff0c\u4e0d\u7981\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\u2026\u2026</p>", new ParserTag[0]));
                } else if (target.getSubspeciesOverrideRace() == Race.DEMON) {
                    sb.append(UtilText.parse(user, target, "<p>[npc.name]\u4ece\u7269\u54c1\u680f\u53d6\u51fa" + item.getName() + "\uff0c\u9012\u7ed9\u4e86[npc2.name]\u3002[npc2.she]\u770b\u5230\u9012\u8fc7\u6765\u7684\u662f\u4ec0\u4e48\u4e1c\u897f\u540e\uff0c\u4fbf\u5632\u7b11\u8d77\u6765\uff0c[npc2.speech(\u54c8\uff01\u4f60\u4e0d\u77e5\u9053\u6076\u9b54\u6ca1\u6cd5\u2014\u2014~\u5514\u55ef\uff01~)]</p><p>[npc2.namePos]\u4e00\u5f00\u53e3[npc.Name]\u5c31\u607c\u706b\u8d77\u6765\uff0c\u7acb\u9a6c\u8d77\u5f00\u4e86\u74f6\u585e\uff0c\u7c97\u9c81\u5730\u7ed9\u5bf9\u65b9\u704c\u4e86\u4e0b\u53bb\u3002[npc.Name]\u634f\u4f4f[npc2.her]\u7684\u9f3b\u5b50\uff0c\u7d27\u7d27\u63a7\u5236\u4f4f[npc2.herHim]\uff0c\u76f4\u5230[npc2.name]\u54bd\u4e0b\u6700\u540e\u4e00\u6ef4\u6db2\u4f53\uff0c\u624d\u653e[npc2.herHim]\u79bb\u5f00\u3002\u559d\u5b8c\u540e[npc2.She]\u54b3\u55fd\u4e86\u4e00\u9635\u5b50\uff0c\u628a\u5634\u89d2\u6b8b\u7559\u7684\u6db2\u4f53\u62b9\u5e72\u51c0\u540e\uff0c\u6c14\u607c\u5730\u561f\u54dd\u8d77\u6765\uff0c[npc2.speech(\u4e0d\u7b97\u592a\u96be\u559d\u2026\u2026)]</p>", new ParserTag[0]));
                } else if (target.hasFetish(Fetish.FETISH_TRANSFORMATION_RECEIVING)) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u770b\u5230\u9012\u8fc7\u6765\u7684\u662f\u4ec0\u4e48\u4e1c\u897f\u540e\uff0c\u4fbf\u5174\u9ad8\u91c7\u70c8\u5730\u5927\u53eb\u8d77\u6765\uff0c\u95ee\u9053\uff0c[npc2.speech(\u8fd9\u662f\u8f6c\u5316\u7075\u836f\u5427\uff1f\uff01\u6c42\u4f60\u4e86\uff0c\u8ba9\u6211\u559d\u5427\uff01\u60f3\u628a\u6211\u53d8\u6210\u4ec0\u4e48\u6837\u90fd\u53ef\u4ee5\uff01)]</p><p>[npc.Name]\u542c\u5230[npc2.namePos]\u56de\u5e94\u5982\u6b64\u70ed\u60c5\uff0c\u4e0d\u7531\u5f97\u9732\u51fa\u4e86\u4e00\u62b9\u5fae\u7b11\uff0c\u968f\u540e\u8d77\u5f00\u4e86\u74f6\u585e\uff0c\u5c06\u836f\u5242\u9001\u5230\u90a3\u6025\u5207\u7684[npc2.race]\u5634\u65c1\u3002[npc2.name]\u5f00\u5fc3\u5730\u542b\u4f4f\u4e86\u74f6\u53e3\uff0c\u5927\u53e3\u5927\u53e3\u5730\u7545\u996e\u8d77\u6765\u3002\u559d\u5b8c\u540e[npc2.She]\u54b3\u55fd\u4e86\u4e00\u9635\u5b50\uff0c\u4fbf\u611f\u5230\u6db2\u4f53\u7684\u6548\u679c\u6b63\u5728\u5176\u8eab\u4f53\u6df1\u5904\u8d77\u6548\uff0c\u4e0d\u7981\u559c\u6781\u800c\u6ce3\u2026\u2026</p>", new ParserTag[0]));
                } else if (target.getAffection(user) < (float)AffectionLevel.POSITIVE_FIVE_WORSHIP.getMinimumValue()) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u770b\u5230\u9012\u8fc7\u6765\u7684\u662f\u4ec0\u4e48\u4e1c\u897f\u540e\uff0c\u4e0d\u5b89\u5730\u6643\u4e86\u6643\u8eab\u5b50\uff0c\u95ee\u9053\uff0c[npc2.speech(\u4f60\u8be5\u4e0d\u662f\u8ba4\u771f\u7684\u5427\uff0c\u968f\u4fbf\u62ff\u2014\u2014~\u5514\u55ef\uff01~)]</p><p>[npc2.namePos]\u4e00\u5f00\u53e3[npc.Name]\u5c31\u607c\u706b\u8d77\u6765\uff0c\u7acb\u9a6c\u8d77\u5f00\u4e86\u74f6\u585e\uff0c\u7c97\u9c81\u5730\u7ed9\u5bf9\u65b9\u704c\u4e86\u4e0b\u53bb\u3002[npc.Name]\u634f\u4f4f[npc2.her]\u7684\u9f3b\u5b50\uff0c\u7d27\u7d27\u63a7\u5236\u4f4f[npc2.herHim]\uff0c\u76f4\u5230[npc2.name]\u54bd\u4e0b\u6700\u540e\u4e00\u6ef4\u6db2\u4f53\uff0c\u624d\u653e[npc2.herHim]\u79bb\u5f00\u3002\u559d\u5b8c\u540e[npc2.She]\u54b3\u55fd\u4e86\u4e00\u9635\u5b50\uff0c\u4fbf\u611f\u5230\u6db2\u4f53\u7684\u6548\u679c\u6b63\u5728\u5176\u8eab\u4f53\u6df1\u5904\u8d77\u6548\uff0c\u4e0d\u7981\u60ca\u547c\u8d77\u6765\u2026\u2026</p>", new ParserTag[0]));
                } else {
                    sb.append(UtilText.parse(user, target, " \u7531\u4e8e[npc2.she]\u975e\u5e38\u559c\u6b22[npc.name]\uff0c\u4e8e\u662f\u6682\u65f6\u653e\u4e0b\u4e86\u5bf9\u4e8e\u8f6c\u5316\u7684\u62c5\u5fe7\uff0c\u8bf4\u9053\uff0c[npc2.speech(\u6211\u5f53\u7136\u4f1a\u559d\u4e86\uff01\u65e0\u8bba\u4ec0\u4e48\u6211\u90fd\u4f1a\u4e3a\u4f60\u505a\u7684\u2026\u2026)]</p><p>\u542c\u5230[npc2.namePos]\u5fc3\u7518\u60c5\u613f\u7684\u56de\u590d\uff0c[npc.Name]\u4fbf\u8d77\u5f00\u4e86\u74f6\u585e\uff0c\u5c06\u836f\u5242\u9012\u7ed9\u4e86[npc2.herHim]\u3002[npc2.she]\u4e3a\u4e86\u53d6\u60a6\u5bf9\u65b9\uff0c\u4fbf\u4e5f\u6b23\u7136\u542b\u4f4f\u74f6\u53e3\uff0c\u5927\u53e3\u5927\u53e3\u5730\u7545\u996e\u8d77\u6765\u3002\u559d\u5b8c\u540e[npc2.She]\u54b3\u55fd\u4e86\u4e00\u9635\u5b50\uff0c\u4fbf\u611f\u5230\u6db2\u4f53\u7684\u6548\u679c\u6b63\u5728\u5176\u8eab\u4f53\u6df1\u5904\u8d77\u6548\uff0c\u4e0d\u514d\u60ca\u547c\u4e00\u58f0\u2026\u2026</p>", new ParserTag[0]));
                }
                sb.append(itemOwner.useItem(item, target, false, true));
                return sb.toString();
            }
            if (item.getItemType().equals(ItemType.FETISH_REFINED)) {
                sb.append(UtilText.parse(user, target, "<p>[npc.Name]\u4ece\u7269\u54c1\u680f\u53d6\u51fa" + item.getName() + "\uff0c\u9012\u7ed9\u4e86[npc2.name]\u3002", new ParserTag[0]));
                if (isObedientSlave) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u987a\u4ece\u5730\u542c\u4ece\u4e86\u8981\u6c42\uff0c\u4ece[npc.Name]\u90a3\u91cc\u63a5\u4e0b\u4e86\u88c5\u6709\u6539\u53d8\u6027\u7656\u6db2\u4f53\u7684\u74f6\u5b50\uff0c\u8bf4\u9053\uff0c[npc2.speech(\u6211\u81ea\u7136\u4f1a\u5fe0\u4e8e\u804c\u5b88\uff0c\u53d8\u6210\u60a8\u559c\u6b22\u7684\u90a3\u79cd\u5974\u96b6\u2026\u2026)]</p><p>[npc2.she]\u4e3a\u4e86\u53d6\u60a6\u4e3b\u4eba\uff0c\u8fde\u5fd9\u8d77\u5f00\u4e86\u74f6\u585e\uff0c\u4fbf\u8feb\u4e0d\u53ca\u5f85\u5730\u9001\u5230[npc2.lips]\u8fb9\uff0c\u5927\u53e3\u5927\u53e3\u5730\u8c6a\u996e\u8d77\u6765\u3002\u559d\u5b8c\u540e[npc2.She]\u54b3\u55fd\u4e86\u4e00\u9635\u5b50\uff0c\u4fbf\u611f\u5230\u6db2\u4f53\u7684\u6548\u679c\u6b63\u5728\u5176\u8111\u6d77\u6df1\u5904\u8d77\u6548\uff0c\u4e0d\u7981\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\u2026\u2026</p>", new ParserTag[0]));
                } else if (target.hasFetish(Fetish.FETISH_KINK_RECEIVING)) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u770b\u5230\u9012\u8fc7\u6765\u7684\u662f\u4ec0\u4e48\u4e1c\u897f\u540e\uff0c\u4fbf\u5174\u9ad8\u91c7\u70c8\u5730\u5927\u53eb\u8d77\u6765\uff0c\u95ee\u9053\uff0c[npc2.speech(\u80fd\u8ba9\u6211\u5f97\u5230\u65b0\u7684\u6027\u7656\u5417\uff1f\uff01\u6c42\u4f60\u4e86\uff0c\u8ba9\u6211\u559d\u5427\uff01)]</p><p>[npc.Name]\u542c\u5230[npc2.namePos]\u56de\u5e94\u5982\u6b64\u70ed\u60c5\uff0c\u4e0d\u7531\u5f97\u9732\u51fa\u4e86\u4e00\u62b9\u5fae\u7b11\uff0c\u968f\u540e\u8d77\u5f00\u4e86\u74f6\u585e\uff0c\u5c06\u836f\u5242\u9001\u5230\u90a3\u6025\u5207\u7684[npc2.race]\u5634\u65c1\u3002[npc2.name]\u5f00\u5fc3\u5730\u542b\u4f4f\u4e86\u74f6\u53e3\uff0c\u5927\u53e3\u5927\u53e3\u5730\u7545\u996e\u8d77\u6765\u3002\u559d\u5b8c\u540e[npc2.She]\u54b3\u55fd\u4e86\u4e00\u9635\u5b50\uff0c\u4fbf\u611f\u5230\u6db2\u4f53\u7684\u6548\u679c\u6b63\u5728\u5176\u8111\u6d77\u6df1\u5904\u8d77\u6548\uff0c\u4e0d\u7981\u559c\u6781\u800c\u6ce3\u2026\u2026</p>", new ParserTag[0]));
                } else if (target.getSubspeciesOverrideRace() == Race.DEMON) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u770b\u5230\u9012\u8fc7\u6765\u7684\u662f\u4ec0\u4e48\u4e1c\u897f\u540e\uff0c\u4fbf\u5632\u7b11\u8d77\u6765\uff0c[npc2.speech(\u54c8\uff01\u4f60\u4e0d\u77e5\u9053\u6076\u9b54\u6ca1\u6cd5\u2014\u2014~\u5514\u55ef\uff01~)]</p><p>[npc2.namePos]\u4e00\u5f00\u53e3[npc.Name]\u5c31\u607c\u706b\u8d77\u6765\uff0c\u7acb\u9a6c\u8d77\u5f00\u4e86\u74f6\u585e\uff0c\u7c97\u9c81\u5730\u7ed9\u5bf9\u65b9\u704c\u4e86\u4e0b\u53bb\u3002[npc.Name]\u634f\u4f4f[npc2.her]\u7684\u9f3b\u5b50\uff0c\u7d27\u7d27\u63a7\u5236\u4f4f[npc2.herHim]\uff0c\u76f4\u5230[npc2.name]\u54bd\u4e0b\u6700\u540e\u4e00\u6ef4\u6db2\u4f53\uff0c\u624d\u653e[npc2.herHim]\u79bb\u5f00\u3002\u559d\u5b8c\u540e[npc2.She]\u54b3\u55fd\u4e86\u4e00\u9635\u5b50\uff0c\u628a\u5634\u89d2\u6b8b\u7559\u7684\u6db2\u4f53\u62b9\u5e72\u51c0\u540e\uff0c\u53d1\u51fa\u4e00\u58f0\u6deb\u8361\u7684[npc2.moan]\uff0c[npc2.speech(~\u554a\u554a\uff01~\u5bf9\u4e86\uff0c\u8fd9\u662f\u6027\u7656\u8f6c\u5316\u836f\u5427\uff1f\uff01~\u989d\u554a\uff01~\u8eab\u4f53\u597d\u70ed\u2026\u2026)]</p>", new ParserTag[0]));
                } else if (target.getAffection(user) < (float)AffectionLevel.POSITIVE_FIVE_WORSHIP.getMinimumValue()) {
                    sb.append(UtilText.parse(user, target, "[npc2.she]\u770b\u5230\u9012\u8fc7\u6765\u7684\u662f\u4ec0\u4e48\u4e1c\u897f\u540e\uff0c\u4e0d\u5b89\u5730\u6643\u4e86\u6643\u8eab\u5b50\uff0c\u95ee\u9053\uff0c[npc2.speech(\u4f60\u8be5\u4e0d\u662f\u8ba4\u771f\u7684\u5427\uff0c\u968f\u4fbf\u62ff\u2014\u2014~\u5514\u55ef\uff01~)]</p><p>[npc2.namePos]\u4e00\u5f00\u53e3[npc.Name]\u5c31\u607c\u706b\u8d77\u6765\uff0c\u7acb\u9a6c\u8d77\u5f00\u4e86\u74f6\u585e\uff0c\u7c97\u9c81\u5730\u7ed9\u5bf9\u65b9\u704c\u4e86\u4e0b\u53bb\u3002[npc.Name]\u634f\u4f4f[npc2.her]\u7684\u9f3b\u5b50\uff0c\u7d27\u7d27\u63a7\u5236\u4f4f[npc2.herHim]\uff0c\u76f4\u5230[npc2.name]\u54bd\u4e0b\u6700\u540e\u4e00\u6ef4\u6db2\u4f53\uff0c\u624d\u653e[npc2.herHim]\u79bb\u5f00\u3002\u559d\u5b8c\u540e[npc2.She]\u54b3\u55fd\u4e86\u4e00\u9635\u5b50\uff0c\u4fbf\u611f\u5230\u6db2\u4f53\u7684\u6548\u679c\u6b63\u5728\u5176\u8111\u6d77\u6df1\u5904\u8d77\u6548\uff0c\u4e0d\u7981\u60ca\u547c\u8d77\u6765\u2026\u2026</p>", new ParserTag[0]));
                } else {
                    sb.append(UtilText.parse(user, target, " \u7531\u4e8e[npc2.she]\u975e\u5e38\u559c\u6b22[npc.name]\uff0c\u4e8e\u662f\u6682\u65f6\u653e\u4e0b\u4e86\u5bf9\u4e8e\u8f6c\u5316\u7684\u62c5\u5fe7\uff0c\u8bf4\u9053\uff0c[npc2.speech(\u6211\u5f53\u7136\u4f1a\u559d\u4e86\uff01\u65e0\u8bba\u4ec0\u4e48\u6211\u90fd\u4f1a\u4e3a\u4f60\u505a\u7684\u2026\u2026)]</p><p>\u542c\u5230[npc2.namePos]\u5fc3\u7518\u60c5\u613f\u7684\u56de\u590d\uff0c[npc.Name]\u4fbf\u8d77\u5f00\u4e86\u74f6\u585e\uff0c\u5c06\u836f\u5242\u9012\u7ed9\u4e86[npc2.herHim]\u3002[npc2.she]\u4e3a\u4e86\u53d6\u60a6\u5bf9\u65b9\uff0c\u4fbf\u4e5f\u6b23\u7136\u542b\u4f4f\u74f6\u53e3\uff0c\u5927\u53e3\u5927\u53e3\u5730\u7545\u996e\u8d77\u6765\u3002\u559d\u5b8c\u540e[npc2.She]\u54b3\u55fd\u4e86\u4e00\u9635\u5b50\uff0c\u4fbf\u611f\u5230\u6db2\u4f53\u7684\u6548\u679c\u6b63\u5728\u5176\u8111\u6d77\u6df1\u5904\u8d77\u6548\uff0c\u4e0d\u514d\u60ca\u547c\u4e00\u58f0\u2026\u2026</p>", new ParserTag[0]));
                }
                sb.append(itemOwner.useItem(item, target, false, true));
                return sb.toString();
            }
            if (item.getItemType().equals(ItemType.POTION) || item.getItemType().equals(ItemType.EGGPLANT_POTION) || item.getItemType().equals(ItemType.MOTHERS_MILK) || item.getItemType().equals(ItemType.FETISH_UNREFINED)) {
                if (isObedientSlave) {
                    sb.append(UtilText.parse(user, target, "<p>[npc.name]\u4ece\u7269\u54c1\u680f\u53d6\u51fa" + item.getName() + "\uff0c\u9012\u7ed9\u4e86[npc2.name]\u3002[npc2.she]\u987a\u4ece\u5730\u542c\u4ece\u4e86\u8981\u6c42\uff0c\u6b23\u7136\u4ece[npc.Name]\u90a3\u91cc\u63a5\u4e0b\u4e86\u88c5\u6709\u6db2\u4f53\u7684\u74f6\u5b50\uff0c\u8bf4\u9053\uff0c[npc2.speech(\u60a8\u65e0\u8bba\u7ed9\u6211\u4ec0\u4e48\uff0c\u6211\u90fd\u4f1a\u559d\u7684\u2026\u2026)]</p><p>[npc2.she]\u4e3a\u4e86\u53d6\u60a6\u4e3b\u4eba\uff0c\u8fde\u5fd9\u8d77\u5f00\u4e86\u74f6\u585e\uff0c\u4fbf\u8feb\u4e0d\u53ca\u5f85\u5730\u9001\u5230[npc2.lips]\u8fb9\uff0c\u5927\u53e3\u5927\u53e3\u5730\u8c6a\u996e\u8d77\u6765\u3002\u559d\u5b8c\u540e[npc2.She]\u54b3\u55fd\u4e86\u4e00\u9635\u5b50\uff0c\u4fbf\u611f\u5230\u6db2\u4f53\u6b63\u5728\u8d77\u6548\u4e86\uff0c\u4e0d\u7981\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\u2026\u2026</p>", new ParserTag[0]));
                } else {
                    sb.append(UtilText.parse(user, target, "<p>[npc.name]\u4ece\u7269\u54c1\u680f\u53d6\u51fa" + item.getName() + "\uff0c\u9012\u7ed9\u4e86[npc2.name]\u3002[npc2.she]\u770b\u5230\u9012\u8fc7\u6765\u7684\u662f\u4ec0\u4e48\u4e1c\u897f\u540e\uff0c\u4e0d\u5b89\u5730\u6643\u4e86\u6643\u8eab\u5b50\uff0c\u95ee\u9053\uff0c[npc2.speech(\u4f60\u8be5\u4e0d\u662f\u8ba4\u771f\u7684\u5427\uff0c\u968f\u4fbf\u62ff\u2014\u2014~\u5514\u55ef\uff01~)]</p><p>[npc2.namePos]\u4e00\u5f00\u53e3[npc.Name]\u5c31\u607c\u706b\u8d77\u6765\uff0c\u7acb\u9a6c\u8d77\u5f00\u4e86\u74f6\u585e\uff0c\u7c97\u9c81\u5730\u7ed9\u5bf9\u65b9\u704c\u4e86\u4e0b\u53bb\u3002[npc.Name]\u634f\u4f4f[npc2.her]\u7684\u9f3b\u5b50\uff0c\u7d27\u7d27\u63a7\u5236\u4f4f[npc2.herHim]\uff0c\u76f4\u5230[npc2.name]\u54bd\u4e0b\u6700\u540e\u4e00\u6ef4\u6db2\u4f53\uff0c\u624d\u653e[npc2.herHim]\u79bb\u5f00\u3002\u559d\u5b8c\u540e[npc2.She]\u54b3\u55fd\u4e86\u4e00\u9635\u5b50\uff0c\u4fbf\u611f\u5230\u6db2\u4f53\u6b63\u5728\u8d77\u6548\u4e86\uff0c\u4e0d\u7981\u60ca\u547c\u8d77\u6765\u2026\u2026</p>", new ParserTag[0]));
                }
                sb.append(itemOwner.useItem(item, target, false, true));
                return sb.toString();
            }
            if (item.getItemType().equals(ItemType.EGGPLANT)) {
                if (isObedientSlave) {
                    sb.append(UtilText.parse(user, target, "<p>[npc.Name]\u4ece\u7269\u54c1\u680f\u4e2d\u53d6\u51fa\u8304\u5b50\uff0c\u9012\u7ed9\u4e86[npc2.name]\u3002[npc2.she]\u770b\u5230\u9012\u8fc7\u6765\u7684\u662f\u4ec0\u4e48\u4e1c\u897f\u540e\uff0c\u987a\u4ece\u5730\u63a5\u4e86\u4e0b\u6765\uff0c\u8bf4\u9053\uff0c[npc2.speech(\u60a8\u65e0\u8bba\u7ed9\u6211\u4ec0\u4e48\uff0c\u6211\u90fd\u4f1a\u5403\u7684\u2026\u2026)]</p><p>[npc2.she]\u4e3a\u4e86\u53d6\u60a6\u4e3b\u4eba\uff0c\u8fde\u5fd9\u628a\u8fd9\u7d2b\u8272\u7684\u6c34\u679c\u9001\u5230[npc2.lips]\u8fb9\uff0c\u5403\u5f97\u5e72\u5e72\u51c0\u51c0\u2026\u2026</p>", new ParserTag[0]));
                } else {
                    sb.append(UtilText.parse(target, "<p>[npc.Name]\u4ece\u7269\u54c1\u680f\u4e2d\u53d6\u51fa\u8304\u5b50\uff0c\u9012\u7ed9\u4e86[npc2.name]\u3002[npc2.she]\u770b\u5230\u9012\u8fc7\u6765\u7684\u662f\u4ec0\u4e48\u4e1c\u897f\u540e\uff0c\u4e0d\u5b89\u5730\u6643\u4e86\u6643\u8eab\u5b50\uff0c\u95ee\u9053\uff0c[npc2.speech(\u4f60\u62ff\u90a3\u4e2a\u662f\u8981\u2014\u2014~\u5514\u55ef\uff01~)]</p><p>[npc2.namePos]\u4e00\u5f00\u53e3[npc.Name]\u5c31\u607c\u706b\u8d77\u6765\uff0c\u7acb\u9a6c\u628a\u8304\u5b50\u585e\u8fdb\u4e86[npc2.her]\u7684\u5634\u5df4\uff0c\u5f3a\u8feb[npc2.herHim]\u628a\u8fd9\u7d2b\u8272\u7684\u6c34\u679c\u5403\u5f97\u5e72\u5e72\u51c0\u51c0\u2026\u2026</p>", new ParserTag[0]));
                }
                sb.append(itemOwner.useItem(item, target, false, true));
                return sb.toString();
            }
            return itemOwner.useItem(item, target, false);
        }
        return itemOwner.useItem(item, target, false);
    }
}

