/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.dominion;

import com.lilithsthrone.game.Game;
import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.effects.AbstractPerk;
import com.lilithsthrone.game.character.effects.PerkCategory;
import com.lilithsthrone.game.character.effects.PerkManager;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.persona.SexualOrientation;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.ReindeerOverseerDialogue;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.outfit.OutfitType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.Season;
import com.lilithsthrone.world.Weather;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReindeerOverseer
extends NPC {
    public ReindeerOverseer() {
        this(Gender.getGenderFromUserPreferences(false, false), false);
    }

    public ReindeerOverseer(Gender gender) {
        this(gender, false);
    }

    public ReindeerOverseer(boolean isImported) {
        this(Gender.F_V_B_FEMALE, isImported);
    }

    public ReindeerOverseer(Gender gender, boolean isImported) {
        super(isImported, null, null, "", Util.random.nextInt(28) + 18, Util.randomItemFrom(Month.values()), 1 + Util.random.nextInt(25), 10, null, null, null, new CharacterInventory(false, 10), WorldType.DOMINION, PlaceType.DOMINION_STREET, false, new NPCGenerationFlag[0]);
        if (!isImported) {
            this.setRandomLocation(WorldType.DOMINION, PlaceType.DOMINION_STREET, true);
            this.setSexualOrientation(SexualOrientation.AMBIPHILIC);
            AbstractSubspecies subspecies = Subspecies.REINDEER_MORPH;
            if (gender.isFeminine()) {
                RaceStage stage = Main.game.getCharacterUtils().getRaceStageFromPreferences(Main.getProperties().getSubspeciesFeminineFurryPreferencesMap().get(subspecies), gender, subspecies);
                this.setBody(gender, subspecies, stage, true);
            } else {
                RaceStage stage = Main.game.getCharacterUtils().getRaceStageFromPreferences(Main.getProperties().getSubspeciesMasculineFurryPreferencesMap().get(subspecies), gender, subspecies);
                this.setBody(gender, subspecies, stage, true);
            }
            this.setName(Name.getRandomTriplet(subspecies));
            this.setPlayerKnowsName(false);
            this.setHistory(Occupation.REINDEER_OVERSEER);
            Main.game.getCharacterUtils().addFetishes(this, new AbstractFetish[0]);
            Main.game.getCharacterUtils().randomiseBody(this, true);
            this.resetInventory(true);
            this.inventory.setMoney(10 + Util.random.nextInt(this.getLevel() * 10) + 1);
            this.equipClothing(EquipClothingSetting.getAllClothingSettings());
            Main.game.getCharacterUtils().applyMakeup(this, true);
            this.dailyUpdate();
            this.initHealthAndManaToMax();
        }
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        ReindeerOverseer.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
        if (Main.isVersionOlderThan(Game.loadingVersion, "0.3.3.6")) {
            this.resetPerksMap(true);
        }
    }

    @Override
    public void setupPerks(boolean autoSelectPerks) {
        PerkManager.initialisePerks((GameCharacter)this, Util.newArrayListOfValues(new AbstractPerk[0]), Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 3), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)));
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        Main.game.getCharacterUtils().equipClothingFromOutfitType(this, OutfitType.JOB_LABOUR, settings);
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getDescription() {
        return UtilText.parse((GameCharacter)this, "[npc.Name]\u662f\u67d0\u4e2a\u9a6f\u9e7f\u5316\u5f62\u5c0f\u961f\u7684\u76d1\u5de5\uff0c\u5728\u6574\u4e2a\u5fa1\u57ce\u533a\u6e05\u7406\u79ef\u96ea\uff0c\u626b\u6e05\u8857\u9053\u3002", new ParserTag[0]);
    }

    @Override
    public void dailyUpdate() {
        if (!this.isSlave() && !Main.game.getPlayer().getFriendlyOccupants().contains(this.getId())) {
            if (Main.game.getCurrentWeather() != Weather.SNOW && Main.game.getSeason() != Season.WINTER) {
                Main.game.getDialogueFlags().values.remove(DialogueFlagValue.hasSnowedThisWinter);
                if (this.getLocation() != Main.game.getPlayer().getLocation()) {
                    this.setLocation(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, true);
                }
            } else {
                int i;
                this.clearNonEquippedInventory(false);
                if (this.getLocationPlace().getPlaceType().equals(PlaceType.DOMINION_STREET) && !this.getLocation().equals(Main.game.getPlayer().getLocation())) {
                    this.moveToAdjacentMatchingCellType(true, new AbstractPlaceType[0]);
                    Main.game.getDialogueFlags().dailyReindeerReset(this.getId());
                }
                for (int i2 = 0; i2 < 10 + Util.random.nextInt(6); ++i2) {
                    this.addItem(Main.game.getItemGen().generateItem(ItemType.PRESENT), false);
                }
                for (AbstractItemType item : ItemType.getAllItems()) {
                    if (item == null || !item.getItemTags().contains((Object)ItemTag.REINDEER_GIFT)) continue;
                    for (i = 0; i < 3 + Util.random.nextInt(6); ++i) {
                        this.addItem(Main.game.getItemGen().generateItem(item), false);
                    }
                }
                for (AbstractClothingType clothing : ClothingType.getAllClothing()) {
                    if (clothing == null || !clothing.getDefaultItemTags().contains((Object)ItemTag.REINDEER_GIFT)) continue;
                    for (i = 0; i < 1 + Util.random.nextInt(2); ++i) {
                        this.addClothing(Main.game.getItemGen().generateClothing(clothing, false), false);
                    }
                }
            }
        }
    }

    @Override
    public String getTraderDescription() {
        return UtilText.parse((GameCharacter)this, "<p>[npc.speech(\u6ca1\u4ec0\u4e48\u5174\u8da3\u4ece\u4f60\u90a3\u91cc\u4e70\u4e1c\u897f\uff0c)][npc.name]\u89e3\u91ca\u7740\u4fbf\u9886\u4f60\u53bb\u4e86\u9644\u8fd1\u7684\u62d6\u8f66\u8fb9\uff0c\u4e0a\u9762\u9ad8\u9ad8\u5730\u5806\u6ee1\u4e86\u76d2\u5b50\uff0c[npc.speech(\u4f46\u662f\u6211\u5356\u7684\u4e1c\u897f\u90fd\u5728\u8fd9\u4e86\u3002\u6211\u4eec\u4eca\u5e74\u7a7f\u8d8a\u5fc3\u6797\u9ad8\u5730\u6765\u5230\u5fa1\u57ce\u533a\uff0c\u6240\u4ee5\u80fd\u63d0\u4f9b\u4e00\u4e9b\u5996\u72d0\u7684\u4f20\u7edf\u670d\u9970\uff01)]</p>", new ParserTag[0]);
    }

    @Override
    public boolean isTrader() {
        return true;
    }

    @Override
    public boolean willBuy(AbstractCoreItem item) {
        return false;
    }

    @Override
    public void endSex() {
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return ReindeerOverseerDialogue.ENCOUNTER_START;
    }
}

