/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.fields;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.Covering;
import com.lilithsthrone.game.character.body.valueEnums.AssSize;
import com.lilithsthrone.game.character.body.valueEnums.BodyHair;
import com.lilithsthrone.game.character.body.valueEnums.BodySize;
import com.lilithsthrone.game.character.body.valueEnums.Capacity;
import com.lilithsthrone.game.character.body.valueEnums.ClitorisSize;
import com.lilithsthrone.game.character.body.valueEnums.CoveringModifier;
import com.lilithsthrone.game.character.body.valueEnums.CoveringPattern;
import com.lilithsthrone.game.character.body.valueEnums.HairLength;
import com.lilithsthrone.game.character.body.valueEnums.HairStyle;
import com.lilithsthrone.game.character.body.valueEnums.HipSize;
import com.lilithsthrone.game.character.body.valueEnums.LabiaSize;
import com.lilithsthrone.game.character.body.valueEnums.LipSize;
import com.lilithsthrone.game.character.body.valueEnums.Muscle;
import com.lilithsthrone.game.character.body.valueEnums.OrificeElasticity;
import com.lilithsthrone.game.character.body.valueEnums.OrificePlasticity;
import com.lilithsthrone.game.character.body.valueEnums.TongueLength;
import com.lilithsthrone.game.character.body.valueEnums.Wetness;
import com.lilithsthrone.game.character.effects.AbstractPerk;
import com.lilithsthrone.game.character.effects.PerkCategory;
import com.lilithsthrone.game.character.effects.PerkManager;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.fetishes.FetishDesire;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.NameTriplet;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.persona.PersonalityTrait;
import com.lilithsthrone.game.character.persona.SexualOrientation;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Ceridwen
extends NPC {
    public Ceridwen() {
        this(false);
    }

    public Ceridwen(boolean isImported) {
        super(isImported, new NameTriplet("\u51ef\u4e3d\u5fb7\u6e29"), "\u6469\u6839", "\u51ef\u4e3d\u5fb7\u6e29\u5728\u4f0a\u5229\u65af\u7684\u8d2d\u7269\u533a\u7ecf\u8425\u7740\u4fbf\u5229\u5e97\u201c\u968f\u65f6\u7cae\u4ed3\u201d\u3002\u5979\u867d\u7136\u5584\u826f\u53c8\u70ed\u5fc3\uff0c\u4f46\u5374\u6709\u4e2a\u602a\u7656\uff1a\u4f1a\u5077\u5077\u8ddf\u8e2a\u6700\u559c\u6b22\u7684\u987e\u5ba2\u2026\u2026", 32, Month.DECEMBER, 30, 20, Gender.F_V_B_FEMALE, Subspecies.getSubspeciesFromId("innoxia_raptor_subspecies_owl"), RaceStage.GREATER, new CharacterInventory(false, 10), WorldType.getWorldTypeFromId("innoxia_fields_elis_shops"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_shops_convenience"), true, new NPCGenerationFlag[0]);
        this.setGenericName("\u767d\u7fbd\u9e2e\u5973");
        if (!isImported) {
            this.dailyUpdate();
            this.setPlayerKnowsName(false);
        }
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        Ceridwen.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
    }

    @Override
    public void setupPerks(boolean autoSelectPerks) {
        PerkManager.initialisePerks((GameCharacter)this, Util.newArrayListOfValues(new AbstractPerk[0]), Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)));
    }

    @Override
    public void setStartingBody(boolean setPersona) {
        if (setPersona) {
            this.setPersonalityTraits(PersonalityTrait.CONFIDENT, PersonalityTrait.KIND, PersonalityTrait.BRAVE);
            this.setSexualOrientation(SexualOrientation.AMBIPHILIC);
            this.setHistory(Occupation.NPC_STORE_OWNER);
            this.addFetish(Fetish.FETISH_DOMINANT);
            this.setFetishDesire(Fetish.FETISH_VAGINAL_RECEIVING, FetishDesire.THREE_LIKE);
        }
        this.setHeight(180);
        this.setFemininity(80);
        this.setMuscle(Muscle.THREE_MUSCULAR.getMedianValue());
        this.setBodySize(BodySize.TWO_AVERAGE.getMedianValue());
        this.setEyeCovering(new Covering(BodyCoveringType.getBodyCoveringTypeFromId("innoxia_raptor_eye"), PresetColour.EYE_YELLOW));
        this.setSkinCovering(new Covering(BodyCoveringType.getBodyCoveringTypeFromId("innoxia_raptor_feathers"), CoveringPattern.NONE, CoveringModifier.SMOOTH, PresetColour.COVERING_WHITE, false, PresetColour.COVERING_WHITE, false), true);
        this.setSkinCovering(new Covering(BodyCoveringType.HUMAN, PresetColour.SKIN_PALE), true);
        this.setHairCovering(new Covering(BodyCoveringType.getBodyCoveringTypeFromId("innoxia_raptor_hair"), PresetColour.COVERING_WHITE), true);
        this.setHairLength(HairLength.ZERO_BALD.getMinimumValue());
        this.setHairStyle(HairStyle.NONE);
        this.setHairCovering(new Covering(BodyCoveringType.getBodyCoveringTypeFromId("innoxia_raptor_body_hair"), PresetColour.COVERING_WHITE), false);
        this.setUnderarmHair(BodyHair.FOUR_NATURAL);
        this.setAssHair(BodyHair.FOUR_NATURAL);
        this.setPubicHair(BodyHair.FOUR_NATURAL);
        this.setFacialHair(BodyHair.ZERO_NONE);
        this.setFaceVirgin(false);
        this.setLipSize(LipSize.TWO_FULL);
        this.setFaceCapacity(Capacity.TWO_TIGHT, true);
        this.setTongueLength(TongueLength.ZERO_NORMAL.getMedianValue());
        this.setAssVirgin(false);
        this.setAssBleached(false);
        this.setAssSize(AssSize.THREE_NORMAL);
        this.setHipSize(HipSize.FOUR_WOMANLY);
        this.setVaginaVirgin(false);
        this.setVaginaClitorisSize(ClitorisSize.ZERO_AVERAGE);
        this.setVaginaLabiaSize(LabiaSize.TWO_AVERAGE);
        this.setVaginaSquirter(false);
        this.setVaginaCapacity(Capacity.THREE_SLIGHTLY_LOOSE, true);
        this.setVaginaWetness(Wetness.THREE_WET);
        this.setVaginaElasticity(OrificeElasticity.THREE_FLEXIBLE.getValue());
        this.setVaginaPlasticity(OrificePlasticity.FOUR_ACCOMMODATING.getValue());
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        this.unequipAllClothingIntoVoid(true, true);
        this.setMoney(5000L);
        this.equipClothingFromNowhere(Main.game.getItemGen().generateClothing("innoxia_torso_feminine_short_sleeve_shirt", PresetColour.CLOTHING_BLUE_GREY, PresetColour.CLOTHING_GREY, PresetColour.CLOTHING_WHITE, false), true, this);
        this.equipClothingFromNowhere(Main.game.getItemGen().generateClothing("innoxia_chest_plunge_bra", PresetColour.CLOTHING_BLACK, false), true, this);
        this.equipClothingFromNowhere(Main.game.getItemGen().generateClothing("innoxia_leg_mini_skirt", PresetColour.CLOTHING_GREY_DARK, false), true, this);
        this.equipClothingFromNowhere(Main.game.getItemGen().generateClothing("innoxia_groin_thong", PresetColour.CLOTHING_BLACK, false), true, this);
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getSpeechColour() {
        return PresetColour.BASE_PINK_SALMON.toWebHexString();
    }

    @Override
    public void dailyUpdate() {
        this.clearNonEquippedInventory(false);
        this.addItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), 25, false, false);
        this.addItem(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER), 10, false, false);
        for (AbstractItemType item : ItemType.getAllItems()) {
            if (!item.getItemTags().contains((Object)ItemTag.SOLD_BY_RALPH) || item.getItemTags().contains((Object)ItemTag.SILLY_MODE) && !Main.game.isSillyMode()) continue;
            this.addItem(Main.game.getItemGen().generateItem(item), !item.isConsumedOnUse() ? 1 : 6 + Util.random.nextInt(12), false, false);
        }
        for (AbstractWeaponType weapon : WeaponType.getAllWeapons()) {
            if (!weapon.getItemTags().contains((Object)ItemTag.SOLD_BY_RALPH) || weapon.getItemTags().contains((Object)ItemTag.SILLY_MODE) && !Main.game.isSillyMode()) continue;
            this.addWeapon(Main.game.getItemGen().generateWeapon(weapon), 1 + Util.random.nextInt(5), false, false);
        }
        for (AbstractClothingType clothing : ClothingType.getAllClothing()) {
            if (!clothing.getDefaultItemTags().contains((Object)ItemTag.SOLD_BY_RALPH) || clothing.getDefaultItemTags().contains((Object)ItemTag.SILLY_MODE) && !Main.game.isSillyMode()) continue;
            if (clothing.isDefaultSlotCondom()) {
                Colour condomColour = clothing.getColourReplacement(0).getRandomOfDefaultColours();
                Colour condomColourSec = PresetColour.CLOTHING_BLACK;
                Colour condomColourTer = PresetColour.CLOTHING_BLACK;
                if (clothing.getColourReplacement(1) != null) {
                    condomColourSec = clothing.getColourReplacement(1).getRandomOfDefaultColours();
                }
                if (clothing.getColourReplacement(2) != null) {
                    condomColourTer = clothing.getColourReplacement(2).getRandomOfDefaultColours();
                }
                for (int i = 0; i < (3 + Util.random.nextInt(4)) * (clothing.getRarity() == Rarity.COMMON ? 3 : (clothing.getRarity() == Rarity.UNCOMMON ? 2 : 1)); ++i) {
                    this.addClothing(Main.game.getItemGen().generateClothing(clothing, condomColour, condomColourSec, condomColourTer, false), false);
                }
                continue;
            }
            this.addClothing(Main.game.getItemGen().generateClothing(clothing, false), false);
        }
    }

    @Override
    public void turnUpdate() {
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }

    @Override
    public String getTraderDescription() {
        return UtilText.parseFromXMLFile("places/fields/elis/shops/convenience", "TRANSACTION_START");
    }

    @Override
    public void applyItemTransactionEffects(AbstractCoreItem itemSold, int quantity, int individualPrice, boolean soldToPlayer) {
        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.removeTraderDescription, true);
        UtilText.addSpecialParsingString(itemSold.getName(), true);
        UtilText.addSpecialParsingString(Util.intToString(quantity * individualPrice), false);
        if (soldToPlayer) {
            Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("places/fields/elis/shops/convenience", "BUY_TRANSACTION_COMPLETE"));
        } else {
            Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("places/fields/elis/shops/convenience", "SELL_TRANSACTION_COMPLETE"));
        }
    }

    @Override
    public boolean isTrader() {
        return true;
    }

    @Override
    public boolean willBuy(AbstractCoreItem item) {
        if (item.getItemTags().contains((Object)ItemTag.CONTRABAND_LIGHT) || item.getItemTags().contains((Object)ItemTag.CONTRABAND_MEDIUM) || item.getItemTags().contains((Object)ItemTag.CONTRABAND_HEAVY)) {
            return false;
        }
        if (item instanceof AbstractItem) {
            return true;
        }
        if (item instanceof AbstractClothing) {
            AbstractClothingType type = ((AbstractClothing)item).getClothingType();
            return type.isDefaultSlotCondom();
        }
        return false;
    }

    @Override
    public void endSex() {
    }
}

