/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.fields;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.companions.SlaveDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FieldsBandit
extends NPC {
    public FieldsBandit() {
        this(Gender.getGenderFromUserPreferences(false, false), false, new NPCGenerationFlag[0]);
    }

    public FieldsBandit(Gender gender) {
        this(gender, false, new NPCGenerationFlag[0]);
    }

    public FieldsBandit(boolean isImported) {
        this(Gender.getGenderFromUserPreferences(false, false), isImported, new NPCGenerationFlag[0]);
    }

    public FieldsBandit(Gender gender, boolean isImported, NPCGenerationFlag ... generationFlags) {
        super(isImported, null, null, "", Util.random.nextInt(28) + 18, Util.randomItemFrom(Month.values()), 1 + Util.random.nextInt(25), 5, null, null, null, new CharacterInventory(false, 10), WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, false, generationFlags);
        if (!isImported) {
            this.setLevel(10 + Util.random.nextInt(11));
            HashMap<AbstractSubspecies, Integer> availableRaces = new HashMap<AbstractSubspecies, Integer>();
            AbstractPlaceType placeType = Main.game.getPlayer().getLocationPlace().getPlaceType();
            for (AbstractSubspecies s : Subspecies.getAllSubspecies()) {
                if (s.getSubspeciesOverridePriority() > 0 || !Subspecies.getWorldSpecies(WorldType.WORLD_MAP, placeType, false, new AbstractSubspecies[0]).containsKey(s)) continue;
                AbstractSubspecies.addToSubspeciesMap((int)(10000.0f * Subspecies.getWorldSpecies(WorldType.WORLD_MAP, placeType, false, new AbstractSubspecies[0]).get(s).getChanceMultiplier()), gender, s, availableRaces);
            }
            this.setBodyFromSubspeciesPreference(gender, availableRaces, true, true);
            if (Math.random() < (double)((float)Main.getProperties().halfDemonSpawnRate / 100.0f) && this.getSubspecies() != Subspecies.SLIME) {
                this.setBody(Main.game.getCharacterUtils().generateHalfDemonBody(this, gender, this.getBody().getFleshSubspecies(), true), true);
            }
            if (Math.random() < (double)((float)Main.getProperties().taurSpawnRate / 100.0f) && this.getLegConfiguration() != LegConfiguration.QUADRUPEDAL) {
                if (this.getSubspecies() == Subspecies.HALF_DEMON && this.getLegType().isLegConfigurationAvailable(LegConfiguration.QUADRUPEDAL)) {
                    Main.game.getCharacterUtils().applyTaurConversion(this);
                } else if (this.getRace().getRacialBody().getLegType().isLegConfigurationAvailable(LegConfiguration.QUADRUPEDAL)) {
                    this.setLegType(this.getRace().getRacialBody().getLegType());
                    Main.game.getCharacterUtils().applyTaurConversion(this);
                }
            }
            this.setSexualOrientation(RacialBody.valueOfRace(this.getRace()).getSexualOrientation(gender));
            this.setName(Name.getRandomTriplet(this.getSubspecies()));
            this.setPlayerKnowsName(false);
            Main.game.getCharacterUtils().setHistoryAndPersonality(this, true);
            this.setHistory(Occupation.NPC_MUGGER);
            this.setSexualOrientation(RacialBody.valueOfRace(this.getRace()).getSexualOrientation(gender));
            Main.game.getCharacterUtils().addFetishes(this, new AbstractFetish[0]);
            Main.game.getCharacterUtils().randomiseBody(this, true);
            this.resetInventory(true);
            this.inventory.setMoney(10 + Util.random.nextInt(this.getLevel() * 10) + 1);
            Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
            if (!Arrays.asList(generationFlags).contains((Object)NPCGenerationFlag.NO_CLOTHING_EQUIP)) {
                this.equipClothing(EquipClothingSetting.getAllClothingSettings());
            }
            Main.game.getCharacterUtils().applyMakeup(this, true);
            Main.game.getCharacterUtils().applyTattoos(this, true);
            this.initPerkTreeAndBackgroundPerks();
            this.setStartingCombatMoves();
            this.loadImages();
            this.initHealthAndManaToMax();
        }
        this.setEnslavementDialogue(SlaveDialogue.DEFAULT_ENSLAVEMENT_DIALOGUE, true);
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        FieldsBandit.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        this.incrementMoney((long)((float)this.getInventory().getNonEquippedValue() * 2.5f));
        this.clearNonEquippedInventory(false);
        Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
        String outfitId = "innoxia_genericMugger_dominion_masculine";
        if (this.isFeminine()) {
            outfitId = "innoxia_genericMugger_dominion_feminine";
        }
        Main.game.getCharacterUtils().equipClothingFromOutfitId(this, outfitId, settings);
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getDescription() {
        if (this.isSlave() && this.isDoll()) {
            return super.getDescription();
        }
        if (this.isSlave()) {
            return UtilText.parse((GameCharacter)this, "[npc.NamePos]\u5728\u5f17\u6d1b\u4f0a\u7530\u91ce\u6e38\u8361\u88ad\u51fb\u65e0\u8f9c\u8def\u4eba\u7684\u65e5\u5b50\u5df2\u7ecf\u7ed3\u675f\u3002[npc.sheIs]\u56e0\u89e6\u72af\u6cd5\u5f8b\u6210\u4e3a\u4e86\u5974\u96b6\uff0c\u4e0d\u8fc7\u662f[npc.her]\u4e3b\u4eba\u7684\u8d22\u4ea7\u800c\u5df2\u3002", new ParserTag[0]);
        }
        if (Main.game.getPlayer() != null && Main.game.getPlayer().getFriendlyOccupants().contains(this.getId())) {
            return UtilText.parse((GameCharacter)this, "\u4f60\u7b2c\u4e00\u6b21\u9047\u89c1[npc.name]\u65f6\uff0c[npc.she]\u662f\u5f17\u6d1b\u4f0a\u539f\u91ce\u4e0a\u6f2b\u6e38\u7684\u52ab\u532a\uff0c\u56db\u5904\u5bfb\u627e\u65c5\u8005\u5145\u5f53\u730e\u7269\u3002\u5728\u505a\u4e86\u4e00\u6bb5\u65f6\u95f4\u4f60\u7684\u5974\u96b6\u4e4b\u540e\uff0c[npc.sheIs]\u73b0\u5728\u662f\u4f60\u53ef\u4fe1\u7684\u670b\u53cb\u3002", new ParserTag[0]);
        }
        return UtilText.parse((GameCharacter)this, "[npc.Name]\u662f\u5f17\u6d1b\u4f0a\u539f\u91ce\u4e0a\u6f2b\u6e38\u7684\u52ab\u532a\uff0c\u56db\u5904\u5bfb\u627e\u65c5\u8005\u5145\u5f53\u730e\u7269\u3002", new ParserTag[0]);
    }

    @Override
    public boolean isClothingStealable() {
        return true;
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }

    @Override
    public void applyEscapeCombatEffects() {
        Main.game.banishNPC(this);
    }

    @Override
    public Response endCombat(boolean applyEffects, boolean victory) {
        return null;
    }

    public long getPaymentDemand() {
        return Math.max(2500L, Math.min(Main.game.getPlayer().getMoney() / 10L, 10000L)) / 500L * 500L;
    }
}

