/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.misc;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.NameTriplet;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.persona.SexualOrientation;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicSlave
extends NPC {
    public BasicSlave() {
        this(Gender.getGenderFromUserPreferences(false, false), false);
    }

    public BasicSlave(Gender gender) {
        this(gender, false);
    }

    public BasicSlave(boolean isImported) {
        this(Gender.F_V_B_FEMALE, isImported);
    }

    public BasicSlave(Gender gender, boolean isImported) {
        super(isImported, new NameTriplet("\u5974\u96b6"), "", "", 21, Util.randomItemFrom(Month.values()), 1 + Util.random.nextInt(27), 3, null, null, null, new CharacterInventory(false, 0), WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, false, new NPCGenerationFlag[0]);
        if (!isImported) {
            this.setBody(gender, Subspecies.HUMAN, RaceStage.HUMAN, false);
            this.setSexualOrientation(SexualOrientation.AMBIPHILIC);
            this.setPlayerKnowsName(true);
            this.setSurname("");
            this.setAttribute(Attribute.MAJOR_CORRUPTION, 0.0f);
            this.setHistory(Occupation.NPC_SLAVE);
            this.clearFetishDesires();
            this.clearFetishes();
            this.clearPersonalityTraits();
            this.clearTattoosAndScars();
            this.setObedience(100.0f);
            this.setAffection(Main.game.getPlayer(), 100.0f);
            this.setStartingBody(true);
            this.resetInventory(true);
            this.inventory.setMoney(0L);
            this.equipClothing(EquipClothingSetting.getAllClothingSettings());
            this.initHealthAndManaToMax();
        }
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        BasicSlave.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
    }

    @Override
    public void setStartingBody(boolean setPersona) {
        if (this.body != null) {
            this.setAssVirgin(true);
            this.setFaceVirgin(true);
            this.setNippleCrotchVirgin(true);
            this.setNippleVirgin(true);
            this.setPenisVirgin(true);
            this.setUrethraVirgin(true);
            this.setVaginaVirgin(true);
            this.setVaginaUrethraVirgin(true);
        }
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        this.equipClothingFromNowhere(Main.game.getItemGen().generateClothing("innoxia_bdsm_metal_collar", PresetColour.CLOTHING_STEEL, false), true, this);
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getDescription() {
        if (this.isSlave() && this.isDoll()) {
            return super.getDescription();
        }
        if (this.isSlave()) {
            return UtilText.parse((GameCharacter)this, "\u7531\u4e8e\u89e6\u72af\u4e86\u6cd5\u5f8b\uff0c[npc.she]\u73b0\u5728\u662f\u4e00\u540d\u5974\u96b6\uff0c\u53ea\u4e0d\u8fc7\u662f\u5176\u4e3b\u4eba\u7684\u8d22\u4ea7\u3002", new ParserTag[0]);
        }
        return UtilText.parse((GameCharacter)this, "[npc.nameIsFull]\u66fe\u6709\u4e00\u6bb5\u65f6\u95f4\u662f\u4f60\u7684\u5974\u96b6\uff0c\u4f46\u73b0\u5728\u662f\u4f60\u5f88\u4fe1\u4efb\u7684\u670b\u53cb\u4e86\u3002", new ParserTag[0]);
    }

    @Override
    public boolean isClothingStealable() {
        return true;
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }
}

