/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.misc;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.NameTriplet;
import com.lilithsthrone.game.character.persona.PersonalityTrait;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.dominion.nightlife.NightlifeDistrict;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClubberImport
extends NPC {
    public ClubberImport() {
        this(false);
    }

    public ClubberImport(boolean isImported) {
        super(isImported, new NameTriplet("\u591c\u603b\u4f1a\u4f1a\u5458"), "", "-", 18, Month.JUNE, 10, 1, Gender.F_V_B_FEMALE, Subspecies.HUMAN, RaceStage.HUMAN, new CharacterInventory(false, 0), WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, false, new NPCGenerationFlag[0]);
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        ClubberImport.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
        this.setLastTimeEncountered(-1L);
        if (!this.getId().endsWith("ClubberImport")) {
            this.setId(Main.game.getNextNPCId(ClubberImport.class));
        }
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
    }

    public void applyNewlyImportedClubberVariables() {
        this.endPregnancy(false);
        this.washAllOrifices(true);
        this.calculateStatusEffects(0);
        this.cleanAllDirtySlots(true);
        this.cleanAllClothing(true, false);
        this.clearAffectionMap();
        this.getSlavesOwned().clear();
        this.setPlayerKnowsName(true);
        if (NightlifeDistrict.isSearchingForASub()) {
            this.removePersonalityTrait(PersonalityTrait.CONFIDENT);
        } else {
            this.addPersonalityTrait(PersonalityTrait.CONFIDENT);
        }
        this.setLocation(WorldType.EMPTY, PlaceType.GENERIC_CLUB_HOLDING_CELL, true);
    }

    @Override
    public String getDescription() {
        if (this.isSlave() && this.isDoll()) {
            return super.getDescription();
        }
        return UtilText.parse((GameCharacter)this, "[npc.Name]\u662f\u5fa1\u57ce\u533a\u7684\u5c45\u6c11,\uff0c\u4f60\u4eec\u66fe\u7ecf\u5728\u591c\u751f\u6d3b\u533a\u7684\u4e00\u5bb6\u591c\u603b\u4f1a\u9047\u89c1\u8fc7\u3002", new ParserTag[0]);
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }
}

