/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.misc;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.Game;
import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.types.HornType;
import com.lilithsthrone.game.character.body.types.LegType;
import com.lilithsthrone.game.character.body.types.TailType;
import com.lilithsthrone.game.character.body.types.WingType;
import com.lilithsthrone.game.character.body.valueEnums.AreolaeSize;
import com.lilithsthrone.game.character.body.valueEnums.AssSize;
import com.lilithsthrone.game.character.body.valueEnums.BodyMaterial;
import com.lilithsthrone.game.character.body.valueEnums.BodySize;
import com.lilithsthrone.game.character.body.valueEnums.BreastShape;
import com.lilithsthrone.game.character.body.valueEnums.Capacity;
import com.lilithsthrone.game.character.body.valueEnums.ClitorisSize;
import com.lilithsthrone.game.character.body.valueEnums.CupSize;
import com.lilithsthrone.game.character.body.valueEnums.HipSize;
import com.lilithsthrone.game.character.body.valueEnums.LabiaSize;
import com.lilithsthrone.game.character.body.valueEnums.LipSize;
import com.lilithsthrone.game.character.body.valueEnums.Muscle;
import com.lilithsthrone.game.character.body.valueEnums.NippleSize;
import com.lilithsthrone.game.character.body.valueEnums.OrificeElasticity;
import com.lilithsthrone.game.character.body.valueEnums.OrificePlasticity;
import com.lilithsthrone.game.character.body.valueEnums.TongueLength;
import com.lilithsthrone.game.character.body.valueEnums.Wetness;
import com.lilithsthrone.game.character.body.valueEnums.WingSize;
import com.lilithsthrone.game.character.effects.AbstractPerk;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCFlagValue;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.persona.PersonalityCategory;
import com.lilithsthrone.game.character.persona.SexualOrientation;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.combat.spells.SpellSchool;
import com.lilithsthrone.game.combat.spells.SpellUpgrade;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Elemental
extends NPC {
    private String summonerID;
    private AbstractSubspecies passiveForm;

    public Elemental(boolean isImported) {
        this(Gender.F_V_B_FEMALE, null, isImported);
    }

    public Elemental(Gender gender, GameCharacter summoner, boolean isImported) {
        super(isImported, null, null, "", summoner == null ? 18 : summoner.getAgeValue(), summoner == null ? Month.JANUARY : summoner.getBirthMonth(), summoner == null ? 1 : summoner.getDayOfBirth(), 20, gender, Subspecies.DEMON, RaceStage.GREATER, new CharacterInventory(false, 10), WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, false, new NPCGenerationFlag[0]);
        if (!isImported) {
            this.setLevel(summoner == null ? 1 : summoner.getLevel());
            this.setSummoner(summoner);
            this.setSurname((String)(summoner == null ? "" : this.getSummoner().getNameIgnoresPlayerKnowledge() + "\u5361\u59c6"));
            this.setStartingBody(true);
            this.setPassiveForm(null);
            if (summoner != null) {
                this.setAffection(this.getSummoner(), 100.0f);
            }
            this.setLegType(LegType.DEMON_COMMON);
            this.setHistory(Occupation.ELEMENTAL);
            this.setCombatBehaviour(this.getRace().getPreferredCombatBehaviour());
            this.setSexualOrientation(SexualOrientation.AMBIPHILIC);
            this.setName(Name.getRandomTriplet(Subspecies.DEMON));
            this.setPlayerKnowsName(true);
            this.resetInventory(true);
            this.addFetish(Fetish.FETISH_EXHIBITIONIST);
            this.setAttribute(Attribute.MAJOR_PHYSIQUE, 0.0f);
            this.setAttribute(Attribute.MAJOR_ARCANE, 0.0f);
            this.setAttribute(Attribute.MAJOR_CORRUPTION, 0.0f);
            this.setElementalSchool(SpellSchool.ARCANE);
            this.removePersonalityTraits(PersonalityCategory.SPEECH);
            this.initHealthAndManaToMax();
        }
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element properties = super.saveAsXML(parentElement, doc);
        Element npcSpecific = doc.createElement("elementalSpecial");
        properties.appendChild(npcSpecific);
        XMLUtil.createXMLElementWithValue(doc, npcSpecific, "summoner", this.getSummoner().getId());
        if (this.passiveForm != null) {
            XMLUtil.createXMLElementWithValue(doc, npcSpecific, "passiveForm", Subspecies.getIdFromSubspecies(this.passiveForm));
        }
        return properties;
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        Elemental.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
        Element npcSpecificElement = (Element)parentElement.getElementsByTagName("elementalSpecial").item(0);
        this.setSummoner(((Element)npcSpecificElement.getElementsByTagName("summoner").item(0)).getAttribute("value"));
        if (npcSpecificElement.getElementsByTagName("passiveForm").item(0) != null) {
            this.setPassiveForm(Subspecies.getSubspeciesFromId(((Element)npcSpecificElement.getElementsByTagName("passiveForm").item(0)).getAttribute("value")));
        }
        if (Main.isVersionOlderThan(Game.loadingVersion, "0.2.11.6")) {
            this.setAttribute(Attribute.MAJOR_PHYSIQUE, 0.0f);
            this.setAttribute(Attribute.MAJOR_ARCANE, 0.0f);
            this.setAttribute(Attribute.MAJOR_CORRUPTION, 0.0f);
        }
        if (Main.isVersionOlderThan(Game.loadingVersion, "0.2.12")) {
            this.setElementalSchool(this.getCurrentSchool());
        }
        if (Main.isVersionOlderThan(Game.loadingVersion, "0.3.8.6")) {
            this.resetPerksMap(false);
            this.setHistory(Occupation.ELEMENTAL);
        }
        if (Main.isVersionOlderThan(Game.loadingVersion, "0.3.9.3")) {
            this.setAffection(this.getSummoner(), 100.0f);
        }
    }

    @Override
    public void setStartingBody(boolean setPersona) {
        GameCharacter summoner = this.getSummoner();
        if (summoner == null) {
            return;
        }
        this.setAgeAppearanceAbsolute(summoner.getAppearsAsAgeValue());
        this.setTailType(TailType.DEMON_COMMON);
        this.setWingType(WingType.DEMON_COMMON);
        this.setWingSize(WingSize.THREE_LARGE.getValue());
        this.setLegType(LegType.DEMON_COMMON);
        if (summoner.getHornType().equals(HornType.NONE) || summoner.getHornType().getRace() == Race.DEMON) {
            this.setHornType(summoner.getHornType());
        } else if (this.isFeminine()) {
            this.setHornType(HornType.SWEPT_BACK);
        } else {
            this.setHornType(HornType.STRAIGHT);
        }
        this.setHeight(summoner.getHeightValue());
        this.setFemininity(75);
        this.setMuscle(Muscle.TWO_TONED.getMedianValue());
        this.setBodySize(BodySize.ZERO_SKINNY.getMedianValue());
        this.setFaceVirgin(true);
        this.setLipSize(LipSize.TWO_FULL);
        this.setFaceCapacity(Capacity.ONE_EXTREMELY_TIGHT, true);
        this.setTongueLength(TongueLength.ZERO_NORMAL.getMedianValue());
        this.setNippleVirgin(true);
        if (summoner.hasBreasts()) {
            this.setBreastSize(summoner.getBreastSize());
            this.setBreastShape(summoner.getBreastShape());
            this.setNippleSize(summoner.getNippleSize());
            this.setAreolaeSize(summoner.getAreolaeSize());
        } else {
            this.setBreastSize(CupSize.F.getMeasurement());
            this.setBreastShape(BreastShape.ROUND);
            this.setNippleSize(NippleSize.THREE_LARGE);
            this.setAreolaeSize(AreolaeSize.THREE_LARGE);
        }
        this.setAssVirgin(true);
        this.setAssBleached(false);
        this.setAssSize(AssSize.FOUR_LARGE);
        this.setHipSize(HipSize.FOUR_WOMANLY);
        this.setVaginaVirgin(true);
        this.setVaginaClitorisSize(ClitorisSize.ZERO_AVERAGE);
        this.setVaginaLabiaSize(LabiaSize.ZERO_TINY);
        this.setVaginaSquirter(true);
        this.setVaginaCapacity(Capacity.ONE_EXTREMELY_TIGHT, true);
        this.setVaginaWetness(Wetness.THREE_WET);
        this.setVaginaElasticity(OrificeElasticity.TWO_FIRM.getValue());
        this.setVaginaPlasticity(OrificePlasticity.SIX_MALLEABLE.getValue());
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isElemental() {
        return true;
    }

    @Override
    public String getDescription() {
        return UtilText.parse((GameCharacter)this, this.getSummoner(), "", new ParserTag[0]);
    }

    @Override
    public int getTrueLevel() {
        if (this.getSummoner() == null) {
            return this.level;
        }
        return this.getSummoner().getLevel();
    }

    @Override
    public int getLevel() {
        return this.getTrueLevel();
    }

    @Override
    public void turnUpdate() {
        if (!this.isActive()) {
            this.returnToHome();
        }
        if (!this.hasFlag(NPCFlagValue.elementalStayDirty)) {
            this.cleanAllDirtySlots(true);
            this.cleanAllClothing(true, false);
        }
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }

    @Override
    public String incrementExperience(int increment, boolean withExtraModifiers) {
        return "";
    }

    @Override
    public boolean addPerk(int row, AbstractPerk perk) {
        this.perks.putIfAbsent(row, new HashSet());
        if (((Set)this.perks.get(row)).contains(perk)) {
            return false;
        }
        ((Set)this.perks.get(row)).add(perk);
        if (!perk.isEquippableTrait()) {
            this.applyPerkGainEffects(perk);
        }
        this.calculateSpells(this.getCurrentSchool());
        return true;
    }

    @Override
    public AbstractSubspecies getSubspeciesOverride() {
        return this.getSubspecies();
    }

    @Override
    public AbstractRace getSubspeciesOverrideRace() {
        return Race.ELEMENTAL;
    }

    private void calculateSpells(SpellSchool school) {
        this.resetSpells();
        for (Set<AbstractPerk> perkSet : this.getPerksMap().values()) {
            for (AbstractPerk p : perkSet) {
                if (p.getSchool() != school) continue;
                if (p.getSpellUpgrade() != null) {
                    this.addSpellUpgrade(p.getSpellUpgrade());
                    continue;
                }
                this.addSpell(p.getSpell());
            }
        }
    }

    public SpellSchool getCurrentSchool() {
        switch (this.getBodyMaterial()) {
            case AIR: {
                return SpellSchool.AIR;
            }
            case ARCANE: {
                return SpellSchool.ARCANE;
            }
            case FIRE: {
                return SpellSchool.FIRE;
            }
            case FLESH: 
            case SLIME: 
            case SILICONE: {
                break;
            }
            case RUBBER: 
            case STONE: {
                return SpellSchool.EARTH;
            }
            case ICE: 
            case WATER: {
                return SpellSchool.WATER;
            }
        }
        return SpellSchool.ARCANE;
    }

    public void setElementalSchool(SpellSchool school) {
        this.setElementalSchool(school, null);
    }

    public void setElementalSchool(SpellSchool school, BodyMaterial preferredMaterial) {
        switch (school) {
            case AIR: {
                this.setBodyMaterial(BodyMaterial.AIR);
                break;
            }
            case ARCANE: {
                this.setBodyMaterial(BodyMaterial.ARCANE);
                break;
            }
            case EARTH: {
                if (preferredMaterial == BodyMaterial.RUBBER) {
                    this.setBodyMaterial(BodyMaterial.RUBBER);
                    break;
                }
                this.setBodyMaterial(BodyMaterial.STONE);
                break;
            }
            case FIRE: {
                this.setBodyMaterial(BodyMaterial.FIRE);
                break;
            }
            case WATER: {
                if (preferredMaterial == BodyMaterial.ICE) {
                    this.setBodyMaterial(BodyMaterial.ICE);
                    break;
                }
                this.setBodyMaterial(BodyMaterial.WATER);
            }
        }
        if (this.getSummoner() != null && !this.getSummoner().isPlayer()) {
            this.initPerkTreeAndBackgroundPerks();
        }
        this.calculateSpells(school);
    }

    public GameCharacter getSummoner() {
        try {
            return Main.game.getNPCById(this.summonerID);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setSummoner(String summonerID) {
        this.summonerID = summonerID;
    }

    public void setSummoner(GameCharacter summoner) {
        if (summoner != null) {
            this.summonerID = summoner.getId();
            this.setBirthday(summoner.getBirthday());
            this.setAgeAppearanceAbsolute(summoner.getAppearsAsAgeValue());
        }
    }

    public boolean isActive() {
        if (this.getSummoner() == null) {
            return false;
        }
        return this.getSummoner().isElementalActive();
    }

    public boolean isSummonerServant() {
        if (this.getSummoner() == null) {
            return false;
        }
        switch (this.getCurrentSchool()) {
            case AIR: {
                return this.getSummoner().hasSpellUpgrade(SpellUpgrade.ELEMENTAL_AIR_3A);
            }
            case ARCANE: {
                return this.getSummoner().hasSpellUpgrade(SpellUpgrade.ELEMENTAL_ARCANE_3A);
            }
            case EARTH: {
                return this.getSummoner().hasSpellUpgrade(SpellUpgrade.ELEMENTAL_EARTH_3A);
            }
            case FIRE: {
                return this.getSummoner().hasSpellUpgrade(SpellUpgrade.ELEMENTAL_FIRE_3A);
            }
            case WATER: {
                return this.getSummoner().hasSpellUpgrade(SpellUpgrade.ELEMENTAL_WATER_3A);
            }
        }
        return false;
    }

    public boolean isServant() {
        if (this.getSummoner() == null) {
            return false;
        }
        switch (this.getCurrentSchool()) {
            case AIR: {
                return this.getSummoner().hasSpellUpgrade(SpellUpgrade.ELEMENTAL_AIR_3B);
            }
            case ARCANE: {
                return this.getSummoner().hasSpellUpgrade(SpellUpgrade.ELEMENTAL_ARCANE_3B);
            }
            case EARTH: {
                return this.getSummoner().hasSpellUpgrade(SpellUpgrade.ELEMENTAL_EARTH_3B);
            }
            case FIRE: {
                return this.getSummoner().hasSpellUpgrade(SpellUpgrade.ELEMENTAL_FIRE_3B);
            }
            case WATER: {
                return this.getSummoner().hasSpellUpgrade(SpellUpgrade.ELEMENTAL_WATER_3B);
            }
        }
        return false;
    }

    public AbstractSubspecies getPassiveForm() {
        return this.passiveForm;
    }

    public void setPassiveForm(AbstractSubspecies passiveForm) {
        this.passiveForm = passiveForm;
    }
}

