/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.misc;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AffectionLevel;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.npc.misc.OffspringSeed;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.persona.Relationship;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.companions.SlaveDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.offspring.GenericOffspringDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.outfit.OutfitType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NPCOffspring
extends NPC {
    public NPCOffspring() {
        this(false);
    }

    public NPCOffspring(boolean isImported) {
        super(isImported, null, null, "", 18, Month.JUNE, 15, 3, Gender.F_V_B_FEMALE, Subspecies.DOG_MORPH, RaceStage.GREATER, new CharacterInventory(false, 10), WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, true, new NPCGenerationFlag[0]);
    }

    public NPCOffspring(OffspringSeed os) {
        super(false, os.nameTriplet, os.surname, os.description, 0, os.getBirthday().getMonth(), os.getBirthday().getDayOfMonth(), 1, os.body.getGender(), os.subspecies, os.body.getRaceStage(), new CharacterInventory(false, 10), WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, true, new NPCGenerationFlag[0]);
        this.birthday = LocalDateTime.of(os.getBirthday().getYear(), this.getBirthday().getMonth(), this.getBirthday().getDayOfMonth(), this.getBirthday().getHour(), this.getBirthday().getMinute());
        this.conceptionDate = os.conceptionDate;
        this.motherName = os.getMotherName();
        this.motherFemininity = os.getMotherFemininity();
        this.motherSubspecies = os.getMotherSubspecies();
        this.fatherName = os.getFatherName();
        this.fatherFemininity = os.getFatherFemininity();
        this.fatherSubspecies = os.getFatherSubspecies();
        this.incubatorName = os.getIncubatorName();
        this.incubatorFemininity = os.getIncubatorFemininity();
        this.incubatorSubspecies = os.getIncubatorSubspecies();
        this.body = os.getBody();
        this.body.calculateRace(this);
        this.setLevel(Util.random.nextInt(3) + 1);
        this.setSexualOrientation(RacialBody.valueOfRace(this.getRace()).getSexualOrientation(this.getGender()));
        if (os.getMother() != null) {
            this.setMother(os.getMother());
            this.setAffection(os.getMother(), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
        }
        if (os.getFather() != null) {
            this.setFather(os.getFather());
            this.setAffection(os.getFather(), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
        }
        if (os.getIncubator() != null) {
            this.setIncubator(os.getIncubatorId());
            this.setAffection(os.getIncubator(), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
        }
        Main.game.getCharacterUtils().setHistoryAndPersonality(this, true);
        this.setName(os.nameTriplet);
        Main.game.getCharacterUtils().addFetishes(this, new AbstractFetish[0]);
        Main.game.getCharacterUtils().randomiseBody(this, false);
        this.resetInventory(true);
        this.inventory.setMoney(10 + Util.random.nextInt(this.getLevel() * 10) + 1);
        Main.game.getCharacterUtils().applyMakeup(this, true);
        Main.game.getCharacterUtils().applyTattoos(this, true);
        this.initHealthAndManaToMax();
        this.setEnslavementDialogue(SlaveDialogue.DEFAULT_ENSLAVEMENT_DIALOGUE, true);
        String npcId = Main.game.safeAddNPC(this, false);
        if (os.getMother() != null) {
            os.getMother().swapLitters(os.getId(), npcId);
        }
        if (os.getFather() != null) {
            os.getFather().swapLitters(os.getId(), npcId);
        }
        if (os.getIncubator() != null) {
            os.getIncubator().swapLitters(os.getId(), npcId);
        }
        Main.game.getOffspring().add(this);
        Main.game.removeOffspringSeed(os);
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        NPCOffspring.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
        if (this.getConceptionDate().isAfter(this.getBirthday())) {
            this.setBirthday(this.getConceptionDate().plusMonths(2L));
        } else if (Math.abs((int)ChronoUnit.DAYS.between(this.getConceptionDate(), this.getBirthday())) > 300) {
            this.setConceptionDate(this.getBirthday().minusMonths(2L));
        }
        this.setEnslavementDialogue(SlaveDialogue.DEFAULT_ENSLAVEMENT_DIALOGUE, true);
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        this.incrementMoney((long)((float)this.getInventory().getNonEquippedValue() * 0.5f));
        this.clearNonEquippedInventory(false);
        Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
        if (this.getHistory() == Occupation.NPC_PROSTITUTE) {
            Main.game.getCharacterUtils().equipClothingFromOutfitType(this, OutfitType.PROSTITUTE, settings);
        } else {
            Main.game.getCharacterUtils().equipClothingFromOutfitType(this, OutfitType.MUGGER, settings);
        }
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isPlayerOnFirstNameTerms() {
        return true;
    }

    private String getRelationshipFromPlayer() {
        Set<Relationship> rel = Main.game.getPlayer().getRelationshipsTo(this, new Relationship[0]);
        if (rel.isEmpty()) {
            return "";
        }
        return UtilText.parse((GameCharacter)this, "\u4f60\u662f[npc.hisHer]\u7684", new ParserTag[0]) + NPCOffspring.getRelationshipStr(rel, Main.game.getPlayer().getGender().getType()) + "\u3002";
    }

    private static String getMatingDescription(GameCharacter self, GameCharacter partner, String what) {
        String result = what + "\u548c" + partner.getName("a");
        String rel = partner.getRelationshipStrTo(self, new Relationship[0]);
        if (!rel.isEmpty()) {
            return result + "(\u4f60\u7684" + rel + ")";
        }
        return result;
    }

    @Override
    public String getDescription() {
        int daysToBirth = (int)ChronoUnit.DAYS.between(this.getConceptionDate(), this.getBirthday());
        if (this.getMother() == null || this.getFather() == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[npc.Name]\u662f\u4f60" + (this.getMother() != null && this.getMother().isPlayer() ? NPCOffspring.getMatingDescription(this.getMother(), this.getFather(), "\u8eab\u4e3a\u6bcd\u4eb2") : NPCOffspring.getMatingDescription(this.getFather(), this.getMother(), "\u8eab\u4e3a\u7236\u4eb2")) + "\u751f\u51fa\u7684[npc.daughter]\u3002" + this.getRelationshipFromPlayer() + "[npc.She]\u4e8e" + Units.date(this.getConceptionDate(), Units.DateType.LONG) + "\u5f00\u59cb\u5b55\u80b2\uff0c" + (String)(daysToBirth == 0 ? "\u4e14\u5728\u540c\u4e00\u5929" : (daysToBirth > 1 ? Util.intToString(daysToBirth) + "\u5929\u540e" : Util.intToString(daysToBirth) + "\u5929\u540e")) + (String)(this.getMother() != null && this.getMother().isPlayer() ? (this.getIncubator() != null && !this.getIncubator().isPlayer() ? this.getIncubator().getName() : "\u4f60") + "\u4fbf\u5c06\u5176\u5206\u5a29\u800c\u51fa\u3002" : "[npc.she]\u4fbf\u964d\u751f\u4e86\u3002"));
        if (this.isSlave() && this.isDoll()) {
            sb.append("\u5728\u4f60\u5974\u5f79\u4e86[npc.herHim]\u4e4b\u540e\uff0c\u4f60\u5c06[npc.herHim]\u5728\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u6c38\u4e45\u5730\u8f6c\u5316\u6210\u4e86\u4e00\u4e2a\u552f\u547d\u662f\u4ece\u7684\u6027\u7231\u73a9\u5076\u3002");
        } else {
            sb.append("\u4f60\u4eec\u7b2c\u4e00\u6b21\u76f8\u9047\u65f6\uff0c[npc.herHim]\u6b63\u5728\u5fa1\u57ce\u533a\u7684\u5c0f\u5df7\u6e38\u8361\uff0c\u7531\u4e8e\u67d0\u79cd\u53d7\u5965\u672f\u5f71\u54cd\u7684\u5929\u6027\uff0c\u4f60\u4eec\u4e24\u4e2a\u7b2c\u4e00\u773c\u5c31\u8ba4\u51fa\u4e86\u5bf9\u65b9\u3002");
        }
        return UtilText.parse((GameCharacter)this, sb.toString(), new ParserTag[0]);
    }

    @Override
    public void endSex() {
        if (!this.isSlave()) {
            this.setPendingClothingDressing(true);
        }
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return GenericOffspringDialogue.OFFSPRING_ENCOUNTER;
    }

    @Override
    public boolean isAllowingPlayerToManageInventory() {
        return this.getAffection(Main.game.getPlayer()) >= (float)AffectionLevel.POSITIVE_FIVE_WORSHIP.getMinimumValue() || this.isSlave() && this.getOwner().isPlayer();
    }

    @Override
    public Response endCombat(boolean applyEffects, boolean victory) {
        if (victory) {
            return new Response("", "", GenericOffspringDialogue.AFTER_COMBAT_VICTORY);
        }
        return new Response("", "", GenericOffspringDialogue.AFTER_COMBAT_DEFEAT);
    }
}

