/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.misc;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.valueEnums.BodyMaterial;
import com.lilithsthrone.game.character.body.valueEnums.BodyShape;
import com.lilithsthrone.game.character.body.valueEnums.BodySize;
import com.lilithsthrone.game.character.body.valueEnums.Femininity;
import com.lilithsthrone.game.character.body.valueEnums.Height;
import com.lilithsthrone.game.character.body.valueEnums.Muscle;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.gender.GenderPronoun;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.misc.GenericAndrogynousNPC;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.persona.NameTriplet;
import com.lilithsthrone.game.character.pregnancy.Litter;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.npcDialogue.offspring.GenericOffspringDialogue;
import com.lilithsthrone.game.sex.SexAreaOrifice;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.XMLSaving;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OffspringSeed
implements XMLSaving {
    protected String id;
    protected Boolean fromPlayer;
    protected Boolean born;
    protected NameTriplet nameTriplet;
    protected String surname;
    protected String description;
    protected LocalDateTime birthday;
    protected AbstractSubspecies subspecies;
    protected Body body;
    protected String motherId;
    protected String fatherId;
    protected String incubatorId;
    protected LocalDateTime conceptionDate;
    protected String motherName = "???";
    protected Femininity motherFemininity = Femininity.FEMININE;
    protected AbstractSubspecies motherSubspecies = Subspecies.HUMAN;
    protected String fatherName = "???";
    protected Femininity fatherFemininity = Femininity.MASCULINE;
    protected AbstractSubspecies fatherSubspecies = Subspecies.HUMAN;
    protected String incubatorName = "???";
    protected Femininity incubatorFemininity = Femininity.ANDROGYNOUS;
    protected AbstractSubspecies incubatorSubspecies = Subspecies.HUMAN;

    public OffspringSeed() {
    }

    public OffspringSeed(NPC npc) {
        this.fromPlayer = npc.getMother() != null && npc.getMother().isPlayer() || npc.getFather() != null && npc.getFather().isPlayer() || npc.getIncubator() != null && npc.getIncubator().isPlayer();
        this.born = false;
        this.nameTriplet = npc.getNameTriplet();
        this.surname = npc.getSurname();
        this.description = npc.getDescription();
        this.birthday = npc.getBirthday();
        this.subspecies = npc.getSubspecies();
        this.body = npc.getBody();
        this.motherId = npc.getMotherId();
        this.fatherId = npc.getFatherId();
        this.incubatorId = npc.getIncubatorId();
        this.conceptionDate = npc.getConceptionDate();
        this.motherName = npc.getMotherName();
        this.motherFemininity = npc.getMotherFemininity();
        this.motherSubspecies = npc.getMotherSubspecies();
        this.fatherName = npc.getFatherName();
        this.fatherFemininity = npc.getFatherFemininity();
        this.fatherSubspecies = npc.getFatherSubspecies();
        this.incubatorName = npc.getIncubatorName();
        this.incubatorFemininity = npc.getIncubatorFemininity();
        this.incubatorSubspecies = npc.getIncubatorSubspecies();
        try {
            boolean carried = false;
            String osId = Main.game.addOffspringSeed(this, false);
            if (npc.getMother() != null && npc.getMother().getPregnantLitter() != null && npc.getMother().getPregnantLitter().getOffspring().contains(npc.getId())) {
                carried = true;
            } else if (npc.getIncubator() != null) {
                for (Map.Entry<SexAreaOrifice, Litter> entry : npc.getIncubator().getIncubatingLitters().entrySet()) {
                    Litter litter = entry.getValue();
                    if (litter == null || !litter.getOffspring().contains(npc.getId())) continue;
                    carried = true;
                    break;
                }
            }
            this.born = !carried;
            if (npc.getMother() != null) {
                npc.getMother().swapLitters(npc.getId(), osId);
            }
            if (npc.getFather() != null) {
                npc.getFather().swapLitters(npc.getId(), osId);
            }
            if (npc.getIncubator() != null) {
                npc.getIncubator().swapLitters(npc.getId(), osId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Main.game.getOffspring().remove(npc);
        Main.game.banishNPC(npc);
    }

    public OffspringSeed(GameCharacter mother, GameCharacter father) {
        this(mother, father, father.getBody());
    }

    public OffspringSeed(GameCharacter mother, Body fatherBody) {
        this(mother, null, fatherBody);
    }

    public OffspringSeed(GameCharacter mother, GameCharacter father, Body fatherBody) {
        boolean motherHasSurname;
        this.fromPlayer = mother.isPlayer() || father != null && father.isPlayer();
        this.born = false;
        GenericAndrogynousNPC template = new GenericAndrogynousNPC();
        boolean bl = motherHasSurname = mother.getSurname() != null && !mother.getSurname().isEmpty();
        if (mother.getTrueSubspecies() == Subspecies.LILIN || mother.getTrueSubspecies() == Subspecies.ELDER_LILIN) {
            this.setSurname(mother.getName(false) + "\u9a6c\u5c14\u56fe\u62c9\u5c3c");
        } else if (father != null && (father.getTrueSubspecies() == Subspecies.LILIN || father.getTrueSubspecies() == Subspecies.ELDER_LILIN)) {
            this.setSurname(father.getName(false) + "\u9a6c\u5c14\u56fe\u62c9\u5c3c");
        } else if (mother.getMother() != null && (mother.getMother().getTrueSubspecies() == Subspecies.LILIN || mother.getMother().getTrueSubspecies() == Subspecies.ELDER_LILIN)) {
            this.setSurname(mother.getMother().getName(false) + "\u9a6c\u5c14\u56fe");
        } else if (!(father == null || father.getSurname() == null || father.getSurname().isEmpty() || !father.getSurname().endsWith("\u9a6c\u5c14\u56fe\u62c9\u5c3c") && !father.getSurname().endsWith("\u9a6c\u5c14\u56fe\u8428\u8389") && !father.getSurname().endsWith("\u9a6c\u5c14\u56fe\u62c9\u6bd4\u56fe") || motherHasSurname && (mother.getSurname().endsWith("\u9a6c\u5c14\u56fe\u62c9\u5c3c") || mother.getSurname().endsWith("\u9a6c\u5c14\u56fe\u8428\u8389") || mother.getSurname().endsWith("\u9a6c\u5c14\u56fe\u62c9\u6bd4\u56fe")))) {
            if (father.getSurname().endsWith("\u9a6c\u5c14\u56fe\u62c9\u5c3c")) {
                this.setSurname(father.getSurname().replace("\u9a6c\u5c14\u56fe\u62c9\u5c3c", "\u9a6c\u5c14\u56fe"));
            } else if (father.getSurname().endsWith("\u9a6c\u5c14\u56fe\u8428\u8389")) {
                this.setSurname(father.getSurname().replace("\u9a6c\u5c14\u56fe\u8428\u8389", "\u9a6c\u5c14\u56fe"));
            } else if (father.getSurname().endsWith("\u9a6c\u5c14\u56fe\u62c9\u6bd4\u56fe")) {
                this.setSurname(father.getSurname().replace("\u9a6c\u5c14\u56fe\u62c9\u6bd4\u56fe", "\u9a6c\u5c14\u56fe"));
            }
        } else if (motherHasSurname) {
            if (mother.getSurname().endsWith("\u9a6c\u5c14\u56fe\u62c9\u5c3c")) {
                this.setSurname(mother.getSurname().replace("\u9a6c\u5c14\u56fe\u62c9\u5c3c", "\u9a6c\u5c14\u56fe"));
            } else if (mother.getSurname().endsWith("\u9a6c\u5c14\u56fe\u8428\u8389")) {
                this.setSurname(mother.getSurname().replace("\u9a6c\u5c14\u56fe\u8428\u8389", "\u9a6c\u5c14\u56fe"));
            } else if (mother.getSurname().endsWith("\u9a6c\u5c14\u56fe\u62c9\u6bd4\u56fe")) {
                this.setSurname(mother.getSurname().replace("\u9a6c\u5c14\u56fe\u62c9\u6bd4\u56fe", "\u9a6c\u5c14\u56fe"));
            } else {
                this.setSurname(mother.getSurname());
            }
        } else {
            this.setSurname("");
        }
        Gender gender = Main.getProperties().isOffspringGenderUsingPreferences(mother) ? Gender.getGenderFromUserPreferences(false, false) : Gender.getBasicGender(Math.random() < (double)mother.getRace().getChanceForMaleOffspring() ? Femininity.MASCULINE : Femininity.FEMININE);
        Body preGeneratedBody = AbstractSubspecies.getPreGeneratedBody(template, gender, mother, mother.getBody(), fatherBody);
        if (preGeneratedBody != null) {
            this.setBody(preGeneratedBody);
        } else {
            this.body = Main.game.getCharacterUtils().generateBody((GameCharacter)template, gender, mother, father, fatherBody);
        }
        AbstractRace race = this.body.getBodyMaterial() == BodyMaterial.SLIME ? Race.SLIME : this.body.getRaceFromPartWeighting();
        this.subspecies = AbstractSubspecies.getSubspeciesFromBody(this.body, race);
        if (this.surname.contains("martu") && (this.subspecies == Subspecies.IMP || this.subspecies == Subspecies.IMP_ALPHA)) {
            this.setSurname(Name.surnames[Util.random.nextInt(Name.surnames.length)]);
        }
        this.setName(Name.getRandomTriplet(this.getSubspecies()));
        this.setMother(mother);
        if (father != null) {
            this.setFather(father);
        }
        this.setConceptionDate(Main.game.getDateNow());
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element offspringSeedData = doc.createElement("data");
        parentElement.appendChild(offspringSeedData);
        XMLUtil.createXMLElementWithValue(doc, offspringSeedData, "id", this.getId());
        XMLUtil.createXMLElementWithValue(doc, offspringSeedData, "fromPlayer", this.isFromPlayer().toString());
        XMLUtil.createXMLElementWithValue(doc, offspringSeedData, "born", this.isBorn().toString());
        Element name = doc.createElement("name");
        offspringSeedData.appendChild(name);
        XMLUtil.addAttribute(doc, name, "nameFeminine", this.getNameTriplet().getFeminine());
        XMLUtil.addAttribute(doc, name, "nameAndrogynous", this.getNameTriplet().getAndrogynous());
        XMLUtil.addAttribute(doc, name, "nameMasculine", this.getNameTriplet().getMasculine());
        XMLUtil.createXMLElementWithValue(doc, offspringSeedData, "surname", this.getSurname());
        XMLUtil.createXMLElementWithValue(doc, offspringSeedData, "description", this.getDescription());
        if (this.birthday != null) {
            XMLUtil.createXMLElementWithValue(doc, offspringSeedData, "yearOfBirth", String.valueOf(this.getBirthday().getYear()));
            XMLUtil.createXMLElementWithValue(doc, offspringSeedData, "monthOfBirth", String.valueOf(this.getBirthday().getMonth()));
            XMLUtil.createXMLElementWithValue(doc, offspringSeedData, "dayOfBirth", String.valueOf(this.getBirthday().getDayOfMonth()));
        }
        Element offspringSeedBody = doc.createElement("body");
        parentElement.appendChild(offspringSeedBody);
        XMLUtil.addAttribute(doc, offspringSeedBody, "subspecies", Subspecies.getIdFromSubspecies(this.subspecies));
        this.body.saveAsXML(offspringSeedBody, doc);
        Element offspringSeedFamily = doc.createElement("family");
        parentElement.appendChild(offspringSeedFamily);
        XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "motherId", this.getMotherId());
        XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "motherName", this.getMotherName());
        XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "motherFemininity", this.getMotherFemininity().toString());
        XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "motherSubspecies", Subspecies.getIdFromSubspecies(this.getMotherSubspecies()));
        XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "fatherId", this.getFatherId());
        XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "fatherName", this.getFatherName());
        XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "fatherFemininity", this.getFatherFemininity().toString());
        XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "fatherSubspecies", Subspecies.getIdFromSubspecies(this.getFatherSubspecies()));
        if (this.incubatorId != null) {
            XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "incubatorId", this.getIncubatorId());
            XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "incubatorName", this.getIncubatorName());
            XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "incubatorFemininity", this.getIncubatorFemininity().toString());
            XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "incubatorSubspecies", Subspecies.getIdFromSubspecies(this.getIncubatorSubspecies()));
        }
        XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "yearOfConception", String.valueOf(this.getConceptionDate().getYear()));
        XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "monthOfConception", String.valueOf(this.getConceptionDate().getMonth()));
        XMLUtil.createXMLElementWithValue(doc, offspringSeedFamily, "dayOfConception", String.valueOf(this.getConceptionDate().getDayOfMonth()));
        return parentElement;
    }

    public static OffspringSeed loadFromXML(Element parentElement, Document doc) {
        String surname;
        StringBuilder sb = new StringBuilder();
        OffspringSeed os = new OffspringSeed();
        NodeList nodes = parentElement.getElementsByTagName("data");
        Element element = (Element)nodes.item(0);
        String loadedCharacterId = OffspringSeed.getValueFromElementWithTagName(element, "id");
        if (loadedCharacterId != null) {
            os.setId(loadedCharacterId);
        }
        os.setFromPlayer(OffspringSeed.getValueFromElementWithTagName(element, "fromPlayer").equals("true"));
        os.setBorn(OffspringSeed.getValueFromElementWithTagName(element, "born").equals("true"));
        Element nameElement = (Element)element.getElementsByTagName("name").item(0);
        String nameElementValue = nameElement.getAttribute("value");
        if (!nameElementValue.isEmpty()) {
            os.setName(new NameTriplet(nameElementValue));
        } else {
            String nameMasculine = nameElement.getAttribute("nameMasculine");
            String nameAndrogynous = nameElement.getAttribute("nameAndrogynous");
            String nameFeminine = nameElement.getAttribute("nameFeminine");
            NameTriplet backup = Name.getRandomTriplet(Subspecies.HUMAN);
            os.setName(new NameTriplet(nameMasculine.isEmpty() ? backup.getMasculine() : nameMasculine, nameAndrogynous.isEmpty() ? backup.getAndrogynous() : nameAndrogynous, nameFeminine.isEmpty() ? backup.getFeminine() : nameFeminine));
        }
        if (element.getElementsByTagName("surname") != null && element.getElementsByTagName("surname").getLength() > 0 && (surname = ((Element)element.getElementsByTagName("surname").item(0)).getAttribute("value")) != null && !surname.isEmpty()) {
            os.setSurname(surname);
        }
        if (element.getElementsByTagName("description").getLength() != 0) {
            os.setDescription(((Element)element.getElementsByTagName("description").item(0)).getAttribute("value"));
        }
        try {
            int day = Integer.parseInt(((Element)element.getElementsByTagName("dayOfBirth").item(0)).getAttribute("value"));
            Month month = Month.valueOf(((Element)element.getElementsByTagName("monthOfBirth").item(0)).getAttribute("value"));
            int year = Integer.parseInt(((Element)element.getElementsByTagName("yearOfBirth").item(0)).getAttribute("value"));
            os.setBirthday(LocalDateTime.of(year, month, month == Month.FEBRUARY && day == 29 ? 28 : day, 12, 0));
        }
        catch (Exception day) {
            // empty catch block
        }
        element = (Element)parentElement.getElementsByTagName("body").item(0);
        os.subspecies = Subspecies.getSubspeciesFromId(element.getAttribute("subspecies"));
        os.body = Body.loadFromXML(sb, (Element)parentElement.getElementsByTagName("body").item(0), doc);
        os.body.calculateRace(null);
        nodes = parentElement.getElementsByTagName("family");
        Element familyElement = (Element)nodes.item(0);
        if (familyElement != null) {
            os.setMother(((Element)familyElement.getElementsByTagName("motherId").item(0)).getAttribute("value"));
            try {
                os.motherName = ((Element)familyElement.getElementsByTagName("motherName").item(0)).getAttribute("value");
                os.motherFemininity = Femininity.valueOf(((Element)familyElement.getElementsByTagName("motherFemininity").item(0)).getAttribute("value"));
                os.motherSubspecies = Subspecies.getSubspeciesFromId(((Element)familyElement.getElementsByTagName("motherSubspecies").item(0)).getAttribute("value"));
            }
            catch (Exception month) {
                // empty catch block
            }
            os.setFather(((Element)familyElement.getElementsByTagName("fatherId").item(0)).getAttribute("value"));
            try {
                os.fatherName = ((Element)familyElement.getElementsByTagName("fatherName").item(0)).getAttribute("value");
                os.fatherFemininity = Femininity.valueOf(((Element)familyElement.getElementsByTagName("fatherFemininity").item(0)).getAttribute("value"));
                os.fatherSubspecies = Subspecies.getSubspeciesFromId(((Element)familyElement.getElementsByTagName("fatherSubspecies").item(0)).getAttribute("value"));
            }
            catch (Exception month) {
                // empty catch block
            }
            if (familyElement.getElementsByTagName("incubatorId").getLength() > 0) {
                os.setIncubator(((Element)familyElement.getElementsByTagName("incubatorId").item(0)).getAttribute("value"));
            }
            try {
                os.incubatorName = ((Element)familyElement.getElementsByTagName("incubatorName").item(0)).getAttribute("value");
                os.incubatorFemininity = Femininity.valueOf(((Element)familyElement.getElementsByTagName("incubatorFemininity").item(0)).getAttribute("value"));
                os.incubatorSubspecies = Subspecies.getSubspeciesFromId(((Element)familyElement.getElementsByTagName("incubatorSubspecies").item(0)).getAttribute("value"));
            }
            catch (Exception month) {
                // empty catch block
            }
            try {
                int day = Integer.parseInt(((Element)familyElement.getElementsByTagName("dayOfConception").item(0)).getAttribute("value"));
                Month month = Month.valueOf(((Element)familyElement.getElementsByTagName("monthOfConception").item(0)).getAttribute("value"));
                int year = Integer.parseInt(((Element)familyElement.getElementsByTagName("yearOfConception").item(0)).getAttribute("value"));
                os.setConceptionDate(LocalDateTime.of(year, month, day, 12, 0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return os;
    }

    public static String getValueFromElementWithTagName(Element parentElement, String tagName) {
        return OffspringSeed.getValueFromElementWithTagName(parentElement, tagName, null);
    }

    public static String getValueFromElementWithTagName(Element parentElement, String tagName, String defaultValue) {
        Element x = (Element)parentElement.getElementsByTagName(tagName).item(0);
        return x != null ? x.getAttribute("value") : defaultValue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean isFromPlayer() {
        return this.fromPlayer;
    }

    public void setFromPlayer(Boolean fromPlayer) {
        this.fromPlayer = fromPlayer;
    }

    public Boolean isBorn() {
        return this.born;
    }

    public void setBorn(Boolean born) {
        this.born = born;
    }

    private NameTriplet getNameTriplet() {
        return this.nameTriplet;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LocalDateTime getBirthday() {
        return this.birthday;
    }

    public void setBirthday(LocalDateTime birthday) {
        this.birthday = birthday;
    }

    public GameCharacter getMother() {
        if (this.motherId == null || this.motherId.isEmpty() || this.motherId.equals("NOT_SET")) {
            return null;
        }
        try {
            return Main.game.getNPCById(this.motherId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMotherId() {
        return this.motherId;
    }

    public void setMother(String motherId) {
        this.motherId = motherId;
    }

    public void setMother(GameCharacter mother) {
        this.motherId = mother.getId();
        this.motherName = mother.getNameIgnoresPlayerKnowledge();
        this.motherFemininity = mother.getFemininity();
        this.motherSubspecies = mother.getTrueSubspecies();
    }

    public String getMotherName() {
        return this.motherName;
    }

    public Femininity getMotherFemininity() {
        return this.motherFemininity;
    }

    public AbstractSubspecies getMotherSubspecies() {
        return this.motherSubspecies;
    }

    public GameCharacter getFather() {
        if (this.fatherId == null || this.fatherId.isEmpty() || this.fatherId.equals("NOT_SET")) {
            return null;
        }
        try {
            return Main.game.getNPCById(this.fatherId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFatherId() {
        return this.fatherId;
    }

    public void setFather(String fatherId) {
        this.fatherId = fatherId;
    }

    public void setFather(GameCharacter father) {
        this.fatherId = father.getId();
        this.fatherName = father.getNameIgnoresPlayerKnowledge();
        this.fatherFemininity = father.getFemininity();
        this.fatherSubspecies = father.getTrueSubspecies();
    }

    public String getFatherName() {
        return this.fatherName;
    }

    public Femininity getFatherFemininity() {
        return this.fatherFemininity;
    }

    public AbstractSubspecies getFatherSubspecies() {
        return this.fatherSubspecies;
    }

    public String getIncubatorId() {
        return this.incubatorId;
    }

    public void setIncubator(String incubatorId) {
        this.incubatorId = incubatorId;
        if (this.getIncubator() != null && this.getIncubator().isPlayer()) {
            this.setFromPlayer(true);
        }
    }

    public void setIncubator(GameCharacter incubator) {
        this.incubatorId = incubator.getId();
        this.incubatorName = incubator.getNameIgnoresPlayerKnowledge();
        this.incubatorFemininity = incubator.getFemininity();
        this.incubatorSubspecies = incubator.getTrueSubspecies();
    }

    public GameCharacter getIncubator() {
        if (this.getIncubatorId() == null || this.getIncubatorId().isEmpty() || this.getIncubatorId().equals("NOT_SET")) {
            return null;
        }
        try {
            return Main.game.getNPCById(this.getIncubatorId());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getIncubatorName() {
        return this.incubatorName;
    }

    public Femininity getIncubatorFemininity() {
        return this.incubatorFemininity;
    }

    public AbstractSubspecies getIncubatorSubspecies() {
        return this.incubatorSubspecies;
    }

    public LocalDateTime getConceptionDate() {
        return this.conceptionDate;
    }

    public void setConceptionDate(LocalDateTime conceptionDate) {
        this.conceptionDate = conceptionDate;
    }

    public Body getBody() {
        return this.body;
    }

    public BodyMaterial getBodyMaterial() {
        return this.getBody().getBodyMaterial();
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public void setBody(Gender startingGender, GameCharacter mother, GameCharacter father) {
        GenericAndrogynousNPC template = new GenericAndrogynousNPC();
        this.body = Main.game.getCharacterUtils().generateBody((GameCharacter)template, startingGender, mother, father);
    }

    public String getName() {
        switch (this.getFemininity()) {
            case MASCULINE_STRONG: 
            case MASCULINE: {
                return this.nameTriplet.getMasculine();
            }
            case ANDROGYNOUS: {
                return this.nameTriplet.getAndrogynous();
            }
        }
        return this.nameTriplet.getFeminine();
    }

    public void setName(NameTriplet nameTriplet) {
        this.nameTriplet = nameTriplet;
    }

    public AbstractRace getRace() {
        return this.getSubspecies().getRace();
    }

    public AbstractSubspecies getSubspecies() {
        return this.subspecies;
    }

    public boolean isFeral() {
        return this.getBody().isFeral();
    }

    public boolean isFeminine() {
        return this.body == null || this.body.isFeminine();
    }

    public Femininity getFemininity() {
        return Femininity.valueOf(this.body.getFemininity());
    }

    public boolean isTakesAfterMother() {
        return this.body.isTakesAfterMother();
    }

    public AbstractSubspecies getHalfDemonSubspecies() {
        return this.body.getHalfDemonSubspecies();
    }

    public DialogueNode getEncounterDialogue() {
        return GenericOffspringDialogue.OFFSPRING_ENCOUNTER;
    }

    public String hisHer() {
        if (this.isFeminine()) {
            return GenderPronoun.POSSESSIVE_BEFORE_NOUN.getFeminine();
        }
        return GenderPronoun.POSSESSIVE_BEFORE_NOUN.getMasculine();
    }

    public Gender getGender() {
        return this.body.getGender();
    }

    public String getGenderName() {
        return this.getGender().getNounYoung();
    }

    public BodyShape getBodyShape() {
        return BodyShape.valueOf(Muscle.valueOf(this.body.getMuscle()), BodySize.valueOf(this.body.getBodySize()));
    }

    public Height getHeight() {
        return this.body.getHeight();
    }
}

