/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.misc;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.npc.dominion.Finch;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.persona.NameTriplet;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.companions.SlaveDialogue;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SlaveForSale
extends NPC {
    public SlaveForSale() {
        this(Gender.getGenderFromUserPreferences(false, false), true, false);
    }

    public SlaveForSale(boolean isImported) {
        this(Gender.getGenderFromUserPreferences(false, false), true, isImported);
    }

    public SlaveForSale(Gender gender, boolean isImported) {
        this(gender, true, isImported);
    }

    public SlaveForSale(Gender gender, boolean allowTaurSpawns, boolean isImported) {
        super(isImported, new NameTriplet("\u5974\u96b6"), "", "", 21, Util.randomItemFrom(Month.values()), 1 + Util.random.nextInt(27), 1, null, null, null, new CharacterInventory(false, 0), WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, false, new NPCGenerationFlag[0]);
        if (!isImported) {
            this.setLevel(Util.random.nextInt(3) + 1);
            HashMap<AbstractSubspecies, Integer> availableRaces = new HashMap<AbstractSubspecies, Integer>();
            for (AbstractSubspecies s : Subspecies.getAllSubspecies()) {
                if (s.getSubspeciesOverridePriority() > 0 || s.isNonBiped() && !allowTaurSpawns) continue;
                if (Subspecies.getWorldSpecies(WorldType.DOMINION, null, false, new AbstractSubspecies[0]).containsKey(s)) {
                    AbstractSubspecies.addToSubspeciesMap((int)(10000.0f * Subspecies.getWorldSpecies(WorldType.DOMINION, PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION, false, new AbstractSubspecies[0]).get(s).getChanceMultiplier()), gender, s, availableRaces);
                }
                if (!Subspecies.getWorldSpecies(WorldType.SUBMISSION, null, false, new AbstractSubspecies[0]).containsKey(s)) continue;
                AbstractSubspecies.addToSubspeciesMap((int)(10000.0f * Subspecies.getWorldSpecies(WorldType.SUBMISSION, PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION, false, new AbstractSubspecies[0]).get(s).getChanceMultiplier()), gender, s, availableRaces);
            }
            this.setBodyFromSubspeciesPreference(gender, availableRaces, true, true);
            if (Math.random() < (double)((float)Main.getProperties().halfDemonSpawnRate / 100.0f) && this.getSubspecies() != Subspecies.SLIME) {
                this.setBody(Main.game.getCharacterUtils().generateHalfDemonBody(this, gender, this.getBody().getFleshSubspecies(), true), true);
            }
            if (allowTaurSpawns && Math.random() < (double)((float)Main.getProperties().taurSpawnRate / 100.0f) && this.getLegConfiguration() != LegConfiguration.QUADRUPEDAL) {
                if (this.getSubspecies() == Subspecies.HALF_DEMON && this.getLegType().isLegConfigurationAvailable(LegConfiguration.QUADRUPEDAL)) {
                    Main.game.getCharacterUtils().applyTaurConversion(this);
                } else if (this.getRace().getRacialBody().getLegType().isLegConfigurationAvailable(LegConfiguration.QUADRUPEDAL)) {
                    this.setLegType(this.getRace().getRacialBody().getLegType());
                    Main.game.getCharacterUtils().applyTaurConversion(this);
                }
            }
            this.setSexualOrientation(RacialBody.valueOfRace(this.getRace()).getSexualOrientation(gender));
            this.setName(Name.getRandomTriplet(this.getSubspecies()));
            this.setPlayerKnowsName(true);
            this.setAttribute(Attribute.MAJOR_CORRUPTION, 0.0f);
            Main.game.getCharacterUtils().setHistoryAndPersonality(this, true);
            this.setHistory(Occupation.NPC_SLAVE);
            this.clearFetishDesires();
            this.clearFetishes();
            Main.game.getCharacterUtils().addFetishes(this, new AbstractFetish[0]);
            this.setObedience(100.0f);
            this.setStartingBody(true);
            Main.game.getCharacterUtils().randomiseBody(this, true);
            this.resetInventory(true);
            this.inventory.setMoney(0L);
            this.equipClothing(EquipClothingSetting.getAllClothingSettings());
            this.initHealthAndManaToMax();
            this.setEnslavementDialogue(SlaveDialogue.DEFAULT_ENSLAVEMENT_DIALOGUE, true);
        }
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        SlaveForSale.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        this.equipClothingFromNowhere(Main.game.getItemGen().generateClothing("innoxia_bdsm_metal_collar", PresetColour.CLOTHING_STEEL, false), true, Main.game.getNpc(Finch.class));
    }

    @Override
    public String getDescription() {
        if (this.isSlave() && this.isDoll()) {
            return super.getDescription();
        }
        if (this.isSlave()) {
            return UtilText.parse((GameCharacter)this, "\u7531\u4e8e\u67d0\u4e9b\u539f\u56e0\uff0c[npc.nameIsFull]\u662f\u4e00\u540d\u5974\u96b6\uff0c\u53ea\u4e0d\u8fc7\u662f\u5176\u4e3b\u4eba\u7684\u8d22\u4ea7\u3002", new ParserTag[0]);
        }
        return UtilText.parse((GameCharacter)this, "[npc.nameIsFull]\u66fe\u6709\u4e00\u6bb5\u65f6\u95f4\u662f\u4f60\u7684\u5974\u96b6\uff0c\u4f46\u73b0\u5728\u662f\u4f60\u5f88\u4fe1\u4efb\u7684\u670b\u53cb\u4e86\u3002", new ParserTag[0]);
    }
}

