/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.submission;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.valueEnums.BodyMaterial;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.companions.SlaveDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.submission.BatCavernDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.outfit.OutfitType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BatCavernSlimeAttacker
extends NPC {
    public BatCavernSlimeAttacker() {
        this(Gender.getGenderFromUserPreferences(false, false), false);
    }

    public BatCavernSlimeAttacker(Gender gender) {
        this(gender, false);
    }

    public BatCavernSlimeAttacker(boolean isImported) {
        this(Gender.F_V_B_FEMALE, isImported);
    }

    public BatCavernSlimeAttacker(Gender gender, boolean isImported) {
        super(isImported, null, null, "", Util.random.nextInt(28) + 18, Util.randomItemFrom(Month.values()), 1 + Util.random.nextInt(25), 3, gender, Subspecies.HUMAN, RaceStage.HUMAN, new CharacterInventory(false, 10), WorldType.BAT_CAVERNS, PlaceType.BAT_CAVERN_DARK, false, new NPCGenerationFlag[0]);
        if (!isImported) {
            this.setLocation(Main.game.getPlayer(), true);
            this.setLevel(8 + Util.random.nextInt(5));
            this.setBody(gender, Subspecies.SLIME, RaceStage.GREATER, false);
            this.setSexualOrientation(RacialBody.valueOfRace(this.getRace()).getSexualOrientation(gender));
            this.setName(Name.getRandomTriplet(this.getSubspecies()));
            this.setPlayerKnowsName(false);
            Main.game.getCharacterUtils().setHistoryAndPersonality(this, true);
            Main.game.getCharacterUtils().addFetishes(this, new AbstractFetish[0]);
            Main.game.getCharacterUtils().randomiseBody(this, true);
            this.setBodyMaterial(BodyMaterial.SLIME);
            this.resetInventory(true);
            this.inventory.setMoney(50 + Util.random.nextInt(this.getLevel() * 10) + 1);
            Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
            this.equipClothing(EquipClothingSetting.getAllClothingSettings());
            Main.game.getCharacterUtils().applyMakeup(this, true);
            this.initPerkTreeAndBackgroundPerks();
            this.setStartingCombatMoves();
            this.loadImages();
            this.useItem(Main.game.getItemGen().generateItem(ItemType.MUSHROOM), this, false);
            this.initHealthAndManaToMax();
        }
        this.setEnslavementDialogue(SlaveDialogue.DEFAULT_ENSLAVEMENT_DIALOGUE, true);
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        BatCavernSlimeAttacker.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        this.incrementMoney((long)((float)this.getInventory().getNonEquippedValue() * 0.5f));
        this.clearNonEquippedInventory(false);
        Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
        Main.game.getCharacterUtils().equipClothingFromOutfitType(this, OutfitType.MUGGER, settings);
    }

    @Override
    public void hourlyUpdate(int hour) {
        if (!this.isSlave() && !Main.game.getPlayer().getFriendlyOccupants().contains(this.getId())) {
            this.useItem(Main.game.getItemGen().generateItem(ItemType.MUSHROOM), this, false);
        }
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getDescription() {
        if (this.isSlave() && this.isDoll()) {
            return super.getDescription();
        }
        if (this.isSlave()) {
            return UtilText.parse((GameCharacter)this, "[npc.NamePos]\u5728\u8759\u8760\u6d1e\u7a9f\u91cc\u55d1\u8611\u83c7\uff0c\u88ad\u51fb\u65e0\u8f9c\u8def\u4eba\u7684\u65e5\u5b50\u5df2\u7ecf\u7ed3\u675f\u3002\u7531\u4e8e\u5176\u975e\u6cd5\u884c\u5f84\uff0c\u4f5c\u4e3a\u60e9\u7f5a\u800c\u88ab\u5974\u5f79\uff0c[npc.sheIs]\u73b0\u5728\u662f\u4e00\u540d\u5974\u96b6\uff0c\u53ea\u4e0d\u8fc7\u662f\u5176\u4e3b\u4eba\u7684\u8d22\u4ea7\u3002", new ParserTag[0]);
        }
        if (Main.game.getPlayer().getFriendlyOccupants().contains(this.getId())) {
            return UtilText.parse((GameCharacter)this, "[npc.NamePos]\u5728\u8759\u8760\u6d1e\u7a9f\u91cc\u55d1\u8611\u83c7\uff0c\u88ad\u51fb\u65e0\u8f9c\u8def\u4eba\u7684\u65e5\u5b50\u5df2\u7ecf\u7ed3\u675f\u3002\u4f60\u8ddf[npc.name]\u4ea4\u4e86\u670b\u53cb\uff0c\u5e76\u4e14\u9080\u8bf7[npc.herHim]\u8ddf\u4f60\u4f4f\u5728\u4e00\u8d77\uff0c\u5e2e\u52a9[npc.herHim]\u5f00\u59cb\u4e00\u6bb5\u5168\u65b0\u7684\u751f\u6d3b\u3002", new ParserTag[0]);
        }
        return UtilText.parse((GameCharacter)this, "[npc.Name]\u662f\u8759\u8760\u6d1e\u7a9f\u7684\u5c45\u6c11\uff0c\u5e76\u4ee5\u55d1\u8611\u83c7\uff0c\u88ad\u51fb\u8def\u8fc7\u7684\u65e0\u8f9c\u8def\u4eba\u548c\u505a\u7231\u4e3a\u4e50\u3002", new ParserTag[0]);
    }

    @Override
    public void endSex() {
        if (!this.isSlave()) {
            this.setPendingClothingDressing(true);
        }
    }

    @Override
    public boolean isClothingStealable() {
        return true;
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return BatCavernDialogue.CAVERN_ATTACK;
    }

    @Override
    public Response endCombat(boolean applyEffects, boolean victory) {
        if (victory) {
            return new Response("", "", BatCavernDialogue.AFTER_COMBAT_VICTORY);
        }
        return new Response("", "", BatCavernDialogue.AFTER_COMBAT_DEFEAT);
    }
}

