/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.submission;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.fetishes.FetishDesire;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.character.race.SubspeciesSpawnRarity;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.submission.dicePoker.DicePokerTable;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.outfit.OutfitType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GamblingDenPatron
extends NPC {
    private DicePokerTable table;

    public GamblingDenPatron() {
        this(Gender.getGenderFromUserPreferences(false, false), DicePokerTable.COPPER, false);
    }

    public GamblingDenPatron(Gender gender) {
        this(gender, DicePokerTable.COPPER, false);
    }

    public GamblingDenPatron(boolean isImported) {
        this(Gender.F_V_B_FEMALE, DicePokerTable.COPPER, isImported);
    }

    public GamblingDenPatron(Gender gender, DicePokerTable table, boolean isImported) {
        this(gender, table, WorldType.GAMBLING_DEN, PlaceType.GAMBLING_DEN_GAMBLING, isImported);
    }

    public GamblingDenPatron(Gender gender, DicePokerTable table, AbstractWorldType worldType, AbstractPlaceType placeType, boolean isImported) {
        super(isImported, null, null, "", Util.random.nextInt(28) + 18, Util.randomItemFrom(Month.values()), 1 + Util.random.nextInt(25), 3, null, null, null, new CharacterInventory(false, 10), worldType, placeType, false, new NPCGenerationFlag[0]);
        this.table = table;
        if (!isImported) {
            this.setLevel(5 + Util.random.nextInt(4));
            int slimeChance = Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.slimeQueenHelped) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_SLIME_QUEEN) ? 1000 : 500;
            HashMap<AbstractSubspecies, Integer> availableRaces = new HashMap<AbstractSubspecies, Integer>();
            if (worldType == WorldType.GAMBLING_DEN) {
                for (AbstractSubspecies s : Subspecies.getAllSubspecies()) {
                    if (s == Subspecies.SLIME) {
                        AbstractSubspecies.addToSubspeciesMap(slimeChance, gender, s, availableRaces);
                        continue;
                    }
                    if (Subspecies.getWorldSpecies(WorldType.SUBMISSION, PlaceType.GAMBLING_DEN_GAMBLING, false, Subspecies.IMP, Subspecies.IMP_ALPHA).containsKey(s)) {
                        AbstractSubspecies.addToSubspeciesMap((int)(1000.0f * Subspecies.getWorldSpecies(WorldType.SUBMISSION, PlaceType.GAMBLING_DEN_GAMBLING, false, Subspecies.IMP, Subspecies.IMP_ALPHA).get(s).getChanceMultiplier()), gender, s, availableRaces);
                        continue;
                    }
                    if (!Subspecies.getWorldSpecies(WorldType.DOMINION, PlaceType.GAMBLING_DEN_GAMBLING, false, Subspecies.IMP, Subspecies.IMP_ALPHA).containsKey(s)) continue;
                    AbstractSubspecies.addToSubspeciesMap((int)(250.0f * Subspecies.getWorldSpecies(WorldType.DOMINION, PlaceType.GAMBLING_DEN_GAMBLING, false, Subspecies.IMP, Subspecies.IMP_ALPHA).get(s).getChanceMultiplier()), gender, s, availableRaces);
                }
            } else {
                for (AbstractSubspecies s : Subspecies.getAllSubspecies()) {
                    Map<AbstractSubspecies, SubspeciesSpawnRarity> subMap;
                    if (s.getSubspeciesOverridePriority() > 0 || !(subMap = Subspecies.getWorldSpecies(worldType, placeType, false, new AbstractSubspecies[0])).containsKey(s)) continue;
                    AbstractSubspecies.addToSubspeciesMap((int)(10000.0f * subMap.get(s).getChanceMultiplier()), gender, s, availableRaces);
                }
            }
            this.setBodyFromSubspeciesPreference(gender, availableRaces, true, true);
            this.setSexualOrientation(RacialBody.valueOfRace(this.getRace()).getSexualOrientation(gender));
            this.setName(Name.getRandomTriplet(this.getSubspecies()));
            this.setPlayerKnowsName(false);
            Main.game.getCharacterUtils().setHistoryAndPersonality(this, false);
            Main.game.getCharacterUtils().addFetishes(this, new AbstractFetish[0]);
            this.setFetishDesire(Fetish.FETISH_DOMINANT, FetishDesire.TWO_NEUTRAL);
            Main.game.getCharacterUtils().randomiseBody(this, true);
            this.resetInventory(true);
            this.inventory.setMoney(750 + Util.random.nextInt(750));
            Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, false);
            this.equipClothing(EquipClothingSetting.getAllClothingSettings());
            Main.game.getCharacterUtils().applyMakeup(this, true);
            Main.game.getCharacterUtils().applyTattoos(this, true);
            this.initPerkTreeAndBackgroundPerks();
            this.setStartingCombatMoves();
            this.loadImages();
            this.initHealthAndManaToMax();
        }
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element properties = super.saveAsXML(parentElement, doc);
        Element tableElement = doc.createElement("table");
        properties.appendChild(tableElement);
        XMLUtil.addAttribute(doc, tableElement, "value", this.table.toString());
        return properties;
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        GamblingDenPatron.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
        try {
            Element npcSpecificElement = (Element)parentElement.getElementsByTagName("table").item(0);
            this.setTable(DicePokerTable.valueOf(npcSpecificElement.getAttribute("value")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        Main.game.getCharacterUtils().equipClothingFromOutfitType(this, OutfitType.CASUAL, settings);
    }

    public DicePokerTable getTable() {
        return this.table;
    }

    public void setTable(DicePokerTable table) {
        this.table = table;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getDescription() {
        switch (this.table) {
            case COPPER: {
                return UtilText.parse((GameCharacter)this, "[npc.Name]\u8fd8\u662f\u4e2a\u9ab0\u5b50\u6251\u514b\u7684\u65b0\u624b\uff0c\u6240\u4ee5\u5728\u8d4c\u573a\u7684\u6251\u514b\u5927\u5385\u91cc\u9009\u62e9\u201c\u94dc\u684c\u201d\u3002", new ParserTag[0]);
            }
            case SILVER: {
                return UtilText.parse((GameCharacter)this, "[npc.Name]\u73a9\u9ab0\u5b50\u6251\u514b\u5df2\u7ecf\u6709\u4e86\u4e0d\u5c11\u7ecf\u9a8c\uff0c\u6240\u4ee5\u5728\u8d4c\u573a\u7684\u6251\u514b\u5927\u5385\u9009\u91cc\u62e9\u201c\u94f6\u684c\u201d\u3002", new ParserTag[0]);
            }
            case GOLD: {
                return UtilText.parse((GameCharacter)this, "[npc.Name]\u662f\u9ab0\u5b50\u6251\u514b\u7684\u5927\u5e08\uff0c\u6240\u4ee5\u5728\u8d4c\u573a\u7684\u6251\u514b\u5927\u5385\u9009\u91cc\u62e9\u201c\u91d1\u684c\u201d\u3002", new ParserTag[0]);
            }
        }
        return "";
    }

    @Override
    public void endSex() {
        if (!this.isSlave()) {
            this.setPendingClothingDressing(true);
        }
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }

    @Override
    public Response endCombat(boolean applyEffects, boolean victory) {
        return null;
    }
}

