/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.persona;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.persona.PersonalityCategory;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PersonalityTrait {
    CONFIDENT(false, PersonalityCategory.CORE, "\u81ea\u4fe1", "[npc.NameIsFull]\u975e\u5e38\u6709\u4e3b\u89c1\uff0c\u5bf9[npc.herself]\u76f8\u5f53\u81ea\u4fe1\u3002", "", PresetColour.BASE_GREEN_LIME){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(SHY);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(CONFIDENT) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u5f88\u81ea\u4fe1\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u66f4\u81ea\u4fe1\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(CONFIDENT) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u7f3a\u4e4f\u81ea\u4fe1\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u4e0d\u518d\u81ea\u4fe1\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    SHY(false, PersonalityCategory.CORE, "\u5bb3\u7f9e", "[npc.NameIsFull]\u5728\u4ed6\u4eba\u9762\u524d\u975e\u5e38\u5bb3\u7f9e\uff0c\u4e14\u503e\u5411\u5c3d\u53ef\u80fd\u907f\u5f00\u8c08\u8bdd\u3002", "", PresetColour.BASE_YELLOW_LIGHT){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(CONFIDENT);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(SHY) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u5f88\u5bb3\u7f9e\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u66f4\u5bb3\u7f9e\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(SHY) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u518d\u5bb3\u7f9e\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u4e0d\u518d\u5bb3\u7f9e\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    KIND(false, PersonalityCategory.CORE, "\u5584\u826f", "[npc.Name]\u603b\u8bd5\u7740\u8868\u73b0\u53cb\u5584\uff0c\u4f53\u8d34\u4ed6\u4eba\uff0c\u6709\u65f6\u751a\u81f3\u4f1a\u4e0d\u60dc\u727a\u7272[npc.her]\u81ea\u8eab\u7684\u5feb\u4e50\u3002", "", PresetColour.BASE_GREEN){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(SELFISH);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(KIND) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u5f88\u5584\u826f\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u66f4\u5584\u826f\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(KIND) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u600e\u4e48\u5584\u826f\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u4e0d\u518d\u5584\u826f\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    SELFISH(false, PersonalityCategory.CORE, "\u81ea\u79c1", "[npc.Name]\u603b\u662f\u628a[npc.herself]\u653e\u5728\u9996\u4f4d\uff0c\u82e5[npc.herHim]\u4e0d\u80fd\u76f4\u63a5\u53d7\u76ca\u7684\u4e8b\u60c5\uff0c\u5927\u6982\u7387\u4f1a\u5bf9\u6b64\u65e0\u52a8\u4e8e\u8877\u3002", "", PresetColour.BASE_RED){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(KIND);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(SELFISH) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u5f88\u81ea\u79c1\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u66f4\u81ea\u79c1\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(SELFISH) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u518d\u81ea\u79c1\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u4e0d\u518d\u81ea\u79c1\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    NAIVE(false, PersonalityCategory.CORE, "\u5929\u771f", "\u7f3a\u4e4f\u4eba\u751f\u7ecf\u9a8c\u4e0e\u667a\u6167\uff0c[npc.name]\u5b8c\u5168\u65e0\u6cd5\u7406\u89e3\u73b0\u5b9e\u7684\u6b8b\u9177\u3002", "", PresetColour.BASE_PINK_LIGHT){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(CYNICAL);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(NAIVE) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u5f88\u5929\u771f\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u66f4\u5929\u771f\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(NAIVE) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u518d\u5929\u771f\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u4e0d\u518d\u5929\u771f\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    CYNICAL(false, PersonalityCategory.CORE, "\u6124\u4e16\u5ac9\u4fd7", "[npc.NameIsFull]\u5bf9\u4e8e\u4ed6\u4eba\u7684\u610f\u56fe\u4e0e\u52a8\u673a\u62b1\u6709\u76f8\u5f53\u7684\u7591\u5fc3\u3002", "", PresetColour.BASE_RED_DARK){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(NAIVE);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(CYNICAL) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6124\u4e16\u5ac9\u4fd7\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u66f4\u6124\u4e16\u5ac9\u4fd7\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(CYNICAL) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u518d\u6124\u4e16\u5ac9\u4fd7\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u4e0d\u518d\u6124\u4e16\u5ac9\u4fd7\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    BRAVE(false, PersonalityCategory.COMBAT, "\u52c7\u6562", "[npc.Name]\u603b\u662f\u52c7\u4e8e\u884c\u52a8\uff0c\u4e14\u4e0d\u754f\u6597\u4e89\u3002", "", PresetColour.BASE_ORANGE){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(COWARDLY);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(BRAVE) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u5f88\u52c7\u6562\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u66f4\u52c7\u6562\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(BRAVE) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u518d\u52c7\u6562\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u4e0d\u518d\u52c7\u6562\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    COWARDLY(false, PersonalityCategory.COMBAT, "\u61e6\u5f31", "[npc.Name]\u5f88\u5bb9\u6613\u62c5\u60ca\u53d7\u6015\uff0c\u6bd4\u8d77\u76f4\u63a5\u89e3\u51b3\u4e89\u7aef\uff0c\u5b81\u53ef\u76f4\u63a5\u9003\u5f00\u3002", "", PresetColour.BASE_RED_LIGHT){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(BRAVE);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(COWARDLY) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u5f88\u61e6\u5f31\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u66f4\u61e6\u5f31\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(COWARDLY) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u518d\u61e6\u5f31\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u4e0d\u518d\u61e6\u5f31\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    LEWD(false, PersonalityCategory.SEX, "\u597d\u8272", "[npc.NameHasFull]\u62e5\u6709\u5927\u91cf\u5404\u79cd\u4e0e\u6027\u6709\u5173\u7684\u77e5\u8bc6\uff0c\u5e76\u4e14\u4e50\u4e8e\u8ba8\u8bba\u8fd9\u4e9b\u4e0b\u6d41\u7684\u4e8b\u60c5\u3002", "", PresetColour.BASE_PINK){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(PRUDE, INNOCENT);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(LEWD) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u5f88\u597d\u8272\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u66f4\u597d\u8272\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(LEWD) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u518d\u597d\u8272\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u4e0d\u518d\u597d\u8272\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    INNOCENT(false, PersonalityCategory.SEX, "\u7eaf\u6d01", "\u8ba8\u8bba\u548c\u8fdb\u884c\u6027\u884c\u4e3a\u65f6\uff0c[npc.Name]\u603b\u662f\u8868\u73b0\u5f97\u5c34\u5c2c\u53c8\u65e0\u77e5\u3002", "", PresetColour.BASE_BLUE_LIGHT){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(LEWD, PRUDE);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(INNOCENT) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u5f88\u7eaf\u6d01\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u66f4\u7eaf\u6d01\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(INNOCENT) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u518d\u7eaf\u6d01\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u4e0d\u518d\u7eaf\u6d01\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    PRUDE(false, PersonalityCategory.SEX, "\u62d8\u8c28", "[npc.Name]\u4e0d\u613f\u8c08\u53ca\u6027\u4e8b\uff0c\u751a\u81f3\u62d2\u7edd\u627f\u8ba4\u81ea\u5df1\u77e5\u9053\u4efb\u4f55\u4e0e\u6027\u76f8\u5173\u7684\u4e8b\u60c5\u3002", "", PresetColour.BASE_BLUE_STEEL){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(LEWD, INNOCENT);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(INNOCENT) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u5f88\u62d8\u8c28\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u66f4\u62d8\u8c28\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(INNOCENT) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u518d\u62d8\u8c28\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u4e0d\u518d\u62d8\u8c28\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    LISP(false, PersonalityCategory.SPEECH, "\u53e3\u9f7f\u4e0d\u6e05", "[npc.Name]\u8bf4\u8bdd\u53e3\u9f7f\u4e0d\u6e05\uff0c\u4f1a\u628a\u201cz\u201d\u3001\u201cc\u201d\u3001\u201cs\u201d\u8bf4\u6210\u201czh\u201d\u3001\u201cch\u201d\u3001\u201csh\u201d\u3002", "[style.italicsBad([npc.namePos]\u6e38\u620f\u4e2d\u7684\u6240\u6709\u53d1\u8a00\u90fd\u4f1a\u88ab\u8fd9\u4e2a\u4e2a\u6027\u5f71\u54cd\uff01)]", PresetColour.BASE_PURPLE_LIGHT){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(MUTE);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(LISP) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u53e3\u9f7f\u4e0d\u6e05\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u6709\u4e9b\u53e3\u9f7f\u4e0d\u6e05\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(LISP) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u518d\u53e3\u9f7f\u4e0d\u6e05\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u8bf4\u8bdd\u66f4\u6e05\u695a\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    STUTTER(false, PersonalityCategory.SPEECH, "\u53e3\u5403", "[npc.NameHasFull]\u4e60\u60ef\u5728\u8bf4\u8bdd\u65f6\u78d5\u78d5\u7eca\u7eca\u3002", "[style.italicsBad([npc.namePos]\u6e38\u620f\u4e2d\u7684\u6240\u6709\u53d1\u8a00\u90fd\u4f1a\u88ab\u8fd9\u4e2a\u4e2a\u6027\u5f71\u54cd\uff01)]", PresetColour.BASE_PINK_SALMON){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(MUTE);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(STUTTER) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u53e3\u5403\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u6709\u4e9b\u53e3\u5403\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(STUTTER) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u518d\u53e3\u5403\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u4e0d\u518d\u53e3\u5403\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    MUTE(true, PersonalityCategory.SPEECH, "\u54d1\u5df4", "[npc.NameIsFull]\u662f\u4e2a\u54d1\u5df4\uff0c\u5c3d\u7ba1\u8fd8\u662f\u80fd\u5728\u5174\u594b\u65f6\u53d1\u51fa\u4e00\u4e9b\u6deb\u53eb\uff0c\u4f46\u5b8c\u5168\u65e0\u6cd5\u5bf9\u8bdd\u3002", "[style.italicsBad([npc.namePos]\u6e38\u620f\u4e2d\u7684\u6240\u6709\u53d1\u8a00\u90fd\u4f1a\u88ab\u79fb\u9664\uff01)]", PresetColour.BASE_CRIMSON){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(LISP, STUTTER, SLOVENLY);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(STUTTER) ? "[style.colourDisabled([npc.NameIsFull]\u5df2\u7ecf\u662f\u54d1\u5df4\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u4e0d\u80fd\u8bf4\u8bdd\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(STUTTER) ? "[style.colourDisabled([npc.NameIsFull]\u5df2\u7ecf\u80fd\u8bf4\u8bdd\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u80fd\u8bf4\u8bdd\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    }
    ,
    SLOVENLY(false, PersonalityCategory.SPEECH, "\u53d1\u97f3\u6a21\u7cca", "[npc.Name]\u53d1\u97f3\u5f88\u6a21\u7cca\uff1b\u7ecf\u5e38\u4e22\u5931\u5143\u97f3\u6216\u53d1\u9519\u97f3\uff0c[npc.her]\u8bf4\u7684\u8bdd\u901a\u5e38\u90fd\u5f88\u96be\u542c\u61c2\u3002", "[style.italicsBad([npc.namePos]\u6e38\u620f\u4e2d\u7684\u6240\u6709\u53d1\u8a00\u90fd\u4f1a\u88ab\u8fd9\u4e2a\u4e2a\u6027\u5f71\u54cd\uff01)]", PresetColour.BASE_BROWN){

        @Override
        public List<PersonalityTrait> getMutuallyExclusiveSettings() {
            return Util.newArrayListOfValues(MUTE);
        }

        @Override
        public String getAdditionDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (target.hasPersonalityTrait(SLOVENLY) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u53d1\u97f3\u6a21\u7cca\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorBad(\u53d1\u97f3\u53d8\u6a21\u7cca\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }

        @Override
        public String getRemovalDescription(GameCharacter target) {
            return UtilText.parse(target, "<p style='text-align:center;'>" + (!target.hasPersonalityTrait(SLOVENLY) ? "[style.colourDisabled([npc.Name]\u5df2\u7ecf\u4e0d\u518d\u53d1\u97f3\u6a21\u7cca\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]" : "[npc.Name]\u610f\u8bc6\u5230\u81ea\u5df1[style.colourMinorGood(\u53d1\u97f3\u4e0d\u518d\u6a21\u7cca\u4e86)]\uff01") + "</p>", new ParserTag[0]);
        }
    };

    private boolean specialRequirements;
    private PersonalityCategory personalityCategory;
    private String name;
    private String description;
    private String gameplayInformation;
    private Colour colour;

    private PersonalityTrait(boolean specialRequirements, PersonalityCategory personalityCategory, String name, String description, String gameplayInformation, Colour colour) {
        this.specialRequirements = specialRequirements;
        this.personalityCategory = personalityCategory;
        this.name = name;
        this.description = description;
        this.gameplayInformation = gameplayInformation;
        this.colour = colour;
    }

    public PersonalityCategory getPersonalityCategory() {
        return this.personalityCategory;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription(GameCharacter character, boolean withGameplayInformation, boolean withMutuallyExclusiveInformation) {
        StringBuilder sb = new StringBuilder();
        sb.append(UtilText.parse(character, this.description, new ParserTag[0]));
        if (withGameplayInformation) {
            if (this.gameplayInformation != null && !this.gameplayInformation.isEmpty()) {
                sb.append("<br/>" + UtilText.parse(character, this.gameplayInformation, new ParserTag[0]));
            } else {
                sb.append("<br/>[style.italicsDisabled(\u6ca1\u6709\u6e38\u620f\u5185\u5b9e\u9645\u6548\u679c\u2026\u2026)]");
            }
        }
        if (withMutuallyExclusiveInformation && !this.getMutuallyExclusiveSettings().isEmpty()) {
            sb.append("<br/>[style.colourBad(\u76f8\u65a5\u5c5e\u6027)]\u662f");
            ArrayList<String> names = new ArrayList<String>();
            for (PersonalityTrait trait : this.getMutuallyExclusiveSettings()) {
                names.add("<span style='color:" + trait.getColour().toWebHexString() + ";'>" + trait.getName() + "</span>");
            }
            sb.append(Util.stringsToStringList(names, false) + "\uff01");
        }
        return sb.toString();
    }

    public Colour getColour() {
        return this.colour;
    }

    public abstract List<PersonalityTrait> getMutuallyExclusiveSettings();

    public abstract String getAdditionDescription(GameCharacter var1);

    public abstract String getRemovalDescription(GameCharacter var1);

    public boolean isSpecialRequirements() {
        return this.specialRequirements;
    }
}

