/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.pregnancy;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.misc.OffspringSeed;
import com.lilithsthrone.game.character.pregnancy.FertilisationType;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.PresetColour;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Litter
implements XMLSaving {
    private String id;
    private LocalDateTime conceptionDate;
    private LocalDateTime birthDate;
    private LocalDateTime incubationStartDate;
    private String motherId;
    private String fatherId;
    private String incubatorId;
    private int sonsMother;
    private int daughtersMother;
    private int sonsFather;
    private int daughtersFather;
    private FertilisationType fertilisationType;
    private List<String> offspring;
    private String birthedDescription;
    private AbstractSubspecies motherRace;
    private AbstractSubspecies fatherRace;

    public Litter(LocalDateTime conceptionDate, LocalDateTime birthDate, GameCharacter mother, GameCharacter father, FertilisationType fertilisationType, List<OffspringSeed> offspring) {
        this.id = mother.getId() + mother.getLittersGenerated();
        this.conceptionDate = LocalDateTime.of(conceptionDate.getYear(), conceptionDate.getMonth(), conceptionDate.getDayOfMonth(), 12, 0);
        this.birthDate = LocalDateTime.of(birthDate.getYear(), birthDate.getMonth(), birthDate.getDayOfMonth(), 12, 0);
        this.incubationStartDate = null;
        this.fertilisationType = fertilisationType;
        this.motherId = mother.getId();
        this.motherRace = mother.getSubspecies();
        if (father != null) {
            this.fatherId = father.getId();
            this.fatherRace = father.getSubspecies();
        } else {
            this.fatherId = "";
            this.fatherRace = null;
        }
        this.incubatorId = "";
        this.sonsMother = 0;
        this.daughtersMother = 0;
        this.sonsFather = 0;
        this.daughtersFather = 0;
        this.offspring = new ArrayList<String>();
        for (OffspringSeed os : offspring) {
            this.offspring.add(os.getId());
            if (os.isFeminine()) {
                if (os.isTakesAfterMother()) {
                    ++this.daughtersMother;
                    continue;
                }
                ++this.daughtersFather;
                continue;
            }
            if (os.isTakesAfterMother()) {
                ++this.sonsMother;
                continue;
            }
            ++this.sonsFather;
        }
        this.generateBirthedDescription();
    }

    public Litter(String id, LocalDateTime conceptionDate, LocalDateTime birthDate, String motherId, String fatherId, FertilisationType fertilisationType, int sonsMother, int daughtersMother, int sonsFather, int daughtersFather, List<String> offspring, AbstractSubspecies motherRace, AbstractSubspecies fatherRace, String birthedDescription) {
        this.id = id;
        this.conceptionDate = LocalDateTime.of(conceptionDate.getYear(), conceptionDate.getMonth(), conceptionDate.getDayOfMonth(), 12, 0);
        this.birthDate = LocalDateTime.of(birthDate.getYear(), birthDate.getMonth(), birthDate.getDayOfMonth(), 12, 0);
        this.incubationStartDate = null;
        this.motherId = motherId;
        this.fatherId = fatherId;
        this.incubatorId = "";
        this.fertilisationType = fertilisationType;
        this.sonsMother = sonsMother;
        this.daughtersMother = daughtersMother;
        this.sonsFather = sonsFather;
        this.daughtersFather = daughtersFather;
        this.offspring = offspring;
        this.motherRace = motherRace;
        this.fatherRace = fatherRace;
        this.birthedDescription = birthedDescription;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("litter");
        parentElement.appendChild(element);
        Element idElement = doc.createElement("id");
        element.appendChild(idElement);
        idElement.setTextContent(this.id);
        XMLUtil.createXMLElementWithValue(doc, element, "yearOfBirth", String.valueOf(this.getBirthDate().getYear()));
        XMLUtil.createXMLElementWithValue(doc, element, "monthOfBirth", this.getBirthDate().getMonth().toString());
        XMLUtil.createXMLElementWithValue(doc, element, "dayOfBirth", String.valueOf(this.getBirthDate().getDayOfMonth()));
        XMLUtil.createXMLElementWithValue(doc, element, "yearOfConception", String.valueOf(this.getConceptionDate().getYear()));
        XMLUtil.createXMLElementWithValue(doc, element, "monthOfConception", this.getConceptionDate().getMonth().toString());
        XMLUtil.createXMLElementWithValue(doc, element, "dayOfConception", String.valueOf(this.getConceptionDate().getDayOfMonth()));
        if (this.getIncubationStartDate() != null) {
            XMLUtil.createXMLElementWithValue(doc, element, "yearOfIncubationStart", String.valueOf(this.getIncubationStartDate().getYear()));
            XMLUtil.createXMLElementWithValue(doc, element, "monthOfIncubationStart", this.getIncubationStartDate().getMonth().toString());
            XMLUtil.createXMLElementWithValue(doc, element, "dayOfIncubationStart", String.valueOf(this.getIncubationStartDate().getDayOfMonth()));
        }
        XMLUtil.addAttribute(doc, element, "motherId", this.getMotherId());
        XMLUtil.addAttribute(doc, element, "fatherId", this.getFatherId());
        XMLUtil.addAttribute(doc, element, "incubatorId", this.getIncubatorId());
        XMLUtil.addAttribute(doc, element, "fertilisationType", this.getFertilisationType().toString());
        XMLUtil.addAttribute(doc, element, "sonsMother", String.valueOf(this.getSonsFromMother()));
        XMLUtil.addAttribute(doc, element, "daughtersMother", String.valueOf(this.getDaughtersFromMother()));
        XMLUtil.addAttribute(doc, element, "sonsFather", String.valueOf(this.getSonsFromFather()));
        XMLUtil.addAttribute(doc, element, "daughtersFather", String.valueOf(this.getDaughtersFromFather()));
        XMLUtil.addAttribute(doc, element, "motherRace", Subspecies.getIdFromSubspecies(this.getMotherRace()));
        XMLUtil.addAttribute(doc, element, "fatherRace", Subspecies.getIdFromSubspecies(this.getFatherRace()));
        XMLUtil.addAttribute(doc, element, "birthedDescription", this.getBirthedDescription());
        Element innerElement = doc.createElement("offspringList");
        element.appendChild(innerElement);
        for (String offspring : this.getOffspring()) {
            element = doc.createElement("offspring");
            innerElement.appendChild(element);
            XMLUtil.addAttribute(doc, element, "id", offspring);
        }
        return element;
    }

    public static Litter loadFromXML(Element parentElement, Document doc) {
        LocalDateTime loadedBirthDate;
        LocalDateTime loadedConceptionDate;
        int year;
        int day;
        String loadedId = "";
        if (parentElement.getElementsByTagName("id").item(0) != null) {
            loadedId = parentElement.getElementsByTagName("id").item(0).getTextContent();
        }
        Element element = (Element)parentElement.getElementsByTagName("offspringList").item(0);
        ArrayList<String> offspring = new ArrayList<String>();
        NodeList offSpringList = element.getElementsByTagName("offspring");
        for (int i = 0; i < offSpringList.getLength(); ++i) {
            Element e = (Element)offSpringList.item(i);
            offspring.add(e.getAttribute("id"));
        }
        AbstractSubspecies motherRace = Subspecies.HUMAN;
        AbstractSubspecies fatherRace = Subspecies.HUMAN;
        try {
            motherRace = Subspecies.getSubspeciesFromId(parentElement.getAttribute("motherRace"));
            fatherRace = Subspecies.getSubspeciesFromId(parentElement.getAttribute("fatherRace"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        LocalDateTime loadedIncubationStartDate = null;
        if (parentElement.getElementsByTagName("dayOfConception").getLength() > 0) {
            day = Integer.valueOf(((Element)parentElement.getElementsByTagName("dayOfConception").item(0)).getAttribute("value"));
            Month month = Month.valueOf(((Element)parentElement.getElementsByTagName("monthOfConception").item(0)).getAttribute("value"));
            year = Integer.valueOf(((Element)parentElement.getElementsByTagName("yearOfConception").item(0)).getAttribute("value"));
            loadedConceptionDate = LocalDateTime.of(year, month, day, 12, 0);
            day = Integer.valueOf(((Element)parentElement.getElementsByTagName("dayOfBirth").item(0)).getAttribute("value"));
            month = Month.valueOf(((Element)parentElement.getElementsByTagName("monthOfBirth").item(0)).getAttribute("value"));
            year = Integer.valueOf(((Element)parentElement.getElementsByTagName("yearOfBirth").item(0)).getAttribute("value"));
            loadedBirthDate = LocalDateTime.of(year, month, day, 12, 0);
        } else {
            int conceptionDay = Integer.valueOf(parentElement.getAttribute("dayOfConception"));
            loadedConceptionDate = Main.game.getStartingDate().plusDays(conceptionDay);
            int birthDay = Integer.valueOf(parentElement.getAttribute("dayOfBirth"));
            loadedBirthDate = Main.game.getStartingDate().plusDays(birthDay);
        }
        if (parentElement.getElementsByTagName("dayOfIncubationStart").getLength() > 0) {
            day = Integer.valueOf(((Element)parentElement.getElementsByTagName("dayOfIncubationStart").item(0)).getAttribute("value"));
            Month month = Month.valueOf(((Element)parentElement.getElementsByTagName("monthOfIncubationStart").item(0)).getAttribute("value"));
            year = Integer.valueOf(((Element)parentElement.getElementsByTagName("yearOfIncubationStart").item(0)).getAttribute("value"));
            loadedIncubationStartDate = LocalDateTime.of(year, month, day, 12, 0);
        }
        String birthedDescription = "";
        try {
            birthedDescription = parentElement.getAttribute("birthedDescription");
        }
        catch (Exception month) {
            // empty catch block
        }
        Litter litter = new Litter(loadedId, loadedConceptionDate, loadedBirthDate, parentElement.getAttribute("motherId"), parentElement.getAttribute("fatherId"), FertilisationType.NORMAL, Integer.valueOf(parentElement.getAttribute("sonsMother")), Integer.valueOf(parentElement.getAttribute("daughtersMother")), Integer.valueOf(parentElement.getAttribute("sonsFather")), Integer.valueOf(parentElement.getAttribute("daughtersFather")), offspring, motherRace, fatherRace, birthedDescription);
        if (parentElement.hasAttribute("incubatorId")) {
            litter.setIncubatorId(parentElement.getAttribute("incubatorId"));
        }
        if (parentElement.hasAttribute("fertilisationType")) {
            litter.setFertilisationType(FertilisationType.valueOf(parentElement.getAttribute("fertilisationType")));
        }
        if (loadedIncubationStartDate != null) {
            litter.setIncubationStartDate(loadedIncubationStartDate);
        }
        return litter;
    }

    public String getId() {
        return this.id;
    }

    public boolean isSelfImpregnation() {
        return this.getMotherId().equals(this.getFatherId());
    }

    public LocalDateTime getConceptionDate() {
        return this.conceptionDate;
    }

    public LocalDateTime getIncubationStartDate() {
        return this.incubationStartDate;
    }

    public void setIncubationStartDate(LocalDateTime incubationStartDate) {
        this.incubationStartDate = incubationStartDate;
    }

    public LocalDateTime getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(LocalDateTime birthDate) {
        this.birthDate = birthDate;
    }

    public String getMotherId() {
        return this.motherId;
    }

    public String getFatherId() {
        return this.fatherId;
    }

    public String getIncubatorId() {
        return this.incubatorId;
    }

    public void setIncubatorId(String incubatorId) {
        this.incubatorId = incubatorId;
    }

    public GameCharacter getIncubator() {
        try {
            return Main.game.getNPCById(this.incubatorId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public GameCharacter getMother() {
        try {
            return Main.game.getNPCById(this.motherId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isMotherId(String motherId) {
        return this.motherId.equals(motherId);
    }

    public GameCharacter getFather() {
        try {
            return Main.game.getNPCById(this.fatherId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isFather(GameCharacter potentialFather) {
        return Objects.equals(potentialFather, this.getFather());
    }

    public String getFatherName() {
        if (this.getFather() == null) {
            return "\u67d0\u4eba";
        }
        return this.getFather().getName();
    }

    public boolean isFatherId(String fatherId) {
        return this.fatherId.equals(fatherId);
    }

    public FertilisationType getFertilisationType() {
        return this.fertilisationType;
    }

    public void setFertilisationType(FertilisationType fertilisationType) {
        this.fertilisationType = fertilisationType;
    }

    public Set<GameCharacter> getOffspringCharacters() {
        HashSet<GameCharacter> result = new HashSet<GameCharacter>();
        this.offspring.stream().map(x -> {
            try {
                return Main.game.getNPCById((String)x);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).forEach(result::add);
        return result;
    }

    public Set<OffspringSeed> getOffspringSeed() {
        HashSet<OffspringSeed> result = new HashSet<OffspringSeed>();
        this.offspring.stream().map(x -> {
            try {
                return Main.game.getOffspringSeedById((String)x);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).forEach(result::add);
        return result;
    }

    public List<String> getOffspring() {
        return this.offspring;
    }

    public int getSonsFromMother() {
        return this.sonsMother;
    }

    public int getDaughtersFromMother() {
        return this.daughtersMother;
    }

    public int getSonsFromFather() {
        return this.sonsFather;
    }

    public int getDaughtersFromFather() {
        return this.daughtersFather;
    }

    public int getTotalLitterCount() {
        return this.sonsMother + this.daughtersMother + this.sonsFather + this.daughtersFather;
    }

    public AbstractSubspecies getMotherRace() {
        return this.motherRace;
    }

    public AbstractSubspecies getFatherRace() {
        return this.fatherRace;
    }

    public void setFatherRace(AbstractSubspecies fatherSubspecies) {
        this.fatherRace = fatherSubspecies;
    }

    public void generateBirthedDescription() {
        HashMap<CallSite, Integer> sons = new HashMap<CallSite, Integer>();
        HashMap<CallSite, Integer> feralSons = new HashMap<CallSite, Integer>();
        HashMap<CallSite, Integer> daughters = new HashMap<CallSite, Integer>();
        HashMap<CallSite, Integer> feralDaughters = new HashMap<CallSite, Integer>();
        String feralString = "<b style='color:" + RaceStage.FERAL.getColour().toWebHexString() + ";'>" + RaceStage.FERAL.getName() + "</b>";
        for (String id : this.getOffspring()) {
            try {
                String nameId;
                OffspringSeed offspring = Main.game.getOffspringSeedById(id);
                AbstractSubspecies subspecies = offspring.getSubspecies();
                if (offspring.isFeminine()) {
                    nameId = subspecies.getSingularFemaleName(offspring.getBody()) + "|" + subspecies.getPluralFemaleName(offspring.getBody());
                    if (offspring.isFeral()) {
                        feralDaughters.putIfAbsent((CallSite)((Object)nameId), 0);
                        feralDaughters.put((CallSite)((Object)nameId), (Integer)feralDaughters.get(nameId) + 1);
                        continue;
                    }
                    daughters.putIfAbsent((CallSite)((Object)nameId), 0);
                    daughters.put((CallSite)((Object)nameId), (Integer)daughters.get(nameId) + 1);
                    continue;
                }
                nameId = subspecies.getSingularMaleName(offspring.getBody()) + "|" + subspecies.getPluralMaleName(offspring.getBody());
                if (offspring.isFeral()) {
                    feralSons.putIfAbsent((CallSite)((Object)nameId), 0);
                    feralSons.put((CallSite)((Object)nameId), (Integer)feralSons.get(nameId) + 1);
                    continue;
                }
                sons.putIfAbsent((CallSite)((Object)nameId), 0);
                sons.put((CallSite)((Object)nameId), (Integer)sons.get(nameId) + 1);
            }
            catch (Exception offspring) {}
        }
        ArrayList<String> entries = new ArrayList<String>();
        for (Map.Entry entry : sons.entrySet()) {
            entries.add("<b>" + Util.intToString(((Integer)entry.getValue()).intValue()) + "</b>\u4e2a<b style='color:" + PresetColour.MASCULINE.toWebHexString() + ";'>" + ((Integer)entry.getValue() > 1 ? ((String)entry.getKey()).split("\\|")[1] : ((String)entry.getKey()).split("\\|")[0]) + "</b>");
        }
        for (Map.Entry entry : feralSons.entrySet()) {
            entries.add("<b>" + Util.intToString(((Integer)entry.getValue()).intValue()) + "</b>\u53ea" + feralString + "<b style='color:" + PresetColour.MASCULINE.toWebHexString() + ";'>" + ((Integer)entry.getValue() > 1 ? ((String)entry.getKey()).split("\\|")[1] : ((String)entry.getKey()).split("\\|")[0]) + "</b>");
        }
        for (Map.Entry entry : daughters.entrySet()) {
            entries.add("<b>" + Util.intToString(((Integer)entry.getValue()).intValue()) + "</b>\u4e2a<b style='color:" + PresetColour.FEMININE.toWebHexString() + ";'>" + ((Integer)entry.getValue() > 1 ? ((String)entry.getKey()).split("\\|")[1] : ((String)entry.getKey()).split("\\|")[0]) + "</b>");
        }
        for (Map.Entry entry : feralDaughters.entrySet()) {
            entries.add("<b>" + Util.intToString(((Integer)entry.getValue()).intValue()) + "</b>\u53ea" + feralString + "<b style='color:" + PresetColour.FEMININE.toWebHexString() + ";'>" + ((Integer)entry.getValue() > 1 ? ((String)entry.getKey()).split("\\|")[1] : ((String)entry.getKey()).split("\\|")[0]) + "</b>");
        }
        if (!entries.isEmpty()) {
            this.birthedDescription = Util.stringsToStringList(entries, false);
        }
    }

    public String getBirthedDescription() {
        if (this.birthedDescription == null || this.birthedDescription.isEmpty()) {
            this.generateBirthedDescription();
        }
        return this.birthedDescription;
    }
}

