/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.quests;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AffectionLevel;
import com.lilithsthrone.game.character.attributes.ObedienceLevel;
import com.lilithsthrone.game.character.npc.dominion.Arthur;
import com.lilithsthrone.game.character.npc.dominion.Helena;
import com.lilithsthrone.game.character.npc.dominion.Lilaya;
import com.lilithsthrone.game.character.npc.dominion.Scarlett;
import com.lilithsthrone.game.character.npc.dominion.Zaranix;
import com.lilithsthrone.game.character.npc.fields.Aurokaris;
import com.lilithsthrone.game.character.npc.fields.Lunexis;
import com.lilithsthrone.game.character.npc.fields.Ursa;
import com.lilithsthrone.game.character.npc.submission.DarkSiren;
import com.lilithsthrone.game.character.npc.submission.Lyssieth;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.quests.QuestType;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.places.dominion.enforcerHQ.BraxOffice;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.Lab;
import com.lilithsthrone.game.dialogue.places.submission.impFortress.ImpCitadelDialogue;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Quest {
    MAIN_PROLOGUE(QuestType.MAIN, 1, 5){

        @Override
        public String getName() {
            return "\u71ac\u8fc7\u4eca\u665a";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u7b54\u5e94\u8389\u8389\u59e8\u5988\u8981\u53c2\u52a0\u5979\u535a\u7269\u9986\u65b0\u5c55\u89c8\u7684\u5f00\u5e55\u5f0f\u3002\u4f60\u5fc5\u987b\u71ac\u8fc7\u4eca\u665a\u7684\u65e0\u804a\u65f6\u5149\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5728\u535a\u7269\u9986\u5ea6\u8fc7\u7684\u591c\u665a\u6bd4\u4f60\u60f3\u7684\u8981\u6f2b\u957f\u5f97\u591a\u3002\u4e00\u4e2a\u540d\u53eb\u8389\u8389\u4e1d\u7684\u795e\u79d8\u6076\u9b54\u8bf1\u9a97\u4f60\u7a7f\u8fc7\u4e00\u4e2a\u795e\u5947\u7684\u5165\u53e3\uff0c\u8fdb\u5165\u4e00\u4e2a\u5e73\u884c\u5b87\u5b99\u3002\u4f60\u5728\u4e00\u6761\u964c\u751f\u7684\u8857\u9053\u4e0a\u9192\u6765\uff0c\u4e4b\u540e\u88ab\u534a\u6076\u9b54\u201c\u8389\u83b1\u96c5\u201d\u4ece\u5371\u96be\u4e2d\u6551\u4e86\u51fa\u6765\u3002\u5979\u4f3c\u4e4e\u662f\u8fd9\u4e2a\u5b87\u5b99\u4e2d\u8389\u8389\u59e8\u5988\u7684\u5f02\u9762\u540c\u4f4d\u4f53\u3002\u5979\u628a\u4f60\u5b89\u7f6e\u5728\u5979\u5bb6\u91cc\uff0c\u4f5c\u4e3a\u534f\u52a9\u5979\u5b9e\u9a8c\u7684\u56de\u62a5\u3002";
        }
    }
    ,
    MAIN_1_A_LILAYAS_TESTS(QuestType.MAIN, 1, 10){

        @Override
        public String getName() {
            return "\u8389\u83b1\u96c5\u7684\u6d4b\u8bd5";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u53ef\u4ee5\u968f\u65f6\u5230\u8389\u83b1\u96c5\u7684\u5b9e\u9a8c\u5ba4\u627e\u5979\uff0c\u5979\u4f1a\u5728\u90a3\u91cc\u7ee7\u7eed\u5bf9\u4f60\u8fdb\u884c\u6d4b\u8bd5\u3002\u4e5f\u8bb8\u5979\u80fd\u627e\u5230\u9001\u4f60\u56de\u5bb6\u7684\u529e\u6cd5\uff1f";
        }

        @Override
        public String getCompletedDescription() {
            return "\u8389\u83b1\u96c5\u53c8\u5bf9\u4f60\u8fdb\u884c\u4e86\u4e00\u4e9b\u6d4b\u8bd5\uff0c\u4f46\u6ca1\u6709\u8001\u540c\u4e8b\u4e9a\u745f\u7684\u5e2e\u52a9\uff0c\u5979\u7684\u7814\u7a76\u65e0\u6cd5\u53d6\u5f97\u8fdb\u5c55\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
            ((Arthur)Main.game.getNpc(Arthur.class)).generateNewTile();
        }
    }
    ,
    MAIN_1_B_DEMON_HOME(QuestType.MAIN, 1, 10){

        @Override
        public String getName() {
            return "\u5bfb\u627e\u4e9a\u745f\uff1a\u6076\u9b54\u4e4b\u5bb6";
        }

        @Override
        public String getDescription() {
            return "\u8389\u83b1\u96c5\u544a\u8bc9\u4f60\uff0c\u5979\u7684\u8001\u540c\u4e8b\u4e9a\u745f\u4f1a\u66f4\u4e86\u89e3\u4f20\u9001\u95e8\u4e2d\u4f7f\u7528\u7684\u9b54\u6cd5\u7c7b\u578b\u3002\u4e0d\u8fc7\uff0c\u8389\u83b1\u96c5\u770b\u8d77\u6765\u5bf9\u4e9a\u745f\u5f88\u4e0d\u5f85\u89c1\u3002\u4f60\u7684\u4efb\u52a1\u5c31\u662f\u53bb\u627e\u5230\u4ed6\uff0c\u8ba9\u4ed6\u7ed9\u8389\u83b1\u96c5\u597d\u597d\u9053\u6b49\uff0c\u8fd9\u6837\u5979\u624d\u4f1a\u5bb9\u8bb8\u4ed6\u4e00\u8d77\u5171\u4e8b\u3002\u4e9a\u745f\u4f4f\u5728\u672c\u5e02\u201c\u6076\u9b54\u4e4b\u5bb6\u201d\u533a\u7684\u201c\u5723\u5c14\u8482\u65c5\u9986\u201d\uff0c\u53ef\u4ee5\u53bb\u90a3\u91cc\u627e\u4ed6\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u6765\u5230\u4e9a\u745f\u5bb6\u624d\u53d1\u73b0\u4ed6\u88ab\u6293\u4e86\u3002\u5fa1\u57ce\u533a\u6267\u6cd5\u8005\u4ee5\u6d89\u5acc\u5bc6\u8c0b\u53cd\u5bf9\u8389\u8389\u4e1d\u7684\u7f6a\u540d\u902e\u6355\u4e86\u4ed6\uff0c\u5e76\u79fb\u4ea4\u81f3\u6267\u6cd5\u8005\u603b\u90e8\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
        }
    }
    ,
    MAIN_1_C_WOLFS_DEN(QuestType.MAIN, 3, 20){

        @Override
        public String getName() {
            return "\u5bfb\u627e\u4e9a\u745f\uff1a\u52c7\u95ef\u72fc\u7a74";
        }

        @Override
        public String getDescription() {
            return "\u4e9a\u745f\u88ab\u5fa1\u57ce\u533a\u7684\u6267\u6cd5\u8005\u902e\u6355\uff0c\u5e76\u88ab\u5e26\u5230\u4e86\u6267\u6cd5\u8005\u603b\u90e8\u3002\u770b\u6765\u4f60\u5f97\u53bb\u90a3\u513f\u8fdb\u4e00\u6b65\u8be2\u95ee\u8be6\u60c5\uff0c\u5e76\u60f3\u529e\u6cd5\u6551\u51fa\u4e9a\u745f\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u88ab\u8feb\u9762\u5bf9\u5411\u7763\u67e5\u6267\u6cd5\u8005\uff0c\u5e03\u62c9\u514b\u65af\u3002\u8fd8\u597d\u4f60\u6253\u5f97\u8fc7\u4ed6\uff01\u4f46\u968f\u540e\u4fbf\u662f\u4e00\u4e2a\u5669\u8017\uff1a\u4e9a\u745f\u5df2\u88ab\u5356\u4e3a\u5974\u96b6\uff01";
        }

        @Override
        public void applySkipQuestEffects() {
            BraxOffice.setBraxsPostQuestStatus(false);
            BraxOffice.givePlayerEnforcerUniform(null, -1);
        }
    }
    ,
    MAIN_1_D_SLAVERY(QuestType.MAIN, 3, 10){

        @Override
        public String getName() {
            return "\u5bfb\u627e\u4e9a\u745f\uff1a\u6ca6\u4e3a\u5974\u96b6";
        }

        @Override
        public String getDescription() {
            return "\u5728\u51fb\u8d25\u5e03\u62c9\u514b\u65af\u540e\uff0c\u4f60\u53d1\u73b0\u4e86\u4e9a\u745f\u7684\u60c5\u62a5\uff0c\u4ed6\u88ab\u5f53\u505a\u5974\u96b6\u5356\u7ed9\u4e86\u53eb\u65af\u5609\u4e3d\u7684\u5974\u96b6\u8d29\u5b50\u3002\u4f60\u5fc5\u987b\u524d\u5f80\u5974\u96b6\u5df7\uff0c\u627e\u5230\u65af\u5609\u4e3d\uff0c\u5e76\u60f3\u529e\u6cd5\u89e3\u6551\u4e9a\u745f\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5728\u5974\u96b6\u5df7\u627e\u5230\u4e86\u54c8\u6bd4\u65af\u5609\u4e3d\uff0c\u5979\u662f\u4f60\u89c1\u8fc7\u7684\u6700\u7c97\u9c81\u7684\u4eba\u4e4b\u4e00\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
        }
    }
    ,
    MAIN_1_E_REPORT_TO_HELENA(QuestType.MAIN, 3, 30){

        @Override
        public String getName() {
            return "\u5bfb\u627e\u4e9a\u745f\uff1a\u62a5\u544a\u6d77\u4f26\u5a1c";
        }

        @Override
        public String getDescription() {
            return "\u5728\u5974\u96b6\u5df7\u627e\u5230\u65af\u5609\u4e3d\u540e\uff0c\u4f60\u53d1\u73b0\u4e9a\u745f\u5df2\u7ecf\u4e0d\u5728\u5979\u624b\u91cc\u4e86\u3002\u5979\u8981\u4f60\u53bb\u54c8\u6bd4\u4e4b\u5de2\u5411\u5979\u7684\u65cf\u957f\u6d77\u4f26\u5a1c\u62a5\u544a\uff0c\u5979\u7684\u751f\u610f\u5b8c\u5168\u5931\u8d25\u4e86\u3002\u4e0d\u7136\u7684\u8bdd\u5979\u534a\u70b9\u53e3\u98ce\u90fd\u4e0d\u4f1a\u6f0f\u7ed9\u4f60\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u628a\u65af\u5609\u4e3d\u7684\u9ebb\u70e6\u62a5\u544a\u7ed9\u4e86\u5979\u7684\u65cf\u957f\u6d77\u4f26\u5a1c\u3002\u5979\u4f3c\u4e4e\u5bf9\u65af\u5609\u4e3d\u6ca1\u6709\u591a\u5c11\u540c\u60c5\uff0c\u5f88\u5feb\u5c31\u98de\u8fc7\u53bb\u548c\u5979\u5f53\u9762\u8c08\u4e86\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
            Main.game.getNpc(Helena.class).setLocation(WorldType.SLAVER_ALLEY, PlaceType.SLAVER_ALLEY_SCARLETTS_SHOP);
            Main.game.getNpc(Helena.class).addSlave(Main.game.getNpc(Scarlett.class));
        }
    }
    ,
    MAIN_1_F_SCARLETTS_FATE(QuestType.MAIN, 3, 30){

        @Override
        public String getName() {
            return "\u5bfb\u627e\u4e9a\u745f\uff1a\u65af\u5609\u4e3d\u7684\u547d\u8fd0";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u9700\u8981\u56de\u5230\u65af\u5609\u4e3d\u7684\u5e97\u91cc\uff0c\u770b\u770b\u5979\u73b0\u5728\u600e\u4e48\u6837\u4e86\u3002\u5e0c\u671b\u6d77\u4f26\u5a1c\u6ca1\u6709\u5bf9\u5979\u592a\u82db\u523b\uff0c\u5979\u73b0\u5728\u4f1a\u613f\u610f\u544a\u8bc9\u4f60\u4e9a\u745f\u53d1\u751f\u4e86\u4ec0\u4e48\u4e8b\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u56de\u5230\u65af\u5609\u4e3d\u7684\u5546\u5e97\uff0c\u5374\u53d1\u73b0\u6d77\u4f26\u5a1c\u5df2\u7ecf\u5974\u5f79\u4e86\u5979\uff01";
        }

        @Override
        public void applySkipQuestEffects() {
            Main.game.getNpc(Helena.class).addSlave(Main.game.getNpc(Scarlett.class));
            Main.game.getNpc(Scarlett.class).setObedience(ObedienceLevel.POSITIVE_TWO_OBEDIENT.getMedianValue());
            Main.game.getNpc(Scarlett.class).resetInventory(true);
            AbstractClothing collar = Main.game.getItemGen().generateClothing("innoxia_bdsm_metal_collar", PresetColour.CLOTHING_BLACK_STEEL, false);
            collar.setSealed(true);
            Main.game.getNpc(Scarlett.class).equipClothingFromNowhere(collar, true, Main.game.getNpc(Helena.class));
            Main.game.getNpc(Scarlett.class).equipClothingFromNowhere(Main.game.getItemGen().generateClothing("innoxia_bdsm_ballgag", PresetColour.CLOTHING_PINK, false), true, Main.game.getNpc(Helena.class));
        }
    }
    ,
    MAIN_1_G_SLAVERY(QuestType.MAIN, 3, 30){

        @Override
        public String getName() {
            return "\u5bfb\u627e\u4e9a\u745f\uff1a\u5974\u96b6\u8eab\u4efd";
        }

        @Override
        public String getDescription() {
            return "\u6d77\u4f26\u5a1c\u613f\u610f\u628a\u65af\u5609\u4e3d\u5356\u7ed9\u4f60\uff0c\u8fd9\u4f3c\u4e4e\u662f\u4f60\u83b7\u5f97\u6240\u9700\u4fe1\u606f\u7684\u552f\u4e00\u9014\u5f84\u3002\u8981\u8d2d\u4e70\u65af\u5609\u4e3d\uff0c\u4f60\u9700\u8981\u6301\u6709\u8d29\u5974\u8bb8\u53ef\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u6d77\u4f26\u5a1c\u628a\u65af\u5609\u4e3d\u5356\u7ed9\u4e86\u4f60\u3002\u5982\u6b64\u4e00\u6765\uff0c\u4f60\u5373\u53ef\u547d\u4ee4\u65af\u5609\u4e3d\u544a\u8bc9\u4f60\uff0c\u4e9a\u745f\u5230\u5e95\u53d1\u751f\u4e86\u4ec0\u4e48\u4e8b\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
            AbstractClothing ballgag = Main.game.getNpc(Scarlett.class).getClothingInSlot(InventorySlot.MOUTH);
            if (ballgag != null) {
                ballgag.setSealed(false);
                Main.game.getNpc(Scarlett.class).unequipClothingIntoVoid(ballgag, true, (GameCharacter)Main.game.getNpc(Helena.class));
            }
            if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_SLAVERY)) {
                Main.game.getPlayer().startQuest(QuestLine.SIDE_SLAVERY);
            }
            ArrayList<Quest> slaverSkipQuests = Util.newArrayListOfValues(SIDE_SLAVER_NEED_RECOMMENDATION, SIDE_SLAVER_RECOMMENDATION_OBTAINED, SIDE_UTIL_COMPLETE);
            for (int i = 0; i < slaverSkipQuests.size() - 1; ++i) {
                Quest q = (Quest)((Object)slaverSkipQuests.get(i));
                if (Main.game.getPlayer().getQuest(QuestLine.SIDE_SLAVERY) != q) continue;
                q.applySkipQuestEffects();
                Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_SLAVERY, (Quest)((Object)slaverSkipQuests.get(i + 1)));
            }
            Main.game.getNpc(Scarlett.class).setAffection(Main.game.getNpc(Helena.class), (float)AffectionLevel.NEGATIVE_FIVE_LOATHE.getMedianValue());
            Main.game.getNpc(Scarlett.class).setObedience(ObedienceLevel.NEGATIVE_FOUR_DEFIANT.getMedianValue());
            Main.game.getNpc(Scarlett.class).setAffection(Main.game.getPlayer(), (float)AffectionLevel.NEGATIVE_FIVE_LOATHE.getMedianValue());
            Main.game.getPlayer().addSlave(Main.game.getNpc(Scarlett.class));
            Main.game.getNpc(Scarlett.class).setLocation(WorldType.SLAVER_ALLEY, PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION, true);
            ((Zaranix)Main.game.getNpc(Zaranix.class)).generateNewTile();
        }
    }
    ,
    MAIN_1_H_THE_GREAT_ESCAPE(QuestType.MAIN, 10, 200){

        @Override
        public String getName() {
            return "\u5bfb\u627e\u4e9a\u745f\uff1a\u9003\u79bb\u9b54\u722a";
        }

        @Override
        public String getDescription() {
            return "\u539f\u6765\uff0c\u4e9a\u745f\u88ab\u5356\u7ed9\u4e86\u4e00\u4e2a\u6781\u5176\u5371\u9669\u7684\u6076\u9b54\uff0c\u540d\u53eb\u624e\u62c9\u5c3c\u514b\u65af\uff0c\u4ed6\u4f4f\u5728\u6076\u9b54\u4e4b\u5bb6\u3002\u4f60\u9700\u8981\u524d\u5f80\u6076\u9b54\u4e4b\u5bb6\u8425\u6551\u4e9a\u745f\uff01";
        }

        @Override
        public String getCompletedDescription() {
            return "\u6253\u8d25\u624e\u62c9\u5c3c\u514b\u65af\u540e\uff0c\u4f60\u6551\u51fa\u4e86\u4e9a\u745f\uff0c\u5e76\u628a\u4ed6\u5e26\u56de\u4e86\u8389\u83b1\u96c5\u7684\u5bb6\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.zaranixDiscoveredHome, true);
            Main.game.getNpc(Arthur.class).setLocation(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_LAB, true);
        }
    }
    ,
    MAIN_1_I_ARTHURS_TALE(QuestType.MAIN, 1, 30){

        @Override
        public String getName() {
            return "\u5bfb\u627e\u4e9a\u745f\uff1a\u6765\u9f99\u53bb\u8109";
        }

        @Override
        public String getDescription() {
            return "\u65e2\u7136\u4f60\u5df2\u7ecf\u4ece\u624e\u62c9\u5c3c\u514b\u65af\u7684\u9b54\u638c\u4e2d\u6551\u51fa\u4e86\u4e9a\u745f\uff0c\u5c31\u5e94\u8be5\u56de\u5230\u8389\u83b1\u96c5\u7684\u5bb6\uff0c\u4ece\u4ed6\u90a3\u91cc\u4e86\u89e3\u4e8b\u60c5\u7684\u524d\u56e0\u540e\u679c\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4e9a\u745f\u89e3\u91ca\u4e86\u4ed6\u662f\u5982\u4f55\u6d89\u8db3\u4f20\u9001\u6cd5\u672f\u8fd9\u95e8\u7981\u672f\u7684\u3002\u624e\u62c9\u5c3c\u514b\u65af\u901a\u8fc7\u4ed6\u7684\u4e00\u540d\u7279\u5de5\u53d1\u73b0\u4e86\u8fd9\u4ef6\u4e8b\uff0c\u5e76\u6beb\u4e0d\u8d39\u529b\u5730\u4ee5\u53db\u56fd\u7f6a\u5c06\u4e9a\u745f\u5974\u5f79\u3002\u65e2\u7136\u4f60\u6551\u4e86\u4ed6\uff0c\u4ed6\u4e5f\u5f88\u60f3\u62a5\u7b54\u4f60\uff0c\u627e\u51fa\u9001\u4f60\u56de\u5bb6\u7684\u65b9\u6cd5\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
            Cell arthurRoomCell = Lab.addArthurRoom();
            Main.game.getNpc(Arthur.class).setLocation(arthurRoomCell, true);
        }
    }
    ,
    MAIN_1_J_ARTHURS_ROOM(QuestType.MAIN, 1, 30){

        @Override
        public String getName() {
            return "\u5bfb\u627e\u4e9a\u745f\uff1a\u4ed6\u7684\u623f\u95f4";
        }

        @Override
        public String getDescription() {
            return "\u8389\u83b1\u96c5\u771f\u7684\u4e0d\u60f3\u8ba9\u4e9a\u745f\u5f85\u5728\u5979\u7684\u5b9e\u9a8c\u5ba4\u91cc\uff0c\u5979\u59d4\u6258\u4f60\u5e2e\u841d\u4e1d\u627e\u4e2a\u5408\u9002\u7684\u623f\u95f4\u5b89\u6392\u4e9a\u745f\u4f4f\u4e0b\u3002<br/><i>\u8fdb\u5165\u8389\u83b1\u96c5\u7684\u5bb6\u7684\u4e00\u4e2a\u7a7a\u623f\u95f4\uff0c\u901a\u8fc7\u623f\u95f4\u7ba1\u7406\u7a97\u53e3\u5c06\u5176\u5347\u7ea7\u4e3a \u201c\u4e9a\u745f\u7684\u5367\u5ba4\u201d\u3002</i>";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u4e3a\u4e9a\u745f\u627e\u5230\u4e86\u4e00\u4e2a\u5408\u9002\u7684\u623f\u95f4\uff0c\u5e76\u5728\u841d\u4e1d\u7684\u5e2e\u52a9\u4e0b\uff0c\u628a\u5927\u91cf\u7684\u5965\u672f\u4eea\u5668\u642c\u8fdb\u4e86\u4ed6\u7684\u65b0\u5b9e\u9a8c\u5ba4\u517c\u5367\u5ba4\u3002";
        }
    }
    ,
    MAIN_2_A_INTO_THE_DEPTHS(QuestType.MAIN, 1, 10){

        @Override
        public String getName() {
            return "\u8fdb\u5165\u5c48\u57ce\u533a";
        }

        @Override
        public String getDescription() {
            return "\u4e9a\u745f\u80fd\u591f\u89e3\u91ca\u4f60\u88ab\u4f20\u9001\u5230\u8fd9\u4e2a\u65b0\u4e16\u754c\u7684\u673a\u5236\uff0c\u4f46\u4ed6\u4f3c\u4e4e\u5bf9\u4e00\u4e9b\u7ec6\u8282\u6709\u6240\u4fdd\u7559\u3002\u4ed6\u8bf4\uff0c\u4e00\u65e6\u4ed6\u786e\u5b9a\u53d1\u751f\u4e86\u4ec0\u4e48\u4e8b\uff0c\u4ed6\u5c31\u4f1a\u628a\u4e00\u5207\u90fd\u89e3\u91ca\u6e05\u695a\uff0c\u4f46\u8981\u505a\u5230\u8fd9\u4e00\u70b9\uff0c\u4ed6\u9700\u8981\u548c\u4e03\u4f4d\u8389\u7433\u957f\u8001\u4e2d\u7684\u4e00\u4f4d\u8c08\u8c08\u3002\u7ecf\u8fc7\u4e00\u756a\u4e89\u8bba\uff0c\u8389\u83b1\u96c5\u540c\u610f\u8bf4\u670d\u5979\u7684\u6bcd\u4eb2\u5e2e\u5fd9\uff0c\u4f46\u5fc5\u987b\u7531\u4f60\u6765\u4f20\u8bdd\u3002<br/><i>\u524d\u5f80\u5c48\u57ce\u533a\u6c34\u4e0b\u90fd\u5e02\uff0c\u6c42\u89c1\u8389\u83b1\u96c5\u7684\u6bcd\u4eb2\uff0c\u8389\u897f\u4e1d\u3002</i>";
        }

        @Override
        public String getCompletedDescription() {
            return "\u6839\u636e\u4e9a\u745f\u7684\u5efa\u8bae\uff0c\u4f60\u5192\u9669\u8fdb\u5165\u4e86\u5c48\u57ce\u533a\uff0c\u53d1\u73b0\u4e86\u8389\u897f\u4e1d\u5bab\u6bbf\u7684\u4f4d\u7f6e\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
            Main.game.getPlayer().addItem(Main.game.getItemGen().generateItem(ItemType.LYSSIETHS_RING), false);
        }
    }
    ,
    MAIN_2_B_SIRENS_CALL(QuestType.MAIN, 25, 300){

        @Override
        public String getName() {
            return "\u585e\u58ec\u7684\u547c\u5524";
        }

        @Override
        public String getDescription() {
            return "\u8389\u897f\u4e1d\u5bab\u6bbf\u95e8\u53e3\u7684\u5b88\u536b\u544a\u8bc9\u4f60\uff0c\u5979\u73b0\u5728\u4e0d\u63a5\u5f85\u4efb\u4f55\u8bbf\u5ba2\u3002\u8981\u5f97\u5230\u5979\u7684\u63a5\u89c1\uff0c\u552f\u4e00\u7684\u529e\u6cd5\u5c31\u662f\u89e3\u51b3\u5979\u7684\u9ebb\u70e6\u5973\u513f\u201c\u6697\u591c\u585e\u58ec\u201d\u3002\u76ee\u524d\uff0c\u5979\u4f4f\u5728\u5c48\u57ce\u533a\u4e2d\u5fc3\u96a7\u9053\u7684\u4e00\u4e2a\u77f3\u5934\u8981\u585e\u91cc\uff0c\u5e76\u4ece\u90a3\u91cc\u6d3e\u51fa\u5c0f\u6076\u9b54\u56e2\u4f19\u6050\u5413\u65e0\u8f9c\u5e02\u6c11\u3002</br>\u65e0\u8bba\u662f\u5802\u5802\u6b63\u6b63\u5730\u51b3\u6597\uff0c\u6291\u6216\u662f\u63d2\u5708\u5f04\u5957\u5730\u7b97\u8ba1\uff0c\u53ea\u8981\u4f60\u80fd\u5974\u5f79\u5979\uff0c\u4fbf\u80fd\u5f97\u5230\u8389\u897f\u4e1d\u7684\u63a5\u89c1\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u8bbe\u6cd5\u5974\u5f79\u4e86\u8389\u897f\u4e1d\u7684\u9ebb\u70e6\u5973\u513f\uff0c\u56e0\u6b64\u8d62\u5f97\u89d0\u89c1\u8389\u897f\u4e1d\u7684\u673a\u4f1a\uff01";
        }

        @Override
        public void applySkipQuestEffects() {
            Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.LYSSIETHS_RING));
            ImpCitadelDialogue.clearFortress(false);
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.impFortressAlphaDefeated, true);
            for (GameCharacter gameCharacter : Main.game.getCharactersPresent(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL)) {
                if (!gameCharacter.getHomeLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_IMP_TUNNELS_ALPHA)) continue;
                gameCharacter.returnToHome();
            }
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.impFortressFemalesDefeated, true);
            for (GameCharacter gameCharacter : Main.game.getCharactersPresent(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL)) {
                if (!gameCharacter.getHomeLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_IMP_TUNNELS_FEMALES)) continue;
                gameCharacter.returnToHome();
            }
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.impFortressMalesDefeated, true);
            for (GameCharacter gameCharacter : Main.game.getCharactersPresent(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL)) {
                if (!gameCharacter.getHomeLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_IMP_TUNNELS_MALES)) continue;
                gameCharacter.returnToHome();
            }
        }
    }
    ,
    MAIN_2_C_SIRENS_FALL(QuestType.MAIN, 1, 10){

        @Override
        public String getName() {
            return "\u585e\u58ec\u9677\u843d";
        }

        @Override
        public String getDescription() {
            return "\u8fd4\u56de\u8389\u897f\u4e1d\u7684\u5bab\u6bbf\u544a\u77e5\u5b88\u536b\uff0c\u4f60\u5df2\u5974\u5f79\u4e86\u201c\u6697\u591c\u585e\u58ec\u201d\u3002\u8fd9\u5e94\u8be5\u8db3\u4ee5\u8ba9\u4f60\u89d0\u89c1\u8389\u897f\u4e1d\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u56e0\u4e3a\u5974\u5f79\u4e86\u201c\u6697\u591c\u585e\u58ec\u201d\uff0c\u8389\u897f\u4e1d\u5bab\u6bbf\u95e8\u53e3\u7684\u5b88\u536b\u5141\u8bb8\u4f60\u8fdb\u5165\u5bab\u6bbf\u89d0\u89c1\u5979\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
            if (Main.game.getPlayer().hasItemType(ItemType.LYSSIETHS_RING)) {
                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.LYSSIETHS_RING));
            }
            if (!Main.game.getPlayer().hasClothingType(ClothingType.FINGER_LYSSIETHS_RING, true)) {
                Main.game.getPlayer().addClothing(Main.game.getItemGen().generateClothing(ClothingType.FINGER_LYSSIETHS_RING, false), false);
            }
        }
    }
    ,
    MAIN_2_D_MEETING_A_LILIN(QuestType.MAIN, 1, 100){

        @Override
        public String getName() {
            return "\u9762\u89c1\u8389\u7433";
        }

        @Override
        public String getDescription() {
            return "\u524d\u5f80\u8389\u897f\u4e1d\u7684\u5bab\u6bbf\uff0c\u8ffd\u5bfb\u6700\u7ec8\u7b54\u6848\uff1a\u4f60\u4e3a\u4ec0\u4e48\u4f1a\u5728\u8fd9\u91cc\uff0c\u5982\u4f55\u624d\u80fd\u56de\u5230\u539f\u6765\u7684\u4e16\u754c\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u8389\u897f\u4e1d\u900f\u9732\uff0c\u8fd9\u4e2a\u4e16\u754c\u5176\u5b9e\u5c31\u662f\u539f\u6765\u7684\u4e16\u754c\uff0c\u8389\u8389\u4e1d\u4ece\u955c\u5b50\u4e2d\u88ab\u91ca\u653e\u51fa\u6765\u540e\uff0c\u5c06\u73b0\u5b9e\u7684\u5386\u53f2\u6539\u5199\u4e86";
        }

        @Override
        public void applySkipQuestEffects() {
            ((DarkSiren)Main.game.getNpc(DarkSiren.class)).postDefeatReset();
            AbstractItemEffectType.getBookEffect(Main.game.getPlayer(), Subspecies.LILIN, null, false);
            Main.game.getNpc(Lyssieth.class).incrementAffection(Main.game.getPlayer(), 25.0f);
            Main.game.getNpc(Lilaya.class).incrementAffection(Main.game.getPlayer(), 10.0f);
            Main.game.getNpc(DarkSiren.class).incrementAffection(Main.game.getPlayer(), 10.0f);
            Main.game.getNpc(Arthur.class).incrementAffection(Main.game.getPlayer(), 10.0f);
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.firstReactionLiberate, true);
            if (Main.game.getNpc(DarkSiren.class).getAffection(Main.game.getPlayer()) < 0.0f) {
                Main.game.getNpc(DarkSiren.class).setAffection(Main.game.getPlayer(), 0.0f);
            }
        }
    }
    ,
    MAIN_3_ELIS(QuestType.MAIN, 1, 25){

        @Override
        public String getName() {
            return "\u76ee\u7684\u5730\uff1a\u4f0a\u5229\u65af";
        }

        @Override
        public String getDescription() {
            return "\u8389\u897f\u4e1d\u544a\u8bc9\u4f60\uff0c\u60f3\u6253\u8d25\u8389\u7433\u957f\u8001\u2014\u2014\u534a\u5929\u9a6c\u4eba\u9732\u5185\u7279\uff0c\u4f60\u9700\u8981\u5f97\u5230\u7c73\u8bfa\u5854\u8389\u4e1d\u7684\u5e2e\u52a9\uff0c\u5979\u662f\u7edf\u6cbb\u4f0a\u5229\u65af\u9547\u7684\u8389\u7433\u3002\u6885\u62c9\u514b\u897f\u4e1d\u5efa\u8bae\u5411\u5996\u72d0\u5bfb\u6c42\u5e2e\u52a9\uff0c\u4e0d\u8fc7\u4e5f\u5f97\u7b49\u4f60\u5230\u4e86\u4f0a\u5229\u65af\u518d\u505a\u6253\u7b97\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u8389\u897f\u4e1d\u544a\u8bc9\u4f60\uff0c\u60f3\u6253\u8d25\u8389\u7433\u957f\u8001\u2014\u2014\u534a\u5929\u9a6c\u4eba\u9732\u5185\u7279\uff0c\u4f60\u9700\u8981\u5f97\u5230\u7c73\u8bfa\u5854\u8389\u4e1d\u7684\u5e2e\u52a9\uff0c\u5979\u662f\u7edf\u6cbb\u4f0a\u5229\u65af\u9547\u7684\u8389\u7433\u3002\u4e3a\u6b64\uff0c\u4f60\u7b2c\u4e00\u6b21\u79bb\u5f00\u4e86\u5fa1\u57ce\u533a\u2026\u2026";
        }

        @Override
        public void applySkipQuestEffects() {
        }
    }
    ,
    MAIN_3_B_MEETING_MERAXIS(QuestType.MAIN, 1, 25){

        @Override
        public String getName() {
            return "\u5230\u7ea2\u9f99\u9152\u9986";
        }

        @Override
        public String getDescription() {
            return "\u5f53\u4f60\u79bb\u5f00\u5fa1\u57ce\u533a\u65f6\uff0c\u6885\u62c9\u514b\u897f\u4e1d\u8d70\u4e86\u8fc7\u6765\u3002\u5979\u8ba9\u4f60\u5230\u4f0a\u5229\u65af\u7684\u7ea2\u9f99\u9152\u9986\u6765\u627e\u5979\uff0c\u90a3\u91cc\u79bb\u5c0f\u9547\u7684\u4e1c\u5927\u95e8\u4e0d\u8fdc\u3002\u6885\u62c9\u514b\u897f\u4e1d\u8fd8\u8bf4\uff0c\u7b49\u4f60\u6765\u4e86\uff0c\u5979\u4f1a\u5b89\u6392\u4f60\u4e0e\u7c73\u8bfa\u5854\u8389\u4e1d\u89c1\u9762\uff0c\u4e5f\u4f1a\u7ed9\u4f60\u5b89\u6392\u597d\u4f4f\u5904\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5728\u7ea2\u9f99\u9152\u9986\u89c1\u5230\u4e86\u6885\u62c9\u514b\u897f\u4e1d\uff0c\u5979\u5728\u65c5\u5e97\u7684\u4e00\u697c\u79df\u4e86\u4e00\u95f4\u5c4b\u5b50\uff0c\u4f5c\u4e3a\u4f60\u7684\u4f4f\u6240\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
        }
    }
    ,
    MAIN_3_C_MEETING_MINOTALLYS(QuestType.MAIN, 1, 25){

        @Override
        public String getName() {
            return "\u4e0e\u7c73\u8bfa\u5854\u8389\u4e1d\u4f1a\u9762";
        }

        @Override
        public String getDescription() {
            return "\u6885\u62c9\u514b\u897f\u4e1d\u5b89\u6392\u4f60\u4e0e\u7c73\u8bfa\u5854\u8389\u4e1d\u4f1a\u9762\uff0c\u5171\u5546\u5a01\u80c1\u2014\u2014\u4f0a\u5229\u65af\u57ce\u7684\u9732\u5185\u7279\u3002\u5728[units.time(9)]-[units.time(18)]\u95f4\u7684\u4efb\u610f\u65f6\u523b\uff0c\u544a\u77e5\u6885\u62c9\u514b\u897f\u4e1d\u4f60\u5df2\u7ecf\u51c6\u5907\u597d\u53c2\u52a0\u4f1a\u9762\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u4e0e\u6885\u62c9\u514b\u897f\u4e1d\u524d\u5f80\u4e86\u4f0a\u5229\u65af\u7684\u5e02\u9547\u8bae\u4f1a\uff0c\u524d\u53bb\u89c1\u7c73\u8bfa\u5854\u8389\u4e1d\u3002\u800c\u5728\u90a3\uff0c\u4f60\u540c\u65f6\u89c1\u5230\u4e86\u5979\u7684\u4e2a\u4eba\u52a9\u7406\uff0c\u963f\u91cc\u6602\u3002\u7c73\u8bfa\u5854\u8389\u4e1d\u5bf9\u5f17\u6d1b\u4f0a\u7530\u91ce\u7684\u73b0\u72b6\u77e2\u53e3\u5426\u8ba4\uff0c\u5e76\u8868\u793a\u53ea\u6709\u5f53\u7279\u5f25\u65af\u5e93\u62c9\u53d7\u5230\u67d0\u79cd\u5a01\u80c1\u65f6\uff0c\u5979\u624d\u4f1a\u8003\u8651\u91c7\u53d6\u884c\u52a8\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
        }
    }
    ,
    MAIN_3_D_TO_THEMISCYRA(QuestType.MAIN, 1, 25){

        @Override
        public String getName() {
            return "\u524d\u5f80\u7279\u5f25\u65af\u5e93\u62c9";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u540c\u610f\u4e0e\u6885\u62c9\u514b\u897f\u4e1d\u4e00\u540c\u524d\u5f80\u7279\u5f25\u65af\u5e93\u62c9\uff0c\u53bb\u786e\u8ba4\u6b64\u5730\u662f\u5426\u53d7\u9732\u5185\u7279\u7684\u519b\u961f\u5a01\u80c1\u3002\u5f53\u4f60\u51c6\u5907\u597d\u4e4b\u540e\uff0c\u4f60\u9700\u8981\u4e0e\u6885\u62c9\u514b\u897f\u4e1d\u89c1\u9762\uff0c\u8ba9\u5979\u5e26\u4f60\u524d\u5f80\u90a3\u91cc\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u4e0e\u6885\u62c9\u514b\u897f\u4e1d\u4e00\u540c\u524d\u5f80\u7279\u5f25\u65af\u5e93\u62c9\uff0c\u4f46\u5728\u62b5\u8fbe\u524d\uff0c\u4f60\u4fbf\u53d1\u73b0\u90a3\u91cc\u5df2\u906d\u9732\u5185\u7279\u7684\u519b\u961f\u6467\u6bc1\u4e86\uff01";
        }

        @Override
        public void applySkipQuestEffects() {
            if (Main.game.getWorlds().get(WorldType.WORLD_MAP).getCell(PlaceType.getPlaceTypeFromId("innoxia_fields_themiscyra")) == null) {
                Main.game.getWorlds().get(WorldType.WORLD_MAP).getCell(11, 32).getPlace().setPlaceType(PlaceType.getPlaceTypeFromId("innoxia_fields_themiscyra"));
            }
        }
    }
    ,
    MAIN_3_E_THEMISCYRA_ATTACK(QuestType.MAIN, 1, 250){

        @Override
        public String getName() {
            return "\u4fdd\u62a4\u5973\u738b";
        }

        @Override
        public String getDescription() {
            return "\u5728\u4e0e\u6885\u62c9\u514b\u897f\u4e1d\u5206\u522b\u540e\uff0c\u4f60\u8ddf\u4e00\u540d\u540d\u4e3a\u5965\u7f57\u5361\u5229\u65af\u7684\u4e9a\u9a6c\u900a\u725b\u5973\u4e00\u540c\u5408\u4f5c\u3002\u4f60\u9700\u8981\u7a7f\u8d8a\u7279\u5f25\u65af\u5e93\u62c9\uff0c\u627e\u5230\u6885\u62c9\u514b\u897f\u4e1d\uff0c\u4ee5\u53ca\u4e4c\u8428\u2014\u2014\u4e9a\u9a6c\u900a\u4eba\u7684\u5973\u738b\uff0c\u5979\u5e94\u5f53\u5728\u5bab\u6bbf\u5185\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4e0e\u5965\u7f57\u5361\u5229\u65af\u7ed3\u4f34\u800c\u884c\uff0c\u4f60\u7a7f\u8d8a\u4e86\u7279\u5f25\u65af\u5e93\u62c9\uff0c\u627e\u5230\u4e86\u6885\u62c9\u514b\u897f\u4e1d\uff0c\u4e14\u5728\u5bab\u6bbf\u524d\u7684\u5e7f\u573a\u4e0a\u627e\u5230\u4e86\u4e4c\u8428\u3002\u5728\u9047\u5230\u9732\u5185\u7279\u519b\u961f\u7684\u9996\u9886\u9732\u5185\u514b\u897f\u4e1d\u540e\uff0c\u6885\u62c9\u514b\u897f\u4e1d\u5c06\u4f60\u4eec\u4e94\u4eba\u4f20\u9001\u56de\u4e86\u4f0a\u5229\u65af\u7684\u5e02\u9547\u8bae\u4f1a\uff0c\u800c\u7c73\u8bfa\u5854\u8389\u4e1d\u7ec8\u4e8e\u76f8\u4fe1\u9732\u5185\u7279\u4f1a\u5bf9\u4f0a\u5229\u65af\u9020\u6210\u5a01\u80c1\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
            if (Main.game.getWorlds().get(WorldType.getWorldTypeFromId("innoxia_fields_elis_town")).getCell(PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_amazon_camp")) == null) {
                Main.game.getWorlds().get(WorldType.getWorldTypeFromId("innoxia_fields_elis_town")).getCell(10, 20).getPlace().setPlaceType(PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_amazon_camp"));
            }
            Main.game.getNpc(Ursa.class).setLocation(WorldType.getWorldTypeFromId("innoxia_fields_elis_town"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_amazon_camp"), true);
            Main.game.getNpc(Aurokaris.class).setLocation(WorldType.getWorldTypeFromId("innoxia_fields_elis_town"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_amazon_camp"), true);
            Main.game.getNpc(Lunexis.class).setLocation(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, true);
        }
    }
    ,
    MAIN_3_F_PREPARING_ELIS(QuestType.MAIN, 1, 25){

        @Override
        public String getName() {
            return "SWORD\u7684\u63f4\u52a9";
        }

        @Override
        public String getDescription() {
            return "\u7531\u4e8e\u9732\u5185\u7279\u51c6\u5907\u5728\u4e0d\u4e45\u7684\u5c06\u6765\u653b\u6253\u4f0a\u5229\u65af\uff0c\u4f60\u544a\u8bc9\u7c73\u8bfa\u5854\u8389\u4e1d\u4f60\u4f1a\u5e2e\u52a9\u7ec4\u7ec7\u57ce\u9547\u7684\u9632\u5fa1\u3002\u4f60\u9700\u8981\u524d\u5f80\u4f0a\u5229\u65af\u7684\u6267\u6cd5\u8005\u7ad9\uff0c\u5411SWORD\u6267\u6cd5\u8005\u5c0f\u7ec4\u5bfb\u6c42\u5e2e\u52a9\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u524d\u5f80\u4f0a\u5229\u65af\u7684\u6267\u6cd5\u5c40\uff0c\u8bf7\u6c42SWORD\u6267\u6cd5\u8005\u5c0f\u7ec4\u5e2e\u52a9\u6574\u987f\u57ce\u9547\u7684\u9632\u5fa1\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
        }
    }
    ,
    MAIN_3_G_SWORD_SCAPEGOAT(QuestType.MAIN, 1, 25){

        @Override
        public String getName() {
            return "SWORD\u7684\u4ee3\u7f6a\u7f94\u7f8a";
        }

        @Override
        public String getDescription() {
            return "SWORD\u6267\u6cd5\u8005\u544a\u8bc9\u4f60\uff0c\u4e3a\u4e86\u8ba9\u4ed6\u4eec\u5e2e\u52a9\u4f60\uff0c\u4f60\u9996\u5148\u8981\u5e2e\u52a9\u4ed6\u4eec\u3002\u4f60\u8981\u8ddf\u53bb\u6267\u884c\u4e00\u9879\u884c\u52a8\uff0c\u963b\u6b62\u4e00\u4f4d\u8389\u7433\u957f\u8001\u7684\u5973\u513f\uff0c\u8fd9\u6837\u5982\u679c\u4ed6\u4eec\u88ab\u8ba4\u51fa\u6765\uff0c\u4f60\u5c31\u80fd\u5e2e\u4ed6\u4eec\u6446\u8131\u56f0\u5883\u3002\u4f60\u9700\u8981\u5728\u5468\u4e8c\u665a\u4e0a[units.time(17)]\u4e4b\u540e\u4e0e\u4ed6\u4eec\u5728\u6267\u6cd5\u5c40\u4f1a\u9762\uff0c\u4ee5\u5f00\u59cb\u884c\u52a8\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5728\u5468\u4e8c\u665a\u4e0a\u4e0eSWORD\u6267\u6cd5\u8005\u4f1a\u9762\uff0c\u8ddf\u968f\u4ed6\u4eec\u4e00\u8d77\u884c\u52a8\uff0c\u963b\u6b62\u4e00\u4f4d\u8389\u7433\u957f\u8001\u7684\u5973\u513f\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
        }
    }
    ,
    MAIN_3_H_SWORD_MISSION(QuestType.MAIN, 25, 250){

        @Override
        public String getName() {
            return "\u963b\u6b62\u9b45\u9b54";
        }

        @Override
        public String getDescription() {
            return "\u5728SWORD\u6267\u6cd5\u8005\u6e05\u7406\u9b45\u9b54\u603b\u90e8\u7684\u65f6\u5019\uff0c\u4f60\u9700\u8981\u548c\u4ed6\u4eec\u5f85\u5728\u4e00\u8d77\u3002\u4f60\u4e0d\u9700\u8981\u6218\u6597\uff0c\u4f46\u4f60\u82e5\u7ed9\u6267\u6cd5\u8005\u4eec\u4e00\u4e9b\u652f\u63f4\u7684\u8bdd\uff0c\u53ef\u80fd\u4f1a\u8d62\u5f97\u4ed6\u4eec\u7684\u611f\u8c22\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u4e0eSWORD\u6267\u6cd5\u8005\u534f\u529b\u5408\u4f5c\uff0c\u6e05\u7406\u7740\u9b45\u9b54\u7684\u603b\u90e8\u3002\u867d\u7136\u5979\u9003\u8131\u4e86\uff0c\u4f46\u4f60\u4e5f\u5f7b\u5e95\u4e2d\u6b62\u4e86\u4ee5\u5979\u4e3a\u9996\u7684\u975e\u6cd5\u5974\u5f79\u6d3b\u52a8\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
        }
    }
    ,
    MAIN_3_I_ARION_REPORT(QuestType.MAIN, 1, 25){

        @Override
        public String getName() {
            return "\u62a5\u544a\u7c73\u8bfa\u5854\u8389\u4e1d";
        }

        @Override
        public String getDescription() {
            return "[style.italicsBad(\u4e3b\u7ebf\u4efb\u52a1\u6682\u65f6\u5230\u6b64\u4e3a\u6b62\uff01\u5f88\u5feb\u5c31\u4f1a\u66f4\u65b0\uff01)]<br/>\u73b0\u5728SWORD\u6267\u6cd5\u8005\u4eec\u6b63\u5728\u4e3a\u57ce\u9547\u7684\u9632\u5fa1\u505a\u51c6\u5907\uff0c\u4f60\u9700\u8981\u56de\u5230\u5e02\u653f\u5385\u5411\u7c73\u8bfa\u5854\u8389\u4e1d\u62a5\u544a\u6b64\u4e8b\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "-";
        }
    }
    ,
    MAIN_3_J_TODO(QuestType.MAIN, 1, 25){

        @Override
        public String getName() {
            return "";
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public String getCompletedDescription() {
            return "-";
        }
    }
    ,
    SIDE_UTIL_COMPLETE(QuestType.SIDE, 1, 0){

        @Override
        public String getName() {
            return "\u4efb\u52a1\u5b8c\u6210\uff01";
        }

        @Override
        public String getDescription() {
            return "\u4efb\u52a1\u5b8c\u6210\uff01";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4efb\u52a1\u5b8c\u6210\uff01";
        }
    }
    ,
    SIDE_DISCOVER_ALL_ITEMS(QuestType.SIDE, 1, 100){

        @Override
        public String getName() {
            return "\u5706\u6ee1\u4e3b\u4e49\u8005";
        }

        @Override
        public String getDescription() {
            return "\u5728\u8fd9\u4e2a\u65b0\u4e16\u754c\u91cc\uff0c\u6709\u8bb8\u591a\u5947\u7279\u7684\u7269\u54c1\u3002\u4f60\u5728\u60f3\u81ea\u5df1\u80fd\u5426\u628a\u5b83\u4eec\u90fd\u627e\u51fa\u6765\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5df2\u7ecf\u53d1\u73b0\u4e86\u6240\u6709\u53ef\u4ee5\u627e\u5230\u7684\u7269\u54c1\uff01";
        }
    }
    ,
    SIDE_DISCOVER_ALL_RACES(QuestType.SIDE, 1, 100){

        @Override
        public String getName() {
            return "\u5706\u6ee1\u4e3b\u4e49\u8005";
        }

        @Override
        public String getDescription() {
            return "\u8fd9\u4e2a\u4e16\u754c\u4e0a\u4f3c\u4e4e\u6709\u5f88\u591a\u5947\u602a\u7684\u65b0\u79cd\u65cf\u3002\u4f60\u60f3\u77e5\u9053\u81ea\u5df1\u662f\u5426\u80fd\u53d1\u73b0\u5168\u90e8\u7684\u79cd\u65cf\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u4eec\u53d1\u73b0\u4e86\u6240\u6709\u53ef\u4ee5\u627e\u5230\u7684\u79cd\u65cf\uff01";
        }
    }
    ,
    SIDE_ENCHANTMENTS_LILAYA_HELP(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u5411\u8389\u83b1\u96c5\u5bfb\u6c42\u5e2e\u52a9";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u6700\u8fd1\u611f\u89c9\u6709\u4e00\u80a1\u5947\u602a\u7684\u529b\u91cf\u8fdb\u5165\u4e86\u4f60\u7684\u8eab\u4f53\uff0c\u867d\u7136\u5b83\u4f3c\u4e4e\u6ca1\u6709\u4ea7\u751f\u4efb\u4f55\u660e\u663e\u7684\u5f71\u54cd\uff0c\u4f46\u4f60\u8fd8\u662f\u5e94\u8be5\u53bb\u68c0\u67e5\u4e00\u4e0b\u3002\u8389\u83b1\u96c5\u80af\u5b9a\u4f1a\u77e5\u9053\u66f4\u591a\uff0c\u4e5f\u8bb8\u4f60\u5e94\u8be5\u53bb\u548c\u5979\u8c08\u8c08\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u8389\u83b1\u96c5\u544a\u8bc9\u4f60\uff0c\u4f60\u53ef\u4ee5\u4ece\u5176\u4ed6\u4eba\u7684\u5965\u672f\u7075\u6c14\u5f53\u4e2d\u6536\u96c6\u201c\u7cbe\u534e\u201d\u3002\u5979\u4f3c\u4e4e\u6709\u70b9\u62c5\u5fc3\u4f60\u80fd\u505a\u5230\u8fd9\u4e00\u70b9\uff0c\u56e0\u4e3a\u901a\u5e38\u53ea\u6709\u8389\u7433\u624d\u80fd\u7528\u8fd9\u79cd\u65b9\u5f0f\u6536\u96c6\u7cbe\u534e\u2026\u2026";
        }
    }
    ,
    SIDE_PREGNANCY_CONSULT_LILAYA(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u8389\u83b1\u96c5\u6700\u6e05\u695a";
        }

        @Override
        public String getDescription() {
            return "\u8fd9\u4e0d\u53ef\u80fd\u2026\u2026\u4f60\u6000\u5b55\u4e86\uff1f\u4f60<b>\u6000\u5b55</b>\u4e86\uff01\u8389\u83b1\u96c5\u80af\u5b9a\u77e5\u9053\u8be5\u600e\u4e48\u505a\uff1f\uff01";
        }

        @Override
        public String getCompletedDescription() {
            return "\u8389\u83b1\u96c5\u8bbe\u6cd5\u8ba9\u4f60\u5e73\u9759\u4e0b\u6765\uff0c\u5e76\u5b89\u6170\u4f60\u8bf4\uff0c\u5728\u8fd9\u4e2a\u4e16\u754c\u4e0a\uff0c\u6000\u5b55\u5e76\u4e0d\u50cf\u5728\u8001\u5bb6\u90a3\u6837\u662f\u4ef6\u5927\u4e8b\u3002";
        }
    }
    ,
    SIDE_PREGNANCY_LILAYA_THE_MIDWIFE(QuestType.SIDE, 1, 20){

        @Override
        public String getName() {
            return "\u52a9\u4ea7\u58eb\u8389\u83b1\u96c5";
        }

        @Override
        public String getDescription() {
            return "\u8389\u83b1\u96c5\u8bf4\uff0c\u53ea\u8981\u4f60\u51c6\u5907\u597d\u4e86\uff0c\u5979\u5c31\u80fd\u5e2e\u4f60\u751f\u4ea7\u3002\u4f60\u9700\u8981\u7b49\u5230\u809a\u5b50\u4e0d\u518d\u53d8\u5927\u540e\uff0c\u518d\u53bb\u627e\u8389\u83b1\u96c5\u751f\u4ea7\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u8389\u83b1\u96c5\u5e2e\u4f60\u751f\u4e86\u5b69\u5b50\u3002\u5979\u8bf4\uff0c\u5982\u679c\u4f60\u518d\u6b21\u6000\u5b55\uff0c\u5979\u53ef\u4ee5\u968f\u65f6\u5e2e\u5fd9\u3002";
        }
    }
    ,
    SIDE_INCUBATION_WAITING(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u6d3b\u4f53\u5b75\u5375\u5668";
        }

        @Override
        public String getDescription() {
            return "\u6beb\u65e0\u7591\u95ee\uff0c\u4f60\u7684\u4f53\u5185\u5df2\u7ecf\u690d\u5165\u4e86\u4e00\u7a9d\u5375\uff01\u9664\u4e86\u7b49\u5f85\u5b83\u4eec\u6210\u719f\uff0c\u7136\u540e\u4ea7\u4e0b\u5b83\u4eec\u4e4b\u5916\uff0c\u4f60\u522b\u65e0\u4ed6\u6cd5\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u7b49\u5f85\u690d\u5165\u4f53\u5185\u7684\u5375\u5b50\u6210\u719f\uff0c\u7136\u540e\u6210\u529f\u4ea7\u5375\u5e76\u5b75\u5316\u4e86\u8fd9\u4e9b\u5375\uff01";
        }
    }
    ,
    SIDE_SLAVER_NEED_RECOMMENDATION(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u63a8\u8350\u4fe1";
        }

        @Override
        public String getDescription() {
            return "\u5728\u5974\u96b6\u7ba1\u7406\u5927\u697c\u8be2\u95ee\u5982\u4f55\u83b7\u5f97\u5974\u96b6\u6267\u7167\u540e\uff0c\u4f60\u53d1\u73b0\u9996\u5148\u9700\u8981\u4e00\u5c01\u63a8\u8350\u4fe1\u3002\u8389\u83b1\u96c5\u5e94\u8be5\u80fd\u5e2e\u4e0a\u5fd9\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u8389\u83b1\u96c5\u7ed9\u4e86\u4f60\u4e00\u5c01\u63a8\u8350\u4fe1\uff0c\u66f4\u91cd\u8981\u7684\u662f\uff0c\u5979\u8fd8\u63d0\u51fa\u8ba9\u4f60\u5728\u5979\u7684\u5b85\u90b8\u91cc\u5b89\u7f6e\u4f60\u7684\u5974\u96b6\u3002";
        }

        @Override
        public void applySkipQuestEffects() {
            Main.game.getDialogueFlags().values.add(DialogueFlagValue.finchIntroduced);
        }
    }
    ,
    SIDE_SLAVER_RECOMMENDATION_OBTAINED(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u9012\u4ea4\u4fe1\u4ef6";
        }

        @Override
        public String getDescription() {
            return "\u73b0\u5728\u4f60\u5df2\u7ecf\u4ece\u8389\u83b1\u96c5\u90a3\u91cc\u62ff\u5230\u4e86\u63a8\u8350\u4fe1\uff0c\u4f60\u5e94\u8be5\u56de\u5230\u5974\u96b6\u5df7\u7684\u5974\u96b6\u7ba1\u7406\u5927\u697c\uff0c\u628a\u5b83\u4ea4\u7ed9[finch.name]\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5411[finch.name]\u63d0\u4ea4\u4e86\u63a8\u8350\u4fe1\uff0c\u5e76\u5728\u652f\u4ed8\u8d39\u7528\u540e\u83b7\u5f97\u4e86\u5974\u96b6\u8bb8\u53ef\u8bc1\uff01";
        }

        @Override
        public void applySkipQuestEffects() {
            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(Main.game.getItemGen().generateItem(ItemType.SLAVER_LICENSE), false));
        }
    }
    ,
    SIDE_ACCOMMODATION_NEED_LILAYAS_PERMISSION(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u5973\u623f\u4e1c\u8389\u83b1\u96c5";
        }

        @Override
        public String getDescription() {
            return "\u8389\u83b1\u96c5\u7684\u8c6a\u5b85\u91cc\u6709\u5f88\u591a\u7a7a\u623f\u95f4\uff0c\u53ef\u4ee5\u7528\u4f5c\u5ba2\u4eba\u7684\u4f4f\u6240\u3002\u4f60\u5e94\u8be5\u95ee\u95ee\u5979\uff0c\u4f60\u662f\u5426\u53ef\u4ee5\u7528\u8fd9\u4e9b\u623f\u95f4\u6765\u5b89\u7f6e\u4f60\u7684\u4eb2\u670b\u597d\u53cb\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u8389\u83b1\u96c5\u5141\u8bb8\u4f60\u4f7f\u7528\u7a7a\u623f\u95f4\u5b89\u7f6e\u4f60\u7684\u670b\u53cb\u548c\u5bb6\u4eba\uff0c\u6761\u4ef6\u662f\u4f60\u5fc5\u987b\u652f\u4ed8\u7531\u6b64\u4ea7\u751f\u7684\u8d39\u7528\u3002";
        }
    }
    ,
    SIDE_DOLL_STORAGE_ASK_FOR_SPACE(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u73a9\u5076\u53bb\u5f80\u4f55\u65b9\uff1f";
        }

        @Override
        public String getDescription() {
            return "\u867d\u7136\u8389\u83b1\u96c5\u7684\u8c6a\u5b85\u91cc\u6709\u4e0d\u5c11\u53ef\u4ee5\u5b58\u653e\u73a9\u5076\u7684\u7a7a\u623f\u95f4\uff0c\u4f46\u5728\u4f60\u628a\u73a9\u5076\u5e26\u56de\u5bb6\u4e4b\u524d\uff0c\u6700\u597d\u8fd8\u662f\u5148\u5f81\u5f97\u5979\u7684\u540c\u610f\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u8389\u83b1\u96c5\u5141\u8bb8\u4f60\u4f7f\u7528\u7a7a\u95f2\u623f\u95f4\u6765\u5b58\u653e\u4f60\u8d2d\u4e70\u7684\u6240\u6709\u73a9\u5076\u3002";
        }
    }
    ,
    SIDE_HYPNO_WATCH_VICKY(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u5965\u672f\u827a\u672f\u7684\u8ba2\u5355";
        }

        @Override
        public String getDescription() {
            return "\u4e9a\u745f\u544a\u8bc9\u4f60\uff0c\u624e\u62c9\u5c3c\u514b\u65af\u6307\u793a\u4ed6\u5bfb\u627e\u4e00\u79cd\u6539\u53d8\u4eba\u6027\u53d6\u5411\u7684\u5965\u672f\u65b9\u6cd5\u3002\u867d\u7136\u4ed6\u5411\u4f60\u4fdd\u8bc1\uff0c\u4ed6\u672c\u4eba\u65e0\u610f\u4f7f\u7528\u8fd9\u79cd\u7269\u54c1\uff0c\u4f46\u4e9a\u745f\u786e\u5b9e\u8868\u793a\u6709\u5174\u8da3\u5b8c\u6210\u4ed6\u7684\u7814\u7a76\uff0c\u5e76\u8ba9\u4f60\u53bb\u8d2d\u7269\u4e2d\u5fc3\u91cc\u7684\u201c\u5965\u672f\u827a\u672f\u201d\u5e97\u53d6\u4e00\u4efd\u7279\u522b\u8ba2\u5355\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u4ece\u201c\u5965\u672f\u827a\u672f\u201d\u90a3\u91cc\u53d6\u56de\u4e86\u5305\u88f9\uff0c\u5e76\u628a\u5b83\u5e26\u56de\u7ed9\u4e9a\u745f\u3002";
        }
    }
    ,
    SIDE_HYPNO_WATCH_TEST_SUBJECT(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u6d4b\u8bd5\u7528\u5177";
        }

        @Override
        public String getDescription() {
            return "\u8389\u83b1\u96c5\u6309\u7167\u4e9a\u745f\u7684\u6307\u793a\u7ed9\u6000\u8868\u9644\u9b54\u540e\uff0c\u5979\u95ee\u662f\u5426\u53ef\u4ee5\u5728\u4f60\u8eab\u4e0a\u6d4b\u8bd5\u4e00\u4e0b\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u50ac\u7720\u6000\u8868\u4f3c\u4e4e\u8d77\u4e86\u4f5c\u7528\uff0c\u4e0d\u8fc7\u8389\u83b1\u96c5\u5728\u5b83\u4ea7\u751f\u6c38\u4e45\u6027\u6548\u679c\u4e4b\u524d\u5c31\u505c\u6b62\u4e86\u6d4b\u8bd5\u3002\u5979\u8b66\u544a\u8bf4\uff0c\u50ac\u7720\u6000\u8868\u4f1a\u5bf9\u76ee\u6807\u7684\u601d\u60f3\u65bd\u52a0\u5f3a\u70c8\u7684\u5815\u843d\u6548\u679c\uff0c\u5728\u5c06\u6000\u8868\u4ea4\u7ed9\u4f60\u4e4b\u524d\uff0c\u5979\u987a\u4fbf\u89e3\u9664\u4e86\u4e0a\u9762\u7684\u9644\u9b54\u3002";
        }
    }
    ,
    LIGHTNING_SPELL_1_PAYMENT(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u529b\u91cf\u7684\u4ee3\u4ef7";
        }

        @Override
        public String getDescription() {
            return "\u4e9a\u745f\u5411\u4f60\u5c55\u793a\u4e86\u5728\u6267\u6cd5\u8005\u4ed3\u5e93\u627e\u5230\u7684\u5965\u672f\u95ea\u7535\u7403\uff0c\u5e76\u544a\u8bc9\u4f60\u53ef\u4ee5\u5b66\u4e60\u5176\u4e2d\u7684\u95ea\u7535\u6cd5\u672f\u79d8\u5bc6\u3002\u5c3d\u7ba1\u7531\u6b64\u5f97\u5230\u7684\u6cd5\u672f\u5c06\u6bd4\u95ea\u7535\u7403\u7684\u5a01\u529b\u66f4\u5f3a\u5927\uff0c\u4e9a\u745f\u5411\u4f60\u89e3\u91ca\uff0c\u8fd9\u6837\u7684\u6c72\u53d6\u4e0d\u6b62\u9700\u8981\u6781\u5927\u91cf\u7684\u5965\u672f\u7cbe\u534e\uff0c\u540c\u65f6\u4e5f\u4f1a\u6c38\u8fdc\u79fb\u9664\u7403\u4f53\u56fa\u6709\u7684\u6cd5\u672f\u3002<br/>\u5f53\u4f60\u53ef\u4ee5\u5e76\u613f\u610f\u8fd9\u6837\u505a\u65f6\uff0c\u7ed9\u4e9a\u745f\u4e00\u4e2a\u5965\u672f\u95ea\u7535\u7403\u5e76\u8ba9\u4ed6\u4ece\u4f60\u7684\u7075\u6c14\u5185\u6c72\u53d6500\u5965\u672f\u7cbe\u534e\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u7ed9\u4e86\u4e9a\u745f\u4ece\u6267\u6cd5\u8005\u4ed3\u5e93\u627e\u6765\u7684\u5965\u672f\u95ea\u7535\u7403\uff0c\u540c\u65f6\u8ba9\u4ed6\u4ece\u4f60\u7684\u7075\u6c14\u4e2d\u6c72\u53d6\u4e86500\u5965\u672f\u7cbe\u534e\u3002\u4f5c\u4e3a\u4ea4\u6362\uff0c\u4f60\u88ab\u8bb8\u8bfa\u4e86\u4e00\u4e2a\u5f3a\u5927\u7684\u5965\u672f\u95ea\u7535\u6cd5\u672f";
        }
    }
    ,
    LIGHTNING_SPELL_2_WAITING(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u95ea\u7535\u63d0\u53d6";
        }

        @Override
        public String getDescription() {
            return "\u4e9a\u745f\u544a\u8bc9\u4f60\uff0c\u4ece\u95ea\u7535\u7403\u5185\u83b7\u53d6\u5965\u672f\u95ea\u7535\u7684\u79d8\u5bc6\u9700\u8981\u4e00\u4e9b\u65f6\u95f4\u3002\u4f60\u9700\u8981\u5728\u4e24\u5468\u540e\u56de\u6765\u627e\u4ed6\uff0c\u770b\u770b\u4ed6\u7684\u7814\u7a76\u5f97\u5230\u4e86\u4ec0\u4e48\u6210\u679c\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4e9a\u745f\u5174\u594b\u5730\u544a\u8bc9\u4f60\uff0c\u4ed6\u4e0d\u4ec5\u4ece\u95ea\u7535\u7403\u4e0a\u63d0\u53d6\u51fa\u4e24\u79cd\u5965\u672f\u95ea\u7535\u7684\u79d8\u5bc6\uff0c\u800c\u4e14\u8fd8\u80fd\u5c06\u5269\u4f59\u529b\u91cf\u8f6c\u79fb\u5230\u4e00\u4e2a\u8f83\u5c0f\u7684\u6c34\u6676\u4e2d\uff0c\u5e76\u5c06\u5176\u9576\u5728\u4e00\u4e2a\u6212\u6307\u4e0a\u7ed9\u4e86\u4f60\u3002";
        }
    }
    ,
    HARPY_PACIFICATION_ONE(QuestType.SIDE, 6, 25){

        @Override
        public String getName() {
            return "\u6df7\u4e71\u4e2d\u7684\u5de2\u7a74";
        }

        @Override
        public String getDescription() {
            return "\u6267\u6cd5\u8005\u544a\u8bc9\u4f60\uff0c\u54c8\u6bd4\u4e4b\u5de2\u76ee\u524d\u975e\u5e38\u5371\u9669\u3002\u7ecf\u8fc7\u8fdb\u4e00\u6b65\u7684\u8be2\u95ee\uff0c\u4f60\u53d1\u73b0\u80fd\u8ba9\u4e09\u4f4d\u65cf\u957f\u5e73\u9759\u4e0b\u6765\u7684\u4eba\u53ef\u4ee5\u83b7\u5f97\u4e30\u539a\u7684\u5956\u52b1\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5df2\u7ecf\u63a7\u5236\u4e86\u5176\u4e2d\u4e00\u4e2a\u54c8\u6bd4\u5de2\u7a74\uff01";
        }
    }
    ,
    HARPY_PACIFICATION_TWO(QuestType.SIDE, 6, 25){

        @Override
        public String getName() {
            return "\u89e3\u51b3\u4e00\u4e2a\uff0c\u8fd8\u5269\u4e24\u4e2a";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5df2\u7ecf\u6210\u529f\u7684\u201c\u5b89\u629a\u201d\u4e86\u4e00\u4f4d\u54c8\u6bd4\u65cf\u957f\uff0c\u4f46\u8fd8\u6709\u4e24\u4f4d\u7b49\u7740\u4f60\u53bb\u201c\u5b89\u629a\u201d\u5462\uff01";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5df2\u7ecf\u63a7\u5236\u4e86\u4e24\u4e2a\u54c8\u6bd4\u5de2\u7a74\uff01";
        }
    }
    ,
    HARPY_PACIFICATION_THREE(QuestType.SIDE, 6, 25){

        @Override
        public String getName() {
            return "\u8fd8\u5269\u4e00\u4f4d\u65cf\u957f";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5df2\u7ecf\u6210\u529f\u7684\u201c\u5b89\u629a\u201d\u4e86\u4e24\u4f4d\u4f4d\u54c8\u6bd4\u65cf\u957f\uff0c\u8fd8\u5269\u6700\u540e\u4e00\u4f4d\uff01";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5df2\u7ecf\u63a7\u5236\u4e86\u5168\u90e8\u4e3b\u8981\u54c8\u6bd4\u5de2\u7a74\uff01";
        }
    }
    ,
    HARPY_PACIFICATION_REWARD(QuestType.SIDE, 6, 50){

        @Override
        public String getName() {
            return "\u54c8\u6bd4" + (Main.game.getPlayer().isFeminine() ? "\u5973\u738b" : "\u4e4b\u738b");
        }

        @Override
        public String getDescription() {
            return "\u56de\u5230\u6267\u6cd5\u8005\u5c97\u54e8\u62a5\u544a\u4efb\u52a1\u5df2\u7ecf\u5b8c\u6210\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u5728\u544a\u77e5\u6267\u6cd5\u8005\u4f60\u5df2\u7ecf\u63a7\u5236\u4e86\u6240\u6709\u4e3b\u8981\u54c8\u6bd4\u5de2\u7a74\u540e\uff0c\u6267\u6cd5\u8005\u6062\u590d\u4e86\u5e38\u89c4\u5de1\u903b\u3002\u4f60\u73b0\u5728\u53ef\u4ee5\u5728\u54c8\u6bd4\u4e4b\u5de2\u901a\u884c\u65e0\u963b\u4e86\uff01";
        }
    }
    ,
    SLIME_QUEEN_ONE(QuestType.SIDE, 10, 25){

        @Override
        public String getName() {
            return "\u9ebb\u70e6\u7684\u53f2\u83b1\u59c6\u4eec";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u521a\u6765\u5230\u5c48\u57ce\u533a\u65f6\uff0c\u4fbf\u9047\u5230\u4e00\u4f4d\u540d\u53eb\u514b\u83b1\u5c14\u7684\u6267\u6cd5\u8005\u3002\u5979\u544a\u8bc9\u4f60\u96a7\u9053\u91cc\u6b63\u5728\u53d1\u751f\u7684\u60c5\u51b5\u3002\u53f2\u83b1\u59c6\u6b63\u5728\u88ad\u51fb\u65e0\u8f9c\u7684\u65c5\u884c\u8005\uff0c\u5e76\u628a\u4ed6\u4eec\u53d8\u6210\u4e5f\u53d8\u6210\u53f2\u83b1\u59c6\u3002\u4e8e\u662f\u53f2\u83b1\u59c6\u5c31\u8d8a\u6765\u8d8a\u591a\u3002\u5982\u679c\u4f60\u5411\u6267\u6cd5\u8005\u63d0\u4f9b\u51f6\u731b\u53f2\u83b1\u59c6\u6765\u6e90\u7684\u7ebf\u7d22\uff0c\u5c31\u80fd\u83b7\u5f97\u4e94\u5343\u706b\u5e01\u5956\u52b1\u3002<br/><p style='text-align:center;'><i>\u4f60\u9700\u8981\u901a\u8fc7\u5728<b>\u5c48\u57ce\u533a\u7684\u96a7\u9053</b>\u4e2d\u6253\u5012\u4e00\u53ea\u53f2\u83b1\u59c6\uff0c\u4ee5\u83b7\u53d6\u66f4\u591a\u7ebf\u7d22\u3002</i></p>";
        }

        @Override
        public String getCompletedDescription() {
            return "\u96a7\u9053\u91cc\u9047\u5230\u7684\u4e00\u53ea\u53f2\u83b1\u59c6\u544a\u8bc9\u4f60\uff0c\u6709\u4f4d\u201c\u53f2\u83b1\u59c6\u5973\u738b\u201d\u547d\u4ee4\u5b83\u4eec\u8f6c\u5316\u5176\u4ed6\u4eba\u3002";
        }
    }
    ,
    SLIME_QUEEN_TWO(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u6c47\u62a5";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5e94\u8be5\u5411\u5c48\u57ce\u533a\u7684\u6267\u6cd5\u8005\u6c47\u62a5\u5173\u4e8e\u8fd9\u4e2a\u201c\u53f2\u83b1\u59c6\u5973\u738b\u201d\u7684\u4e8b\u60c5\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u542c\u5b8c\u62a5\u544a\u7684\u6267\u6cd5\u8005\u544a\u8bc9\u4f60\uff0c\u4ed6\u4eec\u4ee5\u524d\u542c\u8bf4\u8fc7\u5173\u4e8e\u53f2\u83b1\u59c6\u5973\u738b\u7684\u4f20\u8a00\uff0c\u4f46\u4ece\u672a\u5728\u5c48\u57ce\u533a\u4e2d\u53d1\u73b0\u8fc7\u8e2a\u8ff9\u3002\u4ed6\u4eec\u5efa\u8bae\u4f60\u53bb\u8759\u8760\u6d1e\u7a9f\u770b\u770b\uff0c\u5982\u679c\u4f60\u80fd\u627e\u5230\u5973\u738b\u5e76\u7ed3\u675f\u5979\u7684\u9634\u8c0b\uff0c\u4ed6\u4eec\u8fd8\u4f1a\u518d\u7ed9\u4f60\u4e24\u4e07\u706b\u5e01\u3002";
        }
    }
    ,
    SLIME_QUEEN_THREE(QuestType.SIDE, 15, 25){

        @Override
        public String getName() {
            return "\u5bfb\u627e\u53f2\u83b1\u59c6\u5973\u738b";
        }

        @Override
        public String getDescription() {
            return "\u524d\u5f80\u8759\u8760\u6d1e\u7a9f\uff0c\u5bfb\u627e\u4f20\u8bf4\u4e2d\u7684\u53f2\u83b1\u59c6\u5973\u738b\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u5728\u53f2\u83b1\u59c6\u6e56\u7684\u4e2d\u592e\uff0c\u4f60\u53d1\u73b0\u4e86\u53f2\u83b1\u59c6\u5973\u738b\u7684\u5de2\u7a74\uff01";
        }
    }
    ,
    SLIME_QUEEN_FOUR(QuestType.SIDE, 20, 50){

        @Override
        public String getName() {
            return "\u9762\u5bf9\u5973\u738b";
        }

        @Override
        public String getDescription() {
            return "\u524d\u5f80\u5854\u9876\u5bfb\u627e\u53f2\u83b1\u59c6\u5973\u738b\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5728\u5854\u9876\u627e\u5230\u4e86\u53f2\u83b1\u59c6\u5973\u738b\u3002";
        }
    }
    ,
    SLIME_QUEEN_FIVE_SUBMIT(QuestType.SIDE, 1, 25){

        @Override
        public String getName() {
            return "\u5e2e\u52a9\u5973\u738b";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u51b3\u5b9a\u534f\u52a9\u53f2\u83b1\u59c6\u5973\u738b\u628a\u5c48\u57ce\u533a\u7684\u4eba\u53e3\u90fd\u8f6c\u5316\u6210\u53f2\u83b1\u59c6\u7684\u8ba1\u5212\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u51b3\u5b9a\u5e2e\u52a9\u53f2\u83b1\u59c6\u5973\u738b\u5b9e\u73b0\u5979\u7684\u8ba1\u5212\uff0c\u5e76\u4e14\u7b54\u5e94\u6b3a\u9a97\u6267\u6cd5\u8005\uff0c\u597d\u8ba9\u4ed6\u4eec\u76f8\u4fe1\u5979\u4e0d\u518d\u662f\u4e00\u4e2a\u5a01\u80c1\u3002";
        }
    }
    ,
    SLIME_QUEEN_SIX_SUBMIT(QuestType.SIDE, 1, 200){

        @Override
        public String getName() {
            return "\u6700\u7ec8\u62a5\u544a";
        }

        @Override
        public String getDescription() {
            return "\u8ddf\u514b\u83b1\u5c14\u56de\u62a5\u53f2\u83b1\u59c6\u5973\u738b\u4e0d\u518d\u662f\u9ebb\u70e6\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u544a\u8bc9\u514b\u83b1\u5c14\u53f2\u83b1\u59c6\u5973\u738b\u4e0d\u518d\u662f\u5a01\u80c1\uff0c\u5e76\u4e14\u6536\u5230\u4e86\u4e24\u5343\u706b\u5e01\u4f5c\u4e3a\u62a5\u916c\u3002\u73b0\u5728\u968f\u7740\u4f60\u7684\u5973\u738b\u514d\u4e8e\u6267\u6cd5\u8005\u7684\u8c03\u67e5\uff0c\u5c48\u57ce\u533a\u53d8\u6210\u53f2\u83b1\u59c6\u7684\u5929\u5802\u53ea\u5269\u4e0b\u65f6\u95f4\u95ee\u9898\u4e86\uff01";
        }
    }
    ,
    SLIME_QUEEN_FIVE_CONVINCE(QuestType.SIDE, 1, 25){

        @Override
        public String getName() {
            return "\u8bf4\u670d\u5973\u738b";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u51b3\u5b9a\u8981\u8bf4\u670d\u53f2\u83b1\u59c6\u5973\u738b\u653e\u5f03\u5979\u7684\u8ba1\u5212\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u8bf4\u670d\u4e86\u51ef\u745f\u7433\u653e\u5f03\u4e86\u5979\u628a\u5c48\u57ce\u533a\u7684\u6240\u6709\u4eba\u90fd\u8f6c\u5316\u6210\u53f2\u83b1\u59c6\u7684\u8ba1\u5212\u3002";
        }
    }
    ,
    SLIME_QUEEN_SIX_CONVINCE(QuestType.SIDE, 1, 200){

        @Override
        public String getName() {
            return "\u6700\u7ec8\u62a5\u544a";
        }

        @Override
        public String getDescription() {
            return "\u8ddf\u514b\u83b1\u5c14\u56de\u62a5\u53f2\u83b1\u59c6\u5973\u738b\u4e0d\u518d\u662f\u9ebb\u70e6\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u544a\u8bc9\u514b\u83b1\u5c14\u53f2\u83b1\u59c6\u5973\u738b\u4e0d\u518d\u662f\u4e00\u4e2a\u5a01\u80c1\uff0c\u5e76\u4e14\u6536\u5230\u4e86\u4e24\u5343\u706b\u5e01\u4f5c\u4e3a\u62a5\u916c\u3002";
        }
    }
    ,
    SLIME_QUEEN_FIVE_FORCE(QuestType.SIDE, 1, 25){

        @Override
        public String getName() {
            return "\u80c1\u8feb\u5973\u738b";
        }

        @Override
        public String getDescription() {
            return "\u80c1\u8feb\u53f2\u83b1\u59c6\u5973\u738b\u653e\u5f03\u5979\u7684\u8ba1\u5212\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u8feb\u4f7f\u51ef\u745f\u7433\u653e\u5f03\u4e86\u5979\u628a\u5c48\u57ce\u533a\u7684\u6240\u6709\u4eba\u90fd\u8f6c\u5316\u6210\u53f2\u83b1\u59c6\u7684\u8ba1\u5212\u3002";
        }
    }
    ,
    SLIME_QUEEN_SIX_FORCE(QuestType.SIDE, 1, 200){

        @Override
        public String getName() {
            return "\u6700\u7ec8\u62a5\u544a";
        }

        @Override
        public String getDescription() {
            return "\u8ddf\u514b\u83b1\u5c14\u56de\u62a5\u53f2\u83b1\u59c6\u5973\u738b\u4e0d\u518d\u662f\u9ebb\u70e6\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u544a\u8bc9\u514b\u83b1\u5c14\u53f2\u83b1\u59c6\u5973\u738b\u4e0d\u518d\u662f\u4e00\u4e2a\u5a01\u80c1\uff0c\u5e76\u4e14\u6536\u5230\u4e86\u4e24\u5343\u706b\u5e01\u4f5c\u4e3a\u62a5\u916c\u3002";
        }
    }
    ,
    TELEPORTING_START(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u4ece\u4ed3\u5e93\u4e2d\u9003\u8131";
        }

        @Override
        public String getDescription() {
            return "\u610f\u5916\u4f20\u9001\u5230\u4e86\u2018SWORD\u2019\u6267\u6cd5\u8005\u90e8\u95e8\u7684\u5b58\u50a8\u4ed3\u5e93\uff0c\u73b0\u5728\u4f60\u548c\u514b\u83b1\u5c14\u9700\u8981\u907f\u514d\u88ab\u53d1\u73b0\uff0c\u5e76\u4e14\u5b89\u5168\u79bb\u5f00\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u548c\u514b\u83b1\u5c14\u6253\u7b97\u8bbe\u6cd5\u4eceSWORD\u7684\u4ed3\u5e93\u4e2d\u79bb\u5f00\u3002";
        }
    }
    ,
    TELEPORTING_CAUGHT(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u5fcd\u53d7\u62d8\u7981";
        }

        @Override
        public String getDescription() {
            if (Main.game.isNonConEnabled()) {
                return "\u4f60\u5728SWORD\u7684\u4ed3\u5e93\u4e2d\u88ab\u6267\u6cd5\u8005\u51fb\u8d25\u4e86\uff0c\u73b0\u5728\u4f60\u88ab\u5224\u5904\u9501\u5728\u5974\u96b6\u5df7\u7684\u516c\u5171\u5211\u5177\u4e2d\u7684\u60e9\u7f5a\u3002\u5fcd\u53d7\u8fd9\u4e00\u78e8\u96be\u76f4\u5230\u514b\u83b1\u5c14\u524d\u6765\u8425\u6551\u4f60\u2026\u2026";
            }
            return "\u4f60\u5728SWORD\u7684\u4ed3\u5e93\u4e2d\u88ab\u6267\u6cd5\u8005\u51fb\u8d25\u4e86\uff0c\u73b0\u5728\u4f60\u88ab\u5224\u5904\u5728\u6267\u6cd5\u8005\u603b\u90e8\u7684\u76d1\u72f1\u4e2d\u76d1\u7981\u7684\u60e9\u7f5a\u3002\u5fcd\u53d7\u8fd9\u4e00\u714e\u71ac\u76f4\u5230\u514b\u83b1\u5c14\u524d\u6765\u8425\u6551\u4f60\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            if (Main.game.isNonConEnabled()) {
                return "\u4f60\u5728SWORD\u7684\u4ed3\u5e93\u4e2d\u88ab\u6267\u6cd5\u8005\u51fb\u8d25\u4e86\uff0c\u73b0\u5728\u4f60\u88ab\u5224\u5904\u9501\u5728\u5974\u96b6\u5df7\u7684\u516c\u5171\u5211\u5177\u4e2d\u6570\u4e2a\u5c0f\u65f6\uff0c\u76f4\u5230\u514b\u83b1\u5c14\u73b0\u8eab\u6765\u91ca\u653e\u4f60\u3002";
            }
            return "\u4f60\u5728SWORD\u7684\u4ed3\u5e93\u4e2d\u88ab\u6267\u6cd5\u8005\u51fb\u8d25\u4e86\uff0c\u73b0\u5728\u4f60\u88ab\u5224\u5904\u5728\u6267\u6cd5\u8005\u603b\u90e8\u7684\u76d1\u72f1\u51e0\u4e2a\u5c0f\u65f6\u7684\u76d1\u7981\uff0c\u76f4\u5230\u514b\u83b1\u5c14\u524d\u6765\u91ca\u653e\u4f60\u3002";
        }
    }
    ,
    DADDY_START(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u4e0e[daddy.name]\u89c1\u9762";
        }

        @Override
        public String getDescription() {
            return "\u841d\u4e1d\u8981\u6c42\u4f60\u53bb\u89c1[daddy.name]\uff0c\u8bf4\u670d[daddy.herHim]\u522b\u518d\u6765\u6253\u6270\u8389\u83b1\u96c5\u3002([daddy.He]\u53ea\u5728[daddy.his]\u6076\u9b54\u4e4b\u5bb6\u7684\u516c\u5bd3\u4e2d\u7684" + Units.time(LocalTime.of(18, 0)) + "\u548c" + Units.time(LocalTime.of(21, 0)) + "\u6709\u7a7a\u3002)";
        }

        @Override
        public String getCompletedDescription() {
            return "\u9075\u7167\u841d\u4e1d\u7684\u5429\u5490\uff0c\u4f60\u548c[daddy.name]\u5728[daddy.her]\u6076\u9b54\u4e4b\u5bb6\u7684\u516c\u5bd3\u4e2d\u89c1\u4e86\u9762\u3002";
        }
    }
    ,
    DADDY_MEETING(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u4e0e[daddy.name]\u5171\u8fdb\u665a\u9910";
        }

        @Override
        public String getDescription() {
            return "[daddy.Name]\u575a\u6301\u8981\u5728\u665a\u9910\u65f6\u89e3\u91ca[daddy.her]\u7684\u52a8\u673a\u3002\u4f60\u8981\u4e48\u63a5\u53d7[daddy.her]\u7684\u63d0\u8bae\uff0c\u8981\u4e48\u76f4\u622a\u4e86\u5f53\u5730\u62d2\u7edd[daddy.herHim]\u5e76\u8981\u6c42[daddy.she]\u79bb\u8389\u83b1\u96c5\u8fdc\u70b9\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u7ed9\u4e86[daddy.name]\u5173\u4e8e\u5171\u8fdb\u665a\u9910\u8bf7\u6c42\u7684\u56de\u7b54\u3002";
        }
    }
    ,
    DADDY_REFUSED(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "[daddy.Name]\u88ab\u62d2\u7edd";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u544a\u8bc9[daddy.name]\uff0c\u4f60\u5bf9\u4e8e\u8ddf[daddy.herHim]\u4e00\u8d77\u51fa\u53bb\u5403\u996d\u6ca1\u6709\u4e1d\u6beb\u5174\u8da3\uff0c\u5e76\u4e14[daddy.sheIs]\u6c38\u8fdc\u90fd\u4e0d\u8981\u518d\u6765\u6253\u6270\u8389\u83b1\u96c5\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u544a\u8bc9[daddy.name]\uff0c\u4f60\u5bf9\u4e8e\u8ddf[daddy.herHim]\u4e00\u8d77\u51fa\u53bb\u5403\u996d\u6ca1\u6709\u4e1d\u6beb\u5174\u8da3\uff0c\u5e76\u4e14[daddy.sheIs]\u6c38\u8fdc\u90fd\u4e0d\u8981\u518d\u6765\u6253\u6270\u8389\u83b1\u96c5\u4e86\u3002";
        }
    }
    ,
    DADDY_REFUSED_2(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "[daddy.Name]\u88ab\u62d2\u7edd";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u544a\u8bc9[daddy.name]\uff0c\u4f60\u5bf9\u8bf4\u670d\u8389\u83b1\u96c5\u548c[daddy.herHim]\u89c1\u9762\u6ca1\u6709\u4e1d\u6beb\u5174\u8da3\uff0c\u5e76\u4e14[daddy.she]\u6c38\u8fdc\u90fd\u4e0d\u8981\u518d\u6765\u6253\u6270\u4f60\u7684[lilaya.relation(pc)]\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u544a\u8bc9[daddy.name]\uff0c\u4f60\u5bf9\u8bf4\u670d\u8389\u83b1\u96c5\u548c[daddy.herHim]\u89c1\u9762\u6ca1\u6709\u4e1d\u6beb\u5174\u8da3\uff0c\u5e76\u4e14[daddy.she]\u6c38\u8fdc\u90fd\u4e0d\u8981\u518d\u6765\u6253\u6270\u4f60\u7684[lilaya.relation(pc)]\u4e86\u3002";
        }
    }
    ,
    DADDY_ACCEPTED(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u8bf4\u670d\u8389\u83b1\u96c5";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u540c\u610f\u8bf4\u670d\u8389\u83b1\u96c5\u6765\u548c[daddy.name]\u5171\u8fdb\u665a\u9910\uff0c\u7136\u540e\u529d\u8bf4\u5979\u8bf7\u8389\u897f\u4e1d\u6765\u548c[daddy.herHim]\u89c1\u9762\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u8bf4\u670d\u4e86\u8389\u83b1\u96c5\u548c[daddy.name]\u5171\u8fdb\u665a\u9910\uff0c\u6761\u4ef6\u662f\u4f60\u548c\u5979\u4e00\u8d77\u53bb\u3002";
        }
    }
    ,
    DADDY_LILAYA_MEETING(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u8389\u83b1\u96c5\u4e0e[daddy.name]\u7684\u7ea6\u4f1a";
        }

        @Override
        public String getDescription() {
            return "\u8389\u83b1\u96c5\u540c\u610f\u548c[daddy.name]\u5171\u8fdb\u665a\u9910\uff0c\u73b0\u5728\u4f60\u9700\u8981\u966a\u7740\u5979\uff0c\u786e\u4fdd\u665a\u4e0a\u80fd\u987a\u5229\u8fdb\u884c\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u548c\u8389\u83b1\u96c5\u4e00\u8d77\u4e0e[daddy.name]\u5171\u8fdb\u665a\u9910\uff0c\u5979\u7ed9[daddy.herHim]\u5e26\u53bb\u4e86\u5173\u4e8e\u8389\u897f\u4e1d\u7231\u60c5\u504f\u597d\u7684\u574f\u6d88\u606f\uff0c\u4e0d\u8fc7\u5979\u4f3c\u4e4e\u5f88\u559c\u6b22[daddy.herHim]\u2026\u2026";
        }
    }
    ,
    BUYING_BRAX_START(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u6536\u96c6\u9999\u6c34";
        }

        @Override
        public String getDescription() {
            return "\u574e\u8fea\u8bf4\u5979\u4f1a\u8003\u8651\u628a[brax.name]\u5356\u7ed9\u4f60\uff0c\u4f46\u5728\u7ed9\u51fa\u660e\u786e\u7b54\u6848\u4e4b\u524d\uff0c\u5979\u60f3\u8ba9\u4f60\u53bb\u8d2d\u7269\u4e2d\u5fc3\u201c\u9b45\u9b54\u7684\u79d8\u5bc6\u201d\u5546\u5e97\u90a3\u91cc\u53d6\u5979\u8ba2\u8d2d\u7684\u9999\u6c34\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u4ece\u9b45\u9b54\u7684\u79d8\u5bc6\u90a3\u91cc\u8d2d\u4e70\u5e76\u53d6\u5f97\u4e86\u574e\u8fea\u8ba2\u8d2d\u7684\u9999\u6c34\u3002";
        }
    }
    ,
    BUYING_BRAX_DELIVER_PERFUME(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u8fd0\u9001\u9999\u6c34";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5df2\u7ecf\u83b7\u5f97\u4e86\u74f6\u88c5\u9999\u6c34\uff0c\u73b0\u5728\u4f60\u9700\u8981\u628a\u5b83\u4eec\u9001\u5230\u6267\u6cd5\u8005\u603b\u90e8\u7684\u574e\u8fea\u90a3\u91cc\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u628a\u574e\u8fea\u7684\u74f6\u88c5\u9999\u6c34\u4ea4\u5230\u4e86\u5979\u624b\u4e0a\u3002";
        }
    }
    ,
    BUYING_BRAX_LOLLIPOPS(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u8fdd\u7981\u68d2\u68d2\u7cd6";
        }

        @Override
        public String getDescription() {
            return "\u574e\u8fea\u8bf4\u5979\u613f\u610f\u628a\u5e03\u62c9\u514b\u65af\u5356\u7ed9\u4f60\uff0c\u4f46\u5979\u9700\u8981\u601d\u8003\u4e00\u4e0b[brax.sheIs]\u503c\u591a\u5c11\u94b1\u3002\u5979\u8ba9\u4f60\u4ece\u54c8\u6bd4\u4e4b\u5de2\u7684\u6267\u6cd5\u8005\u68c0\u67e5\u7ad9\u62ff\u6765\u4e00\u76d2\u8fdd\u7981\u68d2\u68d2\u7cd6\uff0c\u4e4b\u540e\u5979\u4f1a\u7ed9\u4f60\u62a5\u4ef7\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u4ece\u54c8\u6bd4\u4e4b\u5de2\u7684\u6267\u6cd5\u8005\u68c0\u67e5\u7ad9\u53d6\u56de\u4e86\u68d2\u68d2\u7cd6\u3002";
        }
    }
    ,
    BUYING_BRAX_DELIVER_LOLLIPOPS(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u574e\u8fea\u7684\u68d2\u68d2\u7cd6";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u62ff\u5230\u4e86\u90a3\u76d2\u8fdd\u7981\u68d2\u68d2\u7cd6\uff0c\u73b0\u5728\u4f60\u9700\u8981\u628a\u5b83\u4eec\u4ea4\u7ed9\u6267\u6cd5\u8005\u603b\u90e8\u7684\u574e\u8fea\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u628a\u90a3\u76d2\u8fdd\u7981\u68d2\u68d2\u7cd6\u4ea4\u7ed9\u4e86\u574e\u8fea\uff0c\u5979\u4f3c\u4e4e\u6839\u672c\u4e0d\u5728\u610f\u5370\u5728\u4e0a\u9762\u7684\u8b66\u544a\u3002";
        }
    }
    ,
    BUYING_BRAX_LIPSTICK(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u4ef7\u503c\u4e00\u72fc\u7684\u53e3\u7ea2";
        }

        @Override
        public String getDescription() {
            return "\u574e\u8fea\u8bf4\u5e03\u62c9\u514b\u65af\u592a\u73cd\u8d35\u4e86\uff0c\u4e0d\u80fd\u4ec5\u4ec5\u4e3a\u4e86\u4e9b\u8bb8\u706b\u5e01\u800c\u51fa\u552e\uff0c\u4f46\u5979\u613f\u610f\u7528\u5e03\u62c9\u514b\u65af\u6362\u53d6\u540c\u6837\u73cd\u8d35\u7684\u4e1c\u897f\uff1a\u4e00\u76d2\u53eb\u505a\u201c\u767e\u4e07\u4e4b\u543b\u201d\u7684\u9650\u91cf\u7248\u53e3\u7ea2\u3002\u663e\u7136\uff0c\u574e\u8fea\u53d1\u73b0\u4e86\u4ec5\u5b58\u7684\u4e00\u76d2\u5f85\u552e\u53e3\u7ea2\u7684\u4e0b\u843d\uff0c\u5728\u8d2d\u7269\u4e2d\u5fc3\u4e00\u5bb6\u540d\u4e3a\u201c\u62c9\u5c14\u592b\u5c0f\u5403\u5e97\u201d\u7684\u5546\u5e97\u91cc\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u4ece\u62c9\u5c14\u592b\u90a3\u91cc\u53d6\u56de\u4e86\u90a3\u76d2\u201c\u767e\u4e07\u4e4b\u543b\u201d";
        }
    }
    ,
    BUYING_BRAX_DELIVER_LIPSTICK(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u5728\u72fc\u7684\u95e8\u524d";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u62ff\u5230\u4e86\u90a3\u76d2\u201c\u767e\u4e07\u4e4b\u543b\u201d\uff0c\u5269\u4e0b\u7684\u5c31\u662f\u628a\u5b83\u4ea4\u7ed9\u574e\u8fea\uff0c\u4ee5\u6362\u53d6[brax.name]\u7684\u6240\u6709\u6743\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u628a\u90a3\u76d2\u201c\u767e\u4e07\u4e4b\u543b\u201d\u4ea4\u7ed9\u4e86\u574e\u8fea\uff0c\u6700\u7ec8\u83b7\u5f97\u4e86\u5956\u54c1\uff1a[brax.name]\u7684\u6240\u6709\u6743\u3002";
        }
    }
    ,
    VENGAR_START(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u9f20\u7a9f";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u540c\u610f\u5e2e\u52a9\u963f\u514b\u585e\u5c14\u5bf9\u4ed8\u6587\u52a0\u2014\u2014\u5c48\u57ce\u533a\u6700\u5927\u3001\u6700\u5371\u9669\u56e2\u4f19\u7684\u5934\u76ee\u3002\u4f60\u53ef\u4ee5\u76f4\u63a5\u53bb\u4ed6\u7684\u85cf\u8eab\u5904\u201c\u9f20\u7a9f\u201d\uff0c\u6216\u662f\u5148\u5411\u514b\u83b1\u5c14\u5bfb\u6c42\u5e2e\u52a9\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u4f7f\u7528\u963f\u514b\u585e\u5c14\u7ed9\u7684\u5bc6\u7801\uff0c\u5f97\u4ee5\u8fdb\u5165\u6587\u52a0\u7684\u85cf\u8eab\u5904\uff1a\u9f20\u7a9f\u3002";
        }
    }
    ,
    VENGAR_ONE(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u4e0e\u6587\u52a0\u89c1\u9762";
        }

        @Override
        public String getDescription() {
            return "\u4e3a\u4e86\u627e\u5230\u6587\u52a0\uff0c\u4f60\u9700\u8981\u5728" + Units.time(LocalDateTime.of(1, 1, 1, 6, 0)) + "\u548c" + Units.time(LocalDateTime.of(1, 1, 1, 22, 0)) + "\u7684\u65f6\u95f4\u6bb5\u5230\u4e3b\u5385\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u53d1\u73b0\u6587\u52a0\u5750\u5728\u4e3b\u5385\u7684\u5b9d\u5ea7\u4e0a\uff0c\u63a5\u8fd1\u4ed6\u4e4b\u540e\uff0c\u4f60\u8981\u4e48\u9009\u62e9\u52a0\u5165\u4ed6\u7684\u5e2e\u6d3e\uff0c\u8981\u4e48\u4f1a\u88ab\u4ed6\u7684\u9f20\u5973\u4fdd\u9556\u653b\u51fb\u3002";
        }
    }
    ,
    VENGAR_TWO_CONFLICT(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u51b2\u7a81";
        }

        @Override
        public String getDescription() {
            return "\u9009\u62e9\u4e86\u6311\u6218\u6587\u52a0\uff0c\u73b0\u5728\u4f60\u9700\u8981\u5728\u6218\u6597\u4e2d\u51fb\u8d25\u4ed6\uff0c\u624d\u80fd\u5728\u4ed6\u7684\u5e2e\u6d3e\u4e2d\u5360\u636e\u4e3b\u5bfc\u5730\u4f4d\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u6210\u529f\u51fb\u8d25\u4e86\u6587\u52a0\uff0c\u4f46\u5728\u4f60\u8fdb\u4e00\u6b65\u884c\u52a8\u524d\uff0cSWORD\u5c31\u5f00\u59cb\u4e86\u5bf9\u9f20\u7a9f\u7684\u7a81\u88ad\u3002";
        }
    }
    ,
    VENGAR_TWO_COOPERATION(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u963f\u514b\u585e\u5c14\u7684\u81e3\u670d";
        }

        @Override
        public String getDescription() {
            return "\u6587\u52a0\u900f\u9732\uff0c\u4e00\u6bb5\u65f6\u95f4\u4ee5\u6765\uff0c\u4ed6\u4e00\u76f4\u60f3\u4e13\u6ce8\u4e8e\u81ea\u5df1\u5408\u6cd5\u7684\u6717\u59c6\u9152\u5382\u4e1a\u52a1\uff0c\u4f46\u4ed6\u5982\u679c\u8f7b\u6613\u5730\u653e\u8fc7\u963f\u514b\u585e\u5c14\u5c31\u4f1a\u5931\u53bb\u5e2e\u6d3e\u6210\u5458\u7684\u5c0a\u91cd\u3002\u4f5c\u4e3a\u7ed3\u675f\u52d2\u7d22\u7684\u4ea4\u6362\uff0c\u4f60\u540c\u610f\u8bf4\u670d\u963f\u514b\u585e\u5c14\u6765\u5411\u6587\u52a0\u8868\u660e\u4ed6\u7684\u987a\u4ece\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u6210\u529f\u8bf4\u670d\u963f\u514b\u585e\u5c14\u53bb\u9f20\u7a9f\u5411\u6587\u52a0\u8868\u793a\u81e3\u670d\u3002\u966a\u540c\u4ed6\u53bb\u90a3\u91cc\uff0c\u4f60\u80fd\u591f\u505a\u4e9b\u4ec0\u4e48\u6765\u5f71\u54cd\u9cc4\u7537\u7684\u906d\u9047\u3002";
        }
    }
    ,
    VENGAR_TWO_ENFORCERS(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u7a81\u88ad";
        }

        @Override
        public String getDescription() {
            return "\u5728\u786e\u8ba4\u6587\u52a0\u5c31\u85cf\u5728\u9f20\u7a9f\u540e\uff0c\u4f60\u542f\u52a8\u4e86\u56de\u58f0\u77f3\u5411\u5728\u7b49\u5f85\u7740\u7684SWORD\u6267\u6cd5\u8005\u53d1\u51fa\u5f00\u59cb\u7a81\u88ad\u7684\u4fe1\u53f7\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "SWORD\u7684\u6267\u6cd5\u8005\u6210\u529f\u7a81\u88ad\u4e86\u9f20\u7a9f\u5e76\u902e\u6355\u4e86\u6587\u52a0\u3002";
        }
    }
    ,
    VENGAR_THREE_COOPERATION_END(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u6587\u52a0\u7684\u672b\u8def";
        }

        @Override
        public String getDescription() {
            return "[axel.name]\u5df2\u7ecf\u5411\u6587\u52a0\u8868\u793a\u81e3\u670d\uff0c\u5269\u4e0b\u8981\u505a\u7684\u5c31\u662f\u8fd4\u56de\u8d4c\u573a\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u5728[axel.name]\u5411\u6587\u52a0\u8868\u793a\u81e3\u670d\u540e\uff0c\u4e00\u7fa4SWORD\u6267\u6cd5\u8005\u51fa\u73b0\u4e86\uff0c\u4ed6\u4eec\u7a81\u88ad\u4e86\u9f20\u7a9f\u5e76\u902e\u6355\u4e86\u90a3\u9f20\u7537\uff01";
        }
    }
    ,
    VENGAR_THREE_END(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u56de\u53bb\u627e\u963f\u514b\u585e\u5c14";
        }

        @Override
        public String getDescription() {
            return "\u6587\u52a0\u5df2\u7ecf\u88ab\u89e3\u51b3\u4e86\uff0c\u4f60\u9700\u8981\u56de\u53bb\u627e\u963f\u514b\u585e\u5c14\uff0c\u8ba9\u4ed6\u77e5\u9053\u53d1\u751f\u4e86\u4ec0\u4e48\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u56de\u5230\u963f\u514b\u585e\u5c14\u8eab\u8fb9\uff0c\u544a\u8bc9\u4ed6\u4e4b\u540e\u60c5\u51b5\u4f1a\u5982\u4f55\u53d1\u5c55\u3002";
        }
    }
    ,
    VENGAR_OPTIONAL_CLAIRE(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u514b\u83b1\u5c14\u7684\u5e2e\u52a9";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u8ba4\u4e3a\u8ba9\u514b\u83b1\u5c14\u4e86\u89e3\u60c5\u51b5\u662f\u6700\u597d\u7684\u9009\u62e9\uff0c\u4e8e\u662f\u5411\u5979\u8be2\u95ee\u6267\u6cd5\u8005\u662f\u5426\u80fd\u5e2e\u4e0a\u5fd9\u3002\u770b\u6765\uff0c\u6709\u4e00\u652fSWORD\u5c0f\u961f\u5df2\u7ecf\u51c6\u5907\u597d\u7a81\u88ad\u9f20\u7a9f\u4e86\uff0c\u4f46\u4ed6\u4eec\u9700\u8981\u5728\u53d1\u52a8\u653b\u51fb\u4e4b\u524d\u786e\u8ba4\u6587\u52a0\u5728\u91cc\u9762\u3002\u514b\u83b1\u5c14\u7ed9\u4e86\u4f60\u4e00\u5757\u56de\u58f0\u77f3\uff0c\u5982\u679c\u4f60\u60f3\u8ba9\u6267\u6cd5\u8005\u652f\u63f4\u4f60\uff0c\u5c31\u6fc0\u6d3b\u5b83\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u8ba4\u4e3a\u8ba9\u514b\u83b1\u5c14\u4e86\u89e3\u60c5\u51b5\u662f\u6700\u597d\u7684\u9009\u62e9\uff0c\u4e8e\u662f\u5411\u5979\u8be2\u95ee\u6267\u6cd5\u8005\u662f\u5426\u80fd\u5e2e\u4e0a\u5fd9\u3002\u770b\u6765\uff0c\u6709\u4e00\u652fSWORD\u5c0f\u961f\u5df2\u7ecf\u51c6\u5907\u597d\u7a81\u88ad\u9f20\u7a9f\u4e86\uff0c\u4f46\u4ed6\u4eec\u9700\u8981\u5728\u53d1\u52a8\u653b\u51fb\u4e4b\u524d\u786e\u8ba4\u6587\u52a0\u5728\u91cc\u9762\u3002\u514b\u83b1\u5c14\u7ed9\u4e86\u4f60\u4e00\u5757\u56de\u58f0\u77f3\uff0c\u5982\u679c\u4f60\u60f3\u8ba9\u6267\u6cd5\u8005\u652f\u63f4\u4f60\uff0c\u5c31\u6fc0\u6d3b\u5b83\u3002";
        }
    }
    ,
    WES_FAIL(QuestType.SIDE, 1, 0){

        @Override
        public String getName() {
            return "\u9519\u5931\u673a\u4f1a";
        }

        @Override
        public String getDescription() {
            return "\u5728\u544a\u77e5\u97e6\u65af\u5229\u4f60\u65e0\u610f\u5e2e\u52a9\u4ed6\u8c03\u67e5\u4e4b\u540e\uff0c\u8fd9\u4e2a\u72d0\u7537\u6d88\u5931\u4e86\uff0c\u4f60\u53ef\u4ee5\u786e\u5b9a\u4ed6\u518d\u4e5f\u4e0d\u4f1a\u5bfb\u6c42\u4f60\u7684\u5e2e\u52a9\u4e86\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return this.getDescription();
        }
    }
    ,
    WES_START(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u8bf7\u6c42\u5e2e\u52a9";
        }

        @Override
        public String getDescription() {
            return "\u7a7f\u884c\u4e8e\u5fa1\u57ce\u533a\u65f6\uff0c\u4e00\u540d\u795e\u79d8\u7684SWORD\u79d8\u5bc6\u6267\u6cd5\u8005\u5411\u4f60\u6c42\u52a9\u3002\u4ed6\u60f3\u548c\u4f60\u5728[units.time(13)]\u5230[units.time(14)]\u4e8e\u8d2d\u7269\u4e2d\u5fc3\u7684\u53e4\u8463\u5e97\u5916\u89c1\u9762\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u7b54\u5e94\u5e2e\u52a9\u97e6\u65af\u5229\u8c03\u67e5\u4ed6\u7684\u4e0a\u7ea7\u8b66\u5b98\u3002";
        }
    }
    ,
    WES_1(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u5bfb\u627e\u57c3\u52d2";
        }

        @Override
        public String getDescription() {
            return "\u97e6\u65af\u544a\u8bc9\u4f60\uff0c\u4ed6\u7684\u8b66\u5b98\u4e0a\u53f8\uff0c[elle.name](\u7b80\u79f0\u201c\u57c3\u52d2\u201d)\uff0c\u6bcf\u5468\u4e09\u90fd\u4f1a\u5e26\u4e0a\u591c\u89c6\u955c\u53bb\u5348\u4f11\u5f88\u957f\u65f6\u95f4\uff0c\u56de\u6765\u65f6\u978b\u5b50\u603b\u662f\u6e7f\u7684\u3002\u4f60\u9700\u8981\u627e\u5230\u5979\uff0c\u5e76\u7528\u97e6\u65af\u7ed9\u4f60\u7684\u5965\u672f\u5f55\u50cf\u673a\u8bb0\u5f55\u4e0b\u6240\u6709\u7f6a\u8bc1\u2026\u2026<br/>\u5979\u7684[style.colourOrange(\u5348\u4f11\u65f6\u95f4\u5f02\u5e38\u957f)]\u3002<br/>\u5979\u53ea\u5728[style.colourOrange(\u661f\u671f\u4e09)]\u51fa\u73b0\u8fd9\u79cd\u60c5\u51b5\u3002<br/>\u5979\u968f\u8eab\u643a\u5e26\u4e00\u5957[style.colourOrange(\u591c\u89c6\u955c)]\u3002<br/>\u4e4b\u540e\uff0c\u5979\u7684[style.colourOrange(\u978b\u5b50\u603b\u662f\u6e7f\u7684)]\uff0c\u6709\u65f6[style.colourOrange(\u4e0a\u9762\u6cbe\u6709\u53d1\u5149\u6b8b\u7559\u7269)]\u3002<br/>[style.italicsMinorGood(\u53ef\u4ee5\u8be2\u95ee\u8389\u83b1\u96c5\u4ee5\u83b7\u5f97\u76ee\u6807\u5730\u70b9\u7684\u63d0\u793a\u3002)]";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u63a8\u65ad\u51fa\u57c3\u52d2\u5728\u8759\u8760\u6d1e\u7a9f\u505a\u7740\u89c1\u4e0d\u5f97\u4eba\u7684\u751f\u610f\uff0c\u5e76\u8bbe\u6cd5\u6536\u96c6\u5230\u4e86\u5979\u5411\u4e00\u4e2a\u5371\u9669\u7684\u72af\u7f6a\u5e2e\u6d3e\u51fa\u552e\u6b66\u5668\u7684\u8bc1\u636e\u3002";
        }
    }
    ,
    WES_2(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u4f7f\u7528\u8bc1\u636e";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u7684\u5965\u672f\u5f55\u50cf\u673a\u8bb0\u5f55\u6709\u57c3\u52d2\u8150\u8d25\u7684\u7f6a\u8bc1\uff0c\u4f60\u6709\u4e24\u79cd\u53ef\u9009\u7684\u5904\u7406\u65b9\u5f0f\u3002\u4f60\u53ef\u4ee5\u628a\u5b83\u533f\u540d\u4e3e\u62a5\u7ed9\u514b\u83b1\u5c14\u6216\u574e\u8fea\uff0c\u6216\u8005\u5982\u679c\u4f60\u60f3\u80cc\u53db\u97e6\u65af\u5e76\u7ad9\u5728\u57c3\u52d2\u8fd9\u8fb9\uff0c\u4f60\u4e5f\u53ef\u4ee5\u5728[units.time(16)]\u5230[units.time(18)]\u4e8e\u6267\u6cd5\u8005\u603b\u90e8\u5916\u7b49\u5f85\u57c3\u52d2\uff0c\u5728\u4e0b\u73ed\u65f6\u95f4\u5411[elle.race]\u8868\u660e\u4e00\u5207\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u8981\u5229\u7528\u6536\u96c6\u7684\u8bc1\u636e\u7ed9\u97e6\u65af\u548c\u57c3\u52d2\u7684\u5168\u90e8\u4ea4\u6613\u753b\u4e0a\u53e5\u53f7\u3002";
        }
    }
    ,
    WES_3_WES(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u652f\u6301\u97e6\u65af";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u51b3\u5b9a\u6309\u7167\u97e6\u65af\u7684\u8981\u6c42\u505a\uff0c\u5e76\u5c06\u6307\u63a7\u8bc1\u636e\u533f\u540d\u4e3e\u62a5\u7ed9\u6267\u6cd5\u8005\u3002\u4e8b\u60c5\u89e3\u51b3\u81f3\u5c11\u8981\u4e00\u5468\u65f6\u95f4\uff0c\u4e4b\u540e\u4f60\u53ef\u4ee5\u5728[units.time(9)]\u5230[units.time(17)]\u4e4b\u95f4\u53bb\u6267\u6cd5\u8005\u603b\u90e8\u770b\u671b\u97e6\u65af\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u652f\u6301\u4e86\u97e6\u65af\uff0c\u5728\u533f\u540d\u63d0\u4ea4\u6307\u63a7\u8bc1\u636e\u540e\uff0c\u4f60\u5728\u6267\u6cd5\u8005\u603b\u90e8\u9047\u5230\u4e86\u8fd9\u72d0\u7537\uff0c\u4ed6\u88ab\u63d0\u62d4\u6765\u63a5\u66ff\u57c3\u52d2\u7684\u5de5\u4f5c\u3002\u4ed6\u6709\u4e86\u65b0\u7684\u6743\u9650\uff0c\u4f5c\u4e3a\u5bf9\u4f60\u5e2e\u52a9\u7684\u56de\u62a5\uff0c\u4ed6\u5141\u8bb8\u4f60\u8fdb\u5165\u6267\u6cd5\u8005\u603b\u90e8\u7684\u519b\u9700\u5904\u3002\u4f60\u53ef\u4ee5\u5728[units.time(9)]\u5230[units.time(17)]\u4e4b\u95f4\u4e0d\u53d7\u9650\u5236\u5730\u53bb\u6267\u6cd5\u8005\u603b\u90e8\u62dc\u8bbf\u97e6\u65af\u3002";
        }
    }
    ,
    WES_3_ELLE(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u652f\u6301\u57c3\u52d2";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u51b3\u5b9a\u80cc\u53db\u97e6\u65af\uff0c\u5e76\u5c06\u4e00\u5207\u90fd\u544a\u8bc9\u57c3\u52d2\u3002\u591a\u4e8f\u4e86\u4f60\u7684\u610f\u5916\u5e2e\u52a9\uff0c[elle.race]\u627f\u8bfa\uff0c\u4f60\u53ef\u4ee5\u5728\u81f3\u5c11\u4e00\u5468\u540e\u56de\u5230\u6267\u6cd5\u8005\u603b\u90e8\uff0c\u5979\u4f1a\u7ed9\u4f60\u5956\u52b1\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u652f\u6301\u4e86\u57c3\u52d2\uff0c\u4f60\u56de\u5230\u6267\u6cd5\u8005\u603b\u90e8\u4e0e\u5979\u4f1a\u9762\uff0c\u53d1\u73b0\u97e6\u65af\u88ab\u5974\u5f79\u4e86\u3002[elle.race]\u5141\u8bb8\u4f60\u8fdb\u5165\u6267\u6cd5\u8005\u603b\u90e8\u7684\u519b\u9700\u5904\uff0c\u4ee5\u6b64\u6765\u8868\u8fbe\u5bf9\u4f60\u7684\u611f\u8c22\u3002\u4f60\u53ef\u4ee5\u5728[units.time(9)]\u5230[units.time(17)]\u4e4b\u95f4\u4e0d\u53d7\u9650\u5236\u5730\u53bb\u6267\u6cd5\u8005\u603b\u90e8\u62dc\u8bbf\u57c3\u52d2(\u4ee5\u53ca\u97e6\u65af)\u3002";
        }
    }
    ,
    REBEL_BASE_HANDLE_REFUSED(QuestType.SIDE, 15, 5){

        @Override
        public String getName() {
            return "\u62c9\u4e0b\u62c9\u6746\uff01";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5728\u8759\u8760\u6d1e\u7a9f\u91cc\u53d1\u73b0\u4e86\u4e00\u4e2a\u5947\u602a\u7684\u62c9\u6746\u3002\u6ca1\u4eba\u77e5\u9053\u5b83\u662f\u5e72\u4ec0\u4e48\u7528\u7684\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u62c9\u4e0b\u62c9\u6746\u4e0d\u662f\u6700\u4f73\u9009\u62e9\uff0c\u4f46\u4f60\u8fd8\u662f\u8fd9\u4e48\u505a\u4e86\u3002";
        }
    }
    ,
    REBEL_BASE_PASSWORD_PART_ONE(QuestType.SIDE, 15, 5){

        @Override
        public String getName() {
            return "\u62c9\u4e0b\u62c9\u6746\uff0c\u5f97\u5230\u8c1c\u9898";
        }

        @Override
        public String getDescription() {
            return "\u5947\u602a\u7684\u62c9\u6746\u8981\u6c42\u4f60\u8f93\u5165\u67d0\u79cd\u672a\u77e5\u7684\u5bc6\u7801\u3002\u4e5f\u8bb8\u5728\u9644\u8fd1\u641c\u7d22\u4e00\u4e0b\u5c31\u80fd\u53d1\u73b0\u7ebf\u7d22\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u627e\u5230\u7684\u534a\u5f20\u65e5\u8bb0\u7eb8\u4e0a\u8bf4\u5bc6\u7801\u662f\u4e24\u4e2a\u5355\u8bcd\uff0c\u4f60\u53ea\u80fd\u8fa8\u8ba4\u4e00\u4e2a\u5355\u8bcd\uff0c\u53e6\u4e00\u4e2a\u88ab\u6495\u6389\u4e86\u3002";
        }
    }
    ,
    REBEL_BASE_PASSWORD_PART_TWO(QuestType.SIDE, 15, 5){

        @Override
        public String getName() {
            return "\u586b\u7a7a\u9898";
        }

        @Override
        public String getDescription() {
            return "\u53e6\u4e00\u534a\u5bc6\u7801\u4e00\u5b9a\u5728\u53e6\u5916\u534a\u5f20\u65e5\u8bb0\u7eb8\u4e0a\uff0c\u4e5f\u8bb8\u80fd\u5728\u9644\u8fd1\u627e\u5230\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u627e\u5168\u4e86\u4e24\u90e8\u5206\u5bc6\u7801\uff0c\u5b83\u4eec\u4e00\u8d77\u6784\u6210\u4e86\u77ed\u8bed\u201cRUAT CAELUM\u201d(\u54ea\u6015\u5929\u5d29\u5730\u88c2)\u3002";
        }
    }
    ,
    REBEL_BASE_PASSWORD_COMPLETE(QuestType.SIDE, 15, 5){

        @Override
        public String getName() {
            return "\u829d\u9ebb\u5f00\u95e8";
        }

        @Override
        public String getDescription() {
            return "\u6709\u4e86\u5b8c\u6574\u7684\u5bc6\u7801\uff0c\u4f60\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\u6311\u6218\u62c9\u6746\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u53d1\u73b0\u62c9\u6746\u5176\u5b9e\u8fde\u63a5\u7740\u4e00\u6247\u95e8\uff0c\u5b83\u901a\u5411\u4e00\u4e2a\u4ece\u8759\u8760\u6d1e\u7a9f\u4e2d\u5206\u79bb\u51fa\u6765\u7684\u9690\u85cf\u6d1e\u7a74\u3002";
        }
    }
    ,
    REBEL_BASE_EXPLORATION(QuestType.SIDE, 15, 5){

        @Override
        public String getName() {
            return "\u6d1e\u7a74\u5927\u5192\u9669";
        }

        @Override
        public String getDescription() {
            return "\u6ca1\u4eba\u77e5\u9053\u8fd9\u9690\u85cf\u6d1e\u7a74\u5185\u6709\u4f55\u7269\u6216\u901a\u5f80\u4f55\u5904\u3002\u6216\u8bb8\u4f60\u53ef\u4ee5\u8fdb\u5165\u6d1e\u7a74\u5bfb\u627e\u7b54\u6848\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u53d1\u73b0\u8fd9\u4e2a\u9690\u85cf\u7684\u6d1e\u7a74\u662f\u4e00\u4e2a\u65e9\u5df2\u6d88\u5931\u7684\u53cd\u6297\u519b\u7ec4\u7ec7\u7684\u85cf\u8eab\u4e4b\u5730\u3002\u4ece\u79cd\u79cd\u7279\u5f81\u6765\u770b\uff0c\u4ed6\u4eec\u6700\u7ec8\u6ca1\u80fd\u83b7\u80dc\u3002";
        }
    }
    ,
    REBEL_BASE_ESCAPE(QuestType.SIDE, 15, 100){

        @Override
        public String getName() {
            return "\u9003\u51fa\u751f\u5929";
        }

        @Override
        public String getDescription() {
            return "\u8d76\u5728\u6d1e\u7a74\u5b8c\u5168\u574d\u584c\u4e4b\u524d\uff0c\u662f\u65f6\u5019\u9003\u8d70\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5b89\u7136\u65e0\u6059\u5730\u9003\u51fa\u4e86\u6d1e\u7a74\u3002\u6d1e\u7a74\u91cc\u5176\u5b83\u4e1c\u897f\u73b0\u5728\u90fd\u88ab\u6c38\u8fdc\u57cb\u846c\u4e86\u3002";
        }
    }
    ,
    REBEL_BASE_FAILED(QuestType.SIDE, 15, 0){

        @Override
        public String getName() {
            return "\u4e34\u9635\u9000\u7f29";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5b89\u7136\u65e0\u6059\u5730\u9003\u51fa\u4e86\u6d1e\u7a74\uff0c\u4f46\u6d1e\u7a74\u91cc\u9690\u85cf\u7684\u6240\u6709\u79d8\u5bc6\uff0c\u73b0\u5728\u90fd\u6c38\u8fdc\u88ab\u57cb\u846c\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return this.getDescription();
        }
    }
    ,
    REBEL_BASE_FIREBOMBS_START(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u70b9\u71c3\u5f15\u4fe1";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u4ece\u795e\u79d8\u6d1e\u7a9f\u4e2d\u5f97\u5230\u7684\u71c3\u70e7\u5f39\u53ef\u4ee5\u5728\u6218\u6597\u4e2d\u6d3e\u4e0a\u7528\u573a\u3002\u4f60\u9700\u8981\u627e\u5230\u4e00\u4e2a\u80fd\u5236\u9020\u71c3\u70e7\u5f39\u6216\u8005\u6709\u71c3\u70e7\u5f39\u6e20\u9053\u7684\u4eba\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u7f57\u514b\u897f\u7b54\u5e94\u5e2e\u4f60\u8c03\u67e5\u71c3\u70e7\u5f39\u7684\u83b7\u53d6\u6e20\u9053\u3002";
        }
    }
    ,
    REBEL_BASE_FIREBOMBS_FINISH(QuestType.SIDE, 1, 5){

        @Override
        public String getName() {
            return "\u9f20\u4eba\u706b\u529b";
        }

        @Override
        public String getDescription() {
            return "\u7f57\u514b\u897f\u9700\u8981\u4e24\u5929\u65f6\u95f4\u624d\u80fd\u83b7\u5f97\u65b0\u7684\u71c3\u70e7\u5f39\u3002\u4f60\u6700\u597d\u5230\u65f6\u5019\u56de\u6765\u627e\u5979\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4e0d\u77e5\u4e3a\u4ec0\u4e48\uff0c\u7f57\u514b\u897f\u6ca1\u6709\u9a97\u4f60\uff0c\u4f60\u5f97\u5230\u4e86\u4e00\u6279\u71c3\u70e7\u5f39\u3002";
        }
    }
    ,
    REBEL_BASE_FIREBOMBS_FAILED(QuestType.SIDE, 1, 0){

        @Override
        public String getName() {
            return "\u4e0d\u60c5\u613f\u7684\u7f57\u514b\u897f";
        }

        @Override
        public String getDescription() {
            return "\u7f57\u514b\u897f\u624b\u5934\u6ca1\u6709\u6837\u54c1\uff0c\u5979\u65e0\u6cd5\u7406\u89e3\u4f55\u4e3a\u71c3\u70e7\u5f39\uff0c\u4ea6\u6216\u662f\u5979\u4e0d\u60f3\u5728\u4eff\u5236\u71c3\u70e7\u5f39\u8fd9\u4ef6\u4e8b\u4e0a\u6d6a\u8d39\u65f6\u95f4\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return this.getDescription();
        }
    }
    ,
    EISEK_STALL_QUEST_STAGE_ONE(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u6536\u96c6\u6750\u6599";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5df2\u7ecf\u77e5\u9053\u4e86\u827e\u745f\u514b\u88c5\u4fee\u644a\u4f4d\u6240\u9700\u7684\u6750\u6599\u4ee5\u53ca\u4ed6\u7684\u65b0\u62db\u724c\u4e0a\u60f3\u8981\u7684\u5185\u5bb9\u3002\u73b0\u5728\u4f60\u53ea\u9700\u8981\u4ece\u5c0f\u9547\u9644\u8fd1\u7684\u5546\u8d29\u90a3\u6536\u96c6\u8fd9\u4e9b\u6750\u6599\u6765\u7ed9\u4ed6\u4e00\u4e2a\u60ca\u559c\u3002\u4e5f\u8bb8\u9644\u8fd1\u4f1a\u6709\u4e00\u5bb6\u5e03\u5e97\uff1f";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5411\u83ab\u59ae\u5361\u8ba2\u8d2d\u4e86\u4e00\u4e2a\u65b0\u62db\u724c\u548c\u4e00\u4e9b\u5e03\u6599\u3002";
        }
    }
    ,
    EISEK_STALL_QUEST_STAGE_TWO(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u8fd9\u91cc\u9700\u8981\u4e00\u4e2a\u906e\u9633\u68da";
        }

        @Override
        public String getDescription() {
            return "\u7b49\u5f85\u83ab\u59ae\u5361\u5b8c\u6210\u4f60\u7684\u8ba2\u5355\u7684\u65f6\u5019\uff0c\u4f60\u9700\u8981\u627e\u4e00\u4e9b\u6728\u68cd\u6765\u642d\u5efa\u906e\u9633\u68da\u3002\u6216\u8bb8\u5f53\u5730\u7684\u94c1\u5320\u53ef\u4ee5\u62c6\u5378\u957f\u67c4\u6b66\u5668\u7684\u67c4\uff1f";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5df2\u7ecf\u5411\u56e0\u82cf\u548c\u9ed1\u5c14\u8ba2\u8d2d\u4e86\u4e00\u4e9b\u65a7\u5934\u7684\u67c4\u3002";
        }
    }
    ,
    EISEK_STALL_QUEST_STAGE_THREE(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u4e00\u5207\u90fd\u51c6\u5907\u5c31\u7eea\u3002";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5e94\u8be5\u5728\u4e00\u5929\u540e\u786e\u8ba4\u9ed1\u5c14\u7684\u8ba2\u5355\uff0c\u5728\u4e09\u5929\u540e\u786e\u8ba4\u83ab\u59ae\u5361\u7684\u8ba2\u5355\u90fd\u662f\u5426\u51c6\u5907\u597d\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5df2\u7ecf\u6536\u96c6\u4e86\u6240\u9700\u7684\u5168\u90e8\u6750\u6599\u3002";
        }
    }
    ,
    EISEK_STALL_QUEST_STAGE_FOUR(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u5168\u90e8\u7ec4\u88c5\u8d77\u6765";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5df2\u7ecf\u6709\u529e\u6cd5\u53bb\u6539\u9020\u827e\u745f\u514b\u7684\u644a\u4f4d\u4e86\u3002\u4e0b\u6b21\u89c1\u9762\u7684\u65f6\u5019\u544a\u8bc9\u4ed6\u5427\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u53ef\u4ee5\u80af\u5b9a\u5730\u8bf4\uff0c\u827e\u745f\u514b\u5bf9\u4f60\u4e3a\u4ed6\u6240\u505a\u7684\u4e00\u5207\u611f\u5230\u975e\u5e38\u9ad8\u5174\uff0c\u4ed6\u7684\u644a\u4f4d\u770b\u8d77\u6765\u6bd4\u4ee5\u5f80\u4efb\u4f55\u65f6\u5019\u90fd\u597d\u3002";
        }
    }
    ,
    EISEK_MOB_QUEST_STAGE_ONE(QuestType.SIDE, 10, 25){

        @Override
        public String getName() {
            return "\u4ee5\u4e00\u654c\u4f17";
        }

        @Override
        public String getDescription() {
            return "\u827e\u745f\u514b\u89e3\u91ca\u4e86\u4e3a\u4ec0\u4e48\u4f1a\u6709\u66b4\u5f92\u8ffd\u6740\u4ed6\uff0c\u4f46\u662f\u4ed6\u5e76\u4e0d\u8ba4\u8bc6\u4ed6\u4eec\u3002\u5982\u679c\u4f60\u60f3\u8981\u786e\u4fdd\u8fd9\u4e9b\u66b4\u5f92\u4e0d\u4f1a\u518d\u6765\uff0c\u4f60\u5e94\u8be5\u53bb\u627e\u5230\u4ed6\u4eec\u5e76\u4e0e\u5176\u5bf9\u5cd9\u3002<br/>\u4ed6\u4eec\u4f3c\u4e4e\u90fd\u662f\u672c\u5730\u4eba\uff0c\u53ef\u80fd\u5728\u9547\u4e0a\u627e\u627e\u5c31\u53ef\u4ee5\u627e\u5230\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u901a\u8fc7\u4e00\u70b9\u70b9\u8fd0\u6c14\u548c\u66b4\u5f92\u8d34\u5728\u5899\u4e0a\u7684\u5168\u5f69\u6d77\u62a5\uff0c\u4f60\u627e\u5230\u5e76\u8fdb\u5165\u4e86\u4ed6\u4eec\u7684\u636e\u70b9\u3002";
        }
    }
    ,
    EISEK_MOB_QUEST_STAGE_TWO(QuestType.SIDE, 10, 100){

        @Override
        public String getName() {
            return "\u79bb\u90a3\u9f99\u8fdc\u4e00\u70b9\uff01";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5df2\u7ecf\u627e\u5230\u4e86\u66b4\u5f92\u7684\u636e\u70b9\uff0c\u662f\u65f6\u5019\u5904\u7406\u4ed6\u4eec\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.getDialogueFlagValueFromId("dsg_elis_eisek_mob_quest_intimidate"))) {
                return "\u4f60\u51b3\u5b9a\u7528\u4f60\u90a3\u4ee4\u4eba\u751f\u754f\u7684\u529b\u91cf\u53bb\u8bf4\u670d\u66b4\u5f92\u8fdc\u79bb\u827e\u745f\u514b\u3002";
            }
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.getDialogueFlagValueFromId("dsg_elis_eisek_mob_quest_intimidate_arcane"))) {
                return "\u4f60\u51b3\u5b9a\u7528\u4f60\u7684\u5965\u672f\u80fd\u529b\u53bb\u8bf4\u670d\u66b4\u5f92\u8fdc\u79bb\u827e\u745f\u514b\u3002";
            }
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.getDialogueFlagValueFromId("dsg_elis_eisek_mob_quest_persuade"))) {
                if (!Main.game.isSillyModeEnabled()) {
                    return "\u4f60\u7528\u611f\u4eba\u7684\u8bdd\u8bed\u8bf4\u670d\u4e86\u66b4\u5f92\u8fdc\u79bb\u827e\u745f\u514b\u3002";
                }
                return "\u4f60\u7528\u4e8b\u5b9e\u548c\u5bcc\u6709\u903b\u8f91\u7684\u8bdd\u8bed\u63a8\u7ffb\u4e86\u66b4\u5f92\u7684\u89c2\u70b9\u3002";
            }
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.getDialogueFlagValueFromId("dsg_elis_eisek_mob_quest_seduce"))) {
                return "\u4f60\u7cbe\u901a\u6b32\u671b\u9b54\u6cd5\uff0c\u5229\u7528\u5b83\u717d\u52a8\u4e86\u4e00\u573a\u6deb\u8db4\uff0c\u4ece\u800c\u8bf4\u670d\u4e86\u66b4\u5f92\u8fdc\u79bb\u827e\u745f\u514b\u3002";
            }
            return "\u4f60\u6ca1\u80fd\u8bf4\u670d\u66b4\u5f92\u653e\u8fc7\u827e\u745f\u514b\u3002";
        }
    }
    ,
    EISEK_MOB_QUEST_STAGE_TWO_FAILED(QuestType.SIDE, 10, 0){

        @Override
        public String getName() {
            return "\u629b\u5f03";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u6ca1\u80fd\u6210\u529f\u8bf4\u670d\u66b4\u5f92\u653e\u8fc7\u827e\u745f\u514b\u3002\u4f60\u5e94\u8be5\u56de\u53bb\u544a\u8bc9\u4ed6\u8fd9\u4e2a\u574f\u6d88\u606f\u56e0\u4e3a\u4f60\u5904\u7406\u4e0d\u4e86\u90a3\u4e9b\u66b4\u5f92\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u6ca1\u80fd\u8bf4\u670d\u66b4\u5f92\u653e\u8fc7\u827e\u745f\u514b\u3002";
        }
    }
    ,
    EISEK_MOB_QUEST_STAGE_THREE_FAILED(QuestType.SIDE, 10, 0){

        @Override
        public String getName() {
            return "\u574f\u6d88\u606f";
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public String getCompletedDescription() {
            return "\u5c3d\u7ba1\u4ed6\u60f3\u8bd5\u56fe\u63a9\u76d6\uff0c\u4f46\u4ed6\u8fd8\u662f\u5bf9\u4e8e\u6709\u66b4\u5f92\u60f3\u6697\u7b97\u4ed6\u800c\u611f\u5230\u975e\u5e38\u4e0d\u5b89\u3002";
        }
    }
    ,
    EISEK_MOB_QUEST_STAGE_THREE(QuestType.SIDE, 10, 250){

        @Override
        public String getName() {
            return "\u597d\u6d88\u606f";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5df2\u7ecf\u89e3\u51b3\u4e86\u66b4\u5f92\uff0c\u73b0\u5728\u8be5\u56de\u53bb\u544a\u8bc9\u827e\u745f\u514b\u8fd9\u4e2a\u597d\u6d88\u606f\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u5c3d\u7ba1\u4ed6\u8bd5\u56fe\u63a9\u76d6\uff0c\u4f46\u8fd8\u662f\u8868\u73b0\u51fa\u4e86\u5bf9\u4e8e\u4e0d\u4f1a\u6709\u66b4\u5f92\u6253\u6270\u4ed6\u7684\u9ad8\u5174\u3002\u4f60\u751a\u81f3\u56e0\u6b64\u83b7\u5f97\u4e86\u4e00\u9897\u7a00\u6709\u7684\u706b\u9f99\u679c\u3002";
        }
    }
    ,
    EISEK_SILLYMODE_QUEST_STAGE_ONE(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u53e4\u602a\u7684\u4eba\u7fa4";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u9047\u5230\u53e6\u4e00\u7fa4\u5bf9\u827e\u745f\u514b\u5f02\u5e38\u75f4\u8ff7\u7684\u66b4\u5f92\uff0c\u867d\u7136\u65e0\u679c\u800c\u7ec8\uff0c\u4f46\u4f60\u8fd8\u662f\u60f3\u770b\u770b\u8fd9\u7fa4\u4eba\u5230\u5e95\u600e\u4e48\u56de\u4e8b\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u8fdb\u5165\u4e86\u4ed6\u4eec\u805a\u96c6\u7684\u5730\u4e0b\u5ba4\u3002";
        }
    }
    ,
    EISEK_SILLYMODE_QUEST_STAGE_TWO(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u6697\u9ed1\u5730\u7262";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5c3e\u968f\u5730\u4e0b\u5c45\u6c11\u8fd4\u56de\u4e86\u4ed6\u4eec\u7684\u5730\u4e0b\u5ba4\uff0c\u51b3\u5b9a\u8fdb\u53bb\u770b\u770b\u3002\u9057\u61be\u7684\u662f\u4ed6\u4eec\u4e0d\u592a\u559c\u6b22\u4f60\u7684\u975e\u6cd5\u5165\u4fb5\u884c\u4e3a\uff0c\u62e6\u4f4f\u4e86\u4f60\u7684\u53bb\u8def\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5f88\u63a5\u8fd1\u51fa\u53e3\u4e86\uff0c\u53ea\u5269\u4e0b\u4e00\u4e2a\u969c\u788d\u2026\u2026";
        }
    }
    ,
    EISEK_SILLYMODE_QUEST_STAGE_THREE(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u5730\u7262\u5df2\u901a\u5173";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u51fb\u8d25\u4e86\u8fd9\u53e4\u602a\u56e2\u4f19\u7684\u9996\u9886\uff0c\u5269\u4e0b\u8981\u505a\u7684\u5c31\u662f\u79bb\u5f00\u8fd9\u91cc\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u6210\u529f\u9003\u79bb\u4e86\u5730\u7262\uff0c\u8ba9\u8fd9\u7fa4\u8822\u8d27\u660e\u767d\u4e86\u8c01\u624d\u662f\u8001\u5927\u3002";
        }
    }
    ,
    OGLIX_BEER_BARRELS_1(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u5580\u620e\u7684\u6876";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u540c\u610f\u5e2e\u5965\u683c\u5229\u514b\u65af\u6269\u5927\u5976\u5564\u5993\u4e1a\u52a1\uff0c\u63a5\u4e0b\u6765\u7684\u4efb\u52a1\u662f\u524d\u5f80\u9152\u9986\u201c\u534a\u4eba\u9a6c\u4e4b\u5251\u201d\uff0c\u95ee\u95ee\u5e97\u4e3b\u5580\u620e\u6709\u6ca1\u6709\u95f2\u7f6e\u7684\u5907\u7528\u6876\u3002\u5982\u679c\u4ed6\u62d2\u7edd\u5e2e\u5fd9\uff0c\u6208\u5229\u514b\u65af\u5429\u5490\u4f60\u544a\u8bc9\u534a\u4eba\u9a6c\u201c\u6208\u5229\u514b\u65af\u8ba9\u4f60\u5f53\u53ea\u4e56\u5c0f\u9a6c\u201d\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u591a\u4e8f\u4e86\u7279\u6b8a\u5492\u8bed\u201c\u6208\u5229\u514b\u65af\u8ba9\u4f60\u5f53\u53ea\u4e56\u5c0f\u9a6c\u201d\uff0c\u4f60\u624d\u8bf4\u670d\u5580\u620e\u628a\u56db\u4e2a\u5907\u7528\u6876\u9001\u5230\u5965\u683c\u5229\u514b\u65af\u7684\u9152\u9986\u3002";
        }
    }
    ,
    OGLIX_BEER_BARRELS_2(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u4e56\u5c0f\u9a6c\u62a5\u544a";
        }

        @Override
        public String getDescription() {
            return "\u5728\u53d6\u5f97\u5580\u620e\u7684\u5e2e\u52a9\u540e\uff0c\u4f60\u9700\u8981\u56de\u53bb\u901a\u77e5\u5965\u683c\u5229\u514b\u65af\uff0c\u5580\u620e\u9009\u62e9\u6210\u4e3a\u6208\u5229\u514b\u65af\u7684\u201c\u4e56\u5c0f\u9a6c\u201d\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u56de\u53bb\u627e\u5230\u5965\u683c\u5229\u514b\u65af\uff0c\u544a\u8bc9\u5979\u4f60\u6210\u529f\u4e86\u3002\u5965\u683c\u5229\u514b\u65af\u83b7\u5f97\u4e86\u989d\u5916\u56db\u4e2a\u6876\uff0c\u53ef\u4ee5\u7528\u6765\u9501\u4f4f\u65b0\u7684\u5976\u5564\u5993\uff0c\u5979\u5e0c\u671b\u4f60\u4ece\u9644\u8fd1\u5c0f\u5df7\u7684\u72af\u7f6a\u8005\u4e2d\u5bfb\u627e\u5408\u9002\u7684\u4eba\u9009\u3002\u6b64\u5916\uff0c\u5979\u8bf4\u5982\u679c\u4f60\u60f3\u77e5\u9053\u201c\u6208\u5229\u514b\u65af\u8ba9\u4f60\u5f53\u53ea\u4e56\u5c0f\u9a6c\u201d\u8fd9\u53e5\u8bdd\u7684\u610f\u601d\uff0c\u5c31\u5728[units.time(6)]-[units.time(7)]\u4e4b\u95f4\u5077\u5077\u5230\u5979\u9152\u9986\u540e\u9762\u6765\u2026\u2026";
        }
    }
    ,
    LUNEXIS_ESCAPE(QuestType.SIDE, 1, 10){

        @Override
        public String getName() {
            return "\u91ca\u653e\u9732\u5185\u514b\u897f\u4e1d";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5c48\u670d\u4e8e\u9732\u5185\u514b\u897f\u4e1d\uff0c\u53d1\u8a93\u8981\u505a\u5979\u5fe0\u8bda\u7684\u9e21\u5df4\u5957\uff0c\u4f60\u7684\u65b0\u4e3b\u4eba\u547d\u4ee4\u4f60\u5e2e\u52a9\u5979\u9003\u79bb\u76d1\u7981\u3002\u4e3a\u4e86\u62a5\u590d\u5c06\u5979\u4f20\u9001\u5230\u4f0a\u5229\u65af\u7684\u4eba\uff0c\u534a\u4eba\u9a6c\u8bbe\u8ba1\u4e86\u4e00\u4e2a\u8ba1\u5212\uff0c\u4f60\u8981\u8bf4\u670d\u6885\u62c9\u514b\u897f\u4e1d\u5c06\u4f60\u4eec\u4e09\u4eba\u4f20\u9001\u56de\u7279\u5f25\u65af\u5e93\u62c9\u3002\u4e00\u65e6\u56de\u5230\u90a3\u91cc\uff0c\u4f60\u7684\u4e3b\u4eba\u5c31\u4f1a\u5956\u52b1\u4f60\uff0c\u8ba9\u4f60\u6210\u4e3a\u5176\u4e2d\u4e00\u4e2a\u79c1\u4eba\u9e21\u5df4\u5957\u5974\u96b6\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u8bf4\u670d\u4e86\u6885\u62c9\u514b\u897f\u4e1d\uff0c\u5c06\u5979\u81ea\u5df1\u8fde\u540c\u4f60\u548c\u9732\u5185\u514b\u897f\u4e1d\u4e00\u8d77\u4f20\u9001\u56de\u7279\u5f25\u65af\u5e93\u62c9\u3002\u56de\u5230\u90a3\u91cc\uff0c\u4f60\u7684\u6b3a\u9a97\u5c31\u662d\u7136\u82e5\u63ed\u4e86\u3002\u5c3d\u7ba1\u6885\u62c9\u514b\u897f\u4e1d\u8bd5\u56fe\u6218\u6597\uff0c\u4f46\u5f88\u5feb\u5c31\u88ab\u5236\u670d\uff0c\u4f60\u7684\u4e3b\u4eba\u5229\u7528\u5979\u8d62\u56de\u4e86\u534a\u4eba\u9a6c\u90e8\u961f\u52a8\u6447\u7684\u5fe0\u8bda\u3002";
        }
    }
    ,
    LUNEXIS_ESCAPE_FAILED(QuestType.SIDE, 1, 0){

        @Override
        public String getName() {
            return "\u80cc\u53db\u9732\u5185\u514b\u897f\u4e1d";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u51b3\u5b9a\u80cc\u53db\u9732\u5185\u514b\u897f\u4e1d\uff0c\u5411\u6885\u62c9\u514b\u897f\u4e1d\u5766\u767d\u4e00\u5207\uff0c\u4e4b\u540e\u4f60\u88ab\u7981\u6b62\u4e0e\u6076\u9b54\u534a\u4eba\u9a6c\u6709\u4efb\u4f55\u8fdb\u4e00\u6b65\u7684\u63a5\u89e6\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return this.getDescription();
        }
    }
    ,
    DOLL_FACTORY_1(QuestType.SIDE, 30, 10){

        @Override
        public String getName() {
            return "\u8c03\u67e5\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97";
        }

        @Override
        public String getDescription() {
            return "\u5b89\u5409\u8389\u514b\u4e1d\u7684\u65e5\u8bb0\u91cc\u63d0\u5230\uff0c\u88ab\u7ed1\u67b6\u7684\u96be\u6c11\u90fd\u88ab\u4f20\u9001\u5230\u4e86\u5fa1\u57ce\u533a\u7684\u201c\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u201d\u3002\u5982\u679c\u4f60\u60f3\u4e86\u89e3\u5b89\u5409\u8389\u514b\u4e1d\u7684\u53d7\u5bb3\u8005\u7ecf\u5386\u4e86\u4ec0\u4e48\uff0c\u90a3\u4f60\u9700\u8981\u8c03\u67e5\u8fd9\u5bb6\u5546\u5e97\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u6765\u5230\u201c\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u201d\uff0c\u8bd5\u56fe\u67e5\u660e\u5b89\u5409\u8389\u514b\u4e1d\u7ed1\u67b6\u7684\u96be\u6c11\u662f\u5426\u88ab\u5e26\u5230\u4e86\u90a3\u91cc\u3002\u867d\u7136\u4ec0\u4e48\u90fd\u6ca1\u53d1\u73b0\uff0c\u4f46\u5f53\u4f60\u51c6\u5907\u79bb\u5f00\u65f6\uff0c\u4e00\u4e2a\u540d\u53eb\u83f2\u4e9a\u6885\u5854\u7684\u8bb0\u8005\u63a5\u8fd1\u4f60\u5e76\u63d0\u4f9b\u4e86\u5e2e\u52a9\u3002";
        }
    }
    ,
    DOLL_FACTORY_2(QuestType.SIDE, 30, 10){

        @Override
        public String getName() {
            return "\u7a81\u7834\u8fdb\u5165";
        }

        @Override
        public String getDescription() {
            return "\u83f2\u4e9a\u6885\u5854\u77e5\u9053\u6709\u6761\u6697\u9053\u80fd\u591f\u8fdb\u5165\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u540e\u65b9\uff0c\u5979\u8ba4\u5b9a\u88ab\u7ed1\u67b6\u7684\u96be\u6c11\u5c31\u5728\u90a3\u91cc\uff0c\u505a\u5974\u96b6\u52b3\u5de5\u3002\u4f60\u4e5f\u6ca1\u6709\u5176\u4ed6\u65b9\u5f0f\u5f97\u77e5\u4e0b\u9762\u7a76\u7adf\u53d1\u751f\u4e86\u4ec0\u4e48\uff0c\u4e8e\u662f\u540c\u610f\u4e86\u5979\u7684\u8ba1\u5212\uff0c\u5e76\u7ea6\u5b9a[units.time(1)]-[units.time(4)]\u4e4b\u95f4\u5728\u5546\u5e97\u9644\u8fd1\u89c1\u9762\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5728\u201c\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u201d\u5916\u89c1\u5230\u4e86\u83f2\u4e9a\u6885\u5854\uff0c\u5e76\u5728\u6ca1\u6709\u89e6\u53d1\u62a5\u8b66\u7cfb\u7edf\u7684\u60c5\u51b5\u4e0b\u4ece\u540e\u9762\u95ef\u5165\u4e86\u623f\u5c4b\u3002";
        }
    }
    ,
    DOLL_FACTORY_3(QuestType.SIDE, 30, 10){

        @Override
        public String getName() {
            return "\u8ffd\u6839\u7a76\u5e95";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5df2\u7ecf\u6210\u529f\u8fdb\u5165\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u7684\u540e\u65b9\uff0c\u641c\u67e5\u4e00\u4e0b\u88ab\u7ed1\u67b6\u7684\u96be\u6c11\u7684\u6240\u5728\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u53d1\u73b0\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u7684\u540e\u65b9\u6709\u4e00\u53f0\u5de8\u5927\u7684\u7535\u68af\uff0c\u5750\u7535\u68af\u4e0b\u53bb\u540e\uff0c\u7adf\u627e\u5230\u5fa1\u57ce\u533a\u5730\u4e0b\u9690\u85cf\u7684\u4e00\u4e2a\u5de8\u578b\u8bbe\u65bd\u3002";
        }
    }
    ,
    DOLL_FACTORY_4(QuestType.SIDE, 30, 10){

        @Override
        public String getName() {
            return "\u6536\u96c6\u8bc1\u636e";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u548c\u83f2\u4e9a\u6885\u5854\u9700\u8981\u5bfb\u627e\u96be\u6c11\u906d\u9047\u7684\u86db\u4e1d\u9a6c\u8ff9\u3002\u80af\u5b9a\u80fd\u5728\u67d0\u4e2a\u5730\u65b9\u627e\u5230\u8d26\u672c\u3001\u673a\u5668\u539f\u7406\u56fe\u6216\u8005\u8bf8\u5982\u6b64\u7c7b\u7684\u6587\u4ef6\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u6536\u96c6\u5230\u4e86\u786e\u51ff\u8bc1\u636e\uff0c\u80fd\u8bc1\u660e\u62c9\u7279\u91cc\u514b\u65af\u548c\u5b89\u5409\u8389\u514b\u4e1d\u53c2\u4e0e\u4e86\u7ed1\u67b6\u4e0e\u975e\u6cd5\u5974\u5f79\uff0c\u5e76\u4e14\u5f97\u77e5\u4e86\u6d1b\u7ef4\u8036\u7eb3\u7684\u73a9\u5076\u7684\u6050\u6016\u5236\u9020\u65b9\u6cd5\u3002";
        }
    }
    ,
    DOLL_FACTORY_5(QuestType.SIDE, 30, 250){

        @Override
        public String getName() {
            return "\u8be5\u79bb\u5f00\u4e86";
        }

        @Override
        public String getDescription() {
            return "\u65e2\u7136\u83f2\u4e9a\u5df2\u7ecf\u6536\u96c6\u5230\u8db3\u591f\u8bc1\u636e\u5c06\u62a5\u9053\u53d1\u8868\uff0c\u4f60\u4eec\u4e24\u4e2a\u73b0\u5728\u9700\u8981\u4ece\u5de5\u5382\u4e2d\u9003\u79bb\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u548c\u83f2\u4e9a\u6210\u529f\u4ece\u5730\u4e0b\u5de5\u5382\u9003\u4e86\u51fa\u6765\u3002";
        }
    }
    ,
    DOLL_FACTORY_5_DOLLIFIED(QuestType.SIDE, 30, 250){

        @Override
        public String getName() {
            return "\u8981\u53d8\u6210\u73a9\u5076\u4e86\uff01";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u88ab\u5b89\u5409\u8389\u514b\u4e1d\u6293\u4f4f\u4e86\uff0c\u5979\u5c06\u4f60\u53d8\u6210\u4e86\u73a9\u5076\uff01\u4f60\u73b0\u5728\u6025\u9700\u627e\u5230\u83f2\u4e9a\uff0c\u5728\u5979\u7684\u5e2e\u52a9\u4e0b\u53d6\u6d88\u8fd9\u4e2a\u53ef\u6015\u7684\u8f6c\u5316\u3002<br/>[style.italics(\u4f60\u9700\u8981\u641c\u5bfb\u5e76\u8c03\u67e5\u5de5\u5382\u5185\u56db\u4e2a)][style.italicsExcellent(\u9ec4\u8272)][style.italics(\u7684\u5730\u5757\u6765\u5bfb\u627e\u83f2\u4e9a\u3002)]";
        }

        @Override
        public String getCompletedDescription() {
            return "\u5b89\u5409\u8389\u514b\u4e1d\u628a\u4f60\u8f6c\u5316\u6210\u4e86\u73a9\u5076\uff0c\u4e0d\u8fc7\u4f60\u8bbe\u6cd5\u627e\u5230\u4e86\u83f2\u4e9a\u5e76\u9006\u8f6c\u4e86\u73a9\u5076\u5316\u8fdb\u7a0b\uff0c\u4e4b\u540e\u4f60\u548c\u83f2\u4e9a\u4e00\u8d77\u9003\u79bb\u4e86\u5de5\u5382\u3002";
        }
    }
    ,
    DOLL_FACTORY_6(QuestType.SIDE, 30, 500){

        @Override
        public String getName() {
            return "\u83f2\u4e9a\u6885\u5854\u7684\u6d88\u606f";
        }

        @Override
        public String getDescription() {
            return "\u83f2\u4e9a\u6885\u5854\u4fdd\u8bc1\u4f1a\u5199\u4e00\u7bc7\u6587\u7ae0\uff0c\u5c06\u4f60\u4eec\u4e8c\u4eba\u5728\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u76ee\u7779\u7684\u4e00\u4e9b\u516c\u4e4b\u4e8e\u4f17\u3002\u5979\u8fd8\u8bf4\u597d\u4e86\u53ea\u8981\u505a\u597d\u53d1\u8868\u7684\u51c6\u5907\uff0c\u5c31\u9a6c\u4e0a\u7ed9\u4f60\u6d88\u606f\u3002<br/>[style.italicsMinorGood(\u5df2\u7ecf\u8fc7\u4e86\u597d\u51e0\u5929\uff0c\u767d\u5929\u7684\u65f6\u5019\u68c0\u67e5\u4e00\u4e0b\u8389\u83b1\u96c5\u5b85\u90b8\u7684\u95e8\u5385\u5427\u3002)]";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5e76\u6ca1\u6709\u7b49\u5230\u83f2\u4e9a\u6885\u5854\u7684\u6d88\u606f\uff0c\u53cd\u800c\u9047\u5230\u4e86\u8d5b\u62c9\u7279\u91cc\u514b\u65af\u3002\u5979\u5229\u7528\u81ea\u5df1\u4e0e\u8389\u83b1\u96c5\u7684\u4eb2\u5bc6\u5173\u7cfb\uff0c\u5c06\u4f60\u903c\u5165\u56f0\u5883\u5e76\u8981\u6c42\u4f60\u7b7e\u7f72\u4e00\u4efd\u6587\u4ef6\uff0c\u5ba3\u79f0\u83f2\u4e9a\u6885\u5854\u8bf4\u7684\u90fd\u662f\u8c0e\u8bdd\u3002";
        }
    }
    ,
    DOLL_FACTORY_7A(QuestType.SIDE, 30, 10){

        @Override
        public String getName() {
            return "\u8bda\u4fe1\u81f3\u4e0a";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u62d2\u7edd\u4e0e\u8d5b\u62c9\u7279\u91cc\u514b\u65af\u540c\u6d41\u5408\u6c61\uff0c\u53cd\u800c\u53d1\u8a93\u5fc5\u5b9a\u4f1a\u8bb2\u51fa\u771f\u76f8\uff0c\u4e3a\u83f2\u4e9a\u6885\u5854\u6587\u7ae0\u4e2d\u6240\u5199\u7684\u4e00\u5207\u80cc\u4e66\u3002\u8d5b\u62c9\u7279\u91cc\u514b\u65af\u8bf4\u5979\u4f1a\u5c06\u5546\u5e97\u5173\u505c\u4e00\u5230\u4e24\u5468\u7684\u65f6\u95f4\uff0c\u4ee5\u7b49\u5f85\u516c\u4f17\u7684\u6124\u6012\u5e73\u606f\uff0c\u4e4b\u540e\u5979\u4fbf\u8fc5\u901f\u5730\u79bb\u5f00\u4e86\u5b85\u90b8\u3002<br/>[style.italicsMinorGood(\u4f60\u6253\u7b97\u5728\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u91cd\u65b0\u5f00\u4e1a\u4e4b\u540e\uff0c\u56de\u53bb\u770b\u770b\u73a9\u5076\u4eec\u600e\u4e48\u6837\u4e86\u2026\u2026)]";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u62d2\u7edd\u4e0e\u8d5b\u62c9\u7279\u91cc\u514b\u65af\u540c\u6d41\u5408\u6c61\uff0c\u53cd\u800c\u53d1\u8a93\u5fc5\u5b9a\u4f1a\u8bb2\u51fa\u771f\u76f8\uff0c\u4e3a\u83f2\u4e9a\u6885\u5854\u6587\u7ae0\u4e2d\u6240\u5199\u7684\u4e00\u5207\u80cc\u4e66\u3002\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u5173\u505c\u4e00\u5468\u540e\uff0c\u4f60\u53c8\u4e00\u6b21\u56de\u5230\u4e86\u8fd9\u91cc\uff0c\u4f60\u53d1\u73b0\u5b89\u5409\u8389\u514b\u4e1d\u88ab\u8ba4\u5b9a\u4e3a\u4e86\u975e\u6cd5\u5974\u5f79\u4e8b\u4ef6\u80cc\u540e\u7684\u4e3b\u8c0b\uff0c\u800c\u8d5b\u62c9\u7279\u91cc\u514b\u65af\u73b0\u5728\u53ea\u88ab\u5141\u8bb8\u5c06\u6700\u6076\u52a3\u7684\u7f6a\u72af\u8f6c\u5316\u4e3a\u73a9\u5076\u3002<br/>\u6b64\u5916\uff0c\u8d5b\u62c9\u7279\u91cc\u514b\u65af\u5e76\u4e0d\u60f3\u4e0e\u4f60\u4e3a\u654c\uff0c\u5979\u70ed\u5207\u5730\u5e0c\u671b\u80fd\u7559\u4f4f\u4f60\u8fd9\u540d\u987e\u5ba2\uff0c\u751a\u81f3\u5c06\u5b89\u5409\u8389\u514b\u4e1d\u7684\u5904\u7f6e\u6743\u4e5f\u4ea4\u5230\u4e86\u4f60\u7684\u624b\u91cc\u2026\u2026";
        }
    }
    ,
    DOLL_FACTORY_7B(QuestType.SIDE, 30, 10){

        @Override
        public String getName() {
            return "\u591a\u597d\u7684\u751f\u610f";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u80cc\u5f03\u4e86\u83f2\u4e9a\u6885\u5854\u7684\u4fe1\u4efb\uff0c\u5728\u6587\u4ef6\u4e0a\u7b7e\u4e0b\u4e86\u540d\u5b57\uff0c\u5ba3\u79f0\u62a5\u544a\u4e2d\u8c0e\u8bdd\u8fde\u7bc7\u3002\u8d5b\u62c9\u7279\u91cc\u514b\u65af\u5bf9\u4f60\u7684\u51b3\u5b9a\u5341\u5206\u6ee1\u610f\uff0c\u9080\u8bf7\u4f60\u5728\u5546\u5e97\u91cd\u65b0\u5f00\u4e1a\u540e\u518d\u5149\u987e\u4e00\u6b21\uff0c\u5979\u4e3a\u4f60\u51c6\u5907\u4e86\u4e9b\u7279\u522b\u7684\u5956\u52b1\u2026\u2026<br/>[style.italicsMinorGood(\u7b49\u8fc7\u51e0\u5929\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u91cd\u65b0\u5f00\u4e1a\u4e4b\u540e\uff0c\u4f60\u6253\u7b97\u518d\u53bb\u4e00\u8d9f\u2026\u2026)]";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u80cc\u5f03\u4e86\u83f2\u4e9a\u6885\u5854\u7684\u4fe1\u4efb\uff0c\u5728\u6587\u4ef6\u4e0a\u7b7e\u4e0b\u4e86\u540d\u5b57\uff0c\u5ba3\u79f0\u62a5\u544a\u4e2d\u8c0e\u8bdd\u8fde\u7bc7\u3002\u4f5c\u4e3a\u62a5\u7b54\uff0c\u8d5b\u62c9\u7279\u91cc\u514b\u65af\u53ef\u4ee5\u8ba9\u4f60\u53ea\u82b1\u4e00\u7b14\u5c0f\u94b1\u5c31\u5e2e\u4f60\u628a\u4f60\u7684\u5974\u96b6\u8f6c\u5316\u4e3a\u73a9\u5076\uff0c\u5982\u679c\u4f60\u5c06\u5176\u653e\u5728\u5e97\u4e2d\u552e\u5356\uff0c\u5979\u4e5f\u4f1a\u4ea4\u7ed9\u4f60\u5e94\u5f97\u7684\u94b1\u3002";
        }
    }
    ,
    RELATIONSHIP_NYAN_1_STOCK_ISSUES(QuestType.RELATIONSHIP, 1, 0){

        @Override
        public String getName() {
            return "\u5e2e\u52a9\u59ae\u5b89";
        }

        @Override
        public String getDescription() {
            return "\u59ae\u5b89\u89e3\u91ca\u8bf4\uff0c\u7531\u4e8e\u4f9b\u8d27\u5546\u7a81\u7136\u5931\u53bb\u8054\u7cfb\uff0c\u9644\u9b54\u670d\u88c5\u7684\u8d27\u6e90\u88ab\u6390\u65ad\u4e86\u3002\u663e\u800c\u6613\u89c1\uff0c\u8fd9\u4f9b\u8d27\u5546\u4ee5\u524d\u548c\u59ae\u5b89\u5173\u7cfb\u4e0d\u9519\uff0c\u4ed6\u7684\u53cd\u5e38\u4e3e\u52a8\u8ba9\u7d27\u5f20\u7684\u732b\u5973\u6000\u7591\u4ed6\u906d\u9047\u4ec0\u4e48\u53ef\u6015\u7684\u4e8b\u60c5\u3002<br/>\u4e5f\u8bb8\u4f60\u53ef\u4ee5\u5e2e\u52a9\u59ae\u5b89\u627e\u51fa\u4f9b\u8d27\u5546\u7684\u4e0b\u843d\uff1f";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5411\u59ae\u5b89\u4f38\u51fa\u63f4\u624b\uff0c\u52a9\u5979\u67e5\u6e05\u9644\u9b54\u670d\u88c5\u4f9b\u5e94\u5546\u5230\u5e95\u906d\u9047\u4e86\u4ec0\u4e48\u3002";
        }
    }
    ,
    RELATIONSHIP_NYAN_2_STOCK_ISSUES_AGREED_TO_HELP(QuestType.RELATIONSHIP, 1, 25){

        @Override
        public String getName() {
            return "\u6551\u51ef";
        }

        @Override
        public String getDescription() {
            return "\u59ae\u5b89\u544a\u8bc9\u4f60\uff0c\u5979\u7684\u4f9b\u8d27\u5546[kay.nameFull]\u5728\u5fa1\u57ce\u533a\u7684\u4ed3\u5e93\u5f00\u5c55\u4e1a\u52a1\u3002\u4f60\u9700\u8981\u524d\u5f80\u57ce\u5e02\u897f\u504f\u5317\u7684\u5730\u65b9\uff0c\u627e\u5230\u51ef\u7684\u4ed3\u5e93\uff0c\u4e86\u89e3\u4ed6\u4e3a\u4ec0\u4e48\u7a81\u7136\u5207\u65ad\u4e86\u4e0e\u59ae\u5b89\u7684\u6240\u6709\u8054\u7cfb\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u627e\u5230\u4e86\u51ef\u7684\u4ed3\u5e93\uff0c\u53d1\u73b0\u4ed6\u7684\u751f\u610f\u5b9e\u9645\u4e0a\u5df2\u7ecf\u88ab\u4e00\u5bf9\u6043\u5f3a\u51cc\u5f31\u7684\u8d4f\u91d1\u730e\u4eba\u62a2\u8d70\u4e86\u3002";
        }
    }
    ,
    RELATIONSHIP_NYAN_3_STOCK_ISSUES_DOBERMANNS(QuestType.RELATIONSHIP, 10, 100){

        @Override
        public String getName() {
            return "\u8d4f\u91d1\u6076\u9738\u5144\u5f1f";
        }

        @Override
        public String getDescription() {
            return "\u6c83\u5c14\u592b\u5188\u548c\u5361\u5c14\u662f\u4e00\u5bf9\u8d4f\u91d1\u730e\u4eba\uff0c\u53d7\u51ef\u7684\u96c7\u4f63\u6765\u4fdd\u62a4\u4ed6\u7684\u4ed3\u5e93\uff0c\u4f46\u4ed6\u4eec\u80cc\u53db\u4e86\u96c7\u4e3b\uff0c\u5b9e\u9645\u4e0a\u5168\u76d8\u63a7\u5236\u4f4f\u4e86\u4ed6\u7684\u751f\u610f\u6765\u5f80\u3002\u4e0d\u7ba1\u7528\u4ec0\u4e48\u529e\u6cd5\uff0c\u4f60\u90fd\u5f97\u8bf4\u670d\u8fd9\u4e9b\u675c\u5bbe\u6076\u9738\uff0c\u8ba9\u4ed6\u4eec\u79bb\u51ef\u8fdc\u70b9\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u641e\u5b9a\u4e86\u6c83\u5c14\u592b\u5188\u548c\u5361\u5c14\uff0c\u8ba9\u4ed6\u4eec\u6eda\u56de\u5974\u96b6\u5df7\u7684\u201c\u8d4f\u91d1\u730e\u4eba\u5c0f\u5c4b\u201d\u3002\u73b0\u5728\uff0c\u4f60\u65e2\u4fdd\u4f4f\u4e86\u51ef\u7684\u751f\u610f\uff0c\u53c8\u8ba9\u59ae\u5b89\u6062\u590d\u4e86\u9644\u9b54\u670d\u9970\u7684\u5e93\u5b58\u3002\u51ef\u8868\u793a\u6c38\u8fdc\u4e0d\u4f1a\u5fd8\u8bb0\u4f60\u7684\u6069\u60c5\uff0c\u6b22\u8fce\u4f60\u968f\u65f6\u6765\u627e\u4ed6\u3002";
        }
    }
    ,
    RELATIONSHIP_NYAN_4_STOCK_ISSUES_SUPPLIERS_BEATEN(QuestType.RELATIONSHIP, 1, 25){

        @Override
        public String getName() {
            return "\u59ae\u5b89\u7684\u5956\u52b1";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u5df2\u7ecf\u62ef\u6551\u4e86\u51ef\u7684\u751f\u610f\uff0c\u73b0\u5728\u8be5\u56de\u53bb\u544a\u8bc9\u59ae\u5b89\u53d1\u751f\u4e86\u4ec0\u4e48\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u59ae\u5b89\u9ad8\u5174\u6781\u4e86\uff0c\u4e0d\u4ec5\u4ed8\u4e86\u4e8b\u5148\u7ea6\u5b9a\u7684\u62a5\u916c\uff0c\u8fd8\u8868\u793a\u5546\u5e97\u4ee5\u540e\u90fd\u4f1a\u7ed9\u4f60\u63d0\u4f9b\u4e03\u4e94\u6298\u7684\u7ec8\u8eab\u4f18\u60e0\u3002\u5979\u8fd8\u900f\u9732\u81ea\u5df1\u662f\u5355\u8eab\uff0c\u7b28\u7b28\u5730\u5411\u4f60\u642d\u8baa\u2026\u2026";
        }
    }
    ,
    ROMANCE_HELENA_FAILED(QuestType.RELATIONSHIP, 1, 0){

        @Override
        public String getName() {
            return "\u76db\u6012\u7684\u65cf\u957f";
        }

        @Override
        public String getDescription() {
            return "\u5728\u4f60\u62d2\u7edd\u628a\u65af\u5609\u4e3d\u5356\u7ed9\u6d77\u4f26\u5a1c\u540e\uff0c\u8fd9\u4f4d\u54c8\u6bd4\u65cf\u957f\u653e\u5f03\u4e86\u5979\u7ecf\u8425\u5974\u96b6\u4e70\u5356\u7684\u8ba1\u5212\u5e76\u6124\u6012\u7684\u56de\u5de2\u4e86\u3002\u5979\u8d70\u4e4b\u524d\u975e\u5e38\u65e0\u60c5\u7684\u8fb1\u9a82\u4e86\u4f60\uff0c\u4f60\u53ef\u4ee5\u80af\u5b9a\u5979\u518d\u4e5f\u4e0d\u60f3\u89c1\u5230\u4f60\u4e86\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return this.getDescription();
        }
    }
    ,
    ROMANCE_HELENA_1_OFFER_HELP(QuestType.RELATIONSHIP, 1, 5){

        @Override
        public String getName() {
            return "\u63d0\u4f9b\u5e2e\u52a9";
        }

        @Override
        public String getDescription() {
            return "\u5728\u5411\u6d77\u4f26\u5a1c\u6253\u542c\u8fc7\u5979\u7684\u751f\u610f\u540e\uff0c\u4f60\u53d1\u73b0\u5979\u53ea\u80fd\u52c9\u5f3a\u7ef4\u6301\u7740\u6b64\u5904\u7684\u8fd0\u8f6c\u3002\u5728\u6d77\u4f26\u5a1c\u8868\u8fbe\u4e86\u5979\u5bf9\u4e8e\u5546\u5e97\u6539\u9020\u7684\u60f3\u6cd5\u540e\uff0c\u5979\u8868\u793a\u5979\u6839\u672c\u6ca1\u6709\u65f6\u95f4\u4e5f\u6ca1\u6709\u5174\u8da3\u5b8c\u6210\u8fd9\u4e2a\u5de5\u4f5c\u3002\u6216\u8bb8\u4f60\u53ef\u4ee5\u63d0\u4f9b\u70b9\u5e2e\u52a9\uff1f";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5411\u6d77\u4f26\u5a1c\u4f38\u51fa\u63f4\u624b\uff0c\u5e2e\u52a9\u5546\u5e97\u8fdb\u884c\u6539\u5584\u3002";
        }
    }
    ,
    ROMANCE_HELENA_2_PURCHASE_PAINT(QuestType.RELATIONSHIP, 1, 25){

        @Override
        public String getName() {
            return "\u8d2d\u4e70\u989c\u6599";
        }

        @Override
        public String getDescription() {
            return "\u6d77\u4f26\u5a1c\u63d0\u53ca\u4e86\u5979\u60f3\u505a\u7684\u7b2c\u4e00\u4ef6\u4e8b\uff0c\u91cd\u65b0\u7c89\u5237\u6574\u4e2a\u5e97\u94fa\u7684\u5916\u89c2\u3002\u54c8\u6bd4\u6ca1\u6709\u7ed9\u4f60\u63d0\u4f9b\u4efb\u4f55\u8d44\u91d1\uff0c\u4e14\u5e0c\u671b\u4f60\u53bb\u201c\u963f\u683c\u65af\u7684DIY\u4ed3\u5e93\u201d\u4e70\u4e00\u7f50\u201c\u7d2b\u661f\u201d\u724c\u91d1\u8272\u989c\u6599\u3002\u5728\u8d2d\u4e70\u540e\uff0c\u4f60\u9700\u8981\u56de\u53bb\u627e\u6d77\u4f26\u5a1c\u3002<br/><i>(\u201c\u963f\u683c\u65af\u7684DIY\u4ed3\u5e93\u201d\u53ef\u4ee5\u5728\u5974\u96b6\u5df7\u7684\u5357\u4fa7\u627e\u5230\uff0c\u5c31\u5728\u8fd0\u6cb3\u65c1\u8fb9\u3002)</i>";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u4ece\u201c\u963f\u683c\u65af\u7684DIY\u4ed3\u5e93\u201d\u5904\u8d2d\u4e70\u4e86\u9700\u6c42\u7269\u54c1\uff0c\u5e76\u8fd4\u56de\u53bb\u627e\u6d77\u4f26\u5a1c\u3002";
        }
    }
    ,
    ROMANCE_HELENA_3_A_EXTERIOR_DECORATOR(QuestType.RELATIONSHIP, 1, 10){

        @Override
        public String getName() {
            return "\u5ba4\u5916\u88c5\u9970\u5de5(1/3)";
        }

        @Override
        public String getDescription() {
            return "\u5728\u4f60\u4e70\u5230\u91d1\u8272\u6cb9\u6f06\u540e\u4f60\u56de\u5230\u6d77\u4f26\u5a1c\u7684\u5546\u5e97\uff0c\u5979\u8981\u6c42\u4f60\u5c3d\u5feb\u5f00\u59cb\u91cd\u65b0\u7c89\u5237\u5979\u7684\u5546\u5e97\u5916\u90e8\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u522e\u6389\u4e86\u6d77\u4f26\u5a1c\u5546\u5e97\u524d\u9762\u7684\u65e7\u6cb9\u6f06\u3002";
        }
    }
    ,
    ROMANCE_HELENA_3_B_EXTERIOR_DECORATOR(QuestType.RELATIONSHIP, 1, 10){

        @Override
        public String getName() {
            return "\u5ba4\u5916\u88c5\u9970\u5de5(2/3)";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u9700\u8981\u5728\u8425\u4e1a\u65f6\u95f4\u56de\u5230\u6d77\u4f26\u5a1c\u7684\u5546\u5e97\u6765\u786e\u8ba4\u4f60\u7684\u4e0b\u4e00\u4e2a\u4efb\u52a1\u662f\u4ec0\u4e48\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u91cd\u65b0\u7c89\u5237\u4e86\u6d77\u4f26\u5a1c\u5546\u5e97\u7684\u6b63\u9762\uff0c\u5e76\u4e14\u6536\u5230\u4e86\u5a1c\u5854\u8389\u4e9a\u9001\u6765\u7684\u5bb6\u5177\u3002";
        }
    }
    ,
    ROMANCE_HELENA_3_C_EXTERIOR_DECORATOR(QuestType.RELATIONSHIP, 1, 10){

        @Override
        public String getName() {
            return "\u5ba4\u5916\u88c5\u9970\u5de5(3/3)";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u9700\u8981\u5728\u8425\u4e1a\u65f6\u95f4\u56de\u5230\u6d77\u4f26\u5a1c\u7684\u5546\u5e97\u6765\u786e\u8ba4\u4f60\u7684\u4e0b\u4e00\u4e2a\u4efb\u52a1\u662f\u4ec0\u4e48\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u5728\u54c8\u6bd4\u65cf\u957f\u7684\u76d1\u7763\u4e0b\uff0c\u4f60\u5728\u5979\u7684\u5e97\u94fa\u95e8\u4e0a\u7528\u91d1\u5b57\u5199\u4e0b\u201c\u6d77\u4f26\u5a1c\u7cbe\u54c1\u5e97\u201d\u3002";
        }
    }
    ,
    ROMANCE_HELENA_4_SCARLETTS_RETURN(QuestType.RELATIONSHIP, 1, 100){

        @Override
        public String getName() {
            return "\u65af\u5609\u4e3d\u5f52\u6765";
        }

        @Override
        public String getDescription() {
            boolean playerOwner;
            boolean slave = Main.game.getNpc(Scarlett.class).isSlave() || Main.game.getNpc(Scarlett.class).getHomeWorldLocation() == WorldType.EMPTY;
            boolean bl = playerOwner = Main.game.getNpc(Scarlett.class).isSlave() && Main.game.getNpc(Scarlett.class).getOwner().isPlayer();
            return "\u6d77\u4f26\u5a1c\u5411\u4f60\u900f\u9732\u9053\u5979\u8ba1\u5212\u5c06\u5979\u7684\u5974\u96b6\u5e97\u53d8\u6210\u4e00\u4e2a\u53ef\u4ee5\u8ba9\u5ba2\u6237\u5b9a\u5236\u5974\u96b6\u7684\u5730\u65b9\u3002\u5979\u60f3\u8ba9\u5979\u4ee5\u524d\u7684\u793c\u4eea\u8001\u5e08\u6765\u8bad\u7ec3\u8fd9\u4e9b\u5974\u96b6\uff0c\u90a3\u4e2a\u4eba\u6b63\u662f\u65af\u5609\u4e3d\u7684\u59d0\u59b9\u3002" + (String)(slave ? "\u5979\u7ed9\u6d77\u4f26\u5a1c\u7684\u6761\u4ef6\u662f\u8ba9\u5979\u4efb\u6027\u7684\u59b9\u59b9\u83b7\u5f97\u81ea\u7531\uff0c\u4fdd\u8bc1\u4e0d\u518d\u5974\u5f79\u5979\u800c\u4e14\u8ba9\u5979\u7ee7\u7eed\u5de5\u4f5c\u2026\u2026<br/>" + (playerOwner ? "\u4f60\u628a\u65af\u5609\u4e3d\u5e26\u7ed9\u6d77\u4f26\u5a1c\u5e76\u5356\u7ed9\u5979\u2026\u2026" : "\u4f60\u9700\u8981\u627e\u5230\u65af\u5609\u4e3d\u5e76\u4ece\u5979\u7684\u65b0\u4e3b\u4eba\u90a3\u91cc\u4e70\u4e0b\u5979\u3002\u636e\u6d77\u4f26\u5a1c\u6240\u8bf4\uff0c\u5979\u662f\u88ab\u8d2d\u7269\u4e2d\u5fc3\u91cc\u7684\u53e4\u8463\u5e97\u8001\u677f\u4e70\u8d70\u7684\u3002") : "\u5979\u7ed9\u6d77\u4f26\u5a1c\u7684\u6761\u4ef6\u662f\u8ba9\u5979\u4efb\u6027\u7684\u59b9\u59b9\u83b7\u5f97\u81ea\u7531\uff0c\u5e76\u4fdd\u8bc1\u4e0d\u518d\u5974\u5f79\u5979\u2026\u2026<br/>\u4f60\u9700\u8981\u53bb\u6d77\u4f26\u5a1c\u7684\u5de2\u627e\u5230\u65af\u5609\u4e3d\uff0c\u8ba9\u5979\u56de\u5230\u6d77\u4f26\u5a1c\u8eab\u8fb9\u2026\u2026");
        }

        @Override
        public String getCompletedDescription() {
            return "\u6839\u636e\u6d77\u4f26\u5a1c\u4ee5\u524d\u7684\u793c\u4eea\u6559\u7ec3\u7684\u610f\u613f\uff0c\u65af\u5609\u4e3d\u4ece\u4eca\u4ee5\u540e\u5c06\u62c5\u4efb\u54c8\u6bd4\u65cf\u957f\u7684\u4e2a\u4eba\u52a9\u7406\u3002";
        }
    }
    ,
    ROMANCE_HELENA_5_SCARLETT_TRAINER(QuestType.RELATIONSHIP, 1, 5){

        @Override
        public String getName() {
            return "\u54c8\u6bd4\u7684\u5e2e\u624b";
        }

        @Override
        public String getDescription() {
            return "\u4e24\u540d\u54c8\u6bd4\u65e9\u65e9\u79bb\u5f00\u53bb\u62dc\u8bbf\u65af\u5609\u4e3d\u7684\u59d0\u59b9\u4e86\u3002\u4f60\u9700\u8981\u5728\u8425\u4e1a\u65f6\u95f4\u56de\u5230\u6d77\u4f26\u5a1c\u7684\u5546\u5e97\uff0c\u770b\u770b\u4f60\u7684\u4e0b\u4e00\u4e2a\u4efb\u52a1\u662f\u4ec0\u4e48\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u56de\u5230\u6d77\u4f26\u5a1c\u7684\u5546\u5e97\uff0c\u53d1\u73b0\u4e00\u5207\u90fd\u5b89\u6392\u59a5\u5f53\uff0c\u51c6\u5907\u597d\u8ba9\u54c8\u6bd4\u65cf\u957f\u63a5\u5f85\u987e\u5ba2\u4e86\u3002\u7136\u800c\uff0c\u5728\u6b64\u4e4b\u524d\uff0c\u4f60\u8fd8\u9700\u8981\u5e2e\u5979\u505a\u4e00\u4e9b\u4e8b\u60c5\u2026\u2026";
        }
    }
    ,
    ROMANCE_HELENA_6_ADVERTISING(QuestType.RELATIONSHIP, 1, 15){

        @Override
        public String getName() {
            return "\u5e7f\u544a\u6d3b\u52a8";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u62ff\u5230\u4e86\u516d\u5f20\u70ab\u8000\u6d77\u4f26\u5a1c\u7f8e\u8c8c\u7684\u9644\u9b54\u6d77\u62a5\uff0c\u4f60\u7684\u4efb\u52a1\u662f\u628a\u5b83\u4eec\u8d34\u5728\u5974\u96b6\u5df7\u7684\u5165\u53e3\u5904\uff0c\u4e3a\u5979\u7684\u5546\u5e97\u505a\u5e7f\u544a\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5728\u5974\u96b6\u5df7\u7684\u5165\u53e3\u5904\u5f20\u8d34\u4e86\u201c\u6d77\u4f26\u5a1c\u7cbe\u54c1\u5e97\u201d\u7684\u6d77\u62a5\u3002";
        }
    }
    ,
    ROMANCE_HELENA_7_GRAND_OPENING_PREPARATION(QuestType.RELATIONSHIP, 1, 15){

        @Override
        public String getName() {
            return "\u4e3a\u76db\u5927\u5f00\u4e1a\u505a\u51c6\u5907";
        }

        @Override
        public String getDescription() {
            return "\u8d34\u5b8c\u6d77\u62a5\u540e\uff0c\u65af\u5609\u4e3d\u51fa\u73b0\u4e86\uff0c\u5e26\u4f60\u8fd4\u56de\u6d77\u4f26\u5a1c\u7684\u5546\u5e97\u3002\u4f60\u7684\u65b0\u4efb\u52a1\u662f\u4e3a\u660e\u5929\u7684\u76db\u5927\u5f00\u4e1a\u505a\u597d\u51c6\u5907\uff0c\u8fd9\u610f\u5473\u7740\u4f60\u8981\u5f7b\u591c\u5de5\u4f5c\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u548c\u65af\u5609\u4e3d\u4e3a\u5546\u5e97\u7684\u76db\u5927\u5f00\u4e1a\u505a\u597d\u4e86\u51c6\u5907\u3002";
        }
    }
    ,
    ROMANCE_HELENA_8_FINISH(QuestType.RELATIONSHIP, 1, 100){

        @Override
        public String getName() {
            return "\u8c03\u5236\u996e\u6599";
        }

        @Override
        public String getDescription() {
            return "\u6d77\u4f26\u5a1c\u4e0d\u60f3\u8ba9\u65af\u5609\u4e3d\u5728\u5f00\u4e1a\u5178\u793c\u4e0a\u60f9\u9ebb\u70e6\uff0c\u6240\u4ee5\u8ba9\u4f60\u4eec\u4e24\u4e2a\u7559\u5728\u91cc\u5c4b\u4e3a\u5ba2\u4eba\u8c03\u5236\u996e\u6599\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u548c\u65af\u5609\u4e3d\u4e00\u76f4\u5728\u91cc\u5c4b\u8c03\u5236\u996e\u6599\uff0c\u76f4\u5230\u5f00\u4e1a\u5178\u793c\u7ed3\u675f\u3002\u6d77\u4f26\u5a1c\u7ec8\u4e8e\u56de\u5e94\u4e86\u4f60\u7684\u52aa\u529b\uff0c\u5979\u544a\u8bc9\u4f60\uff0c\u4f5c\u4e3a\u5956\u52b1\uff0c\u5979\u613f\u610f\u8ba9\u4f60\u5e26\u5979\u53bb\u7ea6\u4f1a\u2026\u2026";
        }
    }
    ,
    ROMANCE_NATALYA_FAILED_INTERVIEW(QuestType.RELATIONSHIP, 1, 0){

        @Override
        public String getName() {
            return "\u9762\u8bd5\u5931\u8d25";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u62d2\u7edd\u6309\u7167\u5a1c\u5854\u8389\u4e9a\u5728\u9762\u8bd5\u4e2d\u7684\u8981\u6c42\u884c\u4e8b\uff0c\u4f60\u88ab\u8d76\u51fa\u4e86\u5fa1\u57ce\u901f\u9012\uff0c\u5e76\u88ab\u544a\u77e5\u6c38\u8fdc\u4e0d\u8981\u56de\u6765\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return this.getDescription();
        }
    }
    ,
    ROMANCE_NATALYA_FAILED_CONTRACT(QuestType.RELATIONSHIP, 1, 0){

        @Override
        public String getName() {
            return "\u5408\u540c\u88ab\u62d2";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u62d2\u7edd\u7b7e\u8ba2\u5a1c\u5854\u8389\u4e9a\u63d0\u4f9b\u7ed9\u4f60\u7684\u5408\u540c\uff0c\u4f60\u88ab\u8d76\u51fa\u4e86\u5fa1\u57ce\u901f\u9012\uff0c\u5e76\u88ab\u544a\u77e5\u6c38\u8fdc\u4e0d\u8981\u56de\u6765\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return this.getDescription();
        }
    }
    ,
    ROMANCE_NATALYA_1_INTERVIEW_START(QuestType.RELATIONSHIP, 1, 5){

        @Override
        public String getName() {
            return "\u63a5\u53d7\u9762\u8bd5";
        }

        @Override
        public String getDescription() {
            return "\u5a1c\u5854\u8389\u4e9a\u662f\u5fa1\u57ce\u901f\u9012\u7684\u9a6c\u573a\u4e3b\uff0c\u5979\u7ed9\u4f60\u63d0\u4f9b\u4e86\u4e00\u4e2a\u9762\u8bd5\u201c[style.mule]\u201d\u804c\u4f4d\u7684\u673a\u4f1a\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u63a5\u53d7\u4e86\u5a1c\u5854\u8389\u4e9a\u7684\u9080\u8bf7\uff0c\u8fdb\u884c\u5fa1\u57ce\u901f\u9012\u201c[style.mule]\u201d\u804c\u4f4d\u7684\u9762\u8bd5\u3002";
        }
    }
    ,
    ROMANCE_NATALYA_2_CONTRACT_SIGNED(QuestType.RELATIONSHIP, 1, 5){

        @Override
        public String getName() {
            return "\u5a1c\u5854\u8389\u4e9a\u7684[style.Mule]";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u63a5\u53d7\u4e86\u201c[style.mule]\u201d\u804c\u4f4d\u7684\u9762\u8bd5\u9080\u8bf7\uff0c\u63a5\u4e0b\u6765\u9700\u8981\u6210\u529f\u901a\u8fc7\u5e76\u7b7e\u8ba2\u5408\u540c\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u6210\u529f\u901a\u8fc7\u4e86\u5a1c\u5854\u8389\u4e9a\u7684\u9762\u8bd5\uff0c\u5728\u7b7e\u8ba2\u5408\u540c\u540e\uff0c\u4f60\u88ab\u544a\u77e5\u9700\u8981\u8f6c\u5316\u4e3a[style.a_shemale]\u534a\u517d\u4eba\u3002";
        }
    }
    ,
    ROMANCE_NATALYA_3_TRAINING_1(QuestType.RELATIONSHIP, 1, 5){

        @Override
        public String getName() {
            return "[style.Mule]\u8bad\u7ec3";
        }

        @Override
        public String getDescription() {
            return "\u5a1c\u5854\u8389\u4e9a\u544a\u8bc9\u4f60\uff0c\u8bad\u7ec3\u7684\u7b2c\u4e00\u9636\u6bb5\u662f\u8ba9\u4f60\u7ed9\u4e00\u540d\u534a\u4eba\u9a6c\u5974\u96b6\u53cd\u590d\u8fdb\u884c\u53e3\u4ea4\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u5728\u8f6c\u5316\u4e3a[style.a_shemale]\u534a\u517d\u4eba\u540e\uff0c[style.mule]\u8bad\u7ec3\u5f00\u59cb\uff0c\u4f60\u542e\u5438\u4e86\u5fa1\u57ce\u901f\u9012\u4e00\u540d\u4e0d\u542c\u7ba1\u6559\u7684\u534a\u4eba\u9a6c\u5974\u96b6\u7684\u9e21\u5df4\u3002";
        }
    }
    ,
    ROMANCE_NATALYA_4_TRAINING_2(QuestType.RELATIONSHIP, 1, 5){

        @Override
        public String getName() {
            return "\u66f4\u591a\u7684\u8bad\u7ec3";
        }

        @Override
        public String getDescription() {
            return "\u518d\u4e00\u6b21\uff0c\u5a1c\u5854\u8389\u4e9a\u544a\u8bc9\u4f60\u7b2c\u4e8c\u5929\u56de\u6765\u7ee7\u7eed\u8bad\u7ec3\uff0c\u5185\u5bb9\u5305\u62ec\u5b66\u4e60\u5982\u4f55\u7231\u4e0a\u8214\u809b\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u8bad\u7ec3\u7684\u7b2c\u4e8c\u9636\u6bb5\u662f\u6d82\u4e0a\u8272\u5f69\u9c9c\u8273\u7684\u53e3\u7ea2\uff0c\u7ed9\u5a1c\u5854\u8389\u4e9a\u4e3b\u4eba\u8fdb\u884c\u543b\u809b\u3002";
        }
    }
    ,
    ROMANCE_NATALYA_5_TRAINING_3(QuestType.RELATIONSHIP, 1, 5){

        @Override
        public String getName() {
            return "\u6700\u7ec8\u8bad\u7ec3";
        }

        @Override
        public String getDescription() {
            return "\u5a1c\u5854\u8389\u4e9a\u547d\u4ee4\u4f60\u660e\u5929\u56de\u6765\u7ed3\u675f\u8bad\u7ec3\uff0c\u5185\u5bb9\u5305\u62ec\u7ed9\u4e00\u4e2a\u534a\u4eba\u9a6c\u5974\u96b6\u8214\u809b\uff0c\u7136\u540e\u88ab\u5a1c\u5854\u8389\u4e9a\u548c\u8fd9\u4e2a\u5974\u96b6\u9a91\u4e0a\u5e76\u809b\u4ea4\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u5728\u5bf9\u4e00\u4e2a\u534a\u4eba\u9a6c\u5974\u96b6\u8fdb\u884c\u8214\u809b\uff0c\u7136\u540e\u88ab\u4ed6\u4eec\u9a91\u4e0a\u5e76\u809b\u4ea4\u540e\uff0c\u5a1c\u5854\u8389\u4e9a\u5ba3\u5e03\u4f60\u7684[style.mule]\u8bad\u7ec3\u5df2\u7ecf\u5b8c\u6210\u3002";
        }
    }
    ,
    ROMANCE_MONICA_1_TO_THE_FARM(QuestType.RELATIONSHIP, 1, 10){

        @Override
        public String getName() {
            return "\u53bb\u5f80\u519c\u573a";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u4e3b\u52a8\u63d0\u51fa\u5e2e\u83ab\u59ae\u5361\u627e\u56de\u5b9a\u5236\u5438\u5976\u5668\uff0c\u5979\u544a\u8bc9\u4f60\u53ef\u4ee5\u53bb\u5979\u4ee5\u524d\u7684\u5de5\u4f5c\u573a\u6240\u5bfb\u627e\uff0c\u90a3\u662f\u4e00\u4e2a\u4f4d\u4e8e\u4f0a\u5229\u65af\u4e1c\u5317\u90e8\uff0c\u540d\u4e3a\u201c\u827e\u5f17\u5229\u514b\u65af\u4e73\u4e1a\u201d\u7684\u519c\u573a\u3002\u4f60\u5fc5\u987b\u524d\u5f80\u8fd9\u4e2a\u519c\u573a\uff0c\u8be2\u95ee\u83ab\u59ae\u5361\u7684\u5b9a\u5236\u5438\u5976\u5668\u7684\u4e0b\u843d\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u627e\u5230\u4e86\u83ab\u59ae\u5361\u4ee5\u524d\u5de5\u4f5c\u7684\u519c\u573a\uff0c\u7d22\u8981\u725b\u5973\u7684\u5b9a\u5236\u5438\u5976\u5668\u3002\u4f60\u83b7\u51c6\u4e0e\u519c\u573a\u4e3b\u4f1a\u9762\u2026\u2026";
        }
    }
    ,
    ROMANCE_MONICA_2_UNREASONABLE_DEMAND(QuestType.RELATIONSHIP, 1, 10){

        @Override
        public String getName() {
            return "\u4e0d\u60c5\u4e4b\u8bf7";
        }

        @Override
        public String getDescription() {
            return "\u4f60\u4e0e\u519c\u573a\u4e3b\u827e\u5f17\u5229\u514b\u65af\u4f1a\u9762\uff0c\u5979\u662f\u4e00\u540d\u5916\u8868\u8d2a\u5a6a\u53c8\u50b2\u6162\u7684\u9b45\u9b54\u3002\u867d\u7136\u5979\u627f\u8ba4\u5438\u5976\u5668\u6beb\u65e0\u4ef7\u503c\uff0c\u4f46\u5979\u8fd8\u662f\u8981\u6c42\u4f60\u7ed9\u5979\u4e00\u5927\u7b14\u94b1\uff0c\u6216\u8005\u7b7e\u7f72\u4e00\u4efd\u53ef\u7591\u7684\u5408\u540c\u6765\u6362\u53d6\u5b83\u2026\u2026";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u8bbe\u6cd5\u4ece\u827e\u5f17\u5229\u514b\u65af\u5904\u83b7\u5f97\u4e86\u83ab\u59ae\u5361\u7684\u5b9a\u5236\u5438\u5976\u5668\u3002";
        }
    }
    ,
    ROMANCE_MONICA_3_THE_JOURNEY_HOME(QuestType.RELATIONSHIP, 1, 10){

        @Override
        public String getName() {
            return "\u56de\u5bb6\u4e4b\u8def";
        }

        @Override
        public String getDescription() {
            return "\u73b0\u5728\u83ab\u59ae\u5361\u7684\u5b9a\u5236\u5438\u5976\u5668\u5df2\u7ecf\u5230\u4e86\u4f60\u7684\u624b\u91cc\uff0c\u5269\u4e0b\u8981\u505a\u7684\u5c31\u662f\u8fd8\u7ed9\u5b83\u7684\u4e3b\u4eba\u4e86\u3002";
        }

        @Override
        public String getCompletedDescription() {
            return "\u4f60\u5c06\u83ab\u59ae\u5361\u7684\u5b9a\u5236\u5438\u5976\u5668\u8fd8\u7ed9\u4e86\u5979\uff0c\u8fd9\u8ba9\u5979\u559c\u51fa\u671b\u5916\u3002";
        }
    };

    private int level;
    private int experienceReward;
    private QuestType questType;

    private Quest(QuestType questType, int level, int experienceReward) {
        this.questType = questType;
        this.level = level;
        this.experienceReward = experienceReward;
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getCompletedDescription();

    public void applySkipQuestEffects() {
    }

    public int getLevel() {
        return this.level;
    }

    public QuestType getQuestType() {
        return this.questType;
    }

    public int getExperienceReward() {
        return this.experienceReward;
    }

    public static Quest getQuestFromId(String quest) {
        if (quest.equalsIgnoreCase("MAIN_3_A_FINDING_THE_YOUKO")) {
            return MAIN_3_ELIS;
        }
        if (quest.equalsIgnoreCase("MAIN_3_D_TO_THEMISCRYA")) {
            return MAIN_3_D_TO_THEMISCYRA;
        }
        return Quest.valueOf(quest);
    }
}

