/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.race;

public enum SubspeciesSpawnRarity {
    NEGATIVE_THREE_ZERO(0.0f),
    NEGATIVE_TWO_MYTHICAL(0.001f),
    NEGATIVE_ONE_LEGENDARY(0.01f),
    ONE(0.1f),
    TWO(0.2f),
    THREE(0.3f),
    FOUR(0.4f),
    FIVE(0.5f),
    SIX(0.6f),
    SEVEN(0.7f),
    EIGHT(0.8f),
    NINE(0.9f),
    TEN(1.0f),
    TWENTY(2.0f),
    FORTY(4.0f),
    EIGHTY(8.0f);

    private float chanceMultiplier;

    private SubspeciesSpawnRarity(float chanceMultiplier) {
        this.chanceMultiplier = chanceMultiplier;
    }

    public static SubspeciesSpawnRarity getSubspeciesSpawnRarityFromString(String rarity) {
        if (rarity.equalsIgnoreCase("ZERO_EXTREMELY_RARE")) {
            return ONE;
        }
        if (rarity.equalsIgnoreCase("ONE_VERY_RARE")) {
            return TWO;
        }
        if (rarity.equalsIgnoreCase("TWO_RARE")) {
            return THREE;
        }
        if (rarity.equalsIgnoreCase("THREE_UNCOMMON")) {
            return FIVE;
        }
        if (rarity.equalsIgnoreCase("FOUR_COMMON")) {
            return TEN;
        }
        return SubspeciesSpawnRarity.valueOf(rarity);
    }

    public float getChanceMultiplier() {
        return this.chanceMultiplier;
    }
}

