/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.combat;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.AppliedStatusEffect;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCFlagValue;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.combat.Attack;
import com.lilithsthrone.game.combat.CombatBehaviour;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.moves.AbstractCombatMove;
import com.lilithsthrone.game.combat.moves.CombatMove;
import com.lilithsthrone.game.combat.moves.CombatMoveType;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.combat.spells.SpellUpgrade;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Combat {
    private NPC activeNPC;
    private GameCharacter targetedAlly;
    private GameCharacter targetedEnemy;
    private NPC enemyLeader;
    private List<NPC> allies = new ArrayList<NPC>();
    private List<NPC> enemies = new ArrayList<NPC>();
    private List<NPC> allCombatants = new ArrayList<NPC>();
    private List<GameCharacter> activeCombatants;
    private float escapeChance = 0.0f;
    private boolean submitBlocked = false;
    private Map<GameCharacter, Float> totalDamageTaken;
    private int turn = 0;
    private boolean attemptedEscape = false;
    private boolean escaped = false;
    private boolean playerVictory = false;
    private StringBuilder postCombatStringBuilder = new StringBuilder();
    private StringBuilder combatTurnResolutionStringBuilder = new StringBuilder();
    private Map<GameCharacter, GameCharacter> preferredTargets;
    private Map<GameCharacter, Stack<Float>> manaBurnStack;
    private Map<GameCharacter, Map<AbstractStatusEffect, Integer>> statusEffectsToApply;
    private Map<GameCharacter, List<String>> combatContent;
    private Map<GameCharacter, List<String>> predictionContent;
    private Map<GameCharacter, List<String>> escapeDescriptionMap;
    private Map<GameCharacter, List<Util.Value<GameCharacter, AbstractItem>>> itemsToBeUsed;
    private Map<GameCharacter, Map<InventorySlot, Map<AbstractWeapon, Integer>>> weaponsThrownDuringTurn;
    private Map<GameCharacter, Map<InventorySlot, Map<AbstractWeapon, Integer>>> weaponsThrownDuringCombat;
    private Map<GameCharacter, Map<InventorySlot, AbstractWeaponType>> thrownWeaponsDepleted;
    private DialogueNode playerPostVictoryDialogue;
    private DialogueNode playerPostDefeatDialogue;
    public final DialogueNode ITEM_USED = new DialogueNode("\u6218\u6597", "\u4f7f\u7528\u7269\u54c1\u3002", true){

        @Override
        public String getLabel() {
            return Combat.this.getCombatLabel();
        }

        @Override
        public String getHeaderContent() {
            return Combat.this.npcStatus();
        }

        @Override
        public String getContent() {
            return Combat.this.getCombatContent();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Combat.this.isEnemyPartyDefeated()) {
                    return new ResponseEffectsOnly("\u80dc\u5229", "<span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u4f60\u8d62\u4e86\uff01</span>"){

                        @Override
                        public void effects() {
                            Combat.this.endCombat(true);
                            Main.game.setContent(Combat.this.getEndCombatDialogue(true, true));
                        }
                    };
                }
                return new Response("\u7ee7\u7eed", "\u6218\u6597\u7ee7\u7eed\u3002", Combat.this.ENEMY_ATTACK){

                    @Override
                    public void effects() {
                        Combat.this.endCombatTurn();
                    }
                };
            }
            return null;
        }

        @Override
        public DialogueNodeType getDialogueNodeType() {
            return DialogueNodeType.NORMAL;
        }
    };
    public final DialogueNode SUBMIT = new DialogueNode("\u6218\u6597", "\u5c48\u670d", true){

        @Override
        public String getLabel() {
            return Combat.this.getCombatLabel();
        }

        @Override
        public String getHeaderContent() {
            return Combat.this.npcStatus();
        }

        @Override
        public String getContent() {
            return UtilText.parse((GameCharacter)Combat.this.enemyLeader, "<p>\u4f60\u786e\u5b9a\u8981\u5411[npc.Name]<b>\u5c48\u670d</b>\u5417\uff1f<b>\u8fd9\u5c06\u5bfc\u81f4\u4f60\u6218\u6597\u5931\u8d25\uff0c[npc.herHim]\u53ef\u4ee5\u5bf9\u4f60\u4e3a\u6240\u6b32\u4e3a\uff01</b></p>", new ParserTag[0]);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u5c48\u670d", UtilText.parse((GameCharacter)Combat.this.enemyLeader, "\u5411[npc.name]\u5c48\u670d\u3002<span style='color:" + PresetColour.GENERIC_TERRIBLE.toWebHexString() + ";'>\u8fd9\u5c06\u5bfc\u81f4\u4f60\u8f93\u6389\u5f53\u524d\u7684\u6218\u6597\uff01</span>", new ParserTag[0]), Combat.this.SUBMIT_CONFIRM){

                    @Override
                    public void effects() {
                        StringBuilder sb = new StringBuilder();
                        sb.append(Combat.this.getCharactersTurnDiv(Main.game.getPlayer(), "\u5c48\u670d", Util.newArrayListOfValues(UtilText.parse((GameCharacter)Combat.this.enemyLeader, "\u4f60\u5728[npc.name]\u9762\u524d\u8dea\u4e0b\uff0c\u987a\u4ece\u5730\u5782\u4e0b\u4e86\u8111\u888b\uff0c\u5495\u54dd\u9053\uff0c[pc.speech(\u6211\u4e0d\u60f3\u518d\u6253\u4e86\uff0c\u6211\u6295\u964d\u3002)]", new ParserTag[0]))));
                        sb.append(Combat.this.getCharactersTurnDiv(Combat.this.enemyLeader, "\u80dc\u5229", Util.newArrayListOfValues(UtilText.parse((GameCharacter)Combat.this.enemyLeader, "[npc.Name]\u653e\u51fa\u5f97\u80dc\u7684\u5927\u7b11\uff0c\u4e0a\u524d\u53bb\u63a5\u53d7\u4e86\u4f60\u7684\u5c48\u670d\u2026\u2026", new ParserTag[0]))));
                        Main.game.getTextStartStringBuilder().append(sb.toString());
                    }
                };
            }
            if (index == 0) {
                return new Response("\u53d6\u6d88", "\u7ee7\u7eed\u6218\u6597\u3002", Combat.this.ENEMY_ATTACK);
            }
            return null;
        }

        @Override
        public DialogueNodeType getDialogueNodeType() {
            return DialogueNodeType.NORMAL;
        }
    };
    public final DialogueNode SUBMIT_CONFIRM = new DialogueNode("\u6218\u6597", "\u5c48\u670d", true){

        @Override
        public String getLabel() {
            return Combat.this.getCombatLabel();
        }

        @Override
        public String getHeaderContent() {
            return Combat.this.npcStatus();
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new ResponseEffectsOnly("\u7ee7\u7eed", UtilText.parse((GameCharacter)Combat.this.enemyLeader, "\u4f60\u7b49\u5f85[npc.Name]\u884c\u52a8\u3002", new ParserTag[0])){

                    @Override
                    public void effects() {
                        Combat.this.endCombat(false);
                        Main.game.setResponseTab(0);
                        Main.game.setContent(Combat.this.getEndCombatDialogue(true, false));
                    }
                };
            }
            return null;
        }

        @Override
        public DialogueNodeType getDialogueNodeType() {
            return DialogueNodeType.NORMAL;
        }
    };
    public final DialogueNode ENEMY_ATTACK = new DialogueNode("\u6218\u6597", "\u654c\u4eba\u5411\u4f60\u53d1\u8d77\u53cd\u51fb\u3002", true){

        @Override
        public String getLabel() {
            return Combat.this.getCombatLabel();
        }

        @Override
        public String getHeaderContent() {
            return Combat.this.npcStatus();
        }

        @Override
        public String getContent() {
            return Combat.this.getCombatContent();
        }

        @Override
        public String getResponseTabTitle(int index) {
            if (Combat.this.enemyLeader.interruptCombatSpecialCase() != null) {
                return null;
            }
            if (index == 0) {
                return "\u6838\u5fc3\u52a8\u4f5c";
            }
            if (index == 1) {
                return "\u57fa\u7840\u52a8\u4f5c";
            }
            if (index == 2) {
                return "\u7279\u6b8a\u52a8\u4f5c";
            }
            if (index == 3) {
                return "\u6cd5\u672f";
            }
            if (index == 4) {
                return "\u547d\u4ee4";
            }
            return null;
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (Combat.this.enemyLeader.interruptCombatSpecialCase() != null) {
                if (index == 1) {
                    return Combat.this.enemyLeader.interruptCombatSpecialCase();
                }
                return null;
            }
            if (Combat.this.escaped) {
                if (index == 1) {
                    return new ResponseEffectsOnly("\u9003\u8131\uff01", "\u4f60\u9003\u8d70\u4e86\uff01"){

                        @Override
                        public void effects() {
                            Combat.this.enemyLeader.applyEscapeCombatEffects();
                            for (NPC enemy : Combat.this.enemies) {
                                enemy.addFlag(NPCFlagValue.playerEscapedLastCombat);
                            }
                            Main.game.setInCombat(false);
                            Main.game.setResponseTab(0);
                            Main.game.setContent(new Response("", "", Main.game.getDefaultDialogue(false)));
                        }
                    };
                }
                return null;
            }
            if (Combat.this.isEnemyPartyDefeated()) {
                if (index == 1) {
                    return new ResponseEffectsOnly("\u80dc\u5229", UtilText.parse((GameCharacter)Combat.this.enemyLeader, "<span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u4f60\u6253\u8d25\u4e86[npc.name]\uff01</span>", new ParserTag[0])){

                        @Override
                        public void effects() {
                            Combat.this.endCombat(true);
                            Main.game.setResponseTab(0);
                            Main.game.setContent(Combat.this.getEndCombatDialogue(true, true));
                        }
                    };
                }
                return null;
            }
            if (Combat.this.isAlliedPartyDefeated()) {
                if (index == 1) {
                    return new ResponseEffectsOnly("\u8d25\u5317", "\u4f60\u88ab\u6253\u8d25\u4e86\uff01"){

                        @Override
                        public void effects() {
                            Combat.this.endCombat(false);
                            Main.game.setResponseTab(0);
                            Main.game.setContent(Combat.this.getEndCombatDialogue(true, false));
                        }
                    };
                }
                return null;
            }
            if (Main.game.getPlayer().isStunned()) {
                if (index == 1) {
                    return new Response("\u7729\u6655\uff01", "\u672c\u56de\u5408\u4f60\u65e0\u6cd5\u884c\u52a8\uff01", Combat.this.ENEMY_ATTACK){

                        @Override
                        public void effects() {
                            Combat.this.combatContent.put(Main.game.getPlayer(), Util.newArrayListOfValues("\u4f60\u88ab\u7729\u6655\u4e86\uff0c\u65e0\u6cd5\u505a\u51fa\u52a8\u4f5c\uff01"));
                            Combat.this.endCombatTurn();
                        }
                    };
                }
                return null;
            }
            if (Combat.this.isCombatantDefeated(Main.game.getPlayer())) {
                if (index == 1) {
                    return new Response("\u89c2\u6218", "\u4f60\u5df2\u8d25\u4e86\uff0c\u4fbf\u53ea\u80fd\u773c\u7741\u7741\u5730\u770b\u7740\u4f19\u4f34\u7ee7\u7eed\u6218\u6597\uff01", Combat.this.ENEMY_ATTACK){

                        @Override
                        public void effects() {
                            Combat.this.combatContent.put(Main.game.getPlayer(), Util.newArrayListOfValues("\u4f60\u5df2\u8d25\u4e86\uff0c\u4fbf\u53ea\u80fd\u773c\u7741\u7741\u5730\u770b\u7740\u4f19\u4f34\u7ee7\u7eed\u6218\u6597\uff01"));
                            Combat.this.endCombatTurn();
                        }
                    };
                }
                return null;
            }
            final List<GameCharacter> pcEnemies = Combat.this.getEnemies(Main.game.getPlayer());
            final List<GameCharacter> pcAllies = Combat.this.getAllies(Main.game.getPlayer());
            pcAllies.add(Main.game.getPlayer());
            if (index == 0) {
                return new Response("\u7ed3\u675f\u56de\u5408", Main.game.getPlayer().getRemainingAP() <= 0 ? "\u7ed3\u675f\u5f53\u524d\u56de\u5408" : "\u8981\u7ed3\u675f\u5f53\u524d\u56de\u5408\u5417\uff1f\u4f60\u8fd8\u6709\u672a\u4f7f\u7528\u7684\u884c\u52a8\u70b9\uff01", Combat.this.ENEMY_ATTACK){

                    @Override
                    public void effects() {
                        Combat.this.endCombatTurn();
                    }

                    @Override
                    public Colour getHighlightColour() {
                        if (Main.game.getPlayer().getRemainingAP() > 0) {
                            return PresetColour.GENERIC_BAD;
                        }
                        return PresetColour.GENERIC_GOOD;
                    }
                };
            }
            if (index <= 10 || index > 14) {
                int moveIndex;
                int n = moveIndex = index <= 10 ? index - 1 : index - 5;
                if (responseTab == 0 || responseTab == 1) {
                    int n2 = moveIndex = index <= 8 ? index - 1 : index - 7;
                    if (index == 9) {
                        if (Main.combat.isSubmitBlocked()) {
                            return new Response("\u5c48\u670d", "\u8fd9\u662f\u4e00\u573a\u65e0\u6cd5\u653e\u5f03\u7684\u6218\u6597\uff01", null);
                        }
                        return new Response("\u5c48\u670d", Combat.this.getEnemies(Main.game.getPlayer()).size() == 1 ? "\u5411\u5bf9\u624b\u6295\u964d\uff0c\u4efb\u4eba\u8086\u610f\u6446\u5f04\u4e3a\u6240\u6b32\u4e3a\u3002" : "\u5411\u5bf9\u624b\u6295\u964d\uff0c\u4efb\u4eba\u8086\u610f\u6446\u5f04\u4e3a\u6240\u6b32\u4e3a\u3002", Combat.this.SUBMIT);
                    }
                    if (index == 10) {
                        if (Combat.this.escapeChance == 0.0f) {
                            return new Response("\u9003\u8dd1", "\u8fd9\u662f\u4f60\u65e0\u6cd5\u9003\u907f\u7684\u6218\u6597\uff01", null);
                        }
                        if (!Main.game.getPlayer().isAbleToEscape()) {
                            return new Response("\u9003\u8dd1", Main.game.getPlayer().getUnableToEscapeDescription(), null);
                        }
                        return new Response("\u9003\u8dd1", "\u8bd5\u56fe\u9003\u8dd1\u3002<br/><br/>" + (String)(Combat.this.escapeChance == 100.0f && Main.game.getPlayer().hasTrait(Perk.JOB_ATHLETE, true) ? "\u4f60\u53d1\u52a8<b style='color:" + Perk.JOB_ATHLETE.getColour().toWebHexString() + ";'>" + Perk.JOB_ATHLETE.getName(Main.game.getPlayer()) + "</b>\u7684\u6548\u679c\uff0c\u4ece\u6218\u6597\u4e2d\u8f7b\u677e\u5730\u8131\u8eab\u4e86\uff01" : (Combat.this.escapeChance == 100.0f && Main.game.getPlayer().getSubspecies() == Subspecies.CAT_MORPH_CHEETAH ? "\u8fd8\u597d\u4f60\u6709\u730e\u8c79\u5316\u5f62\u7684\u8eaf\u4f53\uff0c\u8f7b\u800c\u6613\u4e3e\u5730\u5c31\u4ece\u6218\u6597\u4e2d\u8131\u8eab\u4e86\uff01" : "")) + "\u4f60\u6709" + Combat.this.escapeChance + "%\u673a\u7387\u9003\u8131\uff01", Combat.this.ENEMY_ATTACK){

                            @Override
                            public void effects() {
                                Combat.this.escape(Main.game.getPlayer());
                                Combat.this.endCombatTurn();
                            }
                        };
                    }
                }
                if (responseTab == 0) {
                    if (Main.game.getPlayer().getEquippedMoves().size() > moveIndex) {
                        AbstractCombatMove move = Main.game.getPlayer().getEquippedMoves().get(moveIndex);
                        return Combat.this.getMoveResponse(move, pcEnemies, pcAllies);
                    }
                    if (index <= 8) {
                        return new Response("-", "\u8fd9\u662f\u7a7a\u95f2\u7684\u6838\u5fc3\u6218\u6597\u52a8\u4f5c\u680f\u4f4d\u3002\u5728\u6218\u6597\u5916\u53ef\u4ee5\u901a\u8fc7\u6253\u5f00\u624b\u673a\u83dc\u5355\uff0c\u9009\u62e9\u201c\u6218\u6597\u52a8\u4f5c\u201d\uff0c\u4ee5\u6dfb\u52a0\u6838\u5fc3\u6218\u6597\u52a8\u4f5c\u3002", null);
                    }
                } else if (responseTab == 1) {
                    if (Main.game.getPlayer().getAvailableBasicMoves().size() > moveIndex) {
                        AbstractCombatMove move = Main.game.getPlayer().getAvailableBasicMoves().get(moveIndex);
                        return Combat.this.getMoveResponse(move, pcEnemies, pcAllies);
                    }
                } else if (responseTab == 2) {
                    if (Main.game.getPlayer().getAvailableSpecialMoves().size() > moveIndex) {
                        AbstractCombatMove move = Main.game.getPlayer().getAvailableSpecialMoves().get(moveIndex);
                        return Combat.this.getMoveResponse(move, pcEnemies, pcAllies);
                    }
                } else if (responseTab == 3) {
                    if (Main.game.getPlayer().getAvailableSpellMoves().size() > moveIndex) {
                        AbstractCombatMove move = Main.game.getPlayer().getAvailableSpellMoves().get(moveIndex);
                        return Combat.this.getMoveResponse(move, pcEnemies, pcAllies);
                    }
                } else if (responseTab == 4) {
                    String costDescription = "<br/>[style.colourMinorGood(\u8fd9\u662f\u4e00\u9879\u81ea\u7531\u52a8\u4f5c\uff0c\u4e0d\u4f1a\u6d88\u8017\u4efb\u4f55AP\uff0c\u4e5f\u4e0d\u4f1a\u7ed3\u675f\u56de\u5408\u3002)]";
                    for (int i = 1; i <= CombatBehaviour.values().length; ++i) {
                        if (index != i) continue;
                        final CombatBehaviour behaviour = CombatBehaviour.values()[i - 1];
                        if (Combat.this.targetedAlly.isPlayer()) {
                            return new Response(Util.capitaliseSentence(behaviour.getName()), "\u4f60\u4e0d\u80fd\u5bf9\u81ea\u5df1\u53d1\u53f7\u65bd\u4ee4\uff01", null);
                        }
                        return new Response(Util.capitaliseSentence(behaviour.getName()), Combat.this.targetedAlly.getCombatBehaviour() == behaviour ? "[style.italicsMinorGood(" + behaviour.getDescription(Combat.this.targetedAlly) + ")]" + UtilText.parse(Combat.this.targetedAlly, "<br/>[style.italics(\u4f60\u53ef\u4ee5\u9009\u62e9\u8be5\u52a8\u4f5c\uff0c\u8ba9[npc.name]\u91cd\u65b0\u51b3\u5b9a\u884c\u52a8\u3002)]", new ParserTag[0]) : behaviour.getOrderDescription(Combat.this.targetedAlly) + costDescription, Combat.this.ENEMY_ATTACK){

                            @Override
                            public Colour getHighlightColour() {
                                if (Combat.this.targetedAlly.getCombatBehaviour() == behaviour) {
                                    return PresetColour.GENERIC_GOOD;
                                }
                                return super.getHighlightColour();
                            }

                            @Override
                            public void effects() {
                                Combat.this.targetedAlly.setCombatBehaviour(behaviour);
                                List<GameCharacter> npcAllies = Combat.this.getAllies(Combat.this.targetedAlly);
                                List<GameCharacter> npcEnemies = Combat.this.getEnemies(Combat.this.targetedAlly);
                                npcAllies.removeIf(character -> Combat.this.isCombatantDefeated((GameCharacter)character));
                                npcEnemies.removeIf(character -> Combat.this.isCombatantDefeated((GameCharacter)character));
                                int i = 0;
                                for (Util.Value<GameCharacter, AbstractCombatMove> move : Combat.this.targetedAlly.getSelectedMoves()) {
                                    move.getValue().performOnDeselection(i, Combat.this.targetedAlly, move.getKey(), new ArrayList<GameCharacter>(npcEnemies), new ArrayList<GameCharacter>(npcAllies));
                                    Combat.this.targetedAlly.setCooldown(move.getValue().getIdentifier(), 0);
                                    ++i;
                                }
                                Combat.this.targetedAlly.resetSelectedMoves();
                                Combat.this.targetedAlly.setRemainingAP(Combat.this.targetedAlly.getMaxAP(), npcEnemies, npcAllies);
                                Combat.this.targetedAlly.selectMoves(npcEnemies, npcAllies);
                                Combat.this.predictionContent.put(Combat.this.targetedAlly, Combat.this.targetedAlly.getMovesPredictionString(npcEnemies, npcAllies));
                            }
                        };
                    }
                    if (index == CombatBehaviour.values().length + 1) {
                        if (Combat.this.targetedAlly.isPlayer()) {
                            return new Response("\u5faa\u73af\u9009\u53d6", "\u4f60\u4e0d\u80fd\u5bf9\u81ea\u5df1\u53d1\u53f7\u65bd\u4ee4\uff01", null);
                        }
                        return new Response("\u5faa\u73af\u9009\u53d6", UtilText.parse(Combat.this.targetedAlly, "\u544a\u8bc9[npc.name]\u6539\u53d8\u653b\u51fb\u5bf9\u8c61\u3002[npc.She]\u6b63\u5728\u7784\u51c6[style.colourBad(" + (Combat.this.getPreferredTarget(Combat.this.targetedAlly) == null ? "\u4efb\u610f\u89d2\u8272" : UtilText.parse(Combat.this.getPreferredTarget(Combat.this.targetedAlly), "[npc.name]", new ParserTag[0])) + ")]\u3002", new ParserTag[0]) + costDescription, Combat.this.ENEMY_ATTACK){

                            @Override
                            public void effects() {
                                List<GameCharacter> npcAllies = Combat.this.getAllies(Combat.this.targetedAlly);
                                List<GameCharacter> npcEnemies = Combat.this.getEnemies(Combat.this.targetedAlly);
                                npcAllies.removeIf(character -> Combat.this.isCombatantDefeated((GameCharacter)character));
                                npcEnemies.removeIf(character -> Combat.this.isCombatantDefeated((GameCharacter)character));
                                int i = 0;
                                for (Util.Value<GameCharacter, AbstractCombatMove> move : Combat.this.targetedAlly.getSelectedMoves()) {
                                    move.getValue().performOnDeselection(i, Combat.this.targetedAlly, move.getKey(), new ArrayList<GameCharacter>(npcEnemies), new ArrayList<GameCharacter>(npcAllies));
                                    Combat.this.targetedAlly.setCooldown(move.getValue().getIdentifier(), 0);
                                    ++i;
                                }
                                int currentTargetIndex = 0;
                                if (Combat.this.getPreferredTarget(Combat.this.targetedAlly) != null) {
                                    currentTargetIndex = Combat.this.enemies.indexOf(Combat.this.getPreferredTarget(Combat.this.targetedAlly));
                                }
                                ArrayList<NPC> enemiesDoubled = new ArrayList<NPC>(Combat.this.enemies);
                                enemiesDoubled.addAll(Combat.this.enemies);
                                for (int enemyIdx = 0; enemyIdx < enemiesDoubled.size(); ++enemyIdx) {
                                    GameCharacter enemyAtIndex = (GameCharacter)enemiesDoubled.get(enemyIdx);
                                    if (Combat.this.isCombatantDefeated(enemyAtIndex) || Combat.this.getPreferredTarget(Combat.this.targetedAlly) == enemyAtIndex || enemyIdx <= currentTargetIndex && Combat.this.getPreferredTarget(Combat.this.targetedAlly) != null) continue;
                                    Combat.this.setPreferredTarget(Combat.this.targetedAlly, enemyAtIndex);
                                    break;
                                }
                                Combat.this.targetedAlly.resetSelectedMoves();
                                Combat.this.targetedAlly.setRemainingAP(Combat.this.targetedAlly.getMaxAP(), npcEnemies, npcAllies);
                                Combat.this.targetedAlly.selectMoves(npcEnemies, npcAllies);
                                Combat.this.predictionContent.put(Combat.this.targetedAlly, Combat.this.targetedAlly.getMovesPredictionString(npcEnemies, npcAllies));
                            }
                        };
                    }
                    if (index == CombatBehaviour.values().length + 2) {
                        if (Combat.this.targetedAlly.isPlayer()) {
                            return new Response("\u6e05\u7a7a\u9009\u53d6", "\u4f60\u4e0d\u80fd\u5bf9\u81ea\u5df1\u53d1\u53f7\u65bd\u4ee4\uff01", null);
                        }
                        if (Combat.this.getPreferredTarget(Combat.this.targetedAlly) == null) {
                            return new Response("\u6e05\u7a7a\u9009\u53d6", UtilText.parse(Combat.this.targetedAlly, "[npc.Name]\u5df2\u7ecf\u9009\u597d\u60f3\u9009\u7684\u76ee\u6807\u4e86\uff01", new ParserTag[0]), null);
                        }
                        return new Response("\u6e05\u7a7a\u9009\u53d6", UtilText.parse(Combat.this.targetedAlly, "\u544a\u8bc9[npc.name]\u968f\u610f\u9009\u53d6\u89d2\u8272\u3002[npc.She]\u6b63\u5728\u7784\u51c6[style.colourBad(" + (Combat.this.getPreferredTarget(Combat.this.targetedAlly) == null ? "\u4efb\u610f\u89d2\u8272" : UtilText.parse(Combat.this.getPreferredTarget(Combat.this.targetedAlly), "[npc.name]", new ParserTag[0])) + ")]\u3002", new ParserTag[0]) + costDescription, Combat.this.ENEMY_ATTACK){

                            @Override
                            public void effects() {
                                List<GameCharacter> npcAllies = Combat.this.getAllies(Combat.this.targetedAlly);
                                List<GameCharacter> npcEnemies = Combat.this.getEnemies(Combat.this.targetedAlly);
                                npcAllies.removeIf(character -> Combat.this.isCombatantDefeated((GameCharacter)character));
                                npcEnemies.removeIf(character -> Combat.this.isCombatantDefeated((GameCharacter)character));
                                int i = 0;
                                for (Util.Value<GameCharacter, AbstractCombatMove> move : Combat.this.targetedAlly.getSelectedMoves()) {
                                    move.getValue().performOnDeselection(i, Combat.this.targetedAlly, move.getKey(), new ArrayList<GameCharacter>(npcEnemies), new ArrayList<GameCharacter>(npcAllies));
                                    Combat.this.targetedAlly.setCooldown(move.getValue().getIdentifier(), 0);
                                    ++i;
                                }
                                Combat.this.setPreferredTarget(Combat.this.targetedAlly, null);
                                Combat.this.targetedAlly.resetSelectedMoves();
                                Combat.this.targetedAlly.setRemainingAP(Combat.this.targetedAlly.getMaxAP(), npcEnemies, npcAllies);
                                Combat.this.targetedAlly.selectMoves(npcEnemies, npcAllies);
                                Combat.this.predictionContent.put(Combat.this.targetedAlly, Combat.this.targetedAlly.getMovesPredictionString(npcEnemies, npcAllies));
                            }
                        };
                    }
                }
            } else {
                if (index == 11) {
                    return new ResponseEffectsOnly("[style.colourGood(\u76ee\u6807\uff1a)] " + (Combat.this.getTargetedAlliedCombatant().isPlayer() ? "\u4f60\u81ea\u5df1" : Util.capitaliseSentence(Combat.this.getTargetedAlliedCombatant().getName())), "\u4f60\u53ef\u4ee5\u4f7f\u7528\u8be5\u52a8\u4f5c\u6216\u70b9\u51fb\u5c4f\u5e55\u5de6\u4fa7\u7684\u540d\u79f0\uff0c\u5faa\u73af\u6d4f\u89c8\u76ee\u6807\u76df\u53cb\u3002"){

                        @Override
                        public void effects() {
                            ArrayList<GameCharacter> alliesPlusPlayer = Util.newArrayListOfValues(Main.game.getPlayer());
                            alliesPlusPlayer.addAll(Combat.this.getAllies(Main.game.getPlayer()));
                            if (alliesPlusPlayer.size() == 1) {
                                return;
                            }
                            for (int i = 0; i < alliesPlusPlayer.size(); ++i) {
                                if (!((GameCharacter)alliesPlusPlayer.get(i)).equals(Combat.this.getTargetedAlliedCombatant())) continue;
                                if (i + 1 < alliesPlusPlayer.size()) {
                                    Combat.this.setTargetedCombatant((GameCharacter)alliesPlusPlayer.get(i + 1));
                                    break;
                                }
                                Combat.this.setTargetedCombatant((GameCharacter)alliesPlusPlayer.get(0));
                                break;
                            }
                        }
                    };
                }
                if (index == 12) {
                    return new ResponseEffectsOnly("[style.colourBad(\u76ee\u6807\uff1a)] " + Util.capitaliseSentence(Combat.this.getTargetedCombatant().getName()), "\u4f60\u53ef\u4ee5\u4f7f\u7528\u8be5\u52a8\u4f5c\u6216\u70b9\u51fb\u5c4f\u5e55\u53f3\u4fa7\u7684\u540d\u79f0\uff0c\u5faa\u73af\u6d4f\u89c8\u76ee\u6807\u654c\u4eba\u3002"){

                        @Override
                        public void effects() {
                            List<GameCharacter> playerEnemies = Combat.this.getEnemies(Main.game.getPlayer());
                            if (playerEnemies.size() == 1) {
                                return;
                            }
                            for (int i = 0; i < playerEnemies.size(); ++i) {
                                if (!playerEnemies.get(i).equals(Combat.this.getTargetedCombatant())) continue;
                                if (i + 1 < playerEnemies.size()) {
                                    Combat.this.setTargetedCombatant(playerEnemies.get(i + 1));
                                    break;
                                }
                                Combat.this.setTargetedCombatant(playerEnemies.get(0));
                                break;
                            }
                        }
                    };
                }
                if (index == 14) {
                    return new Response("\u91cd\u7f6e", Main.game.getPlayer().getSelectedMoves().size() == 0 ? "\u4f60\u8fd8\u6ca1\u6709\u9009\u62e9\u4efb\u4f55\u52a8\u4f5c\uff0c\u6240\u4ee5\u65e0\u6cd5\u91cd\u7f6e\uff01" : "\u91cd\u7f6e\u6240\u9009\u52a8\u4f5c\uff0c\u8ba9\u4f60\u53ef\u4ee5\u4e3a\u8be5\u56de\u5408\u9009\u62e9\u5176\u4ed6\u884c\u52a8\u3002", Main.game.getPlayer().getSelectedMoves().size() == 0 ? null : Combat.this.ENEMY_ATTACK){

                        @Override
                        public void effects() {
                            if (Main.game.isInCombat()) {
                                int i = 0;
                                for (Util.Value<GameCharacter, AbstractCombatMove> move : Main.game.getPlayer().getSelectedMoves()) {
                                    move.getValue().performOnDeselection(i, Main.game.getPlayer(), move.getKey(), new ArrayList<GameCharacter>(Combat.this.enemies), new ArrayList<GameCharacter>(Combat.this.allies));
                                    Main.game.getPlayer().setCooldown(move.getValue().getIdentifier(), 0);
                                    ++i;
                                }
                            }
                            Main.game.getPlayer().resetSelectedMoves();
                            Main.game.getPlayer().setRemainingAP(Main.game.getPlayer().getMaxAP(), pcEnemies, pcAllies);
                            Combat.this.predictionContent.put(Main.game.getPlayer(), new ArrayList());
                        }
                    };
                }
            }
            return null;
        }

        @Override
        public DialogueNodeType getDialogueNodeType() {
            return DialogueNodeType.NORMAL;
        }
    };
    private StringBuilder endTurnStatusEffectText = new StringBuilder();

    public void initialiseCombat(List<NPC> allies, boolean addElementalsToAllies, NPC enemyLeader, List<NPC> enemies, Map<GameCharacter, String> openingDescriptions) {
        this.initialiseCombat(allies, addElementalsToAllies, enemyLeader, enemies, openingDescriptions, false, false);
    }

    public void initialiseCombat(List<NPC> allies, boolean addElementalsToAllies, NPC enemyLeader, List<NPC> enemies, Map<GameCharacter, String> openingDescriptions, boolean escapeBlocked, boolean submitBlocked) {
        this.playerPostVictoryDialogue = null;
        this.playerPostDefeatDialogue = null;
        this.allCombatants = new ArrayList<NPC>();
        this.allies = new ArrayList<NPC>();
        this.enemyLeader = enemyLeader;
        this.enemies = new ArrayList<NPC>();
        this.activeCombatants = new ArrayList<GameCharacter>();
        this.predictionContent = new HashMap<GameCharacter, List<String>>();
        this.combatContent = new HashMap<GameCharacter, List<String>>();
        this.escapeDescriptionMap = new HashMap<GameCharacter, List<String>>();
        this.itemsToBeUsed = new HashMap<GameCharacter, List<Util.Value<GameCharacter, AbstractItem>>>();
        this.preferredTargets = new HashMap<GameCharacter, GameCharacter>();
        this.manaBurnStack = new HashMap<GameCharacter, Stack<Float>>();
        this.statusEffectsToApply = new HashMap<GameCharacter, Map<AbstractStatusEffect, Integer>>();
        this.predictionContent.put(Main.game.getPlayer(), new ArrayList());
        this.itemsToBeUsed.put(Main.game.getPlayer(), new ArrayList());
        this.manaBurnStack.put(Main.game.getPlayer(), new Stack());
        this.statusEffectsToApply.put(Main.game.getPlayer(), new HashMap());
        this.combatContent.put(Main.game.getPlayer(), new ArrayList());
        this.activeCombatants.add(Main.game.getPlayer());
        this.weaponsThrownDuringTurn = new HashMap<GameCharacter, Map<InventorySlot, Map<AbstractWeapon, Integer>>>();
        this.weaponsThrownDuringCombat = new HashMap<GameCharacter, Map<InventorySlot, Map<AbstractWeapon, Integer>>>();
        this.thrownWeaponsDepleted = new HashMap<GameCharacter, Map<InventorySlot, AbstractWeaponType>>();
        this.resetWeaponsThrownDuringTurn(Main.game.getPlayer());
        this.resetWeaponsThrownDuringCombat(Main.game.getPlayer());
        this.resetThrownWeaponsDepleted(Main.game.getPlayer());
        if (addElementalsToAllies) {
            if (Main.game.getPlayer().isElementalSummoned()) {
                this.addAlly(Main.game.getPlayer().getElemental());
                Main.game.getPlayer().getElemental().setLocation(Main.game.getPlayer(), false);
            }
            if (allies != null) {
                for (NPC nPC : allies) {
                    this.addAlly(nPC);
                    if (!nPC.isElementalSummoned()) continue;
                    this.addAlly(nPC.getElemental());
                    nPC.getElemental().setLocation(nPC, false);
                }
            }
        }
        for (NPC nPC : enemies) {
            this.addEnemy(nPC);
            if (!nPC.isElementalSummoned()) continue;
            this.addEnemy(nPC.getElemental());
            nPC.getElemental().setLocation(nPC, false);
        }
        enemies.sort((enemy1, enemy2) -> enemy2.getLevel() - enemy1.getLevel());
        this.targetedEnemy = enemies.get(0);
        this.targetedAlly = Main.game.getPlayer();
        this.activeNPC = enemies.get(0);
        this.attemptedEscape = false;
        this.escaped = false;
        this.playerVictory = false;
        this.totalDamageTaken = new HashMap<GameCharacter, Float>();
        this.turn = 0;
        this.postCombatStringBuilder.setLength(0);
        this.combatTurnResolutionStringBuilder.setLength(0);
        if (escapeBlocked) {
            this.escapeChance = 0.0f;
        } else {
            this.escapeChance = enemies.get(0).getEscapeChance();
            if (Main.game.getPlayer().hasTrait(Perk.RUNNER, true)) {
                this.escapeChance *= 1.5f;
            } else if (Main.game.getPlayer().hasTrait(Perk.RUNNER_2, true)) {
                this.escapeChance *= 2.0f;
            }
            if (this.escapeChance > 0.0f && Main.game.getPlayer().hasTrait(Perk.JOB_ATHLETE, true)) {
                this.escapeChance = 100.0f;
            }
            if (this.escapeChance > 0.0f && Main.game.getPlayer().getSubspecies() == Subspecies.CAT_MORPH_CHEETAH) {
                boolean cheetahEnemy = false;
                for (GameCharacter enemy : this.getEnemies(Main.game.getPlayer())) {
                    if (enemy.getSubspecies() != Subspecies.CAT_MORPH_CHEETAH) continue;
                    cheetahEnemy = true;
                }
                if (!cheetahEnemy) {
                    this.escapeChance = 100.0f;
                }
            }
        }
        this.submitBlocked = submitBlocked;
        String startingEffect = "";
        if (Main.game.getPlayer().hasSpellUpgrade(SpellUpgrade.TELEPATHIC_COMMUNICATION_3)) {
            Main.game.getPlayer().addStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION, 11);
            startingEffect = Spell.getBasicStatusEffectApplication(Main.game.getPlayer(), true, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION, 10)));
        } else if (Main.game.getPlayer().hasSpellUpgrade(SpellUpgrade.TELEPATHIC_COMMUNICATION_2)) {
            Main.game.getPlayer().addStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_PROJECTED_TOUCH, 11);
            startingEffect = Spell.getBasicStatusEffectApplication(Main.game.getPlayer(), true, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPATHIC_COMMUNICATION_PROJECTED_TOUCH, 10)));
        } else if (Main.game.getPlayer().hasSpellUpgrade(SpellUpgrade.TELEPATHIC_COMMUNICATION_1)) {
            Main.game.getPlayer().addStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION, 11);
            startingEffect = Spell.getBasicStatusEffectApplication(Main.game.getPlayer(), true, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPATHIC_COMMUNICATION, 10)));
        }
        if (Main.game.getPlayer().hasTrait(Perk.JOB_SOLDIER, true)) {
            Main.game.getPlayer().addStatusEffect(StatusEffect.COMBAT_JOB_SOLDIER, 2);
            this.combatContent.get(Main.game.getPlayer()).add("\u4f60\u5728\u7b2c\u4e00\u56de\u5408\u4e2d\u9020\u6210\u7684\u4efb\u610f" + Attribute.HEALTH_MAXIMUM.getName() + "\u4f24\u5bb3\u90fd\u4f1a[style.boldExcellent(\u52a0\u500d)]\uff0c\u8fd9\u662f\u7531\u4e8e\u4f60\u7684<b style='color:" + Perk.JOB_SOLDIER.getColour().toWebHexString() + ";'>" + Perk.JOB_SOLDIER.getName(Main.game.getPlayer()) + "</b>\u80fd\u529b\u3002");
        }
        this.combatContent.get(Main.game.getPlayer()).add(openingDescriptions != null && openingDescriptions.containsKey(Main.game.getPlayer()) ? openingDescriptions.get(Main.game.getPlayer()) : "\u4f60\u51c6\u5907\u597d\u884c\u52a8\u4e86\u2026\u2026");
        String string = this.getPregnancyProtectionText(Main.game.getPlayer());
        if (!string.isEmpty()) {
            this.combatContent.get(Main.game.getPlayer()).add(string);
        }
        this.combatContent.get(Main.game.getPlayer()).add(startingEffect);
        for (NPC combatant : this.allCombatants) {
            startingEffect = "";
            if (combatant.hasSpellUpgrade(SpellUpgrade.TELEPATHIC_COMMUNICATION_3)) {
                combatant.addStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION, 11);
                startingEffect = Spell.getBasicStatusEffectApplication(combatant, true, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION, 10)));
            } else if (combatant.hasSpellUpgrade(SpellUpgrade.TELEPATHIC_COMMUNICATION_2)) {
                combatant.addStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_PROJECTED_TOUCH, 11);
                startingEffect = Spell.getBasicStatusEffectApplication(combatant, true, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPATHIC_COMMUNICATION_PROJECTED_TOUCH, 10)));
            } else if (combatant.hasSpellUpgrade(SpellUpgrade.TELEPATHIC_COMMUNICATION_1)) {
                combatant.addStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION, 11);
                startingEffect = Spell.getBasicStatusEffectApplication(combatant, true, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPATHIC_COMMUNICATION, 10)));
            }
            if (combatant.hasTrait(Perk.JOB_SOLDIER, true)) {
                combatant.addStatusEffect(StatusEffect.COMBAT_JOB_SOLDIER, 2);
                this.combatContent.get(combatant).add(UtilText.parse((GameCharacter)combatant, "\u7b2c\u4e00\u4e2a\u56de\u5408\u4e2d\uff0c[npc.name]\u9020\u6210\u7684\u4efb\u4f55" + Attribute.HEALTH_MAXIMUM.getName() + "\u4f24\u5bb3\u90fd\u4f1a[style.boldExcellent(\u7ffb\u500d)]\uff0c\u8fd9\u591a\u4e8f\u4e86[npc.her]<b style='color:" + Perk.JOB_SOLDIER.getColour().toWebHexString() + ";'>" + Perk.JOB_SOLDIER.getName(combatant) + "</b>\u80fd\u529b\u3002", new ParserTag[0]));
            }
            this.combatContent.get(combatant).add(UtilText.parse((GameCharacter)combatant, openingDescriptions != null && openingDescriptions.containsKey(combatant) ? openingDescriptions.get(combatant) : "[npc.Name]\u51c6\u5907\u884c\u52a8\u2026\u2026", new ParserTag[0]));
            String string2 = this.getPregnancyProtectionText(combatant);
            if (!string2.isEmpty()) {
                this.combatContent.get(combatant).add(string2);
            }
            this.combatContent.get(combatant).add(startingEffect);
        }
        Main.game.getPlayer().calculateStatusEffects(0);
        Main.game.getPlayer().resetSelectedMoves();
        Main.game.getPlayer().resetMoveCooldowns();
        this.applyNewTurnShielding(Main.game.getPlayer());
        Main.game.getPlayer().setRemainingAP(Main.game.getPlayer().getMaxAP(), null, null);
        this.combatTurnResolutionStringBuilder.append(this.getCharactersTurnDiv(Main.game.getPlayer(), this.getTurn() == 0 ? "\u51c6\u5907" : "", this.combatContent.get(Main.game.getPlayer())));
        Main.game.setInCombat(true);
        for (NPC npc : this.allCombatants) {
            npc.calculateStatusEffects(0);
            this.combatTurnResolutionStringBuilder.append(this.getCharactersTurnDiv(npc, this.getTurn() == 0 ? "\u51c6\u5907" : "", this.combatContent.get(npc)));
            npc.resetSelectedMoves();
            npc.resetDefaultMoves();
            npc.resetMoveCooldowns();
            this.applyNewTurnShielding(npc);
            npc.setRemainingAP(npc.getMaxAP(), null, null);
            List<GameCharacter> npcAllies = this.getAllies(npc);
            List<GameCharacter> npcEnemies = this.getEnemies(npc);
            npc.selectMoves(npcEnemies, npcAllies);
            this.predictionContent.put(npc, npc.getMovesPredictionString(npcEnemies, npcAllies));
        }
    }

    public void setCharacterTurnContent(GameCharacter character, List<String> descriptions) {
        this.combatContent.put(character, descriptions);
    }

    private String getCharactersTurnDiv(GameCharacter character, String title, List<String> descriptions) {
        String effects = this.applyEffects(character);
        StringBuilder sb = new StringBuilder();
        boolean enemy = this.enemies.contains(character);
        sb.append("<div class='container-full-width' style='text-align:center; box-sizing: border-box; border:6px solid " + (enemy ? PresetColour.GENERIC_MINOR_BAD : PresetColour.GENERIC_MINOR_GOOD).getShades()[0] + "; border-radius:5px;'>");
        sb.append("<div class='container-full-width' style='margin:2px; padding:4px; width:100%; border-radius:5px; text-align:center;'><b style='color:" + character.getFemininity().getColour().toWebHexString() + ";'>" + UtilText.parse(character, "[npc.Name]", new ParserTag[0]) + "</b></div>");
        sb.append("<div class='container-full-width'>");
        for (String s : descriptions) {
            if (s.isEmpty()) continue;
            sb.append("<div class='container-half-width' style='margin:2px; padding:4px; width:100%; border-radius:5px; background:" + PresetColour.BACKGROUND.toWebHexString() + ";'>" + s + "</div>");
        }
        if (!effects.isEmpty()) {
            sb.append("<div class='container-half-width' style='margin:2px; padding:4px; width:100%; border-radius:5px; background:" + PresetColour.BACKGROUND.toWebHexString() + ";'>" + effects + "</div>");
        }
        sb.append("</div>");
        sb.append("</div>");
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void endCombat(boolean playerVictory) {
        this.postCombatStringBuilder.setLength(0);
        this.playerVictory = playerVictory;
        for (NPC enemy : this.enemies) {
            enemy.removeFlag(NPCFlagValue.playerEscapedLastCombat);
        }
        if (playerVictory) {
            void var7_32;
            int xp = 0;
            int money = 0;
            for (NPC nPC : this.enemies) {
                xp += nPC.getExperienceFromVictory();
                money += nPC.getLootMoney();
                nPC.setLostCombatCount(nPC.getLostCombatCount() + 1);
            }
            for (NPC nPC : this.allies) {
                if (nPC.isElemental()) continue;
                this.postCombatStringBuilder.append(nPC.incrementExperience(xp, true));
            }
            this.postCombatStringBuilder.append(Main.game.getPlayer().incrementExperience(xp, true));
            if (money > 0) {
                this.postCombatStringBuilder.append(Main.game.getPlayer().incrementMoney(money));
            }
            HashMap<AbstractCoreItem, Integer> lootedItemsMap = new HashMap<AbstractCoreItem, Integer>();
            for (NPC nPC : this.enemies) {
                if (nPC.getLootItems() == null) continue;
                for (AbstractCoreItem abstractCoreItem : nPC.getLootItems()) {
                    lootedItemsMap.putIfAbsent(abstractCoreItem, 0);
                    lootedItemsMap.put(abstractCoreItem, (Integer)lootedItemsMap.get(abstractCoreItem) + 1);
                    if (abstractCoreItem instanceof AbstractItem) {
                        Main.game.getPlayer().addItem((AbstractItem)abstractCoreItem, false, true);
                        continue;
                    }
                    if (abstractCoreItem instanceof AbstractWeapon) {
                        Main.game.getPlayer().addWeapon((AbstractWeapon)abstractCoreItem, false);
                        continue;
                    }
                    if (!(abstractCoreItem instanceof AbstractClothing)) continue;
                    Main.game.getPlayer().addClothing((AbstractClothing)abstractCoreItem, false);
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry entry : lootedItemsMap.entrySet()) {
                arrayList.add("<b style='color:" + ((AbstractCoreItem)entry.getKey()).getRarity().getColour().toWebHexString() + ";'>" + ((AbstractCoreItem)entry.getKey()).getName() + "</b>" + (String)((Integer)entry.getValue() > 1 ? " <b>(x" + String.valueOf(entry.getValue()) + ")</b>" : ""));
            }
            if (!arrayList.isEmpty()) {
                this.postCombatStringBuilder.append("<div class='container-full-width' style='text-align:center;'>\u4f60[style.boldGood(\u83b7\u5f97\u4e86)]" + Util.stringsToStringList(arrayList, false) + "\uff01</div>");
            }
            boolean bl = false;
            boolean bl2 = false;
            for (NPC enemy : this.enemies) {
                int essencesGained = enemy.getLootEssenceDrops();
                var7_32 += essencesGained;
                if (essencesGained <= 0 || Main.game.getDialogueFlags().values.contains(DialogueFlagValue.essencePostCombatDiscovered)) continue;
                Main.game.getDialogueFlags().values.add(DialogueFlagValue.essencePostCombatDiscovered);
                if (bl) continue;
                if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                    this.postCombatStringBuilder.append(UtilText.parse((GameCharacter)enemy, "<p><i>[npc.Name]\u8e09\u8e09\u8dc4\u8dc4\u5730\u9000\u540e\uff0c\u8d25\u4e0b\u9635\u6765\uff0c\u4f46\u8fd8\u6ca1\u7b49\u4f60\u5e86\u795d\u80dc\u5229\u7684\u559c\u60a6\uff0c\u5468\u56f4\u7684\u4e16\u754c\u4fbf\u6a21\u7cca\u8d77\u6765\u3002[npc.her]\u53e3\u4e2d\u53d1\u51fa\u7684\u5598\u606f\u58f0\u4e5f\u9010\u6e10\u53d8\u5f31\uff0c\u53d8\u6210\u4e86\u95f7\u54cd\uff1b\u5c31\u4eff\u4f5b\u6f5c\u5728\u6c34\u4e0b\u542c\u7740[npc.her]\u8bf4\u8bdd\u4e00\u6837\u3002\u4f60\u6643\u4e86\u6643\u8111\u888b\uff0c\u4f46\u5e76\u6ca1\u6709\u6e05\u9192\u8fc7\u6765\uff0c\u4e8e\u662f\u4f4e\u5934\u770b\u5411[npc.name]\uff0c\u662f\u4e0d\u662f[npc.sheIs]\u4e5f\u540c\u6837\u6536\u5230\u4e86\u5f71\u54cd\uff0c\u53ef\u968f\u540e\u4f60\u5374\u60ca\u8bb6\u5730\u77aa\u5927\u4e86\u773c\u775b\u3002</p><p>\u4e00\u80a1\u7c89\u8272\u7684\u5149\u8292\u5728[npc.her]\u7684\u8eab\u4f53\u5468\u56f4\u6d6e\u73b0\uff0c\u5c31\u8ddf\u4f60\u5728\u8389\u83b1\u96c5\u5b9e\u9a8c\u5ba4\u505a\u6d4b\u8bd5\u65f6\u7684\u90a3\u4e2a\u4e00\u6a21\u4e00\u6837\u3002\u4f60\u5f88\u5feb\u5c31\u660e\u767d\u8fc7\u6765\uff0c\u4f60\u4e0d\u77e5\u4e3a\u4f55\u80fd\u591f\u770b\u5230[npc.namePos]\u7684\u5965\u672f\u7075\u6c14\u4e86\uff0c\u4e8e\u662f\u7740\u8ff7\u4e86\u4f3c\u7684\uff0c\u76f4\u52fe\u52fe\u5730\u76ef\u7740\u4e00\u5757\u4e0d\u5927\u4e0d\u5c0f\u7684\u788e\u7247\u7f13\u7f13\u4ece[npc.herHim]\u5468\u56f4\u788e\u88c2\u5f00\u6765\u3002\u7b49\u5230\u5b8c\u5168\u4e0e\u7075\u6c14\u7684\u5176\u4ed6\u90e8\u5206\u8131\u79bb\uff0c\u90a3\u80fd\u91cf\u7684\u788e\u7247\u4fbf\u7a81\u7136\u4eff\u4f5b\u6709\u610f\u8bc6\u5730\u5411\u4f60\u98de\u6765\u3002</p><p>\u4f60\u88ab\u81ea\u5df1\u6240\u5904\u7684\u5947\u5999\u72b6\u6001\u62d6\u6162\u4e86\u53cd\u5e94\u901f\u5ea6\uff0c\u5934\u6655\u76ee\u7729\uff0c\u6839\u672c\u6ca1\u6709\u673a\u4f1a\u8eb2\u95ea\uff0c\u5f53\u788e\u7247\u63a5\u89e6\u5230\u4f60\u7684\u80f8\u819b\u65f6\uff0c\u7adf\u76f4\u76f4\u523a\u5165\u4e86\u8eab\u4f53\u3002\u788e\u7247\u8fdb\u5165\u8eab\u4f53\u7684\u90a3\u4e00\u523b\uff0c\u4f60\u9644\u8fd1\u7684\u4e16\u754c\u4fbf\u77ac\u95f4\u6062\u590d\u4e86\u6e05\u6670\uff0c\u4f60\u8fd9\u624d\u53cd\u5e94\u8fc7\u6765\u81ea\u5df1\u7528\u529b\u5730\u5438\u7740\u6c14\uff0c\u90a3\u80fd\u91cf\u4f3c\u4e4e\u878d\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5965\u672f\u7075\u6c14\u4e2d\u3002</p><p>\u4f60\u53c8\u4f4e\u5934\u770b\u5411[npc.name]\uff0c\u524d\u4e00\u79d2\u8fd8\u5728\u8eab\u8fb9\u5ffd\u9690\u5ffd\u73b0\u7684\u7c89\u8272\u80fd\u91cf\u573a\u5df2\u7ecf\u6ca1\u4e86\u8e2a\u8ff9\uff0c[npc.she]\u4f3c\u4e4e\u5b8c\u5168\u6ca1\u6709\u770b\u5230\u4f60\u521a\u624d\u76ee\u7779\u7684\u4e00\u5207\u3002\u4f60\u89c9\u5f97\u6700\u597d\u8fd8\u662f\u53bb\u627e\u8389\u83b1\u96c5\uff0c\u95ee\u95ee\u521a\u624d\u53d1\u751f\u4e86\u4ec0\u4e48\uff0c\u4f46\u73b0\u5728\u4f60\u8981\u5148\u60f3\u60f3\u8be5\u600e\u4e48\u5904\u7406\u8fd9\u4e2a\u9ebb\u70e6\u7684[npc.race]\u2026\u2026</i></p>" + (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) ? Main.game.getPlayer().startQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) : ""), new ParserTag[0]));
                    continue;
                }
                this.postCombatStringBuilder.append(UtilText.parse((GameCharacter)enemy, "<p><i>[npc.Name]\u8e09\u8e09\u8dc4\u8dc4\u5730\u9000\u540e\uff0c\u8d25\u4e0b\u9635\u6765\uff0c\u4f46\u8fd8\u6ca1\u7b49\u4f60\u5e86\u795d\u80dc\u5229\u7684\u559c\u60a6\uff0c\u5468\u56f4\u7684\u4e16\u754c\u4fbf\u6a21\u7cca\u8d77\u6765\u3002[npc.her]\u53e3\u4e2d\u53d1\u51fa\u7684\u5598\u606f\u58f0\u4e5f\u9010\u6e10\u53d8\u5f31\uff0c\u53d8\u6210\u4e86\u95f7\u54cd\uff1b\u5c31\u4eff\u4f5b\u6f5c\u5728\u6c34\u4e0b\u542c\u7740[npc.her]\u8bf4\u8bdd\u4e00\u6837\u3002\u4f60\u6643\u4e86\u6643\u8111\u888b\uff0c\u4f46\u5e76\u6ca1\u6709\u6e05\u9192\u8fc7\u6765\uff0c\u4e8e\u662f\u4f4e\u5934\u770b\u5411[npc.name]\uff0c\u662f\u4e0d\u662f[npc.sheIs]\u4e5f\u540c\u6837\u6536\u5230\u4e86\u5f71\u54cd\uff0c\u53ef\u968f\u540e\u4f60\u5374\u60ca\u8bb6\u5730\u77aa\u5927\u4e86\u773c\u775b\u3002</p><p>\u4e00\u80a1\u7c89\u8272\u7684\u5149\u8292\u5728[npc.her]\u7684\u8eab\u4f53\u5468\u56f4\u6d6e\u73b0\uff0c\u5c31\u8ddf\u4f60\u5728\u8389\u83b1\u96c5\u5b9e\u9a8c\u5ba4\u505a\u6d4b\u8bd5\u65f6\u7684\u90a3\u4e2a\u4e00\u6a21\u4e00\u6837\u3002\u4f60\u5f88\u5feb\u5c31\u660e\u767d\u8fc7\u6765\uff0c\u4f60\u4e0d\u77e5\u4e3a\u4f55\u80fd\u591f\u770b\u5230[npc.namePos]\u7684\u5965\u672f\u7075\u6c14\u4e86\uff0c\u4e8e\u662f\u7740\u8ff7\u4e86\u4f3c\u7684\uff0c\u76f4\u52fe\u52fe\u5730\u76ef\u7740\u4e00\u5757\u4e0d\u5927\u4e0d\u5c0f\u7684\u788e\u7247\u7f13\u7f13\u4ece[npc.herHim]\u5468\u56f4\u788e\u88c2\u5f00\u6765\u3002\u7b49\u5230\u5b8c\u5168\u4e0e\u7075\u6c14\u7684\u5176\u4ed6\u90e8\u5206\u8131\u79bb\uff0c\u90a3\u80fd\u91cf\u7684\u788e\u7247\u4fbf\u7a81\u7136\u4eff\u4f5b\u6709\u610f\u8bc6\u5730\u5411\u4f60\u98de\u6765\u3002</p><p>\u4f60\u88ab\u81ea\u5df1\u6240\u5904\u7684\u5947\u5999\u72b6\u6001\u62d6\u6162\u4e86\u53cd\u5e94\u901f\u5ea6\uff0c\u5934\u6655\u76ee\u7729\uff0c\u6839\u672c\u6ca1\u6709\u673a\u4f1a\u8eb2\u95ea\uff0c\u5f53\u788e\u7247\u63a5\u89e6\u5230\u4f60\u7684\u80f8\u819b\u65f6\uff0c\u7adf\u76f4\u76f4\u523a\u5165\u4e86\u8eab\u4f53\u3002\u788e\u7247\u8fdb\u5165\u8eab\u4f53\u7684\u90a3\u4e00\u523b\uff0c\u4f60\u9644\u8fd1\u7684\u4e16\u754c\u4fbf\u77ac\u95f4\u6062\u590d\u4e86\u6e05\u6670\uff0c\u4f60\u8fd9\u624d\u53cd\u5e94\u8fc7\u6765\u81ea\u5df1\u7528\u529b\u5730\u5438\u7740\u6c14\uff0c\u90a3\u80fd\u91cf\u4f3c\u4e4e\u878d\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5965\u672f\u7075\u6c14\u4e2d\u3002</p><p>\u4f60\u53c8\u4f4e\u5934\u770b\u5411[npc.name]\uff0c\u524d\u4e00\u79d2\u8fd8\u5728\u8eab\u8fb9\u5ffd\u9690\u5ffd\u73b0\u7684\u7c89\u8272\u80fd\u91cf\u573a\u5df2\u7ecf\u6ca1\u4e86\u8e2a\u8ff9\uff0c[npc.she]\u4f3c\u4e4e\u5b8c\u5168\u6ca1\u6709\u770b\u5230\u4f60\u521a\u624d\u76ee\u7779\u7684\u4e00\u5207\u3002\u4f60\u5ffd\u7136\u56de\u5fc6\u8d77\u8389\u83b1\u96c5\u544a\u8bc9\u4f60\u6709\u5173\u5438\u6536\u7cbe\u534e\u7684\u4e8b\u60c5\uff0c\u800c\u4e14\u8fd9\u79cd\u884c\u4e3a\u5bf9\u53cc\u65b9\u90fd\u6ca1\u6709\u4efb\u4f55\u635f\u5bb3\u3002\u4f60\u957f\u8212\u4e00\u53e3\u6c14\uff0c\u5c06\u6ce8\u610f\u529b\u53c8\u8f6c\u79fb\u56de\u8fd9\u4e2a\u9ebb\u70e6\u7684[npc.race]\u8eab\u4e0a\u2026\u2026</i></p>", new ParserTag[0]));
            }
            if (var7_32 > 0) {
                this.postCombatStringBuilder.append("<div class='container-full-width' style='text-align:center;'>" + Main.game.getPlayer().incrementEssenceCount((int)var7_32, true) + "</div></br>");
            }
        } else {
            int xpGain = Main.game.getPlayer().getLevel() * 2;
            for (NPC enemy : this.enemies) {
                if (enemy.isElemental()) continue;
                this.postCombatStringBuilder.append(enemy.incrementExperience(xpGain, true));
            }
            long money = Main.game.getPlayer().getMoney();
            int n = -this.enemyLeader.getLootMoney() / 2 * this.enemies.size();
            if (n != 0 && this.enemyLeader.isLootingPlayerAfterCombat()) {
                Main.game.getPlayer().incrementMoney(n);
                this.postCombatStringBuilder.append("<div class='container-full-width' style='text-align:center;'>\u4f60[style.boldBad(\u5931\u53bb\u4e86)]" + UtilText.formatAsMoney(Math.abs(Main.game.getPlayer().getMoney() == 0L ? money : (long)n)) + "\uff01</div>");
            }
            for (NPC nPC : this.enemies) {
                nPC.setWonCombatCount(nPC.getWonCombatCount() + 1);
            }
        }
        for (GameCharacter combatant : this.getAllCombatants(true)) {
            if (!combatant.isElementalSummoned()) continue;
            combatant.getElemental().returnToHome();
            if (playerVictory && this.getEnemies(Main.game.getPlayer()).contains(combatant) || !playerVictory && !this.getEnemies(Main.game.getPlayer()).contains(combatant)) {
                combatant.setElementalSummoned(false);
                this.postCombatStringBuilder.append(UtilText.parse(combatant, combatant.getElemental(), "<div class='container-full-width' style='text-align:center;'><i>[npc.NamePos]\u7684\u5143\u7d20\u4f53<span style='colour:" + combatant.getElemental().getFemininity().getColour().toWebHexString() + ";'>[npc2.name]</span>\u5b8c\u5168\u8017\u5c3d\u4e86\u80fd\u91cf\uff0c\u4e8e\u662f\u88ab[style.italicsBad(\u9a71\u6563)]\u4e86\uff01</i></div>", new ParserTag[0]));
                continue;
            }
            this.postCombatStringBuilder.append(UtilText.parse(combatant, combatant.getElemental(), "<div class='container-full-width' style='text-align:center;'><i>[npc.NamePos]\u7684\u5143\u7d20\u4f53<span style='colour:" + combatant.getElemental().getFemininity().getColour().toWebHexString() + ";'>[npc2.name]</span>\u8017\u5c3d\u4e86\u80fd\u91cf\uff0c\u4e8e\u662f[style.italicsArcane(\u53d8\u56de\u4e86\u88ab\u52a8\u5f62\u6001)]\uff01</i></div>", new ParserTag[0]));
        }
        Main.game.setInCombat(false);
        for (GameCharacter character : this.getAllCombatants(true)) {
            void var5_21;
            void var5_19;
            boolean anyWeaponsRecovered = false;
            boolean bl = false;
            while (var5_19 < Math.min(character.getArmRows(), character.getMainWeaponArray().length)) {
                for (Map.Entry<AbstractWeapon, Integer> entry : this.weaponsThrownDuringCombat.get(character).get((Object)InventorySlot.mainWeaponSlots[var5_19]).entrySet()) {
                    AbstractWeapon abstractWeapon = entry.getKey();
                    for (int count = 0; count < entry.getValue(); ++count) {
                        if (!(Math.random() * 100.0 <= (double)abstractWeapon.getWeaponType().getOneShotChanceToRecoverAfterCombat())) continue;
                        if (character.getMainWeapon((int)var5_19) == null) {
                            character.equipMainWeapon(abstractWeapon, (int)var5_19, false);
                        } else {
                            character.addWeapon(abstractWeapon, 1, false, false);
                        }
                        if (!anyWeaponsRecovered) {
                            this.postCombatStringBuilder.append("<div class='container-full-width' style='text-align:center;'><i>");
                            if (character.isPlayer()) {
                                this.postCombatStringBuilder.append("[style.boldGood(\u5355\u53d1\u6b66\u5668\u88c5\u586b\uff1a)]");
                            } else {
                                this.postCombatStringBuilder.append(UtilText.parse(character, "[style.boldGood([npc.name]\u5355\u53d1\u6b66\u5668\u88c5\u586b\uff1a)]", new ParserTag[0]));
                            }
                            this.postCombatStringBuilder.append("<br/>");
                            this.postCombatStringBuilder.append(Util.capitaliseSentence(abstractWeapon.getDisplayName(true)));
                            anyWeaponsRecovered = true;
                            continue;
                        }
                        this.postCombatStringBuilder.append("\uff0c" + Util.capitaliseSentence(abstractWeapon.getDisplayName(true)));
                    }
                }
                ++var5_19;
            }
            boolean bl3 = false;
            while (var5_21 < Math.min(character.getArmRows(), character.getOffhandWeaponArray().length)) {
                for (Map.Entry<AbstractWeapon, Integer> entry : this.weaponsThrownDuringCombat.get(character).get((Object)InventorySlot.offhandWeaponSlots[var5_21]).entrySet()) {
                    AbstractWeapon abstractWeapon = entry.getKey();
                    for (int count = 0; count < entry.getValue(); ++count) {
                        if (!(Math.random() * 100.0 <= (double)abstractWeapon.getWeaponType().getOneShotChanceToRecoverAfterCombat())) continue;
                        if (character.getOffhandWeapon((int)var5_21) == null) {
                            character.equipOffhandWeapon(abstractWeapon, (int)var5_21, false);
                        } else {
                            character.addWeapon(abstractWeapon, 1, false, false);
                        }
                        if (!anyWeaponsRecovered) {
                            this.postCombatStringBuilder.append("<div class='container-full-width' style='text-align:center;'><i>");
                            if (character.isPlayer()) {
                                this.postCombatStringBuilder.append("[style.boldGood(\u5355\u53d1\u6b66\u5668\u88c5\u586b\uff1a)]");
                            } else {
                                this.postCombatStringBuilder.append(UtilText.parse(character, "[style.boldGood([npc.name]\u5355\u53d1\u6b66\u5668\u88c5\u586b\uff1a)]", new ParserTag[0]));
                            }
                            this.postCombatStringBuilder.append("<br/>");
                            this.postCombatStringBuilder.append(Util.capitaliseSentence(abstractWeapon.getDisplayName(true)));
                            anyWeaponsRecovered = true;
                            continue;
                        }
                        this.postCombatStringBuilder.append("\uff0c" + Util.capitaliseSentence(abstractWeapon.getDisplayName(true)));
                    }
                }
                ++var5_21;
            }
            if (anyWeaponsRecovered) {
                this.postCombatStringBuilder.append("</i></div>");
            }
            if (this.enemies.contains(character)) {
                character.setMana(character.getAttributeValue(Attribute.MANA_MAXIMUM));
                character.setHealth(character.getAttributeValue(Attribute.HEALTH_MAXIMUM));
            } else {
                character.setMana(Math.max(character.getMana(), 5.0f));
                character.setHealth(Math.max(character.getHealth(), 5.0f));
            }
            character.clearCombatStatusEffects();
        }
        Main.game.getTextStartStringBuilder().append(this.postCombatStringBuilder.toString());
    }

    private String npcStatus() {
        return "";
    }

    public DialogueNode startCombat() {
        return this.ENEMY_ATTACK;
    }

    public boolean isCombatantDefeated(GameCharacter character) {
        return character.getHealth() <= 0.0f || character.getLust() >= 100.0f && character.isVulnerableToLustLoss();
    }

    public boolean isOpponent(GameCharacter character, GameCharacter target) {
        if (this.allies.contains(character) || character.isPlayer()) {
            return this.enemies.contains(target);
        }
        return this.allies.contains(target) || target.isPlayer();
    }

    private boolean isAlliedPartyDefeated() {
        for (NPC ally : this.allies) {
            if (this.isCombatantDefeated(ally)) continue;
            return false;
        }
        return this.isCombatantDefeated(Main.game.getPlayer());
    }

    private boolean isEnemyPartyDefeated() {
        for (NPC enemy : this.enemies) {
            if (this.isCombatantDefeated(enemy)) continue;
            return false;
        }
        return true;
    }

    private Response getEndCombatDialogue(boolean applyEffects, boolean playerVictory) {
        if (playerVictory && this.getPlayerPostVictoryDialogue() != null) {
            return new Response("\u80dc\u5229", "\u4f60\u8d62\u4e86\uff01", this.getPlayerPostVictoryDialogue());
        }
        if (!playerVictory && this.getPlayerPostDefeatDialogue() != null) {
            return new Response("\u5931\u8d25", "\u4f60\u8f93\u4e86\uff01", this.getPlayerPostDefeatDialogue());
        }
        return this.enemyLeader.endCombat(applyEffects, playerVictory);
    }

    private Response getMoveResponse(final AbstractCombatMove move, final List<GameCharacter> pcEnemies, final List<GameCharacter> pcAllies) {
        final GameCharacter moveTarget = move.isCanTargetAllies() || move.isCanTargetSelf() ? this.getTargetedAlliedCombatant() : this.getTargetedCombatant();
        final int selectedMoveIndex = Main.game.getPlayer().getSelectedMoves().size();
        String rejectionReason = move.isUsable(selectedMoveIndex, Main.game.getPlayer(), moveTarget, pcEnemies, pcAllies);
        if (rejectionReason != null) {
            return new Response(Util.capitaliseSentence(move.getName(selectedMoveIndex, Main.game.getPlayer())), rejectionReason, null);
        }
        StringBuilder moveStatblock = new StringBuilder();
        boolean isCrit = move.canCrit(selectedMoveIndex, Main.game.getPlayer(), moveTarget, pcEnemies, pcAllies);
        if (move.getStatusEffects(Main.game.getPlayer(), moveTarget, isCrit) != null && !move.getStatusEffects(Main.game.getPlayer(), moveTarget, isCrit).isEmpty()) {
            for (Map.Entry<AbstractStatusEffect, Integer> entry : move.getStatusEffects(Main.game.getPlayer(), moveTarget, isCrit).entrySet()) {
                moveStatblock.append("\u65bd\u52a0<b style='color:" + entry.getKey().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(entry.getKey().getName(moveTarget)) + "</b><b>" + String.valueOf(entry.getValue()) + "\u56de\u5408</b><br/>");
            }
        }
        StringBuilder critText = new StringBuilder();
        critText.append("<br/>[style.colourCrit(\u66b4\u51fb\u8981\u6c42)]\uff1a");
        for (String s : move.getCritRequirements(Main.game.getPlayer(), moveTarget, pcEnemies, pcAllies)) {
            critText.append(s);
        }
        String string = move.getPrediction(selectedMoveIndex, Main.game.getPlayer(), moveTarget, pcEnemies, pcAllies);
        return new Response(Util.capitaliseSentence(move.getName(selectedMoveIndex, Main.game.getPlayer())), moveStatblock.toString() + string + critText.toString(), this.ENEMY_ATTACK){

            @Override
            public void effects() {
                Main.game.getPlayer().selectMove(Main.game.getPlayer().getSelectedMoves().size(), move, moveTarget, pcEnemies, pcAllies);
                Combat.this.predictionContent.put(Main.game.getPlayer(), new ArrayList());
                int i = 0;
                for (Util.Value<GameCharacter, AbstractCombatMove> selectedMove : Main.game.getPlayer().getSelectedMoves()) {
                    Combat.this.predictionContent.get(Main.game.getPlayer()).add(selectedMove.getValue().getPrediction(i, Main.game.getPlayer(), selectedMove.getKey(), pcEnemies, pcAllies));
                    ++i;
                }
            }

            @Override
            public Colour getHighlightColour() {
                return move.getColourByDamageType(selectedMoveIndex, Main.game.getPlayer());
            }

            @Override
            public AbstractCombatMove getAssociatedCombatMove() {
                return move;
            }
        };
    }

    public List<String> applyExtraAttackEffects(GameCharacter attacker, GameCharacter target, Attack attackType, AbstractWeapon weapon, boolean isHit, boolean isCritical) {
        ArrayList<String> extraAttackEffects = new ArrayList<String>();
        if (target.hasStatusEffect(StatusEffect.CLOAK_OF_FLAMES_3) && (attackType == Attack.MAIN || attackType == Attack.OFFHAND || attackType == Attack.DUAL) && (weapon == null || weapon.getWeaponType().isMelee())) {
            float cloakOfFlamesDamage = Math.round(5.0f * (1.0f + target.getAttributeValue(Attribute.DAMAGE_FIRE) / 100.0f));
            if ((cloakOfFlamesDamage = (float)Math.round(cloakOfFlamesDamage * 10.0f) / 10.0f) < 1.0f) {
                cloakOfFlamesDamage = 1.0f;
            }
            attacker.incrementHealth(-cloakOfFlamesDamage);
            if (attacker.isPlayer()) {
                extraAttackEffects.add(UtilText.parse(target, "\u4f60\u53d7\u5230\u4e86<b>" + cloakOfFlamesDamage + "</b>[style.boldFire(\u706b\u7130\u4f24\u5bb3)]\uff0c\u7531[npc.namePos]\u7684[style.boldFire(\u706b\u7130\u4e4b\u73af)]\u9020\u6210\uff01", new ParserTag[0]));
            } else if (target.isPlayer()) {
                extraAttackEffects.add(UtilText.parse(attacker, "[npc.Name]\u53d7\u5230\u4e86<b>" + cloakOfFlamesDamage + "</b>[style.boldFire(\u706b\u7130\u4f24\u5bb3)]\uff0c\u7531\u4f60\u7684[style.boldFire(\u706b\u7130\u4e4b\u73af)]\u9020\u6210\uff01", new ParserTag[0]));
            } else {
                extraAttackEffects.add(UtilText.parse(attacker, target, "[npc1.Name]\u53d7\u5230\u4e86<b>" + cloakOfFlamesDamage + "</b>[style.boldFire(\u706b\u7130\u4f24\u5bb3)]\uff0c\u7531[npc2.namePos]\u7684[style.boldFire(\u706b\u7130\u4e4b\u73af)]\u9020\u6210\uff01", new ParserTag[0]));
            }
        }
        if (isCritical && target.hasStatusEffect(StatusEffect.RAIN_CLOUD_DOWNPOUR_FOR_CLOUDBURST)) {
            target.removeStatusEffect(StatusEffect.RAIN_CLOUD);
            target.removeStatusEffect(StatusEffect.RAIN_CLOUD_CLOUDBURST);
            target.removeStatusEffect(StatusEffect.RAIN_CLOUD_DEEP_CHILL);
            target.removeStatusEffect(StatusEffect.RAIN_CLOUD_DOWNPOUR);
            target.removeStatusEffect(StatusEffect.RAIN_CLOUD_DOWNPOUR_FOR_CLOUDBURST);
            this.addStatusEffectToApply(target, StatusEffect.RAIN_CLOUD_CLOUDBURST, 6);
            extraAttackEffects.add(UtilText.parse(target, "\u7531\u4e8e[npc.name]\u88ab\u66b4\u51fb\u96c6\u4e2d\uff0c[npc.her]\u5934\u9876\u7684\u96e8\u4e91\u5c3a\u5bf8\u589e\u5927\u4e86\uff0c\u5e76\u4e14\u7a81\u7136\u7206\u53d1\u51fa\u6c79\u6d8c\u7684\u4e91\u6d41\uff01", new ParserTag[0]));
            extraAttackEffects.add(Spell.getBasicStatusEffectApplication(target, false, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.RAIN_CLOUD_CLOUDBURST, 6))));
        }
        if (attacker.isPlayer() && attacker.hasFetish(Fetish.FETISH_SADIST) && isCritical && isHit) {
            extraAttackEffects.add("\u7531\u4e8e\u4f60\u7684[style.boldFetish(\u65bd\u8650\u6027\u7656)]\uff0c\u51fb\u4e2d\u4ed6\u4eba\u8981\u5bb3\u5e26\u6765\u7684\u5feb\u611f\u5316\u6210\u4e86\u4e00\u4efd\u5965\u672f\u7cbe\u534e\uff01<br/>" + Main.game.getPlayer().incrementEssenceCount(1, false));
        }
        if (target.isPlayer() && target.hasFetish(Fetish.FETISH_MASOCHIST) && isCritical && isHit) {
            extraAttackEffects.add("\u7531\u4e8e\u4f60\u7684[style.boldFetish(\u53d7\u8650\u6027\u7656)]\uff0c\u88ab\u51fb\u4e2d\u8981\u5bb3\u5e26\u6765\u7684\u5feb\u611f\u5316\u6210\u4e86\u4e00\u4efd\u5965\u672f\u7cbe\u534e\uff01<br/>" + Main.game.getPlayer().incrementEssenceCount(1, false));
        }
        return extraAttackEffects;
    }

    private void escape(GameCharacter escapee) {
        this.attemptedEscape = true;
        boolean allEnemiesStunned = true;
        if (escapee.isPlayer() || this.getAllies(Main.game.getPlayer()).contains(escapee)) {
            for (GameCharacter enemy : this.getEnemies(Main.game.getPlayer())) {
                if (enemy.isStunned()) continue;
                allEnemiesStunned = false;
            }
        } else {
            if (Main.game.getPlayer().isStunned()) {
                allEnemiesStunned = false;
            }
            for (GameCharacter ally : this.getAllies(Main.game.getPlayer())) {
                if (!ally.isStunned()) continue;
                allEnemiesStunned = false;
            }
        }
        this.escapeDescriptionMap = new HashMap<GameCharacter, List<String>>();
        StringBuilder escapeDescription = new StringBuilder();
        if (allEnemiesStunned) {
            this.escaped = true;
            escapeDescription.append("\u6240\u6709\u7684\u654c\u4eba\u90fd\u88ab\u9707\u6151\uff0c\u6240\u4ee5\u4f60\u8f7b\u677e\u8131\u8eab\u4e86\uff01");
        } else if ((float)Util.random.nextInt(100) < this.escapeChance) {
            this.escaped = true;
            escapeDescription.append("\u4f60\u987a\u5229\u8131\u8eab\u4e86\uff01");
        } else {
            escapeDescription.append("\u4f60\u6ca1\u80fd\u9003\u6389\uff01");
        }
        this.escapeDescriptionMap.put(escapee, Util.newArrayListOfValues(escapeDescription.toString()));
        for (GameCharacter combatant : this.getAllCombatants(true)) {
            if (this.getAllies(escapee).contains(combatant) || combatant.equals(escapee)) {
                int i = 0;
                for (Util.Value<GameCharacter, AbstractCombatMove> move : combatant.getSelectedMoves()) {
                    move.getValue().performOnDeselection(i, combatant, move.getKey(), new ArrayList<GameCharacter>(this.enemies), new ArrayList<GameCharacter>(this.allies));
                    combatant.setCooldown(move.getValue().getIdentifier(), 0);
                    ++i;
                }
                combatant.resetSelectedMoves();
                combatant.setRemainingAP(combatant.getMaxAP(), this.getEnemies(combatant), this.getAllies(combatant));
                this.predictionContent.put(combatant, new ArrayList());
                if (!this.escaped || combatant.equals(escapee)) continue;
                this.escapeDescriptionMap.put(combatant, Util.newArrayListOfValues(UtilText.parse(combatant, "[npc.Name]\u9003\u79bb\u4e86\uff01", new ParserTag[0])));
                continue;
            }
            if (!this.escaped) continue;
            this.escapeDescriptionMap.put(combatant, Util.newArrayListOfValues(UtilText.parse(combatant, "[npc.Name]\u8bd5\u56fe\u963b\u6b62\u4f60\u9003\u8dd1\uff0c\u4f46\u5931\u8d25\u4e86\uff01", new ParserTag[0])));
        }
        if (this.escaped) {
            for (GameCharacter combatant : this.getAllCombatants(true)) {
                if (!combatant.isElementalSummoned()) continue;
                combatant.getElemental().returnToHome();
                escapeDescription.append(UtilText.parse(combatant, combatant.getElemental(), "<p style='text-align:center;'><i>[npc.NamePos]\u7684\u5143\u7d20\u4f53<span style='colour:" + combatant.getElemental().getFemininity().getColour().toWebHexString() + ";'>[npc2.name]</span>\u8017\u5c3d\u4e86\u80fd\u91cf\uff0c\u4e8e\u662f[style.italicsArcane(\u53d8\u56de\u4e86\u88ab\u52a8\u5f62\u6001)]\uff01</i></p>", new ParserTag[0]));
            }
        }
    }

    private boolean attackCharacter(GameCharacter character) {
        if (this.escaped) {
            this.combatContent.put(character, this.escapeDescriptionMap.get(character));
            return false;
        }
        if (character.isPlayer()) {
            if (!this.activeCombatants.contains(character)) {
                this.combatContent.put(character, Util.newArrayListOfValues(UtilText.parse(character, "<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u88ab\u51fb\u8d25\u4e86\uff01</span>", new ParserTag[0])));
                return false;
            }
            if (this.attemptedEscape) {
                this.combatContent.put(character, Util.newArrayListOfValues(UtilText.parse(character, "<span style='color:" + PresetColour.GENERIC_MINOR_BAD.toWebHexString() + ";'>\u4f60\u6ca1\u80fd\u9003\u8dd1\uff01</span>", new ParserTag[0])));
                return false;
            }
        } else if (this.allies.contains(character)) {
            if (!this.activeCombatants.contains(character)) {
                this.combatContent.put(character, Util.newArrayListOfValues(UtilText.parse(character, "<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u88ab\u51fb\u8d25\u4e86\uff01</span>", new ParserTag[0])));
                return false;
            }
            if (this.attemptedEscape) {
                this.combatContent.put(character, Util.newArrayListOfValues(UtilText.parse(character, "<span style='color:" + PresetColour.GENERIC_MINOR_BAD.toWebHexString() + ";'>[npc.Name]\u6ca1\u80fd\u548c\u4f60\u9003\u8dd1\uff01</span>", new ParserTag[0])));
                return false;
            }
        } else if (!this.activeCombatants.contains(character)) {
            this.combatContent.put(character, Util.newArrayListOfValues(UtilText.parse(character, "<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u88ab\u51fb\u8d25\u4e86\uff01</span>", new ParserTag[0])));
            return false;
        }
        if (character.isStunned()) {
            this.combatContent.put(character, Util.newArrayListOfValues(UtilText.parse(character, "[npc.NameIsFull]\u88ab\u7729\u6655\u4e86\uff0c\u65e0\u6cd5\u505a\u51fa\u52a8\u4f5c\uff01", new ParserTag[0])));
            character.resetSelectedMoves();
            return false;
        }
        return true;
    }

    private void applyNewTurnShielding(GameCharacter character) {
        DamageType[] damageTypes;
        character.resetShields();
        int bonusEnergyShielding = Math.round(character.getAttributeValue(Attribute.ENERGY_SHIELDING));
        character.incrementShields(DamageType.HEALTH, bonusEnergyShielding);
        for (DamageType dt : damageTypes = new DamageType[]{DamageType.PHYSICAL, DamageType.FIRE, DamageType.ICE, DamageType.POISON}) {
            character.incrementShields(dt, Math.round(character.getAttributeValue(dt.getResistAttribute())));
        }
        character.incrementShields(DamageType.LUST, Math.round(character.getAttributeValue(DamageType.LUST.getResistAttribute())));
    }

    /*
     * WARNING - void declaration
     */
    public void endCombatTurn() {
        this.combatTurnResolutionStringBuilder.setLength(0);
        List<GameCharacter> combatants = this.getAllCombatants(true);
        CombatMoveType[] order = new CombatMoveType[]{CombatMoveType.DEFEND, CombatMoveType.SPELL, CombatMoveType.ATTACK};
        for (GameCharacter gameCharacter : this.getAllCombatants(true)) {
            this.combatContent.put(gameCharacter, new ArrayList());
        }
        for (int i = 0; i < order.length; ++i) {
            for (GameCharacter character : combatants) {
                if (!this.attackCharacter(character)) continue;
                List<GameCharacter> list = this.getAllies(character);
                List<GameCharacter> list2 = this.getEnemies(character);
                character.performMoves(order[i], this.combatContent.get(character), list2, list);
            }
            if (i != 2) continue;
            for (GameCharacter character : combatants) {
                for (Map.Entry<AbstractStatusEffect, Integer> entry : this.statusEffectsToApply.get(character).entrySet()) {
                    character.addStatusEffect(entry.getKey(), entry.getValue() + 1);
                }
                this.statusEffectsToApply.put(character, new HashMap());
            }
        }
        for (GameCharacter gameCharacter : combatants) {
            void var6_23;
            int count;
            AbstractWeapon weapon;
            int n;
            StringBuilder thrownWeaponsRecoveredDescriptions = new StringBuilder();
            boolean bl = false;
            while (n < Math.min(gameCharacter.getArmRows(), gameCharacter.getMainWeaponArray().length)) {
                for (Map.Entry<AbstractWeapon, Integer> entry : this.weaponsThrownDuringTurn.get(gameCharacter).get((Object)InventorySlot.mainWeaponSlots[n]).entrySet()) {
                    weapon = entry.getKey();
                    for (count = 0; count < entry.getValue(); ++count) {
                        if (!(Math.random() * 100.0 <= (double)weapon.getWeaponType().getOneShotChanceToRecoverAfterTurn())) continue;
                        if (gameCharacter.getMainWeapon(n) == null) {
                            gameCharacter.equipMainWeapon(weapon, n, false);
                        } else {
                            gameCharacter.addWeapon(weapon, 1, false, false);
                        }
                        this.incrementWeaponsThrownDuringCombat(gameCharacter, InventorySlot.mainWeaponSlots[n], weapon, -1);
                        if (thrownWeaponsRecoveredDescriptions.length() == 0) {
                            thrownWeaponsRecoveredDescriptions.append("[style.boldGood(\u5355\u53d1\u6b66\u5668\u88c5\u586b\uff1a)]");
                        }
                        thrownWeaponsRecoveredDescriptions.append("<br/>");
                        thrownWeaponsRecoveredDescriptions.append(weapon.getWeaponType().getOneShotEndTurnRecoveryDescription(gameCharacter).trim());
                    }
                }
                ++n;
            }
            n = 0;
            while (var6_23 < Math.min(gameCharacter.getArmRows(), gameCharacter.getOffhandWeaponArray().length)) {
                for (Map.Entry<AbstractWeapon, Integer> entry : this.weaponsThrownDuringTurn.get(gameCharacter).get((Object)InventorySlot.offhandWeaponSlots[var6_23]).entrySet()) {
                    weapon = entry.getKey();
                    for (count = 0; count < entry.getValue(); ++count) {
                        if (!(Math.random() * 100.0 <= (double)weapon.getWeaponType().getOneShotChanceToRecoverAfterTurn())) continue;
                        if (gameCharacter.getOffhandWeapon((int)var6_23) == null) {
                            gameCharacter.equipOffhandWeapon(weapon, (int)var6_23, false);
                        } else {
                            gameCharacter.addWeapon(weapon, 1, false, false);
                        }
                        this.incrementWeaponsThrownDuringCombat(gameCharacter, InventorySlot.offhandWeaponSlots[var6_23], weapon, -1);
                        if (thrownWeaponsRecoveredDescriptions.length() == 0) {
                            thrownWeaponsRecoveredDescriptions.append("[style.boldGood(\u5355\u53d1\u6b66\u5668\u88c5\u586b\uff1a)]");
                        }
                        thrownWeaponsRecoveredDescriptions.append("<br/>");
                        thrownWeaponsRecoveredDescriptions.append(weapon.getWeaponType().getOneShotEndTurnRecoveryDescription(gameCharacter).trim());
                    }
                }
                ++var6_23;
            }
            this.resetWeaponsThrownDuringTurn(gameCharacter);
            this.combatContent.get(gameCharacter).add(thrownWeaponsRecoveredDescriptions.toString());
            this.combatTurnResolutionStringBuilder.append(this.getCharactersTurnDiv(gameCharacter, this.getTurn() == 0 ? "\u51c6\u5907" : "", this.combatContent.get(gameCharacter)));
            gameCharacter.resetSelectedMoves();
        }
        this.attemptedEscape = false;
        for (GameCharacter gameCharacter : combatants) {
            for (Map.Entry entry : this.statusEffectsToApply.get(gameCharacter).entrySet()) {
                gameCharacter.addStatusEffect((AbstractStatusEffect)entry.getKey(), (Integer)entry.getValue());
            }
            this.statusEffectsToApply.put(gameCharacter, new HashMap());
            List<GameCharacter> npcAllies = this.getAllies(gameCharacter);
            List<GameCharacter> list = this.getEnemies(gameCharacter);
            this.applyNewTurnShielding(gameCharacter);
            gameCharacter.lowerMoveCooldowns();
            gameCharacter.setRemainingAP(gameCharacter.getMaxAP(), list, npcAllies);
            if (this.isCombatantDefeated(gameCharacter)) {
                if (this.activeCombatants.remove(gameCharacter)) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    boolean playerVampyre = false;
                    float manaAbsorbed = Math.round(gameCharacter.getMana() / 2.0f);
                    for (GameCharacter c2 : combatants) {
                        if (this.isCombatantDefeated(c2) || !c2.hasTraitActivated(Perk.ARCANE_VAMPYRISM)) continue;
                        if (c2.isPlayer()) {
                            arrayList.add(0, UtilText.parse(c2, "[npc.name]", new ParserTag[0]));
                            playerVampyre = true;
                        } else {
                            arrayList.add(UtilText.parse(c2, "[npc.name]", new ParserTag[0]));
                        }
                        c2.incrementMana(manaAbsorbed);
                    }
                    if (!arrayList.isEmpty()) {
                        gameCharacter.setMana(manaAbsorbed);
                        this.predictionContent.put(gameCharacter, Util.newArrayListOfValues(UtilText.parse(gameCharacter, "[style.boldArcane(" + Util.capitaliseSentence(Perk.ARCANE_VAMPYRISM.getName(Main.game.getPlayer())) + ":)]<br/>" + Util.capitaliseSentence(Util.stringsToStringList(arrayList, false)) + "\u5438\u6536\u4e86[npc.namePos]\u5269\u4f59\u7075\u6c14\u7684\u4e00\u534a\uff0c" + (this.enemies.contains(gameCharacter) ? "[style.colourGood(" : "[style.colourBad(") + "\u83b7\u5f97\u4e86 " + manaAbsorbed + "\u7075\u6c14)]\uff01", new ParserTag[0])));
                        continue;
                    }
                    this.predictionContent.put(gameCharacter, Util.newArrayListOfValues("<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u6218\u8d25\u2026\u2026</span>"));
                    continue;
                }
                this.predictionContent.put(gameCharacter, Util.newArrayListOfValues("<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u6218\u8d25\u2026\u2026</span>"));
                continue;
            }
            if (gameCharacter.isStunned()) {
                this.predictionContent.put(gameCharacter, Util.newArrayListOfValues("<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u7729\u6655\uff01</span>"));
                continue;
            }
            if (gameCharacter.isPlayer()) {
                this.predictionContent.put(gameCharacter, new ArrayList());
                continue;
            }
            npcAllies.removeIf(c -> this.isCombatantDefeated((GameCharacter)c));
            list.removeIf(c -> this.isCombatantDefeated((GameCharacter)c));
            gameCharacter.selectMoves(list, npcAllies);
            this.predictionContent.put(gameCharacter, gameCharacter.getMovesPredictionString(list, npcAllies));
        }
        if (this.isCombatantDefeated(this.targetedEnemy)) {
            for (NPC nPC : this.enemies) {
                if (this.isCombatantDefeated(nPC)) continue;
                this.targetedEnemy = nPC;
                break;
            }
        }
        if (this.isCombatantDefeated(this.targetedAlly)) {
            this.targetedAlly = Main.game.getPlayer();
        }
        ++this.turn;
    }

    private String getShieldsDisplayValue(AbstractAttribute att, int shields) {
        String valueForDisplay = String.valueOf(shields);
        if (att.isInfiniteAtUpperLimit() && shields >= att.getUpperLimit()) {
            valueForDisplay = UtilText.getInfinitySymbol(false);
        }
        return valueForDisplay;
    }

    private String getTitleResources(GameCharacter character) {
        DamageType[] damageTypes;
        int apRemaining = character.getRemainingAP();
        StringBuilder sb = new StringBuilder();
        sb.append("<b>(<span style='color:" + (apRemaining == 0 ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_BAD).toWebHexString() + ";'>" + apRemaining + "</span>/" + character.getMaxAP() + " AP)</b>");
        sb.append("<div class='container-full-width' style='text-align:center;'>");
        boolean shieldsFound = false;
        int shields = character.getShields(DamageType.HEALTH);
        if (shields != 0) {
            shieldsFound = true;
            sb.append("<div style='display:inline-block; float:none; margin:auto; padding:0 2px; background-color:" + PresetColour.BACKGROUND.toWebHexString() + "; border-radius:5px; width:auto; position:relative;'><span style='color:" + DamageType.HEALTH.getColour().toWebHexString() + ";'>" + UtilText.getShieldSymbol() + "</span> " + (String)(shields < 0 ? "[style.colourDisabled(" + shields + ")]" : this.getShieldsDisplayValue(Attribute.ENERGY_SHIELDING, shields)) + "<div class='overlay' id='" + character.getId() + "_COMBAT_SHIELD_" + String.valueOf((Object)DamageType.HEALTH) + "' style='cursor:default;'></div></div>");
        }
        for (DamageType dt : damageTypes = new DamageType[]{DamageType.PHYSICAL, DamageType.FIRE, DamageType.ICE, DamageType.POISON}) {
            shields = character.getShields(dt);
            if (shields == 0) continue;
            if (shieldsFound) {
                sb.append(" | ");
            }
            shieldsFound = true;
            sb.append("<div style='display:inline-block; float:none; margin:auto; padding:0 2px; background-color:" + PresetColour.BACKGROUND.toWebHexString() + "; border-radius:5px; width:auto; position:relative;'><span style='color:" + dt.getColour().toWebHexString() + ";'>" + UtilText.getShieldSymbol() + "</span> " + (String)(shields < 0 ? "[style.colourDisabled(" + shields + ")]" : this.getShieldsDisplayValue(dt.getResistAttribute(), shields)) + "<div class='overlay' id='" + character.getId() + "_COMBAT_SHIELD_" + String.valueOf((Object)dt) + "' style='cursor:default;'></div></div>");
        }
        shields = character.getShields(DamageType.LUST);
        if (shields != 0) {
            if (shieldsFound) {
                sb.append(" | ");
            }
            shieldsFound = true;
            sb.append("<div style='display:inline-block; float:none; margin:auto; padding:0 2px; background-color:" + PresetColour.BACKGROUND.toWebHexString() + "; border-radius:5px; width:auto; position:relative;'><span style='color:" + DamageType.LUST.getColour().toWebHexString() + ";'>" + UtilText.getShieldSymbol() + "</span> " + (String)(shields < 0 ? "[style.colourDisabled(" + shields + ")]" : this.getShieldsDisplayValue(DamageType.LUST.getResistAttribute(), shields)) + "<div class='overlay' id='" + character.getId() + "_COMBAT_SHIELD_" + String.valueOf((Object)DamageType.LUST) + "' style='cursor:default;'></div></div>");
        }
        sb.append("</div>");
        return sb.toString();
    }

    private String getCombatContent() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='container-full-width' style='text-align:center; box-sizing: border-box; border:6px solid " + PresetColour.BASE_WHITE.toWebHexString() + "; border-radius:5px;'>");
        sb.append("<div class='container-full-width' style='margin:2px; padding:4px; width:100%; border-radius:5px; text-align:center;'><b>\u8ba1\u5212</b></div>");
        sb.append("<div class='container-half-width'>");
        sb.append("[style.boldGood(\u4f60)]" + this.getTitleResources(Main.game.getPlayer()));
        if (this.predictionContent.get(Main.game.getPlayer()).isEmpty()) {
            sb.append("<div class='container-half-width' style='margin:2px; padding:4px; width:100%; border-radius:5px; background:" + PresetColour.BACKGROUND.toWebHexString() + ";'>[style.colourDisabled(\u6ca1\u6709\u9009\u5b9a\u884c\u52a8\u2026\u2026)]</div>");
        } else {
            for (String s : this.predictionContent.get(Main.game.getPlayer())) {
                sb.append("<div class='container-half-width' style='margin:2px; padding:4px; width:100%; border-radius:5px; background:" + PresetColour.BACKGROUND.toWebHexString() + ";'>" + s + "</div>");
            }
        }
        sb.append("</br>");
        for (GameCharacter ally : this.getAllies(Main.game.getPlayer())) {
            sb.append(UtilText.parse(ally, "</br>[style.boldMinorGood([npc.Name])]", new ParserTag[0]) + this.getTitleResources(ally));
            for (String s : this.predictionContent.get(ally)) {
                sb.append("<div class='container-half-width' style='margin:2px; padding:4px; width:100%; border-radius:5px; background:" + PresetColour.BACKGROUND.toWebHexString() + ";'>" + s + "</div>");
            }
            sb.append("</br>");
        }
        sb.append("</div>");
        sb.append("<div class='container-half-width'>");
        Iterator<Object> iterator = this.getEnemies(Main.game.getPlayer()).iterator();
        while (iterator.hasNext()) {
            GameCharacter enemy;
            sb.append(UtilText.parse(enemy, this.enemyLeader.equals(enemy = (GameCharacter)iterator.next()) ? "[style.boldBad([npc.Name])]" : "</br>[style.boldMinorBad([npc.Name])]", new ParserTag[0]) + this.getTitleResources(enemy));
            for (String s : this.predictionContent.get(enemy)) {
                sb.append("<div class='container-half-width' style='margin:2px; padding:4px; width:100%; border-radius:5px; background:" + PresetColour.BACKGROUND.toWebHexString() + ";'>" + s + "</div>");
            }
            sb.append("</br>");
        }
        sb.append("</div>");
        sb.append("</div>");
        sb.append(this.combatTurnResolutionStringBuilder.toString());
        return sb.toString();
    }

    private String applyEffects(GameCharacter character) {
        this.endTurnStatusEffectText = new StringBuilder();
        ArrayList<AbstractStatusEffect> effectsToRemove = new ArrayList<AbstractStatusEffect>();
        for (AppliedStatusEffect appliedSe : character.getAppliedStatusEffects()) {
            AbstractStatusEffect se = appliedSe.getEffect();
            if (!se.isCombatEffect()) continue;
            appliedSe.setSecondsPassed(this.turn);
            StringBuilder s = new StringBuilder();
            if (appliedSe.getEffect().getEffectInterval() <= 0 || (long)this.turn - appliedSe.getLastTimeAppliedEffect() > (long)appliedSe.getEffect().getEffectInterval()) {
                if (appliedSe.getEffect().getEffectInterval() <= 0) {
                    s.append(se.applyEffect(character, 1, appliedSe.getSecondsPassed()));
                } else {
                    int i = 0;
                    while ((long)i < (Main.game.getSecondsPassed() - appliedSe.getLastTimeAppliedEffect()) / (long)appliedSe.getEffect().getEffectInterval()) {
                        if (s.length() > 0) {
                            s.append("<br/>");
                        }
                        s.append(se.applyEffect(character, 1, appliedSe.getSecondsPassed()));
                        ++i;
                    }
                }
                appliedSe.setLastTimeAppliedEffect(Main.game.getSecondsPassed());
                if (s.length() != 0) {
                    this.endTurnStatusEffectText.append("<p><b style='color: " + se.getColour().toWebHexString() + "'>" + Util.capitaliseSentence(se.getName(character)) + ":</b>" + s.toString() + "</p>");
                }
            }
            if (character.getStatusEffectDuration(se) >= 0) {
                character.setCombatStatusEffectDuration(se, character.getStatusEffectDuration(se) - 1);
            }
            if (character.getStatusEffectDuration(se) != 0) continue;
            effectsToRemove.add(se);
        }
        for (AbstractStatusEffect se : effectsToRemove) {
            this.endTurnStatusEffectText.append(character.removeStatusEffectCombat(se));
        }
        return this.endTurnStatusEffectText.toString();
    }

    private String getCombatLabel() {
        if (this.turn == 0) {
            return "\u6218\u6597\uff1a\u5f00\u59cb";
        }
        return "\u6218\u6597\uff1a\u7b2c" + this.turn + "\u56de\u5408";
    }

    public GameCharacter getTargetedCombatant() {
        return this.targetedEnemy;
    }

    public GameCharacter getTargetedAlliedCombatant() {
        return this.targetedAlly;
    }

    public void setTargetedCombatant(GameCharacter targetedCombatant) {
        if (this.getEnemies(Main.game.getPlayer()).contains(targetedCombatant)) {
            this.targetedEnemy = targetedCombatant;
        } else {
            this.targetedAlly = targetedCombatant;
        }
    }

    public NPC getActiveNPC() {
        return this.activeNPC;
    }

    public void setActiveNPC(NPC activeNPC) {
        this.activeNPC = activeNPC;
    }

    public void resetItemsToBeUsed(GameCharacter character) {
        this.itemsToBeUsed.put(character, new ArrayList());
    }

    public List<Util.Value<GameCharacter, AbstractItem>> getItemsToBeUsed(GameCharacter user) {
        return this.itemsToBeUsed.get(user);
    }

    public void addItemToBeUsed(GameCharacter user, GameCharacter target, AbstractItem item) {
        this.itemsToBeUsed.get(user).add(new Util.Value<GameCharacter, AbstractItem>(target, item));
        this.predictionContent.get(Main.game.getPlayer()).add(CombatMove.ITEM_USAGE.getPrediction(user.getSelectedMoves().size(), user, target, this.getEnemies(user), this.getAllies(user)));
        Main.game.getPlayer().selectMove(user.getSelectedMoves().size(), CombatMove.ITEM_USAGE, target, this.getEnemies(user), this.getAllies(user));
    }

    public void resetWeaponsThrownDuringTurn(GameCharacter character) {
        this.weaponsThrownDuringTurn.put(character, new HashMap());
        for (InventorySlot slot : InventorySlot.allWeaponSlots) {
            this.weaponsThrownDuringTurn.get(character).put(slot, new HashMap());
        }
    }

    public Map<AbstractWeapon, Integer> getWeaponsThrownDuringTurn(GameCharacter user, InventorySlot slot) {
        return this.weaponsThrownDuringTurn.get(user).get((Object)slot);
    }

    public void incrementWeaponsThrownDuringTurn(GameCharacter user, InventorySlot slot, AbstractWeapon weapon, int increment) {
        this.weaponsThrownDuringTurn.get(user).get((Object)slot).putIfAbsent(weapon, 0);
        this.weaponsThrownDuringTurn.get(user).get((Object)slot).put(weapon, this.weaponsThrownDuringTurn.get(user).get((Object)slot).get(weapon) + increment);
    }

    public void resetWeaponsThrownDuringCombat(GameCharacter character) {
        this.weaponsThrownDuringCombat.put(character, new HashMap());
        for (InventorySlot slot : InventorySlot.allWeaponSlots) {
            this.weaponsThrownDuringCombat.get(character).put(slot, new HashMap());
        }
    }

    public Map<AbstractWeapon, Integer> getWeaponsThrownDuringCombat(GameCharacter user, InventorySlot slot) {
        return this.weaponsThrownDuringCombat.get(user).get((Object)slot);
    }

    public void incrementWeaponsThrownDuringCombat(GameCharacter user, InventorySlot slot, AbstractWeapon weapon, int increment) {
        this.weaponsThrownDuringCombat.get(user).get((Object)slot).putIfAbsent(weapon, 0);
        this.weaponsThrownDuringCombat.get(user).get((Object)slot).put(weapon, this.weaponsThrownDuringCombat.get(user).get((Object)slot).get(weapon) + increment);
    }

    public void resetThrownWeaponsDepleted(GameCharacter character) {
        this.thrownWeaponsDepleted.put(character, new HashMap());
        for (InventorySlot slot : InventorySlot.allWeaponSlots) {
            this.thrownWeaponsDepleted.get(character).put(slot, null);
        }
    }

    public AbstractWeaponType getThrownWeaponsDepleted(GameCharacter user, InventorySlot slot) {
        return this.thrownWeaponsDepleted.get(user).get((Object)slot);
    }

    public void addThrownWeaponsDepleted(GameCharacter user, InventorySlot slot, AbstractWeaponType weapon) {
        this.thrownWeaponsDepleted.get(user).put(slot, weapon);
    }

    public void removeThrownWeaponsDepleted(GameCharacter user, InventorySlot slot) {
        this.thrownWeaponsDepleted.get(user).put(slot, null);
    }

    public String getPregnancyProtectionText(GameCharacter character) {
        return character.isVisiblyPregnant() ? UtilText.parse(character, "\u4e00\u80a1\u5f3a\u5927\u7684\u5965\u672f\u80fd\u91cf\u573a\u4fdd\u62a4\u4e86[npc.namePos]\u7684\u5b55\u809a\uff0c\u4fdd\u8bc1\u5176\u672a\u964d\u751f\u7684\u540e\u4ee3\u4e0d\u53d7\u4efb\u4f55\u635f\u5bb3\u3002", new ParserTag[0]) : "";
    }

    public List<GameCharacter> getAllCombatants(boolean includePlayer) {
        ArrayList<GameCharacter> returnList = new ArrayList<GameCharacter>(this.allCombatants);
        if (includePlayer) {
            returnList.add(Main.game.getPlayer());
        }
        return returnList;
    }

    public void addAlly(NPC ally) {
        if (!this.allies.contains(ally)) {
            this.allies.add(ally);
            this.allCombatants.add(ally);
            ally.resetMoveCooldowns();
            this.predictionContent.put(ally, new ArrayList());
            this.itemsToBeUsed.put(ally, new ArrayList());
            this.manaBurnStack.put(ally, new Stack());
            this.statusEffectsToApply.put(ally, new HashMap());
            this.combatContent.put(ally, new ArrayList());
            this.activeCombatants.add(ally);
            this.resetWeaponsThrownDuringTurn(ally);
            this.resetWeaponsThrownDuringCombat(ally);
            this.resetThrownWeaponsDepleted(ally);
            if (Main.game.isInCombat()) {
                List<GameCharacter> npcAllies = this.getAllies(ally);
                List<GameCharacter> npcEnemies = this.getEnemies(ally);
                this.applyNewTurnShielding(ally);
                ally.setRemainingAP(ally.getMaxAP(), npcEnemies, npcAllies);
                npcAllies.removeIf(c -> this.isCombatantDefeated((GameCharacter)c));
                npcEnemies.removeIf(c -> this.isCombatantDefeated((GameCharacter)c));
                ally.selectMoves(npcEnemies, npcAllies);
                this.predictionContent.put(ally, ally.getMovesPredictionString(npcEnemies, npcAllies));
            }
        }
    }

    public void addEnemy(NPC enemy) {
        if (!this.enemies.contains(enemy)) {
            this.enemies.add(enemy);
            this.allCombatants.add(enemy);
            enemy.resetMoveCooldowns();
            enemy.setFoughtPlayerCount(enemy.getFoughtPlayerCount() + 1);
            this.predictionContent.put(enemy, new ArrayList());
            this.itemsToBeUsed.put(enemy, new ArrayList());
            this.manaBurnStack.put(enemy, new Stack());
            this.statusEffectsToApply.put(enemy, new HashMap());
            this.combatContent.put(enemy, new ArrayList());
            this.activeCombatants.add(enemy);
            this.resetWeaponsThrownDuringTurn(enemy);
            this.resetWeaponsThrownDuringCombat(enemy);
            this.resetThrownWeaponsDepleted(enemy);
            if (Main.game.isInCombat()) {
                List<GameCharacter> npcAllies = this.getAllies(enemy);
                List<GameCharacter> npcEnemies = this.getEnemies(enemy);
                this.applyNewTurnShielding(enemy);
                enemy.setRemainingAP(enemy.getMaxAP(), npcEnemies, npcAllies);
                npcAllies.removeIf(c -> this.isCombatantDefeated((GameCharacter)c));
                npcEnemies.removeIf(c -> this.isCombatantDefeated((GameCharacter)c));
                enemy.selectMoves(npcEnemies, npcAllies);
                this.predictionContent.put(enemy, enemy.getMovesPredictionString(npcEnemies, npcAllies));
            }
        }
    }

    public List<GameCharacter> getAllies(GameCharacter combatant) {
        ArrayList<GameCharacter> returnList = new ArrayList<GameCharacter>();
        if (combatant.isPlayer()) {
            returnList.addAll(this.allies);
        } else if (this.allies.contains(combatant)) {
            returnList.add(Main.game.getPlayer());
            returnList.addAll(this.allies);
        } else {
            returnList.addAll(this.enemies);
        }
        returnList.remove(combatant);
        return returnList;
    }

    public List<GameCharacter> getEnemies(GameCharacter combatant) {
        ArrayList<GameCharacter> returnList = new ArrayList<GameCharacter>();
        if (combatant.isPlayer()) {
            returnList.addAll(this.enemies);
        } else if (this.allies.contains(combatant)) {
            returnList.addAll(this.enemies);
        } else {
            returnList.add(Main.game.getPlayer());
            returnList.addAll(this.allies);
        }
        return returnList;
    }

    public GameCharacter getRandomAlliedPartyMember(GameCharacter target) {
        ArrayList<GameCharacter> possibleTargets = new ArrayList<GameCharacter>();
        for (GameCharacter character : this.getAllies(target)) {
            possibleTargets.add(character);
        }
        if (possibleTargets.size() == 0) {
            return target;
        }
        return (GameCharacter)possibleTargets.get(Util.random.nextInt(possibleTargets.size()));
    }

    public int getTurn() {
        return this.turn;
    }

    public float getTotalDamageTaken(GameCharacter character) {
        this.totalDamageTaken.putIfAbsent(character, Float.valueOf(0.0f));
        return this.totalDamageTaken.get(character).floatValue();
    }

    public void setTotalDamageTaken(GameCharacter character, float damage) {
        this.totalDamageTaken.put(character, Float.valueOf(damage));
    }

    public void incrementTotalDamageTaken(GameCharacter character, float increment) {
        this.setTotalDamageTaken(character, this.getTotalDamageTaken(character) + increment);
    }

    public boolean isCharacterVictory(GameCharacter character) {
        if (this.getEnemies(character).contains(Main.game.getPlayer())) {
            return !this.playerVictory;
        }
        return this.playerVictory;
    }

    public boolean isPlayerVictory() {
        return this.playerVictory;
    }

    public void setupManaBurnStackForOutOfCombat(GameCharacter character) {
        this.manaBurnStack = new HashMap<GameCharacter, Stack<Float>>();
        this.manaBurnStack.put(character, new Stack());
    }

    public Map<GameCharacter, Stack<Float>> getManaBurnStack() {
        return this.manaBurnStack;
    }

    public void setPreferredTarget(GameCharacter character, GameCharacter target) {
        if (target == null) {
            this.preferredTargets.remove(character);
        } else {
            this.preferredTargets.put(character, target);
        }
    }

    public GameCharacter getPreferredTarget(GameCharacter character) {
        if (!this.preferredTargets.containsKey(character) || this.isCombatantDefeated(this.preferredTargets.get(character))) {
            return null;
        }
        return this.preferredTargets.get(character);
    }

    public void addStatusEffectToApply(GameCharacter target, AbstractStatusEffect effect, int duration) {
        this.statusEffectsToApply.get(target).put(effect, duration);
    }

    public Map<GameCharacter, Map<AbstractStatusEffect, Integer>> getStatusEffectsToApply() {
        return this.statusEffectsToApply;
    }

    public DialogueNode getPlayerPostVictoryDialogue() {
        return this.playerPostVictoryDialogue;
    }

    public void setPlayerPostVictoryDialogue(DialogueNode playerPostVictoryDialogue) {
        this.playerPostVictoryDialogue = playerPostVictoryDialogue;
    }

    public DialogueNode getPlayerPostDefeatDialogue() {
        return this.playerPostDefeatDialogue;
    }

    public void setPlayerPostDefeatDialogue(DialogueNode playerPostDefeatDialogue) {
        this.playerPostDefeatDialogue = playerPostDefeatDialogue;
    }

    public boolean isSubmitBlocked() {
        return this.submitBlocked;
    }
}

