/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.combat.moves;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.moves.AbstractCombatMove;
import com.lilithsthrone.game.combat.moves.CombatMoveCategory;
import com.lilithsthrone.game.combat.moves.CombatMoveType;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.List;
import java.util.Map;

public class CMWeaponSpecials {
    public static AbstractCombatMove MKAR_MAG_DUMP = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u6e05\u7a7a\u5f39\u5323", 2, 2, CombatMoveType.ATTACK, DamageType.PHYSICAL, "moves/mag_dump", Util.newArrayListOfValues(PresetColour.BASE_ORANGE), false, true, false, null){

        private int getBulletDamage() {
            return 21000;
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(source.hasWeaponEquipped(WeaponType.getWeaponTypeFromId("innoxia_gun_mkar")), "\u4ec5\u9002\u7528\u4e8e\u88c5\u5907\u4e86MKAR\u7684\u89d2\u8272\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, "\u5168\u81ea\u52a8\u6e05\u7a7a\u6574\u4e2a30\u53d1\u5f39\u5323\uff0c\u6bcf\u4e00\u53d1\u547d\u4e2d\u7684\u5b50\u5f39\u9020\u6210" + 1.getFormattedDamage(damageType, this.getBulletDamage(), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u3002<br/>[style.italicsGood(\u76ee\u6807\u4e3a\u6240\u6709\u654c\u4eba\uff01)]", new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, "[npc.Name]\u53ef\u4ee5\u8f6c\u4e3a\u5168\u81ea\u52a8\uff0c\u5bf9\u654c\u4eba\u6e05\u7a7a\u6574\u4e2a30\u53d1\u5f39\u5323\uff0c\u6bcf\u4e00\u53d1\u547d\u4e2d\u7684\u5b50\u5f39\u9020\u6210" + 1.getFormattedDamage(damageType, this.getBulletDamage(), null, false, false) + "\u4f24\u5bb3\u3002<br/>[style.italicsGood(\u76ee\u6807\u4e3a\u6240\u6709\u654c\u4eba\uff01)]", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            StringBuilder attackDesc = new StringBuilder();
            StringBuilder attackEffects = new StringBuilder();
            int bulletsHit = 25 - Util.random.nextInt(6);
            int bulletsPerEnemy = bulletsHit / enemies.size();
            String weaponName = "";
            for (AbstractWeapon weapon : source.getMainWeaponArray()) {
                if (!weapon.getCombatMoves().contains(this)) continue;
                weaponName = weapon.getName();
                break;
            }
            if (weaponName.isEmpty()) {
                for (AbstractWeapon weapon : source.getOffhandWeaponArray()) {
                    if (!weapon.getCombatMoves().contains(this)) continue;
                    weaponName = weapon.getName();
                    break;
                }
            }
            if (weaponName.isEmpty()) {
                weaponName = "\u6b65\u67aa";
            }
            attackDesc.append(UtilText.parse(source, "[npc.Name]\u5c06" + weaponName + "\u7684\u9009\u62e9\u63a3\u63a8\u81f3\u5168\u81ea\u52a8\u4f4d\uff0c\u7784\u51c6\u540e\u6263\u52a8\u4e86\u6273\u673a\uff0c\u91ca\u653e\u51fa\u9707\u8033\u6b32\u804b\u7684\u67aa\u6797\u5f39\u96e8\uff0c\u5411\u7740" + (enemies.size() == 1 ? UtilText.parse(target, "[npc.name]", new ParserTag[0]) : "[npc.her]\u7684\u654c\u4eba") + "\u800c\u53bb\uff01", new ParserTag[0]));
            for (int i = 0; i < enemies.size(); ++i) {
                GameCharacter enemy = enemies.get(i);
                int finalBullets = Math.max(1, bulletsPerEnemy - Util.random.nextInt(3));
                boolean maxLust = this.isTargetAtMaximumLust(target);
                Util.Value<String, Integer> damageValue = damageType.damageTarget(source, enemy, this.getBulletDamage() * finalBullets);
                attackDesc.append(UtilText.parse(enemy, "<br/>[npc.NameIsFull]\u88ab[style.boldTerrible(" + finalBullets + ")]\u53d1\u5b50\u5f39\u547d\u4e2d\uff01" + damageValue.getKey(), new ParserTag[0]));
                if (i > 0) {
                    attackEffects.append("<br/>");
                }
                attackEffects.append(UtilText.parse(enemy, "[npc.Name]\u53d7\u5230\u4e86" + 1.getFormattedDamage(damageType, damageValue.getValue(), enemy, true, maxLust) + "\u4f24\u5bb3\uff01", new ParserTag[0]));
            }
            return 1.formatAttackOutcome(source, target, attackDesc.toString(), attackEffects.toString(), null, null);
        }
    };
    public static AbstractCombatMove BR14_MAG_DUMP = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u6e05\u7a7a\u5f39\u5323", 2, 2, CombatMoveType.ATTACK, DamageType.PHYSICAL, "moves/mag_dump", Util.newArrayListOfValues(PresetColour.BASE_ORANGE), false, true, false, null){

        private int getBulletDamage() {
            return 26000;
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(source.hasWeaponEquipped(WeaponType.getWeaponTypeFromId("innoxia_gun_br14")), "\u4ec5\u9002\u7528\u4e8e\u88c5\u5907\u4e86BR14\u7684\u89d2\u8272\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, "\u5168\u81ea\u52a8\u6e05\u7a7a\u6574\u4e2a20\u53d1\u5f39\u5323\uff0c\u6bcf\u4e00\u53d1\u547d\u4e2d\u7684\u5b50\u5f39\u9020\u6210" + 2.getFormattedDamage(damageType, this.getBulletDamage(), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u3002<br/>[style.italicsGood(\u76ee\u6807\u4e3a\u6240\u6709\u654c\u4eba\uff01)]", new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, "[npc.Name]\u53ef\u4ee5\u8f6c\u4e3a\u5168\u81ea\u52a8\uff0c\u5bf9\u654c\u4eba\u6e05\u7a7a\u6574\u4e2a20\u53d1\u5f39\u5323\uff0c\u6bcf\u4e00\u53d1\u547d\u4e2d\u7684\u5b50\u5f39\u9020\u6210" + 2.getFormattedDamage(damageType, this.getBulletDamage(), null, false, false) + "\u4f24\u5bb3\u3002<br/>[style.italicsGood(\u76ee\u6807\u4e3a\u6240\u6709\u654c\u4eba\uff01)]", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            StringBuilder attackDesc = new StringBuilder();
            StringBuilder attackEffects = new StringBuilder();
            int bulletsHit = 15 - Util.random.nextInt(11);
            int bulletsPerEnemy = bulletsHit / enemies.size();
            String weaponName = "";
            for (AbstractWeapon weapon : source.getMainWeaponArray()) {
                if (!weapon.getCombatMoves().contains(this)) continue;
                weaponName = weapon.getName();
                break;
            }
            if (weaponName.isEmpty()) {
                for (AbstractWeapon weapon : source.getOffhandWeaponArray()) {
                    if (!weapon.getCombatMoves().contains(this)) continue;
                    weaponName = weapon.getName();
                    break;
                }
            }
            if (weaponName.isEmpty()) {
                weaponName = "\u6b65\u67aa";
            }
            attackDesc.append(UtilText.parse(source, "[npc.Name]\u5c06" + weaponName + "\u7684\u9009\u62e9\u63a3\u62e8\u5411\u5168\u81ea\u52a8\u4f4d\uff0c\u7784\u51c6\u540e\u6263\u52a8\u4e86\u6273\u673a\uff0c\u91ca\u653e\u51fa\u9707\u8033\u6b32\u804b\u7684\u67aa\u6797\u5f39\u96e8\uff0c\u5411\u7740" + (enemies.size() == 1 ? UtilText.parse(target, "[npc.name]", new ParserTag[0]) : "[npc.her]\u7684\u654c\u4eba") + "\u800c\u53bb\uff01", new ParserTag[0]));
            for (int i = 0; i < enemies.size(); ++i) {
                GameCharacter enemy = enemies.get(i);
                int finalBullets = Math.max(1, bulletsPerEnemy - Util.random.nextInt(3));
                boolean maxLust = this.isTargetAtMaximumLust(target);
                Util.Value<String, Integer> damageValue = damageType.damageTarget(source, enemy, this.getBulletDamage() * finalBullets);
                attackDesc.append(UtilText.parse(enemy, "<br/>[npc.NameIsFull]\u88ab[style.boldTerrible(" + finalBullets + ")]\u53d1\u5b50\u5f39\u547d\u4e2d\uff01" + damageValue.getKey(), new ParserTag[0]));
                if (i > 0) {
                    attackEffects.append("<br/>");
                }
                attackEffects.append(UtilText.parse(enemy, "[npc.Name]\u53d7\u5230\u4e86" + 2.getFormattedDamage(damageType, damageValue.getValue(), enemy, true, maxLust) + "\u4f24\u5bb3\uff01", new ParserTag[0]));
            }
            return 2.formatAttackOutcome(source, target, attackDesc.toString(), attackEffects.toString(), null, null);
        }
    };
    public static AbstractCombatMove FAUXMAS_MAG_DUMP = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u6e05\u7a7a\u5f39\u5323", 2, 2, CombatMoveType.ATTACK, DamageType.PHYSICAL, "moves/mag_dump", Util.newArrayListOfValues(PresetColour.BASE_ORANGE), false, true, false, null){

        private int getBulletDamage() {
            return 18000;
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(source.hasWeaponEquipped(WeaponType.getWeaponTypeFromId("innoxia_gun_famase")), "\u4ec5\u9002\u7528\u4e8e\u88c5\u5907\u4e86\u6cd5\u683c\u739b\u65af\u7684\u89d2\u8272\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, "\u5168\u81ea\u52a8\u6e05\u7a7a\u6574\u4e2a25\u53d1\u5f39\u5323\uff0c\u6bcf\u4e00\u53d1\u547d\u4e2d\u7684\u5b50\u5f39\u9020\u6210" + 3.getFormattedDamage(damageType, this.getBulletDamage(), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u3002<br/>[style.italicsGood(\u76ee\u6807\u4e3a\u6240\u6709\u654c\u4eba\uff01)]", new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, "[npc.Name]\u53ef\u4ee5\u8f6c\u4e3a\u5168\u81ea\u52a8\uff0c\u5bf9\u654c\u4eba\u6e05\u7a7a\u6574\u4e2a25\u53d1\u5f39\u5323\uff0c\u6bcf\u4e00\u53d1\u547d\u4e2d\u7684\u5b50\u5f39\u9020\u6210" + 3.getFormattedDamage(damageType, this.getBulletDamage(), null, false, false) + "\u4f24\u5bb3\u3002<br/>[style.italicsGood(\u76ee\u6807\u4e3a\u6240\u6709\u654c\u4eba\uff01)]", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            StringBuilder attackDesc = new StringBuilder();
            StringBuilder attackEffects = new StringBuilder();
            int bulletsHit = 20 - Util.random.nextInt(6);
            int bulletsPerEnemy = bulletsHit / enemies.size();
            String weaponName = "";
            for (AbstractWeapon weapon : source.getMainWeaponArray()) {
                if (!weapon.getCombatMoves().contains(this)) continue;
                weaponName = weapon.getName();
                break;
            }
            if (weaponName.isEmpty()) {
                for (AbstractWeapon weapon : source.getOffhandWeaponArray()) {
                    if (!weapon.getCombatMoves().contains(this)) continue;
                    weaponName = weapon.getName();
                    break;
                }
            }
            if (weaponName.isEmpty()) {
                weaponName = "\u6b65\u67aa";
            }
            attackDesc.append(UtilText.parse(source, "[npc.Name]\u5c06" + weaponName + "\u7684\u9009\u62e9\u63a3\u63a8\u81f3\u5168\u81ea\u52a8\u4f4d\uff0c\u7784\u51c6\u540e\u6263\u52a8\u4e86\u6273\u673a\uff0c\u91ca\u653e\u51fa\u9707\u8033\u6b32\u804b\u7684\u67aa\u6797\u5f39\u96e8\uff0c\u5411\u7740" + (enemies.size() == 1 ? UtilText.parse(target, "[npc.name]", new ParserTag[0]) : "[npc.her]\u7684\u654c\u4eba") + "\uff01", new ParserTag[0]));
            for (int i = 0; i < enemies.size(); ++i) {
                GameCharacter enemy = enemies.get(i);
                int finalBullets = Math.max(1, bulletsPerEnemy - Util.random.nextInt(3));
                boolean maxLust = this.isTargetAtMaximumLust(target);
                Util.Value<String, Integer> damageValue = damageType.damageTarget(source, enemy, this.getBulletDamage() * finalBullets);
                attackDesc.append(UtilText.parse(enemy, "<br/>[npc.NameIsFull]\u88ab[style.boldTerrible(" + finalBullets + ")]\u53d1\u5b50\u5f39\u547d\u4e2d\uff01" + damageValue.getKey(), new ParserTag[0]));
                if (i > 0) {
                    attackEffects.append("<br/>");
                }
                attackEffects.append(UtilText.parse(enemy, "[npc.Name]\u53d7\u5230\u4e86" + 3.getFormattedDamage(damageType, damageValue.getValue(), enemy, true, maxLust) + "\u4f24\u5bb3\uff01", new ParserTag[0]));
            }
            return 3.formatAttackOutcome(source, target, attackDesc.toString(), attackEffects.toString(), null, null);
        }
    };
    public static AbstractCombatMove INKY_SUMMON = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u53ec\u5524\u58a8\u58a8", 100, 1, CombatMoveType.ATTACK, DamageType.LUST, "statusEffects/inky_summon", Util.newArrayListOfValues(PresetColour.BASE_PURPLE), false, true, false, (Map)Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.INKY_ATTACK, 6))){

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(source.hasWeaponEquipped(WeaponType.getWeaponTypeFromId("innoxia_pen_inky")), "\u4ec5\u9002\u7528\u4e8e\u88c5\u5907\u4e86\u201c\u58a8\u58a8\u7684\u94a2\u7b14\u201d\u7684\u89d2\u8272\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return UtilText.parse(source, target, "\u5bf9\u7740[npc2.name]\u91ca\u653e\u51fa\u58a8\u58a8\u3002\u8fd9\u53ea\u5c0f\u5965\u672f\u5b9e\u4f53\u6bcf\u56de\u5408\u4f1a\u6109\u60a6\u5730\u9020\u6210" + 4.getFormattedDamage(DamageType.LUST, 15, null, false, false) + "\u70b9\u4f24\u5bb3\uff0c\u540c\u65f6\u4f1a\u4f7f[npc2.her]\u7684\u884c\u52a8\u70b9\u51cf\u5c111\u70b9\uff01", new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            return UtilText.parse(source, "\u5bf9\u7740\u76ee\u6807\u91ca\u653e\u51fa\u58a8\u58a8\u3002\u8fd9\u53ea\u5c0f\u5965\u672f\u5b9e\u4f53\u6bcf\u56de\u5408\u4f1a\u6109\u60a6\u5730\u9020\u6210" + 4.getFormattedDamage(DamageType.LUST, 15, null, false, false) + "\u70b9\u4f24\u5bb3\uff0c\u540c\u65f6\u4f1a\u4f7f\u76ee\u6807\u7684\u884c\u52a8\u70b9\u51cf\u5c111\u70b9\uff01", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return 4.formatAttackOutcome(source, target, "[npc.Name]\u5c06\u7b14\u5e3d\u8f6c\u4e86\u4e09\u5708\uff0c\u7136\u540e\u5c06\u5b83\u62d4\u5f00\uff0c\u91ca\u653e\u51fa\u67d0\u79cd\u975e\u5e38\u7279\u6b8a\u7684\u7269\u8d28\u3002\u4e00\u56e2\u7d2b\u8272\u7684\u6db2\u4f53\u4ece\u9732\u51fa\u7684\u7b14\u5c16\u4e0a\u6ef4\u843d\uff0c\u8fc5\u901f\u81a8\u80c0\u6210\u4e00\u4e2a\u7ae0\u9c7c\u4e00\u6837\u7684\u5c0f\u751f\u7269\u3002\u8fd9\u53ea\u88ab\u79f0\u4e3a\u58a8\u58a8\u7684\u5965\u672f\u751f\u547d\u60ac\u6d6e\u5728\u7a7a\u4e2d\uff0c\u773c\u775b\u91cc\u5145\u6ee1\u4e86\u7231\u5fc3\uff0c\u5b83\u76ef\u7740[npc2.name]\uff0c\u53d1\u51fa\u4e00\u5c0f\u58f0\u5feb\u4e50\u7684\u547b\u541f\u3002<br/><br/>\u58a8\u58a8\u5f84\u76f4\u98de\u5411[npc2.name]\uff0c\u7528\u89e6\u624b\u73af\u62b1\u4f4f[npc2.herHim]\uff0c\u5f00\u59cb\u4e0b\u6d41\u5730\u63c9\u634f\u7231\u629a\u8d77\u6765\uff0c\u53d1\u51fa\u4e86\u66f4\u591a\u5feb\u4e50\u7684\u53eb\u58f0\u3002\u5f88\u663e\u800c\u6613\u89c1\u7684\u662f\uff0c[npc2.namePos]\u5c06\u8fd9\u53ea\u5965\u672f\u751f\u7269\u4ece[npc2.herHim]\u81ea\u5df1\u8eab\u4e0a\u62c9\u4e0b\u6765\u7684\u4efb\u4f55\u5c1d\u8bd5\u90fd\u6ce8\u5b9a\u8981\u5931\u8d25\u3002\u6bcf\u5f53[npc2.she]\u8bd5\u56fe\u6293\u4f4f\u8fd9\u53ea\u5c0f\u7ae0\u9c7c\uff0c[npc2.her]\u7684[npc.hands]\u90fd\u4f1a\u4ece\u5b83\u7684\u6d41\u4f53\u8eab\u8eaf\u4e0a\u6ed1\u5f00\uff0c\u5f15\u5f97\u8fd9\u53ea\u4e0b\u6d41\u751f\u7269\u53d1\u51fa\u53ef\u7231\u7684\u54af\u54af\u7b11\u58f0\u3002<br/><br/>\u5c3d\u7ba1\u58a8\u58a8\u7684\u89e6\u624b\u65e2\u4ee4\u4eba\u5206\u5fc3\u53c8\u8ba9\u4eba\u5174\u594b\uff0c\u4f46[npc2.name]\u5374\u5bf9\u5b83\u6beb\u65e0\u529e\u6cd5\uff0c\u53ea\u597d\u5c3d\u53ef\u80fd\u5730\u65e0\u89c6\u5b83\uff0c\u7b49\u5f85\u5b83\u8017\u5c3d\u5965\u672f\u80fd\u91cf\u2026\u2026", "\u58a8\u58a8\u73b0\u5728\u5168\u795e\u8d2f\u6ce8\u5730\u5bf9[npc2.name]\u91ca\u653e\u60c5\u6b32\uff01", null, null);
        }
    };
}

