/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.combat.moves;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum CombatMoveType {
    ATTACK("\u653b\u51fb", PresetColour.DAMAGE_TYPE_PHYSICAL),
    DEFEND("\u9632\u5fa1", PresetColour.SPELL_SCHOOL_WATER),
    TEASE("\u6311\u9017", PresetColour.GENERIC_SEX),
    SPELL("\u6cd5\u672f", PresetColour.GENERIC_ARCANE),
    POWER("\u80fd\u529b", PresetColour.GENERIC_ARCANE),
    ATTACK_DEFEND("\u9632\u5fa1\u5f0f\u653b\u51fb", PresetColour.SPELL_SCHOOL_WATER, new ArrayList<CombatMoveType>(Arrays.asList(ATTACK, DEFEND)));

    private String name;
    private List<CombatMoveType> countsAsList;
    private Colour colour;

    private CombatMoveType(String name, Colour colour) {
        this.name = name;
        this.colour = colour;
        this.countsAsList = new ArrayList<CombatMoveType>();
        this.countsAsList.add(this);
    }

    private CombatMoveType(String name, Colour colour, List<CombatMoveType> countsAsList) {
        this.name = name;
        this.colour = colour;
        this.countsAsList = countsAsList;
    }

    public String getName() {
        return this.name;
    }

    public Colour getColour() {
        return this.colour;
    }

    public List<CombatMoveType> getCountsAsList() {
        return this.countsAsList;
    }

    public boolean countsAs(CombatMoveType moveTypeCompared) {
        if (this == moveTypeCompared) {
            return true;
        }
        for (CombatMoveType moveType : this.countsAsList) {
            if (moveTypeCompared != moveType) continue;
            return true;
        }
        return false;
    }
}

