/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.combat.spells;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.EffectBenefit;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.effects.TreeEntry;
import com.lilithsthrone.game.combat.Attack;
import com.lilithsthrone.game.combat.CombatBehaviour;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.DamageVariance;
import com.lilithsthrone.game.combat.moves.AbstractCombatMove;
import com.lilithsthrone.game.combat.moves.CombatMoveType;
import com.lilithsthrone.game.combat.spells.SpellSchool;
import com.lilithsthrone.game.combat.spells.SpellType;
import com.lilithsthrone.game.combat.spells.SpellUpgrade;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.SpellManagement;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.sex.SexAreaOrifice;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Spell {
    FIREBALL(false, SpellSchool.FIRE, SpellType.OFFENSIVE, DamageType.FIRE, false, "\u706b\u7403\u672f", "fireball", "\u53ec\u5524\u4e00\u4e2a\u5965\u672f\u706b\u7130\u7403\uff0c\u5411\u76ee\u6807\u53d1\u5c04\u3002", 30, DamageVariance.LOW, 75, null, Util.newArrayListOfValues(SpellUpgrade.FIREBALL_1, SpellUpgrade.FIREBALL_2, SpellUpgrade.FIREBALL_3), null, null){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null && caster.hasSpellUpgrade(SpellUpgrade.FIREBALL_1)) {
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.LINGERING_FLAMES, 2));
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public int getDamage(GameCharacter caster) {
            if (caster != null && caster.hasSpellUpgrade(SpellUpgrade.FIREBALL_2) && !caster.hasSpellUpgrade(SpellUpgrade.FIREBALL_3)) {
                return 15;
            }
            return 30;
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return this.getFormattedSpellDamageRange(caster, target, enemies, allies);
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float damage = Attack.calculateSpellDamage(caster, target, this.damageType, this.getDamage(caster), this.damageVariance, isCritical);
            float cost = this.getModifiedCost(caster);
            if (caster.hasStatusEffect(StatusEffect.FIRE_MANA_BURN)) {
                cost = ((Float)Main.combat.getManaBurnStack().get(caster).remove(0)).floatValue();
            }
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u6c38\u6052\u4e4b\u706b\u554a\uff0c\u6211\u5c06\u4f53\u5185\u6f29\u6da1\u7684\u5c01\u5370\u89e3\u9664\uff01\u51fa\u6765\u5427\uff0c\u6bc1\u706d\u4e4b\u7130\uff01", "\u4ece\u706b\u7130\u7684\u9762\u7eb1\u4e4b\u5916\uff0c\u6211\u542c\u5230\u4e86\u5965\u672f\u7684\u53ec\u5524\uff01\u73b0\u5728\uff0c\u901a\u8fc7\u6211\uff0c\u5730\u72f1\u964d\u4e34\uff01", "\u9ed1\u6697\u7684\u865a\u7a7a\u554a\uff0c\u6211\u547d\u4ee4\u4f60\u7c89\u788e\u53e4\u8001\u7684\u5c01\u5370\uff0c\u8ba9\u5730\u72f1\u4e4b\u706b\u6c38\u4e16\u4e0d\u7184\uff01\u53bb\u5427\uff0c\u7ea2\u83b2\u6012\u706b\uff01"), "\u4f60\u5728[pc.arm]\u5468\u56f4\u53ec\u5524\u51fa\u4e00\u4e2a\u5965\u672f\u706b\u7130\u6f29\u6da1\uff0c\u5c06\u5176\u539f\u59cb\u529b\u91cf\u96c6\u4e2d\u5230\u4e00\u56e2\u718a\u718a\u71c3\u70e7\u7684\u706b\u7403\uff0c\u7136\u540e\u5411\u81ea\u5df1\u53d1\u5c04\uff01", "\u4f60\u5728[pc.arm]\u5468\u56f4\u53ec\u5524\u51fa\u4e00\u4e2a\u5965\u672f\u706b\u7130\u6f29\u6da1\uff0c\u5c06\u5176\u539f\u59cb\u529b\u91cf\u96c6\u4e2d\u5230\u4e00\u56e2\u718a\u718a\u71c3\u70e7\u7684\u706b\u7403\uff0c\u7136\u540e\u5411[npc.Name]\u53d1\u5c04\uff01", "", "[npc.she]\u5728[npc.arm]\u5468\u56f4\u53ec\u5524\u51fa\u4e00\u4e2a\u5965\u672f\u706b\u7130\u6f29\u6da1\uff0c\u5c06\u5176\u539f\u59cb\u529b\u91cf\u96c6\u4e2d\u5230\u4e00\u56e2\u718a\u718a\u71c3\u70e7\u7684\u706b\u7403\uff0c\u7136\u540e\u5411\u4f60\u53d1\u5c04\uff01", "[npc1.her]\u5728[npc1.arm]\u5468\u56f4\u53ec\u5524\u51fa\u4e00\u4e2a\u5965\u672f\u706b\u7130\u6f29\u6da1\uff0c\u5c06\u5176\u539f\u59cb\u529b\u91cf\u96c6\u4e2d\u5230\u4e00\u56e2\u718a\u718a\u71c3\u70e7\u7684\u706b\u7403\uff0c\u7136\u540e\u5411[npc2.name]\u53d1\u5c04\uff01"));
            if (caster.hasSpellUpgrade(SpellUpgrade.FIREBALL_2)) {
                descriptionSB.append("\u521a\u53d1\u5c04\uff0c\u706b\u7403\u4fbf\u7acb\u523b\u4e00\u5206\u4e3a\u4e8c\uff01");
            }
            descriptionSB.append(this.getDamageDescription(caster, target, damage, isHit, isCritical));
            if (isHit) {
                descriptionSB.append(this.applyDamage(caster, target, damage));
                if (caster.hasSpellUpgrade(SpellUpgrade.FIREBALL_1)) {
                    this.applyStatusEffects(caster, target, isCritical);
                    descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.FIREBALL_2)) {
                    damage = Attack.calculateSpellDamage(caster, target, this.damageType, this.getDamage(caster), this.damageVariance, isCritical);
                    GameCharacter secondaryTarget = Main.combat.getRandomAlliedPartyMember(target);
                    if (secondaryTarget.equals(target)) {
                        descriptionSB.append("<br/>\u7b2c\u4e8c\u679a\u706b\u7403\u8f6c\u5411\uff0c\u5bf9" + UtilText.parse(target, "[npc.name]", new ParserTag[0]) + "\u4e8c\u6b21\u8fde\u51fb\uff01");
                        descriptionSB.append(this.getDamageDescription(caster, target, damage, isHit, isCritical));
                        descriptionSB.append(this.applyDamage(caster, target, damage));
                    } else {
                        descriptionSB.append("<br/>\u7b2c\u4e8c\u679a\u706b\u7403\u5ffd\u7136\u8f6c\u5411\uff0c\u51fb\u4e2d\u4e86" + (secondaryTarget.isPlayer() ? "\u4f60" : UtilText.parse(secondaryTarget, "[npc.name]", new ParserTag[0])) + "\uff01");
                        descriptionSB.append(this.getDamageDescription(caster, secondaryTarget, damage, isHit, isCritical));
                        descriptionSB.append(this.applyDamage(caster, secondaryTarget, damage));
                        this.applyStatusEffects(caster, secondaryTarget, isCritical);
                        descriptionSB.append(this.getStatusEffectApplication(caster, secondaryTarget, isHit, isCritical));
                    }
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    FLASH(false, SpellSchool.FIRE, SpellType.OFFENSIVE_STATUS_EFFECT, DamageType.FIRE, false, "\u95ea\u5149\u672f", "flash", "\u4ea7\u751f\u8000\u773c\u7684\u95ea\u5149\uff0c\u4f7f\u76ee\u6807\u773c\u82b1\u7f2d\u4e71\u3002", 0, DamageVariance.LOW, 50, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.FLASH, 1)), Util.newArrayListOfValues(SpellUpgrade.FLASH_1, SpellUpgrade.FLASH_2, SpellUpgrade.FLASH_3), null, Util.newArrayListOfValues("[style.colourExcellent(\u7729\u6655)]\u76ee\u6807\uff0c\u4f7f\u5176[style.colourTerrible(-1)][style.colourActionPoints(\u884c\u52a8\u70b9)]\uff01")){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null && caster.hasSpellUpgrade(SpellUpgrade.FLASH_1)) {
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.FLASH_1, 1));
            }
            return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.FLASH, 1));
        }

        @Override
        public int getBaseCost(GameCharacter caster) {
            if (caster != null && caster.hasSpellUpgrade(SpellUpgrade.FLASH_3)) {
                return 25;
            }
            return 50;
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            if (caster != null && caster.hasSpellUpgrade(SpellUpgrade.FLASH_1)) {
                return "\u9020\u6210\u7729\u6655\uff0c[style.colourTerrible(-2)]\u884c\u52a8\u70b9\uff01";
            }
            return "\u9020\u6210\u7729\u6655\uff0c[style.colourTerrible(-1)]\u884c\u52a8\u70b9\uff01";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            if (caster.hasStatusEffect(StatusEffect.FIRE_MANA_BURN)) {
                cost = ((Float)Main.combat.getManaBurnStack().get(caster).remove(0)).floatValue();
            }
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u6c89\u5bc2\u4e8e\u543e\u4f53\u5185\u7684\u529b\u91cf\u554a\uff0c\u5386\u7ecf\u6570\u5343\u8f7d\u5c01\u5370\u5df2\u7136\u82cf\u9192\uff01\u73b0\u5728\uff0c\u8bf7\u89c1\u8bc1\u5b87\u5b99\u8bde\u751f\u65f6\u8000\u773c\u7684\u6012\u706b\u5427\uff01", "\u767e\u4e07\u661f\u4f53\u4e4b\u5149\u8000\u4ecd\u4e0d\u53ca\u6211\u7206\u53d1\u51fa\u7684\u529b\u91cf\uff01\u5965\u672f\u5c01\u5370\u89e3\u9664\uff0c\u5c06\u6211\u9762\u524d\u7684\u877c\u8681\u81f4\u76f2\u5427\uff01", "\u70c8\u65e5\u4e4b\u6012\u706b\uff0c\u768e\u6708\u4e4b\u51dd\u89c6\uff0c\u613f\u82cd\u5929\u89c1\u8bc1\u6211\u7684\u529b\u91cf\uff01\u671b\u89c1\u4e16\u754c\u7684\u5c3d\u5934\u5427\uff0c\u7edd\u671b\u5427\uff01"), "\u4f60\u4e00\u7529\u624b\u8155\uff0c\u4fbf\u5728\u4f60\u7684\u9762\u524d\u53ec\u5524\u51fa\u4e00\u9053\u70ab\u76ee\u7684\u95ea\u5149\uff01", "\u4f60\u4e00\u7529\u624b\u8155\uff0c\u4fbf\u5728[npc.namePos]\u7684\u9762\u524d\u53ec\u5524\u51fa\u4e00\u9053\u70ab\u76ee\u7684\u95ea\u5149\uff01", "", "[npc.Name]\u4e00\u7529\u624b\u8155\uff0c\u4fbf\u5728[npc.her]\u7684\u9762\u524d\u53ec\u5524\u51fa\u4e00\u9053\u70ab\u76ee\u7684\u95ea\u5149\uff01", "[npc1.name]\u4e00\u7529\u624b\u8155\uff0c\u4fbf\u5728[npc2.namePos]\u7684\u9762\u524d\u53ec\u5524\u51fa\u4e00\u9053\u70ab\u76ee\u7684\u95ea\u5149\uff01"));
            if (caster.hasSpellUpgrade(SpellUpgrade.FLASH_2)) {
                descriptionSB.append("\u53e6\u4e00\u9053\u5149\u8292\u4ece\u7b2c\u4e00\u9053\u4e2d\u5206\u51fa\uff0c\u641c\u5bfb\u7740\u53e6\u4e00\u4e2a\u76ee\u6807\uff01");
            }
            descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
            if (isHit) {
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
                if (caster.hasSpellUpgrade(SpellUpgrade.FLASH_2)) {
                    GameCharacter secondaryTarget = Main.combat.getRandomAlliedPartyMember(target);
                    if (secondaryTarget.equals(target)) {
                        descriptionSB.append("<br/>\u7b2c\u4e8c\u9053\u95ea\u5149\u6ca1\u80fd\u627e\u5230\u5176\u4ed6\u76ee\u6807\uff0c\u8fc5\u901f\u6d88\u6563\u4e86\u2026\u2026");
                    } else {
                        descriptionSB.append("<br/>\u7b2c\u4e8c\u9053\u95ea\u5149\u51b2\u5411" + UtilText.parse(secondaryTarget, "[npc.namePos]\u7684\u9762\u524d\uff0c\u4ee4\u5176[npc.herHim]\u4e5f\u773c\u82b1\u7f2d\u4e71\u8d77\u6765\uff01", new ParserTag[0]));
                        descriptionSB.append(this.getDamageDescription(caster, secondaryTarget, 0.0f, isHit, isCritical));
                        this.applyStatusEffects(caster, secondaryTarget, isCritical);
                        descriptionSB.append(this.getStatusEffectApplication(caster, secondaryTarget, isHit, isCritical));
                    }
                }
            } else {
                descriptionSB.append("<p style='text-align:center;'>[style.italicsBad(\u95ea\u5149\u6ca1\u80fd\u547d\u4e2d\uff01)]</p>");
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    CLOAK_OF_FLAMES(false, SpellSchool.FIRE, SpellType.DEFENSIVE_STATUS_EFFECT, DamageType.FIRE, true, "\u706b\u7130\u6597\u7bf7", "cloak_of_flames", "\u4e3a\u76ee\u6807\u62ab\u4e0a\u5965\u672f\u706b\u7130\u7684\u4fdd\u62a4\u6597\u7bf7\uff0c\u4f7f\u5176\u83b7\u5f97\u66f4\u597d\u7684\u51b0\u706b\u6297\u6027\u3002", 0, DamageVariance.LOW, 50, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.CLOAK_OF_FLAMES, 3)), Util.newArrayListOfValues(SpellUpgrade.CLOAK_OF_FLAMES_1, SpellUpgrade.CLOAK_OF_FLAMES_2, SpellUpgrade.CLOAK_OF_FLAMES_3), Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Integer>(Attribute.RESISTANCE_FIRE, 5), new Util.Value<AbstractAttribute, Integer>(Attribute.RESISTANCE_ICE, 10)), Util.newArrayListOfValues("\u6301\u7eed[style.colourGood(3\u56de\u5408)]")){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null && caster.hasSpellUpgrade(SpellUpgrade.CLOAK_OF_FLAMES_3)) {
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.CLOAK_OF_FLAMES_3, 3));
            }
            if (caster != null && caster.hasSpellUpgrade(SpellUpgrade.CLOAK_OF_FLAMES_2)) {
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.CLOAK_OF_FLAMES_2, 3));
            }
            if (caster != null && caster.hasSpellUpgrade(SpellUpgrade.CLOAK_OF_FLAMES_1)) {
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.CLOAK_OF_FLAMES_1, 3));
            }
            return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.CLOAK_OF_FLAMES, 3));
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u7ed9\u4e88\u76ee\u6807\u7528\u4e8e\u4fdd\u62a4\u7684\u706b\u7130\u6597\u7bf7\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            if (caster.hasStatusEffect(StatusEffect.FIRE_MANA_BURN)) {
                cost = ((Float)Main.combat.getManaBurnStack().get(caster).remove(0)).floatValue();
            }
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u5728\u6211\u7684\u529b\u91cf\u4e4b\u4e0b\uff0c\u51b0\u5ddd\u5c06\u878d\uff0c\u5343\u661f\u5931\u8272\uff01\u554a\uff0c\u7fa4\u661f\u4e4b\u6012\uff0c\u6211\u547d\u4ee4\u6c5d\u5e87\u62a4[npc.master]\uff01", "\u6c5d\u9700\u77e5\u6653\uff0c\u5730\u72f1\u4e4b\u706b\u81e3\u670d\u4e8e\u6211\u7684\u4e00\u4e3e\u4e00\u52a8\uff0c\u6211\u81ea\u706b\u7130\u4f4d\u9762\u7684\u70bd\u70ed\u6df1\u6e0a\u4e2d\uff0c\u53ec\u5524\u51fa\u4fdd\u62a4\u6211\u514d\u53d7\u4e00\u5207\u4f24\u5bb3\u7684\u529b\u91cf\uff01", "\u4ee5\u706b\u7130\u4e0e\u72c2\u6012\u7684\u529b\u91cf\uff0c\u6211\u5c06\u91ca\u653e\u70c8\u65e5\u7684\u5730\u72f1\u4e4b\u706b\uff01\u6765\u5427\uff0c\u5965\u672f\u7684\u72f1\u706b\uff0c\u5e87\u62a4\u4f60\u7684[npc.master]\uff0c\u51fb\u9000\u4efb\u4f55\u80c6\u6562\u88ad\u6765\u7684\u5bb6\u4f19\uff01"), "\u4f60[pc.arm]\u4e00\u6325\uff0c\u4fbf\u5728\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u4ef6\u7528\u4e8e\u4fdd\u62a4\u7684\u5965\u672f\u706b\u7130\u6597\u7bf7\uff01", "\u4f60[pc.arm]\u4e00\u6325\uff0c\u4fbf\u5728[npc.Name]\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u4ef6\u7528\u4e8e\u4fdd\u62a4\u7684\u5965\u672f\u706b\u7130\u6597\u7bf7\uff01", "[npc.Name][npc.arm]\u4e00\u6325\uff0c\u4fbf\u5728\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u4ef6\u7528\u4e8e\u4fdd\u62a4\u7684\u5965\u672f\u706b\u7130\u6597\u7bf7\uff01", "[npc.Name][npc.arm]\u4e00\u6325\uff0c\u4fbf\u5728\u4f60\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u4ef6\u7528\u4e8e\u4fdd\u62a4\u7684\u5965\u672f\u706b\u7130\u6597\u7bf7\uff01", "[npc1.name][npc1.arm]\u4e00\u6325\uff0c\u4fbf\u5728[npc2.name]\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u4ef6\u7528\u4e8e\u4fdd\u62a4\u7684\u5965\u672f\u706b\u7130\u6597\u7bf7\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
            if (isHit) {
                target.removeStatusEffect(StatusEffect.CLOAK_OF_FLAMES);
                target.removeStatusEffect(StatusEffect.CLOAK_OF_FLAMES_1);
                target.removeStatusEffect(StatusEffect.CLOAK_OF_FLAMES_2);
                target.removeStatusEffect(StatusEffect.CLOAK_OF_FLAMES_3);
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    ELEMENTAL_FIRE(false, SpellSchool.FIRE, SpellType.SUMMON, DamageType.FIRE, true, "\u5143\u7d20\u4e4b\u706b", "elemental_fire", "\u5c06\u5143\u7d20\u4f53\u4e0e\u70c8\u706b\u5b66\u6d3e\u7ed1\u5b9a\uff0c\u53ec\u5524\u51fa\u5b9e\u4f53\u5f62\u6001\u7684\u706b\u5143\u7d20\u3002", 0, DamageVariance.LOW, 200, null, Util.newArrayListOfValues(SpellUpgrade.ELEMENTAL_FIRE_1, SpellUpgrade.ELEMENTAL_FIRE_2, SpellUpgrade.ELEMENTAL_FIRE_3A, SpellUpgrade.ELEMENTAL_FIRE_3B), null, Util.newArrayListOfValues("\u4ee5[style.colourSchoolFire(\u706b\u7130)]\u7684\u5f62\u6001\u53ec\u5524[style.colourArcane(\u5143\u7d20)]")){

        @Override
        public Util.Value<Boolean, String> getSpellCastOutOfCombatDescription(GameCharacter owner, GameCharacter target) {
            if (!owner.hasSpell(this)) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u6ca1\u6709\u5b66\u4f1a\u8be5\u6cd5\u672f\uff0c\u6240\u4ee5\u65e0\u6cd5\u91ca\u653e\uff01", new ParserTag[0]));
            }
            if (owner.isCaptive()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u88ab\u4fd8\u864f\u65f6\u65e0\u6cd5\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            if (Main.game.isInCombat()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u6218\u6597\u4e2d\u53ea\u80fd\u4ee5\u6218\u6597\u52a8\u4f5c\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            if (!Main.game.isSavedDialogueNeutral() && Main.game.getCurrentDialogueNode() == SpellManagement.CHARACTER_SPELLS_FIRE && SpellManagement.getDialogueReturn().getDialogueNodeType() != DialogueNodeType.OCCUPANT_MANAGEMENT) {
                return new Util.Value<Boolean, String>(false, "\u53ea\u80fd\u5728\u4e2d\u7acb\u573a\u666f\u91ca\u653e\u6cd5\u672f\uff01");
            }
            if (owner.getMana() < this.getModifiedCost(owner) && !owner.isSpellSchoolSpecialAbilityUnlocked(SpellSchool.FIRE)) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u9700\u8981\u81f3\u5c11<b>" + this.getModifiedCost(owner) + "</b>[style.boldMana(\u7075\u6c14)]\u624d\u80fd\u91ca\u653e\u8be5\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            String description = owner.isPlayer() ? "\u5c06\u5143\u7d20\u4f53\u4e0e\u70c8\u706b\u5b66\u6d3e\u7ed1\u5b9a\u540e\u53ec\u5524\uff01" : "\u8ba9[npc.name]\u5c06\u5143\u7d20\u4f53\u4e0e\u70c8\u706b\u5b66\u6d3e\u7ed1\u5b9a\u540e\u53ec\u5524\uff01";
            String cost = "\u5c06\u6d88\u8017<b>" + this.getModifiedCost(owner) + "</b>[style.boldMana(\u7075\u6c14)]\uff01";
            if (owner.getMana() < this.getModifiedCost(owner)) {
                cost = "\u5c06\u6d88\u8017<b>" + Math.round((owner.getMana() - this.getModifiedCost(owner)) * -0.25f) + "</b>[style.boldHealth(" + Attribute.HEALTH_MAXIMUM.getName() + ")]\uff01";
            }
            return new Util.Value<Boolean, String>(true, UtilText.parse(owner, description + "<br/>" + cost, new ParserTag[0]));
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u4ee5\u706b\u7130\u7684\u5f62\u6001\u53ec\u5524\u5143\u7d20\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            if (caster.hasStatusEffect(StatusEffect.FIRE_MANA_BURN)) {
                cost = ((Float)Main.combat.getManaBurnStack().get(caster).remove(0)).floatValue();
            }
            descriptionSB.setLength(0);
            boolean elementalAlreadySummoned = false;
            if (!caster.hasDiscoveredElemental()) {
                caster.createElemental();
            } else {
                elementalAlreadySummoned = caster.isElementalSummoned();
            }
            caster.setElementalSummoned(true);
            caster.getElemental().setElementalSchool(SpellSchool.FIRE);
            if (elementalAlreadySummoned) {
                descriptionSB.append(UtilText.parse(caster, caster.getElemental(), (caster.hasTraitActivated(Perk.CHUUNI) ? Util.randomItemFrom(Util.newArrayListOfValues("[npc.speech(\u53e4\u8001\u7684\u706b\u7130\u4eea\u5f0f\u4e0b\uff0c\u6211\u53ec\u5524\u51fa\u5730\u72f1\u4e0e\u6124\u6012\u7684\u5316\u8eab\uff01\u56de\u5e94\u4f60[npc.master]\u7684\u53ec\u5524\u5427\uff0c[npc2.name]\uff0c\u7ecf\u5386\u767e\u4e07\u4f4d\u9762\u7684\u711a\u70e7\uff0c\u670d\u4ece\u6211\u7684\u610f\u5fd7\uff01)] ", "[npc.speech(\u613f\u5c01\u5370\u4e8e\u6211\u4f53\u5185\u6570\u5343\u8f7d\u7684\u529b\u91cf\u4e00\u671d\u8ff8\u53d1\uff01\u901a\u8fc7\u6c38\u6052\u7684\u94fe\u63a5\uff0c\u6211\u5411\u706b\u7130\u4f4d\u9762\u53d1\u51fa\u53ec\u5524\uff0c\u51fa\u6765\u5427\uff0c[npc2.name]\uff01)] ", "[npc.speech(\u8ba9\u706b\u7130\u541e\u566c\u4e00\u5207\uff0c\u613f\u6211\u4f53\u5185\u7684\u72f1\u706b\u8ff8\u53d1\u800c\u51fa\u5427\uff01\u70c8\u7130\u4e0e\u6012\u706b\uff0c\u8fd9\u662f[npc.master]\u53ec\u5524\uff01\u670d\u4ece\u6211\uff0c\u73b0\u8eab\u5427\uff0c[npc2.name]\uff01)] ")) : "") + (caster.isPlayer() ? "\u968f\u7740\u70ab\u76ee\u7684\u95ea\u5149\u548c\u706b\u7130\u7684\u7206\u88c2\u58f0\uff0c\u4f60\u5c06\u5143\u7d20\u4f53[npc2.name]\u4e0e\u70c8\u706b\u5b66\u6d3e\u7ed1\u5b9a\uff01" : "\u968f\u7740\u70ab\u76ee\u7684\u95ea\u5149\u548c\u706b\u7130\u7684\u7206\u88c2\u58f0\uff0c[npc1.name]\u5c06\u5143\u7d20\u4f53[npc2.name]\u4e0e\u70c8\u706b\u5b66\u6d3e\u7ed1\u5b9a\uff01"), new ParserTag[0]));
            } else {
                descriptionSB.append(UtilText.parse(caster, caster.getElemental(), (caster.hasTraitActivated(Perk.CHUUNI) ? Util.randomItemFrom(Util.newArrayListOfValues("[npc.speech(\u706b\u7130\u7684\u53e4\u8001\u4eea\u5f0f\u4e0b\uff0c\u6211\u53ec\u5524\u51fa\u5730\u72f1\u4e0e\u6124\u6012\u7684\u5316\u8eab\uff01\u56de\u5e94\u4f60[npc.master]\u7684\u53ec\u5524\u5427\uff0c[npc2.name]\uff0c\u7ecf\u5386\u767e\u4e07\u4f4d\u9762\u7684\u711a\u70e7\uff0c\u670d\u4ece\u6211\u7684\u610f\u5fd7\uff01)] ", "[npc.speech(\u613f\u5c01\u5370\u4e8e\u6211\u4f53\u5185\u6570\u5343\u8f7d\u7684\u529b\u91cf\u4e00\u671d\u8ff8\u53d1\uff01\u901a\u8fc7\u6c38\u6052\u7684\u94fe\u63a5\uff0c\u6211\u5411\u706b\u7130\u4f4d\u9762\u53d1\u51fa\u53ec\u5524\uff0c\u51fa\u6765\u5427\uff0c[npc2.name]\uff01)] ", "[npc.speech(\u8ba9\u706b\u7130\u541e\u566c\u4e00\u5207\uff0c\u613f\u6211\u4f53\u5185\u7684\u72f1\u706b\u8ff8\u53d1\u800c\u51fa\u5427\uff01\u70c8\u7130\u4e0e\u6012\u706b\uff0c\u8fd9\u662f[npc.master]\u7684\u53ec\u5524\uff01\u670d\u4ece\u6211\uff0c\u73b0\u8eab\u5427\uff0c[npc2.name]\uff01)] ")) : "") + (caster.isPlayer() ? "\u968f\u7740\u70ab\u76ee\u7684\u95ea\u5149\u548c\u706b\u7130\u7684\u7206\u88c2\u58f0\uff0c\u4f60\u53ec\u5524\u51fa\u5143\u7d20\u4f53[npc2.name]\uff0c\u5e76\u4e0e\u70c8\u706b\u5b66\u6d3e\u7ed1\u5b9a\uff01" : "\u968f\u7740\u70ab\u76ee\u7684\u95ea\u5149\u548c\u706b\u7130\u7684\u7206\u88c2\u58f0\uff0c[npc1.name]\u53ec\u5524\u51fa\u5143\u7d20\u4f53[npc2.name]\uff0c\u5e76\u4e0e\u70c8\u706b\u5b66\u6d3e\u7ed1\u5b9a\uff01"), new ParserTag[0]));
                if (Main.game.isInCombat()) {
                    caster.getElemental().setLocation(caster, false);
                    if (caster.isPlayer() || Main.combat.getAllies(Main.game.getPlayer()).contains(caster)) {
                        Main.combat.addAlly(caster.getElemental());
                    } else {
                        Main.combat.addEnemy(caster.getElemental());
                    }
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    ICE_SHARD(false, SpellSchool.WATER, SpellType.OFFENSIVE, DamageType.ICE, false, "\u51b0\u5203\u672f", "ice_shard", "\u53ec\u5524\u4e00\u679a\u51b0\u971c\u88c2\u7247\uff0c\u5411\u76ee\u6807\u53d1\u5c04\u3002", 25, DamageVariance.LOW, 35, null, Util.newArrayListOfValues(SpellUpgrade.ICE_SHARD_1, SpellUpgrade.ICE_SHARD_2, SpellUpgrade.ICE_SHARD_3), null, null){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null) {
                if (caster.hasSpellUpgrade(SpellUpgrade.ICE_SHARD_3) && isCritical) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.FREEZING_FOG, 3), new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.FROZEN, 1));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.ICE_SHARD_1)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.FREEZING_FOG, 3));
                }
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return this.getFormattedSpellDamageRange(caster, target, enemies, allies);
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float damage = Attack.calculateSpellDamage(caster, target, this.damageType, this.getDamage(caster), this.damageVariance, isCritical);
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u89c1\u8bc1\u65e0\u5149\u865a\u65e0\u7684\u6050\u6016\u5427\uff01\u51b0\u96ea\u7684\u547c\u5524\uff0c\u96ea\u66b4\u7684\u72c2\u6012\uff0c\u91ca\u653e\u5427\uff0c\u6211\u7684\u5965\u672f\u4e4b\u529b\uff01", "\u6211\u5df2\u7ecf\u6323\u8131\u4f53\u5185\u7684\u67b7\u9501\uff0c\u6211\u5c06\u7528\u529b\u91cf\uff0c\u51bb\u7ed3\u6574\u4e2a\u5b87\u5b99\uff01\u72c2\u98ce\u3001\u51b0\u96f9\u3001\u5bd2\u51b0\uff0c\u542c\u6211\u53f7\u4ee4\uff0c\u65e0\u754f\u5730\u51b2\u950b\u5427\uff01", "\u5728\u51bb\u7ed3\u7684\u865a\u7a7a\u4e4b\u5916\uff0c\u6211\u7684\u529b\u91cf\u81ea\u6b64\u8ff8\u53d1\uff01\u6211\u5c06\u5c55\u73b0\u8fd9\u529b\u91cf\uff0c\u8de8\u8d8a\u51bb\u7ed3\u7684\u6df7\u6c8c\u9886\u57df\u7684\u754c\u9650\uff01"), "\u4f60\u4ece\u7a7a\u6c14\u7684\u6c34\u6c7d\u4e2d\u53ec\u5524\u51fa\u4e00\u9053\u65cb\u8f6c\u7684\u6c34\u6da1\uff0c\u5c06\u80fd\u91cf\u96c6\u4e2d\u540e\u4fbf\u5c06\u5176\u51bb\u7ed3\uff0c\u5236\u9020\u51fa\u4e00\u5757\u51b0\u5203\uff0c\u968f\u540e\u5411\u81ea\u5df1\u8eab\u4e0a\u6295\u53bb\uff01", "\u4f60\u4ece\u7a7a\u6c14\u7684\u6c34\u6c7d\u4e2d\u53ec\u5524\u51fa\u4e00\u9053\u65cb\u8f6c\u7684\u6c34\u6da1\uff0c\u5c06\u80fd\u91cf\u96c6\u4e2d\u540e\u4fbf\u5c06\u5176\u51bb\u7ed3\uff0c\u5236\u9020\u51fa\u4e00\u5757\u51b0\u5203\uff0c\u968f\u540e\u5411[npc.Name]\u8eab\u4e0a\u6295\u53bb\uff01", "", "[npc1.name]\u4ece\u7a7a\u6c14\u7684\u6c34\u6c7d\u4e2d\u53ec\u5524\u51fa\u4e00\u9053\u65cb\u8f6c\u7684\u6c34\u6da1\uff0c\u5c06\u80fd\u91cf\u96c6\u4e2d\u540e\u4fbf\u5c06\u5176\u51bb\u7ed3\uff0c\u5236\u9020\u51fa\u4e00\u5757\u51b0\u5203\uff0c\u968f\u540e\u5411\u4f60\u8eab\u4e0a\u6295\u53bb\uff01", "[npc1.name]\u4ece\u7a7a\u6c14\u7684\u6c34\u6c7d\u4e2d\u53ec\u5524\u51fa\u4e00\u9053\u65cb\u8f6c\u7684\u6c34\u6da1\uff0c\u5c06\u80fd\u91cf\u96c6\u4e2d\u540e\u4fbf\u5c06\u5176\u51bb\u7ed3\uff0c\u5236\u9020\u51fa\u4e00\u5757\u51b0\u5203\uff0c\u968f\u540e\u5411[npc2.name]\u8eab\u4e0a\u6295\u53bb\uff01"));
            if (isHit && isCritical && caster.hasSpellUpgrade(SpellUpgrade.ICE_SHARD_2)) {
                descriptionSB.append("\u51b0\u5203\u7834\u7a7a\u800c\u8fc7\u65f6\u7206\u53d1\u51fa\u4e00\u9635\u51bb\u7ed3\u7684\u96fe\u6c14");
                if (caster.hasSpellUpgrade(SpellUpgrade.ICE_SHARD_3)) {
                    descriptionSB.append("\uff0c\u628a\u5468\u56f4\u7684\u4e00\u5207\u90fd\u51b0\u5c01\u5728\u4e86\u8584\u8584\u7684\u51b0\u5c42\u4e2d\uff01");
                } else {
                    descriptionSB.append("\uff01");
                }
            }
            descriptionSB.append(this.getDamageDescription(caster, target, damage, isHit, isCritical));
            if (isHit) {
                if (damage > 0.0f) {
                    descriptionSB.append(this.applyDamage(caster, target, damage));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.ICE_SHARD_1)) {
                    this.applyStatusEffects(caster, target, isCritical);
                    descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues("\u76ee\u6807\u62e5\u6709\u201c\u51bb\u4eba\u5bd2\u96fe\u201d\u72b6\u6001\u6548\u679c\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return target.hasStatusEffect(StatusEffect.FREEZING_FOG) || Main.combat.getStatusEffectsToApply().get(target).containsKey(StatusEffect.FREEZING_FOG);
        }
    }
    ,
    RAIN_CLOUD(false, SpellSchool.WATER, SpellType.OFFENSIVE_STATUS_EFFECT, DamageType.ICE, false, "\u96e8\u4e91\u672f", "rain_cloud", "\u5728\u76ee\u6807\u5934\u9876\u53ec\u5524\u4e00\u5c0f\u56e2\u5965\u672f\u9b54\u6cd5\u96e8\u4e91\uff0c\u524a\u5f31\u4ed6\u4eec\u7684\u65bd\u6cd5\u80fd\u529b\u3002", 0, DamageVariance.LOW, 33, null, Util.newArrayListOfValues(SpellUpgrade.RAIN_CLOUD_1, SpellUpgrade.RAIN_CLOUD_2, SpellUpgrade.RAIN_CLOUD_3), Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Integer>(Attribute.SPELL_COST_MODIFIER, -25)), Util.newArrayListOfValues("\u6301\u7eed[style.colourGood(3\u56de\u5408)]")){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null) {
                if (caster.hasSpellUpgrade(SpellUpgrade.RAIN_CLOUD_3)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.RAIN_CLOUD_DOWNPOUR_FOR_CLOUDBURST, 3));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.RAIN_CLOUD_2)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.RAIN_CLOUD_DOWNPOUR, 3));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.RAIN_CLOUD_1)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.RAIN_CLOUD_DEEP_CHILL, 3));
                }
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.RAIN_CLOUD, 3));
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u5728\u76ee\u6807\u5934\u9876\u53ec\u5524\u4e00\u56e2\u96e8\u4e91\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u613f\u82cd\u7a79\u9707\u6012\uff0c\u6d2a\u6c34\u5e2d\u5377\u5927\u5730\uff01\u6211\u5c06\u5c55\u73b0\u4f53\u5185\u7684\u6d2a\u8352\u4e4b\u529b\uff0c\u6495\u88c2\u5929\u7a7a\uff0c\u5c06\u4f60\u9001\u5165\u6c34\u4e4b\u575f\u5893\uff01"), "\u4f60\u9ad8\u6325[pc.arm]\uff0c\u5728\u4f60\u81ea\u5df1\u5934\u9876\u53ec\u5524\u51fa\u4e00\u56e2\u96e8\u4e91\uff01", "\u4f60\u9ad8\u6325[pc.arm]\uff0c\u5728[npc.namePos]\u5934\u9876\u53ec\u5524\u51fa\u4e00\u56e2\u96e8\u4e91\uff01", "", "[npc.Name]\u9ad8\u6325[npc.arm]\uff0c\u5728\u4f60\u5934\u9876\u53ec\u5524\u51fa\u4e00\u56e2\u96e8\u4e91\uff01", "[npc.Name]\u9ad8\u6325[npc.arm]\uff0c\u5728[npc2.namePos]\u5934\u9876\u53ec\u5524\u51fa\u4e00\u56e2\u96e8\u4e91\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
            if (isHit) {
                target.removeStatusEffect(StatusEffect.RAIN_CLOUD_CLOUDBURST);
                target.removeStatusEffect(StatusEffect.RAIN_CLOUD_DOWNPOUR_FOR_CLOUDBURST);
                target.removeStatusEffect(StatusEffect.RAIN_CLOUD_DOWNPOUR);
                target.removeStatusEffect(StatusEffect.RAIN_CLOUD_DEEP_CHILL);
                target.removeStatusEffect(StatusEffect.RAIN_CLOUD);
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    SOOTHING_WATERS(false, SpellSchool.WATER, SpellType.DEFENSIVE_HEAL, DamageType.ICE, true, "\u629a\u6170\u4e4b\u6c34", "soothing_waters", "\u53ec\u5524\u4e00\u56e2\u6ce8\u5165\u4e86\u5b89\u629a\u5965\u672f\u7684\u6c34\uff0c\u6062\u590d\u996e\u7528\u8005\u7684" + Attribute.HEALTH_MAXIMUM.getName() + "\u3002", 0, DamageVariance.LOW, 100, null, Util.newArrayListOfValues(SpellUpgrade.SOOTHING_WATERS_1_CLEAN, SpellUpgrade.SOOTHING_WATERS_2_CLEAN, SpellUpgrade.SOOTHING_WATERS_1, SpellUpgrade.SOOTHING_WATERS_2, SpellUpgrade.SOOTHING_WATERS_3), null, Util.newArrayListOfValues("[style.boldGood(\u6062\u590d)]20%[style.boldHealth(" + Attribute.HEALTH_MAXIMUM.getName() + ")]")){

        @Override
        public Map<Integer, List<TreeEntry<SpellSchool, SpellUpgrade>>> getSpellUpgradeTree() {
            return soothingWatersUpgradeTree;
        }

        @Override
        public Util.Value<Boolean, String> getSpellCastOutOfCombatDescription(GameCharacter owner, GameCharacter target) {
            if (!owner.hasSpell(this)) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u6ca1\u6709\u5b66\u4f1a\u8be5\u6cd5\u672f\uff0c\u6240\u4ee5\u65e0\u6cd5\u91ca\u653e\uff01", new ParserTag[0]));
            }
            if (owner.isCaptive()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u88ab\u4fd8\u864f\u65f6\u65e0\u6cd5\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            if (Main.game.isInCombat()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u6218\u6597\u4e2d\u53ea\u80fd\u4ee5\u6218\u6597\u52a8\u4f5c\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            if (!Main.game.isSavedDialogueNeutral() && Main.game.getCurrentDialogueNode() == SpellManagement.CHARACTER_SPELLS_WATER && SpellManagement.getDialogueReturn().getDialogueNodeType() != DialogueNodeType.OCCUPANT_MANAGEMENT) {
                return new Util.Value<Boolean, String>(false, "\u53ea\u80fd\u5728\u4e2d\u7acb\u573a\u666f\u91ca\u653e\u6cd5\u672f\uff01");
            }
            if (owner.getMana() < this.getModifiedCost(owner)) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u9700\u8981\u81f3\u5c11<b>" + this.getModifiedCost(owner) + "</b>[style.boldMana(\u7075\u6c14)]\u624d\u80fd\u91ca\u653e\u8be5\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            Object description = owner.isPlayer() ? "\u91ca\u653e\u201c\u629a\u6170\u4e4b\u6c34\u201d" : "\u8ba9[npc.name]\u91ca\u653e\u201c\u629a\u6170\u4e4b\u6c34\u201d";
            description = owner == target ? (String)description + " \u76ee\u6807\u4e3a[npc.herself]\uff01" : (String)description + "\u76ee\u6807\u4e3a[npc2.name]\uff01";
            String cost = "\u5c06\u6d88\u8017<b>" + this.getModifiedCost(owner) + "</b>[style.boldMana(\u7075\u6c14)]\uff01";
            return new Util.Value<Boolean, String>(true, UtilText.parse(owner, target, (String)description + "<br/>" + cost, new ParserTag[0]));
        }

        @Override
        public int getAPCost() {
            return 3;
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u6cbb\u6108\u76ee\u6807";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u6c34\u6d41\u3001\u6eaa\u6c34\u3001\u6cb3\u5ddd\u3001\u6d77\u6d0b\u554a\uff0c\u6211\u547c\u5524\u8fd9\u5ddd\u6d41\u4e0d\u606f\u7684\u5faa\u73af\uff01\u6211\u5c06\u529b\u91cf\u91ca\u653e\u4e8e\u6c5d\uff0c\u5e26\u6765\u6c38\u6052\u751f\u547d\u7684\u6e90\u6cc9\uff01"), "\u4f60\u5c06[pc.hand]\u8f7b\u8f7b\u4e00\u6325\uff0c\u4fbf\u53ec\u5524\u51fa\u4e00\u9897\u5c0f\u7403\u5927\u5c0f\u7684\u6cbb\u6108\u4e4b\u6c34\uff0c\u5e76\u5c06\u5176\u4e00\u996e\u800c\u5c3d\u3002", "\u4f60\u5c06[pc.hand]\u8f7b\u8f7b\u4e00\u6325\uff0c\u4fbf\u53ec\u5524\u51fa\u4e00\u9897\u5c0f\u7403\u5927\u5c0f\u7684\u6cbb\u6108\u4e4b\u6c34\uff0c\u9001\u5230[npc.Name]\u8eab\u8fb9\u4f9b\u5176\u996e\u7528\u3002", "[npc.Name]\u5c06[npc.hand]\u8f7b\u8f7b\u4e00\u6325\uff0c\u4fbf\u53ec\u5524\u51fa\u4e00\u9897\u5c0f\u7403\u5927\u5c0f\u7684\u6cbb\u6108\u4e4b\u6c34\uff0c\u5e76\u5c06\u5176\u4e00\u996e\u800c\u5c3d\u3002", "[npc.Name]\u5c06[npc.hand]\u8f7b\u8f7b\u4e00\u6325\uff0c\u4fbf\u53ec\u5524\u51fa\u4e00\u9897\u5c0f\u7403\u5927\u5c0f\u7684\u6cbb\u6108\u4e4b\u6c34\uff0c\u9001\u5230\u4f60\u8eab\u8fb9\u4f9b\u4f60\u996e\u7528\u3002", "[npc.Name]\u5c06[npc.hand]\u8f7b\u8f7b\u4e00\u6325\uff0c\u4fbf\u53ec\u5524\u51fa\u4e00\u9897\u5c0f\u7403\u5927\u5c0f\u7684\u6cbb\u6108\u4e4b\u6c34\uff0c\u9001\u5230[npc2.name]\u8eab\u8fb9\u4f9b\u5176\u996e\u7528\u3002"));
            if (caster.hasSpellUpgrade(SpellUpgrade.SOOTHING_WATERS_3)) {
                descriptionSB.append("\u4ece\u539f\u672c\u7684\u7403\u4f53\u4e2d\u5206\u88c2\u51fa\u4e86\u4e00\u9897\u66f4\u5c0f\u7684\u6c34\u7403\uff01");
            }
            if (isHit) {
                if (caster.hasSpellUpgrade(SpellUpgrade.SOOTHING_WATERS_3)) {
                    descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
                    descriptionSB.append("<br/>\u6c34\u7403\u6062\u590d\u4e86" + UtilText.parse(target, "[npc.name]", new ParserTag[0]) + (int)(target.getAttributeValue(Attribute.HEALTH_MAXIMUM) * 0.4f) + Attribute.HEALTH_MAXIMUM.getColouredName("b") + "\u548c" + (int)(target.getAttributeValue(Attribute.MANA_MAXIMUM) * 0.2f) + Attribute.MANA_MAXIMUM.getColouredName("b") + "\uff01");
                    descriptionSB.append(this.applyDamage(caster, target, -target.getAttributeValue(Attribute.HEALTH_MAXIMUM) * 0.4f));
                    target.incrementMana(target.getAttributeValue(Attribute.MANA_MAXIMUM) * 0.2f);
                    if (Main.game.isInCombat()) {
                        ArrayList<GameCharacter> alliesPlusCaster = new ArrayList<GameCharacter>(Main.combat.getAllies(caster));
                        alliesPlusCaster.add(caster);
                        for (GameCharacter combatant : alliesPlusCaster) {
                            descriptionSB.append("<br/>" + UtilText.parse(combatant, "\u8f83\u5c0f\u7684\u6c34\u7403\u98de\u5411[npc.name]\uff0c\u6062\u590d\u4e86[npc.herHim]" + (int)(target.getAttributeValue(Attribute.HEALTH_MAXIMUM) * 0.1f) + Attribute.HEALTH_MAXIMUM.getColouredName("b") + "\u548c" + (int)(target.getAttributeValue(Attribute.MANA_MAXIMUM) * 0.1f) + Attribute.MANA_MAXIMUM.getColouredName("b") + "\uff01", new ParserTag[0]));
                            descriptionSB.append(this.applyDamage(caster, combatant, -combatant.getAttributeValue(Attribute.HEALTH_MAXIMUM) * 0.1f));
                            combatant.incrementMana(combatant.getAttributeValue(Attribute.MANA_MAXIMUM) * 0.1f);
                            if (caster.hasSpellUpgrade(SpellUpgrade.SOOTHING_WATERS_1_CLEAN)) {
                                descriptionSB.append(UtilText.parse(combatant, "<br/>[npc.NamePos]\u7684\u8eab\u4f53\u548c\u7a7f\u7740\u7684\u8863\u7269\u90fd\u501f\u52a9\u6cd5\u672f[style.colourAqua(\u6e05\u7406\u5e72\u51c0)]\u4e86\uff01", new ParserTag[0]));
                                combatant.cleanAllClothing(false, false);
                                combatant.cleanAllDirtySlots(true);
                            }
                            if (!caster.hasSpellUpgrade(SpellUpgrade.SOOTHING_WATERS_2_CLEAN)) continue;
                            descriptionSB.append(UtilText.parse(combatant, "<br/>[npc.NamePos]\u7684\u8eab\u4f53\u501f\u52a9\u6cd5\u672f[style.colourAqua(\u5b8c\u5168\u6e05\u7406)]\u4e86\uff01", new ParserTag[0]));
                            combatant.drainTotalFluidsStored(SexAreaOrifice.ANUS, 250.0f);
                            combatant.drainTotalFluidsStored(SexAreaOrifice.VAGINA, 250.0f);
                            combatant.drainTotalFluidsStored(SexAreaOrifice.NIPPLE, 250.0f);
                            combatant.drainTotalFluidsStored(SexAreaOrifice.NIPPLE_CROTCH, 250.0f);
                            combatant.drainTotalFluidsStored(SexAreaOrifice.URETHRA_PENIS, 250.0f);
                            combatant.drainTotalFluidsStored(SexAreaOrifice.URETHRA_VAGINA, 250.0f);
                        }
                    }
                } else if (caster.hasSpellUpgrade(SpellUpgrade.SOOTHING_WATERS_2)) {
                    descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
                    descriptionSB.append("<br/>\u6c34\u7403\u6062\u590d\u4e86" + UtilText.parse(target, "[npc.name]", new ParserTag[0]) + (int)(target.getAttributeValue(Attribute.HEALTH_MAXIMUM) * 0.4f) + Attribute.HEALTH_MAXIMUM.getColouredName("b") + "\u548c" + (int)(target.getAttributeValue(Attribute.MANA_MAXIMUM) * 0.2f) + Attribute.MANA_MAXIMUM.getColouredName("b") + "\uff01");
                    descriptionSB.append(this.applyDamage(caster, target, -target.getAttributeValue(Attribute.HEALTH_MAXIMUM) * 0.4f));
                    target.incrementMana(target.getAttributeValue(Attribute.MANA_MAXIMUM) * 0.2f);
                } else if (caster.hasSpellUpgrade(SpellUpgrade.SOOTHING_WATERS_1)) {
                    descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
                    descriptionSB.append("<br/>\u6c34\u7403\u6062\u590d\u4e86" + UtilText.parse(target, "[npc.name]", new ParserTag[0]) + (int)(target.getAttributeValue(Attribute.HEALTH_MAXIMUM) * 0.2f) + Attribute.HEALTH_MAXIMUM.getColouredName("b") + "\u548c" + (int)(target.getAttributeValue(Attribute.MANA_MAXIMUM) * 0.2f) + Attribute.MANA_MAXIMUM.getColouredName("b") + "\uff01");
                    descriptionSB.append(this.applyDamage(caster, target, -target.getAttributeValue(Attribute.HEALTH_MAXIMUM) * 0.2f));
                    target.incrementMana(target.getAttributeValue(Attribute.MANA_MAXIMUM) * 0.2f);
                } else {
                    descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
                    descriptionSB.append("<br/>\u6c34\u7403\u6062\u590d\u4e86" + UtilText.parse(target, "[npc.name]", new ParserTag[0]) + (int)(target.getAttributeValue(Attribute.HEALTH_MAXIMUM) * 0.2f) + Attribute.HEALTH_MAXIMUM.getColouredName("b") + "\uff01");
                    descriptionSB.append(this.applyDamage(caster, target, -target.getAttributeValue(Attribute.HEALTH_MAXIMUM) * 0.2f));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.SOOTHING_WATERS_1_CLEAN)) {
                    descriptionSB.append(UtilText.parse(target, "<br/>[npc.NamePos]\u7684\u8eab\u4f53\u548c\u7a7f\u7740\u7684\u8863\u7269\u90fd\u501f\u52a9\u6cd5\u672f[style.colourAqua(\u6e05\u7406\u5e72\u51c0)]\u4e86\uff01", new ParserTag[0]));
                    target.cleanAllClothing(false, false);
                    target.cleanAllDirtySlots(true);
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.SOOTHING_WATERS_2_CLEAN)) {
                    descriptionSB.append(UtilText.parse(target, "<br/>[npc.NamePos]\u7684\u8eab\u4f53\u501f\u52a9\u6cd5\u672f[style.colourAqua(\u5b8c\u5168\u6e05\u7406)]\u4e86\uff01", new ParserTag[0]));
                    target.drainTotalFluidsStored(SexAreaOrifice.ANUS, 250.0f);
                    target.drainTotalFluidsStored(SexAreaOrifice.VAGINA, 250.0f);
                    target.drainTotalFluidsStored(SexAreaOrifice.NIPPLE, 250.0f);
                    target.drainTotalFluidsStored(SexAreaOrifice.NIPPLE_CROTCH, 250.0f);
                    target.drainTotalFluidsStored(SexAreaOrifice.URETHRA_PENIS, 250.0f);
                    target.drainTotalFluidsStored(SexAreaOrifice.URETHRA_VAGINA, 250.0f);
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    ELEMENTAL_WATER(false, SpellSchool.WATER, SpellType.SUMMON, DamageType.ICE, true, "\u5143\u7d20\u4e4b\u6c34", "elemental_water", "\u5c06\u5143\u7d20\u4f53\u4e0e\u6fc0\u6d41\u5b66\u6d3e\u7ed1\u5b9a\uff0c\u53ec\u5524\u51fa\u5b9e\u4f53\u5f62\u6001\u7684\u6c34\u5143\u7d20\u3002", 0, DamageVariance.LOW, 200, null, Util.newArrayListOfValues(SpellUpgrade.ELEMENTAL_WATER_1, SpellUpgrade.ELEMENTAL_WATER_2, SpellUpgrade.ELEMENTAL_WATER_3A, SpellUpgrade.ELEMENTAL_WATER_3B), null, Util.newArrayListOfValues("\u4ee5[style.colourSchoolWater(\u6c34\u6d41)]\u7684\u5f62\u6001\u53ec\u5524[style.colourArcane(\u5143\u7d20)]")){

        @Override
        public Util.Value<Boolean, String> getSpellCastOutOfCombatDescription(GameCharacter owner, GameCharacter target) {
            if (!owner.hasSpell(this)) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u6ca1\u6709\u5b66\u4f1a\u8be5\u6cd5\u672f\uff0c\u6240\u4ee5\u65e0\u6cd5\u91ca\u653e\uff01", new ParserTag[0]));
            }
            if (owner.isCaptive()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u88ab\u4fd8\u864f\u65f6\u65e0\u6cd5\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            if (Main.game.isInCombat()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u6218\u6597\u4e2d\u53ea\u80fd\u4ee5\u6218\u6597\u52a8\u4f5c\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            if (!Main.game.isSavedDialogueNeutral() && Main.game.getCurrentDialogueNode() == SpellManagement.CHARACTER_SPELLS_WATER && SpellManagement.getDialogueReturn().getDialogueNodeType() != DialogueNodeType.OCCUPANT_MANAGEMENT) {
                return new Util.Value<Boolean, String>(false, "\u53ea\u80fd\u5728\u4e2d\u7acb\u573a\u666f\u91ca\u653e\u6cd5\u672f\uff01");
            }
            if (owner.getMana() < this.getModifiedCost(owner)) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u9700\u8981\u81f3\u5c11<b>" + this.getModifiedCost(owner) + "</b>[style.boldMana(\u7075\u6c14)]\u624d\u80fd\u91ca\u653e\u8be5\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            String description = owner.isPlayer() ? "\u5c06\u5143\u7d20\u4f53\u4e0e\u6fc0\u6d41\u5b66\u6d3e\u7ed1\u5b9a\u540e\u53ec\u5524\uff01" : "\u8ba9[npc.name]\u5c06\u5143\u7d20\u4f53\u4e0e\u6fc0\u6d41\u5b66\u6d3e\u7ed1\u5b9a\u540e\u53ec\u5524\uff01";
            String cost = "\u5c06\u6d88\u8017<b>" + this.getModifiedCost(owner) + "</b>[style.boldMana(\u7075\u6c14)]\uff01";
            return new Util.Value<Boolean, String>(true, UtilText.parse(owner, description + "<br/>" + cost, new ParserTag[0]));
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u4ee5\u6c34\u6d41\u7684\u5f62\u6001\u53ec\u5524\u5143\u7d20\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            boolean elementalAlreadySummoned = false;
            if (!caster.hasDiscoveredElemental()) {
                caster.createElemental();
            } else {
                elementalAlreadySummoned = caster.isElementalSummoned();
            }
            caster.setElementalSummoned(true);
            caster.getElemental().setElementalSchool(SpellSchool.WATER);
            if (elementalAlreadySummoned) {
                descriptionSB.append(UtilText.parse(caster, caster.getElemental(), (caster.hasTraitActivated(Perk.CHUUNI) ? Util.randomItemFrom(Util.newArrayListOfValues("[npc.speech(\u6d77\u4e0e\u5929\u7684\u53e4\u8001\u4eea\u5f0f\u4e0b\uff0c\u6211\u53ec\u5524\u51fa\u6c38\u6052\u7684\u6fc0\u6d41\uff01\u56de\u5e94\u4f60[npc.master]\u7684\u53ec\u5524\u5427\uff0c[npc2.name]\uff0c\u7ecf\u5386\u767e\u4e07\u4f4d\u9762\u7684\u6df9\u6ca1\uff0c\u670d\u4ece\u6211\u7684\u610f\u5fd7\uff01)] ", "[npc.speech(\u613f\u5c01\u5370\u4e8e\u6211\u4f53\u5185\u6570\u5343\u8f7d\u7684\u529b\u91cf\u4e00\u671d\u8ff8\u53d1\uff01\u901a\u8fc7\u6c38\u6052\u7684\u94fe\u63a5\uff0c\u6c34\u6d41\u542c\u6211\u53f7\u4ee4\uff0c\u51fa\u6765\u5427\uff0c[npc2.name]\uff01)] ", "[npc.speech(\u8ba9\u60ca\u6d9b\u88ad\u6765\uff0c\u613f\u6211\u4f53\u5185\u7684\u6d77\u5578\u8ff8\u53d1\u800c\u51fa\u5427\uff01\u6d2a\u6d41\u4e0e\u66b4\u96e8\uff0c\u8fd9\u662f[npc.master]\u7684\u53ec\u5524\uff01\u670d\u4ece\u6211\uff0c\u73b0\u8eab\u5427\uff0c[npc2.name]\uff01)] ")) : "") + (caster.isPlayer() ? "\u968f\u7740\u5de8\u5927\u7684\u6d6a\u6d9b\u58f0\uff0c\u4f60\u5c06\u5143\u7d20\u4f53[npc2.name]\u4e0e\u6fc0\u6d41\u5b66\u6d3e\u7ed1\u5b9a\uff01" : "\u968f\u7740\u5de8\u5927\u7684\u6d6a\u6d9b\u58f0\uff0c[npc1.name]\u5c06\u5143\u7d20\u4f53[npc2.name]\u4e0e\u6fc0\u6d41\u5b66\u6d3e\u7ed1\u5b9a\uff01"), new ParserTag[0]));
            } else {
                descriptionSB.append(UtilText.parse(caster, caster.getElemental(), (caster.hasTraitActivated(Perk.CHUUNI) ? Util.randomItemFrom(Util.newArrayListOfValues("[npc.speech(\u6d77\u4e0e\u5929\u7684\u53e4\u8001\u4eea\u5f0f\u4e0b\uff0c\u6211\u53ec\u5524\u51fa\u6c38\u6052\u7684\u6fc0\u6d41\uff01\u56de\u5e94\u4f60[npc.master]\u7684\u53ec\u5524\u5427\uff0c[npc2.name]\uff0c\u7ecf\u5386\u767e\u4e07\u4f4d\u9762\u7684\u6df9\u6ca1\uff0c\u670d\u4ece\u6211\u7684\u610f\u5fd7\uff01)] ", "[npc.speech(\u613f\u5c01\u5370\u4e8e\u6211\u4f53\u5185\u6570\u5343\u8f7d\u7684\u529b\u91cf\u4e00\u671d\u8ff8\u53d1\uff01\u901a\u8fc7\u6c38\u6052\u7684\u94fe\u63a5\uff0c\u6c34\u6d41\u542c\u6211\u53f7\u4ee4\uff0c\u51fa\u6765\u5427\uff0c[npc2.name]\uff01)] ", "[npc.speech(\u8ba9\u60ca\u6d9b\u88ad\u6765\uff0c\u613f\u6211\u4f53\u5185\u7684\u6d77\u5578\u8ff8\u53d1\u800c\u51fa\u5427\uff01\u6d2a\u6d41\u4e0e\u66b4\u96e8\uff0c\u8fd9\u662f[npc.master]\u7684\u53ec\u5524\uff01\u670d\u4ece\u6211\uff0c\u73b0\u8eab\u5427\uff0c[npc2.name]\uff01)] ")) : "") + (caster.isPlayer() ? "\u968f\u7740\u5de8\u5927\u7684\u6d6a\u6d9b\u58f0\uff0c\u4f60\u53ec\u5524\u51fa\u5143\u7d20\u4f53[npc2.name]\uff0c\u5e76\u4e0e\u6fc0\u6d41\u5b66\u6d3e\u7ed1\u5b9a\uff01" : "\u968f\u7740\u5de8\u5927\u7684\u6d6a\u6d9b\u58f0\uff0c[npc1.name]\u53ec\u5524\u51fa\u5143\u7d20\u4f53[npc2.name]\uff0c\u5e76\u4e0e\u6fc0\u6d41\u5b66\u6d3e\u7ed1\u5b9a\uff01"), new ParserTag[0]));
                if (Main.game.isInCombat()) {
                    caster.getElemental().setLocation(caster, false);
                    if (caster.isPlayer() || Main.combat.getAllies(Main.game.getPlayer()).contains(caster)) {
                        Main.combat.addAlly(caster.getElemental());
                    } else {
                        Main.combat.addEnemy(caster.getElemental());
                    }
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    POISON_VAPOURS(false, SpellSchool.AIR, SpellType.OFFENSIVE_STATUS_EFFECT, DamageType.POISON, false, "\u6bd2\u4e91\u672f", "poison_vapours", "\u5728\u76ee\u6807\u5468\u56f4\u53ec\u5524\u4e00\u56e2\u6709\u6bd2\u6c14\u4f53\u3002", 0, DamageVariance.LOW, 50, null, Util.newArrayListOfValues(SpellUpgrade.POISON_VAPOURS_1, SpellUpgrade.POISON_VAPOURS_2, SpellUpgrade.POISON_VAPOURS_3), null, Util.newArrayListOfValues("\u6bcf\u56de\u5408\u9020\u6210<b>25</b>[style.colourPoison(\u6bd2\u7d20\u4f24\u5bb3)]\uff0c\u6301\u7eed[style.colourGood(3\u56de\u5408)]")){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null) {
                if (caster.hasSpellUpgrade(SpellUpgrade.POISON_VAPOURS_3)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.POISON_VAPOURS_WEAKENING_CLOUD, 3));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.POISON_VAPOURS_2)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.POISON_VAPOURS_ARCANE_SICKNESS, 3));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.POISON_VAPOURS_1)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.POISON_VAPOURS_CHOKING_HAZE, 3));
                }
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.POISON_VAPOURS, 3));
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u5728\u76ee\u6807\u5468\u56f4\u53ec\u5524\u4e00\u56e2\u6bd2\u4e91";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u6253\u7834\u8fd9\u5c01\u5370\uff0c\u8ba9\u771f\u6b63\u7684\u529b\u91cf\u91ca\u653e\u800c\u51fa\u5427\uff01\u6765\u5427\uff0c\u9634\u973e\u4e0e\u70df\u96fe\uff0c\u8ba9\u6c14\u6d41\u542c\u6211\u53f7\u4ee4\uff01"), "\u4f60[pc.arm]\u4e00\u626b\uff0c\u4fbf\u5728\u81ea\u5df1\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u56e2\u6bd2\u6027\u84b8\u6c7d\u4e91\uff01", "\u4f60[pc.arm]\u4e00\u626b\uff0c\u4fbf\u5728[npc.Name]\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u56e2\u6bd2\u6027\u84b8\u6c7d\u4e91\uff01", "", "[npc.her][npc.arm]\u4e00\u626b\uff0c\u4fbf\u5728\u4f60\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u56e2\u6bd2\u6027\u84b8\u6c7d\u4e91\uff01", "[npc.her][npc.arm]\u4e00\u626b\uff0c\u4fbf\u5728[npc2.name]\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u56e2\u6bd2\u6027\u84b8\u6c7d\u4e91\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
            if (isHit) {
                target.removeStatusEffect(StatusEffect.POISON_VAPOURS_WEAKENING_CLOUD);
                target.removeStatusEffect(StatusEffect.POISON_VAPOURS_ARCANE_SICKNESS);
                target.removeStatusEffect(StatusEffect.POISON_VAPOURS_CHOKING_HAZE);
                target.removeStatusEffect(StatusEffect.POISON_VAPOURS);
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    VACUUM(false, SpellSchool.AIR, SpellType.OFFENSIVE_STATUS_EFFECT_MINOR_DAMAGE, DamageType.PHYSICAL, false, "\u771f\u7a7a\u672f", "vacuum", "\u521b\u9020\u4e00\u90e8\u5206\u771f\u7a7a\u73af\u5883\uff0c\u5148\u901a\u8fc7\u5438\u529b\u9020\u6210\u5c11\u91cf\u4f24\u5bb3\uff0c\u5e76\u5728\u505c\u7559\u5728\u5468\u56f4\uff0c\u7ee7\u7eed\u963b\u788d\u76ee\u6807\u7684\u884c\u52a8\u3002", 5, DamageVariance.LOW, 60, null, Util.newArrayListOfValues(SpellUpgrade.VACUUM_1, SpellUpgrade.VACUUM_2, SpellUpgrade.VACUUM_3), Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Integer>(Attribute.ENERGY_SHIELDING, -5)), Util.newArrayListOfValues("\u6301\u7eed[style.colourGood(4\u56de\u5408)]")){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null) {
                if (caster.hasSpellUpgrade(SpellUpgrade.VACUUM_3)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.VACUUM_TOTAL_VOID, 4));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.VACUUM_2)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.VACUUM_SUCTION, 4));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.VACUUM_1)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.VACUUM_SECONDARY_VOIDS, 4));
                }
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.VACUUM, 4));
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u5728\u76ee\u6807\u5468\u56f4\u53ec\u5524\u51fa\u4e00\u90e8\u5206\u5e72\u6270\u7684\u771f\u7a7a\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float damage = Attack.calculateSpellDamage(caster, target, this.damageType, this.getDamage(caster), this.damageVariance, isCritical);
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u6bd4\u9ed1\u8272\u66f4\u52a0\u6df1\u9083\u7684\u9ed1\u6697\uff01\u6211\u53ec\u5524\u4e0d\u706d\u7684\u865a\u65e0\uff0c\u7a7f\u8d8a\u65f6\u7a7a\u7684\u88c2\u7f1d\uff0c\u8ba9\u6211\u7684\u529b\u91cf\u5c55\u73b0\u51fa\u6765\u5427\uff01"), "\u4f60\u7d27\u63e1\u62f3\u5934\uff0c\u5728\u81ea\u5df1\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u90e8\u5206\u771f\u7a7a\uff01", "\u4f60\u7d27\u63e1\u62f3\u5934\uff0c\u5728[npc.Name]\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u90e8\u5206\u771f\u7a7a\uff01", "", "[npc.Name]\u7d27\u63e1\u62f3\u5934\uff0c\u5728\u4f60\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u90e8\u5206\u771f\u7a7a\uff01", "[npc.Name]\u7d27\u63e1\u62f3\u5934\uff0c\u5728[npc2.name]\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u90e8\u5206\u771f\u7a7a\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, damage, isHit, isCritical));
            if (isHit) {
                descriptionSB.append(this.applyDamage(caster, target, damage));
                target.removeStatusEffect(StatusEffect.VACUUM_TOTAL_VOID);
                target.removeStatusEffect(StatusEffect.VACUUM_SUCTION);
                target.removeStatusEffect(StatusEffect.VACUUM_SECONDARY_VOIDS);
                target.removeStatusEffect(StatusEffect.VACUUM);
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    PROTECTIVE_GUSTS(false, SpellSchool.AIR, SpellType.DEFENSIVE_STATUS_EFFECT, DamageType.PHYSICAL, true, "\u62a4\u4f53\u4e4b\u98ce", "protective_gusts", "\u53ec\u5524\u4ec1\u6148\u4e4b\u98ce\u4fdd\u62a4\u76ee\u6807\uff0c\u5e76\u5e2e\u52a9\u5f15\u5bfc\u76ee\u6807\u653b\u51fb\u3002", 0, DamageVariance.LOW, 50, null, Util.newArrayListOfValues(SpellUpgrade.PROTECTIVE_GUSTS_1, SpellUpgrade.PROTECTIVE_GUSTS_2, SpellUpgrade.PROTECTIVE_GUSTS_3), Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Integer>(Attribute.RESISTANCE_POISON, 5), new Util.Value<AbstractAttribute, Integer>(Attribute.ENERGY_SHIELDING, 1)), Util.newArrayListOfValues("\u6301\u7eed[style.colourGood(3\u56de\u5408)]")){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null) {
                if (caster.hasSpellUpgrade(SpellUpgrade.PROTECTIVE_GUSTS_3)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.PROTECTIVE_GUSTS_FOCUSED_BLAST, 5));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.PROTECTIVE_GUSTS_2)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.PROTECTIVE_GUSTS_FOCUSED_BLAST, 3));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.PROTECTIVE_GUSTS_1)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.PROTECTIVE_GUSTS_GUIDING_WIND, 3));
                }
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.PROTECTIVE_GUSTS, 3));
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u53ec\u5524\u4e00\u9053\u4ec1\u6148\u4e4b\u98ce\u4fdd\u62a4\u76ee\u6807\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u5927\u6c14\uff0c\u670d\u4ece\u6211\u7684\u547d\u4ee4\uff01\u6211\u5c06\u91ca\u653e\u51fa\u771f\u6b63\u7684\u529b\u91cf\uff0c\u72c2\u98ce\u4e0e\u6211\u7684\u610f\u5fd7\u540c\u4e00\uff01"), "\u4f60\u5c06[pc.arms]\u5f20\u5411\u4e24\u8fb9\uff0c\u53ec\u5524\u51fa\u4e00\u9053\u4ec1\u6148\u4e4b\u98ce\u4fdd\u62a4\u7740\u4f60\uff01", "\u4f60\u5c06[pc.arms]\u5f20\u5f00\u5411\u4e24\u8fb9\uff0c\u53ec\u5524\u51fa\u4e00\u9053\u4ec1\u6148\u4e4b\u98ce\u4fdd\u62a4\u7740[npc.Name]\uff01", "[npc.Name]\u5c06[npc.arms]\u5f20\u5411\u4e24\u8fb9\uff0c\u53ec\u5524\u51fa\u4e00\u9053\u4ec1\u6148\u4e4b\u98ce\u4fdd\u62a4\u81ea\u5df1\uff01", "[npc.Name]\u5c06[npc.arms]\u5f20\u5f00\u5411\u4e24\u8fb9\uff0c\u53ec\u5524\u51fa\u4e00\u9053\u4ec1\u6148\u4e4b\u98ce\u4fdd\u62a4\u7740\u4f60\uff01", "[npc.Name]\u5c06[npc.arms]\u5f20\u5f00\u5411\u4e24\u8fb9\uff0c\u53ec\u5524\u51fa\u4e00\u9053\u4ec1\u6148\u4e4b\u98ce\u4fdd\u62a4\u7740[npc2.name]\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
            if (isHit) {
                target.removeStatusEffect(StatusEffect.PROTECTIVE_GUSTS_FOCUSED_BLAST);
                target.removeStatusEffect(StatusEffect.PROTECTIVE_GUSTS_GUIDING_WIND);
                target.removeStatusEffect(StatusEffect.PROTECTIVE_GUSTS);
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    ELEMENTAL_AIR(false, SpellSchool.AIR, SpellType.SUMMON, DamageType.PHYSICAL, true, "\u5143\u7d20\u4e4b\u98ce", "elemental_air", "\u5c06\u5143\u7d20\u4f53\u4e0e\u5927\u6c14\u5b66\u6d3e\u7ed1\u5b9a\uff0c\u53ec\u5524\u51fa\u5b9e\u4f53\u5f62\u6001\u7684\u98ce\u5143\u7d20\u3002", 0, DamageVariance.LOW, 200, null, Util.newArrayListOfValues(SpellUpgrade.ELEMENTAL_AIR_1, SpellUpgrade.ELEMENTAL_AIR_2, SpellUpgrade.ELEMENTAL_AIR_3A, SpellUpgrade.ELEMENTAL_AIR_3B), null, Util.newArrayListOfValues("\u4ee5[style.colourArcane(\u5143\u7d20)]\u7684\u5f62\u6001\u53ec\u5524[style.colourSchoolAir(\u98ce)]")){

        @Override
        public Util.Value<Boolean, String> getSpellCastOutOfCombatDescription(GameCharacter owner, GameCharacter target) {
            if (!owner.hasSpell(this)) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u6ca1\u6709\u5b66\u4f1a\u8be5\u6cd5\u672f\uff0c\u6240\u4ee5\u65e0\u6cd5\u91ca\u653e\uff01", new ParserTag[0]));
            }
            if (owner.isCaptive()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u88ab\u4fd8\u864f\u65f6\u65e0\u6cd5\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            if (Main.game.isInCombat()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u6218\u6597\u4e2d\u53ea\u80fd\u4ee5\u6218\u6597\u52a8\u4f5c\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            if (!Main.game.isSavedDialogueNeutral() && Main.game.getCurrentDialogueNode() == SpellManagement.CHARACTER_SPELLS_AIR && SpellManagement.getDialogueReturn().getDialogueNodeType() != DialogueNodeType.OCCUPANT_MANAGEMENT) {
                return new Util.Value<Boolean, String>(false, "\u53ea\u80fd\u5728\u4e2d\u7acb\u573a\u666f\u91ca\u653e\u6cd5\u672f\uff01");
            }
            if (owner.getMana() < this.getModifiedCost(owner)) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u9700\u8981\u81f3\u5c11<b>" + this.getModifiedCost(owner) + "</b>[style.boldMana(\u7075\u6c14)]\u624d\u80fd\u91ca\u653e\u8be5\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            String description = owner.isPlayer() ? "\u5c06\u5143\u7d20\u4f53\u4e0e\u5927\u6c14\u5b66\u6d3e\u7ed1\u5b9a\u540e\u53ec\u5524\uff01" : "\u8ba9[npc.name]\u5c06\u5143\u7d20\u4f53\u4e0e\u5927\u6c14\u5b66\u6d3e\u7ed1\u5b9a\u540e\u53ec\u5524\uff01";
            String cost = "\u5c06\u6d88\u8017<b>" + this.getModifiedCost(owner) + "</b>[style.boldMana(\u7075\u6c14)]\uff01";
            return new Util.Value<Boolean, String>(true, UtilText.parse(owner, description + "<br/>" + cost, new ParserTag[0]));
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u4ee5\u5927\u6c14\u7684\u5f62\u6001\u53ec\u5524\u5143\u7d20\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            boolean elementalAlreadySummoned = false;
            if (!caster.hasDiscoveredElemental()) {
                caster.createElemental();
            } else {
                elementalAlreadySummoned = caster.isElementalSummoned();
            }
            caster.setElementalSummoned(true);
            caster.getElemental().setElementalSchool(SpellSchool.AIR);
            if (elementalAlreadySummoned) {
                descriptionSB.append(UtilText.parse(caster, caster.getElemental(), (caster.hasTraitActivated(Perk.CHUUNI) ? Util.randomItemFrom(Util.newArrayListOfValues("[npc.speech(\u72c2\u98ce\u7684\u53e4\u8001\u4eea\u5f0f\u4e0b\uff0c\u6211\u53ec\u5524\u51fa\u90a3\u53f0\u98ce\uff01\u56de\u5e94\u4f60[npc.master]\u7684\u53ec\u5524\u5427\uff0c[npc2.name]\uff0c\u7ecf\u5386\u767e\u4e07\u4f4d\u9762\u7684\u547c\u5578\uff0c\u670d\u4ece\u6211\u7684\u610f\u5fd7\uff01)] ", "[npc.speech(\u613f\u5c01\u5370\u4e8e\u6211\u4f53\u5185\u6570\u5343\u8f7d\u7684\u529b\u91cf\u4e00\u671d\u8ff8\u53d1\uff01\u901a\u8fc7\u6c38\u6052\u7684\u94fe\u63a5\uff0c\u6211\u5411\u5927\u6c14\u53d1\u51fa\u53ec\u5524\uff0c\u51fa\u6765\u5427\uff0c[npc2.name]\uff01)] ", "[npc.speech(\u8ba9\u72c2\u98ce\u88ad\u6765\uff0c\u613f\u6211\u4f53\u5185\u7684\u98d3\u98ce\u8ff8\u53d1\u800c\u51fa\u5427\uff01\u98ce\u66b4\u4e0e\u6df7\u6c8c\uff0c\u8fd9\u662f[npc.master]\u7684\u53ec\u5524\uff01\u670d\u4ece\u6211\uff0c\u73b0\u8eab\u5427\uff0c[npc2.name]\uff01)] ")) : "") + (caster.isPlayer() ? "\u968f\u7740\u9707\u64bc\u7684\u98ce\u58f0\uff0c\u4f60\u5c06\u5143\u7d20\u4f53[npc2.name]\u4e0e\u5927\u6c14\u5b66\u6d3e\u7ed1\u5b9a\uff01" : "\u968f\u7740\u9707\u64bc\u7684\u98ce\u58f0\uff0c[npc1.name]\u5c06\u5143\u7d20\u4f53[npc2.name]\u4e0e\u5927\u6c14\u5b66\u6d3e\u7ed1\u5b9a\uff01"), new ParserTag[0]));
            } else {
                descriptionSB.append(UtilText.parse(caster, caster.getElemental(), (caster.hasTraitActivated(Perk.CHUUNI) ? Util.randomItemFrom(Util.newArrayListOfValues("[npc.speech(\u72c2\u98ce\u7684\u53e4\u8001\u4eea\u5f0f\u4e0b\uff0c\u6211\u53ec\u5524\u51fa\u90a3\u53f0\u98ce\uff01\u56de\u5e94\u4f60[npc.master]\u7684\u53ec\u5524\u5427\uff0c[npc2.name]\uff0c\u7ecf\u5386\u767e\u4e07\u4f4d\u9762\u7684\u547c\u5578\uff0c\u670d\u4ece\u6211\u7684\u610f\u5fd7\uff01)] ", "[npc.speech(\u613f\u5c01\u5370\u4e8e\u6211\u4f53\u5185\u6570\u5343\u8f7d\u7684\u529b\u91cf\u4e00\u671d\u8ff8\u53d1\uff01\u901a\u8fc7\u6c38\u6052\u7684\u94fe\u63a5\uff0c\u6211\u5411\u5927\u6c14\u53d1\u51fa\u53ec\u5524\uff0c\u51fa\u6765\u5427\uff0c[npc2.name]\uff01)] ", "[npc.speech(\u8ba9\u72c2\u98ce\u88ad\u6765\uff0c\u613f\u6211\u4f53\u5185\u7684\u98d3\u98ce\u8ff8\u53d1\u800c\u51fa\u5427\uff01\u98ce\u66b4\u4e0e\u6df7\u6c8c\uff0c\u8fd9\u662f[npc.master]\u7684\u53ec\u5524\uff01\u670d\u4ece\u6211\uff0c\u73b0\u8eab\u5427\uff0c[npc2.name]\uff01)] ")) : "") + (caster.isPlayer() ? "\u968f\u7740\u9707\u64bc\u7684\u98ce\u58f0\uff0c\u4f60\u53ec\u5524\u51fa\u5143\u7d20\u4f53[npc2.name]\uff0c\u5e76\u4e0e\u5927\u6c14\u5b66\u6d3e\u7ed1\u5b9a\uff01" : "\u968f\u7740\u9707\u64bc\u7684\u98ce\u58f0\uff0c[npc1.name]\u53ec\u5524\u51fa\u5143\u7d20\u4f53[npc2.name]\uff0c\u5e76\u4e0e\u5927\u6c14\u5b66\u6d3e\u7ed1\u5b9a\uff01"), new ParserTag[0]));
                if (Main.game.isInCombat()) {
                    caster.getElemental().setLocation(caster, false);
                    if (caster.isPlayer() || Main.combat.getAllies(Main.game.getPlayer()).contains(caster)) {
                        Main.combat.addAlly(caster.getElemental());
                    } else {
                        Main.combat.addEnemy(caster.getElemental());
                    }
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    SLAM(false, SpellSchool.EARTH, SpellType.OFFENSIVE, DamageType.PHYSICAL, false, "\u91cd\u51fb\u672f", "slam", "\u53ec\u5524\u4e00\u80a1\u78be\u538b\u7684\u529b\u91cf\u6ce2\uff0c\u731b\u51fb\u76ee\u6807\u3002", 40, DamageVariance.LOW, 60, null, Util.newArrayListOfValues(SpellUpgrade.SLAM_1, SpellUpgrade.SLAM_2, SpellUpgrade.SLAM_3), null, null){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null) {
                if (caster.hasSpellUpgrade(SpellUpgrade.SLAM_2)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.SLAM_AFTER_SHOCK, 2));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.SLAM_1)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.SLAM_GROUND_SHAKE, 2));
                }
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return this.getFormattedSpellDamageRange(caster, target, enemies, allies);
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float damage = Attack.calculateSpellDamage(caster, target, this.damageType, this.getDamage(caster), this.damageVariance, isCritical);
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u5c71\u5ce6\u9707\u98a4\uff0c\u5927\u5730\u7eb5\u88c2\uff01\u6211\u5c06\u91ca\u653e\u529b\u91cf\uff0c\u65e0\u7a77\u4e4b\u529b\u5c06\u4efb\u6211\u4f7f\u5f79\uff0c\u4ee4\u4f60\u7070\u98de\u70df\u706d\uff01"), "\u4f60\u91cd\u91cd\u5730\u5411\u4e0b\u4e00\u6325\uff0c\u4fbf\u53ec\u5524\u51fa\u4e00\u9053\u7eaf\u7cb9\u7684\u529b\u6ce2\uff0c\u7838\u5411\u4e86\u81ea\u5df1\uff01", "\u4f60\u91cd\u91cd\u5730\u5411\u4e0b\u4e00\u6325\uff0c\u4fbf\u53ec\u5524\u51fa\u4e00\u9053\u7eaf\u7cb9\u7684\u529b\u6ce2\uff0c\u7838\u5411\u4e86[npc.Name]\uff01", "", "[npc.Name]\u91cd\u91cd\u5730\u5411\u4e0b\u4e00\u6325\uff0c\u4fbf\u53ec\u5524\u51fa\u4e00\u9053\u7eaf\u7cb9\u7684\u529b\u6ce2\uff0c\u7838\u5411\u4e86\u4f60\uff01", "[npc.Name]\u91cd\u91cd\u5730\u5411\u4e0b\u4e00\u6325\uff0c\u4fbf\u53ec\u5524\u51fa\u4e00\u9053\u7eaf\u7cb9\u7684\u529b\u6ce2\uff0c\u7838\u5411\u4e86[npc2.name]\uff01"));
            if (isHit) {
                if (caster.hasSpellUpgrade(SpellUpgrade.SLAM_3)) {
                    descriptionSB.append("\u529b\u968f\u540e\u51fb\u5411\u5730\u9762\uff0c\u9020\u6210\u4e86\u5267\u70c8\u7684\u5730\u9707\uff01");
                } else if (caster.hasSpellUpgrade(SpellUpgrade.SLAM_1)) {
                    descriptionSB.append("\u529b\u968f\u540e\u51fb\u5411\u5730\u9762\uff0c\u9020\u6210\u4e86\u660e\u663e\u7684\u9707\u52a8\uff01");
                }
            }
            descriptionSB.append(this.getDamageDescription(caster, target, damage, isHit, isCritical));
            if (isHit) {
                if (damage > 0.0f) {
                    descriptionSB.append(this.applyDamage(caster, target, damage));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.SLAM_3)) {
                    for (GameCharacter combatant : Main.combat.getEnemies(caster)) {
                        this.applyStatusEffects(caster, combatant, isCritical);
                        descriptionSB.append(this.getStatusEffectApplication(caster, combatant, isHit, isCritical));
                    }
                } else if (caster.hasSpellUpgrade(SpellUpgrade.SLAM_1)) {
                    this.applyStatusEffects(caster, target, isCritical);
                    descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    TELEKENETIC_SHOWER(false, SpellSchool.EARTH, SpellType.OFFENSIVE_STATUS_EFFECT, DamageType.PHYSICAL, false, "\u5ff5\u529b\u4e4b\u96e8", "telekinetic_shower", "\u5c06\u5468\u56f4\u7684\u5c0f\u7269\u4f53\u4e3e\u8d77\u81f3\u7a7a\u4e2d\uff0c\u4e00\u9f50\u5411\u76ee\u6807\u7838\u53bb\u3002", 0, DamageVariance.LOW, 125, null, Util.newArrayListOfValues(SpellUpgrade.TELEKENETIC_SHOWER_1, SpellUpgrade.TELEKENETIC_SHOWER_2, SpellUpgrade.TELEKENETIC_SHOWER_3), null, Util.newArrayListOfValues("\u6bcf\u56de\u5408\u9020\u6210<b>25</b>[style.colourPhysical(\u7269\u7406\u4f24\u5bb3)]\uff0c\u6301\u7eed[style.colourGood(3\u56de\u5408)]")){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null) {
                if (caster.hasSpellUpgrade(SpellUpgrade.TELEKENETIC_SHOWER_3)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEKENETIC_SHOWER_UNSEEN_FORCE, 6));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.TELEKENETIC_SHOWER_2)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEKENETIC_SHOWER_PRECISION_STRIKES, 6));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.TELEKENETIC_SHOWER_1)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEKENETIC_SHOWER, 6));
                }
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEKENETIC_SHOWER, 3));
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u5411\u76ee\u6807\u53d1\u5c04\u51fa\u4e00\u4e9b\u5c0f\u7269\u4f53\uff0c\u5e76\u5e72\u6270\u5bf9\u65b9\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u5b87\u5b99\u661f\u8fb0\u4e4b\u529b\u542c\u6211\u53f7\u4ee4\uff01\u5728\u8fd9\u4f4d\u9762\u7684\u6da1\u6d41\u4e2d\uff0c\u6211\u5c06\u626d\u66f2\u65f6\u7a7a\u7684\u8fb9\u754c\uff01"), "\u4f60\u62ac\u8d77[pc.arms]\uff0c\u8eab\u8fb9\u5404\u79cd\u5c0f\u7269\u4ef6\u4fbf\u540c\u65f6\u98de\u8d77\u81f3\u534a\u7a7a\uff0c\u63a5\u7740\u5c31\u5411\u4f60\u81ea\u5df1\u7838\u53bb\uff01", "\u4f60\u62ac\u8d77[pc.arms]\uff0c\u8eab\u8fb9\u5404\u79cd\u5c0f\u7269\u4ef6\u4fbf\u540c\u65f6\u98de\u8d77\u81f3\u534a\u7a7a\uff0c\u63a5\u7740\u5c31\u5411[npc.Name]\u7838\u53bb\uff01", "", "[npc.Name]\u62ac\u8d77[npc.arms]\uff0c\u8eab\u8fb9\u5404\u79cd\u5c0f\u7269\u4ef6\u4fbf\u540c\u65f6\u98de\u8d77\u81f3\u534a\u7a7a\uff0c\u63a5\u7740\u5c31\u5411\u4f60\u7838\u6765\uff01", "[npc.Name]\u62ac\u8d77[npc.arms]\uff0c\u8eab\u8fb9\u5404\u79cd\u5c0f\u7269\u4ef6\u4fbf\u540c\u65f6\u98de\u8d77\u81f3\u534a\u7a7a\uff0c\u63a5\u7740\u5c31\u5411[npc2.name]\u7838\u53bb\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
            if (isHit) {
                target.removeStatusEffect(StatusEffect.TELEKENETIC_SHOWER);
                target.removeStatusEffect(StatusEffect.TELEKENETIC_SHOWER_PRECISION_STRIKES);
                target.removeStatusEffect(StatusEffect.TELEKENETIC_SHOWER_UNSEEN_FORCE);
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    STONE_SHELL(false, SpellSchool.EARTH, SpellType.DEFENSIVE_STATUS_EFFECT, DamageType.PHYSICAL, true, "\u78d0\u77f3\u4e4b\u58f3", "stone_shell", "\u5728\u76ee\u6807\u5468\u56f4\u53ec\u5524\u4e00\u5c42\u7528\u4e8e\u4fdd\u62a4\u7684\u78d0\u77f3\u3002", 0, DamageVariance.LOW, 25, null, Util.newArrayListOfValues(SpellUpgrade.STONE_SHELL_1, SpellUpgrade.STONE_SHELL_2, SpellUpgrade.STONE_SHELL_3), Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Integer>(Attribute.RESISTANCE_PHYSICAL, 5)), Util.newArrayListOfValues("\u6301\u7eed[style.colourGood(3\u56de\u5408)]")){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null) {
                if (caster.hasSpellUpgrade(SpellUpgrade.STONE_SHELL_3)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.STONE_SHELL_EXPLOSIVE_FINISH, 3));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.STONE_SHELL_2)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.STONE_SHELL_HARDENED_CARAPACE, 3));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.STONE_SHELL_1)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.STONE_SHELL_SHIFTING_SANDS, 3));
                }
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.STONE_SHELL, 3));
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u53ec\u5524\u4e00\u9053\u62a4\u76fe\u6765\u4fdd\u62a4\u4f60\u7684\u76ee\u6807";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u661f\u8fb0\u4e4b\u529b\u7684\u7981\u9522\u5df2\u7ecf\u7ed3\u675f\uff01\u6211\u5c06\u91ca\u653e\u529b\u91cf\uff0c\u5927\u5730\u4e5f\u5c06\u542c\u4ece[npc.master]\u7684\u53ec\u5524\uff01"), "\u4f60\u4f38\u51fa[pc.hand]\u5411\u524d\u4e00\u7529\uff0c\u4fbf\u53ec\u5524\u51fa\u6f02\u6d6e\u7684\u77f3\u76fe\uff0c\u4ece\u63a5\u4e0b\u6765\u7684\u653b\u51fb\u4e2d\u4fdd\u62a4\u7740\u4f60\uff01", "\u4f60\u4f38\u51fa[pc.hand]\u5411\u524d\u4e00\u7529\uff0c\u4fbf\u53ec\u5524\u51fa\u6f02\u6d6e\u7684\u77f3\u76fe\uff0c\u4ece\u63a5\u4e0b\u6765\u7684\u653b\u51fb\u4e2d\u4fdd\u62a4\u7740[npc.Name]\uff01", "[npc.Name]\u4f38\u51fa[npc.hand]\u5411\u524d\u4e00\u7529\uff0c\u4fbf\u53ec\u5524\u51fa\u6f02\u6d6e\u7684\u77f3\u76fe\uff0c\u4ece\u63a5\u4e0b\u6765\u7684\u653b\u51fb\u4e2d\u4fdd\u62a4\u7740[npc.herHim]\uff01", "[npc.Name]\u4f38\u51fa[npc.hand]\u5411\u524d\u4e00\u7529\uff0c\u4fbf\u53ec\u5524\u51fa\u6f02\u6d6e\u7684\u77f3\u76fe\uff0c\u4ece\u63a5\u4e0b\u6765\u7684\u653b\u51fb\u4e2d\u4fdd\u62a4\u7740\u4f60\uff01", "[npc.Name]\u4f38\u51fa[npc.hand]\u5411\u524d\u4e00\u7529\uff0c\u4fbf\u53ec\u5524\u51fa\u6f02\u6d6e\u7684\u77f3\u76fe\uff0c\u4ece\u63a5\u4e0b\u6765\u7684\u653b\u51fb\u4e2d\u4fdd\u62a4\u7740[npc2.name]\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
            if (isHit) {
                descriptionSB.append(target.removeStatusEffectCombat(StatusEffect.STONE_SHELL_EXPLOSIVE_FINISH));
                target.removeStatusEffect(StatusEffect.STONE_SHELL_HARDENED_CARAPACE);
                target.removeStatusEffect(StatusEffect.STONE_SHELL_SHIFTING_SANDS);
                target.removeStatusEffect(StatusEffect.PROTECTIVE_GUSTS);
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    ELEMENTAL_EARTH(false, SpellSchool.EARTH, SpellType.SUMMON, DamageType.PHYSICAL, false, "\u5143\u7d20\u4e4b\u571f", "elemental_earth", "\u5c06\u5143\u7d20\u4f53\u4e0e\u5927\u5730\u5b66\u6d3e\u7ed1\u5b9a\uff0c\u53ec\u5524\u51fa\u5b9e\u4f53\u5f62\u6001\u7684\u571f\u5143\u7d20\u3002", 0, DamageVariance.LOW, 200, null, Util.newArrayListOfValues(SpellUpgrade.ELEMENTAL_EARTH_1, SpellUpgrade.ELEMENTAL_EARTH_2, SpellUpgrade.ELEMENTAL_EARTH_3A, SpellUpgrade.ELEMENTAL_EARTH_3B), null, Util.newArrayListOfValues("\u4ee5[style.colourArcane(\u5143\u7d20)]\u7684\u5f62\u6001\u53ec\u5524[style.colourSchoolAir(\u571f)]")){

        @Override
        public Util.Value<Boolean, String> getSpellCastOutOfCombatDescription(GameCharacter owner, GameCharacter target) {
            if (!owner.hasSpell(this)) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u6ca1\u6709\u5b66\u4f1a\u8be5\u6cd5\u672f\uff0c\u6240\u4ee5\u65e0\u6cd5\u91ca\u653e\uff01", new ParserTag[0]));
            }
            if (owner.isCaptive()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u88ab\u4fd8\u864f\u65f6\u65e0\u6cd5\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            if (Main.game.isInCombat()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u6218\u6597\u4e2d\u53ea\u80fd\u4ee5\u6218\u6597\u52a8\u4f5c\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            if (!Main.game.isSavedDialogueNeutral() && Main.game.getCurrentDialogueNode() == SpellManagement.CHARACTER_SPELLS_EARTH && SpellManagement.getDialogueReturn().getDialogueNodeType() != DialogueNodeType.OCCUPANT_MANAGEMENT) {
                return new Util.Value<Boolean, String>(false, "\u53ea\u80fd\u5728\u4e2d\u7acb\u573a\u666f\u91ca\u653e\u6cd5\u672f\uff01");
            }
            if (owner.getMana() < this.getModifiedCost(owner)) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u9700\u8981\u81f3\u5c11<b>" + this.getModifiedCost(owner) + "</b>[style.boldMana(\u7075\u6c14)]\u624d\u80fd\u91ca\u653e\u8be5\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            String description = owner.isPlayer() ? "\u5c06\u5143\u7d20\u4f53\u4e0e\u5927\u5730\u5b66\u6d3e\u7ed1\u5b9a\u540e\u53ec\u5524\uff01" : "\u8ba9[npc.name]\u5c06\u5143\u7d20\u4f53\u4e0e\u5927\u5730\u5b66\u6d3e\u7ed1\u5b9a\u540e\u53ec\u5524\uff01";
            String cost = "\u5c06\u6d88\u8017<b>" + this.getModifiedCost(owner) + "</b>[style.boldMana(\u7075\u6c14)]\uff01";
            return new Util.Value<Boolean, String>(true, UtilText.parse(owner, description + "<br/>" + cost, new ParserTag[0]));
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u4ee5\u5927\u5730\u7684\u5f62\u6001\u53ec\u5524\u5143\u7d20\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            boolean elementalAlreadySummoned = false;
            if (!caster.hasDiscoveredElemental()) {
                caster.createElemental();
            } else {
                elementalAlreadySummoned = caster.isElementalSummoned();
            }
            caster.setElementalSummoned(true);
            caster.getElemental().setElementalSchool(SpellSchool.EARTH);
            if (elementalAlreadySummoned) {
                descriptionSB.append(UtilText.parse(caster, caster.getElemental(), (caster.hasTraitActivated(Perk.CHUUNI) ? Util.randomItemFrom(Util.newArrayListOfValues("[npc.speech(\u7802\u77f3\u7684\u53e4\u8001\u4eea\u5f0f\u4e0b\uff0c\u6211\u53ec\u5524\u51fa\u90a3\u5730\u9707\uff01\u56de\u5e94\u4f60[npc.master]\u7684\u53ec\u5524\u5427\uff0c[npc2.name]\uff0c\u7ecf\u5386\u767e\u4e07\u4f4d\u9762\u7684\u51b2\u649e\uff0c\u670d\u4ece\u6211\u7684\u610f\u5fd7\uff01)] ", "[npc.speech(\u613f\u5c01\u5370\u4e8e\u6211\u4f53\u5185\u6570\u5343\u8f7d\u7684\u529b\u91cf\u4e00\u671d\u8ff8\u53d1\uff01\u901a\u8fc7\u6c38\u6052\u7684\u94fe\u63a5\uff0c\u6211\u5411\u5927\u5730\u53d1\u51fa\u53ec\u5524\uff0c\u51fa\u6765\u5427\uff0c[npc2.name]\uff01)] ", "[npc.speech(\u8ba9\u5730\u9762\u9707\u52a8\uff0c\u613f\u6211\u4f53\u5185\u7684\u529b\u91cf\u8ff8\u53d1\u800c\u51fa\u5427\uff01\u5de8\u77f3\u4e0e\u7fa4\u5c71\uff0c\u8fd9\u662f[npc.master]\u7684\u53ec\u5524\uff01\u670d\u4ece\u6211\uff0c\u73b0\u8eab\u5427\uff0c[npc2.name]\uff01)] ")) : "") + (caster.isPlayer() ? "\u968f\u7740\u5ca9\u77f3\u4e0e\u74e6\u783e\u7684\u649e\u51fb\u58f0\uff0c\u4f60\u5c06\u5143\u7d20\u4f53[npc2.name]\u4e0e\u5927\u5730\u5b66\u6d3e\u7ed1\u5b9a\uff01" : "\u968f\u7740\u5ca9\u77f3\u4e0e\u74e6\u783e\u7684\u649e\u51fb\u58f0\uff0c[npc1.name]\u5c06\u5143\u7d20\u4f53[npc2.name]\u4e0e\u5927\u5730\u5b66\u6d3e\u7ed1\u5b9a\uff01"), new ParserTag[0]));
            } else {
                descriptionSB.append(UtilText.parse(caster, caster.getElemental(), (caster.hasTraitActivated(Perk.CHUUNI) ? Util.randomItemFrom(Util.newArrayListOfValues("[npc.speech(\u7802\u77f3\u7684\u53e4\u8001\u4eea\u5f0f\u4e0b\uff0c\u6211\u53ec\u5524\u51fa\u90a3\u5730\u9707\uff01\u56de\u5e94\u4f60[npc.master]\u7684\u53ec\u5524\u5427\uff0c[npc2.name]\uff0c\u7ecf\u5386\u767e\u4e07\u4f4d\u9762\u7684\u51b2\u649e\uff0c\u670d\u4ece\u6211\u7684\u610f\u5fd7\uff01)] ", "[npc.speech(\u613f\u5c01\u5370\u4e8e\u6211\u4f53\u5185\u6570\u5343\u8f7d\u7684\u529b\u91cf\u4e00\u671d\u8ff8\u53d1\uff01\u901a\u8fc7\u6c38\u6052\u7684\u94fe\u63a5\uff0c\u6211\u5411\u5927\u5730\u53d1\u51fa\u53ec\u5524\uff0c\u51fa\u6765\u5427\uff0c[npc2.name]\uff01)] ", "[npc.speech(\u8ba9\u5730\u9762\u9707\u52a8\uff0c\u613f\u6211\u4f53\u5185\u7684\u529b\u91cf\u8ff8\u53d1\u800c\u51fa\u5427\uff01\u5de8\u77f3\u4e0e\u7fa4\u5c71\uff0c\u8fd9\u662f[npc.master]\u7684\u53ec\u5524\uff01\u670d\u4ece\u6211\uff0c\u73b0\u8eab\u5427\uff0c[npc2.name]\uff01)] ")) : "") + (caster.isPlayer() ? "\u968f\u7740\u5ca9\u77f3\u4e0e\u74e6\u783e\u7684\u649e\u51fb\u58f0\uff0c\u4f60\u53ec\u5524\u51fa\u5143\u7d20\u4f53[npc2.name]\uff0c\u5e76\u4e0e\u5927\u5730\u5b66\u6d3e\u7ed1\u5b9a\uff01" : "\u968f\u7740\u5ca9\u77f3\u4e0e\u74e6\u783e\u7684\u649e\u51fb\u58f0\uff0c[npc1.name]\u53ec\u5524\u51fa\u5143\u7d20\u4f53[npc2.name]\uff0c\u5e76\u4e0e\u5927\u5730\u5b66\u6d3e\u7ed1\u5b9a\uff01"), new ParserTag[0]));
                if (Main.game.isInCombat()) {
                    caster.getElemental().setLocation(caster, false);
                    if (caster.isPlayer() || Main.combat.getAllies(Main.game.getPlayer()).contains(caster)) {
                        Main.combat.addAlly(caster.getElemental());
                    } else {
                        Main.combat.addEnemy(caster.getElemental());
                    }
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    ARCANE_AROUSAL(false, SpellSchool.ARCANE, SpellType.OFFENSIVE, DamageType.LUST, false, "\u5965\u672f\u72c2\u6b32", "arcane_arousal", "\u4f7f\u76ee\u6807\u770b\u5230\u4e00\u6bb5\u7531\u5965\u672f\u6784\u6210\u7684\u6fc0\u60c5\u753b\u9762\u3002", 15, DamageVariance.LOW, 50, null, Util.newArrayListOfValues(SpellUpgrade.ARCANE_AROUSAL_1, SpellUpgrade.ARCANE_AROUSAL_2, SpellUpgrade.ARCANE_AROUSAL_3), null, null){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null) {
                if (caster.hasSpellUpgrade(SpellUpgrade.ARCANE_AROUSAL_3)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.ARCANE_AROUSAL_DIRTY_PROMISES, 3));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.ARCANE_AROUSAL_2)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.ARCANE_AROUSAL_LUSTFUL_DISTRACTION, 2));
                }
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public int getDamage(GameCharacter caster) {
            if (caster != null && caster.hasSpellUpgrade(SpellUpgrade.ARCANE_AROUSAL_1)) {
                return 30;
            }
            return 15;
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return this.getFormattedSpellDamageRange(caster, target, enemies, allies);
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float damage = Attack.calculateSpellDamage(caster, target, this.damageType, this.getDamage(caster), this.damageVariance, isCritical);
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u4ee5\u5965\u672f\u6700\u672c\u8d28\u7684\u9762\u8c8c\uff0c\u6211\u8981\u4ee5\u8389\u8389\u4e1d\u7684\u795e\u8a00\u52a0\u4e4b\u4f60\u8eab\uff01\u770b\u54ea\uff0c\u8fd9\u5c31\u662f\u80c6\u6562\u76f4\u89c6\u6211\u7684\u82b8\u82b8\u4f17\u751f\u7684\u547d\u8fd0\uff01"), "\u4f60\u96c6\u4e2d\u5965\u672f\u80fd\u91cf\uff0c\u5728\u81ea\u5df1\u8111\u5185\u6295\u5c04\u4e86\u4e00\u526f\u6fc0\u60c5\u7684\u753b\u9762\u3002", "\u4f60\u96c6\u4e2d\u5965\u672f\u80fd\u91cf\uff0c\u5728[npc.namePos]\u8111\u5185\u6295\u5c04\u4e86\u4e00\u526f\u6fc0\u60c5\u7684\u753b\u9762\u3002", "", "[npc.Name]\u96c6\u4e2d\u5965\u672f\u80fd\u91cf\uff0c\u5728\u4f60\u8111\u5185\u6295\u5c04\u4e86\u4e00\u526f\u6fc0\u60c5\u7684\u753b\u9762\uff01", "[npc.Name]\u96c6\u4e2d\u5965\u672f\u80fd\u91cf\uff0c\u5728[npc2.namePos]\u8111\u5185\u6295\u5c04\u4e86\u4e00\u526f\u6fc0\u60c5\u7684\u753b\u9762\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, damage, isHit, isCritical));
            if (isHit) {
                if (damage > 0.0f) {
                    descriptionSB.append(target.incrementLust(damage, true));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.ARCANE_AROUSAL_2)) {
                    target.removeStatusEffect(StatusEffect.ARCANE_AROUSAL_DIRTY_PROMISES);
                    target.removeStatusEffect(StatusEffect.ARCANE_AROUSAL_LUSTFUL_DISTRACTION);
                    this.applyStatusEffects(caster, target, isCritical);
                    descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    TELEPATHIC_COMMUNICATION(false, SpellSchool.ARCANE, SpellType.DEFENSIVE_STATUS_EFFECT, DamageType.PHYSICAL, true, "\u5fc3\u7075\u4f4e\u8bed", "telepathic_communication", "\u65bd\u6cd5\u8005\u5411\u76ee\u6807\u7684\u8111\u6d77\u4e2d\u6295\u5c04\u4e00\u6bb5\u9b45\u60d1\u4e4b\u58f0\u3002", 0, DamageVariance.LOW, 75, null, Util.newArrayListOfValues(SpellUpgrade.TELEPATHIC_COMMUNICATION_1, SpellUpgrade.TELEPATHIC_COMMUNICATION_2, SpellUpgrade.TELEPATHIC_COMMUNICATION_3), Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Integer>(Attribute.DAMAGE_LUST, 15)), Util.newArrayListOfValues("\u6301\u7eed[style.colourGood(5\u56de\u5408)]")){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null) {
                if (caster.hasSpellUpgrade(SpellUpgrade.TELEPATHIC_COMMUNICATION_3)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION, 10));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.TELEPATHIC_COMMUNICATION_2)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPATHIC_COMMUNICATION_PROJECTED_TOUCH, 10));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.TELEPATHIC_COMMUNICATION_1)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPATHIC_COMMUNICATION, 10));
                }
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPATHIC_COMMUNICATION, 5));
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u76f4\u63a5\u5728\u76ee\u6807\u8111\u5185\u53d1\u51fa\u4f4e\u8bed\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u6211\u9a7e\u9a6d\u7740\u6240\u6709\u4f4d\u9762\uff0c\u800c\u5982\u4eca\u5c06\u52a8\u6447\u65f6\u7a7a\u7684\u754c\u9650\uff01\u82cd\u7a79\u4e5f\u5f53\u8046\u542c\u6211\u7684\u58f0\u97f3\uff0c\u5e76\u6df1\u9677\u7edd\u671b\uff01"), "\u4f60\u96c6\u4e2d\u5965\u672f\u80fd\u91cf\uff0c\u4f7f\u5f97\u81ea\u5df1\u7684\u601d\u60f3\u80fd\u591f\u76f4\u63a5\u6295\u5c04\u5230\u4ed6\u4eba\u7684\u8111\u5185\uff01", "\u4f60\u96c6\u4e2d\u5965\u672f\u80fd\u91cf\uff0c\u4f7f\u5f97[npc.namePos]\u7684\u601d\u60f3\u80fd\u591f\u76f4\u63a5\u6295\u5c04\u5230\u4ed6\u4eba\u7684\u8111\u5185\uff01", "[npc.Name]\u96c6\u4e2d\u5965\u672f\u80fd\u91cf\uff0c\u4f7f\u5f97\u81ea\u5df1\u7684\u601d\u60f3\u80fd\u591f\u76f4\u63a5\u6295\u5c04\u5230\u4ed6\u4eba\u7684\u8111\u5185\uff01", "[npc.Name]\u96c6\u4e2d\u5965\u672f\u80fd\u91cf\uff0c\u4f7f\u5f97\u4f60\u7684\u601d\u60f3\u80fd\u591f\u76f4\u63a5\u6295\u5c04\u5230\u4ed6\u4eba\u7684\u8111\u5185\uff01", "[npc1.name]\u96c6\u4e2d\u5965\u672f\u80fd\u91cf\uff0c\u4f7f\u5f97[npc2.namePos]\u7684\u601d\u60f3\u80fd\u591f\u76f4\u63a5\u6295\u5c04\u5230\u4ed6\u4eba\u7684\u8111\u5185\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
            if (isHit) {
                target.removeStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_PROJECTED_TOUCH);
                target.removeStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION);
                target.removeStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION);
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    ARCANE_CLOUD(false, SpellSchool.ARCANE, SpellType.OFFENSIVE_STATUS_EFFECT, DamageType.LUST, false, "\u5965\u672f\u4e4b\u4e91", "arcane_cloud", "\u5728\u76ee\u6807\u7684\u5934\u9876\u53ec\u5524\u4e00\u80a1\u5145\u6ee1\u5965\u672f\u7684\u98ce\u66b4\u3002", 0, DamageVariance.LOW, 150, null, Util.newArrayListOfValues(SpellUpgrade.ARCANE_CLOUD_1, SpellUpgrade.ARCANE_CLOUD_2, SpellUpgrade.ARCANE_CLOUD_3), Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Integer>(Attribute.RESISTANCE_LUST, -25)), Util.newArrayListOfValues("\u6301\u7eed[style.colourGood(3\u56de\u5408)]")){

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null) {
                if (caster.hasSpellUpgrade(SpellUpgrade.ARCANE_CLOUD_3)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.ARCANE_CLOUD_LOCALISED_STORM, 3));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.ARCANE_CLOUD_2)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.ARCANE_CLOUD_ARCANE_THUNDER, 3));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.ARCANE_CLOUD_1)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.ARCANE_CLOUD_ARCANE_LIGHTNING, 3));
                }
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.ARCANE_CLOUD, 3));
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u5728\u76ee\u6807\u5934\u9876\u53ec\u5524\u4e00\u56e2\u5965\u672f\u4e4b\u4e91\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u554a\uff0c\u538b\u6291\u7740\u6211\u65e0\u7a77\u529b\u91cf\u7684\u9ed1\u6697\u5c01\u5370\uff0c\u5982\u4eca\u5df2\u7ecf\u7070\u98de\u70df\u706d\uff01\u73b0\u8eab\u5427\uff0c\u5965\u672f\u4e4b\u6e90\uff0c\u4e3a\u6211\u7684\u654c\u4eba\u9001\u4e0a\u6700\u7ec8\u5ba1\u5224\u5427\uff01"), "\u4f60\u9ad8\u6325[pc.arm]\uff0c\u5728\u4f60\u81ea\u5df1\u5934\u9876\u53ec\u5524\u51fa\u4e00\u56e2\u5965\u672f\u4e4b\u4e91\uff01", "\u4f60\u9ad8\u6325[pc.arm]\uff0c\u5728[npc.namePos]\u5934\u9876\u53ec\u5524\u51fa\u4e00\u56e2\u5965\u672f\u4e4b\u4e91\uff01", "", "[npc.Name]\u9ad8\u6325[npc.arm]\uff0c\u5728\u4f60\u5934\u9876\u53ec\u5524\u51fa\u4e00\u56e2\u5965\u672f\u4e4b\u4e91\uff01", "[npc.Name]\u9ad8\u6325[npc.arm]\uff0c\u5728[npc2.namePos]\u5934\u9876\u53ec\u5524\u51fa\u4e00\u56e2\u5965\u672f\u4e4b\u4e91\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
            if (isHit) {
                target.removeStatusEffect(StatusEffect.ARCANE_CLOUD_LOCALISED_STORM);
                target.removeStatusEffect(StatusEffect.ARCANE_CLOUD_ARCANE_THUNDER);
                target.removeStatusEffect(StatusEffect.ARCANE_CLOUD_ARCANE_LIGHTNING);
                target.removeStatusEffect(StatusEffect.ARCANE_CLOUD);
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    CLEANSE(true, SpellSchool.ARCANE, SpellType.DEFENSIVE_STATUS_EFFECT_CLEAR, DamageType.PHYSICAL, true, "\u51c0\u5316\u672f", "cleanse", "\u4e00\u80a1\u5965\u672f\u80fd\u91cf\u7684\u6ce2\u52a8\u5411\u76ee\u6807\u88ad\u53bb\uff0c\u79fb\u9664\u5bf9\u65b9\u6240\u6709\u7684\u72b6\u6001\u6548\u679c\u3002", 0, DamageVariance.LOW, 200, null, Util.newArrayListOfValues(SpellUpgrade.CLEANSE_1, SpellUpgrade.CLEANSE_2, SpellUpgrade.CLEANSE_3), null, Util.newArrayListOfValues("\u4ece\u76ee\u6807\u76df\u53cb\u6216\u654c\u4eba\u8eab\u4e0a[style.colourGood(\u79fb\u9664\u6240\u6709)]", "\u6218\u6597\u72b6\u6001\u6548\u679c")){

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u4ece\u76ee\u6807\u76df\u53cb\u548c\u654c\u4eba\u8eab\u4e0a\u79fb\u9664\u6240\u6709\u6218\u6597\u72b6\u6001\u6548\u679c\u3002";
        }

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null && Main.game.isInCombat()) {
                AbstractStatusEffect effect = StatusEffect.ARCANE_DUALITY_POSITIVE;
                if (Main.combat.getEnemies(caster).contains(target)) {
                    effect = StatusEffect.ARCANE_DUALITY_NEGATIVE;
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.CLEANSE_3)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(effect, 6));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.CLEANSE_2)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(effect, 3));
                }
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u4ee5\u8389\u8389\u4e1d\u4e4b\u529b\uff0c\u6211\u5c06\u6253\u7834\u4e16\u754c\u7684\u5e7b\u8c61\uff01\u788e\u88c2\u5427\uff0c\u65f6\u95f4\u4e0e\u7a7a\u95f4\uff0c\u6211\u7684\u5965\u672f\u5c06\u4e3b\u5bb0\u4e00\u5207\uff0c\u73b0\u5b9e\u4e5f\u5c06\u4e3a\u4e4b\u626d\u66f2\uff01"), "\u4f60\u4f38\u51fa[pc.hand]\u5411\u524d\u4e00\u7529\uff0c\u4fbf\u5728\u81ea\u5df1\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u9635\u7206\u70b8\uff0c\u5145\u6ee1\u4e86\u51c0\u5316\u7684\u5965\u672f\u80fd\u91cf\uff01", "\u4f60\u4f38\u51fa[pc.hand]\u5411\u524d\u4e00\u7529\uff0c\u4fbf\u5728[npc.Name]\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u9635\u7206\u70b8\uff0c\u5145\u6ee1\u4e86\u51c0\u5316\u7684\u5965\u672f\u80fd\u91cf\uff01", "[npc.Name]\u4f38\u51fa[npc.hand]\u5411\u524d\u4e00\u7529\uff0c\u4fbf\u5728\u81ea\u5df1\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u9635\u7206\u70b8\uff0c\u5145\u6ee1\u4e86\u51c0\u5316\u7684\u5965\u672f\u80fd\u91cf\uff01", "[npc.Name]\u4f38\u51fa[npc.hand]\u5411\u524d\u4e00\u7529\uff0c\u4fbf\u5728\u4f60\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u9635\u7206\u70b8\uff0c\u5145\u6ee1\u4e86\u51c0\u5316\u7684\u5965\u672f\u80fd\u91cf\uff01", "[npc.Name]\u4f38\u51fa[npc.hand]\u5411\u524d\u4e00\u7529\uff0c\u4fbf\u5728[npc2.name]\u8eab\u8fb9\u53ec\u5524\u51fa\u4e00\u9635\u7206\u70b8\uff0c\u5145\u6ee1\u4e86\u51c0\u5316\u7684\u5965\u672f\u80fd\u91cf\uff01"));
            descriptionSB.append(UtilText.parse(this.getPreferredTarget(caster, enemies, allies), "\u90a3\u80a1\u80fd\u91cf\u968f\u540e\u4fbf\u55b7\u5c04\u5411[npc.Name]\u5468\u56f4\uff0c\u5f15\u53d1\u4e86\u7206\u70b8\uff01", new ParserTag[0]));
            if (isHit) {
                ArrayList<AbstractStatusEffect> effectsToRemove = new ArrayList<AbstractStatusEffect>();
                for (AbstractStatusEffect se : target.getStatusEffects()) {
                    if (!se.isCombatEffect() || (se.getBeneficialStatus() != EffectBenefit.BENEFICIAL || caster.hasSpellUpgrade(SpellUpgrade.CLEANSE_1)) && se.getBeneficialStatus() == EffectBenefit.BENEFICIAL) continue;
                    effectsToRemove.add(se);
                }
                for (AbstractStatusEffect se : effectsToRemove) {
                    descriptionSB.append(target.removeStatusEffectCombat(se));
                }
                effectsToRemove.clear();
                for (AbstractStatusEffect se : this.getPreferredTarget(caster, enemies, allies).getStatusEffects()) {
                    if (!se.isCombatEffect() || se.getBeneficialStatus() != EffectBenefit.BENEFICIAL && (se.getBeneficialStatus() == EffectBenefit.BENEFICIAL || caster.hasSpellUpgrade(SpellUpgrade.CLEANSE_1))) continue;
                    effectsToRemove.add(se);
                }
                for (AbstractStatusEffect se : effectsToRemove) {
                    descriptionSB.append(this.getPreferredTarget(caster, enemies, allies).removeStatusEffectCombat(se));
                }
                descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    STEAL(true, SpellSchool.ARCANE, SpellType.MISC, DamageType.PHYSICAL, false, "\u7a83\u53d6\u672f", "steal", "\u4f20\u9001\u672f\u7684\u4f4e\u9636\u5f62\u6001\uff0c\u8be5\u6cd5\u672f\u5141\u8bb8\u65bd\u6cd5\u8005\u4ece\u5bf9\u65b9\u7684\u7269\u54c1\u680f\u4e2d\u5077\u53d6\u4e00\u4ef6\u7269\u54c1\u3002", 0, DamageVariance.LOW, 100, null, Util.newArrayListOfValues(SpellUpgrade.STEAL_1, SpellUpgrade.STEAL_2, SpellUpgrade.STEAL_3A, SpellUpgrade.STEAL_3B), null, Util.newArrayListOfValues("\u4ece\u76ee\u6807\u7684\u7269\u54c1\u680f\u4e2d[style.colourExcellent(\u5077\u53d6)]\u968f\u673a\u7269\u54c1")){

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u7a83\u53d6\u76ee\u6807\u7684\u7269\u54c1\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u4ea4\u7ec7\u7684\u65f6\u7a7a\u4e5f\u5c06\u542c\u6211\u53f7\u4ee4\uff01\u5b87\u5b99\u4f4d\u9762\uff0c\u670d\u4ece\u6211\u7684\u547d\u4ee4\u5427\uff0c\u4ec7\u654c\u4e4b\u7269\u5c06\u5f52\u6211\u6240\u6709\uff01"), "\u4f60\u4f38\u51fa[pc.hand]\u5411\u524d\u4e00\u7529\uff0c\u7136\u540e\u6525\u7d27\u4e86\u62f3\u5934\uff0c\u4fbf\u5c06\u5965\u672f\u80fd\u91cf\u4f20\u5bfc\u51fa\u53bb\uff0c\u5077\u53d6\u4e86\u4e00\u4ef6\u4f60\u81ea\u5df1\u7684\u7269\u54c1\u2026\u2026", "\u4f60\u4f38\u51fa[pc.hand]\u5411\u524d\u4e00\u7529\uff0c\u7136\u540e\u6525\u7d27\u4e86\u62f3\u5934\uff0c\u4fbf\u5c06\u5965\u672f\u80fd\u91cf\u4f20\u5bfc\u51fa\u53bb\uff0c\u5077\u53d6\u4e86\u4e00\u4ef6[npc.namePos]\u7684\u7269\u54c1\uff01", "", "[npc.Name]\u4f38\u51fa[npc.hand]\u5411\u524d\u4e00\u7529\uff0c\u7136\u540e\u6525\u7d27\u4e86\u62f3\u5934\uff0c\u4fbf\u5c06\u5965\u672f\u80fd\u91cf\u4f20\u5bfc\u51fa\u53bb\uff0c\u5077\u53d6\u4e86\u4e00\u4ef6\u4f60\u7684\u7269\u54c1\uff01", "[npc.Name]\u4f38\u51fa[npc.hand]\u5411\u524d\u4e00\u7529\uff0c\u7136\u540e\u6525\u7d27\u4e86\u62f3\u5934\uff0c\u4fbf\u5c06\u5965\u672f\u80fd\u91cf\u4f20\u5bfc\u51fa\u53bb\uff0c\u5077\u53d6\u4e86\u4e00\u4ef6[npc2.namePos]\u7684\u7269\u54c1\uff01"));
            if (isHit) {
                boolean stealItem = false;
                boolean mainWeaponSteal = false;
                boolean offhandWeaponSteal = false;
                AbstractClothing clothingToSteal = null;
                if (caster.hasSpellUpgrade(SpellUpgrade.STEAL_3B) && (clothingToSteal = target.getClothingInSlot(InventorySlot.GROIN)) != null && !clothingToSteal.isSealed()) {
                    target.forceUnequipClothingIntoVoid(caster, clothingToSteal);
                    descriptionSB.append("<br/>" + Spell.getCastDescription(caster, target, null, "\u4f60\u7a83\u53d6\u4e86\u81ea\u5df1\u7684" + clothingToSteal.getName() + "\u2026\u2026", "\u4f60\u7a83\u53d6\u4e86[npc.Name]\u6b63\u7a7f\u5728\u8eab\u4e0a\u7684" + clothingToSteal.getName() + "\uff0c\u5bb3[npc.sheIs]\u60ca\u53eb\u4e00\u58f0\uff0c[npc.speech(\u4f60\uff0c\u4f60\u4e2a\u6d41\u6c13\uff01)]", "", "[npc.Name]\u7a83\u53d6\u4e86\u4f60\u6b63\u7a7f\u5728\u8eab\u4e0a\u7684" + clothingToSteal.getName() + "\uff0c\u4f60\u4e0d\u7981\u60ca\u53eb\u4e00\u58f0\uff0c[pc.speech(\u4f60\uff0c\u4f60\u4e2a\u6d41\u6c13\uff01)]", "[npc1.Name]\u7a83\u53d6\u4e86[npc2.name]\u6b63\u7a7f\u5728\u8eab\u4e0a\u7684" + clothingToSteal.getName() + "\uff0c\u5bb3[npc2.sheIs]\u60ca\u53eb\u4e00\u58f0\uff0c[npc2.speech(\u4f60\uff0c\u4f60\u4e2a\u6d41\u6c13\uff01)]") + "<br/>");
                    clothingToSteal.setName(target.getNameIgnoresPlayerKnowledge() + "'" + clothingToSteal.getName());
                    descriptionSB.append(caster.addClothing(clothingToSteal, true));
                }
                if (clothingToSteal == null) {
                    int i;
                    if (caster.hasSpellUpgrade(SpellUpgrade.STEAL_3A)) {
                        ArrayList<AbstractClothing> nonSealedClothing = new ArrayList<AbstractClothing>();
                        for (AbstractClothing c : target.getClothingCurrentlyEquipped()) {
                            if (c.isSealed()) continue;
                            nonSealedClothing.add(c);
                        }
                        if (!nonSealedClothing.isEmpty()) {
                            clothingToSteal = (AbstractClothing)nonSealedClothing.get(Util.random.nextInt(nonSealedClothing.size()));
                        }
                    } else if (caster.hasSpellUpgrade(SpellUpgrade.STEAL_1)) {
                        ArrayList<AbstractClothing> nonSealedOuterClothing = new ArrayList<AbstractClothing>();
                        for (AbstractClothing c : target.getClothingCurrentlyEquipped()) {
                            if (c.isSealed() || !target.isAbleToUnequip(c, false, target)) continue;
                            nonSealedOuterClothing.add(c);
                        }
                        if (!nonSealedOuterClothing.isEmpty()) {
                            clothingToSteal = (AbstractClothing)nonSealedOuterClothing.get(Util.random.nextInt(nonSealedOuterClothing.size()));
                        }
                    }
                    int mainWeaponIndex = 0;
                    AbstractWeapon mainWeapon = null;
                    int offhandWeaponIndex = 0;
                    AbstractWeapon offhandWeapon = null;
                    ArrayList<Integer> weaponIndexes = new ArrayList<Integer>();
                    for (i = 0; i < target.getMainWeaponArray().length; ++i) {
                        if (target.getMainWeapon(i) == null) continue;
                        weaponIndexes.add(i);
                    }
                    if (!weaponIndexes.isEmpty()) {
                        mainWeaponIndex = (Integer)Util.randomItemFrom(weaponIndexes);
                        mainWeapon = target.getMainWeapon(mainWeaponIndex);
                    }
                    weaponIndexes = new ArrayList();
                    for (i = 0; i < target.getOffhandWeaponArray().length; ++i) {
                        if (target.getOffhandWeapon(i) == null) continue;
                        weaponIndexes.add(i);
                    }
                    if (!weaponIndexes.isEmpty()) {
                        offhandWeaponIndex = (Integer)Util.randomItemFrom(weaponIndexes);
                        offhandWeapon = target.getOffhandWeapon(offhandWeaponIndex);
                    }
                    if (caster.hasSpellUpgrade(SpellUpgrade.STEAL_2)) {
                        mainWeaponSteal = mainWeapon != null;
                        offhandWeaponSteal = offhandWeapon != null;
                    }
                    stealItem = target.getInventorySlotsTaken() > 0;
                    double rnd = Math.random();
                    if (mainWeaponSteal && (rnd < 0.2 || !offhandWeaponSteal && !stealItem && clothingToSteal == null)) {
                        target.unequipMainWeapon(mainWeaponIndex, true, target.isPlayer());
                        descriptionSB.append("<br/>" + Spell.getCastDescription(caster, target, null, "\u4f60\u7a83\u53d6\u4e86\u81ea\u5df1\u7684" + mainWeapon.getName() + "\u2026\u2026", "\u4f60\u4ece[npc.namePos]\u7684[npc.hands]\u4e0a\u7a83\u53d6\u4e86" + mainWeapon.getName() + "\uff01", "", "[npc.Name]\u4ece\u4f60\u7684[pc.hands]\u4e0a\u7a83\u53d6\u4e86" + mainWeapon.getName() + "\uff01", "[npc1.name]\u4ece[npc2.namePos]\u7684[npc2.hands]\u4e0a\u7a83\u53d6\u4e86" + mainWeapon.getName() + "\uff01") + "<br/>" + caster.addWeapon(mainWeapon, true));
                    } else if (offhandWeaponSteal && (rnd < 0.2 || !stealItem && clothingToSteal == null)) {
                        target.unequipOffhandWeapon(offhandWeaponIndex, true, target.isPlayer());
                        descriptionSB.append("<br/>" + Spell.getCastDescription(caster, target, null, "\u4f60\u7a83\u53d6\u4e86\u81ea\u5df1\u7684" + offhandWeapon.getName() + "\u2026\u2026", "\u4f60\u4ece[npc.namePos]\u7684[npc.hands]\u4e0a\u7a83\u53d6\u4e86" + offhandWeapon.getName() + "\uff01", "", "[npc.Name]\u4ece\u4f60\u7684[pc.hands]\u4e0a\u7a83\u53d6\u4e86" + offhandWeapon.getName() + "\uff01", "[npc1.name]\u4ece[npc2.namePos]\u7684[npc2.hands]\u4e0a\u7a83\u53d6\u4e86" + offhandWeapon.getName() + "\uff01") + "<br/>" + caster.addWeapon(offhandWeapon, true));
                    } else if (stealItem && (rnd < 0.5 || clothingToSteal == null)) {
                        AbstractItem item = null;
                        if (!target.getAllItemsInInventory().isEmpty()) {
                            item = Util.randomItemFrom(target.getAllItemsInInventory().keySet());
                        }
                        AbstractWeapon weapon = null;
                        if (!target.getAllWeaponsInInventory().isEmpty()) {
                            weapon = Util.randomItemFrom(target.getAllWeaponsInInventory().keySet());
                        }
                        AbstractClothing clothing = null;
                        if (!target.getAllClothingInInventory().isEmpty()) {
                            clothing = Util.randomItemFrom(target.getAllClothingInInventory().keySet());
                        }
                        double itemStealRnd = Math.random();
                        if (item != null && (itemStealRnd < 0.33 || weapon == null && clothing == null)) {
                            target.removeItem(item);
                            descriptionSB.append("<br/>" + Spell.getCastDescription(caster, target, null, "\u4f60\u7a83\u53d6\u4e86\u81ea\u5df1\u7684" + item.getName() + "\u2026\u2026", "\u4f60\u4ece[npc.namePos]\u7684\u7269\u54c1\u680f\u7a83\u53d6\u4e86" + item.getName() + "\uff01", "", "[npc.Name]\u4ece\u4f60\u7684\u7269\u54c1\u680f\u7a83\u53d6\u4e86" + item.getName() + "\uff01", "[npc1.Name]\u4ece[npc2.namePos]\u7684\u7269\u54c1\u680f\u7a83\u53d6\u4e86" + item.getName() + "\uff01") + "<br/>" + caster.addItem(item, false));
                        } else if (weapon != null && (itemStealRnd < 0.66 || clothing == null)) {
                            target.removeWeapon(weapon);
                            descriptionSB.append("<br/>" + Spell.getCastDescription(caster, target, null, "\u4f60\u7a83\u53d6\u4e86\u81ea\u5df1\u7684" + weapon.getName() + "\u2026\u2026", "\u4f60\u4ece[npc.namePos]\u7684\u7269\u54c1\u680f\u7a83\u53d6\u4e86" + weapon.getName() + "\uff01", "", "[npc.Name]\u4ece\u4f60\u7684\u7269\u54c1\u680f\u7a83\u53d6\u4e86" + weapon.getName() + "\uff01", "[npc1.Name]\u4ece[npc2.namePos]\u7684\u7269\u54c1\u680f\u7a83\u53d6\u4e86" + weapon.getName() + "\uff01") + "<br/>" + caster.addWeapon(weapon, false));
                        } else {
                            target.removeClothing(clothing);
                            descriptionSB.append("<br/>" + Spell.getCastDescription(caster, target, null, "\u4f60\u7a83\u53d6\u4e86\u81ea\u5df1\u7684" + clothing.getName() + "\u2026\u2026", "\u4f60\u4ece[npc.namePos]\u7684\u7269\u54c1\u680f\u7a83\u53d6\u4e86" + clothing.getName() + "\uff01", "", "[npc.Name]\u4ece\u4f60\u7684\u7269\u54c1\u680f\u7a83\u53d6\u4e86" + clothing.getName() + "\uff01", "[npc1.Name]\u4ece[npc2.namePos]\u7684\u7269\u54c1\u680f\u7a83\u53d6\u4e86" + clothing.getName() + "\uff01") + "<br/>" + caster.addClothing(clothing, false));
                        }
                    } else if (clothingToSteal != null) {
                        target.forceUnequipClothingIntoVoid(caster, clothingToSteal);
                        descriptionSB.append("<br/>" + Spell.getCastDescription(caster, target, null, "\u4f60\u7a83\u53d6\u4e86\u81ea\u5df1\u7684" + clothingToSteal.getName() + "\u2026\u2026", "\u4f60\u7a83\u53d6\u4e86[npc.Name]\u6b63\u7a7f\u5728\u8eab\u4e0a\u7684" + clothingToSteal.getName() + "\uff0c\u5bb3[npc.sheIs]\u60ca\u53eb\u4e00\u58f0\uff01", "", "[npc.Name]\u7a83\u53d6\u4e86\u4f60\u6b63\u7a7f\u5728\u8eab\u4e0a\u7684" + clothingToSteal.getName() + "\uff0c\u4f60\u4e0d\u7981\u60ca\u53eb\u4e00\u58f0\uff01", "[npc1.Name]\u7a83\u53d6\u4e86[npc2.name]\u6b63\u7a7f\u5728\u8eab\u4e0a\u7684" + clothingToSteal.getName() + "\uff0c\u5bb3[npc2.sheIs]\u60ca\u53eb\u4e00\u58f0\uff01") + "<br/>");
                        clothingToSteal.setName(target.getNameIgnoresPlayerKnowledge() + "'" + clothingToSteal.getName());
                        descriptionSB.append(caster.addClothing(clothingToSteal, true));
                    } else {
                        descriptionSB.append("<br/>[style.italicsDisabled(\u6ca1\u6709\u4e1c\u897f\u53ef\u5077\u2026\u2026)]");
                    }
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }

        @Override
        public Map<Integer, List<TreeEntry<SpellSchool, SpellUpgrade>>> getSpellUpgradeTree() {
            return spellStealUpgradeTree;
        }
    }
    ,
    TELEPORT(true, SpellSchool.ARCANE, SpellType.DEFENSIVE_STATUS_EFFECT, DamageType.PHYSICAL, true, "\u4f20\u9001\u672f", "teleport", "\u76ee\u6807\u5c06\u4f1a\u88ab\u4f20\u9001\u81f3\u654c\u4eba\u80cc\u540e\uff0c\u95ea\u907f\u6982\u7387\u5927\u5927\u63d0\u9ad8\u3002", 0, DamageVariance.LOW, 200, null, Util.newArrayListOfValues(SpellUpgrade.TELEPORT_1, SpellUpgrade.TELEPORT_2, SpellUpgrade.TELEPORT_3), Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Integer>(Attribute.ENERGY_SHIELDING, 100)), Util.newArrayListOfValues("\u6301\u7eed[style.colourGood(1\u56de\u5408)]", "[style.colourExcellent(\u89e3\u9501)]\u5730\u56fe\u4f20\u9001", "\u540c\u4f34[style.colourTerrible(\u4f1a\u963b\u788d)]\u5730\u56fe\u4f20\u9001")){

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u4f20\u9001\u81f3\u76ee\u6807\u8eab\u540e\u3002";
        }

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            if (caster != null) {
                if (caster.hasSpellUpgrade(SpellUpgrade.TELEPORT_3)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPORT_ARCANE_ARRIVAL, 2));
                }
                if (caster.hasSpellUpgrade(SpellUpgrade.TELEPORT_1)) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPORT_ARCANE_ARRIVAL, 1));
                }
                return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPORT, 1));
            }
            return new HashMap<AbstractStatusEffect, Integer>();
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            if (caster.hasSpellUpgrade(SpellUpgrade.TELEPORT_2) && !allies.isEmpty()) {
                descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u6211\u5df2\u7136\uff0c\u7a7f\u8d8a\u5343\u767e\u4e2a\u4f4d\u9762\uff0c\u8de8\u8d8a\u4e07\u4ebf\u4e2a\u4f4d\u9762\uff01\u8ddd\u79bb\u4e0e\u65f6\u95f4\u4e0d\u8fc7\u662f\u5e9e\u7136\u5de8\u7269\u524d\u5fae\u4e0d\u8db3\u9053\u7684\u88c5\u9970\uff01"), "\u4f60\u7528\u4e00\u53ea[pc.hands]\u8fc5\u901f\u5207\u5212\u8fc7\u7a7a\u6c14\uff0c\u4fbf\u5c06\u81ea\u5df1\u7684\u76df\u53cb\u90fd\u4f20\u9001\u5230\u4e86\u654c\u4eba\u8eab\u540e\uff01", "\u4f60\u7528\u4e00\u53ea[pc.hands]\u8fc5\u901f\u5207\u5212\u8fc7\u7a7a\u6c14\uff0c\u4fbf\u5c06\u81ea\u5df1\u7684\u76df\u53cb\u90fd\u4f20\u9001\u5230\u4e86\u654c\u4eba\u8eab\u540e\uff01", "[npc.Name]\u7528\u4e00\u53ea[npc.hands]\u8fc5\u901f\u5207\u5212\u8fc7\u7a7a\u6c14\uff0c\u4fbf\u5c06\u81ea\u5df1\u7684\u76df\u53cb\u90fd\u4f20\u9001\u5230\u4e86\u654c\u4eba\u8eab\u540e\uff01", "[npc.Name]\u7528\u4e00\u53ea[npc.hands]\u8fc5\u901f\u5207\u5212\u8fc7\u7a7a\u6c14\uff0c\u4fbf\u5c06\u81ea\u5df1\u7684\u76df\u53cb\u90fd\u4f20\u9001\u5230\u4e86\u654c\u4eba\u8eab\u540e\uff01", "[npc.Name]\u7528\u4e00\u53ea[npc.hands]\u8fc5\u901f\u5207\u5212\u8fc7\u7a7a\u6c14\uff0c\u4fbf\u5c06\u81ea\u5df1\u7684\u76df\u53cb\u90fd\u4f20\u9001\u5230\u4e86\u654c\u4eba\u8eab\u540e\uff01"));
            } else {
                descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u6211\u5df2\u7136\uff0c\u7a7f\u8d8a\u5343\u767e\u4e2a\u4f4d\u9762\uff0c\u8de8\u8d8a\u4e07\u4ebf\u4e2a\u4f4d\u9762\uff01\u8ddd\u79bb\u4e0e\u65f6\u95f4\u4e0d\u8fc7\u662f\u5e9e\u7136\u5de8\u7269\u524d\u5fae\u4e0d\u8db3\u9053\u7684\u88c5\u9970\uff01"), "\u4f60\u7528\u4e00\u53ea[pc.hands]\u8fc5\u901f\u5207\u5212\u8fc7\u7a7a\u6c14\uff0c\u4fbf\u5c06\u81ea\u5df1\u4f20\u9001\u5230\u4e86\u654c\u4eba\u8eab\u540e\uff01", "\u4f60\u7528\u4e00\u53ea[pc.hands]\u8fc5\u901f\u5207\u5212\u8fc7\u7a7a\u6c14\uff0c\u4fbf\u5c06[npc.Name]\u4f20\u9001\u5230\u4e86[npc.her]\u7684\u654c\u4eba\u8eab\u540e\uff01", "[npc.Name]\u7528\u4e00\u53ea[npc.hands]\u8fc5\u901f\u5207\u5212\u8fc7\u7a7a\u6c14\uff0c\u4fbf\u5c06\u81ea\u5df1\u4f20\u9001\u5230\u4e86[npc.her]\u7684\u654c\u4eba\u8eab\u540e\uff01", "[npc.Name]\u7528\u4e00\u53ea[npc.hands]\u8fc5\u901f\u5207\u5212\u8fc7\u7a7a\u6c14\uff0c\u4fbf\u5c06\u4f60\u4f20\u9001\u5230\u4e86\u4f60\u7684\u654c\u4eba\u8eab\u540e\uff01", "[npc.Name]\u7528\u4e00\u53ea[npc.hands]\u8fc5\u901f\u5207\u5212\u8fc7\u7a7a\u6c14\uff0c\u4fbf\u5c06[npc2.name]\u4f20\u9001\u5230\u4e86[npc2.her]\u7684\u654c\u4eba\u8eab\u540e\uff01"));
            }
            if (isHit) {
                target.removeStatusEffect(StatusEffect.TELEPORT_ARCANE_ARRIVAL);
                target.removeStatusEffect(StatusEffect.TELEPORT);
                if (caster.hasSpellUpgrade(SpellUpgrade.TELEPORT_2)) {
                    this.applyStatusEffects(caster, caster, isCritical);
                    descriptionSB.append(this.getStatusEffectApplication(caster, caster, isHit, isCritical));
                    for (GameCharacter combatant : Main.combat.getAllies(caster)) {
                        this.applyStatusEffects(caster, combatant, isCritical);
                        descriptionSB.append(this.getStatusEffectApplication(caster, combatant, isHit, isCritical));
                    }
                } else {
                    this.applyStatusEffects(caster, target, isCritical);
                    descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    LILITHS_COMMAND(true, SpellSchool.ARCANE, SpellType.OFFENSIVE, DamageType.PHYSICAL, false, "\u8389\u8389\u4e1d\u4e4b\u5f8b\u4ee4", "liliths_command", "\u4e3a\u65bd\u6cd5\u8005\u7684\u8a00\u8bed\u6ce8\u5165\u8389\u8389\u4e1d\u4e4b\u529b\uff0c\u5f3a\u8feb\u5bf9\u624b\u7acb\u523b\u5c48\u670d\u3002", 0, DamageVariance.LOW, 400, null, Util.newArrayListOfValues(SpellUpgrade.LILITHS_COMMAND_1, SpellUpgrade.LILITHS_COMMAND_2, SpellUpgrade.LILITHS_COMMAND_3), null, Util.newArrayListOfValues("[style.colourGood(25%)]\u7684\u6982\u7387\u4f7f\u76ee\u6807[style.colourExcellent(\u7acb\u523b\u5c48\u670d)]")){

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u5f3a\u8feb\u76ee\u6807\u5c48\u670d\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u8389\u8389\u4e1d\u7531\u6211\u73b0\u51fa\u795e\u529b\uff01\u8de8\u8d8a\u65f6\u95f4\u548c\u7a7a\u95f4\u7684\u9e3f\u6c9f\uff0c\u5979\u7684\u547d\u4ee4\u6c38\u65e0\u5c3d\u5934\uff0c\u4f60\u5fc5\u5c06\u670d\u4ece\uff01"), "", "\u4f60\u4ece\u5965\u672f\u7075\u6c14\u4e2d\u652b\u53d6\u4e86\u5927\u91cf\u7684\u80fd\u91cf\uff0c\u5c06\u8389\u8389\u4e1d\u672c\u4eba\u7684\u5723\u8a00\u6ce8\u5165[npc.name]\u7684\u8111\u5185\uff0c\u547d\u4ee4\u5176\u5c48\u670d\u3002", "", "[npc.Name]\u4ece\u5965\u672f\u7075\u6c14\u4e2d\u652b\u53d6\u4e86\u5927\u91cf\u7684\u80fd\u91cf\uff0c\u5c06\u8389\u8389\u4e1d\u672c\u4eba\u7684\u5723\u8a00\u6ce8\u5165\u4f60\u7684\u8111\u5185\uff0c\u547d\u4ee4\u4f60\u5c48\u670d\u3002", "[npc1.name]\u4ece\u5965\u672f\u7075\u6c14\u4e2d\u652b\u53d6\u4e86\u5927\u91cf\u7684\u80fd\u91cf\uff0c\u5c06\u8389\u8389\u4e1d\u672c\u4eba\u7684\u5723\u8a00\u6ce8\u5165[npc2.namePos]\u7684\u8111\u5185\uff0c\u547d\u4ee4\u5176\u5c48\u670d\u3002"));
            if (isHit) {
                boolean success = false;
                if (caster.hasSpellUpgrade(SpellUpgrade.LILITHS_COMMAND_3)) {
                    success = true;
                } else if (caster.hasSpellUpgrade(SpellUpgrade.LILITHS_COMMAND_2)) {
                    success = Math.random() < 0.75;
                } else if (caster.hasSpellUpgrade(SpellUpgrade.LILITHS_COMMAND_1)) {
                    success = Math.random() < 0.5 && target.isVulnerableToArcaneStorm();
                } else {
                    boolean bl = success = Math.random() < 0.25 && target.isVulnerableToArcaneStorm();
                }
                if (success) {
                    target.setHealthPercentage(0.0f);
                    target.setManaPercentage(0.0f);
                    target.setLustNoText(100.0f);
                    descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
                    if (target.isPlayer()) {
                        descriptionSB.append("<br/>\u4f60\u7a81\u7136\u610f\u8bc6\u5230\u81ea\u5df1\u6b63\u76f4\u9762\u4f17\u6076\u9b54\u4e4b\u4e3b\u3002\u8389\u8389\u4e1d\u53ea\u662f\u4e00\u4f38\u624b\u6307\uff0c\u5411\u7740\u5730\u9762\uff0c\u7b49\u4f60\u53cd\u5e94\u8fc7\u6765\uff0c\u81ea\u5df1\u5df2\u7ecf\u8dea\u5728\u4e86\u5979\u9762\u524d\u3002\u4f60\u6cb9\u7136\u800c\u751f\u4e00\u80a1\u53d6\u60a6\u5bf9\u65b9\u7684\u60f3\u6cd5\uff0c\u4e8e\u662f\u62ac\u5934\u770b\u5411\u8389\u8389\u4e1d\u7684\u773c\u7738\uff0c[pc.moan]\u7740\uff0c[pc.speech(\u6c42\u60a8\u4e86\uff0c\u8389\u8389\u4e1d\u2026\u2026\u968f\u610f\u5730\u4f7f\u7528\u6211\u5427\u2026\u2026\u6211\u662f\u60a8\u5fe0\u8bda\u7684\u5974\u96b6\u2026\u2026)]");
                    } else {
                        descriptionSB.append(UtilText.parse(target, "<br/>[npc.Name]\u53d7\u5230\u8389\u8389\u4e1d\u4e4b\u5f8b\u4ee4\u7684\u538b\u8feb\uff0c\u8dea\u4e86\u4e0b\u6765\u3002[npc.she]\u5f00\u59cb\u629a\u6478\u7740\u81ea\u5df1\u7684\u8eab\u5b50\uff0c\u4e00\u8fb9\u53d1\u51fa[npc.a_moan+]\uff0c\u4e00\u8fb9\u7948\u6c42\u9053\uff0c[npc.speech(\u6c42\u60a8\u4e86\uff0c\u8389\u8389\u4e1d\u2026\u2026\u968f\u610f\u5730\u4f7f\u7528\u6211\u5427\u2026\u2026\u6211\u662f\u60a8\u5fe0\u8bda\u7684\u5974\u96b6\u2026\u2026)]", new ParserTag[0]));
                    }
                } else if (target.isPlayer()) {
                    descriptionSB.append("<br/>\u4f60\u8fde\u5fd9\u6643\u4e86\u6643\u8111\u888b\uff0c\u5411\u540e\u4e00\u8df3\uff0c\u6210\u529f\u62b5\u6297\u4e86\u8389\u8389\u4e1d\u4e4b\u5f8b\u4ee4\uff01");
                } else if (target.isVulnerableToArcaneStorm() || !caster.hasSpellUpgrade(SpellUpgrade.LILITHS_COMMAND_2)) {
                    descriptionSB.append(UtilText.parse(target, "<br/>[npc.Name]\u8fde\u5fd9\u6643\u4e86\u6643\u8111\u888b\uff0c\u5411\u540e\u4e00\u8df3\uff0c\u6210\u529f\u62b5\u6297\u4e86\u8389\u8389\u4e1d\u4e4b\u5f8b\u4ee4\uff01", new ParserTag[0]));
                } else {
                    descriptionSB.append(UtilText.parse(target, "<br/>[npc.Name]\u54a7\u5634\u4e00\u7b11\uff0c\u5632\u8bbd\u9053\uff0c[npc.speech(\u8fd9\u79cd\u5c0f\u628a\u620f\u53ef\u5413\u4e0d\u5012\u6211\u8fd9\u79cd[npc.a_race]\uff01)]", new ParserTag[0]));
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    ELEMENTAL_ARCANE(false, SpellSchool.ARCANE, SpellType.SUMMON, DamageType.LUST, false, "\u5143\u7d20\u5965\u672f", "elemental_arcane", "\u5c06\u5143\u7d20\u4f53\u4e0e\u5965\u672f\u5b66\u6d3e\u7ed1\u5b9a\uff0c\u53ec\u5524\u51fa\u5b9e\u4f53\u5f62\u6001\u7684\u5965\u672f\u5143\u7d20\u3002", 0, DamageVariance.LOW, 200, null, Util.newArrayListOfValues(SpellUpgrade.ELEMENTAL_ARCANE_1, SpellUpgrade.ELEMENTAL_ARCANE_2, SpellUpgrade.ELEMENTAL_ARCANE_3A, SpellUpgrade.ELEMENTAL_ARCANE_3B), null, Util.newArrayListOfValues("\u4ee5[style.colourArcane(\u5965\u672f)]\u7684\u5f62\u6001\u53ec\u5524[style.colourArcane(\u5143\u7d20)]")){

        @Override
        public Util.Value<Boolean, String> getSpellCastOutOfCombatDescription(GameCharacter owner, GameCharacter target) {
            if (!owner.hasSpell(this)) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u6ca1\u6709\u5b66\u4f1a\u8be5\u6cd5\u672f\uff0c\u6240\u4ee5\u65e0\u6cd5\u91ca\u653e\uff01", new ParserTag[0]));
            }
            if (owner.isCaptive()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u88ab\u4fd8\u864f\u65f6\u65e0\u6cd5\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            if (Main.game.isInCombat()) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u6218\u6597\u4e2d\u53ea\u80fd\u4ee5\u6218\u6597\u52a8\u4f5c\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            if (!Main.game.isSavedDialogueNeutral() && Main.game.getCurrentDialogueNode() == SpellManagement.CHARACTER_SPELLS_ARCANE && SpellManagement.getDialogueReturn().getDialogueNodeType() != DialogueNodeType.OCCUPANT_MANAGEMENT) {
                return new Util.Value<Boolean, String>(false, "\u53ea\u80fd\u5728\u4e2d\u7acb\u573a\u666f\u91ca\u653e\u6cd5\u672f\uff01");
            }
            if (owner.getMana() < this.getModifiedCost(owner)) {
                return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u9700\u8981\u81f3\u5c11<b>" + this.getModifiedCost(owner) + "</b>[style.boldMana(\u7075\u6c14)]\u624d\u80fd\u91ca\u653e\u8be5\u6cd5\u672f\uff01", new ParserTag[0]));
            }
            String description = owner.isPlayer() ? "\u5c06\u5143\u7d20\u4f53\u4e0e\u5965\u672f\u5b66\u6d3e\u7ed1\u5b9a\u540e\u53ec\u5524\uff01" : "\u8ba9[npc.name]\u5c06\u5143\u7d20\u4f53\u4e0e\u5965\u672f\u5b66\u6d3e\u7ed1\u5b9a\u540e\u53ec\u5524\uff01";
            String cost = "\u5c06\u6d88\u8017<b>" + this.getModifiedCost(owner) + "</b>[style.boldMana(\u7075\u6c14)]\uff01";
            return new Util.Value<Boolean, String>(true, UtilText.parse(owner, description + "<br/>" + cost, new ParserTag[0]));
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u4ee5\u5965\u672f\u7684\u5f62\u6001\u53ec\u5524\u5143\u7d20\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            float cost = this.getModifiedCost(caster);
            descriptionSB.setLength(0);
            boolean elementalAlreadySummoned = false;
            if (!caster.hasDiscoveredElemental()) {
                caster.createElemental();
            } else {
                elementalAlreadySummoned = caster.isElementalSummoned();
            }
            caster.setElementalSummoned(true);
            caster.getElemental().setElementalSchool(SpellSchool.ARCANE);
            if (elementalAlreadySummoned) {
                descriptionSB.append(UtilText.parse(caster, caster.getElemental(), (caster.hasTraitActivated(Perk.CHUUNI) ? Util.randomItemFrom(Util.newArrayListOfValues("[npc.speech(\u9b54\u9b3c\u4e0e\u6076\u9b54\u7684\u53e4\u8001\u4eea\u5f0f\u4e0b\uff0c\u6211\u53ec\u5524\u51fa\u90a3\u5965\u672f\uff01\u56de\u5e94\u4f60[npc.master]\u7684\u53ec\u5524\u5427\uff0c[npc2.name]\uff0c\u7ecf\u5386\u767e\u4e07\u4f4d\u9762\u7684\u5f81\u670d\uff0c\u670d\u4ece\u6211\u7684\u610f\u5fd7\uff01)] ", "[npc.speech(\u613f\u5c01\u5370\u4e8e\u6211\u4f53\u5185\u6570\u5343\u8f7d\u7684\u529b\u91cf\u4e00\u671d\u8ff8\u53d1\uff01\u901a\u8fc7\u6c38\u6052\u7684\u94fe\u63a5\uff0c\u6211\u5411\u5965\u672f\u672c\u8eab\u53d1\u51fa\u53ec\u5524\uff0c\u51fa\u6765\u5427\uff0c[npc2.name]\uff01)] ", "[npc.speech(\u8ba9\u5965\u672f\u4e3a\u6211\u6240\u7528\uff0c\u613f\u6211\u4f53\u5185\u7684\u529b\u91cf\u8ff8\u53d1\u800c\u51fa\u5427\uff01\u5965\u672f\u7684\u7cbe\u9b42\uff0c\u8fd9\u662f[npc.master]\u7684\u53ec\u5524\uff01\u670d\u4ece\u6211\uff0c\u73b0\u8eab\u5427\uff0c[npc2.name]\uff01)] ")) : "") + (caster.isPlayer() ? "\u968f\u7740\u4e00\u9053\u7d2b\u8272\u7684\u5965\u672f\u95ea\u7535\uff0c\u4f60\u5c06\u5143\u7d20\u4f53[npc2.name]\u4e0e\u5965\u672f\u5b66\u6d3e\u7ed1\u5b9a\uff01" : "\u968f\u7740\u4e00\u9053\u7d2b\u8272\u7684\u5965\u672f\u95ea\u7535\uff0c[npc1.name]\u5c06\u5143\u7d20\u4f53[npc2.name]\u4e0e\u5965\u672f\u5b66\u6d3e\u7ed1\u5b9a\uff01"), new ParserTag[0]));
            } else {
                descriptionSB.append(UtilText.parse(caster, caster.getElemental(), (caster.hasTraitActivated(Perk.CHUUNI) ? Util.randomItemFrom(Util.newArrayListOfValues("[npc.speech(\u9b54\u9b3c\u4e0e\u6076\u9b54\u7684\u53e4\u8001\u4eea\u5f0f\u4e0b\uff0c\u6211\u53ec\u5524\u51fa\u90a3\u5965\u672f\uff01\u56de\u5e94\u4f60[npc.master]\u7684\u53ec\u5524\u5427\uff0c[npc2.name]\uff0c\u7ecf\u5386\u767e\u4e07\u4f4d\u9762\u7684\u5f81\u670d\uff0c\u670d\u4ece\u6211\u7684\u610f\u5fd7\uff01)] ", "[npc.speech(\u613f\u5c01\u5370\u4e8e\u6211\u4f53\u5185\u6570\u5343\u8f7d\u7684\u529b\u91cf\u4e00\u671d\u8ff8\u53d1\uff01\u901a\u8fc7\u6c38\u6052\u7684\u94fe\u63a5\uff0c\u6211\u5411\u5965\u672f\u672c\u8eab\u53d1\u51fa\u53ec\u5524\uff0c\u51fa\u6765\u5427\uff0c[npc2.name]\uff01)] ", "[npc.speech(\u8ba9\u5965\u672f\u4e3a\u6211\u6240\u7528\uff0c\u613f\u6211\u4f53\u5185\u7684\u529b\u91cf\u8ff8\u53d1\u800c\u51fa\u5427\uff01\u5965\u672f\u7684\u7cbe\u9b42\uff0c\u8fd9\u662f[npc.master]\u7684\u53ec\u5524\uff01\u670d\u4ece\u6211\uff0c\u73b0\u8eab\u5427\uff0c[npc2.name]\uff01)] ")) : "") + (caster.isPlayer() ? "\u968f\u7740\u4e00\u9053\u7d2b\u8272\u7684\u5965\u672f\u95ea\u7535\uff0c\u4f60\u53ec\u5524\u51fa\u5143\u7d20\u4f53[npc2.name]\uff0c\u5e76\u4e0e\u5965\u672f\u5b66\u6d3e\u7ed1\u5b9a\uff01" : "\u968f\u7740\u4e00\u9053\u7d2b\u8272\u7684\u5965\u672f\u95ea\u7535\uff0c[npc1.name]\u53ec\u5524\u51fa\u5143\u7d20\u4f53[npc2.name]\uff0c\u5e76\u4e0e\u5965\u672f\u5b66\u6d3e\u7ed1\u5b9a\uff01"), new ParserTag[0]));
                if (Main.game.isInCombat()) {
                    caster.getElemental().setLocation(caster, false);
                    if (caster.isPlayer() || Main.combat.getAllies(Main.game.getPlayer()).contains(caster)) {
                        Main.combat.addAlly(caster.getElemental());
                    } else {
                        Main.combat.addEnemy(caster.getElemental());
                    }
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    WITCH_SEAL(false, SpellSchool.ARCANE, SpellType.OFFENSIVE_STATUS_EFFECT, DamageType.MISC, false, "\u9b54\u5973\u5c01\u9501\u672f", "spell_witch_seal", "\u518d\u76ee\u6807\u8eab\u4e0a\u9644\u52a0\u5965\u672f\u5c01\u5370\uff0c\u4f7f\u5176\u5931\u53bb\u884c\u52a8\u80fd\u529b\u3002", 0, DamageVariance.NONE, 80, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.WITCH_SEAL, 1)), null, null, Util.newArrayListOfValues("[style.colourExcellent(\u5c01\u5370)]\u76ee\u6807\uff0c[style.colourTerrible(-3)][style.colourActionPoints(\u884c\u52a8\u70b9)]\uff01")){

        @Override
        public boolean isSpellBook() {
            return false;
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u5c01\u5370\u4f7f\u884c\u52a8\u70b9[style.colourTerrible(-3)]\uff01";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            descriptionSB.setLength(0);
            float cost = this.getModifiedCost(caster);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u66fe\u7ecf\u7981\u9522\u6211\u7684\u5965\u672f\u4e4b\u529b\u7684\u5c01\u5370\uff0c\u542c\u6211\u53f7\u4ee4\uff01\u8ba9\u654c\u65b9\u5c48\u670d\u4e8e\u7edd\u5bf9\u670d\u4ece\u7684\u9ed1\u6697\u4e4b\u4e0b\u5427\uff0c\u81ea\u6b64\u65e0\u6240\u9041\u9003\uff01"), "", "\u4f60\u5c06\u5965\u672f\u4e4b\u529b\u96c6\u4e2d\u5728\u626b\u628a\u4e0a\uff0c\u53ec\u5524\u51fa\u4e00\u9053\u5f3a\u5927\u7684\u5c01\u5370\uff0c\u628a[npc.name]\u63a7\u5236\u5728\u539f\u5730\uff01", "", "[npc.Name]\u5c06\u5965\u672f\u4e4b\u529b\u96c6\u4e2d\u5728\u626b\u628a\u4e0a\uff0c\u53ec\u5524\u51fa\u4e00\u9053\u5f3a\u5927\u7684\u5c01\u5370\uff0c\u628a\u4f60\u63a7\u5236\u5728\u539f\u5730\uff01", "[npc1.name]\u5c06\u5965\u672f\u4e4b\u529b\u96c6\u4e2d\u5728\u626b\u628a\u4e0a\uff0c\u53ec\u5524\u51fa\u4e00\u9053\u5f3a\u5927\u7684\u5c01\u5370\uff0c\u628a[npc2.name]\u63a7\u5236\u5728\u539f\u5730\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
            if (isHit) {
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    WITCH_CHARM(false, SpellSchool.ARCANE, SpellType.DEFENSIVE_STATUS_EFFECT, DamageType.MISC, true, "\u9b54\u5973\u9b45\u60d1\u672f", "spell_witch_charm", "\u5bf9\u76ee\u6807\u91ca\u653e\u5965\u672f\u9644\u9b54\uff0c\u53ea\u8981\u6709\u4eba\u770b\u5411\u4ed6\uff0c\u4fbf\u65e0\u6cd5\u62b5\u6321\u5176\u9b45\u529b\u3002", 0, DamageVariance.NONE, 40, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.WITCH_CHARM, 5)), null, Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Integer>(Attribute.DAMAGE_LUST, 25)), Util.newArrayListOfValues("\u6301\u7eed[style.colourGood(5\u56de\u5408)]")){

        @Override
        public boolean isSpellBook() {
            return false;
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u589e\u52a0\u8bf1\u60d1\u4f24\u5bb3\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            descriptionSB.setLength(0);
            float cost = this.getModifiedCost(caster);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u73b0\u5b9e\u4e5f\u5c06\u7531\u6211\u65e0\u7a77\u7684\u529b\u91cf\u6240\u626d\u66f2\uff01\u51dd\u89c6\u5bb9\u989c\u8005\u5fc3\u9b42\u4ff1\u60d1\uff0c\u773c\u524d\u5c06\u662f\u81ea\u5df1\u5185\u5fc3\u771f\u6b63\u7684\u6e34\u671b\uff01"), "\u4f60\u5c06\u5965\u672f\u4e4b\u529b\u96c6\u4e2d\u5728\u626b\u628a\u4e0a\uff0c\u5728\u81ea\u5df1\u8eab\u4e0a\u65bd\u52a0\u4e86\u8ff7\u4eba\u7684\u9b45\u60d1\uff01", "\u4f60\u5c06\u5965\u672f\u4e4b\u529b\u96c6\u4e2d\u5728\u626b\u628a\u4e0a\uff0c\u5728[npc.Name]\u8eab\u4e0a\u65bd\u52a0\u4e86\u8ff7\u4eba\u7684\u9b45\u60d1\uff01", "[npc.Name]\u5c06\u5965\u672f\u4e4b\u529b\u96c6\u4e2d\u5728\u626b\u628a\u4e0a\uff0c\u5728\u81ea\u5df1\u8eab\u4e0a\u65bd\u52a0\u4e86\u8ff7\u4eba\u7684\u9b45\u60d1\uff01", "[npc.Name]\u5c06\u5965\u672f\u4e4b\u529b\u96c6\u4e2d\u5728\u626b\u628a\u4e0a\uff0c\u5728\u4f60\u8eab\u4e0a\u65bd\u52a0\u4e86\u8ff7\u4eba\u7684\u9b45\u60d1\uff01", "[npc.Name]\u5c06\u5965\u672f\u4e4b\u529b\u96c6\u4e2d\u5728\u626b\u628a\u4e0a\uff0c\u5728[npc2.name]\u8eab\u4e0a\u65bd\u52a0\u4e86\u8ff7\u4eba\u7684\u9b45\u60d1\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, 0.0f, isHit, isCritical));
            if (isHit) {
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    DARK_SIREN_SIRENS_CALL(false, SpellSchool.AIR, SpellType.OFFENSIVE_STATUS_EFFECT_MINOR_DAMAGE, DamageType.PHYSICAL, false, "\u585e\u58ec\u7684\u547c\u5524", "dark_siren_sirens_call", "\u53d1\u51fa\u5c71\u5d29\u5730\u88c2\u7684\u5c16\u5578\u4f7f\u5927\u5730\u5d29\u574f\uff0c\u88c2\u7f1d\u4e2d\u6d8c\u51fa\u7684\u6bd2\u6c14\u4f1a\u7a92\u606f\u9644\u8fd1\u7684\u6240\u6709\u654c\u4eba\u3002", 10, DamageVariance.NONE, 200, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.BANEFUL_FISSURE, 10)), null, null, Util.newArrayListOfValues("\u6bcf\u56de\u5408\u9020\u6210<b>25</b>[style.colourPoison(\u6bd2\u7d20\u4f24\u5bb3)]\uff0c\u6301\u7eed[style.colourGood(10\u56de\u5408)]", "\u5f71\u54cd[style.colourExcellent(\u6240\u6709\u654c\u4eba)]")){

        @Override
        public boolean isSpellBook() {
            return false;
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return this.getFormattedSpellDamageRange(caster, target, enemies, allies);
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            descriptionSB.setLength(0);
            float damage = Attack.calculateSpellDamage(caster, target, this.damageType, this.getDamage(caster), this.damageVariance, isCritical);
            float cost = this.getModifiedCost(caster);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u5730\u5e95\u7684\u5f3a\u8005\u4eec\uff0c\u542c\u4ece\u4f60\u4eec[npc.master]\u7684\u53f7\u4ee4\uff01\u5728\u65f6\u95f4\u7684\u5c3d\u5934\u5f00\u8f9f\u4e00\u6761\u9ed1\u6697\u7684\u9e3f\u6c9f\uff0c\u8ba9\u7a92\u606f\u7edd\u671b\u7684\u5267\u6bd2\u7634\u6c14\u55b7\u6d8c\u800c\u51fa\u5427\uff01"), "", "\u4f60\u96c6\u4e2d\u9570\u5200\u4e2d\u5de8\u5927\u7684\u5965\u672f\u529b\u91cf\uff0c\u5411[npc.namePos][npc.feet]\u4e0b\u65b9\u7684\u5730\u9762\u7838\u53bb\uff0c\u5288\u5f00\u5927\u5730\u5e76\u53ec\u5524\u51fa\u6bd2\u6c14\uff01", "", "[npc.Name]\u96c6\u4e2d\u9570\u5200\u4e2d\u5de8\u5927\u7684\u5965\u672f\u529b\u91cf\uff0c\u5411\u4f60[pc.feet]\u4e0b\u65b9\u7684\u5730\u9762\u7838\u53bb\uff0c\u5288\u5f00\u5927\u5730\u5e76\u53ec\u5524\u51fa\u6bd2\u6c14\uff01", "[npc.Name]\u96c6\u4e2d\u9570\u5200\u4e2d\u5de8\u5927\u7684\u5965\u672f\u529b\u91cf\uff0c\u5411[npc2.namePos][npc2.feet]\u4e0b\u65b9\u7684\u5730\u9762\u7838\u53bb\uff0c\u5288\u5f00\u5927\u5730\u5e76\u53ec\u5524\u51fa\u6bd2\u6c14\uff01"));
            descriptionSB.append(this.getDamageDescription(caster, target, damage, isHit, isCritical));
            if (isHit && damage > 0.0f) {
                descriptionSB.append(this.applyDamage(caster, target, damage));
            }
            for (GameCharacter combatant : Main.combat.getEnemies(caster)) {
                this.applyStatusEffects(caster, combatant, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, combatant, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            return descriptionSB.toString();
        }
    }
    ,
    LIGHTNING_SPHERE_DISCHARGE(false, SpellSchool.ARCANE, SpellType.OFFENSIVE, DamageType.LUST, false, "\u7535\u80fd\u91ca\u653e", "arcane_lightning_sphere_discharge", "\u5965\u672f\u95ea\u7535\u7403\u4ece\u6301\u7528\u8005\u5904\u5438\u53d6\u4e86\u5c11\u91cf\u7075\u6c14\uff0c\u7206\u53d1\u51fa\u4e00\u9635\u50ac\u60c5\u7684\u5965\u672f\u95ea\u7535\uff0c\u51fb\u4e2d\u4e86\u5468\u56f4[style.colourBad(\u5305\u62ec\u65bd\u6cd5\u8005)]\u7684\u6240\u6709\u4eba\u3002", 10, DamageVariance.MEDIUM, 50, null, null, null, Util.newArrayListOfValues("\u5f71\u54cd[style.colourExcellent(\u6240\u6709\u654c\u4eba)]", "\u5f71\u54cd[style.colourTerrible(\u65bd\u6cd5\u8005)]", "\u5f71\u54cd[style.colourTerrible(\u6240\u6709\u76df\u53cb)]")){

        @Override
        public int getAPCost() {
            return 1;
        }

        @Override
        public int getCooldown() {
            return 2;
        }

        @Override
        public boolean isSpellBook() {
            return false;
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u9020\u6210[style.colourDmgLust(" + Attack.getMinimumSpellDamage(caster, target, this.getDamageType(), this.getDamage(caster), this.getDamageVariance()) + "-" + Attack.getMaximumSpellDamage(caster, target, this.getDamageType(), this.getDamage(caster), this.getDamageVariance()) + this.damageType.getName() + ")]\u4f24\u5bb3\uff0c\u5bf9[style.colourExcellent(\u6240\u6709\u654c\u4eba)]<i>\u4ee5\u53ca</i>[style.colourTerrible(\u6240\u6709\u76df\u53cb\uff0c\u5305\u62ec\u65bd\u6cd5\u8005)]\u751f\u6548\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            descriptionSB.setLength(0);
            float cost = this.getModifiedCost(caster);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u6c38\u6052\u800c\u5e7f\u88a4\u7684\u529b\u91cf\u554a\uff0c\u88ab\u5c01\u5370\u6210\u5343\u4e0a\u4e07\u5e74\u540e\uff0c\u7ec8\u4e8e\u5f97\u4ee5\u91ca\u653e\uff01\u76ee\u7779\u6211\u5524\u51fa\u7684\u5965\u672f\u98ce\u66b4\uff0c\u6210\u4e3a\u4e3a\u60c5\u6b32\u800c\u72c2\u7684\u5080\u5121\uff0c\u5c48\u670d\u5427\uff01"), "\u4f60\u5c06\u90e8\u5206\u7075\u6c14\u5bfc\u5165\u5230\u5965\u672f\u95ea\u7535\u7403\u4e2d\uff0c\u5f3a\u5236\u5176\u4ee5\u7535\u80fd\u91ca\u653e\u7684\u5f62\u5f0f\u653e\u51fa\u4e00\u4e9b\u80fd\u91cf\uff01", "\u4f60\u5c06\u90e8\u5206\u7075\u6c14\u5bfc\u5165\u5230\u5965\u672f\u95ea\u7535\u7403\u4e2d\uff0c\u5f3a\u5236\u5176\u4ee5\u7535\u80fd\u91ca\u653e\u7684\u5f62\u5f0f\u653e\u51fa\u4e00\u4e9b\u80fd\u91cf\uff01", "[npc.Name]\u5c06\u90e8\u5206\u7075\u6c14\u5bfc\u5165\u5230\u5965\u672f\u95ea\u7535\u7403\u4e2d\uff0c\u5f3a\u5236\u5176\u4ee5\u7535\u80fd\u91ca\u653e\u7684\u5f62\u5f0f\u653e\u51fa\u4e00\u4e9b\u80fd\u91cf\uff01", "[npc.Name]\u5c06\u90e8\u5206\u7075\u6c14\u5bfc\u5165\u5230\u5965\u672f\u95ea\u7535\u7403\u4e2d\uff0c\u5f3a\u5236\u5176\u4ee5\u7535\u80fd\u91ca\u653e\u7684\u5f62\u5f0f\u653e\u51fa\u4e00\u4e9b\u80fd\u91cf\uff01", "[npc.Name]\u5c06\u90e8\u5206\u7075\u6c14\u5bfc\u5165\u5230\u5965\u672f\u95ea\u7535\u7403\u4e2d\uff0c\u5f3a\u5236\u5176\u4ee5\u7535\u80fd\u91ca\u653e\u7684\u5f62\u5f0f\u653e\u51fa\u4e00\u4e9b\u80fd\u91cf\uff01"));
            if (isHit) {
                for (GameCharacter combatant : Main.combat.getAllCombatants(true)) {
                    float damage = Attack.calculateSpellDamage(caster, combatant, this.damageType, this.getDamage(caster), this.damageVariance, isCritical);
                    descriptionSB.append(this.getDamageDescription(caster, combatant, damage, isHit, isCritical));
                    if (damage > 0.0f) {
                        descriptionSB.append(this.applyDamage(caster, combatant, damage));
                    }
                    this.applyStatusEffects(caster, combatant, isCritical);
                    descriptionSB.append(this.getStatusEffectApplication(caster, combatant, isHit, isCritical));
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            caster.incrementMana(-cost);
            return descriptionSB.toString();
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues("\u65e0\u6cd5\u66b4\u51fb\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return false;
        }
    }
    ,
    LIGHTNING_SPHERE_OVERCHARGE(false, SpellSchool.ARCANE, SpellType.OFFENSIVE, DamageType.LUST, false, "\u7535\u80fd\u8fc7\u8f7d", "arcane_lightning_sphere_overcharge", "\u5965\u672f\u95ea\u7535\u7403\u4ece\u6301\u7528\u8005\u5904\u5438\u53d6\u4e86\u5927\u91cf\u7075\u6c14\uff0c\u7206\u53d1\u51fa\u4e00\u9635\u72c2\u91ce\u7684\u50ac\u60c5\u5965\u672f\u95ea\u7535\uff0c\u51fb\u4e2d\u4e86\u5468\u56f4[style.colourBad(\u5305\u62ec\u65bd\u6cd5\u8005)]\u7684\u6240\u6709\u4eba\u3002", 30, DamageVariance.HIGH, 250, null, null, null, Util.newArrayListOfValues("\u5f71\u54cd[style.colourExcellent(\u6240\u6709\u654c\u4eba)]", "\u5f71\u54cd[style.colourTerrible(\u65bd\u6cd5\u8005)]", "\u5f71\u54cd[style.colourTerrible(\u6240\u6709\u76df\u53cb)]")){

        @Override
        public int getAPCost() {
            return 3;
        }

        @Override
        public int getCooldown() {
            return 10;
        }

        @Override
        public boolean isSpellBook() {
            return false;
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u9020\u6210[style.colourDmgLust(" + Attack.getMinimumSpellDamage(caster, target, this.getDamageType(), this.getDamage(caster), this.getDamageVariance()) + "-" + Attack.getMaximumSpellDamage(caster, target, this.getDamageType(), this.getDamage(caster), this.getDamageVariance()) + this.damageType.getName() + ")]\u4f24\u5bb3\uff0c\u5bf9[style.colourExcellent(\u6240\u6709\u654c\u4eba)]<i>\u4ee5\u53ca</i>[style.colourTerrible(\u6240\u6709\u76df\u53cb\uff0c\u5305\u62ec\u65bd\u6cd5\u8005)]\u751f\u6548\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            descriptionSB.setLength(0);
            float cost = this.getModifiedCost(caster);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u6c38\u6052\u800c\u5e7f\u88a4\u7684\u529b\u91cf\u554a\uff0c\u88ab\u5c01\u5370\u6210\u5343\u4e0a\u4e07\u5e74\u540e\uff0c\u7ec8\u4e8e\u5f97\u4ee5\u91ca\u653e\uff01\u76ee\u7779\u6211\u5524\u51fa\u7684\u5965\u672f\u98ce\u66b4\uff0c\u6210\u4e3a\u4e3a\u60c5\u6b32\u800c\u72c2\u7684\u5080\u5121\uff0c\u5c48\u670d\u5427\uff01"), "\u4f60\u5c06\u90e8\u5206\u7075\u6c14\u5bfc\u5165\u5230\u5965\u672f\u95ea\u7535\u7403\u4e2d\uff0c\u5f3a\u5236\u5176\u4ee5\u5f3a\u70c8\u7535\u80fd\u91ca\u653e\u7684\u5f62\u5f0f\u653e\u51fa\u80fd\u91cf\uff01", "\u4f60\u5c06\u90e8\u5206\u7075\u6c14\u5bfc\u5165\u5230\u5965\u672f\u95ea\u7535\u7403\u4e2d\uff0c\u5f3a\u5236\u5176\u4ee5\u5f3a\u70c8\u7535\u80fd\u91ca\u653e\u7684\u5f62\u5f0f\u653e\u51fa\u80fd\u91cf\uff01", "[npc.Name]\u5c06\u90e8\u5206\u7075\u6c14\u5bfc\u5165\u5230\u5965\u672f\u95ea\u7535\u7403\u4e2d\uff0c\u5f3a\u5236\u5176\u4ee5\u5f3a\u70c8\u7535\u80fd\u91ca\u653e\u7684\u5f62\u5f0f\u653e\u51fa\u80fd\u91cf\uff01", "[npc.Name]\u5c06\u90e8\u5206\u7075\u6c14\u5bfc\u5165\u5230\u5965\u672f\u95ea\u7535\u7403\u4e2d\uff0c\u5f3a\u5236\u5176\u4ee5\u5f3a\u70c8\u7535\u80fd\u91ca\u653e\u7684\u5f62\u5f0f\u653e\u51fa\u80fd\u91cf\uff01", "[npc.Name]\u5c06\u90e8\u5206\u7075\u6c14\u5bfc\u5165\u5230\u5965\u672f\u95ea\u7535\u7403\u4e2d\uff0c\u5f3a\u5236\u5176\u4ee5\u5f3a\u70c8\u7535\u80fd\u91ca\u653e\u7684\u5f62\u5f0f\u653e\u51fa\u80fd\u91cf\uff01"));
            if (isHit) {
                for (GameCharacter combatant : Main.combat.getAllCombatants(true)) {
                    float damage = Attack.calculateSpellDamage(caster, combatant, this.damageType, this.getDamage(caster), this.damageVariance, isCritical);
                    descriptionSB.append(this.getDamageDescription(caster, combatant, damage, isHit, isCritical));
                    if (damage > 0.0f) {
                        descriptionSB.append(this.applyDamage(caster, combatant, damage));
                    }
                    this.applyStatusEffects(caster, combatant, isCritical);
                    descriptionSB.append(this.getStatusEffectApplication(caster, combatant, isHit, isCritical));
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            caster.incrementMana(-cost);
            return descriptionSB.toString();
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues("\u65e0\u6cd5\u66b4\u51fb\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return false;
        }
    }
    ,
    ARCANE_CHAIN_LIGHTNING(false, SpellSchool.ARCANE, SpellType.OFFENSIVE, DamageType.LUST, false, "\u8fde\u9501\u95ea\u7535", "arcane_lightning_chain", "\u65bd\u6cd5\u8005\u80fd\u53ec\u5524\u51fa\u567c\u556a\u4f5c\u54cd\u7684\u5965\u672f\u95ea\u7535\uff0c\u5728\u76ee\u6807\u95f4\u8df3\u8dc3\uff0c\u4f7f\u6bcf\u4e2a\u88ab\u51fb\u4e2d\u7684\u4eba\u90fd\u65e0\u6cd5\u63a7\u5236\u5730\u5174\u594b\u8d77\u6765\u3002", 15, DamageVariance.MEDIUM, 40, null, null, null, Util.newArrayListOfValues("\u5f71\u54cd[style.colourExcellent(\u6240\u6709\u654c\u4eba)]")){

        @Override
        public int getAPCost() {
            return 1;
        }

        @Override
        public int getCooldown() {
            return 2;
        }

        @Override
        public boolean isSpellBook() {
            return false;
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return "\u9020\u6210[style.colourDmgLust(" + Attack.getMinimumSpellDamage(caster, target, this.getDamageType(), this.getDamage(caster), this.getDamageVariance()) + "-" + Attack.getMaximumSpellDamage(caster, target, this.getDamageType(), this.getDamage(caster), this.getDamageVariance()) + this.damageType.getName() + ")]\u4f24\u5bb3\uff0c\u5bf9[style.colourExcellent(\u6240\u6709\u654c\u4eba)]\u751f\u6548\u3002";
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            descriptionSB.setLength(0);
            float cost = this.getModifiedCost(caster);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u6c38\u6052\u800c\u5e7f\u88a4\u7684\u529b\u91cf\u554a\uff0c\u88ab\u5c01\u5370\u6210\u5343\u4e0a\u4e07\u5e74\u540e\uff0c\u7ec8\u4e8e\u5f97\u4ee5\u91ca\u653e\uff01\u76ee\u7779\u6211\u5524\u51fa\u7684\u5965\u672f\u98ce\u66b4\uff0c\u6210\u4e3a\u4e3a\u60c5\u6b32\u800c\u72c2\u7684\u5080\u5121\uff0c\u5c48\u670d\u5427\uff01"), "\u4f60\u7a0d\u5fae\u5c06\u7cbe\u529b\u96c6\u4e2d\u5728\u7075\u6c14\u4e0a\uff0c\u968f\u540e\u91ca\u653e\u51fa\u4e00\u9053\u567c\u556a\u4f5c\u54cd\u7684\u5965\u672f\u95ea\u7535\uff01", "\u4f60\u7a0d\u5fae\u5c06\u7cbe\u529b\u96c6\u4e2d\u5728\u7075\u6c14\u4e0a\uff0c\u968f\u540e\u91ca\u653e\u51fa\u4e00\u9053\u567c\u556a\u4f5c\u54cd\u7684\u5965\u672f\u95ea\u7535\uff01", "[npc.Name]\u7a0d\u5fae\u5c06\u7cbe\u529b\u96c6\u4e2d\u5728\u7075\u6c14\u4e0a\uff0c\u968f\u540e\u91ca\u653e\u51fa\u4e00\u9053\u567c\u556a\u4f5c\u54cd\u7684\u5965\u672f\u95ea\u7535\uff01", "[npc.Name]\u7a0d\u5fae\u5c06\u7cbe\u529b\u96c6\u4e2d\u5728\u7075\u6c14\u4e0a\uff0c\u968f\u540e\u91ca\u653e\u51fa\u4e00\u9053\u567c\u556a\u4f5c\u54cd\u7684\u5965\u672f\u95ea\u7535\uff01", "[npc.Name]\u7a0d\u5fae\u5c06\u7cbe\u529b\u96c6\u4e2d\u5728\u7075\u6c14\u4e0a\uff0c\u968f\u540e\u91ca\u653e\u51fa\u4e00\u9053\u567c\u556a\u4f5c\u54cd\u7684\u5965\u672f\u95ea\u7535\uff01"));
            if (isHit) {
                for (GameCharacter combatant : Main.combat.getAllCombatants(true)) {
                    if (!Main.combat.isOpponent(caster, combatant)) continue;
                    float damage = Attack.calculateSpellDamage(caster, combatant, this.damageType, this.getDamage(caster), this.damageVariance, isCritical);
                    descriptionSB.append(this.getDamageDescription(caster, combatant, damage, isHit, isCritical));
                    if (damage > 0.0f) {
                        descriptionSB.append(this.applyDamage(caster, combatant, damage));
                    }
                    this.applyStatusEffects(caster, combatant, isCritical);
                    descriptionSB.append(this.getStatusEffectApplication(caster, combatant, isHit, isCritical));
                }
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            caster.incrementMana(-cost);
            return descriptionSB.toString();
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues("\u65e0\u6cd5\u66b4\u51fb\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return false;
        }
    }
    ,
    ARCANE_LIGHTNING_SUPERBOLT(false, SpellSchool.ARCANE, SpellType.OFFENSIVE, DamageType.LUST, false, "\u7a76\u6781\u95ea\u7535", "arcane_lightning_superbolt", "\u65bd\u6cd5\u8005\u53ec\u5524\u51fa\u5f3a\u5927\u7684\u5965\u672f\u95ea\u7535\uff0c\u5411\u76ee\u6807\u53d1\u5c04\uff0c\u53d7\u51fb\u8005\u65e0\u4e0d\u9ad8\u6f6e\u7edd\u9876\u3002", 50, DamageVariance.HIGH, 200, null, null, null, Util.newArrayListOfValues(new String[0])){

        @Override
        public int getAPCost() {
            return 3;
        }

        @Override
        public int getCooldown() {
            return 10;
        }

        @Override
        public boolean isSpellBook() {
            return false;
        }

        @Override
        public String getBasicEffectsString(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return this.getFormattedSpellDamageRange(caster, target, enemies, allies);
        }

        @Override
        public String applyEffect(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies, boolean isHit, boolean isCritical) {
            descriptionSB.setLength(0);
            float cost = this.getModifiedCost(caster);
            descriptionSB.append(Spell.getCastDescription(caster, target, Util.newArrayListOfValues("\u6c38\u6052\u800c\u5e7f\u88a4\u7684\u529b\u91cf\u554a\uff0c\u88ab\u5c01\u5370\u6210\u5343\u4e0a\u4e07\u5e74\u540e\uff0c\u7ec8\u4e8e\u5f97\u4ee5\u91ca\u653e\uff01\u76ee\u7779\u6211\u5524\u51fa\u7684\u5965\u672f\u672b\u65e5\uff0c\u6210\u4e3a\u4e3a\u60c5\u6b32\u800c\u72c2\u7684\u5080\u5121\uff0c\u5c48\u670d\u5427\uff01"), "\u4f60\u7a0d\u5fae\u5c06\u7cbe\u529b\u96c6\u4e2d\u5728\u7075\u6c14\u4e0a\uff0c\u968f\u540e\u91ca\u653e\u51fa\u4e00\u9053\u567c\u556a\u4f5c\u54cd\u7684\u5f3a\u529b\u5965\u672f\u95ea\u7535\u675f\uff0c\u51b2\u5411\u4e86\u4f60\u81ea\u5df1\uff01", "\u4f60\u7a0d\u5fae\u5c06\u7cbe\u529b\u96c6\u4e2d\u5728\u7075\u6c14\u4e0a\uff0c\u968f\u540e\u91ca\u653e\u51fa\u4e00\u9053\u567c\u556a\u4f5c\u54cd\u7684\u5f3a\u529b\u5965\u672f\u95ea\u7535\u675f\uff0c\u51b2\u5411\u4e86[npc.Name]\uff01", "[npc.Name]\u7a0d\u5fae\u5c06\u7cbe\u529b\u96c6\u4e2d\u5728\u7075\u6c14\u4e0a\uff0c\u968f\u540e\u91ca\u653e\u51fa\u4e00\u9053\u567c\u556a\u4f5c\u54cd\u7684\u5f3a\u529b\u5965\u672f\u95ea\u7535\u675f\uff0c\u51b2\u5411\u4e86\u81ea\u5df1\uff01", "[npc.Name]\u7a0d\u5fae\u5c06\u7cbe\u529b\u96c6\u4e2d\u5728\u7075\u6c14\u4e0a\uff0c\u968f\u540e\u91ca\u653e\u51fa\u4e00\u9053\u567c\u556a\u4f5c\u54cd\u7684\u5f3a\u529b\u5965\u672f\u95ea\u7535\u675f\uff0c\u51b2\u5411\u4e86\u4f60\uff01", "[npc.Name]\u7a0d\u5fae\u5c06\u7cbe\u529b\u96c6\u4e2d\u5728\u7075\u6c14\u4e0a\uff0c\u968f\u540e\u91ca\u653e\u51fa\u4e00\u9053\u567c\u556a\u4f5c\u54cd\u7684\u5f3a\u529b\u5965\u672f\u95ea\u7535\u675f\uff0c\u51b2\u5411\u4e86[npc2.name]\uff01"));
            if (isHit) {
                float damage = Attack.calculateSpellDamage(caster, target, this.damageType, this.getDamage(caster), this.damageVariance, isCritical);
                descriptionSB.append(this.getDamageDescription(caster, target, damage, isHit, isCritical));
                if (damage > 0.0f) {
                    descriptionSB.append(this.applyDamage(caster, target, damage));
                }
                this.applyStatusEffects(caster, target, isCritical);
                descriptionSB.append(this.getStatusEffectApplication(caster, target, isHit, isCritical));
            }
            descriptionSB.append(this.getCostDescription(caster, cost));
            caster.incrementMana(-cost);
            return descriptionSB.toString();
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues("\u65e0\u6cd5\u66b4\u51fb\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return false;
        }
    };

    private static Map<SpellSchool, List<Spell>> spellsFromSchoolMap;
    private static StringBuilder descriptionSB;
    protected static Map<Integer, List<TreeEntry<SpellSchool, SpellUpgrade>>> spellStealUpgradeTree;
    protected static Map<Integer, List<TreeEntry<SpellSchool, SpellUpgrade>>> soothingWatersUpgradeTree;
    private boolean forbiddenSpell;
    private SpellSchool spellSchool;
    private SpellType type;
    protected DamageType damageType;
    private boolean beneficial;
    private String name;
    private String description;
    protected int damage;
    protected int spellCost;
    protected DamageVariance damageVariance;
    private Map<AbstractStatusEffect, Integer> statusEffects;
    private List<SpellUpgrade> upgradeList;
    private Map<Integer, List<TreeEntry<SpellSchool, SpellUpgrade>>> spellUpgradeTree;
    private HashMap<AbstractAttribute, Integer> attributeModifiers;
    private List<String> extraEffects;
    private List<String> modifiersList;
    private String pathName;
    private String SVGString;
    private static final int ROWS = 3;
    private static StringBuilder treeSB;
    private static StringBuilder spellSB;
    private static StringBuilder lineSB;
    private static StringBuilder entrySB;

    public static Map<SpellSchool, List<Spell>> getSpellsFromSchoolMap() {
        return spellsFromSchoolMap;
    }

    private Spell(boolean forbiddenSpell, SpellSchool spellSchool, SpellType type, DamageType damageType, boolean beneficial, String name, String pathName, String description, int damage, DamageVariance damageVariance, int spellCost, Map<AbstractStatusEffect, Integer> statusEffects, List<SpellUpgrade> upgradeList, HashMap<AbstractAttribute, Integer> attributeModifiers, List<String> extraEffects) {
        this.forbiddenSpell = forbiddenSpell;
        this.spellSchool = spellSchool;
        this.type = type;
        this.damageType = damageType;
        this.beneficial = beneficial;
        this.name = name;
        this.description = description;
        this.damage = damage;
        this.damageVariance = damageVariance;
        this.spellCost = spellCost;
        this.statusEffects = statusEffects == null ? new HashMap<AbstractStatusEffect, Integer>() : statusEffects;
        this.spellUpgradeTree = new HashMap<Integer, List<TreeEntry<SpellSchool, SpellUpgrade>>>();
        this.upgradeList = upgradeList;
        this.initialiseBasicSpellUpgradeTree(upgradeList);
        this.attributeModifiers = attributeModifiers;
        this.extraEffects = extraEffects;
        this.modifiersList = new ArrayList<String>();
        if (attributeModifiers != null) {
            for (Map.Entry<AbstractAttribute, Integer> e : attributeModifiers.entrySet()) {
                this.modifiersList.add("<b>" + (e.getValue() > 0 ? "+" : "") + String.valueOf(e.getValue()) + "</b><b style='color: " + e.getKey().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(e.getKey().getAbbreviatedName()) + "</b>");
            }
        }
        if (extraEffects != null) {
            this.modifiersList.addAll(extraEffects);
        }
        this.pathName = pathName;
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/com/lilithsthrone/res/combat/spell/" + pathName + ".svg");
            if (is == null) {
                System.err.println("Error! Spell icon file does not exist (Trying to read from '" + pathName + "')!");
            }
            this.SVGString = Util.inputStreamToString(is);
            this.SVGString = SvgUtil.colourReplacement(this.toString(), damageType.getMultiplierAttribute().getColour(), this.SVGString);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected boolean isTargetAtMaximumLust(GameCharacter target) {
        return target != null && target.hasStatusEffect(StatusEffect.DESPERATE_FOR_SEX);
    }

    private void initialiseBasicSpellUpgradeTree(List<SpellUpgrade> upgradeList) {
        if (upgradeList != null) {
            for (int i = 0; i < upgradeList.size(); ++i) {
                this.spellUpgradeTree.put(i, new ArrayList());
                this.spellUpgradeTree.get(i).add(new TreeEntry<SpellSchool, SpellUpgrade>(this.spellSchool, i, upgradeList.get(i)));
                if (i == upgradeList.size() - 1 && upgradeList.size() == 4) {
                    this.spellUpgradeTree.get(i - 1).add(new TreeEntry<SpellSchool, SpellUpgrade>(this.spellSchool, i - 1, upgradeList.get(i)));
                    this.spellUpgradeTree.get(i - 2).get(0).addLink(this.spellUpgradeTree.get(i - 1).get(1));
                    continue;
                }
                if (i == 0) continue;
                this.spellUpgradeTree.get(i).get(0).addLink(this.spellUpgradeTree.get(i - 1).get(0));
            }
        }
    }

    public String applyEffect(GameCharacter caster, GameCharacter target, boolean isHit, boolean isCritical) {
        return this.applyEffect(caster, target, null, null, isHit, isCritical);
    }

    public abstract String applyEffect(GameCharacter var1, GameCharacter var2, List<GameCharacter> var3, List<GameCharacter> var4, boolean var5, boolean var6);

    public List<String> getModifiersAsStringList() {
        return this.modifiersList;
    }

    public boolean isSpellBook() {
        return true;
    }

    public boolean isForbiddenSpell() {
        return this.forbiddenSpell;
    }

    public SpellSchool getSpellSchool() {
        return this.spellSchool;
    }

    public SpellType getType() {
        return this.type;
    }

    public DamageType getDamageType() {
        return this.damageType;
    }

    public boolean isBeneficial() {
        return this.beneficial;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription(GameCharacter source) {
        return this.description;
    }

    public int getDamage(GameCharacter caster) {
        return this.damage;
    }

    public DamageVariance getDamageVariance() {
        return this.damageVariance;
    }

    public int getBaseCost(GameCharacter caster) {
        return this.spellCost;
    }

    public float getModifiedCost(GameCharacter caster) {
        float calculatedCost = this.getBaseCost(caster);
        return (float)Math.round((calculatedCost *= (100.0f - caster.getAttributeValue(Attribute.SPELL_COST_MODIFIER)) / 100.0f) * 10.0f) / 10.0f;
    }

    public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
        return this.statusEffects;
    }

    public List<SpellUpgrade> getUpgradeList() {
        return this.upgradeList;
    }

    public Map<Integer, List<TreeEntry<SpellSchool, SpellUpgrade>>> getSpellUpgradeTree() {
        return this.spellUpgradeTree;
    }

    public HashMap<AbstractAttribute, Integer> getAttributeModifiers() {
        return this.attributeModifiers;
    }

    public List<String> getExtraEffects() {
        return this.extraEffects;
    }

    public String getSVGString() {
        return this.SVGString;
    }

    public String getPathName() {
        return this.pathName;
    }

    protected void applyStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
        for (Map.Entry<AbstractStatusEffect, Integer> se : this.getStatusEffects(caster, target, isCritical).entrySet()) {
            Main.combat.addStatusEffectToApply(target, se.getKey(), se.getValue() * (caster.isPlayer() && caster.hasTrait(Perk.JOB_MUSICIAN, true) ? 2 : 1) * (isCritical ? 2 : 1));
        }
    }

    protected String getFormattedSpellDamageRange(GameCharacter caster, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        return "\u9020\u6210<span style='color:" + this.getDamageType().getColour().toWebHexString() + ";'>" + Math.round(Attack.getMinimumSpellDamage(caster, target, this.getDamageType(), this.getDamage(caster), this.getDamageVariance())) + "-" + Math.round(Attack.getMaximumSpellDamage(caster, target, this.getDamageType(), this.getDamage(caster), this.getDamageVariance())) + this.damageType.getName() + "</span>\u4f24\u5bb3";
    }

    protected String getDamageDescription(GameCharacter caster, GameCharacter target, float damage, boolean isHit, boolean isCritical) {
        StringBuilder damageCostDescriptionSB = new StringBuilder();
        boolean appliesEffects = !this.getStatusEffects(caster, target, isCritical).isEmpty();
        damageCostDescriptionSB.append("<br/>");
        if (caster.isPlayer()) {
            if (isCritical) {
                if (!isHit) {
                    damageCostDescriptionSB.append("[style.italicsBad(\u4f60\u6ca1\u6709\u547d\u4e2d\uff01)]");
                } else {
                    if (damage > 0.0f) {
                        damageCostDescriptionSB.append(UtilText.parse(target, "\u4f60\u51fb\u4e2d\u4e86[npc.Name]\u7684[style.boldExcellent(\u8981\u5bb3)]\uff0c\u9020\u6210<b>" + damage + "</b>" + this.damageType.getMultiplierAttribute().getColouredName("b") + "\uff01", new ParserTag[0]));
                    }
                    if (appliesEffects) {
                        damageCostDescriptionSB.append("\u4f60\u7684\u6cd5\u672f\u9020\u6210\u4e86[style.boldExcellent(\u66b4\u51fb)]\uff0c\u6301\u7eed\u65f6\u95f4\u7ffb\u500d\uff01");
                    }
                }
            } else if (!isHit) {
                damageCostDescriptionSB.append("[style.italicsBad(\u4f60\u6ca1\u6709\u547d\u4e2d\uff01)]");
            } else if (damage > 0.0f) {
                damageCostDescriptionSB.append(UtilText.parse(target, "\u4f60\u51fb\u4e2d\u4e86[npc.Name]\uff0c\u9020\u6210<b>" + damage + "</b>" + this.damageType.getMultiplierAttribute().getColouredName("b") + "\uff01", new ParserTag[0]));
            }
        } else if (isCritical) {
            if (!isHit) {
                damageCostDescriptionSB.append(UtilText.parse(caster, "[style.italicsBad([npc1.Name]\u6ca1\u6709\u547d\u4e2d\uff01)]", new ParserTag[0]));
            } else {
                if (damage > 0.0f) {
                    damageCostDescriptionSB.append(UtilText.parse(caster, target, "[npc1.name]\u51fb\u4e2d\u4e86" + (target.isPlayer() ? "\u4f60" : "[npc2.name]") + "\u7684[style.boldExcellent(\u8981\u5bb3)]\uff0c\u9020\u6210<b>" + damage + "</b>" + this.damageType.getMultiplierAttribute().getColouredName("b") + "\uff01", new ParserTag[0]));
                }
                if (appliesEffects) {
                    damageCostDescriptionSB.append(UtilText.parse(caster, "[npc.Name]\u7684\u6cd5\u672f\u9020\u6210\u4e86[style.boldExcellent(\u66b4\u51fb)]\uff0c\u6301\u7eed\u65f6\u95f4\u7ffb\u500d\uff01", new ParserTag[0]));
                }
            }
        } else if (!isHit) {
            damageCostDescriptionSB.append(UtilText.parse(caster, "[style.italicsBad([npc1.Name]\u6ca1\u6709\u547d\u4e2d\uff01)]", new ParserTag[0]));
        } else if (damage > 0.0f) {
            damageCostDescriptionSB.append(UtilText.parse(caster, target, "[npc1.name]\u51fb\u4e2d\u4e86" + (target.isPlayer() ? "\u4f60" : "[npc2.name]") + "\uff0c\u9020\u6210<b>" + damage + "</b>" + this.damageType.getMultiplierAttribute().getColouredName("b") + "\uff01", new ParserTag[0]));
        }
        if (damageCostDescriptionSB.toString().toString().equals("<br/>")) {
            return "";
        }
        return damageCostDescriptionSB.toString();
    }

    protected String applyDamage(GameCharacter caster, GameCharacter target, float damage) {
        return this.getDamageType().damageTarget(caster, target, (int)damage).getKey();
    }

    protected String getStatusEffectApplication(GameCharacter caster, GameCharacter target, boolean isHit, boolean isCritical) {
        StringBuilder damageCostDescriptionSB = new StringBuilder();
        if (this.getStatusEffects(caster, target, isCritical) != null && !this.getStatusEffects(caster, target, isCritical).isEmpty() && isHit) {
            damageCostDescriptionSB.append("<br/>" + UtilText.parse(target, (!target.isPlayer() ? "[npc.Name]\u73b0\u5728" : "\u4f60\u73b0\u5728") + (this.isBeneficial() ? "\u53d7\u5230" : "\u53d7\u5230"), new ParserTag[0]));
            int i = 0;
            for (Map.Entry<AbstractStatusEffect, Integer> seEntry : this.getStatusEffects(caster, target, isCritical).entrySet()) {
                if (i != 0) {
                    if (i == this.statusEffects.size() - 1) {
                        damageCostDescriptionSB.append("\u3001");
                    } else {
                        damageCostDescriptionSB.append("\u7684\u5f71\u54cd\u3002");
                    }
                }
                damageCostDescriptionSB.append("\u6301\u7eed<b>" + seEntry.getValue() * (caster.isPlayer() && caster.hasTrait(Perk.JOB_MUSICIAN, true) ? 2 : 1) * (isCritical ? 2 : 1) + "</b>\u56de\u5408" + (String)(caster.hasTrait(Perk.JOB_MUSICIAN, true) ? "(\u7531\u4e8e<b style='color:" + Perk.JOB_MUSICIAN.getColour().toWebHexString() + ";'>" + Perk.JOB_MUSICIAN.getName(caster) + "</b>\u800c[style.boldExcellent(\u7ffb\u500d)])" : "") + "<b style='color:" + seEntry.getKey().getColour().toWebHexString() + ";'>" + seEntry.getKey().getName(target) + "</b>");
                ++i;
            }
            damageCostDescriptionSB.append("\u7684\u5f71\u54cd\u3002");
        }
        return damageCostDescriptionSB.toString();
    }

    public static String getBasicStatusEffectApplication(GameCharacter target, boolean beneficial, Map<AbstractStatusEffect, Integer> statusEffects) {
        StringBuilder damageCostDescriptionSB = new StringBuilder();
        damageCostDescriptionSB.append("<br/>" + UtilText.parse(target, (!target.isPlayer() ? "[npc.She]\u73b0\u5728" : "\u4f60\u73b0\u5728") + (beneficial ? "\u53d7\u5230" : "\u53d7\u5230"), new ParserTag[0]));
        int i = 0;
        for (Map.Entry<AbstractStatusEffect, Integer> seEntry : statusEffects.entrySet()) {
            if (i != 0) {
                if (i == statusEffects.size() - 1) {
                    damageCostDescriptionSB.append("\u3001");
                } else {
                    damageCostDescriptionSB.append("\u3001");
                }
            }
            damageCostDescriptionSB.append("<b>" + String.valueOf(seEntry.getValue()) + "</b>\u56de\u5408<b style='color:" + seEntry.getKey().getColour().toWebHexString() + ";'>" + seEntry.getKey().getName(target) + "</b>");
            ++i;
        }
        damageCostDescriptionSB.append("\u7684\u5f71\u54cd\u3002");
        return damageCostDescriptionSB.toString();
    }

    protected String getCostDescription(GameCharacter caster, float cost) {
        if (cost < 0.0f) {
            return "<br/>\u91ca\u653e\u8be5\u6cd5\u672f\u9700\u8981\u6d88\u8017" + (caster.isPlayer() ? "\u4f60" : UtilText.parse(caster, "[npc.name]", new ParserTag[0])) + "<b>" + -cost + "</b><b style='color:" + Attribute.HEALTH_MAXIMUM.getColour().toWebHexString() + ";'>" + Attribute.HEALTH_MAXIMUM.getName() + "</b>\uff01</b>";
        }
        return "<br/>\u91ca\u653e\u8be5\u6cd5\u672f\u9700\u8981\u6d88\u8017" + (caster.isPlayer() ? "\u4f60" : UtilText.parse(caster, "[npc.name]", new ParserTag[0])) + "<b>" + cost + "</b><b style='color:" + Attribute.MANA_MAXIMUM.getColour().toWebHexString() + ";'>\u7075\u6c14</b>\uff01</b>";
    }

    private static String getCastDescription(GameCharacter caster, GameCharacter target, List<String> chuuniDialogue, String playerSelfCast, String playerCastOnNPC, String NPCSelfCast, String NPCCastOnPlayer, String NPCCastOnNPC) {
        StringBuilder sb = new StringBuilder();
        if (caster.hasTraitActivated(Perk.CHUUNI) && chuuniDialogue != null) {
            sb.append(UtilText.parse(caster, target, "[npc.speech(" + Util.randomItemFrom(chuuniDialogue) + ")]</br>", new ParserTag[0]));
        }
        if (caster.isPlayer()) {
            if (target.isPlayer()) {
                sb.append(playerSelfCast);
            } else {
                sb.append(UtilText.parse(target, playerCastOnNPC, new ParserTag[0]));
            }
        } else if (target.isPlayer()) {
            sb.append(UtilText.parse(caster, NPCCastOnPlayer, new ParserTag[0]));
        } else if (target.equals(caster)) {
            sb.append(UtilText.parse(caster, NPCSelfCast, new ParserTag[0]));
        } else {
            sb.append(UtilText.parse(caster, target, NPCCastOnNPC, new ParserTag[0]));
        }
        return sb.toString();
    }

    public static String getSpellMiscTreeDisplay(GameCharacter character, GameCharacter target) {
        treeSB.setLength(0);
        treeSB.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'><div class='container-full-width' style='text-align:center;'><h6 style='color:" + PresetColour.DAMAGE_TYPE_SPELL.toWebHexString() + ";'>\u79d8\u672f</h6></div>");
        for (Spell spell : Spell.values()) {
            if (spell.isSpellBook()) continue;
            treeSB.append("<div class='container-full-width' style='border:1px solid " + (character.hasSpell(spell, true) ? PresetColour.DAMAGE_TYPE_SPELL : PresetColour.BASE_GREY_DARK).toWebHexString() + "; width:25%; padding:0; margin:0;'>");
            treeSB.append(Spell.appendSpell(character, target, -1, spell, true));
            treeSB.append("</div>");
        }
        treeSB.append("</div>");
        return treeSB.toString();
    }

    public static String getSpellTreesDisplay(SpellSchool school, GameCharacter character, GameCharacter target) {
        treeSB.setLength(0);
        Spell.appendSpellSchool(school, character, target);
        return treeSB.toString();
    }

    private static void appendSpellSchool(SpellSchool spellSchool, GameCharacter character, GameCharacter target) {
        treeSB.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'><div class='container-full-width' style='text-align:center;'><h6 style='color:" + spellSchool.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(spellSchool.getName()) + "</h6><b style='color:" + spellSchool.getColour().toWebHexString() + ";'>" + character.getSpellUpgradePoints(spellSchool) + "</b><b>\u53ef\u7528\u5347\u7ea7\u70b9\u6570</b></div>");
        for (Spell spell : Spell.getSpellsFromSchoolMap().get((Object)spellSchool)) {
            if (!spell.isSpellBook()) continue;
            boolean fullyUpgraded = character.isSpellFullyUpgraded(spell);
            if (spell.getSpellUpgradeTree().isEmpty()) continue;
            treeSB.append("<div class='container-full-width' style='border:1px solid " + (fullyUpgraded ? spell.getSpellSchool().getColour() : PresetColour.BASE_GREY_DARK).toWebHexString() + "; width:25%; padding:0; margin:0;'>");
            for (int row = -1; row < 3; ++row) {
                treeSB.append(Spell.appendSpell(character, target, row, spell, false));
            }
            treeSB.append("</div>");
        }
        treeSB.append("</div>");
    }

    private static String appendSpell(GameCharacter character, GameCharacter target, int row, Spell spell, boolean miscSpell) {
        spellSB.setLength(0);
        spellSB.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'>");
        if (row == -1) {
            boolean hasSpell = character.hasSpell(spell, miscSpell);
            boolean forbidden = spell.isForbiddenSpell();
            spellSB.append("<div class='square-button " + (!hasSpell ? " disabled" : "") + "' style='width:50%; margin:8px 25% 4px 25%; cursor: default; " + (String)(hasSpell ? "border-color:" + spell.getSpellSchool().getColour().toWebHexString() + ";" : "") + "' id='SPELL_TREE_" + String.valueOf((Object)spell) + "'><div class='square-button-content' style='cursor: default;'>" + spell.getSVGString() + "</div>" + (!hasSpell ? (forbidden ? "<div class='overlay disabled-dark' style='cursor:default;'></div>" : "<div style='position:absolute; left:0; top:0; margin:0; padding:0; width:100%; height:100%; background-color:rgba(0,0,0,0.8); '></div>") : "") + "</div>");
            Util.Value<Boolean, String> useDesc = spell.getSpellCastOutOfCombatDescription(character, target);
            spellSB.append("<div class='normal-button " + (useDesc.getKey() != false ? "" : "disabled") + "' id='SPELL_TREE_CAST_" + String.valueOf((Object)spell) + "' style='width:50%; margin:8px 25% " + (miscSpell ? "8px" : "0") + " 25%; text-align:center;'>");
            spellSB.append("\u65bd\u6cd5");
            spellSB.append("</div>");
        } else {
            List<TreeEntry<SpellSchool, SpellUpgrade>> upgradesList = spell.getSpellUpgradeTree().get(row);
            int size = upgradesList.size();
            spellSB.append(Spell.getHorizontalLine(character, spell, row));
            for (TreeEntry<SpellSchool, SpellUpgrade> entry : upgradesList) {
                spellSB.append(Spell.getUpgradeEntry(character, spell, entry, size));
            }
        }
        spellSB.append("</div>");
        return spellSB.toString();
    }

    private static String getHorizontalLine(GameCharacter character, Spell spell, int row) {
        lineSB.setLength(0);
        for (TreeEntry<SpellSchool, SpellUpgrade> entry : spell.getSpellUpgradeTree().get(row)) {
            float entryX = Spell.getX(spell, entry.getRow(), entry);
            for (TreeEntry<SpellSchool, SpellUpgrade> siblingEntry : entry.getSiblingLinks()) {
                float siblingX = Spell.getX(spell, siblingEntry.getRow(), siblingEntry);
                lineSB.append("<div style='width:100%; height:100%; padding:0; margin:0; top:0; left:0; position:absolute; pointer-events:none;'><svg width='100%' height='100%'><line x1='" + siblingX + "%' y1='50%' x2='" + entryX + "%' y2='50%' stroke='" + Spell.getPerkLineSiblingColour(character, spell, entry).toWebHexString() + "' stroke-width='2px'/></svg></div>");
            }
            for (TreeEntry<SpellSchool, SpellUpgrade> parentEntry : entry.getParentLinks()) {
                float parentX = Spell.getX(spell, parentEntry.getRow(), parentEntry);
                String colour = Spell.getPerkLineParentColour(character, spell, entry).toWebHexString();
                if (!(Math.abs(entryX - parentX) > 0.01f)) continue;
                lineSB.append("<div style='width:100%; padding:0; margin:0; top:0; left:0; position:absolute; pointer-events: none;'><svg style='padding:0; margin:0;' width='100%'><line x1='" + entryX + "%' y1='0' x2='" + parentX + "%' y2='0' stroke='" + colour + "' stroke-width='4px'/></svg></div>");
            }
        }
        return lineSB.toString();
    }

    private static float getMargin(int size) {
        return (float)(100 - size * 40) / ((float)size * 2.0f);
    }

    private static float getX(Spell spell, int row, TreeEntry<SpellSchool, SpellUpgrade> entry) {
        List<TreeEntry<SpellSchool, SpellUpgrade>> list = spell.getSpellUpgradeTree().get(row);
        int size = list.size();
        float marginSize = Spell.getMargin(size);
        int column = list.indexOf(entry);
        return marginSize * (float)column * 2.0f + (float)(column * 40) + 20.0f + marginSize;
    }

    private static String getUpgradeEntry(GameCharacter character, Spell spell, TreeEntry<SpellSchool, SpellUpgrade> perkEntry, int size) {
        entrySB.setLength(0);
        boolean forbidden = spell.isForbiddenSpell();
        boolean hasUpgrade = character.hasSpellUpgrade(perkEntry.getEntry());
        boolean isUpgradeAvailable = Spell.isSpellUpgradeAvailable(character, spell, perkEntry);
        float entryX = Spell.getX(spell, perkEntry.getRow(), perkEntry);
        if (!perkEntry.getParentLinks().isEmpty()) {
            entrySB.append("<div style='width:100%; height:100%; padding:0; margin:0; top:0; left:0; position:absolute; pointer-events:none;'><svg width='100%' height='100%'><line x1='" + entryX + "%' y1='0%' x2='" + entryX + "%' y2='50%' stroke='" + Spell.getPerkLineParentColour(character, spell, perkEntry).toWebHexString() + "' stroke-width='2px'/></svg></div>");
        }
        if (!perkEntry.getChildLinks().isEmpty()) {
            entrySB.append("<div style='width:100%; height:100%; padding:0; margin:0; top:0; left:0; position:absolute; pointer-events:none;'><svg width='100%' height='100%'><line x1='" + entryX + "%' y1='100%' x2='" + entryX + "%' y2='50%' stroke='" + Spell.getPerkLineChildColour(character, spell, perkEntry).toWebHexString() + "' stroke-width='2px'/></svg></div>");
        }
        entrySB.append("<div class='square-button round" + (!hasUpgrade && !isUpgradeAvailable ? " disabled" : "") + "' style='width:40%; margin:8px " + Spell.getMargin(size) + "%; " + (String)(character.hasSpellUpgrade(perkEntry.getEntry()) ? "cursor: default; border-color:" + perkEntry.getCategory().getColour().toWebHexString() + ";" : (!perkEntry.getEntry().isAvailable(character) ? "cursor: default; border-color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";" : "")) + "' id='SPELL_UPGRADE_" + String.valueOf((Object)perkEntry.getEntry()) + "'><div class='square-button-content'>" + perkEntry.getEntry().getSVGString() + "</div>" + (!hasUpgrade && !isUpgradeAvailable ? (forbidden ? "<div class='overlay disabled-dark' style='border-radius:50%;'></div>" : "<div style='position:absolute; left:0; top:0; margin:0; padding:0; width:100%; height:100%; background-color:rgba(0,0,0,0.8); border-radius:50%; cursor: default;'></div>") : (!hasUpgrade ? "<div style='position:absolute; left:0; top:0; margin:0; padding:0; width:100%; height:100%; background-color:rgba(0,0,0,0.6); border-radius:50%; cursor:pointer;'></div>" : "")) + "</div>");
        return entrySB.toString();
    }

    public static boolean isSpellUpgradeAvailable(GameCharacter character, Spell spell, TreeEntry<SpellSchool, SpellUpgrade> entry) {
        if (character.hasSpell(spell) && entry.getEntry().isAlwaysAvailable()) {
            return true;
        }
        if (!entry.getEntry().isAvailable(character)) {
            return false;
        }
        if (!character.hasSpellUpgrade(entry.getEntry())) {
            for (TreeEntry<SpellSchool, SpellUpgrade> linkedEntry : entry.getLinks()) {
                if (!character.hasSpellUpgrade(linkedEntry.getEntry())) continue;
                return true;
            }
        }
        return false;
    }

    private static Colour getPerkLineParentColour(GameCharacter character, Spell spell, TreeEntry<SpellSchool, SpellUpgrade> entry) {
        boolean parentOwned = false;
        for (TreeEntry<SpellSchool, SpellUpgrade> parent : entry.getParentLinks()) {
            if (!character.hasSpellUpgrade(parent.getEntry())) continue;
            parentOwned = true;
            break;
        }
        return character.hasSpellUpgrade(entry.getEntry()) && parentOwned ? entry.getCategory().getColour() : (Spell.isSpellUpgradeAvailable(character, spell, entry) ? PresetColour.BASE_GREY : PresetColour.TEXT_GREY_DARK);
    }

    private static Colour getPerkLineChildColour(GameCharacter character, Spell spell, TreeEntry<SpellSchool, SpellUpgrade> entry) {
        boolean childOwned = false;
        boolean childAvailable = false;
        for (TreeEntry<SpellSchool, SpellUpgrade> child : entry.getChildLinks()) {
            if (character.hasSpellUpgrade(child.getEntry())) {
                childOwned = true;
            }
            if (!Spell.isSpellUpgradeAvailable(character, spell, child)) continue;
            childAvailable = true;
        }
        return character.hasSpellUpgrade(entry.getEntry()) && childOwned ? entry.getCategory().getColour() : (childAvailable ? PresetColour.BASE_GREY : PresetColour.TEXT_GREY_DARK);
    }

    private static Colour getPerkLineSiblingColour(GameCharacter character, Spell spell, TreeEntry<SpellSchool, SpellUpgrade> entry) {
        boolean siblingOwned = false;
        boolean siblingAvailable = false;
        for (TreeEntry<SpellSchool, SpellUpgrade> sibling : entry.getSiblingLinks()) {
            if (character.hasSpellUpgrade(sibling.getEntry())) {
                siblingOwned = true;
            }
            if ((!Spell.isSpellUpgradeAvailable(character, spell, sibling) || !character.hasSpellUpgrade(entry.getEntry())) && (!Spell.isSpellUpgradeAvailable(character, spell, entry) || !character.hasSpellUpgrade(sibling.getEntry()))) continue;
            siblingAvailable = true;
        }
        return Spell.isSpellUpgradeAvailable(character, spell, entry) && siblingOwned ? entry.getCategory().getColour() : (siblingAvailable ? PresetColour.BASE_GREY : PresetColour.TEXT_GREY_DARK);
    }

    public int getAPCost() {
        return 1;
    }

    public int getCooldown() {
        return 0;
    }

    public boolean isCanTargetEnemies() {
        return !this.isBeneficial();
    }

    public boolean isCanTargetAllies() {
        return this.isBeneficial();
    }

    public boolean isCanTargetSelf() {
        return this.isBeneficial();
    }

    public Util.Value<Boolean, String> getSpellCastOutOfCombatDescription(GameCharacter owner, GameCharacter target) {
        if (!owner.hasSpell(this)) {
            return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "[npc.Name]\u6ca1\u6709\u5b66\u4f1a\u8be5\u6cd5\u672f\uff0c\u6240\u4ee5\u65e0\u6cd5\u91ca\u653e\uff01", new ParserTag[0]));
        }
        if (Main.game.isInCombat()) {
            return new Util.Value<Boolean, String>(false, UtilText.parse(owner, "\u6218\u6597\u4e2d\u53ea\u80fd\u4ee5\u6218\u6597\u52a8\u4f5c\u91ca\u653e\u6cd5\u672f\uff01", new ParserTag[0]));
        }
        return new Util.Value<Boolean, String>(false, "\u8be5\u6cd5\u672f\u53ea\u80fd\u5728\u6218\u6597\u4e2d\u91ca\u653e\uff01");
    }

    public float getWeight(GameCharacter source, List<GameCharacter> enemies, List<GameCharacter> allies) {
        if (this.isCanTargetAllies() && allies.isEmpty()) {
            return 0.0f;
        }
        if (this.getType().isStatusEffectFocus()) {
            boolean noEffect;
            block14: {
                noEffect = true;
                if (this.isCanTargetEnemies()) {
                    HashSet<GameCharacter> survivingEnemies = new HashSet<GameCharacter>(enemies);
                    survivingEnemies.removeIf(enemy -> Main.combat.isCombatantDefeated((GameCharacter)enemy));
                    for (GameCharacter enemy2 : survivingEnemies) {
                        ArrayList<AbstractStatusEffect> statusEffects = new ArrayList<AbstractStatusEffect>(this.getStatusEffects(source, enemy2, false).keySet());
                        if (statusEffects.isEmpty()) continue;
                        for (AbstractStatusEffect se : statusEffects) {
                            if (enemy2.hasStatusEffect(se)) continue;
                            boolean alreadyTargetedWithThisSpell = false;
                            for (Util.Value<GameCharacter, AbstractCombatMove> move : source.getSelectedMoves()) {
                                if (move.getKey() != enemy2 || move.getValue().getAssociatedSpell() != this) continue;
                                alreadyTargetedWithThisSpell = true;
                                break;
                            }
                            if (alreadyTargetedWithThisSpell) continue;
                            noEffect = false;
                            break block14;
                        }
                    }
                } else {
                    HashSet<GameCharacter> survivingAllies = new HashSet<GameCharacter>(allies);
                    survivingAllies.add(source);
                    survivingAllies.removeIf(ally -> Main.combat.isCombatantDefeated((GameCharacter)ally));
                    for (GameCharacter ally2 : survivingAllies) {
                        ArrayList<AbstractStatusEffect> statusEffects = new ArrayList<AbstractStatusEffect>(this.getStatusEffects(source, ally2, false).keySet());
                        if (statusEffects.isEmpty()) continue;
                        for (AbstractStatusEffect se : statusEffects) {
                            if (ally2.hasStatusEffect(se)) continue;
                            boolean alreadyTargetedWithThisSpell = false;
                            for (Util.Value<GameCharacter, AbstractCombatMove> move : source.getSelectedMoves()) {
                                if (move.getKey() != ally2 || move.getValue().getAssociatedSpell() != this) continue;
                                alreadyTargetedWithThisSpell = true;
                                break;
                            }
                            if (alreadyTargetedWithThisSpell) continue;
                            noEffect = false;
                            break block14;
                        }
                    }
                }
            }
            if (noEffect) {
                return 0.0f;
            }
        }
        int behaviourMultiplier = 1;
        if (source.getCombatBehaviour() == CombatBehaviour.ATTACK && !this.isBeneficial()) {
            behaviourMultiplier = 2;
        }
        if (source.getCombatBehaviour() == CombatBehaviour.SUPPORT && this.isBeneficial()) {
            behaviourMultiplier = 10;
        }
        if (source.getCombatBehaviour() == CombatBehaviour.SPELLS) {
            behaviourMultiplier = 10;
        }
        return 0.2f * (float)behaviourMultiplier - 0.2f * (float)source.getSelectedMovesByType(CombatMoveType.SPELL);
    }

    public GameCharacter getPreferredTarget(GameCharacter source, List<GameCharacter> enemies, List<GameCharacter> allies) {
        GameCharacter preferredTarget;
        if (Main.game.isInCombat() && source.isPlayer()) {
            return Main.combat.getTargetedCombatant();
        }
        if (Main.game.isInCombat() && (preferredTarget = Main.combat.getPreferredTarget(source)) != null && !Main.combat.isCombatantDefeated(preferredTarget)) {
            return preferredTarget;
        }
        if (this.isCanTargetEnemies()) {
            if (AbstractCombatMove.shouldBlunder()) {
                return enemies.get(Util.random.nextInt(enemies.size()));
            }
            float lowestHP = -1.0f;
            GameCharacter potentialCharacter = null;
            if (this.getType().isStatusEffectFocus()) {
                HashSet<GameCharacter> survivingEnemies = new HashSet<GameCharacter>(enemies);
                survivingEnemies.removeIf(enemy -> Main.combat.isCombatantDefeated((GameCharacter)enemy));
                Iterator iterator = survivingEnemies.iterator();
                block0: while (iterator.hasNext()) {
                    GameCharacter enemy2 = (GameCharacter)iterator.next();
                    ArrayList<AbstractStatusEffect> statusEffects = new ArrayList<AbstractStatusEffect>(this.getStatusEffects(source, enemy2, false).keySet());
                    if (statusEffects.isEmpty()) continue;
                    for (AbstractStatusEffect se : statusEffects) {
                        if (enemy2.hasStatusEffect(se)) continue;
                        boolean alreadyTargetedWithThisSpell = false;
                        for (Util.Value<GameCharacter, AbstractCombatMove> move : source.getSelectedMoves()) {
                            if (move.getKey() != enemy2 || move.getValue().getAssociatedSpell() != this) continue;
                            alreadyTargetedWithThisSpell = true;
                            break;
                        }
                        if (alreadyTargetedWithThisSpell) continue;
                        potentialCharacter = enemy2;
                        break block0;
                    }
                }
            }
            if (potentialCharacter == null) {
                for (GameCharacter gameCharacter : enemies) {
                    if (lowestHP != -1.0f && !(gameCharacter.getHealth() < lowestHP)) continue;
                    potentialCharacter = gameCharacter;
                    lowestHP = gameCharacter.getHealth();
                }
            }
            return potentialCharacter;
        }
        if (this.isCanTargetAllies() && !allies.isEmpty()) {
            if (AbstractCombatMove.shouldBlunder()) {
                return allies.get(Util.random.nextInt(allies.size()));
            }
            float lowestHP = -1.0f;
            GameCharacter potentialCharacter = null;
            if (this.getType().isStatusEffectFocus()) {
                HashSet<GameCharacter> survivingAllies = new HashSet<GameCharacter>(allies);
                survivingAllies.add(source);
                survivingAllies.removeIf(ally -> Main.combat.isCombatantDefeated((GameCharacter)ally));
                block4: for (GameCharacter ally2 : survivingAllies) {
                    ArrayList<AbstractStatusEffect> statusEffects = new ArrayList<AbstractStatusEffect>(this.getStatusEffects(source, ally2, false).keySet());
                    if (statusEffects.isEmpty()) continue;
                    for (AbstractStatusEffect se : statusEffects) {
                        if (ally2.hasStatusEffect(se)) continue;
                        boolean alreadyTargetedWithThisSpell = false;
                        for (Util.Value<GameCharacter, AbstractCombatMove> move : source.getSelectedMoves()) {
                            if (move.getKey() != ally2 || move.getValue().getAssociatedSpell() != this) continue;
                            alreadyTargetedWithThisSpell = true;
                            break;
                        }
                        if (alreadyTargetedWithThisSpell) continue;
                        potentialCharacter = ally2;
                        break block4;
                    }
                }
            }
            if (potentialCharacter == null) {
                for (GameCharacter gameCharacter : allies) {
                    if (lowestHP != -1.0f && !(gameCharacter.getHealth() < lowestHP)) continue;
                    potentialCharacter = gameCharacter;
                    lowestHP = gameCharacter.getHealth();
                }
            }
            return potentialCharacter;
        }
        return source;
    }

    public abstract String getBasicEffectsString(GameCharacter var1, GameCharacter var2, List<GameCharacter> var3, List<GameCharacter> var4);

    public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
        StringBuilder predictionSB = new StringBuilder();
        predictionSB.append((isCrit ? "[style.colourExcellent(\u66b4\u51fb)]: " : "") + "\u5bf9[npc2.name]<span style='color:" + this.getSpellSchool().getColour().toWebHexString() + ";'>\u65bd\u653e\u6cd5\u672f\u201c" + this.getName() + "\u201d</span>\u3002");
        if (this.getSpellSchool() == SpellSchool.FIRE && source.hasStatusEffect(StatusEffect.FIRE_MANA_BURN) && Main.combat.getManaBurnStack().get(source).size() > 0 && Main.combat.getManaBurnStack().get(source).peek().floatValue() < 0.0f) {
            predictionSB.append("<br/>\u5c06\u4f1a\u6d88\u8017<b style='color:" + PresetColour.ATTRIBUTE_HEALTH.toWebHexString() + ";'>" + Units.round(-Main.combat.getManaBurnStack().get(source).peek().floatValue(), 1) + Attribute.HEALTH_MAXIMUM.getName() + "</b>([style.colourFire(" + StatusEffect.FIRE_MANA_BURN.getName(source) + ")])\u3002");
        } else {
            predictionSB.append("<br/>\u5c06\u4f1a\u6d88\u8017<b style='color:" + PresetColour.ATTRIBUTE_MANA.toWebHexString() + ";'>" + this.getModifiedCost(source) + "\u7075\u6c14</b>\u3002");
        }
        predictionSB.append("<br/><i>" + this.getBasicEffectsString(source, target, enemies, allies) + "</i>");
        return UtilText.parse(source, target, predictionSB.toString(), new ParserTag[0]);
    }

    public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
        StringBuilder sb = new StringBuilder();
        sb.append(this.applyEffect(source, target, enemies, allies, true, isCrit));
        if (isCrit && !this.isBeneficial() && source.hasPerkAnywhereInTree(Perk.ARCANE_CRITICALS)) {
            sb.append(UtilText.parse(source, "<br/>[npc.NamePos]\u7684\u6cd5\u672f[style.boldExcellent(\u66b4\u51fb)]\u4f7f" + (target.isPlayer() ? "\u4f60" : UtilText.parse(target, "[npc.name]", new ParserTag[0])) + "\u627f\u53d7\u4e86[style.boldArcane(\u5965\u672f\u5f31\u70b9)]\u7684\u6548\u679c\uff01", new ParserTag[0]));
            target.addStatusEffect(StatusEffect.ARCANE_WEAKNESS, 2);
            sb.append(UtilText.parse(target, "<br/>[npc.NameIsFull]\u73b0\u5728\u53d7\u5230\u4e86<b style='color:" + StatusEffect.ARCANE_WEAKNESS.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(StatusEffect.ARCANE_WEAKNESS.getName(target)) + "</b>\u7684\u5f71\u54cd\uff0c\u6301\u7eed<b>\u4e24\u56de\u5408</b>\uff01", new ParserTag[0]));
        }
        return sb.toString();
    }

    public void performOnSelection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        if (this.getSpellSchool() == SpellSchool.FIRE && source.hasStatusEffect(StatusEffect.FIRE_MANA_BURN)) {
            if (!Main.game.isInCombat()) {
                Main.combat.setupManaBurnStackForOutOfCombat(source);
            }
            Main.combat.getManaBurnStack().get(source).push(Float.valueOf(source.burnMana(this.getModifiedCost(source))));
        } else {
            source.incrementMana(-this.getModifiedCost(source));
        }
    }

    public void performOnDeselection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        if (this.getSpellSchool() == SpellSchool.FIRE && source.hasStatusEffect(StatusEffect.FIRE_MANA_BURN)) {
            float amount = Main.combat.getManaBurnStack().get(source).pop().floatValue();
            if (amount < 0.0f) {
                source.incrementHealth(-amount);
            } else {
                source.incrementMana(amount);
            }
        } else {
            source.incrementMana(this.getModifiedCost(source));
        }
    }

    public void applyDisruption(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
    }

    public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        ArrayList<String> critReqs = new ArrayList<String>();
        if (this.getSpellSchool() != SpellSchool.FIRE) {
            return Util.newArrayListOfValues("\u662f\u552f\u4e00\u7684\u884c\u52a8\u3002");
        }
        critReqs.add(UtilText.parse(source, "[npc.NamePos]\u7684" + Attribute.HEALTH_MAXIMUM.getName() + "\u4f4e\u4e8e25%\u3002", new ParserTag[0]));
        return critReqs;
    }

    public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        if (this.getSpellSchool() == SpellSchool.FIRE) {
            return source.getHealthPercentage() <= 0.25f;
        }
        return source.getSelectedMoves().size() <= 1;
    }

    static {
        spellsFromSchoolMap = new HashMap<SpellSchool, List<Spell>>();
        for (SpellSchool spellSchool : SpellSchool.values()) {
            spellsFromSchoolMap.put(spellSchool, new ArrayList());
        }
        for (Enum enum_ : Spell.values()) {
            spellsFromSchoolMap.get((Object)((Spell)enum_).getSpellSchool()).add((Spell)enum_);
        }
        descriptionSB = new StringBuilder();
        spellStealUpgradeTree = new HashMap<Integer, List<TreeEntry<SpellSchool, SpellUpgrade>>>();
        spellStealUpgradeTree.put(0, new ArrayList());
        spellStealUpgradeTree.get(0).add(new TreeEntry<SpellSchool, SpellUpgrade>(SpellSchool.ARCANE, 0, SpellUpgrade.STEAL_1));
        spellStealUpgradeTree.put(1, new ArrayList());
        spellStealUpgradeTree.get(1).add(new TreeEntry<SpellSchool, SpellUpgrade>(SpellSchool.ARCANE, 1, SpellUpgrade.STEAL_2));
        spellStealUpgradeTree.get(1).get(0).addLink(spellStealUpgradeTree.get(0).get(0));
        spellStealUpgradeTree.put(2, new ArrayList());
        spellStealUpgradeTree.get(2).add(new TreeEntry<SpellSchool, SpellUpgrade>(SpellSchool.ARCANE, 2, SpellUpgrade.STEAL_3A));
        spellStealUpgradeTree.get(2).get(0).addLink(spellStealUpgradeTree.get(1).get(0));
        spellStealUpgradeTree.get(2).add(new TreeEntry<SpellSchool, SpellUpgrade>(SpellSchool.ARCANE, 2, SpellUpgrade.STEAL_3B));
        spellStealUpgradeTree.get(2).get(1).addLink(spellStealUpgradeTree.get(2).get(0));
        soothingWatersUpgradeTree = new HashMap<Integer, List<TreeEntry<SpellSchool, SpellUpgrade>>>();
        soothingWatersUpgradeTree.put(0, new ArrayList());
        soothingWatersUpgradeTree.get(0).add(new TreeEntry<SpellSchool, SpellUpgrade>(SpellSchool.WATER, 0, SpellUpgrade.SOOTHING_WATERS_1));
        soothingWatersUpgradeTree.get(0).add(new TreeEntry<SpellSchool, SpellUpgrade>(SpellSchool.WATER, 0, SpellUpgrade.SOOTHING_WATERS_1_CLEAN));
        soothingWatersUpgradeTree.put(1, new ArrayList());
        soothingWatersUpgradeTree.get(1).add(new TreeEntry<SpellSchool, SpellUpgrade>(SpellSchool.WATER, 1, SpellUpgrade.SOOTHING_WATERS_2));
        soothingWatersUpgradeTree.get(1).get(0).addLink(soothingWatersUpgradeTree.get(0).get(0));
        soothingWatersUpgradeTree.get(1).add(new TreeEntry<SpellSchool, SpellUpgrade>(SpellSchool.WATER, 1, SpellUpgrade.SOOTHING_WATERS_2_CLEAN));
        soothingWatersUpgradeTree.put(2, new ArrayList());
        soothingWatersUpgradeTree.get(2).add(new TreeEntry<SpellSchool, SpellUpgrade>(SpellSchool.WATER, 2, SpellUpgrade.SOOTHING_WATERS_3));
        soothingWatersUpgradeTree.get(2).get(0).addLink(soothingWatersUpgradeTree.get(1).get(0));
        treeSB = new StringBuilder();
        spellSB = new StringBuilder();
        lineSB = new StringBuilder();
        entrySB = new StringBuilder();
    }
}

