/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.main.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public class AbstractDialogueFlagValue {
    private String id;
    private int resetHour = -1;

    public AbstractDialogueFlagValue() {
        this(false);
    }

    public AbstractDialogueFlagValue(boolean dailyReset) {
        if (dailyReset) {
            this.resetHour = 0;
        }
    }

    public static List<AbstractDialogueFlagValue> loadFlagsFromFile(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                ArrayList<AbstractDialogueFlagValue> flags = new ArrayList<AbstractDialogueFlagValue>();
                for (Element e : coreElement.getAllOf("flag")) {
                    AbstractDialogueFlagValue newFlag = new AbstractDialogueFlagValue(Boolean.valueOf(e.getAttribute("dailyReset".trim())));
                    if (!e.getAttribute("resetHour").isEmpty()) {
                        newFlag.resetHour = Integer.valueOf(e.getAttribute("resetHour"));
                    }
                    newFlag.id = author + "_" + e.getTextContent();
                    flags.add(newFlag);
                }
                return flags;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractDialogueFlagValue was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
        return null;
    }

    public int getResetHour() {
        return this.resetHour;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

