/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.npcDialogue.QuickTransformations;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.AlleywayAttackerDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.AlleywayDemonDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.HarpyAttackerDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.offspring.GenericOffspringDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.submission.BatCavernDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.submission.TunnelAttackDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.harpyNests.HarpyNestBimbo;
import com.lilithsthrone.game.dialogue.places.dominion.harpyNests.HarpyNestDominant;
import com.lilithsthrone.game.dialogue.places.dominion.harpyNests.HarpyNestNympho;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.RoomPlayer;
import com.lilithsthrone.game.dialogue.places.dominion.slaverAlley.SlaverAlleyDialogue;
import com.lilithsthrone.game.dialogue.places.submission.LyssiethPalaceDialogue;
import com.lilithsthrone.game.dialogue.places.submission.dicePoker.DicePoker;
import com.lilithsthrone.game.dialogue.utils.BodyChanging;
import com.lilithsthrone.game.dialogue.utils.CosmeticsDialogue;
import com.lilithsthrone.game.dialogue.utils.MiscDialogue;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DialogueManager {
    private static List<DialogueNode> allDialogues = new ArrayList<DialogueNode>();
    private static Map<DialogueNode, String> dialogueToIdMap = new HashMap<DialogueNode, String>();
    private static Map<String, DialogueNode> idToDialogueMap = new HashMap<String, DialogueNode>();

    public static Map<DialogueNode, String> getDialogueToIdMap() {
        return dialogueToIdMap;
    }

    public static Map<String, DialogueNode> getIdToDialogueMap() {
        return idToDialogueMap;
    }

    public String getDialogueFromFile(String pathName, String tag, GameCharacter ... specialNPCs) {
        return UtilText.parseFromXMLFile(new ArrayList<ParserTag>(), "res", pathName, tag, Arrays.asList(specialNPCs));
    }

    public static List<DialogueNode> getAllDialogues() {
        return allDialogues;
    }

    public static DialogueNode getDialogueFromId(String id) {
        if ((id = id.trim()) == null || id.equalsIgnoreCase("null") || id.equalsIgnoreCase("empty") || id.isEmpty()) {
            return null;
        }
        if (id.equalsIgnoreCase("default")) {
            return Main.game.getDefaultDialogue(false);
        }
        if (id.equalsIgnoreCase("defaultWithEncounter")) {
            return Main.game.getDefaultDialogue(true);
        }
        if (id.equalsIgnoreCase("defaultForceEncounter")) {
            DialogueNode dn = Main.game.getDefaultDialogue(true, true);
            return dn;
        }
        id = Util.getClosestStringMatch(id, idToDialogueMap.keySet());
        return idToDialogueMap.get(id);
    }

    public static String getIdFromDialogue(DialogueNode placeType) {
        return dialogueToIdMap.get(placeType);
    }

    private static void addHardCodedDialogueId(String id, DialogueNode node) {
        allDialogues.add(node);
        dialogueToIdMap.put(node, id);
        idToDialogueMap.put(id, node);
    }

    static {
        DialogueManager.addHardCodedDialogueId("MERAXIS_DEMON_TF_START", LyssiethPalaceDialogue.MERAXIS_DEMON_TF_START);
        DialogueManager.addHardCodedDialogueId("ROOM_SET_ALARM", RoomPlayer.ROOM_SET_ALARM);
        DialogueManager.addHardCodedDialogueId("BEAUTICIAN_START", CosmeticsDialogue.BEAUTICIAN_START);
        DialogueManager.addHardCodedDialogueId("BODY_CHANGING_CORE", BodyChanging.BODY_CHANGING_CORE);
        DialogueManager.addHardCodedDialogueId("QUICK_TRANSFORMATIONS_START", QuickTransformations.QUICK_TRANSFORMATIONS_FEMININITY);
        DialogueManager.addHardCodedDialogueId("OFFSPRING_ENCOUNTER", GenericOffspringDialogue.OFFSPRING_ENCOUNTER);
        DialogueManager.addHardCodedDialogueId("HARPY_NEST_BIMBO_TALK", HarpyNestBimbo.HARPY_NEST_BIMBO_TALK);
        DialogueManager.addHardCodedDialogueId("HARPY_NEST_BIMBO_QUEEN", HarpyNestBimbo.HARPY_NEST_BIMBO_QUEEN);
        DialogueManager.addHardCodedDialogueId("HARPY_NEST_BIMBO_UGLY", HarpyNestBimbo.HARPY_NEST_BIMBO_UGLY);
        DialogueManager.addHardCodedDialogueId("HARPY_NEST_DOMINANT_TALK", HarpyNestDominant.HARPY_NEST_DOMINANT_TALK);
        DialogueManager.addHardCodedDialogueId("HARPY_NEST_DOMINANT_QUEEN", HarpyNestDominant.HARPY_NEST_DOMINANT_QUEEN);
        DialogueManager.addHardCodedDialogueId("HARPY_NEST_DOMINANT_UGLY", HarpyNestDominant.HARPY_NEST_DOMINANT_UGLY);
        DialogueManager.addHardCodedDialogueId("HARPY_NEST_NYMPHO_TALK", HarpyNestNympho.HARPY_NEST_NYMPHO_TALK);
        DialogueManager.addHardCodedDialogueId("HARPY_NEST_NYMPHO_QUEEN", HarpyNestNympho.HARPY_NEST_NYMPHO_QUEEN);
        DialogueManager.addHardCodedDialogueId("HARPY_NEST_NYMPHO_UGLY", HarpyNestNympho.HARPY_NEST_NYMPHO_UGLY);
        DialogueManager.addHardCodedDialogueId("DICE_POKER_CORE", DicePoker.GAMBLING);
        DialogueManager.addHardCodedDialogueId("HC_encounter_alleyway_defeat", AlleywayAttackerDialogue.AFTER_COMBAT_DEFEAT);
        DialogueManager.addHardCodedDialogueId("HC_encounter_alleyway_victory", AlleywayAttackerDialogue.AFTER_COMBAT_VICTORY);
        DialogueManager.addHardCodedDialogueId("HC_encounter_alleyway_demon_defeat", AlleywayDemonDialogue.AFTER_COMBAT_DEFEAT);
        DialogueManager.addHardCodedDialogueId("HC_encounter_alleyway_demon_victory", AlleywayDemonDialogue.AFTER_COMBAT_VICTORY);
        DialogueManager.addHardCodedDialogueId("HC_encounter_harpy_nest_defeat", HarpyAttackerDialogue.AFTER_COMBAT_DEFEAT);
        DialogueManager.addHardCodedDialogueId("HC_encounter_harpy_nest_victory", HarpyAttackerDialogue.AFTER_COMBAT_VICTORY);
        DialogueManager.addHardCodedDialogueId("HC_encounter_submission_defeat", TunnelAttackDialogue.AFTER_COMBAT_DEFEAT);
        DialogueManager.addHardCodedDialogueId("HC_encounter_submission_victory", TunnelAttackDialogue.AFTER_COMBAT_VICTORY);
        DialogueManager.addHardCodedDialogueId("HC_encounter_bat_caverns_defeat", BatCavernDialogue.AFTER_COMBAT_DEFEAT);
        DialogueManager.addHardCodedDialogueId("HC_encounter_bat_caverns_victory", BatCavernDialogue.AFTER_COMBAT_VICTORY);
        DialogueManager.addHardCodedDialogueId("MARKET_STALL_CAFE_INTERIOR_NO_CONTENT", SlaverAlleyDialogue.MARKET_STALL_CAFE_INTERIOR_NO_CONTENT);
        DialogueManager.addHardCodedDialogueId("DOLL_BROCHURE", MiscDialogue.DOLL_BROCHURE);
        DialogueManager.addHardCodedDialogueId("SLAVE_DOLLIFICATION", MiscDialogue.SLAVE_DOLLIFICATION);
        DialogueManager.addHardCodedDialogueId("SAELLATRIX_DOLL_CORE", MiscDialogue.SAELLATRIX_DOLL_CORE);
        DialogueManager.addHardCodedDialogueId("SAELLATRIX_DOLL_PUSSY", MiscDialogue.SAELLATRIX_DOLL_PUSSY);
        DialogueManager.addHardCodedDialogueId("SAELLATRIX_DOLL_ASS", MiscDialogue.SAELLATRIX_DOLL_ASS);
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/dialogue");
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                try {
                    List<DialogueNode> nodes = DialogueNode.loadDialogueNodesFromFile(innerEntry.getKey(), innerEntry.getValue(), entry.getKey(), true);
                    for (DialogueNode node : nodes) {
                        allDialogues.add(node);
                        dialogueToIdMap.put(node, node.getId());
                        idToDialogueMap.put(node.getId(), node);
                    }
                }
                catch (Exception ex) {
                    System.err.println("Loading modded dialogue type failed at 'Dialogue'. File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/dialogue");
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("dialogueNodes")) continue;
                try {
                    List<DialogueNode> nodes = DialogueNode.loadDialogueNodesFromFile(innerEntry.getKey(), innerEntry.getValue(), entry.getKey(), false);
                    for (DialogueNode node : nodes) {
                        allDialogues.add(node);
                        dialogueToIdMap.put(node, node.getId());
                        idToDialogueMap.put(node.getId(), node);
                    }
                }
                catch (Exception ex) {
                    System.err.println("Loading dialogue type failed at 'Dialogue'. File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
    }
}

