/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.companions;

import com.lilithsthrone.controller.MainController;
import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AffectionLevel;
import com.lilithsthrone.game.character.attributes.ObedienceLevel;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringCategory;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.valueEnums.BodyMaterial;
import com.lilithsthrone.game.character.effects.PerkManager;
import com.lilithsthrone.game.character.markings.TattooCounterType;
import com.lilithsthrone.game.character.markings.TattooType;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.dominion.Brax;
import com.lilithsthrone.game.character.npc.dominion.Scarlett;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.companions.OccupantManagementDialogue;
import com.lilithsthrone.game.dialogue.companions.SlaveDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.shoppingArcade.SuccubisSecrets;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.utils.BodyChanging;
import com.lilithsthrone.game.dialogue.utils.CharacterModificationUtils;
import com.lilithsthrone.game.dialogue.utils.CharactersPresentDialogue;
import com.lilithsthrone.game.dialogue.utils.CombatMovesSetup;
import com.lilithsthrone.game.dialogue.utils.CosmeticsDialogue;
import com.lilithsthrone.game.dialogue.utils.InventoryInteraction;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.SpellManagement;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectTimer;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.occupantManagement.OccupancyUtil;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJob;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJobFlag;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJobHours;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJobSetting;
import com.lilithsthrone.game.occupantManagement.slave.SlavePermission;
import com.lilithsthrone.game.occupantManagement.slave.SlavePermissionSetting;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompanionManagement {
    private static DecimalFormat decimalFormat = new DecimalFormat("#0.00");
    private static DialogueNode coreNode;
    private static int defaultResponseTab;
    private static SlaveJob[] savedJobSchedule;
    private static Map<SlaveJob, Set<SlaveJobSetting>> savedJobSettings;
    private static Map<SlavePermission, Set<SlavePermissionSetting>> savedPermissions;
    public static final DialogueNode SLAVE_MANAGEMENT_INSPECT;
    public static final DialogueNode SLAVE_MANAGEMENT_JOBS;
    public static final DialogueNode SLAVE_MANAGEMENT_PERMISSIONS;
    public static final DialogueNode SLAVE_MANAGEMENT_COSMETICS_MAKEUP;
    public static final DialogueNode SLAVE_MANAGEMENT_COSMETICS_HAIR;
    public static final DialogueNode SLAVE_MANAGEMENT_COSMETICS_PIERCINGS;
    public static final DialogueNode SLAVE_MANAGEMENT_COSMETICS_EYES;
    public static final DialogueNode SLAVE_MANAGEMENT_COSMETICS_COVERINGS;
    public static final DialogueNode SLAVE_MANAGEMENT_COSMETICS_OTHER;
    public static final DialogueNode SLAVE_MANAGEMENT_TATTOOS;
    public static final DialogueNode SLAVE_MANAGEMENT_TATTOOS_ADD;
    public static final DialogueNode SLAVE_MANAGEMENT_PERKS;
    public static final DialogueNode OCCUPANT_CHOOSE_NAME;
    public static final DialogueNode SET_SLAVE_FREE_SCARLETT;
    private static boolean freedSlaveDeleted;
    public static final DialogueNode SET_SLAVE_FREE;
    public static final DialogueNode SET_SLAVE_FREE_END_NO_CONTENT;
    public static final DialogueNode SET_SLAVE_FREE_GUEST_ROOM;

    public static boolean isJobSchedulePasteAvailable() {
        return savedJobSchedule != null;
    }

    public static void copyJobSchedule() {
        savedJobSchedule = new SlaveJob[24];
        for (int i = 0; i < savedJobSchedule.length; ++i) {
            CompanionManagement.savedJobSchedule[i] = CompanionManagement.characterSelected().getSlaveJob(i);
        }
    }

    public static boolean pasteJobSchedule() {
        boolean fullSuccess = true;
        CompanionManagement.characterSelected().setSlaveJob24Hours(SlaveJob.IDLE);
        for (int i = 0; i < savedJobSchedule.length; ++i) {
            SlaveJob jobAtHour = savedJobSchedule[i];
            float stamina = CompanionManagement.characterSelected().getDailySlaveJobStamina();
            if (jobAtHour.isAvailable(i, CompanionManagement.characterSelected()) && !jobAtHour.isHidden(CompanionManagement.characterSelected()) && (CompanionManagement.characterSelected().isSlave() || stamina - jobAtHour.getHourlyStaminaDrain(CompanionManagement.characterSelected()) + CompanionManagement.characterSelected().getSlaveJob(i).getHourlyStaminaDrain(CompanionManagement.characterSelected()) >= 0.0f && !CompanionManagement.characterSelected().isSleepingAtHour(i) && jobAtHour.hasFlag(SlaveJobFlag.GUEST_CAN_WORK))) {
                CompanionManagement.characterSelected().setSlaveJob(i, jobAtHour);
                continue;
            }
            fullSuccess = false;
        }
        return fullSuccess;
    }

    public static boolean isJobSettingsPasteAvailable() {
        return savedJobSettings != null;
    }

    public static void copyJobSettings() {
        savedJobSettings = new HashMap<SlaveJob, Set<SlaveJobSetting>>();
        for (SlaveJob job : SlaveJob.values()) {
            savedJobSettings.putIfAbsent(job, new HashSet());
            for (SlaveJobSetting jobSetting : CompanionManagement.characterSelected().getSlaveJobSettings(job)) {
                savedJobSettings.get((Object)job).add(jobSetting);
            }
        }
    }

    public static void pasteJobSettings() {
        for (SlaveJob job : SlaveJob.values()) {
            CompanionManagement.characterSelected().clearSlaveJobSettings(job);
            for (SlaveJobSetting jobSetting : savedJobSettings.get((Object)job)) {
                CompanionManagement.characterSelected().addSlaveJobSettings(job, jobSetting);
            }
        }
    }

    public static boolean isPermissionsPasteAvailable() {
        return savedPermissions != null;
    }

    public static void copyPermissions() {
        savedPermissions = new HashMap<SlavePermission, Set<SlavePermissionSetting>>();
        for (Map.Entry<SlavePermission, Set<SlavePermissionSetting>> entry : CompanionManagement.characterSelected().getSlavePermissionSettings().entrySet()) {
            savedPermissions.put(entry.getKey(), new HashSet());
            for (SlavePermissionSetting setting : entry.getValue()) {
                savedPermissions.get((Object)entry.getKey()).add(setting);
            }
        }
    }

    public static void pastePermissions() {
        CompanionManagement.characterSelected().replaceSlavePermissionSettings(savedPermissions);
    }

    public static DialogueNode getCoreNode() {
        return coreNode;
    }

    public static int getDefaultResponseTab() {
        return defaultResponseTab;
    }

    public static void initManagement(DialogueNode coreNode, int defaultResponseTab, NPC targetedCharacter) {
        if (Main.game.getCurrentDialogueNode().getDialogueNodeType() == DialogueNodeType.NORMAL) {
            Main.game.saveDialogueNode();
        }
        CompanionManagement.coreNode = coreNode;
        CompanionManagement.defaultResponseTab = defaultResponseTab;
        Main.game.getDialogueFlags().setManagementCompanion(targetedCharacter);
        if (targetedCharacter != null && !targetedCharacter.isSlave() && !Main.game.getDialogueFlags().getSlaveryManagerJobSelected().hasFlag(SlaveJobFlag.GUEST_CAN_WORK)) {
            Main.game.getDialogueFlags().setSlaveryManagerJobSelected(SlaveJob.IDLE);
        }
    }

    public static DialogueNode getSlaveryManagementInspectSlaveDialogue(NPC slave) {
        Main.game.getDialogueFlags().setManagementCompanion(slave);
        CharactersPresentDialogue.resetContent(slave);
        return SLAVE_MANAGEMENT_INSPECT;
    }

    public static DialogueNode getSlaveryManagementSlaveJobsDialogue(NPC slave) {
        Main.game.getDialogueFlags().setManagementCompanion(slave);
        CharactersPresentDialogue.resetContent(slave);
        return SLAVE_MANAGEMENT_JOBS;
    }

    public static DialogueNode getSlaveryManagementSlavePermissionsDialogue(NPC slave) {
        Main.game.getDialogueFlags().setManagementCompanion(slave);
        CharactersPresentDialogue.resetContent(slave);
        return SLAVE_MANAGEMENT_PERMISSIONS;
    }

    public static DialogueNode getSlaveryManagementSlaveCosmeticsDialogue(NPC slave) {
        Main.game.getDialogueFlags().setManagementCompanion(slave);
        CharactersPresentDialogue.resetContent(slave);
        return SLAVE_MANAGEMENT_COSMETICS_MAKEUP;
    }

    public static NPC characterSelected() {
        return Main.game.getDialogueFlags().getManagementCompanion();
    }

    private static String getSlaveInformationHeader(NPC character) {
        StringBuilder headerSB = new StringBuilder();
        AffectionLevel affection = AffectionLevel.getAffectionLevelFromValue(character.getAffection(Main.game.getPlayer()));
        ObedienceLevel obedience = ObedienceLevel.getObedienceLevelFromValue(character.getObedienceValue());
        float affectionChange = character.getDailyAffectionChange();
        float obedienceChange = character.getDailyObedienceChange();
        headerSB.append("<div class='container-full-width' style='margin-top:0; text-align:center; border-radius: 5px 0 0 5px;'><div class='container-full-width inner' style='margin-bottom:0;'><div style='width:30%; float:left; font-weight:bold; margin:0; padding:0;'>\u4f4d\u7f6e</div><div style='float:left; width:20%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.AFFECTION.toWebHexString() + ";'>\u597d\u611f</b></div><div style='float:left; width:20%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.OBEDIENCE.toWebHexString() + ";'>\u670d\u4ece</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.CURRENCY_GOLD.toWebHexString() + ";'>\u6536\u5165</b></div><div style='width:15%; float:left; font-weight:bold; margin:0; padding:0;'>\u4ef7\u503c</div></div><div class='container-full-width inner' style='margin-top:0; border-radius: 0 5px 5px; 0'><div style='width:30%; float:left; margin:0; padding:0;'><b style='color:" + character.getLocationPlace().getColour().toWebHexString() + ";'>" + character.getLocationPlace().getName() + "</b>,<br/><span style='color:" + character.getWorldLocation().getColour().toWebHexString() + ";'>" + character.getWorldLocation().getName() + "</span></div><div style='float:left; width:20%; margin:0; padding:0;'><b style='color:" + affection.getColour().toWebHexString() + ";'>" + character.getAffection(Main.game.getPlayer()) + "</b><br/><span style='color:" + (affectionChange == 0.0f ? PresetColour.BASE_GREY : (affectionChange > 0.0f ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_BAD)).toWebHexString() + ";'>" + (affectionChange > 0.0f ? "+" : "") + decimalFormat.format(affectionChange) + "</span>/\u5929<br/><span style='color:" + affection.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(affection.getName()) + "</span></div><div style='float:left; width:20%; margin:0; padding:0;'><b style='color:" + obedience.getColour().toWebHexString() + ";'>" + character.getObedienceValue() + "</b><br/><span style='color:" + (obedienceChange == 0.0f ? PresetColour.BASE_GREY : (obedienceChange > 0.0f ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_BAD)).toWebHexString() + ";'>" + (obedienceChange > 0.0f ? "+" : "") + decimalFormat.format(obedienceChange) + "</span>/\u5929<br/><span style='color:" + obedience.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(obedience.getName()) + "</span></div><div style='float:left; width:15%; margin:0; padding:0;'>" + UtilText.formatAsMoney(SlaveJob.getFinalDailyIncomeAfterModifiers(character)) + "/\u5929</div><div style='float:left; width:15%; margin:0; padding:0;'>" + UtilText.formatAsMoney(character.getValueAsSlave(true)) + "</div></div>");
        headerSB.append("<div class='container-half-width' style='width:50%; margin:0;'>[style.boldExcellent(\u804c\u4e1a\u8bbe\u7f6e: )]");
        ArrayList<String> noPermissions = new ArrayList<String>();
        for (SlaveJob job : SlaveJob.values()) {
            if (!character.hasSlaveJobAssigned(job)) continue;
            ArrayList<String> permissions = new ArrayList<String>();
            if (!character.getSlaveJobSettings(job).isEmpty()) {
                headerSB.append("<br/><b>" + Util.capitaliseSentence(job.getName(character)) + ":</b>");
                for (SlaveJobSetting slaveJobSetting : character.getSlaveJobSettings(job)) {
                    permissions.add("<span style='color:" + slaveJobSetting.getColour().toWebHexString() + ";'>" + slaveJobSetting.getName() + "</span>");
                }
                headerSB.append(Util.stringsToStringList(permissions, false) + "\u3002");
                continue;
            }
            noPermissions.add(job.getName(character));
        }
        if (!noPermissions.isEmpty()) {
            headerSB.append("<br/><b>" + Util.stringsToStringList(noPermissions, true) + ":</b>[style.colourDisabled(n/a)]");
        }
        headerSB.append("</div>");
        if (CompanionManagement.characterSelected().isSlave()) {
            headerSB.append("<div class='container-half-width' style='width:50%; margin:0;'>[style.boldArcane(\u5e38\u89c4\u6743\u9650: )]<br/>");
            int permissionCount = 0;
            for (SlavePermission permission : SlavePermission.values()) {
                if (!permission.isAvailableForCharacter(character)) continue;
                for (SlavePermissionSetting slavePermissionSetting : permission.getSettings()) {
                    if (!slavePermissionSetting.isAvailableForCharacter(character) || !character.getSlavePermissionSettings().get((Object)permission).contains((Object)slavePermissionSetting)) continue;
                    headerSB.append((permissionCount == 0 ? "" : ", ") + "<span style='color:" + permission.getColour().toWebHexString() + ";'>" + slavePermissionSetting.getName() + "</span>");
                    ++permissionCount;
                }
            }
            headerSB.append("\u3002</div>");
        }
        headerSB.append("</div>");
        return headerSB.toString();
    }

    private static String getBusyWarning() {
        return "<br/>[style.italicsMinorBad(\u53ea\u80fd\u5728\u4e00\u4e2a\u5730\u5757\u7684\u9ed8\u8ba4\u5bf9\u8bdd\u4e2d\u4f7f\u7528\u3002)]";
    }

    public static Response getManagementResponses(int index) {
        if (coreNode == CharactersPresentDialogue.MENU) {
            List<NPC> charactersPresent = Main.game.getCharactersPresent();
            Collections.sort(charactersPresent, (c1, c2) -> Main.game.getPlayer().hasCompanion((GameCharacter)c1) ? 1 : 0);
            if (index == 0) {
                return new ResponseEffectsOnly("\u8fd4\u56de", "\u505c\u6b62\u6d4f\u89c8\u5728\u573a\u89d2\u8272\u5e76\u56de\u5230\u6e38\u620f\u3002"){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setManagementCompanion(null);
                        Main.game.restoreSavedContent(false);
                        MainController.updateUI();
                    }
                };
            }
            if (index == 1) {
                if (Main.game.getCurrentDialogueNode() == SLAVE_MANAGEMENT_INSPECT) {
                    return new Response("\u5ba1\u89c6", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u6b63\u5728\u4ed4\u7ec6\u6253\u91cf[npc.name]\uff01", new ParserTag[0]), null);
                }
                return new Response("\u5ba1\u89c6", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4ed4\u7ec6\u6253\u91cf[npc.name]\u3002", new ParserTag[0]), SLAVE_MANAGEMENT_INSPECT);
            }
            if (index == 2) {
                if (Main.game.getCurrentDialogueNode() == SLAVE_MANAGEMENT_JOBS) {
                    return new Response("\u5de5\u4f5c", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u6b63\u5728\u8bbe\u5b9a[npc.namePos]\u7684\u5de5\u4f5c\u548c\u5de5\u65f6\uff01", new ParserTag[0]), null);
                }
                if (!CompanionManagement.characterSelected().hasJob()) {
                    return new Response("\u5de5\u4f5c", "\u8bbe\u5b9a\u8be5\u89d2\u8272\u7684\u5de5\u4f5c\u548c\u5de5\u65f6\u3002", SLAVE_MANAGEMENT_JOBS);
                }
                return new Response("\u5de5\u4f5c", "\u4f60\u4e0d\u80fd\u7ba1\u7406\u5df2\u53d7\u96c7\u5c45\u6c11\u7684\u5de5\u4f5c\u3002\u8be5\u9009\u9879\u53ea\u80fd\u5e94\u7528\u4e8e\u5974\u96b6\u548c\u65e0\u4e1a\u6e38\u6c11\u3002", null);
            }
            if (index == 3) {
                if (Main.game.getCurrentDialogueNode() == SLAVE_MANAGEMENT_PERMISSIONS) {
                    return new Response("\u6743\u9650", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u5df2\u7ecf\u8bbe\u7f6e\u4e86[npc.namePos]\u7684\u6743\u9650\uff01", new ParserTag[0]), null);
                }
                if (CompanionManagement.characterSelected().isSlave()) {
                    return new Response("\u6743\u9650", "\u8bbe\u5b9a\u8be5\u5974\u96b6\u7684\u5de5\u4f5c\u548c\u5de5\u65f6\u3002", SLAVE_MANAGEMENT_PERMISSIONS);
                }
                return new Response("\u6743\u9650", "\u4f60\u65e0\u6cd5\u7ba1\u7406\u81ea\u7531\u540c\u4f34\u7684\u6743\u9650\u3002\u8be5\u9009\u9879\u4ec5\u9002\u7528\u4e8e\u5974\u96b6\u3002", null);
            }
            if (index == 4) {
                if (!Main.game.isSavedDialogueNeutral()) {
                    return new Response("\u7269\u54c1\u680f", "\u4f60\u73b0\u5728\u6b63\u5fd9\u5f97\u4e0d\u53ef\u5f00\u4ea4\uff01" + CompanionManagement.getBusyWarning(), null);
                }
                return new ResponseEffectsOnly("\u7269\u54c1\u680f", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u7ba1\u7406[npc.namePos]\u7684\u7269\u54c1\u680f\u3002", new ParserTag[0])){

                    @Override
                    public void effects() {
                        Main.mainController.openInventory(CompanionManagement.characterSelected(), InventoryInteraction.FULL_MANAGEMENT);
                    }
                };
            }
            if (index == 5) {
                return new Response("\u9001\u5230\u51ef\u7279\u90a3\u91cc", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u4e0d\u80fd\u628a\u961f\u4f0d\u6210\u5458\u9001\u5230\u51ef\u7279\u90a3\u91cc\uff01\u4f60\u9700\u8981\u5148\u628a[npc.name]\u9001\u56de\u5bb6\u2026\u2026", new ParserTag[0]), null);
            }
            if (index == 6) {
                if (Main.game.getCurrentDialogueNode() == SLAVE_MANAGEMENT_PERKS) {
                    return new Response("[style.colourMinorBad(\u91cd\u7f6e\u5929\u8d4b)]", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u91cd\u7f6e[npc.namePos]\u6240\u6709\u7684\u5929\u8d4b\u548c\u7279\u6027\uff0c\u8fd4\u8fd8\u6240\u6709\u6d88\u8017\u7684\u5929\u8d4b\u70b9\u3002(\u4e34\u65f6\u53ef\u7528\uff0c\u7531\u4e8e\u5929\u8d4b\u6811\u4ecd\u5728\u5f00\u53d1\u4e2d\u3002)", new ParserTag[0]), Main.game.getCurrentDialogueNode()){

                        @Override
                        public void effects() {
                            CompanionManagement.characterSelected().resetPerksMap(false, false);
                        }
                    };
                }
                return new Response("\u5929\u8d4b", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u5206\u914d[npc.namePos]\u7684\u5929\u8d4b\u70b9\u3002", new ParserTag[0]), SLAVE_MANAGEMENT_PERKS);
            }
            if (index == 7) {
                if (CompanionManagement.characterSelected().isDoll() && (Main.game.getPlayer().hasItemType(ItemType.DOLL_CONSOLE) || CompanionManagement.characterSelected().hasItemType(ItemType.DOLL_CONSOLE))) {
                    return new ResponseEffectsOnly("\u8f6c\u5316", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f7f\u7528\u4f60\u7684D.E.C.K.\u6765\u5b9a\u5236[npc.namePos]\u7684\u5916\u8c8c\u3002", new ParserTag[0])){

                        @Override
                        public void effects() {
                            ItemEffectType.DOLL_CONSOLE.itemEffectOverride(TFModifier.NONE, TFModifier.NONE, TFPotency.BOOST, 0, Main.game.getPlayer(), CompanionManagement.characterSelected(), new ItemEffectTimer());
                        }
                    };
                }
                if (!CompanionManagement.characterSelected().isAbleToSelfTransform()) {
                    return new Response("\u8f6c\u5316", CompanionManagement.characterSelected().getUnableToTransformDescription(), null);
                }
                if (!Main.game.isSavedDialogueNeutral()) {
                    return new Response("\u8f6c\u5316", "\u4f60\u73b0\u5728\u6b63\u5fd9\u7740\u505a\u522b\u7684\u4e8b\uff01" + CompanionManagement.getBusyWarning(), null);
                }
                return new Response("\u8f6c\u5316", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4ed4\u7ec6\u89c2\u5bdf[npc.name]\u4f1a\u5c06\u81ea\u5df1\u8f6c\u5316\u6210\u4ec0\u4e48\u6837\u2026\u2026", new ParserTag[0]), BodyChanging.BODY_CHANGING_CORE){

                    @Override
                    public void effects() {
                        BodyChanging.setTarget(CompanionManagement.characterSelected());
                    }
                };
            }
            if (index == 8) {
                if (Main.game.getCurrentDialogueNode() == OCCUPANT_CHOOSE_NAME) {
                    return new Response("\u8bbe\u5b9a\u540d\u5b57", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u6b63\u5728\u7ba1\u7406[npc.namePos]\u7684\u540d\u5b57\uff01", new ParserTag[0]), null);
                }
                if (!Main.game.isSavedDialogueNeutral()) {
                    return new Response("\u8bbe\u5b9a\u540d\u5b57", "\u4f60\u73b0\u5728\u6b63\u5fd9\u7740\u505a\u522b\u7684\u4e8b\uff01" + CompanionManagement.getBusyWarning(), null);
                }
                return new Response("\u8bbe\u5b9a\u540d\u5b57", CompanionManagement.characterSelected().isSlave() ? UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u66f4\u6539[npc.namePos]\u7684\u540d\u5b57\u6216\u8ba9[npc.herHim]\u4ee5\u4e0d\u540c\u7684\u540d\u5b57\u79f0\u547c\u4f60\u3002", new ParserTag[0]) : UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u8ba9[npc.name]\u4ee5\u4e0d\u540c\u7684\u540d\u5b57\u79f0\u547c\u4f60\u3002", new ParserTag[0]), OCCUPANT_CHOOSE_NAME);
            }
            if (index == 10) {
                if (Main.game.getPlayer().isCaptive()) {
                    return new Response(CompanionManagement.characterSelected().isElemental() ? "\u9a71\u6563" : "\u9001\u56de\u5bb6", "\u56e0\u4e3a\u4f60\u662f\u4e2a\u4fd8\u864f\uff0c\u73b0\u5728\u4e0d\u80fd\u89e3\u6563\u540c\u4f34\uff01", null);
                }
                if (!Main.game.isSavedDialogueNeutral()) {
                    return new Response(CompanionManagement.characterSelected().isElemental() ? "\u9a71\u6563" : "\u9001\u56de\u5bb6", "\u4f60\u73b0\u5728\u6b63\u5fd9\u7740\u505a\u522b\u7684\u4e8b\uff01" + CompanionManagement.getBusyWarning(), null);
                }
                if (charactersPresent.size() == 1 || charactersPresent.size() == 2 && CompanionManagement.characterSelected().isElementalSummoned() && !Main.game.getPlayer().isElementalSummoned()) {
                    return new ResponseEffectsOnly(CompanionManagement.characterSelected().isElemental() ? "\u9a71\u6563" : "\u9001\u56de\u5bb6", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), CompanionManagement.characterSelected().isElemental() ? "\u9a71\u6563[npc.namePos]\u7684\u7269\u7406\u5f62\u6001\uff0c\u8ba9[npc.herHim]\u8f6c\u53d8\u56de\u5965\u672f\u7075\u6c14\u3002" : "\u8ba9[npc.name]\u56de\u5bb6\u3002", new ParserTag[0])){

                        @Override
                        public void effects() {
                            if (CompanionManagement.characterSelected().isElementalSummoned()) {
                                CompanionManagement.characterSelected().removeCompanion(CompanionManagement.characterSelected().getElemental());
                                CompanionManagement.characterSelected().getElemental().returnToHome();
                            }
                            Main.game.getPlayer().removeCompanion(CompanionManagement.characterSelected());
                            CompanionManagement.characterSelected().returnToHome();
                            Main.game.restoreSavedContent(false);
                        }
                    };
                }
                return new Response(CompanionManagement.characterSelected().isElemental() ? "\u9a71\u6563" : "\u9001\u56de\u5bb6", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), CompanionManagement.characterSelected().isElemental() ? "\u9a71\u6563[npc.namePos]\u7684\u7269\u7406\u5f62\u6001\uff0c\u8ba9[npc.herHim]\u8f6c\u53d8\u56de\u5965\u672f\u7075\u6c14\u3002" : "\u8ba9[npc.name]\u56de\u5bb6\u3002", new ParserTag[0]), coreNode){

                    @Override
                    public void effects() {
                        if (CompanionManagement.characterSelected().isElementalSummoned()) {
                            CompanionManagement.characterSelected().removeCompanion(CompanionManagement.characterSelected().getElemental());
                            CompanionManagement.characterSelected().getElemental().returnToHome();
                        }
                        Main.game.getPlayer().removeCompanion(CompanionManagement.characterSelected());
                        CompanionManagement.characterSelected().returnToHome();
                        Main.game.setResponseTab(0);
                        CharactersPresentDialogue.resetContent(Main.game.getCharactersPresent().get(0));
                    }
                };
            }
            if (index == 11) {
                if (Main.game.isSavedDialogueNeutral()) {
                    return new Response("\u6218\u6597\u52a8\u4f5c", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u8c03\u6574[npc.Name]\u6218\u6597\u4e2d\u53ef\u4f7f\u7528\u7684\u52a8\u4f5c\u3002", new ParserTag[0]), CombatMovesSetup.COMBAT_MOVES_CORE){

                        @Override
                        public void effects() {
                            CombatMovesSetup.setTarget(CompanionManagement.characterSelected(), coreNode);
                        }
                    };
                }
                return new Response("\u6218\u6597\u52a8\u4f5c", "\u4f60\u73b0\u5728\u6b63\u5fd9\u7740\u505a\u522b\u7684\u4e8b\uff01" + CompanionManagement.getBusyWarning(), null);
            }
            if (index == 12) {
                if (Main.game.isSavedDialogueNeutral()) {
                    return new Response("\u6cd5\u672f", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u7ba1\u7406[npc.namePos]\u7684\u6cd5\u672f\u3002", new ParserTag[0]), SpellManagement.CHARACTER_SPELLS_EARTH){

                        @Override
                        public void effects() {
                            SpellManagement.setSpellOwner(CompanionManagement.characterSelected(), coreNode);
                        }
                    };
                }
                return new Response("\u6cd5\u672f", "\u4f60\u73b0\u5728\u6b63\u5fd9\u7740\u505a\u522b\u7684\u4e8b\uff01" + CompanionManagement.getBusyWarning(), null);
            }
            if (index == 13) {
                if (!CompanionManagement.characterSelected().isElementalSummoned()) {
                    return new Response("\u9a71\u6563\u5143\u7d20\u4f53", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.Name]\u8fd8\u6ca1\u6709\u53ec\u5524\u5143\u7d20\u4f53\u2026\u2026", new ParserTag[0]), null);
                }
                if (!Main.game.isSavedDialogueNeutral()) {
                    return new Response("\u9a71\u6563\u5143\u7d20\u4f53", "\u4f60\u73b0\u5728\u6b63\u5fd9\u7740\u505a\u522b\u7684\u4e8b\uff01" + CompanionManagement.getBusyWarning(), null);
                }
                return new Response("\u9a71\u6563\u5143\u7d20\u4f53", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u8ba9[npc.name]\u9a71\u6563[npc.her]\u7684\u5143\u7d20\u4f53\u3002", new ParserTag[0]), coreNode){

                    @Override
                    public void effects() {
                        CompanionManagement.characterSelected().getElemental().returnToHome();
                        CompanionManagement.characterSelected().setElementalSummoned(false);
                    }
                };
            }
        } else if (CompanionManagement.characterSelected() != null && CompanionManagement.characterSelected().isSlave()) {
            if (index == 1) {
                if (Main.game.getCurrentDialogueNode() == SLAVE_MANAGEMENT_INSPECT) {
                    return new Response("\u5ba1\u89c6", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u6b63\u5728\u4ed4\u7ec6\u6253\u91cf[npc.name]\uff01", new ParserTag[0]), null);
                }
                return new Response("\u5ba1\u89c6", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4ed4\u7ec6\u6253\u91cf[npc.name]\uff01", new ParserTag[0]), SLAVE_MANAGEMENT_INSPECT);
            }
            if (index == 2) {
                if (Main.game.getCurrentDialogueNode() == SLAVE_MANAGEMENT_JOBS) {
                    return new Response("\u5de5\u4f5c", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u6b63\u5728\u8bbe\u5b9a[npc.namePos]\u7684\u5de5\u4f5c\u548c\u5de5\u65f6\uff01", new ParserTag[0]), null);
                }
                if (!CompanionManagement.characterSelected().getOwner().isPlayer()) {
                    return new Response("\u5de5\u4f5c", "\u4f60\u4e0d\u80fd\u7ba1\u7406\u4e0d\u5c5e\u4e8e\u4f60\u7684\u5974\u96b6\u7684\u5de5\u4f5c\uff01", null);
                }
                return new Response("\u5de5\u4f5c", "\u8bbe\u5b9a\u8be5\u5974\u96b6\u7684\u5de5\u4f5c\u548c\u5de5\u65f6\u3002", SLAVE_MANAGEMENT_JOBS);
            }
            if (index == 3) {
                if (Main.game.getCurrentDialogueNode() == SLAVE_MANAGEMENT_PERMISSIONS) {
                    return new Response("\u6743\u9650", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u6b63\u5728\u8bbe\u5b9a[npc.namePos]\u7684\u6743\u9650\uff01", new ParserTag[0]), null);
                }
                if (!CompanionManagement.characterSelected().getOwner().isPlayer()) {
                    return new Response("\u6743\u9650", "\u4f60\u4e0d\u80fd\u7ba1\u7406\u4e0d\u5c5e\u4e8e\u4f60\u7684\u5974\u96b6\u7684\u6743\u9650\uff01", null);
                }
                return new Response("\u6743\u9650", "\u8bbe\u5b9a\u8be5\u5974\u96b6\u7684\u6743\u9650\u3002", SLAVE_MANAGEMENT_PERMISSIONS);
            }
            if (index == 4) {
                if (!CompanionManagement.characterSelected().getOwner().isPlayer()) {
                    return new Response("\u7269\u54c1\u680f", "\u4f60\u4e0d\u80fd\u7ba1\u7406\u4e0d\u5c5e\u4e8e\u4f60\u7684\u5974\u96b6\u7684\u7269\u54c1\u680f\uff01", null);
                }
                if (CompanionManagement.characterSelected().getOwner().isPlayer()) {
                    return new ResponseEffectsOnly("\u7269\u54c1\u680f", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u7ba1\u7406[npc.namePos]\u7684\u7269\u54c1\u680f\u3002", new ParserTag[0])){

                        @Override
                        public void effects() {
                            Main.mainController.openInventory(CompanionManagement.characterSelected(), InventoryInteraction.FULL_MANAGEMENT);
                        }
                    };
                }
                return new Response("\u7269\u54c1\u680f", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u4e0d\u80fd\u7ba1\u7406[npc.namePos]\u7684\u7269\u54c1\u680f\uff0c\u56e0\u4e3a\u4f60\u6ca1\u62e5\u6709[npc.herHim]\uff01", new ParserTag[0]), null);
            }
            if (index == 5) {
                if (!CompanionManagement.characterSelected().getOwner().isPlayer()) {
                    return new Response("\u9001\u5230\u51ef\u7279\u90a3\u91cc", "\u4f60\u4e0d\u80fd\u628a\u4e0d\u5c5e\u4e8e\u81ea\u5df1\u7684\u5974\u96b6\u9001\u5230\u51ef\u7279\u90a3\u91cc\uff01", null);
                }
                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.kateIntroduced)) {
                    return new Response("\u9001\u5230\u51ef\u7279\u90a3\u91cc", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u5c06[npc.name]\u9001\u53bb\u51ef\u7279\u7684\u7f8e\u5bb9\u6c99\u9f99\u201c\u9b45\u9b54\u7684\u79d8\u5bc6\u201d\u6539\u53d8\u5916\u8c8c\u3002", new ParserTag[0]), SLAVE_MANAGEMENT_COSMETICS_MAKEUP){

                        @Override
                        public void effects() {
                            BodyChanging.setTarget(CompanionManagement.characterSelected());
                        }
                    };
                }
                return new Response("\u9001\u5230\u51ef\u7279\u90a3\u91cc", "\u4f60\u8fd8\u6ca1\u89c1\u8fc7\u51ef\u7279\uff01", null);
            }
            if (index == 6) {
                if (!CompanionManagement.characterSelected().getOwner().isPlayer()) {
                    return new Response("\u5929\u8d4b", "\u4f60\u4e0d\u80fd\u7ba1\u7406\u4e0d\u5c5e\u4e8e\u81ea\u5df1\u7684\u5974\u96b6\u7684\u5929\u8d4b\uff01", null);
                }
                if (Main.game.getCurrentDialogueNode() == SLAVE_MANAGEMENT_PERKS) {
                    return new Response("[style.colourMinorBad(\u91cd\u7f6e\u5929\u8d4b)]", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u91cd\u7f6e[npc.namePos]\u6240\u6709\u7684\u5929\u8d4b\u548c\u7279\u6027\uff0c\u8fd4\u8fd8\u6240\u6709\u6d88\u8017\u7684\u5929\u8d4b\u70b9\u3002(\u4e34\u65f6\u53ef\u7528\uff0c\u7531\u4e8e\u5929\u8d4b\u6811\u4ecd\u5728\u5f00\u53d1\u4e2d\u3002)", new ParserTag[0]), Main.game.getCurrentDialogueNode()){

                        @Override
                        public void effects() {
                            CompanionManagement.characterSelected().resetPerksMap(false, false);
                        }
                    };
                }
                return new Response("\u5929\u8d4b", "\u4f7f\u7528\u4f60\u7684\u5974\u96b6\u7684\u5929\u8d4b\u70b9\u3002", SLAVE_MANAGEMENT_PERKS);
            }
            if (index == 7) {
                if (CompanionManagement.characterSelected().isDoll() && (Main.game.getPlayer().hasItemType(ItemType.DOLL_CONSOLE) || CompanionManagement.characterSelected().hasItemType(ItemType.DOLL_CONSOLE))) {
                    return new ResponseEffectsOnly("\u8f6c\u5316", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f7f\u7528\u4f60\u7684D.E.C.K.\u6765\u5b9a\u5236[npc.namePos]\u7684\u5916\u8c8c\u3002", new ParserTag[0])){

                        @Override
                        public void effects() {
                            ItemEffectType.DOLL_CONSOLE.itemEffectOverride(TFModifier.NONE, TFModifier.NONE, TFPotency.BOOST, 0, Main.game.getPlayer(), CompanionManagement.characterSelected(), new ItemEffectTimer());
                        }
                    };
                }
                if (!CompanionManagement.characterSelected().isAbleToSelfTransform()) {
                    return new Response("\u8f6c\u5316", CompanionManagement.characterSelected().getUnableToTransformDescription(), null);
                }
                return new Response("\u8f6c\u5316", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4ed4\u7ec6\u89c2\u5bdf[npc.name]\u4f1a\u5c06\u81ea\u5df1\u8f6c\u5316\u6210\u4ec0\u4e48\u6837\u2026\u2026", new ParserTag[0]), BodyChanging.BODY_CHANGING_CORE){

                    @Override
                    public void effects() {
                        BodyChanging.setTarget(CompanionManagement.characterSelected(), coreNode, defaultResponseTab);
                    }
                };
            }
            if (index == 8) {
                if (Main.game.getCurrentDialogueNode() == OCCUPANT_CHOOSE_NAME) {
                    return new Response("\u8bbe\u5b9a\u540d\u5b57", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u6b63\u5728\u7ba1\u7406[npc.namePos]\u7684\u540d\u5b57\uff01", new ParserTag[0]), null);
                }
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u8bbe\u5b9a\u540d\u5b57", "\u4f60\u8fd8\u6ca1\u6709\u9009\u62e9\u89d2\u8272\u2026\u2026", null);
                }
                return new Response("\u8bbe\u5b9a\u540d\u5b57", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u66f4\u6539[npc.namePos]\u7684\u540d\u5b57\u6216\u8ba9[npc.herHim]\u4ee5\u4e0d\u540c\u7684\u540d\u5b57\u79f0\u547c\u4f60\u3002", new ParserTag[0]), OCCUPANT_CHOOSE_NAME);
            }
            if (index == 10 && Main.getProperties().hasValue(PropertyValue.companionContent)) {
                return new Response("\u9001\u56de\u5bb6", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.Name]\u4e0d\u5728\u4f60\u7684\u961f\u4f0d\u91cc\uff0c\u6240\u4ee5\u4f60\u4e0d\u80fd\u628a[npc.herHim]\u9001\u56de\u5bb6\u2026\u2026", new ParserTag[0]), null);
            }
            if (index == 11) {
                if (!CompanionManagement.characterSelected().getOwner().isPlayer()) {
                    return new Response("\u6218\u6597\u52a8\u4f5c", "\u4f60\u4e0d\u80fd\u7ba1\u7406\u4e0d\u5c5e\u4e8e\u81ea\u5df1\u7684\u5974\u96b6\u7684\u6218\u6597\u52a8\u4f5c\uff01", null);
                }
                return new Response("\u6218\u6597\u52a8\u4f5c", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u8c03\u6574[npc.Name]\u6218\u6597\u4e2d\u53ef\u4f7f\u7528\u7684\u52a8\u4f5c\u3002", new ParserTag[0]), CombatMovesSetup.COMBAT_MOVES_CORE){

                    @Override
                    public void effects() {
                        CombatMovesSetup.setTarget(CompanionManagement.characterSelected(), coreNode);
                    }
                };
            }
            if (index == 12) {
                return new Response("\u6cd5\u672f", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u7ba1\u7406[npc.namePos]\u7684\u6cd5\u672f\u3002", new ParserTag[0]), SpellManagement.CHARACTER_SPELLS_EARTH){

                    @Override
                    public void effects() {
                        SpellManagement.setSpellOwner(CompanionManagement.characterSelected(), coreNode);
                    }
                };
            }
            if (index == 13) {
                if (!CompanionManagement.characterSelected().isElementalSummoned()) {
                    return new Response("\u9a71\u6563\u5143\u7d20\u4f53", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.Name]\u8fd8\u6ca1\u6709\u53ec\u5524\u5143\u7d20\u4f53\u2026\u2026", new ParserTag[0]), null);
                }
                return new Response("\u9a71\u6563\u5143\u7d20\u4f53", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u8ba9[npc.name]\u9a71\u6563[npc.her]\u7684\u5143\u7d20\u4f53\u3002", new ParserTag[0]), coreNode){

                    @Override
                    public void effects() {
                        CompanionManagement.characterSelected().removeCompanion(CompanionManagement.characterSelected().getElemental());
                        CompanionManagement.characterSelected().getElemental().returnToHome();
                    }
                };
            }
            if (index == 14) {
                if (CompanionManagement.characterSelected().isDoll()) {
                    return new Response("\u91ca\u653e", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u73a9\u5076\u65e0\u6cd5\u91ca\u653e\u2026\u2026", new ParserTag[0]), null);
                }
                if (!Main.game.getPlayer().hasItemType("innoxia_slavery_freedom_certification")) {
                    return new Response("\u91ca\u653e", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u6ca1\u6709\u81ea\u7531\u8bc1\u660e\uff0c\u6240\u4ee5\u4e0d\u80fd\u91ca\u653e[npc.name]\u2026\u2026<br/><i>\u81ea\u7531\u8bc1\u660e\u53ef\u4ee5\u5411\u5974\u96b6\u5df7\u7684\u5974\u96b6\u7ba1\u7406\u5c40\u91cc\u7684\u82ac\u5947\u8d2d\u4e70\u3002</i>", new ParserTag[0]), null);
                }
                if (CompanionManagement.characterSelected() instanceof Scarlett) {
                    return new Response("\u91ca\u653e", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u586b\u5199\u4e00\u4efd\u81ea\u7531\u8bc1\u660e\u6765\u91ca\u653e[npc.name]\uff01<br/>\u5982\u679c\u4f60\u8fd9\u4e48\u505a\uff0c[npc.she]\u65e0\u7591\u4f1a\u7acb\u523b\u79bb\u5f00\u5e76\u8fd4\u56de\u6d77\u4f26\u5a1c\u7684\u5de2\u2026\u2026", new ParserTag[0]), SET_SLAVE_FREE_SCARLETT);
                }
                if (CompanionManagement.characterSelected() instanceof Brax) {
                    return new Response("\u91ca\u653e", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u65e0\u6cd5\u8ba9[npc.name]\u9003\u8131\u2026\u2026<br/><i>(\u8fd9\u5c06\u5728\u4e3a\u5e03\u62c9\u514b\u65af\u6dfb\u52a0\u66f4\u591a\u5185\u5bb9\u65f6\u52a0\u5165\uff01)</i>", new ParserTag[0]), null);
                }
                String unavailableGuestDescription = "";
                if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ACCOMMODATION)) {
                    unavailableGuestDescription = "[style.italicsMinorBad(\u7531\u4e8e\u8389\u83b1\u96c5\u4e0d\u5141\u8bb8\u4f60\u63a5\u5f85\u5ba2\u4eba\uff0c\u91ca\u653e[npc.herHim]\u4e4b\u540e\u5c06\u65e0\u6cd5\u518d\u9080\u8bf7[npc.name]\u4f4f\u5728\u8c6a\u5b85\u4e2d\uff01)]";
                } else if (!CompanionManagement.characterSelected().isAffectionHighEnoughToInviteHome()) {
                    unavailableGuestDescription = "[style.italicsBad([npc.Name]\u8fd8\u4e0d\u591f\u559c\u6b22\u4f60\uff0c\u4e0d\u4f1a\u5728\u88ab\u91ca\u653e\u540e\u8003\u8651\u7559\u5728\u4f60\u8eab\u8fb9\uff01)]";
                } else if (!OccupancyUtil.isFreeRoomAvailableForOccupant()) {
                    unavailableGuestDescription = "[style.italicsMinorBad(\u7531\u4e8e\u4f60\u6ca1\u6709\u7a7a\u95f2\u7684\u5ba2\u623f\u4f9b[npc.name]\u5165\u4f4f\uff0c\u4f60\u65e0\u6cd5\u5728\u91ca\u653e[npc.herHim]\u540e\u9080\u8bf7[npc.herHim]\u7559\u5728\u8c6a\u5b85\u4e2d\uff01)]";
                }
                final String thanksjava = unavailableGuestDescription;
                return new Response("\u91ca\u653e", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u586b\u5199\u4e00\u4efd\u81ea\u7531\u8bc1\u660e\u6765\u91ca\u653e[npc.name]\uff01<br/>" + (String)(thanksjava.isEmpty() ? "[style.italicsMinorGood([npc.Name]\u73b0\u5728\u5df2\u7ecf\u8db3\u591f\u559c\u6b22\u4f60\uff0c\u613f\u610f\u7559\u4e0b\u6765\u548c\u4f60\u4f4f\u4e00\u8d77\uff0c\u6240\u4ee5\u5728\u91ca\u653e[npc.herHim]\u4e4b\u540e\uff0c\u4f60\u53ef\u4ee5\u8ba9[npc.herHim]\u4f4f\u5728\u7a7a\u95f2\u7684\u5ba2\u623f\u91cc\uff01)]" : thanksjava + "<br/>[style.italicsBad([npc.herHim](\u4ee5\u53ca[npc.her]\u7269\u54c1\u680f\u91cc\u6240\u6709\u7269\u54c1)\u5c06\u4f1a\u4ece\u6e38\u620f\u4e2d\u6c38\u4e45\u5220\u9664\uff01)]"), new ParserTag[0]), SET_SLAVE_FREE){

                    @Override
                    public Colour getHighlightColour() {
                        if (thanksjava.isEmpty()) {
                            return PresetColour.GENERIC_MINOR_GOOD;
                        }
                        return PresetColour.GENERIC_NPC_REMOVAL;
                    }
                };
            }
            if (index == 0) {
                if (coreNode == OccupantManagementDialogue.SLAVE_LIST) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u53cb\u4eba\u4f4f\u5ba2\u5217\u8868\u754c\u9762\u3002", coreNode){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setManagementCompanion(null);
                            coreNode = null;
                        }
                    };
                }
                return new Response("\u8fd4\u56de", CompanionManagement.characterSelected() == null ? "\u8fd4\u56de\u5230\u4e0a\u4e00\u6bb5\u5bf9\u8bdd\u3002" : UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), CompanionManagement.characterSelected().isDollStatue() ? "\u8ba9[npc.name]\u9759\u6b62\u5728\u539f\u5730\uff0c\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u3002" : (CompanionManagement.characterSelected().isAsleep() ? "\u8ba9[npc.name]\u7ee7\u7eed\u7761\u89c9\u2026\u2026" : "\u544a\u8bc9[npc.name]\u4f60\u4f1a\u5728\u5176\u4ed6\u65f6\u95f4\u518d\u53bb\u627e[npc.herHim]\u3002"), new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                    @Override
                    public void effects() {
                        Main.game.setResponseTab(0);
                        Main.game.getDialogueFlags().setManagementCompanion(null);
                        coreNode = null;
                    }
                };
            }
        } else {
            if (index == 1) {
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u5ba1\u89c6", "\u4f60\u8fd8\u6ca1\u9009\u62e9\u4efb\u4f55\u4eba\u2026\u2026", null);
                }
                if (Main.game.getCurrentDialogueNode() == SLAVE_MANAGEMENT_INSPECT) {
                    return new Response("\u5ba1\u89c6", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u6b63\u5728\u4ed4\u7ec6\u6253\u91cf[npc.name]\uff01", new ParserTag[0]), null);
                }
                return new Response("\u5ba1\u89c6", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4ed4\u7ec6\u6253\u91cf[npc.name]\u3002", new ParserTag[0]), SLAVE_MANAGEMENT_INSPECT);
            }
            if (index == 2) {
                if (Main.game.getCurrentDialogueNode() == SLAVE_MANAGEMENT_JOBS) {
                    return new Response("\u5de5\u4f5c", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u6b63\u5728\u8bbe\u5b9a[npc.namePos]\u7684\u5de5\u4f5c\u548c\u5de5\u65f6\uff01", new ParserTag[0]), null);
                }
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u5de5\u4f5c", "\u4f60\u8fd8\u6ca1\u9009\u62e9\u4efb\u4f55\u4eba\u2026\u2026", null);
                }
                if (!CompanionManagement.characterSelected().hasJob()) {
                    return new Response("\u5de5\u4f5c", "\u8bbe\u5b9a\u53cb\u4eba\u4f4f\u5ba2\u7684\u4e34\u65f6\u5de5\u4f5c\u548c\u5de5\u65f6\u3002", SLAVE_MANAGEMENT_JOBS);
                }
                return new Response("\u5de5\u4f5c", "\u8be5\u53cb\u4eba\u4f4f\u5ba2\u5df2\u6709\u6c38\u4e45\u5de5\u4f5c\u3002", null);
            }
            if (index == 3) {
                if (Main.game.getCurrentDialogueNode() == SLAVE_MANAGEMENT_PERMISSIONS) {
                    return new Response("\u6743\u9650", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u6b63\u5728\u8bbe\u5b9a[npc.namePos]\u7684\u6743\u9650\uff01", new ParserTag[0]), null);
                }
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u8bb8\u53ef", "\u4f60\u8fd8\u6ca1\u9009\u62e9\u4efb\u4f55\u4eba\u2026\u2026", null);
                }
                return new Response("\u6743\u9650", "\u4f60\u65e0\u6cd5\u7ba1\u7406\u81ea\u7531\u540c\u4f34\u7684\u6743\u9650\u3002\u8be5\u9009\u9879\u4ec5\u9002\u7528\u4e8e\u5974\u96b6\u3002", null);
            }
            if (index == 4) {
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u7269\u54c1\u680f", "\u4f60\u8fd8\u6ca1\u9009\u62e9\u4efb\u4f55\u4eba\u2026\u2026", null);
                }
                return new ResponseEffectsOnly("\u7269\u54c1\u680f", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u7ba1\u7406[npc.namePos]\u7684\u7269\u54c1\u680f\u3002", new ParserTag[0])){

                    @Override
                    public void effects() {
                        Main.mainController.openInventory(CompanionManagement.characterSelected(), InventoryInteraction.FULL_MANAGEMENT);
                    }
                };
            }
            if (index == 5) {
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u9001\u5230\u51ef\u7279\u90a3\u91cc", "\u4f60\u8fd8\u6ca1\u9009\u62e9\u4efb\u4f55\u4eba\u2026\u2026", null);
                }
                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.kateIntroduced)) {
                    return new Response("\u9001\u5230\u51ef\u7279\u90a3\u91cc", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u5c06[npc.name]\u9001\u53bb\u51ef\u7279\u7684\u7f8e\u5bb9\u6c99\u9f99\u201c\u9b45\u9b54\u7684\u79d8\u5bc6\u201d\u6539\u53d8\u5916\u8c8c\u3002", new ParserTag[0]), SLAVE_MANAGEMENT_COSMETICS_MAKEUP){

                        @Override
                        public void effects() {
                            BodyChanging.setTarget(CompanionManagement.characterSelected());
                        }
                    };
                }
                return new Response("\u9001\u5230\u51ef\u7279\u90a3\u91cc", "\u4f60\u8fd8\u6ca1\u89c1\u8fc7\u51ef\u7279\uff01", null);
            }
            if (index == 6) {
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u5929\u8d4b", "\u4f60\u8fd8\u6ca1\u9009\u62e9\u4efb\u4f55\u4eba\u2026\u2026", null);
                }
                if (Main.game.getCurrentDialogueNode() == SLAVE_MANAGEMENT_PERKS) {
                    return new Response("[style.colourMinorBad(\u91cd\u7f6e\u5929\u8d4b)]", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u91cd\u7f6e[npc.namePos]\u6240\u6709\u7684\u5929\u8d4b\u548c\u7279\u6027\uff0c\u8fd4\u8fd8\u6240\u6709\u6d88\u8017\u7684\u5929\u8d4b\u70b9\u3002(\u4e34\u65f6\u53ef\u7528\uff0c\u7531\u4e8e\u5929\u8d4b\u6811\u4ecd\u5728\u5f00\u53d1\u4e2d\u3002)", new ParserTag[0]), Main.game.getCurrentDialogueNode()){

                        @Override
                        public void effects() {
                            CompanionManagement.characterSelected().resetPerksMap(false, false);
                        }
                    };
                }
                return new Response("\u5929\u8d4b", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u5206\u914d[npc.namePos]\u7684\u5929\u8d4b\u70b9\u3002", new ParserTag[0]), SLAVE_MANAGEMENT_PERKS);
            }
            if (index == 7) {
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u8f6c\u5316", "\u4f60\u8fd8\u6ca1\u9009\u62e9\u4efb\u4f55\u4eba\u2026\u2026", null);
                }
                if (CompanionManagement.characterSelected().isDoll() && (Main.game.getPlayer().hasItemType(ItemType.DOLL_CONSOLE) || CompanionManagement.characterSelected().hasItemType(ItemType.DOLL_CONSOLE))) {
                    return new ResponseEffectsOnly("\u8f6c\u5316", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f7f\u7528\u4f60\u7684D.E.C.K.\u6765\u5b9a\u5236[npc.namePos]\u7684\u5916\u8c8c\u3002", new ParserTag[0])){

                        @Override
                        public void effects() {
                            ItemEffectType.DOLL_CONSOLE.itemEffectOverride(TFModifier.NONE, TFModifier.NONE, TFPotency.BOOST, 0, Main.game.getPlayer(), CompanionManagement.characterSelected(), new ItemEffectTimer());
                        }
                    };
                }
                if (!CompanionManagement.characterSelected().isAbleToSelfTransform()) {
                    return new Response("\u8f6c\u5316", CompanionManagement.characterSelected().getUnableToTransformDescription(), null);
                }
                return new Response("\u8f6c\u5316", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4ed4\u7ec6\u89c2\u5bdf[npc.name]\u4f1a\u5c06\u81ea\u5df1\u8f6c\u5316\u6210\u4ec0\u4e48\u6837\u2026\u2026", new ParserTag[0]), BodyChanging.BODY_CHANGING_CORE){

                    @Override
                    public void effects() {
                        BodyChanging.setTarget(CompanionManagement.characterSelected(), coreNode, defaultResponseTab);
                    }
                };
            }
            if (index == 8) {
                if (Main.game.getCurrentDialogueNode() == OCCUPANT_CHOOSE_NAME) {
                    return new Response("\u8bbe\u5b9a\u540d\u5b57", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u6b63\u5728\u7ba1\u7406[npc.namePos]\u7684\u540d\u5b57\uff01", new ParserTag[0]), null);
                }
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u8bbe\u5b9a\u540d\u5b57", "\u4f60\u8fd8\u6ca1\u9009\u62e9\u4efb\u4f55\u4eba\u2026\u2026", null);
                }
                return new Response("\u8bbe\u5b9a\u540d\u5b57", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u8ba9[npc.Name]\u4ee5\u4e0d\u540c\u7684\u540d\u5b57\u79f0\u547c\u4f60\u3002", new ParserTag[0]), OCCUPANT_CHOOSE_NAME);
            }
            if (index == 10 && Main.getProperties().hasValue(PropertyValue.companionContent)) {
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u9001\u56de\u5bb6", "\u4f60\u8fd8\u6ca1\u9009\u62e9\u4efb\u4f55\u4eba\u2026\u2026", null);
                }
                return new Response("\u9001\u56de\u5bb6", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.Name]\u4e0d\u5728\u4f60\u7684\u961f\u4f0d\u91cc\uff0c\u6240\u4ee5\u4f60\u4e0d\u80fd\u628a[npc.herHim]\u9001\u56de\u5bb6\u2026\u2026", new ParserTag[0]), null);
            }
            if (index == 11) {
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u6218\u6597\u52a8\u4f5c", "\u4f60\u8fd8\u6ca1\u9009\u62e9\u4efb\u4f55\u4eba\u2026\u2026", null);
                }
                return new Response("\u6218\u6597\u52a8\u4f5c", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u8c03\u6574[npc.Name]\u6218\u6597\u4e2d\u53ef\u4f7f\u7528\u7684\u52a8\u4f5c\u3002", new ParserTag[0]), CombatMovesSetup.COMBAT_MOVES_CORE){

                    @Override
                    public void effects() {
                        CombatMovesSetup.setTarget(CompanionManagement.characterSelected(), coreNode);
                    }
                };
            }
            if (index == 12) {
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u6cd5\u672f", "\u4f60\u8fd8\u6ca1\u9009\u62e9\u4efb\u4f55\u4eba\u2026\u2026", null);
                }
                return new Response("\u6cd5\u672f", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u7ba1\u7406[npc.namePos]\u7684\u6cd5\u672f\u3002", new ParserTag[0]), SpellManagement.CHARACTER_SPELLS_EARTH){

                    @Override
                    public void effects() {
                        SpellManagement.setSpellOwner(CompanionManagement.characterSelected(), coreNode);
                    }
                };
            }
            if (index == 13) {
                if (CompanionManagement.characterSelected() == null) {
                    return new Response("\u9a71\u6563\u5143\u7d20\u4f53", "\u4f60\u8fd8\u6ca1\u9009\u62e9\u4efb\u4f55\u4eba\u2026\u2026", null);
                }
                if (!CompanionManagement.characterSelected().isElementalSummoned()) {
                    return new Response("\u9a71\u6563\u5143\u7d20\u4f53", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.Name]\u8fd8\u6ca1\u6709\u53ec\u5524\u5143\u7d20\u4f53\u2026\u2026", new ParserTag[0]), null);
                }
                return new Response("\u9a71\u6563\u5143\u7d20\u4f53", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u8ba9[npc.name]\u9a71\u6563[npc.her]\u7684\u5143\u7d20\u4f53\u3002", new ParserTag[0]), coreNode){

                    @Override
                    public void effects() {
                        CompanionManagement.characterSelected().removeCompanion(CompanionManagement.characterSelected().getElemental());
                        CompanionManagement.characterSelected().getElemental().returnToHome();
                    }
                };
            }
            if (index == 0) {
                if (coreNode == OccupantManagementDialogue.SLAVE_LIST) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u53cb\u4eba\u4f4f\u5ba2\u5217\u8868\u754c\u9762\u3002", coreNode){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setManagementCompanion(null);
                            coreNode = null;
                        }
                    };
                }
                return new Response("\u79bb\u5f00", CompanionManagement.characterSelected() == null ? "\u8fd4\u56de\u5230\u4e0a\u4e00\u6bb5\u5bf9\u8bdd\u3002" : UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), CompanionManagement.characterSelected().isDollStatue() ? "\u8ba9[npc.name]\u9759\u6b62\u5728\u539f\u5730\uff0c\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u3002" : (CompanionManagement.characterSelected().isAsleep() ? "\u8ba9[npc.name]\u7ee7\u7eed\u7761\u89c9\u2026\u2026" : "\u544a\u8bc9[npc.name]\u4f60\u4f1a\u5728\u5176\u4ed6\u65f6\u95f4\u518d\u53bb\u627e[npc.herHim]\u3002"), new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                    @Override
                    public void effects() {
                        Main.game.setResponseTab(0);
                        Main.game.getDialogueFlags().setManagementCompanion(null);
                        coreNode = null;
                    }
                };
            }
        }
        return null;
    }

    private static Response getCosmeticsResponse(int responseTab, int index) {
        if (index == 1) {
            if (!BodyChanging.getTarget().isAbleToWearMakeup()) {
                return new Response("\u5986\u5bb9", UtilText.parse(BodyChanging.getTarget(), "\u7531\u4e8e[npc.namePos]\u8eab\u4f53\u7531" + Main.game.getPlayer().getBodyMaterial().getName() + "\u6784\u6210\uff0c\u51ef\u7279\u65e0\u6cd5\u8fdb\u884c\u5316\u5986\uff01", new ParserTag[0]), null);
            }
            return new Response("\u5316\u5986", "\u51ef\u7279\u63d0\u4f9b\u5e7f\u6cdb\u7684\u5316\u5986\u670d\u52a1\uff0c\u5c0f\u518c\u5b50\u4e0a\u6709\u597d\u51e0\u9875\u90fd\u662f\u5404\u79cd\u56fe\u7247\uff0c\u5c55\u793a\u7740\u5404\u8272\u5404\u6837\u7684\u53e3\u7ea2\u3001\u6307\u7532\u6cb9\u548c\u5176\u4ed6\u5316\u5986\u54c1\u7684\u6548\u679c\u3002", SLAVE_MANAGEMENT_COSMETICS_MAKEUP);
        }
        if (index == 2) {
            return new Response("\u5934\u53d1", "\u4e0a\u9762\u6709\u4e00\u5f20\u8de8\u9875\u7684\u5185\u5bb9\uff0c\u5c55\u793a\u4e86\u51ef\u7279\u80fd\u7ed9\u5934\u53d1\u67d3\u5404\u79cd\u989c\u8272\uff0c\u6362\u4e0d\u540c\u9020\u578b\u548c\u957f\u5ea6\u3002", SLAVE_MANAGEMENT_COSMETICS_HAIR);
        }
        if (index == 3) {
            return new Response("\u7a7f\u5b54", "\u51ef\u7279\u63d0\u4f9b\u591a\u79cd\u591a\u6837\u3001\u8303\u56f4\u5e7f\u6cdb\u7684\u7a7f\u5b54\u3002", SLAVE_MANAGEMENT_COSMETICS_PIERCINGS);
        }
        if (index == 4) {
            if (BodyChanging.getTarget().isDoll()) {
                return new Response("\u773c\u775b", "\u51ef\u7279\u65e0\u6cd5\u7ed9\u5965\u672f\u7845\u80f6\u91cd\u65b0\u67d3\u8272\uff0c\u6240\u4ee5\u8be5\u9009\u9879\u4e0d\u53ef\u7528\u2026\u2026", null);
            }
            return new Response("\u773c\u775b", "\u5c0f\u518c\u5b50\u521a\u5f00\u59cb\u4e13\u95e8\u6709\u4e00\u9875\uff0c\u63a8\u9500\u7740\u51ef\u7279\u773c\u775b\u6613\u8272\u7684\u529f\u592b\u3002\u4e0e\u76ae\u80a4\u6613\u8272\u7c7b\u4f3c\uff0c\u8fd9\u5bf9\u5979\u7684\u7075\u6c14\u8981\u6c42\u5f88\u9ad8\uff0c\u6240\u4ee5\u4e5f\u5f88\u6602\u8d35\u3002", SLAVE_MANAGEMENT_COSMETICS_EYES);
        }
        if (index == 5) {
            if (BodyChanging.getTarget().isDoll()) {
                return new Response("\u4f53\u8868", "\u51ef\u7279\u65e0\u6cd5\u7ed9\u5965\u672f\u7845\u80f6\u91cd\u65b0\u67d3\u8272\uff0c\u6240\u4ee5\u8be5\u9009\u9879\u4e0d\u53ef\u7528\u2026\u2026", null);
            }
            return new Response("\u4f53\u8868", "\u5c0f\u518c\u5b50\u4e2d\u95f4\u4e13\u95e8\u6709\u4e00\u9875\uff0c\u63a8\u9500\u7740\u51ef\u7279\u9a7e\u9a6d\u5965\u672f\u7ed9\u76ae\u80a4\u6216\u76ae\u6bdb\u6613\u8272\u7684\u80fd\u529b\u3002\u663e\u7136\u8fd9\u5bf9\u5979\u7684\u7075\u6c14\u6709\u5f88\u9ad8\u8981\u6c42\uff0c\u6240\u4ee5\u4e5f\u5f88\u884c\u6602\u8d35\u3002", SLAVE_MANAGEMENT_COSMETICS_COVERINGS){

                @Override
                public void effects() {
                    SuccubisSecrets.initCoveringsMap(BodyChanging.getTarget());
                }
            };
        }
        if (index == 6) {
            return new Response("\u5176\u4ed6", "\u51ef\u7279\u8fd8\u63d0\u4f9b\u5404\u79cd\u6742\u9879\u670d\u52a1\uff0c\u4f8b\u5982\u809b\u95e8\u6f02\u767d\u3002", SLAVE_MANAGEMENT_COSMETICS_OTHER);
        }
        if (index == 7) {
            return new Response("\u7eb9\u8eab", "\u5c0f\u518c\u5b50\u7684\u7edd\u5927\u90e8\u5206\u90fd\u88ab\u5404\u79cd\u56fe\u753b\u548c\u7167\u7247\u5360\u636e\uff0c\u4f53\u73b0\u51fa\u51ef\u7279\u975e\u51e1\u7684\u827a\u672f\u6f5c\u8d28\u3002\u5979\u751a\u81f3\u80fd\u7eb9\u4e0a\u5965\u672f\u9644\u9b54\u7684\u7eb9\u8eab\uff0c\u4e0d\u8fc7\u770b\u4e0a\u53bb\u4e0d\u7b97\u4fbf\u5b9c\u2026\u2026", SLAVE_MANAGEMENT_TATTOOS);
        }
        if (index == 0) {
            if (coreNode == OccupantManagementDialogue.SLAVE_LIST) {
                return new Response("\u8fd4\u56de", "\u56de\u5230\u53cb\u4eba\u4f4f\u5ba2\u5217\u8868\u754c\u9762\u3002", coreNode){

                    @Override
                    public void effects() {
                        Main.game.setResponseTab(defaultResponseTab);
                        Main.game.getDialogueFlags().setManagementCompanion(null);
                        coreNode = null;
                    }
                };
            }
            return new Response("\u8fd4\u56de", "\u56de\u5230\u5974\u96b6\u7ba1\u7406\u754c\u9762\u3002", coreNode){

                @Override
                public void effects() {
                    Main.game.setResponseTab(defaultResponseTab);
                }
            };
        }
        return null;
    }

    private static boolean isFreedSlaveAvailableAsGuest() {
        return CompanionManagement.characterSelected().isAffectionHighEnoughToInviteHome() && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ACCOMMODATION) && OccupancyUtil.isFreeRoomAvailableForOccupant();
    }

    static {
        savedJobSchedule = null;
        savedJobSettings = null;
        savedPermissions = null;
        SLAVE_MANAGEMENT_INSPECT = new DialogueNode("\u7ba1\u7406\u5974\u96b6", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u5ba1\u89c6[npc.Name]", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                NPC character = CompanionManagement.characterSelected();
                UtilText.nodeContentSB.setLength(0);
                if (character.isSlave() && character.getOwner().isPlayer()) {
                    UtilText.nodeContentSB.append(CompanionManagement.getSlaveInformationHeader(character));
                }
                UtilText.nodeContentSB.append("<div class='container-full-width'><h6 style='color:" + PresetColour.GENERIC_EXCELLENT.toWebHexString() + "; text-align:center;'>\u68c0\u67e5</h6><div class='container-full-width inner'>" + character.getCharacterInformationScreen(false) + "</div></div><p id='hiddenFieldName' style='display:none;'></p>");
                return UtilText.parse((GameCharacter)character, UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return coreNode.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return coreNode.getResponse(responseTab, index);
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        SLAVE_MANAGEMENT_JOBS = new DialogueNode("\u7ba1\u7406\u5974\u96b6", "\u3002", true){

            @Override
            public void applyPreParsingEffects() {
                if (Main.game.getDialogueFlags().getSlaveryManagerJobSelected().isHidden(CompanionManagement.characterSelected())) {
                    Main.game.getDialogueFlags().setSlaveryManagerJobSelected(SlaveJob.IDLE);
                }
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.NamePos]\u7684\u5de5\u4f5c", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                NPC character = CompanionManagement.characterSelected();
                ObedienceLevel obedience = ObedienceLevel.getObedienceLevelFromValue(character.getObedienceValue());
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(CompanionManagement.getSlaveInformationHeader(character));
                UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'>");
                UtilText.nodeContentSB.append("<div class='container-full-width inner' style='text-align:center;padding-left:2px;padding-right:2px;'>");
                UtilText.nodeContentSB.append("<div class='title-button " + (!CompanionManagement.isJobSchedulePasteAvailable() ? "no-select" : "") + "' id='pasteSlaveJobSchedule' style='position:absolute; left:auto; right:8px; top:8px; padding:2px; margin:0; width:24px; height:24px; border:1px solid #999; " + (!CompanionManagement.isJobSchedulePasteAvailable() ? "opacity:0.5;" : "") + "'>" + SVGImages.SVG_IMAGE_PROVIDER.getPasteIcon() + "</div>");
                UtilText.nodeContentSB.append("<div class='title-button' id='copySlaveJobSchedule' style='position:absolute; left:auto; right:48px; top:8px; padding:2px; margin:0; width:24px; height:24px; border:1px solid #999;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCopyIcon() + "</div>");
                UtilText.nodeContentSB.append("<h6 style='color:" + PresetColour.GENERIC_EXPERIENCE.toWebHexString() + "; text-align:center;'>\u5de5\u4f5c\u5b89\u6392</h6>");
                UtilText.nodeContentSB.append("<div style='width:100%;margin-top:8px;'><b>\u53ef\u884c\u5de5\u4f5c</b></div>");
                for (SlaveJob job : SlaveJob.values()) {
                    if (job.isHidden(character) || !character.isSlave() && !job.hasFlag(SlaveJobFlag.GUEST_CAN_WORK)) continue;
                    UtilText.nodeContentSB.append("<div class='normal-button' id='" + String.valueOf((Object)job) + "_ASSIGN' style='width:calc(16.6% - 2px); margin:1px;color:" + job.getColour().toWebHexString() + ";" + (String)(Main.game.getDialogueFlags().getSlaveryManagerJobSelected() == job ? "border-color:" + job.getColour().toWebHexString() + ";" : "") + "'>" + Util.capitaliseSentence(job.getName(character)) + "</div>");
                }
                UtilText.nodeContentSB.append("<div style='width:100%;margin-top:8px;'><b>\u65f6\u95f4\u6bb5</b></div>");
                float stamina = character.getDailySlaveJobStamina();
                SlaveJob jobSelected = Main.game.getDialogueFlags().getSlaveryManagerJobSelected();
                for (int i = 0; i < 24; ++i) {
                    Colour colour;
                    Colour borderColour = colour = character.getSlaveJob(i).getColour();
                    Colour colour2 = colour;
                    String background = "background:" + colour2.getShades()[0] + ";";
                    if ((!jobSelected.isAvailable(i, character) || !character.isSlave() && stamina - jobSelected.getHourlyStaminaDrain(character) + character.getSlaveJob(i).getHourlyStaminaDrain(character) < 0.0f || !character.isSlave() && character.isSleepingAtHour(i)) && !jobSelected.equals((Object)SlaveJob.IDLE)) {
                        UtilText.nodeContentSB.append("<div class='normal-button hour disabled' style='" + background + "border-color:" + borderColour.toWebHexString() + ";color:" + colour.getShades()[4] + ";' id='" + i + "_WORK_DISABLED'>");
                    } else {
                        UtilText.nodeContentSB.append("<div class='normal-button hour' style='" + background + "border-color:" + borderColour.toWebHexString() + ";color:" + colour.getShades()[4] + ";' id='" + i + "_WORK'>");
                    }
                    UtilText.nodeContentSB.append(String.format("%02d", i) + ":00");
                    if (character.isSleepingAtHour(i)) {
                        String stroke = "text-shadow:1px 1px 0 #000,-1px -1px 0 #000, 1px -1px 0 #000,-1px 1px 0 #000,1px 1px 0 #000;";
                        UtilText.nodeContentSB.append("<b class='hotkey-icon' style='color:" + PresetColour.SLEEP.toWebHexString() + ";" + stroke + "'><span style='font-size:0.8em;'>z</span>zZ</b>");
                    }
                    UtilText.nodeContentSB.append("</div>");
                }
                UtilText.nodeContentSB.append("<div style='width:100%;margin-top:8px;'><i>[style.colourStamina(\u5f53\u524d\u6bcf\u65e5\u4f53\u529b\uff1a)] " + (stamina >= 0.0f ? "[style.colourGood(" : "[style.colourBad(") + stamina + ")]/" + character.getBaseStaminaForSlaveJobs() + "</i></div>");
                for (SlaveJobHours slaveJobHours : SlaveJobHours.values()) {
                    boolean jobDisabled = false;
                    boolean resetI = false;
                    boolean nonSlaveSleeping = false;
                    for (int i = slaveJobHours.getStartHour(); i < slaveJobHours.getStartHour() + slaveJobHours.getLength(); ++i) {
                        if (i > 23) {
                            i -= 24;
                            resetI = true;
                        }
                        if (!jobSelected.isAvailable(i, character)) {
                            jobDisabled = true;
                            break;
                        }
                        if (!nonSlaveSleeping) {
                            boolean bl = nonSlaveSleeping = !character.isSlave() && character.isSleepingAtHour(i);
                        }
                        if (!resetI) continue;
                        i += 24;
                    }
                    if (!character.isSlave() && jobSelected.getHourlyStaminaDrain(character) * (float)slaveJobHours.getLength() > stamina || nonSlaveSleeping || jobDisabled) {
                        UtilText.nodeContentSB.append("<div class='normal-button disabled' id='" + String.valueOf((Object)slaveJobHours) + "_TIME_DISABLED' style='width:16%; margin:2px;'>" + slaveJobHours.getName() + "</div>");
                        continue;
                    }
                    UtilText.nodeContentSB.append("<div class='normal-button' id='" + String.valueOf((Object)slaveJobHours) + "_TIME' style='width:16%; margin:2px;'>" + slaveJobHours.getName() + "</div>");
                }
                UtilText.nodeContentSB.append("</div></div>");
                UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'>");
                UtilText.nodeContentSB.append("<div class='title-button " + (!CompanionManagement.isJobSettingsPasteAvailable() ? "no-select" : "") + "' id='pasteSlaveJobSettings' style='position:absolute; left:auto; right:8px; top:8px; padding:2px; margin:0; width:24px; height:24px; border:1px solid #999; " + (!CompanionManagement.isJobSettingsPasteAvailable() ? "opacity:0.5;" : "") + "'>" + SVGImages.SVG_IMAGE_PROVIDER.getPasteIcon() + "</div>");
                UtilText.nodeContentSB.append("<div class='title-button' id='copySlaveJobSettings' style='position:absolute; left:auto; right:48px; top:8px; padding:2px; margin:0; width:24px; height:24px; border:1px solid #999;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCopyIcon() + "</div>");
                UtilText.nodeContentSB.append("<h6 style='color:" + PresetColour.GENERIC_EXPERIENCE.toWebHexString() + "; text-align:center;'>\u5de5\u4f5c\u8bbe\u7f6e\u4e0e\u76f8\u5173\u4fe1\u606f</h6><div class='container-full-width' style='margin-bottom:0;'><div style='width:20%; float:left; font-weight:bold; margin:0 0 0 4%; padding:0;'>\u5de5\u4f5c</div><div style='float:left; width:9%; font-weight:bold; margin:0; padding:0;'><b>\u5de5\u4eba</b></div><div style='float:left; width:14%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.AFFECTION.toWebHexString() + ";'>\u597d\u611f</b></div><div style='float:left; width:14%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.OBEDIENCE.toWebHexString() + ";'>\u670d\u4ece</b></div><div style='float:left; width:39%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.CURRENCY_GOLD.toWebHexString() + ";'>\u6536\u5165</b>(+<b style='color:" + PresetColour.OBEDIENCE.toWebHexString() + ";'>\u670d\u4ece\u52a0\u6210</b>)</div></div>");
                for (Enum enum_ : SlaveJob.values()) {
                    if (((SlaveJob)enum_).isHidden(character) || !character.isSlave() && !((SlaveJob)enum_).hasFlag(SlaveJobFlag.GUEST_CAN_WORK)) continue;
                    float affectionChange = ((SlaveJob)enum_).getAffectionGain(character);
                    float obedienceChange = ((SlaveJob)enum_).getObedienceGain(character);
                    int income = ((SlaveJob)enum_).getFinalHourlyIncomeAfterModifiers(character);
                    boolean isCurrentJob = character.hasSlaveJobAssigned((SlaveJob)enum_);
                    UtilText.nodeContentSB.append("<div class='container-full-width inner' " + (String)(isCurrentJob ? "style='background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'" : "") + "><div style='width:4%; float:left; margin:0; padding:0;'><div class='title-button no-select' id='SLAVE_JOB_INFO_" + String.valueOf(enum_) + "' style='position:relative; top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getInformationIcon() + "</div></div><div style='width:20%; float:left; margin:0; padding:0;'>" + (isCurrentJob ? "<b style='color:" + ((SlaveJob)enum_).getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(((SlaveJob)enum_).getName(character)) + "</b>" : "[style.colourDisabled(" + Util.capitaliseSentence(((SlaveJob)enum_).getName(character)) + ")]") + "</div><div style='float:left; width:9%; font-weight:bold; margin:0; padding:0;'>" + Main.game.getOccupancyUtil().getTotalCharactersWorkingJob((SlaveJob)enum_) + "/" + String.valueOf(((SlaveJob)enum_).getSlaveLimit() < 0 ? "\u221e" : Integer.valueOf(((SlaveJob)enum_).getSlaveLimit())) + "</div><div style='float:left; width:14%; margin:0; padding:0;'>" + (String)(affectionChange > 0.0f ? "<b style='color:" + PresetColour.AFFECTION.toWebHexString() + ";'>+" + decimalFormat.format(affectionChange) + "</b>" : (affectionChange < 0.0f ? "<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + decimalFormat.format(affectionChange) + "</b>" : "[style.colourDisabled(0)]")) + "/\u5c0f\u65f6</div><div style='float:left; width:14%; margin:0; padding:0;'>" + (String)(obedienceChange > 0.0f ? "<b style='color:" + PresetColour.OBEDIENCE.toWebHexString() + ";'>+" + decimalFormat.format(obedienceChange) + "</b>" : (obedienceChange < 0.0f ? "<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + decimalFormat.format(obedienceChange) + "</b>" : "[style.colourDisabled(0)]")) + "/\u5c0f\u65f6</div><div style='float:left; width:39%; margin:0; padding:0;'>" + UtilText.formatAsMoney(((SlaveJob)enum_).getIncome()) + " + (" + (((SlaveJob)enum_).getObedienceIncomeModifier() > 0.0f ? "[style.colourObedience(" + ((SlaveJob)enum_).getObedienceIncomeModifier() + ")]" : "[style.colourDisabled(" + ((SlaveJob)enum_).getObedienceIncomeModifier() + ")]") + "*<span style='color:" + obedience.getColour().toWebHexString() + ";'>" + character.getObedienceValue() + "</span>) = " + (income > 0 ? UtilText.formatAsMoney(income, "b") : UtilText.formatAsMoney(income, "b", PresetColour.GENERIC_BAD)) + "/\u5c0f\u65f6</div>");
                    for (SlaveJobSetting slaveJobSetting : ((SlaveJob)enum_).getMutualSettings()) {
                        if (!slaveJobSetting.isAvailable()) continue;
                        boolean settingActive = character.hasSlaveJobSetting((SlaveJob)enum_, slaveJobSetting);
                        String id = settingActive ? enum_.toString() + slaveJobSetting.toString() + "_REMOVE" : enum_.toString() + slaveJobSetting.toString() + "_ADD";
                        UtilText.nodeContentSB.append("<div id='" + id + "' class='normal-button" + (settingActive ? " selected" : "") + "' style='width:23%; margin:1%; text-align:center;" + (settingActive ? "border-color:" + ((SlaveJob)enum_).getColour().toWebHexString() + ";" : "border-color:" + ((SlaveJob)enum_).getColour().getShades()[0] + ";") + "'>" + (settingActive ? "<span style='color:" + ((SlaveJob)enum_).getColour().toWebHexString() + ";margin:8px;'>" + slaveJobSetting.getName() + "</span>" : "[style.colourDisabled(" + slaveJobSetting.getName() + ")]") + "</div>");
                    }
                    for (Map.Entry entry : ((SlaveJob)enum_).getMutuallyExclusiveSettings().entrySet()) {
                        UtilText.nodeContentSB.append("<div class='container-full-width inner' style='" + (!isCurrentJob ? "background:#1B1B1B;" : "") + "'><div style='width:100%; float:left; margin:0; padding:0;" + (isCurrentJob ? "" : "color:#777;") + "'><b>" + Util.capitaliseSentence((String)entry.getKey()) + "</b></div>");
                        for (SlaveJobSetting setting : (List)entry.getValue()) {
                            if (!setting.isAvailable()) continue;
                            boolean settingActive = character.hasSlaveJobSetting((SlaveJob)enum_, setting);
                            String id = settingActive ? setting.toString() + "_DISABLED" : setting.toString() + "_TOGGLE_ADD";
                            UtilText.nodeContentSB.append("<div id='" + id + "' class='normal-button" + (settingActive ? " selected" : "") + "' style='width:23%; margin:1%; text-align:center;" + (String)(settingActive ? "border-color:" + ((SlaveJob)enum_).getColour().toWebHexString() + ";" : "") + "'>" + (settingActive ? "<span style='color:" + ((SlaveJob)enum_).getColour().toWebHexString() + ";margin:8px;'>" + setting.getName() + "</span>" : "[style.colourDisabled(" + setting.getName() + ")]") + "</div>");
                        }
                        UtilText.nodeContentSB.append("</div>");
                    }
                    UtilText.nodeContentSB.append("</div>");
                }
                UtilText.nodeContentSB.append("</div>");
                UtilText.nodeContentSB.append("<p id='hiddenFieldName' style='display:none;'></p>");
                return UtilText.parse((GameCharacter)character, UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return coreNode.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return coreNode.getResponse(responseTab, index);
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        SLAVE_MANAGEMENT_PERMISSIONS = new DialogueNode("\u7ba1\u7406\u5974\u96b6", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.Name]: \u8bb8\u53ef", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                NPC character = CompanionManagement.characterSelected();
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(CompanionManagement.getSlaveInformationHeader(character));
                UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'>");
                UtilText.nodeContentSB.append("<div class='title-button " + (!CompanionManagement.isPermissionsPasteAvailable() ? "no-select" : "") + "' id='pastePermissions' style='position:absolute; left:auto; right:8px; top:8px; padding:2px; margin:0; width:24px; height:24px; border:1px solid #999; " + (!CompanionManagement.isPermissionsPasteAvailable() ? "opacity:0.5;" : "") + "'>" + SVGImages.SVG_IMAGE_PROVIDER.getPasteIcon() + "</div>");
                UtilText.nodeContentSB.append("<div class='title-button' id='copyPermissions' style='position:absolute; left:auto; right:48px; top:8px; padding:2px; margin:0; width:24px; height:24px; border:1px solid #999;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCopyIcon() + "</div>");
                UtilText.nodeContentSB.append("<h6 style='color:" + PresetColour.GENERIC_ARCANE.toWebHexString() + "; text-align:center;'>\u6743\u9650</h6>");
                for (SlavePermission permission : SlavePermission.values()) {
                    if (!permission.isAvailableForCharacter(character)) continue;
                    UtilText.nodeContentSB.append("<div class='container-full-width inner' style='box-sizing:border-box; position:relative; width:98%; margin:4px 1%; background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'>");
                    for (SlavePermissionSetting setting : permission.getSettings()) {
                        if (!setting.isAvailableForCharacter(character)) continue;
                        boolean settingActive = character.getSlavePermissionSettings().get((Object)permission).contains((Object)setting);
                        String id = permission.isMutuallyExclusiveSettings() ? (settingActive ? String.valueOf((Object)setting) + "_REMOVE_ME" : String.valueOf((Object)setting) + "_ADD") : (settingActive ? String.valueOf((Object)setting) + "_REMOVE" : String.valueOf((Object)setting) + "_ADD");
                        String style = "width:23%; margin:1%;";
                        if (permission.getSettings().size() == 5) {
                            style = "width:18%; margin:1%;";
                        }
                        UtilText.nodeContentSB.append("<div id='" + id + "' class='normal-button" + (settingActive ? " selected" : "") + "' style='" + style + "text-align:center;" + (String)(settingActive ? "border-color:" + permission.getColour().toWebHexString() + ";" : (permission.isMutuallyExclusiveSettings() ? "" : "border-color:" + permission.getColour().getShades()[0] + ";")) + "'>" + (settingActive ? "<span style='color:" + permission.getColour().toWebHexString() + ";margin:8px;'>" + setting.getName() + "</span>" : "[style.colourDisabled(" + setting.getName() + ")]") + "</div>");
                    }
                    UtilText.nodeContentSB.append("</div>");
                }
                UtilText.nodeContentSB.append("</div><p id='hiddenFieldName' style='display:none;'></p>");
                return UtilText.parse((GameCharacter)character, UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return coreNode.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return coreNode.getResponse(responseTab, index);
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        SLAVE_MANAGEMENT_COSMETICS_MAKEUP = new DialogueNode("\u5974\u96b6\u7ba1\u7406", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.Name]: \u5986\u5bb9", new ParserTag[0]);
            }

            @Override
            public String getHeaderContent() {
                return UtilText.parse(BodyChanging.getTarget(), "<h6 style='text-align:center;'>\u4f60\u5f53\u524d\u62e5\u6709" + UtilText.formatAsMoney(Main.game.getPlayer().getMoney(), "span") + "</h6>" + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyCoveringType.MAKEUP_BLUSHER, "\u816e\u7ea2", "\u816e\u7ea2(\u4e5f\u53eb\u80ed\u8102)\u88ab\u7528\u6765\u7c89\u9970\u8138\u988a\uff0c\u4ee5\u663e\u5f97\u66f4\u52a0\u5e74\u8f7b\u6216\u51f8\u663e\u98a7\u9aa8\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyCoveringType.MAKEUP_LIPSTICK, "\u53e3\u7ea2", "\u53e3\u7ea2\u88ab\u7528\u6765\u4e3a\u5634\u5507\u63d0\u4f9b\u8272\u5f69\u3001\u8d28\u5730\u6216\u4fdd\u62a4\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyCoveringType.MAKEUP_EYE_LINER, "\u773c\u7ebf", "\u773c\u7ebf\u7528\u4e8e\u773c\u5ed3\u5468\u56f4\uff0c\u6709\u52a9\u4e8e\u4fee\u9970\u773c\u578b\u6216\u7a81\u51fa\u4e0d\u540c\u7684\u7279\u5f81\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyCoveringType.MAKEUP_EYE_SHADOW, "\u773c\u5f71", "\u773c\u5f71\u7528\u6765\u8ba9\u4f7f\u7528\u8005\u7684\u773c\u775b\u66f4\u52a0\u51f8\u663e\u8ff7\u4eba\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyCoveringType.MAKEUP_NAIL_POLISH_HANDS, "\u6307\u7532\u6cb9", "\u6307\u7532\u6cb9\u7528\u4e8e\u7ed9[npc.namePos]\u7684[npc.hands]\u6dfb\u52a0\u8272\u5f69\u6216\u63d0\u4f9b\u4fdd\u62a4\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyCoveringType.MAKEUP_NAIL_POLISH_FEET, "\u811a\u8dbe\u7532\u6cb9", "\u811a\u8dbe\u7532\u6cb9\u7528\u4e8e\u7ed9[npc.namePos]\u7684[npc.feet]\u6dfb\u52a0\u8272\u5f69\u6216\u63d0\u4f9b\u4fdd\u62a4\u3002", true, true), new ParserTag[0]);
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u5316\u5986", UtilText.parse(BodyChanging.getTarget(), "\u4f60\u6b63\u5728\u66f4\u6539[npc.namePos]\u7684\u5986\u5bb9\uff01", new ParserTag[0]), null);
                }
                return CompanionManagement.getCosmeticsResponse(responseTab, index);
            }
        };
        SLAVE_MANAGEMENT_COSMETICS_HAIR = new DialogueNode("\u5974\u96b6\u7ba1\u7406", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.Name]: \u6bdb\u53d1", new ParserTag[0]);
            }

            @Override
            public String getHeaderContent() {
                return UtilText.parse(BodyChanging.getTarget(), "<h6 style='text-align:center;'>\u4f60\u5f53\u524d\u62e5\u6709" + UtilText.formatAsMoney(Main.game.getPlayer().getMoney(), "span") + "</h6>" + (BodyChanging.getTarget().isDoll() ? "" : CharacterModificationUtils.getKatesDivHairLengths(true, "\u5934\u53d1\u957f\u5ea6", "\u5934\u53d1\u957f\u5ea6\u51b3\u5b9a\u4e86[npc.namePos]\u80fd\u505a\u7684\u53d1\u578b\u79cd\u7c7b\u3002[npc.her][npc.hair(true)]\u8d8a\u957f\uff0c\u53d1\u578b\u79cd\u7c7b\u5c31\u8d8a\u4e30\u5bcc\u3002")) + CharacterModificationUtils.getKatesDivHairStyles(true, "\u53d1\u578b", "\u53ef\u7528\u7684\u53d1\u578b\u662f\u7531[npc.namePos][npc.hair(true)]\u957f\u5ea6\u51b3\u5b9a\u7684\u3002") + (BodyChanging.getTarget().getBodyMaterial() != BodyMaterial.SLIME && !BodyChanging.getTarget().isDoll() ? CharacterModificationUtils.getKatesDivCoveringsNew(true, BodyChanging.getTarget().getHairType().getRace(), BodyChanging.getTarget().getCovering(BodyChanging.getTarget().getHairCovering()).getType(), UtilText.parse(BodyChanging.getTarget(), "[npc.Hair]\u989c\u8272", new ParserTag[0]), "\u6240\u6709\u6bdb\u53d1\u7684\u6539\u53d8\u989c\u8272\u90fd\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u4f60\u4e4b\u540e\u53c8\u60f3\u8981\u6539\u53d8\u989c\u8272\uff0c\u90a3\u5c31\u5fc5\u987b\u518d\u6765\u627e\u51ef\u7279\u3002", true, true) : ""), new ParserTag[0]);
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 2) {
                    return new Response("\u5934\u53d1", UtilText.parse(BodyChanging.getTarget(), "\u4f60\u6b63\u5728\u66f4\u6539[npc.namePos]\u7684\u6bdb\u53d1\uff01", new ParserTag[0]), null);
                }
                return CompanionManagement.getCosmeticsResponse(responseTab, index);
            }
        };
        SLAVE_MANAGEMENT_COSMETICS_PIERCINGS = new DialogueNode("\u5974\u96b6\u7ba1\u7406", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.Name]: \u7a7f\u5b54", new ParserTag[0]);
            }

            @Override
            public String getHeaderContent() {
                return UtilText.parse(BodyChanging.getTarget(), "<h6 style='text-align:center;'>\u4f60\u5f53\u524d\u62e5\u6709" + UtilText.formatAsMoney(Main.game.getPlayer().getMoney(), "span") + "</h6>" + CharacterModificationUtils.getKatesDivPiercings(false), new ParserTag[0]);
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 3) {
                    return new Response("\u7a7f\u5b54", UtilText.parse(BodyChanging.getTarget(), "\u4f60\u6b63\u5728\u66f4\u6539[npc.namePos]\u7684\u7a7f\u5b54\uff01", new ParserTag[0]), null);
                }
                return CompanionManagement.getCosmeticsResponse(responseTab, index);
            }
        };
        SLAVE_MANAGEMENT_COSMETICS_EYES = new DialogueNode("\u5974\u96b6\u7ba1\u7406", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.Name]: \u773c\u775b", new ParserTag[0]);
            }

            @Override
            public String getHeaderContent() {
                return UtilText.parse(BodyChanging.getTarget(), "<h6 style='text-align:center;'>\u4f60\u5f53\u524d\u62e5\u6709" + UtilText.formatAsMoney(Main.game.getPlayer().getMoney(), "span") + "</h6>" + CharacterModificationUtils.getKatesDivCoveringsNew(true, BodyChanging.getTarget().getEyeType().getRace(), BodyChanging.getTarget().getEyeCovering(), "\u8679\u819c", "\u8679\u819c\u6307\u7684\u662f\u773c\u775b\u4e2d\u67d3\u8272\u7684\u90e8\u5206\uff0c\u8d1f\u8d23\u63a7\u5236\u77b3\u5b54\u7684\u76f4\u5f84\u548c\u5927\u5c0f\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyChanging.getTarget().getBodyMaterial() != BodyMaterial.FLESH ? BodyCoveringType.getMaterialBodyCoveringType(BodyChanging.getTarget().getBodyMaterial(), BodyCoveringCategory.EYE_PUPIL) : BodyCoveringType.EYE_PUPILS, "\u77b3\u5b54", "\u77b3\u5b54\u662f\u4f4d\u4e8e\u8679\u819c\u4e2d\u5fc3\u7684\u900f\u660e\u7269\u4f53\uff0c\u4ee5\u4fbf\u5149\u7ebf\u6253\u5728\u89c6\u7f51\u819c\u4e0a\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyChanging.getTarget().getBodyMaterial() != BodyMaterial.FLESH ? BodyCoveringType.getMaterialBodyCoveringType(BodyChanging.getTarget().getBodyMaterial(), BodyCoveringCategory.EYE_SCLERA) : BodyCoveringType.EYE_SCLERA, "\u5355\u773c\u5de9\u819c", "\u5de9\u819c\u6307\u5f97\u662f\u773c\u775b\u4e2d\u5305\u56f4\u8679\u819c\u7684\u90e8\u5206(\u901a\u5e38\u662f\u767d\u8272\u7684)\u3002", true, true), new ParserTag[0]);
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 4) {
                    return new Response("\u773c\u775b", UtilText.parse(BodyChanging.getTarget(), "\u4f60\u6b63\u5728\u66f4\u6539[npc.namePos]\u7684\u773c\u775b\uff01", new ParserTag[0]), null);
                }
                return CompanionManagement.getCosmeticsResponse(responseTab, index);
            }
        };
        SLAVE_MANAGEMENT_COSMETICS_COVERINGS = new DialogueNode("\u5974\u96b6\u7ba1\u7406", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.Name]: \u4f53\u6bdb", new ParserTag[0]);
            }

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<h6 style='text-align:center;'>\u4f60\u5f53\u524d\u62e5\u6709" + UtilText.formatAsMoney(Main.game.getPlayer().getMoney(), "span") + "</h6>");
                for (Map.Entry<AbstractBodyCoveringType, Util.Value<AbstractRace, List<String>>> entry : SuccubisSecrets.coveringsNamesMap.entrySet()) {
                    AbstractBodyCoveringType bct = entry.getKey();
                    AbstractRace race = entry.getValue().getKey();
                    GameCharacter target = BodyChanging.getTarget();
                    Util.Value<String, String> titleDescription = SuccubisSecrets.getCoveringTitleDescription(target, bct, entry.getValue().getValue());
                    UtilText.nodeContentSB.append(CharacterModificationUtils.getKatesDivCoveringsNew(true, race, bct, titleDescription.getKey(), UtilText.parse(target, titleDescription.getValue(), new ParserTag[0]), true, true));
                }
                return UtilText.parse(BodyChanging.getTarget(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 5) {
                    return new Response("\u4f53\u8868", UtilText.parse(BodyChanging.getTarget(), "\u4f60\u6b63\u5728\u66f4\u6539[npc.namePos]\u7684\u4f53\u6bdb\uff01", new ParserTag[0]), null);
                }
                return CompanionManagement.getCosmeticsResponse(responseTab, index);
            }
        };
        SLAVE_MANAGEMENT_COSMETICS_OTHER = new DialogueNode("\u5974\u96b6\u7ba1\u7406", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.Name]: \u5176\u4ed6", new ParserTag[0]);
            }

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<h6 style='text-align:center;'>\u4f60\u5f53\u524d\u62e5\u6709" + UtilText.formatAsMoney(Main.game.getPlayer().getMoney(), "span") + "</h6>" + CharacterModificationUtils.getKatesDivAnalBleaching());
                if (!BodyChanging.getTarget().isDoll()) {
                    UtilText.nodeContentSB.append((Main.game.isFacialHairEnabled() ? CharacterModificationUtils.getKatesDivFacialHair(true, "\u8138\u90e8\u6bdb\u53d1", "[npc.namePos]\u8138\u4e0a\u7684\u6bdb\u53d1\u3002" + (Main.game.isFemaleFacialHairEnabled() ? "" : "\u5973\u6027\u5316\u89d2\u8272\u65e0\u6cd5\u957f\u51fa\u8138\u90e8\u6bdb\u53d1\u3002")) : "") + (Main.game.isPubicHairEnabled() ? CharacterModificationUtils.getKatesDivPubicHair(true, "\u9634\u6bdb", "\u751f\u6b96\u5668\u9644\u8fd1\u7684\u4f53\u6bdb\uff1b\u4f4d\u4e8e[npc.namePos]\u6027\u5668\u5b98\u548c\u80ef\u90e8\u9644\u8fd1\u3002") : "") + (Main.game.isBodyHairEnabled() ? CharacterModificationUtils.getKatesDivUnderarmHair(true, "\u814b\u6bdb", "[npc.namePos]\u814b\u4e0b\u7684\u4f53\u6bdb\u3002") : "") + (Main.game.isAssHairEnabled() ? CharacterModificationUtils.getKatesDivAssHair(true, "\u809b\u6bdb", "[npc.namePos]\u809b\u95e8\u9644\u8fd1\u7684\u4f53\u6bdb\u3002") : ""));
                    for (AbstractBodyCoveringType bct : BodyCoveringType.getAllBodyCoveringTypes()) {
                        if (!(Main.game.isFacialHairEnabled() && BodyChanging.getTarget().getFacialHairType().getType() == bct || Main.game.isBodyHairEnabled() && BodyChanging.getTarget().getUnderarmHairType().getType() == bct || Main.game.isAssHairEnabled() && BodyChanging.getTarget().getAssHairType().getType() == bct) && (!Main.game.isPubicHairEnabled() || BodyChanging.getTarget().getPubicHairType().getType() != bct)) continue;
                        UtilText.nodeContentSB.append(CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, bct, "\u4f53\u6bdb", "\u4f60\u7684\u4f53\u6bdb\u3002", true, true));
                    }
                }
                return UtilText.parse(BodyChanging.getTarget(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 6) {
                    return new Response("\u5176\u4ed6", UtilText.parse(BodyChanging.getTarget(), "\u4f60\u6b63\u5728\u66f4\u6539[npc.namePos]\u7684\u5176\u4ed6\u7279\u5f81\uff01", new ParserTag[0]), null);
                }
                return CompanionManagement.getCosmeticsResponse(responseTab, index);
            }
        };
        SLAVE_MANAGEMENT_TATTOOS = new DialogueNode("\u9b45\u9b54\u7684\u79d8\u5bc6", "-", true){

            @Override
            public String getContent() {
                return CharacterModificationUtils.getKatesDivTattoos();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 7) {
                    return new Response("\u7eb9\u8eab", UtilText.parse(BodyChanging.getTarget(), "\u4f60\u6b63\u5728\u66f4\u6539[npc.namePos]\u7684\u7eb9\u8eab\uff01", new ParserTag[0]), null);
                }
                if (index == 11) {
                    return new Response("\u786e\u8ba4\u72b6\u6001\uff1a", "\u5f00\u542f\u7eb9\u8eab\u53bb\u9664\u786e\u8ba4\u3002\u542f\u7528\u65f6\uff0c\u9700\u8981\u70b9\u51fb\u4e24\u6b21\u624d\u80fd\u79fb\u9664\u7eb9\u8eab\u3002\u5173\u95ed\u65f6\u53ea\u9700\u8981\u4e00\u6b21\u70b9\u51fb\u3002", SLAVE_MANAGEMENT_TATTOOS){

                        @Override
                        public String getTitle() {
                            return "\u786e\u8ba4\u72b6\u6001\uff1a" + (Main.getProperties().hasValue(PropertyValue.tattooRemovalConfirmations) ? "<span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5f00\u542f</span>" : "<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u5173\u95ed</span>");
                        }

                        @Override
                        public void effects() {
                            Main.getProperties().setValue(PropertyValue.tattooRemovalConfirmations, !Main.getProperties().hasValue(PropertyValue.tattooRemovalConfirmations));
                            Main.getProperties().savePropertiesAsXML();
                        }
                    };
                }
                return CompanionManagement.getCosmeticsResponse(responseTab, index);
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        SLAVE_MANAGEMENT_TATTOOS_ADD = new DialogueNode("\u9b45\u9b54\u7684\u79d8\u5bc6", "-", true){

            @Override
            public String getLabel() {
                return "\u9b45\u9b54\u7684\u79d8\u5bc6-" + Util.capitaliseSentence(CharacterModificationUtils.tattooInventorySlot.getName()) + "\u7eb9\u8eab";
            }

            @Override
            public String getContent() {
                return CharacterModificationUtils.getKatesDivTattoosAdd();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                final int value = CharacterModificationUtils.tattoo.getValue();
                if (index == 1) {
                    if (Main.game.getPlayer().getMoney() < (long)value) {
                        return new Response("\u5e94\u7528(" + UtilText.formatAsMoneyUncoloured(value, "span") + ")", UtilText.parse(BodyChanging.getTarget(), "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u94b1\u53ef\u4ee5\u7ed9[npc.name]\u7eb9\u8eab\uff01", new ParserTag[0]), null);
                    }
                    if (CharacterModificationUtils.tattoo.getType().equals(TattooType.getTattooTypeFromId("innoxia_misc_none")) && CharacterModificationUtils.tattoo.getWriting().getText().isEmpty() && CharacterModificationUtils.tattoo.getCounter().getType() == TattooCounterType.NONE) {
                        return new Response("\u5e94\u7528(" + UtilText.formatAsMoneyUncoloured(value, "span") + ")", "\u4f60\u9700\u8981\u9009\u62e9\u7eb9\u8eab\u7c7b\u578b\uff0c\u6dfb\u52a0\u4e00\u4e9b\u6587\u5b57\u6216\u8ba1\u6570\u6307\u793a\u624d\u80fd\u5f62\u6210\u5b8c\u6574\u7684\u7eb9\u8eab\uff01", null);
                    }
                    return new Response("\u5e94\u7528(" + UtilText.formatAsMoney(value, "span") + ")", UtilText.parse(BodyChanging.getTarget(), "\u4ed8\u94b1\u8ba9\u51ef\u7279\u7ed9[npc.name]\u7eb9\u8fd9\u4e2a\u7eb9\u8eab\uff01", new ParserTag[0]), SLAVE_MANAGEMENT_TATTOOS){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(Main.game.getPlayer().incrementMoney(-value));
                            Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('tattoo_name').value;");
                            CharacterModificationUtils.tattoo.getWriting().setText(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
                            CharacterModificationUtils.tattoo.setName(CharacterModificationUtils.tattoo.getType().getName());
                            BodyChanging.getTarget().addTattoo(CharacterModificationUtils.tattooInventorySlot, CharacterModificationUtils.tattoo);
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u4fdd\u5b58/\u52a0\u8f7d\u7eb9\u8eab\u9884\u8bbe\u3002", CosmeticsDialogue.TATTOO_SAVE_LOAD){

                        @Override
                        public void effects() {
                            CosmeticsDialogue.initTattooSaveLoadDialogue(SLAVE_MANAGEMENT_TATTOOS_ADD);
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u53d6\u6d88\u7eb9\u8eab\u5e76\u56de\u5230\u9009\u62e9\u83dc\u5355\u3002", SLAVE_MANAGEMENT_TATTOOS);
                }
                return null;
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        SLAVE_MANAGEMENT_PERKS = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.NamePos]\u7684\u5929\u8d4b", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "<details><summary>[style.boldPerk(\u5929\u8d4b\u4e0e\u7279\u6027\u4fe1\u606f)]</summary>[style.colourPerk(\u5929\u8d4b)](\u5706\u5f62\u56fe\u6807)\u4e3a[npc.namePos]\u5c5e\u6027\u63d0\u4f9b\u6c38\u4e45\u589e\u76ca\u3002<br/>[style.colourPerk(\u7279\u6027)](\u65b9\u5f62\u56fe\u6807)\u4e3a[npc.name]\u63d0\u4f9b\u72ec\u7279\u7684\u6548\u679c\u3002\u4e0e\u5929\u8d4b\u4e0d\u540c\uff0c<b>\u7279\u6027\u5728\u52a0\u5165\u201c\u751f\u6548\u7279\u6027\u201d\u680f\u4e4b\u524d\u4e0d\u4f1a\u6709\u4efb\u4f55\u6548\u679c</b>\u3002<br/>\u5929\u8d4b\u9700\u9700\u8981\u5929\u8d4b\u70b9\u6570\u89e3\u9501\u3002[npc.Name]\u6bcf\u5f53\u5347\u7ea7\u65f6\u4fbf\u4f1a\u83b7\u5f97\u4e00\u70b9\u5929\u8d4b\u70b9\u6570\uff0c\u5e76\u4e14\u6bcf\u4e94\u7ea7\u83b7\u5f97\u989d\u5916\u4e24\u70b9\u5929\u8d4b\u70b9\u6570\u3002<br/><br/>\u9664\u4e86\u8fd9\u4e9b\u901a\u8fc7\u5929\u8d4b\u70b9\u89e3\u9501\u7684\u5929\u8d4b\u4ee5\u5916\uff0c\u8fd8\u5b58\u5728\u7740\u4e00\u4e9b\u901a\u8fc7\u7279\u6b8a\u4e8b\u4ef6\u89e3\u9501\u7684\u7279\u6b8a\u9690\u85cf\u5929\u8d4b\u3002</details>", new ParserTag[0]));
                UtilText.nodeContentSB.append(PerkManager.MANAGER.getPerkTreeDisplay(CompanionManagement.characterSelected(), true));
                UtilText.nodeContentSB.append("</div>");
                if (!CompanionManagement.characterSelected().isElemental() && !CompanionManagement.characterSelected().isDoll()) {
                    UtilText.nodeContentSB.append("<div class='container-full-width' style='padding:8px; text-align:center;'><i>\u8bf7\u6ce8\u610f\u6b64\u5929\u8d4b\u6811\u4ecd\u5728\u65bd\u5de5\uff0c\u5e76\u975e\u6700\u7ec8\u7248\u672c\uff0c\u4ec5\u7528\u4e8e\u5c55\u793a\u6982\u5ff5\uff01</i></div>");
                }
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getResponseTabTitle(int index) {
                return coreNode.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return coreNode.getResponse(responseTab, index);
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        OCCUPANT_CHOOSE_NAME = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (CompanionManagement.characterSelected().isSlave()) {
                    UtilText.nodeContentSB.append(UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "<p>\u4ece\u73b0\u5728\u5f00\u59cb\uff0c[npc.nameIsFull]\u5c06\u79f0\u547c\u4f60\u4e3a\u201c[npc.pcName]\u201d\uff0c\u4f60\u4e0d\u7981\u601d\u8003\u8d77\u8be5\u4e0d\u8be5\u8ba9[npc.herHim]\u6362\u4e2a\u8bf4\u6cd5\u79f0\u547c\u4f60\u3002[npc.sheIs]\u4e0d\u662f\u4f60\u7684\u5974\u96b6\uff0c\u4f60\u65e0\u6cd5\u968f\u5fc3\u6240\u6b32\u5730\u6539\u53d8[npc.her]\u7684\u540d\u5b57\u2026\u2026</p>", new ParserTag[0]));
                    UtilText.nodeContentSB.append("<div class='container-full-width' style='padding:8px 16px;'><div style='width:18%; float:left; font-weight:bold; margin:0 13% 0 0; padding:0; text-align:center;'>\u540d\u5b57</div><div style='width:18%; float:left; font-weight:bold; margin:0 13% 0 0; padding:0; text-align:center;'>\u59d3\u6c0f</div><div style='width:20%; float:left; font-weight:bold; margin:0 18% 0 0; padding:0; text-align:center;'>" + UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.she]\u5bf9\u4f60\u7684\u79f0\u547c", new ParserTag[0]) + "</div><form style='float:left; width:18%; margin:0; padding:0;'><input type='text' id='slaveNameInput' value='" + UtilText.parseForHTMLDisplay(CompanionManagement.characterSelected().getName(false)) + "' style='width:100%; margin:0; padding:0;'></form><div class='normal-button' id='" + CompanionManagement.characterSelected().getId() + "_RENAME' style='float:left; width:5%; height:22px; line-height:22px; margin:0 0 0 0.5%; padding:0; text-align:center;'>&#10003;</div><div class='normal-button' id='" + CompanionManagement.characterSelected().getId() + "_RENAME_RANDOM' style='float:left; width:5%; height:22px; line-height:22px; margin:0 2% 0 0.5%; padding:0; text-align:center;'>&#127922;</div><form style='float:left; width:18%; margin:0; padding:0;'><input type='text' id='slaveSurnameInput' value='" + UtilText.parseForHTMLDisplay(CompanionManagement.characterSelected().getSurname()) + "' style='width:100%; margin:0; padding:0;'></form><div class='normal-button' id='" + CompanionManagement.characterSelected().getId() + "_RENAME_SURNAME' style='float:left; width:5%; height:22px; line-height:22px; margin:0 0 0 0.5%; padding:0; text-align:center;'>&#10003;</div><div class='normal-button' id='" + CompanionManagement.characterSelected().getId() + "_RENAME_SURNAME_RANDOM' style='float:left; width:5%; height:22px; line-height:22px; margin:0 2% 0 0.5%; padding:0; text-align:center;'>&#127922;</div><form style='float:left; width:20%; margin:0; padding:0;'><input type='text' id='slaveToPlayerNameInput' value='" + UtilText.parseForHTMLDisplay(CompanionManagement.characterSelected().getPetName(Main.game.getPlayer())) + "' style='width:100%; margin:0; padding:0;'></form><div class='normal-button' id='" + CompanionManagement.characterSelected().getId() + "_CALLS_PLAYER' style='float:left; width:5%; height:22px; line-height:22px; margin:0 0 0 0.5%; padding:0; text-align:center;'>&#10003;</div> <div class='normal-button' id='GLOBAL_CALLS_PLAYER' style='float:left; width:12%; height:22px; line-height:22px; margin:0 0 0 0.5%; padding:0; text-align:center;'>\u5168\u4f53\u5974\u96b6</div>");
                } else {
                    UtilText.nodeContentSB.append(UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "<p>\u4ece\u73b0\u5728\u5f00\u59cb\uff0c[npc.nameIsFull]\u5c06\u79f0\u547c\u4f60\u4e3a\u201c[npc.pcName]\u201d\uff0c\u4f60\u4e0d\u7981\u601d\u8003\u8d77\u8be5\u4e0d\u8be5\u8ba9[npc.herHim]\u6362\u4e2a\u8bf4\u6cd5\u79f0\u547c\u4f60\u3002[npc.sheIs]\u4e0d\u662f\u4f60\u7684\u5974\u96b6\uff0c\u4f60\u65e0\u6cd5\u6539\u53d8[npc.herHim]\u7684\u540d\u5b57\u3002</p>", new ParserTag[0]));
                    UtilText.nodeContentSB.append("<div class='container-full-width' style='padding:8px 16px;'><div style='width:18%; float:left; font-weight:bold; margin:0 13% 0 0; padding:0; text-align:center;'>\u540d\u5b57</div><div style='width:18%; float:left; font-weight:bold; margin:0 13% 0 0; padding:0; text-align:center;'>\u59d3\u6c0f</div><div style='width:20%; float:left; font-weight:bold; margin:0 18% 0 0; padding:0; text-align:center;'>" + UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "[npc.she]\u5bf9\u4f60\u7684\u79f0\u547c", new ParserTag[0]) + "</div><form style='float:left; width:18%; margin:0; padding:0;'><input type='text' id='slaveNameInput' value='" + UtilText.parseForHTMLDisplay(CompanionManagement.characterSelected().getName(false)) + "' style='width:100%; margin:0; padding:0;' disabled></form><div class='normal-button disabled' style='float:left; width:5%; height:22px; line-height:22px; margin:0 0 0 0.5%; padding:0; text-align:center;'>&#10003;</div><div class='normal-button disabled' style='float:left; width:5%; height:22px; line-height:22px; margin:0 2% 0 0.5%; padding:0; text-align:center;'>&#127922;</div><form style='float:left; width:18%; margin:0; padding:0;'><input type='text' id='slaveSurnameInput' value='" + UtilText.parseForHTMLDisplay(CompanionManagement.characterSelected().getSurname()) + "' style='width:100%; margin:0; padding:0;' disabled></form><div class='normal-button disabled' style='float:left; width:5%; height:22px; line-height:22px; margin:0 0 0 0.5%; padding:0; text-align:center;'>&#10003;</div><div class='normal-button disabled' style='float:left; width:5%; height:22px; line-height:22px; margin:0 2% 0 0.5%; padding:0; text-align:center;'>&#127922;</div><form style='float:left; width:20%; margin:0; padding:0;'><input type='text' id='slaveToPlayerNameInput' value='" + UtilText.parseForHTMLDisplay(CompanionManagement.characterSelected().getPetName(Main.game.getPlayer())) + "' style='width:100%; margin:0; padding:0;'></form><div class='normal-button' id='" + CompanionManagement.characterSelected().getId() + "_CALLS_PLAYER' style='float:left; width:5%; height:22px; line-height:22px; margin:0 0 0 0.5%; padding:0; text-align:center;'>&#10003;</div> <div class='normal-button disabled' style='float:left; width:12%; height:22px; line-height:22px; margin:0 0 0 0.5%; padding:0; text-align:center;'>\u5168\u4f53\u5974\u96b6</div>");
                }
                UtilText.nodeContentSB.append(UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "<p style='text-align:center; margin-top:4px;'><i>\u5982\u679c[npc.name]\u88ab\u544a\u77e5\u79f0\u547c\u4f60\u4e3a\u201c\u7238\u7238\u201d/\u201c\u5988\u5988\u201d\u3001\u201c\u7239\u5730\u201d/\u201c\u5988\u54aa\u201d\u3001\u201c\u5973\u4e3b\u4eba\u201d/\u201c\u7537\u4e3b\u4eba\u201d\u6216\u201c\u5973\u58eb\u201d/\u201c\u5148\u751f\u201d\uff0c\u90a3\u4e48[npc.she]\u5c06\u6839\u636e\u4f60\u89d2\u8272\u7684\u5973\u6027\u5316\u7a0b\u5ea6\u81ea\u52a8\u5207\u6362\u5408\u9002\u7684\u79f0\u547c\u3002</i></p></div>", new ParserTag[0]));
                UtilText.nodeContentSB.append("<p id='hiddenFieldName' style='display:none;'></p>");
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getResponseTabTitle(int index) {
                return coreNode.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return coreNode.getResponse(responseTab, index);
            }
        };
        SET_SLAVE_FREE_SCARLETT = new DialogueNode("", "", true){

            @Override
            public void applyPreParsingEffects() {
                Main.game.getPlayer().removeSlave(CompanionManagement.characterSelected());
                CompanionManagement.characterSelected().getPetNameMap().remove(Main.game.getPlayer().getId());
                Main.game.getTextEndStringBuilder().append(CompanionManagement.characterSelected().incrementAffection(Main.game.getPlayer(), 25.0f));
                Main.game.getNpc(Scarlett.class).setLocation(WorldType.HARPY_NEST, PlaceType.HARPY_NESTS_HELENAS_NEST, true);
                Main.game.getNpc(Scarlett.class).setObedience(ObedienceLevel.ZERO_FREE_WILLED.getMedianValue());
                ((Scarlett)Main.game.getNpc(Scarlett.class)).resetName();
                ((Scarlett)Main.game.getNpc(Scarlett.class)).completeBodyReset();
                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/enslavement", "SET_SLAVE_FREE_SCARLETT", CompanionManagement.characterSelected()));
                Main.game.getDialogueFlags().setManagementCompanion(null);
            }

            @Override
            public int getSecondsPassed() {
                return 300;
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u7531\u4e8e\u65af\u5609\u4e3d\u5df2\u7ecf\u8dd1\u5f00\u4e86\uff0c\u4f60\u9664\u4e86\u7ee7\u7eed\u4f60\u7684\u4e00\u5929\u5916\u6ca1\u4ec0\u4e48\u53ef\u505a\u7684\u2026\u2026", Main.game.getDefaultDialogue(false));
                }
                return null;
            }
        };
        SET_SLAVE_FREE = new DialogueNode("", "", true){

            @Override
            public void applyPreParsingEffects() {
                Main.game.getPlayer().removeItemByType(ItemType.getItemTypeFromId("innoxia_slavery_freedom_certification"));
                Main.game.getPlayer().removeSlave(CompanionManagement.characterSelected());
                CompanionManagement.characterSelected().setEnslavementDialogue(SlaveDialogue.FREEDOM_DIALOG, false);
                if (!CompanionManagement.isFreedSlaveAvailableAsGuest()) {
                    freedSlaveDeleted = true;
                    if (!CompanionManagement.characterSelected().isAffectionHighEnoughToInviteHome()) {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/enslavement", "SET_SLAVE_FREE_DISLIKE", CompanionManagement.characterSelected()));
                    } else if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ACCOMMODATION) || !OccupancyUtil.isFreeRoomAvailableForOccupant()) {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/enslavement", "SET_SLAVE_FREE_NO_GUEST", CompanionManagement.characterSelected()));
                    }
                    Main.game.banishNPC(CompanionManagement.characterSelected());
                    Main.game.getDialogueFlags().setManagementCompanion(null);
                } else {
                    freedSlaveDeleted = false;
                    CompanionManagement.characterSelected().getPetNameMap().remove(Main.game.getPlayer().getId());
                    Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/enslavement", "SET_SLAVE_FREE_GUEST_CHOICE", CompanionManagement.characterSelected()));
                    Main.game.getTextEndStringBuilder().append(CompanionManagement.characterSelected().incrementAffection(Main.game.getPlayer(), 25.0f));
                }
            }

            @Override
            public int getSecondsPassed() {
                return 300;
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (freedSlaveDeleted) {
                    if (index == 1) {
                        return new Response("\u7ee7\u7eed", "\u73b0\u5728\u4f60\u7684\u5974\u96b6\u5df2\u7ecf\u88ab\u91ca\u653e\u5e76\u6c38\u8fdc\u79bb\u5f00\u4e86\u4f60\uff0c\u4f60\u53ea\u80fd\u7ee7\u7eed\u4f60\u4eca\u5929\u7684\u5176\u4ed6\u8ba1\u5212\u4e86\u2026\u2026", Main.game.getDefaultDialogue(false)){

                            @Override
                            public void effects() {
                            }
                        };
                    }
                } else {
                    if (index == 1) {
                        return new Response("\u63d0\u4f9b\u623f\u95f4", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u95ee\u4e00\u95ee[npc.name]\u60f3\u4e0d\u60f3\u4f5c\u4e3a\u5ba2\u4eba\u7559\u5728\u5b85\u90b8\u91cc\u3002", new ParserTag[0]), SET_SLAVE_FREE_GUEST_ROOM){

                            @Override
                            public void effects() {
                                Cell c = OccupancyUtil.getFreeRoomForOccupant();
                                CompanionManagement.characterSelected().setLocation(c.getType(), c.getLocation(), true);
                                Main.game.getPlayer().setLocation(c.getType(), c.getLocation(), false);
                                Main.game.getPlayer().addFriendlyOccupant(CompanionManagement.characterSelected());
                                Main.game.getTextEndStringBuilder().append(CompanionManagement.characterSelected().incrementAffection(Main.game.getPlayer(), 25.0f));
                            }
                        };
                    }
                    if (index == 2) {
                        return new Response("\u544a\u522b", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u544a\u522b[npc.name]\u2026\u2026<br/>[style.italicsBad([npc.herHim]\u5c06\u4f1a\u4ece\u6e38\u620f\u4e2d\u6c38\u4e45\u5220\u9664\uff01)]", new ParserTag[0]), SET_SLAVE_FREE_END_NO_CONTENT){

                            @Override
                            public Colour getHighlightColour() {
                                return PresetColour.GENERIC_NPC_REMOVAL;
                            }

                            @Override
                            public void effects() {
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/enslavement", "SET_SLAVE_FREE_GOODBYE", CompanionManagement.characterSelected()));
                                Main.game.banishNPC(CompanionManagement.characterSelected());
                                Main.game.getDialogueFlags().setManagementCompanion(null);
                            }
                        };
                    }
                    if (index == 3) {
                        return new Response("\u6254\u51fa\u53bb", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u8ba9\u841d\u4e1d\u6beb\u4e0d\u5ba2\u6c14\u5730\u628a[npc.name]\u8d76\u51fa\u5b85\u90b8\u2026\u2026<br/>[style.italicsBad([npc.herHim]\u5c06\u4f1a\u4ece\u6e38\u620f\u4e2d\u6c38\u4e45\u5220\u9664\uff01)]", new ParserTag[0]), SET_SLAVE_FREE_END_NO_CONTENT){

                            @Override
                            public Colour getHighlightColour() {
                                return PresetColour.GENERIC_NPC_REMOVAL;
                            }

                            @Override
                            public void effects() {
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/enslavement", "SET_SLAVE_FREE_THROWN_OUT", CompanionManagement.characterSelected()));
                                Main.game.banishNPC(CompanionManagement.characterSelected());
                                Main.game.getDialogueFlags().setManagementCompanion(null);
                            }
                        };
                    }
                }
                return null;
            }
        };
        SET_SLAVE_FREE_END_NO_CONTENT = new DialogueNode("", "", false){

            @Override
            public int getSecondsPassed() {
                return 300;
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return Main.game.getDefaultDialogue(false).getResponse(responseTab, index);
            }
        };
        SET_SLAVE_FREE_GUEST_ROOM = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 300;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("characters/enslavement", "SET_SLAVE_FREE_GUEST_ROOM", CompanionManagement.characterSelected());
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", UtilText.parse((GameCharacter)CompanionManagement.characterSelected(), "\u4f60\u628a[npc.name]\u5b89\u7f6e\u5230\u4e86[npc.her]\u7684\u65b0\u623f\u95f4\uff0c\u7ee7\u7eed\u4eca\u5929\u7684\u8ba1\u5212\u2026\u2026", new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setManagementCompanion(null);
                        }
                    };
                }
                return null;
            }
        };
    }
}

