/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.companions;

import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AffectionLevel;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCFlagValue;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.persona.Relationship;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.companions.CompanionManagement;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaSpa;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.RoomPlayer;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.responses.ResponseSex;
import com.lilithsthrone.game.dialogue.responses.ResponseTag;
import com.lilithsthrone.game.dialogue.utils.CharactersPresentDialogue;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.sex.ImmobilisationType;
import com.lilithsthrone.game.sex.SexPace;
import com.lilithsthrone.game.sex.managers.universal.SMGeneric;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.utils.time.DateAndTime;
import com.lilithsthrone.utils.time.SolarElevationAngle;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import com.lilithsthrone.world.places.PlaceUpgrade;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OccupantDialogue {
    private static NPC occupant;
    private static GameCharacter characterForSex;
    private static NPC characterForSexSecondary;
    private static List<NPC> charactersPresent;
    private static boolean isApartment;
    private static boolean confirmKickOut;
    private static boolean initFromCharactersPresent;
    private static int sleepTimeInMinutes;
    public static final DialogueNode OCCUPANT_START_NO_CONTENT;
    public static final DialogueNode OCCUPANT_START;
    public static final DialogueNode OCCUPANT_TALK_LIFE;
    public static final DialogueNode OCCUPANT_TALK_JOB;
    public static final DialogueNode OCCUPANT_TALK_LILAYA;
    public static final DialogueNode OCCUPANT_TALK_SLAVES;
    public static final DialogueNode OCCUPANT_HUG;
    public static final DialogueNode OCCUPANT_PETTINGS;
    public static final DialogueNode OCCUPANT_JOB_SUGGESTION;
    public static final DialogueNode OCCUPANT_JOB_QUIT;
    public static final DialogueNode AFTER_SEX;
    public static final DialogueNode OCCUPANT_KICK_OUT;
    public static final DialogueNode OCCUPANT_MOVE_OUT;
    public static final DialogueNode OCCUPANT_MOVE_OUT_APARTMENT;
    public static final DialogueNode OCCUPANT_APARTMENT_NO_CONTENT;
    public static final DialogueNode OCCUPANT_APARTMENT;
    public static final DialogueNode OCCUPANT_APARTMENT_TALK_LIFE;
    public static final DialogueNode OCCUPANT_APARTMENT_TALK_JOB;
    public static final DialogueNode OCCUPANT_APARTMENT_SLEEP_OVER;
    public static final DialogueNode OCCUPANT_APARTMENT_SLEEP_OVER_WAKE_UP;
    public static final DialogueNode OCCUPANT_APARTMENT_REMOVE;
    public static final DialogueNode APARTMENT_AFTER_SEX;

    public static void initDialogue(NPC targetedOccupant, boolean isApartment, boolean initFromCharactersPresent) {
        if (Main.game.getCurrentDialogueNode().getDialogueNodeType() == DialogueNodeType.NORMAL) {
            Main.game.saveDialogueNode();
        }
        if (isApartment) {
            CompanionManagement.initManagement(OCCUPANT_APARTMENT, 2, targetedOccupant);
        } else if (targetedOccupant.isAtWork() || targetedOccupant.isAtHome()) {
            CompanionManagement.initManagement(OCCUPANT_START, 2, targetedOccupant);
        }
        occupant = targetedOccupant;
        characterForSex = targetedOccupant;
        characterForSexSecondary = null;
        charactersPresent = new ArrayList<NPC>(Main.game.getCharactersPresent());
        charactersPresent.removeIf(npc -> !Main.game.getPlayer().getCompanions().contains(npc) && (!npc.isSlave() || !npc.getOwner().isPlayer()) && !Main.game.getPlayer().getFriendlyOccupants().contains(npc.getId()));
        if (charactersPresent.size() > 1) {
            characterForSexSecondary = charactersPresent.contains(Main.game.getPlayer().getMainCompanion()) && !OccupantDialogue.occupant().equals(Main.game.getPlayer().getMainCompanion()) ? (NPC)Main.game.getPlayer().getMainCompanion() : charactersPresent.stream().filter(npc -> !npc.equals(OccupantDialogue.occupant())).findFirst().get();
        }
        OccupantDialogue.isApartment = isApartment;
        Main.game.getDialogueFlags().setFlag("innoxia_friendly_occupant_apartment", isApartment);
        confirmKickOut = false;
        OccupantDialogue.initFromCharactersPresent = initFromCharactersPresent;
    }

    private static void exitDialogue() {
        Main.game.getDialogueFlags().setManagementCompanion(null);
    }

    private static DialogueNode getAfterSexDialogue() {
        if (initFromCharactersPresent) {
            return CharactersPresentDialogue.AFTER_SEX;
        }
        if (isApartment) {
            return APARTMENT_AFTER_SEX;
        }
        return AFTER_SEX;
    }

    private static NPC occupant() {
        return occupant;
    }

    private static boolean hasJob() {
        return OccupantDialogue.occupant().hasJob();
    }

    private static void applyReactionReset() {
        if (OccupantDialogue.occupant().isVisiblyPregnant()) {
            OccupantDialogue.occupant().setCharacterReactedToPregnancy(Main.game.getPlayer(), true);
        }
        if (Main.game.getPlayer().isVisiblyPregnant()) {
            Main.game.getPlayer().setCharacterReactedToPregnancy(OccupantDialogue.occupant(), true);
        }
        OccupantDialogue.occupant().removeFlag(NPCFlagValue.occupantHasNewJob);
        confirmKickOut = false;
    }

    public static String getTextFilePath() {
        if (OccupantDialogue.occupant().isRelatedTo(Main.game.getPlayer(), new Relationship[0])) {
            return "characters/offspring/occupant";
        }
        return "misc/friendlyOccupantDialogue";
    }

    private static String getThreesomeTextFilePath() {
        if (characterForSex.isRelatedTo(Main.game.getPlayer(), new Relationship[0]) || characterForSexSecondary != null && characterForSexSecondary.isRelatedTo(Main.game.getPlayer(), new Relationship[0])) {
            return "characters/offspring/occupant";
        }
        return "misc/friendlyOccupantDialogue";
    }

    private static boolean isCompanionSexPublic() {
        return !isApartment && Main.game.getPlayer().getLocationPlace().isPopulated() && !Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.WATERING_HOLE_SEATING_AREA) && !Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.WATERING_HOLE_TOILETS);
    }

    private static String getOccupantStartCoreContent() {
        StringBuilder sb = new StringBuilder();
        if (Main.game.getPlayer().getLocationPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_GUEST_ROOM)) {
            sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_START", OccupantDialogue.occupant()));
        } else {
            sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_WORKING", OccupantDialogue.occupant()));
        }
        if (OccupantDialogue.occupant().isVisiblyPregnant()) {
            if (!OccupantDialogue.occupant().isCharacterReactedToPregnancy(Main.game.getPlayer())) {
                sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_START_PREGNANCY_REVEAL", OccupantDialogue.occupant()));
            } else {
                sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_START_STILL_PREGNANT", OccupantDialogue.occupant()));
            }
        }
        if (Main.game.getPlayer().isVisiblyPregnant()) {
            if (!Main.game.getPlayer().isCharacterReactedToPregnancy(OccupantDialogue.occupant())) {
                sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_START_PLAYER_PREGNANCY", OccupantDialogue.occupant()));
            } else {
                sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_START_CONTINUED_PLAYER_PREGNANCY", OccupantDialogue.occupant()));
            }
        }
        if (OccupantDialogue.occupant().hasFlag(NPCFlagValue.occupantHasNewJob)) {
            sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_START_FINISH_WITH_NEW_JOB", OccupantDialogue.occupant()));
        } else {
            sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_START_FINISH", OccupantDialogue.occupant()));
        }
        sb.append(OccupantDialogue.occupant().getPlayerRelationStatusDescription());
        return sb.toString();
    }

    private static String getOccupantApartmentCoreContent() {
        StringBuilder sb = new StringBuilder();
        if (Main.game.getPlayer().getCompanions().contains(OccupantDialogue.occupant())) {
            sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_AS_COMPANION", OccupantDialogue.occupant()));
        } else if (OccupantDialogue.occupant().isAtHome()) {
            sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_START", OccupantDialogue.occupant()));
            if (OccupantDialogue.occupant().isAsleep()) {
                sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_SLEEPING", OccupantDialogue.occupant()));
            } else {
                if (OccupantDialogue.occupant().isVisiblyPregnant() && OccupantDialogue.occupant().isCharacterPossiblyFather(Main.game.getPlayer().getId())) {
                    if (!OccupantDialogue.occupant().isCharacterReactedToPregnancy(Main.game.getPlayer())) {
                        sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_START_PREGNANCY_REVEAL", OccupantDialogue.occupant()));
                    } else {
                        sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_START_STILL_PREGNANT", OccupantDialogue.occupant()));
                    }
                }
                if (Main.game.getPlayer().isVisiblyPregnant() && Main.game.getPlayer().isCharacterPossiblyFather(OccupantDialogue.occupant().getId())) {
                    if (!Main.game.getPlayer().isCharacterReactedToPregnancy(OccupantDialogue.occupant())) {
                        sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_START_PLAYER_PREGNANCY", OccupantDialogue.occupant()));
                    } else {
                        sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_START_CONTINUED_PLAYER_PREGNANCY", OccupantDialogue.occupant()));
                    }
                }
                sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_START_FINISH", OccupantDialogue.occupant()));
                sb.append(OccupantDialogue.occupant().getPlayerRelationStatusDescription());
            }
        } else {
            sb.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_NOT_AT_HOME", OccupantDialogue.occupant()));
        }
        return sb.toString();
    }

    static {
        sleepTimeInMinutes = 240;
        OCCUPANT_START_NO_CONTENT = new DialogueNode("", "", true){

            @Override
            public String getLabel() {
                return Main.game.getPlayer().getLocationPlace().getName();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return OCCUPANT_START.getResponse(responseTab, index);
            }
        };
        OCCUPANT_START = new DialogueNode("", "", true){

            @Override
            public String getLabel() {
                return Main.game.getPlayer().getLocationPlace().getName();
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (OccupantDialogue.occupant().isAsleep()) {
                    UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_SLEEPING", OccupantDialogue.occupant()));
                } else {
                    if (Main.game.getPlayer().getLocationPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_GUEST_ROOM)) {
                        UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_ENTRY", OccupantDialogue.occupant()));
                    }
                    UtilText.nodeContentSB.append(OccupantDialogue.getOccupantStartCoreContent());
                }
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                if (index == 0) {
                    return "\u4e92\u52a8";
                }
                if (index == 1) {
                    return UtilText.parse("[style.colourSex(\u505a\u7231)]", new ParserTag[0]);
                }
                if (index == 2) {
                    return UtilText.parse("[style.colourCompanion(\u7ba1\u7406)]", new ParserTag[0]);
                }
                return null;
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (OccupantDialogue.occupant().isAsleep()) {
                    if (responseTab == 1) {
                        if (index == 1) {
                            if (!OccupantDialogue.occupant().hasTrait(Perk.HEAVY_SLEEPER, true)) {
                                return new Response("\u7761\u5978", UtilText.parse(characterForSex, "[npc.Name]\u5e76\u4e0d\u662f\u91cd\u5ea6\u6c89\u7761\u8005\uff0c\u56e0\u6b64\u4f60\u4e0d\u80fd\u5bf9[npc.herHim]\u8fdb\u884c\u7761\u5978\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                                return new Response("\u7761\u5978", UtilText.parse(characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c\u4f60\u4e0d\u80fd\u5f3a\u8feb[npc.herHim]\u548c\u4f60\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (characterForSex.getSexConsensualCount(Main.game.getPlayer()) == 0) {
                                return new Response("\u7761\u5978", UtilText.parse(characterForSex, "\u5728\u7761\u5978[npc.name]\u4e4b\u524d\uff0c\u4f60\u5fc5\u987b\u8981\u548c[npc.herHim]\u81f3\u5c11\u505a\u8fc7\u4e00\u6b21\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            return new ResponseSex("\u7761\u5978", UtilText.parse(characterForSex, isApartment ? "[npc.sheIs]\u662f\u4e00\u4e2a\u91cd\u5ea6\u6c89\u7761\u8005\uff0c\u4f60\u53ef\u4ee5\u6084\u6084\u6e9c\u8fdb[npc.namePos]\u7684\u516c\u5bd3\uff0c\u5728\u4e0d\u5435\u9192[npc.herHim]\u7684\u60c5\u51b5\u4e0b\u5077\u5077\u4e0e[npc.herHim]\u53d1\u751f\u6027\u884c\u4e3a\u2026\u2026" : "[npc.sheIs]\u662f\u4e00\u4e2a\u91cd\u5ea6\u6c89\u7761\u8005\uff0c\u4f60\u53ef\u4ee5\u6084\u6084\u6e9c\u8fdb[npc.namePos]\u7684\u623f\u95f4\uff0c\u5728\u4e0d\u5435\u9192[npc.herHim]\u7684\u60c5\u51b5\u4e0b\u5077\u5077\u4e0e[npc.herHim]\u53d1\u751f\u6027\u884c\u4e3a\u2026\u2026", new ParserTag[0]), true, false, new SMGeneric(Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(characterForSex), null, null, new ResponseTag[]{ResponseTag.PREFER_MISSIONARY}){

                                @Override
                                public boolean isPublicSex() {
                                    return false;
                                }

                                @Override
                                public SexPace getStartingSexPaceModifier(GameCharacter character) {
                                    if (character.isPlayer()) {
                                        return SexPace.DOM_GENTLE;
                                    }
                                    return super.getStartingSexPaceModifier(character);
                                }

                                @Override
                                public Map<ImmobilisationType, Map<GameCharacter, Set<GameCharacter>>> getStartingCharactersImmobilised() {
                                    HashMap<ImmobilisationType, Map<GameCharacter, Set<GameCharacter>>> map = new HashMap<ImmobilisationType, Map<GameCharacter, Set<GameCharacter>>>();
                                    map.put(ImmobilisationType.SLEEP, new HashMap());
                                    ((Map)map.get((Object)ImmobilisationType.SLEEP)).put(Main.game.getPlayer(), Util.newHashSetOfValues(characterForSex));
                                    return map;
                                }
                            }, OccupantDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "SEX_START", characterForSex)){

                                @Override
                                public void effects() {
                                    OccupantDialogue.applyReactionReset();
                                }
                            };
                        }
                    } else if (index == 1) {
                        return new Response(UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u53eb\u9192[npc.herHim]", new ParserTag[0]), UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u628a[npc.name]\u53eb\u9192\uff0c\u8fd9\u6837\u4f60\u5c31\u53ef\u4ee5\u548c[npc.herHim]\u8fdb\u884c\u4e92\u52a8\u3002<br/>[style.italicsMinorBad(\u8981\u662f\u628a[npc.She]\u5435\u9192\u4e86\uff0c[npc.herHim]\u80af\u5b9a\u4f1a\u5f88\u751f\u6c14\u7684\u2026\u2026)]", new ParserTag[0]), OCCUPANT_START_NO_CONTENT){

                            @Override
                            public void effects() {
                                Main.game.appendToTextEndStringBuilder(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_ENTRY", OccupantDialogue.occupant()));
                                OccupantDialogue.occupant().wakeUp();
                                Main.game.appendToTextEndStringBuilder(UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "<p style='text-align:center;'>[style.italicsMinorBad([npc.Name]\u4e0d\u60f3\u88ab\u53eb\u9192\u2026\u2026)]</p>", new ParserTag[0]));
                                Main.game.appendToTextEndStringBuilder(OccupantDialogue.occupant().incrementAffection(Main.game.getPlayer(), -1.0f));
                                Main.game.appendToTextEndStringBuilder(OccupantDialogue.getOccupantStartCoreContent());
                            }
                        };
                    }
                    if (index == 0) {
                        return new Response("\u79bb\u5f00", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u79bb\u5f00\uff0c\u8ba9[npc.name]\u597d\u597d\u4f11\u606f", new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                            @Override
                            public void effects() {
                                Main.game.setResponseTab(0);
                                OccupantDialogue.applyReactionReset();
                                Main.game.getDialogueFlags().setManagementCompanion(null);
                            }
                        };
                    }
                    return null;
                }
                if (responseTab == 0) {
                    if (index == 1) {
                        if (!OccupantDialogue.occupant().NPCFlagValues.contains((Object)NPCFlagValue.occupantTalkLife)) {
                            return new Response("\u751f\u6d3b", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u8be2\u95ee[npc.name]\u8fc7\u53bb\u7684\u751f\u6d3b\u3002", new ParserTag[0]), OCCUPANT_TALK_LIFE){

                                @Override
                                public void effects() {
                                    OccupantDialogue.applyReactionReset();
                                    OccupantDialogue.occupant().NPCFlagValues.add(NPCFlagValue.occupantTalkLife);
                                    Main.game.getTextEndStringBuilder().append(OccupantDialogue.occupant().incrementAffection(Main.game.getPlayer(), 5.0f));
                                }
                            };
                        }
                        return new Response("\u751f\u6d3b", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4f60\u5df2\u7ecf\u95ee\u8fc7[npc.name]\u8fc7\u53bb\u7684\u751f\u6d3b\u4e86\u3002", new ParserTag[0]), null);
                    }
                    if (index == 2) {
                        if (!OccupantDialogue.occupant().NPCFlagValues.contains((Object)NPCFlagValue.occupantTalkJob)) {
                            return new Response(OccupantDialogue.hasJob() ? "\u5c31\u4e1a" : (OccupantDialogue.occupant().getDesiredJobs().isEmpty() ? "\u5931\u4e1a" : "\u627e\u5de5\u4f5c"), UtilText.parse((GameCharacter)OccupantDialogue.occupant(), OccupantDialogue.hasJob() ? "\u8be2\u95ee[npc.Name][npc.her]\u7684\u5de5\u4f5c\u3002" : (OccupantDialogue.occupant().getDesiredJobs().isEmpty() ? "\u8be2\u95ee[npc.name]\u662f\u5426\u613f\u610f\u7ee7\u7eed\u5f85\u4e1a\u3002" : "\u8be2\u95ee[npc.name]\u5de5\u4f5c\u627e\u5f97\u600e\u4e48\u6837\u3002"), new ParserTag[0]), OCCUPANT_TALK_JOB){

                                @Override
                                public void effects() {
                                    OccupantDialogue.applyReactionReset();
                                    OccupantDialogue.occupant().NPCFlagValues.add(NPCFlagValue.occupantTalkJob);
                                    Main.game.getTextEndStringBuilder().append(OccupantDialogue.occupant().incrementAffection(Main.game.getPlayer(), 5.0f));
                                }
                            };
                        }
                        return new Response("\u5de5\u4f5c", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), OccupantDialogue.hasJob() ? "\u4f60\u5df2\u7ecf\u95ee\u8fc7[npc.name]\u4eca\u5929\u7684\u5de5\u4f5c\u4e86\u3002" : "\u4f60\u4eca\u5929\u5df2\u7ecf\u95ee\u8fc7[npc.name]\u5de5\u4f5c\u627e\u5f97\u600e\u4e48\u6837\u4e86\u3002", new ParserTag[0]), null);
                    }
                    if (index == 3) {
                        if (!OccupantDialogue.occupant().NPCFlagValues.contains((Object)NPCFlagValue.occupantTalkLilaya)) {
                            return new Response("\u8389\u83b1\u96c5", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u8be2\u95ee[npc.name][npc.her]\u548c\u8389\u83b1\u96c5\u4e0e\u841d\u4e1d\u7684\u4e92\u52a8\u3002", new ParserTag[0]), OCCUPANT_TALK_LILAYA){

                                @Override
                                public void effects() {
                                    OccupantDialogue.applyReactionReset();
                                    OccupantDialogue.occupant().NPCFlagValues.add(NPCFlagValue.occupantTalkLilaya);
                                    Main.game.getTextEndStringBuilder().append(OccupantDialogue.occupant().incrementAffection(Main.game.getPlayer(), 5.0f));
                                }
                            };
                        }
                        return new Response("\u8389\u83b1\u96c5", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u95ee\u8fc7[npc.name][npc.her]\u548c\u8389\u83b1\u96c5\u4e0e\u841d\u4e1d\u7684\u4e92\u52a8\u4e86\u3002", new ParserTag[0]), null);
                    }
                    if (index == 4) {
                        if (Main.game.getPlayer().getSlavesOwned().size() == 0) {
                            return new Response("\u5974\u96b6", "\u4f60\u6ca1\u6709\u5974\u96b6\uff0c\u6240\u4ee5\u4e0d\u80fd\u548c[npc.name]\u8ba8\u8bba\u3002", null);
                        }
                        if (!OccupantDialogue.occupant().NPCFlagValues.contains((Object)NPCFlagValue.occupantTalkSlaves)) {
                            return new Response("\u5974\u96b6", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u8be2\u95ee[npc.name][npc.her]\u548c\u4f60\u7684\u5974\u96b6\u7684\u4e92\u52a8\u3002", new ParserTag[0]), OCCUPANT_TALK_SLAVES){

                                @Override
                                public void effects() {
                                    OccupantDialogue.applyReactionReset();
                                    OccupantDialogue.occupant().NPCFlagValues.add(NPCFlagValue.occupantTalkSlaves);
                                    Main.game.getTextEndStringBuilder().append(OccupantDialogue.occupant().incrementAffection(Main.game.getPlayer(), 5.0f));
                                }
                            };
                        }
                        return new Response("\u5974\u96b6", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u95ee\u8fc7[npc.name][npc.her]\u548c\u4f60\u7684\u5974\u96b6\u7684\u4e92\u52a8\u4e86\u3002", new ParserTag[0]), null);
                    }
                    if (index == 5 && Main.getProperties().hasValue(PropertyValue.companionContent)) {
                        if (!Main.game.getPlayer().hasCompanion(OccupantDialogue.occupant())) {
                            if (!OccupantDialogue.occupant().isCompanionAvailable(Main.game.getPlayer())) {
                                return new Response("\u52a0\u5165\u961f\u4f0d", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "[npc.Name]\u4e0d\u80fd\u52a0\u5165\u4f60\u7684\u961f\u4f0d\uff01", new ParserTag[0]), null);
                            }
                            if (Main.game.getPlayer().canHaveMoreCompanions()) {
                                return new Response("\u52a0\u5165\u961f\u4f0d", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u95ee\u4e00\u95ee[npc.name]\u60f3\u4e0d\u60f3\u966a\u4f60\u4e00\u9635\u3002", new ParserTag[0]), OCCUPANT_START){

                                    @Override
                                    public void effects() {
                                        OccupantDialogue.applyReactionReset();
                                        Main.game.getPlayer().addCompanion(OccupantDialogue.occupant());
                                    }
                                };
                            }
                            return new Response("\u52a0\u5165\u961f\u4f0d", "\u4f60\u7684\u961f\u4f0d\u6ee1\u5458\u4e86\uff01", null);
                        }
                        return new Response("\u4ece\u961f\u4f0d\u79fb\u9664", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u547d\u4ee4[npc.name]\u79bb\u5f00\u4f60\u7684\u961f\u4f0d\u3002", new ParserTag[0]), OCCUPANT_START){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                                Main.game.getPlayer().removeCompanion(OccupantDialogue.occupant());
                            }
                        };
                    }
                    if (index == 6) {
                        if (!OccupantDialogue.occupant().NPCFlagValues.contains((Object)NPCFlagValue.occupantHugged)) {
                            if (!OccupantDialogue.occupant().getAffectionLevel(Main.game.getPlayer()).isGreaterThan(AffectionLevel.POSITIVE_TWO_LIKE)) {
                                return new Response("\u62e5\u62b1", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "[npc.Name]\u4e0d\u592a\u559c\u6b22\u4f60\uff0c\u4e0d\u60f3\u7ed9\u4f60\u4e00\u4e2a\u62e5\u62b1\u3002<br/>[style.italicsMinorBad(\u8981\u6c42[npc.name]\u5bf9\u4f60\u62e5\u6709\u81f3\u5c11'" + AffectionLevel.POSITIVE_THREE_CARING.getName() + "'\u7684\u597d\u611f\u3002)]", new ParserTag[0]), null);
                            }
                            return new Response("\u62e5\u62b1", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u7ed9[npc.name]\u4e00\u4e2a\u5927\u5927\u7684\u62e5\u62b1\u3002", new ParserTag[0]), OCCUPANT_HUG){

                                @Override
                                public void effects() {
                                    OccupantDialogue.applyReactionReset();
                                    OccupantDialogue.occupant().NPCFlagValues.add(NPCFlagValue.occupantHugged);
                                    Main.game.getTextEndStringBuilder().append(OccupantDialogue.occupant().incrementAffection(Main.game.getPlayer(), 5.0f));
                                }
                            };
                        }
                        return new Response("\u62e5\u62b1", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u62e5\u62b1[npc.name]\u4e86\u3002", new ParserTag[0]), null);
                    }
                    if (index == 7) {
                        if (!OccupantDialogue.occupant().NPCFlagValues.contains((Object)NPCFlagValue.occupantPet)) {
                            if (!OccupantDialogue.occupant().getAffectionLevel(Main.game.getPlayer()).isGreaterThan(AffectionLevel.POSITIVE_THREE_CARING)) {
                                return new Response("\u6478\u5934", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "[npc.Name]\u4e0d\u592a\u559c\u6b22\u4f60\uff0c\u4e0d\u60f3\u88ab\u4f60\u6478[npc.herHim]\u7684\u5934\u3002<br/>[style.italicsMinorBad(\u8981\u6c42[npc.name]\u5bf9\u4f60\u62e5\u6709\u81f3\u5c11'" + AffectionLevel.POSITIVE_FOUR_LOVE.getName() + "'\u7684\u597d\u611f\u3002)]", new ParserTag[0]), null);
                            }
                            return new Response("\u7231\u629a", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u5145\u6ee1\u7231\u610f\u5730\u6478\u6478[npc.name]\u3002", new ParserTag[0]), OCCUPANT_PETTINGS){

                                @Override
                                public void effects() {
                                    OccupantDialogue.applyReactionReset();
                                    OccupantDialogue.occupant().NPCFlagValues.add(NPCFlagValue.occupantPet);
                                    Main.game.getTextEndStringBuilder().append(OccupantDialogue.occupant().incrementAffection(Main.game.getPlayer(), 5.0f));
                                }
                            };
                        }
                        return new Response("\u7231\u629a", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u7231\u629a\u8fc7[npc.Name]\u4e86\u3002", new ParserTag[0]), null);
                    }
                    if (index == 8 && Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_SPA) != null) {
                        if (!LilayaSpa.isGuestAbleToEquipSwimwear(OccupantDialogue.occupant())) {
                            return new Response("\u9080\u8bf7\u53bb\u6c34\u7597\u4e2d\u5fc3", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "[npc.name]\u7a7f\u4e0d\u4e86\u6cf3\u88c5\uff0c\u6ca1\u6cd5\u53bb\u6c34\u7597\u4e2d\u5fc3\u2026\u2026<br/><i>\u89e3\u5c01[npc.her]\u7684\u8863\u670d\u5e94\u8be5\u4f1a\u597d\u4e9b\u2026\u2026</i>", new ParserTag[0]), null);
                        }
                        return new Response("\u9080\u8bf7\u53bb\u6c34\u7597\u4e2d\u5fc3", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u95ee\u4e00\u95ee[npc.name]\u60f3\u4e0d\u60f3\u966a\u4f60\u53bb\u4f60\u5728\u8389\u83b1\u96c5\u7684\u5b85\u90b8\u4e2d\u5efa\u597d\u7684\u6c34\u7597\u4e2d\u5fc3\u3002<br/>[style.italicsBlueLight(\u4f60\u5c06\u4e00\u76f4\u7a7f\u7740\u73b0\u5728\u7684\u8863\u670d\uff0c\u6240\u4ee5\u5982\u679c\u4f60\u60f3\u6362\u9002\u5b9c\u7684\u6cf3\u88c5\u5c31\u73b0\u5728\u6362\u4e0a\uff01)]", new ParserTag[0]), LilayaSpa.SPA_GUEST_INVITE){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                                LilayaSpa.initGuestAtSpa(OccupantDialogue.occupant());
                                Main.game.getDialogueFlags().setManagementCompanion(null);
                            }
                        };
                    }
                    if (index == 10) {
                        if (OccupantDialogue.hasJob()) {
                            return new Response("\u642c\u51fa\u53bb", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u544a\u8bc9[npc.name]\u4f60\u89c9\u5f97[npc.her]\u6700\u597d\u8fd8\u662f\u642c\u51fa\u53bb\u3002<br/>[style.italics(\u4f60\u53ef\u4ee5\u5728\u4e0b\u4e00\u4e2a\u573a\u666f\u4e2d\u4fdd\u7559\u6216\u79fb\u9664\u8fd9\u4e2a\u89d2\u8272\u3002)]", new ParserTag[0]), OCCUPANT_MOVE_OUT){

                                @Override
                                public void effects() {
                                    OccupantDialogue.applyReactionReset();
                                    Main.game.getDialogueFlags().setManagementCompanion(null);
                                }
                            };
                        }
                        if (confirmKickOut) {
                            return new Response("\u786e\u8ba4\u79fb\u9664", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u544a\u8bc9[npc.name]\u4f60\u60f3\u8ba9[npc.herHim]\u79bb\u5f00\u3002<br/>[style.italicsBad(\u4ece\u6e38\u620f\u4e2d\u6c38\u4e45\u5220\u9664\u8be5\u89d2\u8272\u3002)]", new ParserTag[0]), OCCUPANT_KICK_OUT){

                                @Override
                                public Colour getHighlightColour() {
                                    return PresetColour.GENERIC_NPC_REMOVAL;
                                }

                                @Override
                                public void effects() {
                                    OccupantDialogue.applyReactionReset();
                                    Main.game.getDialogueFlags().setManagementCompanion(null);
                                    Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_KICK_OUT", OccupantDialogue.occupant()));
                                    Main.game.getPlayer().removeFriendlyOccupant(OccupantDialogue.occupant());
                                    Main.game.banishNPC(OccupantDialogue.occupant());
                                }
                            };
                        }
                        return new ResponseEffectsOnly("\u8e22\u51fa", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u544a\u8bc9[npc.name]\u4f60\u60f3\u8ba9[npc.herHim]\u79bb\u5f00\u3002<br/>[style.italicsMinorBad(\u505a\u51fa\u9009\u62e9\u540e\uff0c\u4f60\u9700\u8981\u518d\u6b21\u70b9\u51fb\u4ee5\u786e\u8ba4\u4ece\u6e38\u620f\u4e2d\u6c38\u4e45\u5220\u9664\u8be5\u89d2\u8272\u3002)]", new ParserTag[0])){

                            @Override
                            public void effects() {
                                confirmKickOut = true;
                            }
                        };
                    }
                    if (index == 11) {
                        return new Response(OccupantDialogue.hasJob() ? "\u63d0\u8bae\u8df3\u69fd" : "\u4ecb\u7ecd\u5de5\u4f5c", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), (String)(OccupantDialogue.hasJob() ? "\u544a\u8bc9[npc.name][npc.her]\u73b0\u5728\u7684\u5de5\u4f5c" + UtilText.addDeterminer(occupant.getHistory().getName(OccupantDialogue.occupant())) + "\u4e0d\u9002\u5408[npc.herHim]\uff0c[npc.she]\u5e94\u8be5\u627e\u4e00\u4efd\u65b0\u5de5\u4f5c\u3002" : "\u544a\u8bc9[npc.name]\u4f60\u89c9\u5f97[npc.she]\u9002\u5408\u53bb\u627e\u4ec0\u4e48\u5de5\u4f5c\u3002"), new ParserTag[0]), OCCUPANT_JOB_SUGGESTION){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                            }
                        };
                    }
                    if (index == 12 && OccupantDialogue.occupant().hasJob()) {
                        return new Response("[style.colourBad(\u8f9e\u804c)]", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u8ba9[npc.name]\u8f9e\u53bb[npc.her][npc.a_job]\u5de5\u4f5c\uff0c\u5e76\u8ba9[npc.herHim]\u5728\u4f60\u60f3\u5230\u5176\u4ed6\u4e3b\u610f\u524d\u5f85\u4e1a\u3002", new ParserTag[0]), OCCUPANT_JOB_QUIT){

                            @Override
                            public void effects() {
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_JOB_QUIT", OccupantDialogue.occupant()));
                                OccupantDialogue.occupant().setHistory(Occupation.NPC_UNEMPLOYED);
                                OccupantDialogue.occupant().clearDesiredJobs();
                            }
                        };
                    }
                    if (index == 0) {
                        return new Response("\u79bb\u5f00", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u544a\u8bc9[npc.name]\u4f60\u4f1a\u6362\u4e2a\u65f6\u95f4\u627e[npc.herHim]\u3002", new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                            @Override
                            public void effects() {
                                Main.game.setResponseTab(0);
                                OccupantDialogue.applyReactionReset();
                                Main.game.getDialogueFlags().setManagementCompanion(null);
                            }
                        };
                    }
                    return null;
                }
                if (responseTab == 1) {
                    if (index == 1) {
                        if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                            return new Response("\u505a\u7231", UtilText.parse(characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\u2026\u2026", new ParserTag[0]), null);
                        }
                        return new ResponseSex("\u505a\u7231", UtilText.parse(characterForSex, "\u548c[npc.name]\u505a\u7231\u3002", new ParserTag[0]), true, true, new SMGeneric(Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(characterForSex), Main.game.getPlayer().getCompanions(), null, new ResponseTag[0]){

                            @Override
                            public boolean isPublicSex() {
                                return OccupantDialogue.isCompanionSexPublic();
                            }
                        }, OccupantDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "SEX_START", characterForSex)){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                                Main.game.getTextEndStringBuilder().append(characterForSex.incrementAffection(Main.game.getPlayer(), 5.0f));
                            }
                        };
                    }
                    if (index == 2) {
                        if (characterForSexSecondary == null || charactersPresent.size() < 2) {
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", "\u5f97\u6709\u7b2c\u4e09\u4e2a\u4eba\u5728\u573a\uff0c\u4f60\u624d\u80fd\u5f00\u59cb\u201c\u4e32\u8089\u4e32\u201d\u2026\u2026", null);
                        }
                        if (characterForSex.isPlayer()) {
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", "\u4f60\u4e0d\u80fd\u4ee5\u81ea\u5df1\u4e3a\u76ee\u6807\u5e94\u7528\u8fd9\u4e2a\u52a8\u4f5c\uff01", null);
                        }
                        if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                            if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.name]\u548c[npc2.name]\u90fd\u5bf9\u4f60\u4e0d\u611f\u5174\u8da3\u2026\u2026", new ParserTag[0]), null);
                            }
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse(characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c\u4e0d\u613f\u610f\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c[npc.she]\u548c[npc2.name]\u90fd\u4e0d\u60f3\u548c\u4f60\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (!characterForSexSecondary.isAttractedTo(characterForSex)) {
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u6ca1\u88ab[npc2.name]\u5438\u5f15\uff0c\u4ed6\u4eec\u4e0d\u60f3\u5f7c\u6b64\u63a5\u89e6\uff0c\u6240\u4ee5\u90fd\u4e0d\u4f1a\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (!characterForSex.isAttractedTo(characterForSexSecondary)) {
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc2.name]\u6ca1\u88ab[npc2.name]\u5438\u5f15\uff0c\u4ed6\u4eec\u4e0d\u60f3\u5f7c\u6b64\u63a5\u89e6\uff0c\u6240\u4ee5\u90fd\u4e0d\u4f1a\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        return new ResponseSex("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse(characterForSex, characterForSexSecondary, "\u79fb\u52a8\u5230[npc.name]\u524d\u9762\uff0c[npc2.name]\u73a9\u5f04[npc.her]\u540e\u9762\u7684\u65f6\u5019\uff0c\u4f60\u53ef\u4ee5\u4f7f\u7528[npc.her]\u7684\u5634\u3002", new ParserTag[0]), null, null, null, null, null, null, true, true, new SMGeneric(Util.newArrayListOfValues(characterForSexSecondary, Main.game.getPlayer()), Util.newArrayListOfValues(characterForSex), null, null, new ResponseTag[]{ResponseTag.PREFER_DOGGY}){

                            @Override
                            public boolean isPublicSex() {
                                return OccupantDialogue.isCompanionSexPublic();
                            }
                        }, OccupantDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(OccupantDialogue.getThreesomeTextFilePath(), "SEX_SPITROAST_FRONT_START", characterForSex, characterForSexSecondary)){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                            }
                        };
                    }
                    if (index == 3) {
                        if (characterForSexSecondary == null || charactersPresent.size() < 2) {
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", "\u5f97\u6709\u7b2c\u4e09\u4e2a\u4eba\u5728\u573a\uff0c\u4f60\u624d\u80fd\u5f00\u59cb\u201c\u4e32\u8089\u4e32\u201d\u2026\u2026", null);
                        }
                        if (characterForSex.isPlayer()) {
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", "\u4f60\u4e0d\u80fd\u4ee5\u81ea\u5df1\u4e3a\u76ee\u6807\u5e94\u7528\u8fd9\u4e2a\u52a8\u4f5c\uff01", null);
                        }
                        if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                            if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.name]\u548c[npc2.name]\u90fd\u6ca1\u88ab\u4f60\u5438\u5f15\u2026\u2026", new ParserTag[0]), null);
                            }
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse(characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c\u4e0d\u613f\u610f\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c[npc.she]\u548c[npc2.name]\u90fd\u4e0d\u60f3\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (!characterForSexSecondary.isAttractedTo(characterForSex)) {
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u6ca1\u88ab[npc2.name]\u5438\u5f15\uff0c\u4ed6\u4eec\u4e0d\u60f3\u5f7c\u6b64\u63a5\u89e6\uff0c\u6240\u4ee5\u90fd\u4e0d\u4f1a\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (!characterForSex.isAttractedTo(characterForSexSecondary)) {
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc2.name]\u6ca1\u88ab[npc2.name]\u5438\u5f15\uff0c\u4ed6\u4eec\u4e0d\u60f3\u5f7c\u6b64\u63a5\u89e6\uff0c\u6240\u4ee5\u90fd\u4e0d\u4f1a\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        return new ResponseSex("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse(characterForSex, characterForSexSecondary, "\u79fb\u52a8\u5230[npc.name]\u80cc\u540e\uff0c[npc2.name]\u4f7f\u7528[npc.her]\u7684\u5634\u7684\u65f6\u5019\uff0c\u4f60\u53ef\u4ee5\u73a9\u5f04[npc.her]\u7684\u540e\u9762\u3002", new ParserTag[0]), null, null, null, null, null, null, true, true, new SMGeneric(Util.newArrayListOfValues(Main.game.getPlayer(), characterForSexSecondary), Util.newArrayListOfValues(characterForSex), null, null, new ResponseTag[]{ResponseTag.PREFER_DOGGY}){

                            @Override
                            public boolean isPublicSex() {
                                return OccupantDialogue.isCompanionSexPublic();
                            }
                        }, OccupantDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(OccupantDialogue.getThreesomeTextFilePath(), "SEX_SPITROAST_BEHIND_START", characterForSex, characterForSexSecondary)){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                            }
                        };
                    }
                    if (index == 4) {
                        if (characterForSexSecondary == null || charactersPresent.size() < 2) {
                            return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u652f\u914d\u65b9)", "\u5f97\u6709\u7b2c\u4e09\u4e2a\u4eba\u5728\u573a\uff0c\u4f60\u624d\u80fd\u5f00\u59cb\u5e76\u6392\u540e\u5165\u2026\u2026", null);
                        }
                        if (characterForSex.isPlayer()) {
                            return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u652f\u914d\u65b9)", "\u4f60\u4e0d\u80fd\u4ee5\u81ea\u5df1\u4e3a\u76ee\u6807\u5e94\u7528\u8fd9\u4e2a\u52a8\u4f5c\uff01", null);
                        }
                        if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                            if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u5728\u4e0a)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.name]\u548c[npc2.name]\u90fd\u6ca1\u88ab\u4f60\u5438\u5f15\u2026\u2026", new ParserTag[0]), null);
                            }
                            return new Response("\u5e76\u6392\u540e\u5165(\u5728\u4e0a)", UtilText.parse(characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c\u4e0d\u60f3\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                            return new Response("\u5e76\u6392\u540e\u5165(\u5728\u4e0a)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c[npc.she]\u548c[npc2.name]\u90fd\u4e0d\u60f3\u8ddf\u4f60\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        return new ResponseSex("\u5e76\u6392\u540e\u5165(\u5728\u4e0a)", UtilText.parse(characterForSex, characterForSexSecondary, "\u8ba9[npc.name]\u548c[npc2.name]\u56db\u4f53\u6295\u5730\uff0c\u8dea\u5728[npc.Name]\u8eab\u540e\uff0c\u51c6\u5907\u5e76\u6392\u540e\u5165\u4ed6\u4eec\u3002", new ParserTag[0]), null, null, null, null, null, null, true, false, new SMGeneric(Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(characterForSex, characterForSexSecondary), null, null, new ResponseTag[]{ResponseTag.PREFER_DOGGY}){

                            @Override
                            public boolean isPublicSex() {
                                return OccupantDialogue.isCompanionSexPublic();
                            }
                        }, OccupantDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(OccupantDialogue.getThreesomeTextFilePath(), "SEX_SIDE_BY_SIDE_START", characterForSex, characterForSexSecondary)){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                            }
                        };
                    }
                    if (index == 6) {
                        if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                            return new Response("\u670d\u4ece\u578b\u6027\u7231", UtilText.parse(characterForSex, "[npc.Name]\u4e0d\u662f\u5f88\u60f3\u548c\u4f60\u505a\u7231\uff0c\u56e0\u6b64\u4f60\u9700\u8981\u505a\u652f\u914d\u65b9\u2026\u2026", new ParserTag[0]), null);
                        }
                        return new ResponseSex("\u670d\u4ece\u6027\u7231", UtilText.parse(characterForSex, "\u548c[npc.name]\u6765\u4e00\u573a\u670d\u4ece\u578b\u6027\u7231\u3002", new ParserTag[0]), Util.newArrayListOfValues(Fetish.FETISH_SUBMISSIVE), null, Fetish.FETISH_SUBMISSIVE.getAssociatedCorruptionLevel(), null, null, null, true, true, new SMGeneric(Util.newArrayListOfValues(characterForSex), Util.newArrayListOfValues(Main.game.getPlayer()), null, Main.game.getPlayer().getCompanions(), new ResponseTag[0]){

                            @Override
                            public boolean isPublicSex() {
                                return OccupantDialogue.isCompanionSexPublic();
                            }
                        }, OccupantDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "SEX_AS_SUB_START", characterForSex)){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                                Main.game.getTextEndStringBuilder().append(characterForSex.incrementAffection(Main.game.getPlayer(), 5.0f));
                            }
                        };
                    }
                    if (index == 7) {
                        if (characterForSexSecondary == null || charactersPresent.size() < 2) {
                            return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", "\u5f97\u6709\u7b2c\u4e09\u4e2a\u4eba\u5728\u573a\uff0c\u4f60\u624d\u80fd\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d\u2026\u2026", null);
                        }
                        if (characterForSex.isPlayer()) {
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", "\u4f60\u4e0d\u80fd\u4ee5\u81ea\u5df1\u4e3a\u76ee\u6807\u5e94\u7528\u8fd9\u4e2a\u52a8\u4f5c\uff01", null);
                        }
                        if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                            if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.name]\u548c[npc2.name]\u90fd\u5bf9\u4f60\u4e0d\u611f\u5174\u8da3\u2026\u2026", new ParserTag[0]), null);
                            }
                            return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse(characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c\u4e0d\u613f\u610f\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                            return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c[npc.she]\u548c[npc2.name]\u90fd\u4e0d\u60f3\u548c\u4f60\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        return new ResponseSex("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse(characterForSex, characterForSexSecondary, "\u4f60\u56db\u80a2\u7740\u5730\uff0c\u9762\u671d[npc.name]\uff0c[npc2.name]\u73a9\u5f04\u4f60\u7684\u540e\u9762\u7684\u65f6\u5019\uff0c[npc.she]\u5c31\u53ef\u4ee5\u4f7f\u7528\u4f60\u7684\u5634\u4e86\u3002", new ParserTag[0]), null, null, null, null, null, null, true, true, new SMGeneric(Util.newArrayListOfValues(characterForSexSecondary, characterForSex), Util.newArrayListOfValues(Main.game.getPlayer()), null, null, new ResponseTag[]{ResponseTag.PREFER_DOGGY}){

                            @Override
                            public boolean isPublicSex() {
                                return OccupantDialogue.isCompanionSexPublic();
                            }
                        }, OccupantDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(OccupantDialogue.getThreesomeTextFilePath(), "SEX_SPITROASTED_START", characterForSex, characterForSexSecondary)){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                            }
                        };
                    }
                    if (index == 8) {
                        if (characterForSexSecondary == null || charactersPresent.size() < 2) {
                            return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", "\u5f97\u6709\u7b2c\u4e09\u4e2a\u4eba\u5728\u573a\uff0c\u4f60\u624d\u80fd\u5f00\u59cb\u201c\u4e32\u8089\u4e32\u201d\u2026\u2026", null);
                        }
                        if (characterForSex.isPlayer()) {
                            return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", "\u4f60\u4e0d\u80fd\u4ee5\u81ea\u5df1\u4e3a\u76ee\u6807\u5e94\u7528\u8fd9\u4e2a\u52a8\u4f5c\uff01", null);
                        }
                        if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                            if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.name]\u548c[npc2.name]\u90fd\u6ca1\u88ab\u4f60\u5438\u5f15\u2026\u2026", new ParserTag[0]), null);
                            }
                            return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse(characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c\u4e0d\u613f\u610f\u548c\u4f60\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                            return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c[npc.she]\u548c[npc2.name]\u90fd\u4e0d\u613f\u610f\u548c\u4f60\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        return new ResponseSex("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse(characterForSex, characterForSexSecondary, "\u4f60\u56db\u80a2\u8dea\u5730\uff0c\u5c06\u8eab\u540e\u5c55\u73b0\u7ed9[npc.name]\uff0c\u8fd9\u6837\u5728[npc.she]\u5e72\u4f60\u7684\u65f6\u5019[npc2.name]\u53ef\u4ee5\u540c\u65f6\u4f7f\u7528\u4f60\u7684\u5634\u5df4\u3002", new ParserTag[0]), null, null, null, null, null, null, true, true, new SMGeneric(Util.newArrayListOfValues(characterForSex, characterForSexSecondary), Util.newArrayListOfValues(Main.game.getPlayer()), null, null, new ResponseTag[]{ResponseTag.PREFER_DOGGY}){

                            @Override
                            public boolean isPublicSex() {
                                return OccupantDialogue.isCompanionSexPublic();
                            }
                        }, OccupantDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(OccupantDialogue.getThreesomeTextFilePath(), "SEX_SPITROASTED_START", characterForSexSecondary, characterForSex)){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                            }
                        };
                    }
                    if (index == 9) {
                        if (characterForSexSecondary == null || charactersPresent.size() < 2) {
                            return new Response("\u5e76\u6392\u540e\u5165(\u5728\u4e0b)", UtilText.parse(characterForSex, "\u4f60\u9700\u8981\u7b2c\u4e09\u4e2a\u4eba\u5728\u573a\uff0c\u624d\u80fd\u88ab\u4ed6\u4eec\u6216\u8005[npc.name]\u64cd\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (characterForSex.isPlayer()) {
                            return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u670d\u4ece\u65b9)", "\u4f60\u4e0d\u80fd\u4ee5\u81ea\u5df1\u4e3a\u76ee\u6807\u5e94\u7528\u8fd9\u4e2a\u52a8\u4f5c\uff01", null);
                        }
                        if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                            if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u5728\u4e0b)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.name]\u548c[npc2.name]\u90fd\u6ca1\u88ab\u4f60\u5438\u5f15\u2026\u2026", new ParserTag[0]), null);
                            }
                            return new Response("\u5e76\u6392\u540e\u5165(\u5728\u4e0b)", UtilText.parse(characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c\u4e0d\u60f3\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                            return new Response("\u5e76\u6392\u540e\u5165(\u5728\u4e0b)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c[npc.she]\u548c[npc2.name]\u90fd\u4e0d\u613f\u610f\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (!characterForSexSecondary.isAttractedTo(characterForSex)) {
                            return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u670d\u4ece\u65b9)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u6ca1\u88ab[npc2.name]\u5438\u5f15\uff0c\u4ed6\u4eec\u4e0d\u60f3\u5f7c\u6b64\u63a5\u89e6\uff0c\u6240\u4ee5\u90fd\u4e0d\u4f1a\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (!characterForSex.isAttractedTo(characterForSexSecondary)) {
                            return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u670d\u4ece\u65b9)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc2.name]\u6ca1\u88ab[npc2.name]\u5438\u5f15\uff0c\u4ed6\u4eec\u4e0d\u60f3\u5f7c\u6b64\u63a5\u89e6\uff0c\u6240\u4ee5\u90fd\u4e0d\u4f1a\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                        }
                        return new ResponseSex("\u5e76\u6392\u540e\u5165(\u5728\u4e0b)", UtilText.parse(characterForSex, characterForSexSecondary, "\u5728[npc2.name]\u8eab\u8fb9\u56db\u80a2\u8dea\u5730\uff0c\u8fd9\u6837[npc.name]\u5c31\u53ef\u4ee5\u8dea\u5728\u4f60\u4eec\u8eab\u540e\uff0c\u8ddf\u6328\u5728\u4e00\u8d77\u7684\u4f60\u4eec\u4e24\u4e2a\u505a\u7231\u4e86\u3002", new ParserTag[0]), null, null, null, null, null, null, true, false, new SMGeneric(Util.newArrayListOfValues(characterForSex), Util.newArrayListOfValues(Main.game.getPlayer(), characterForSexSecondary), null, null, new ResponseTag[]{ResponseTag.PREFER_DOGGY}){

                            @Override
                            public boolean isPublicSex() {
                                return OccupantDialogue.isCompanionSexPublic();
                            }
                        }, OccupantDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(OccupantDialogue.getThreesomeTextFilePath(), "SEX_SIDE_BY_SIDE_AS_SUB_START", characterForSex, characterForSexSecondary)){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                            }
                        };
                    }
                    if (index == 11) {
                        if (characterForSexSecondary != null) {
                            return new ResponseEffectsOnly(UtilText.parse(characterForSex, "\u76ee\u6807\uff1a<b style='color:" + characterForSex.getFemininity().getColour().toWebHexString() + ";'>[npc.Name]</b>", new ParserTag[0]), "\u5faa\u73af\u5207\u6362\u9009\u62e9\u7fa4\u4ea4\u89d2\u8272\u3002"){

                                @Override
                                public void effects() {
                                    if (charactersPresent.size() > 1) {
                                        for (int i = 0; i < charactersPresent.size(); ++i) {
                                            if (!charactersPresent.get(i).equals(characterForSex)) continue;
                                            if (i == charactersPresent.size() - 1) {
                                                characterForSex = charactersPresent.get(0);
                                                if (!characterForSexSecondary.equals(characterForSex)) continue;
                                                characterForSexSecondary = charactersPresent.get(1);
                                                continue;
                                            }
                                            characterForSex = charactersPresent.get(i + 1);
                                            if (!characterForSexSecondary.equals(characterForSex)) break;
                                            characterForSexSecondary = charactersPresent.get(i + 2 < charactersPresent.size() ? i + 2 : 0);
                                            break;
                                        }
                                    }
                                    Main.game.updateResponses();
                                }
                            };
                        }
                        return new Response(UtilText.parse(characterForSex, "\u76ee\u6807\uff1a<b>[npc.Name]</b>", new ParserTag[0]), "\u5faa\u73af\u5207\u6362\u9009\u62e9\u7fa4\u4ea4\u76ee\u6807\u89d2\u8272\u3002<br/>[style.italicsBad(\u82e5\u8981\u89e3\u9501\u8be5\u52a8\u4f5c\uff0c\u9700\u8981\u5e26\u7740\u4e00\u540d\u540c\u4f34\uff01)]", null);
                    }
                    if (index == 12) {
                        if (characterForSexSecondary != null) {
                            return new ResponseEffectsOnly(UtilText.parse((GameCharacter)characterForSexSecondary, "\u6b21\u76ee\u6807\uff1a<b style='color:" + characterForSexSecondary.getFemininity().getColour().toWebHexString() + ";'>[npc.Name]</b>", new ParserTag[0]), "\u5faa\u73af\u5207\u6362\u9009\u62e9\u7fa4\u4ea4\u6b21\u76ee\u6807\u89d2\u8272\u3002"){

                                @Override
                                public void effects() {
                                    if (charactersPresent.size() > 1) {
                                        for (int i = 0; i < charactersPresent.size(); ++i) {
                                            if (!charactersPresent.get(i).equals(characterForSexSecondary)) continue;
                                            if (i == charactersPresent.size() - 1) {
                                                characterForSexSecondary = charactersPresent.get(0);
                                                if (!characterForSexSecondary.equals(characterForSex)) break;
                                                characterForSex = charactersPresent.get(1);
                                                break;
                                            }
                                            characterForSexSecondary = charactersPresent.get(i + 1);
                                            if (!characterForSexSecondary.equals(characterForSex)) break;
                                            characterForSex = charactersPresent.get(i + 2 < charactersPresent.size() ? i + 2 : 0);
                                            break;
                                        }
                                    }
                                    Main.game.updateResponses();
                                }
                            };
                        }
                        return new Response(UtilText.parse(characterForSex, "\u6b21\u76ee\u6807\uff1a<b>[npc.Name]</b>", new ParserTag[0]), "\u5faa\u73af\u5207\u6362\u9009\u62e9\u7fa4\u4ea4\u6b21\u76ee\u6807\u89d2\u8272\u3002<br/>[style.italicsBad(\u82e5\u8981\u89e3\u9501\u8be5\u52a8\u4f5c\uff0c\u9700\u8981\u5e26\u7740\u4e00\u540d\u540c\u4f34\uff01)]", null);
                    }
                    if (index == 0) {
                        return new Response("\u79bb\u5f00", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u544a\u8bc9[npc.name]\u4f60\u4f1a\u6362\u4e2a\u65f6\u95f4\u627e[npc.herHim]\u3002", new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                            @Override
                            public void effects() {
                                Main.game.setResponseTab(0);
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "LEAVING", OccupantDialogue.occupant()));
                                OccupantDialogue.applyReactionReset();
                                Main.game.getDialogueFlags().setManagementCompanion(null);
                            }
                        };
                    }
                    return null;
                }
                if (responseTab == 2) {
                    return CompanionManagement.getManagementResponses(index);
                }
                return null;
            }
        };
        OCCUPANT_TALK_LIFE = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4e0e[npc.Name]\u4ea4\u8c08", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_TALK_LIFE", OccupantDialogue.occupant()));
                UtilText.nodeContentSB.append(OccupantDialogue.occupant().getPlayerRelationStatusDescription());
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return OCCUPANT_START.getResponse(responseTab, index);
            }
        };
        OCCUPANT_TALK_JOB = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4e0e[npc.Name]\u4ea4\u8c08", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (OccupantDialogue.hasJob()) {
                    UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_TALK_JOB", OccupantDialogue.occupant()));
                } else {
                    UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_TALK_JOB_HUNTING", OccupantDialogue.occupant()));
                }
                UtilText.nodeContentSB.append(OccupantDialogue.occupant().getPlayerRelationStatusDescription());
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return OCCUPANT_START.getResponse(responseTab, index);
            }
        };
        OCCUPANT_TALK_LILAYA = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4e0e[npc.Name]\u4ea4\u8c08", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_TALK_LILAYA", OccupantDialogue.occupant()));
                UtilText.nodeContentSB.append(OccupantDialogue.occupant().getPlayerRelationStatusDescription());
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return OCCUPANT_START.getResponse(responseTab, index);
            }
        };
        OCCUPANT_TALK_SLAVES = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4e0e[npc.Name]\u4ea4\u8c08", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                String id = Util.randomItemFrom(Main.game.getPlayer().getSlavesOwned());
                try {
                    NPC slave = (NPC)Main.game.getNPCById(id);
                    UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_TALK_SLAVES", OccupantDialogue.occupant(), slave));
                }
                catch (Exception e) {
                    Util.logGetNpcByIdError("OCCUPANT_TALK_SLAVES.getContent()", id);
                    UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_TALK_SLAVES_NULL_SLAVE", OccupantDialogue.occupant()));
                }
                UtilText.nodeContentSB.append(OccupantDialogue.occupant().getPlayerRelationStatusDescription());
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return OCCUPANT_START.getResponse(responseTab, index);
            }
        };
        OCCUPANT_HUG = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 300;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u62e5\u62b1[npc.Name]", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_HUG", OccupantDialogue.occupant()));
                UtilText.nodeContentSB.append(OccupantDialogue.occupant().getPlayerRelationStatusDescription());
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return OCCUPANT_START.getResponse(responseTab, index);
            }
        };
        OCCUPANT_PETTINGS = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u7231\u629a[npc.Name]", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_PETTINGS", OccupantDialogue.occupant()));
                UtilText.nodeContentSB.append(OccupantDialogue.occupant().getPlayerRelationStatusDescription());
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return OCCUPANT_START.getResponse(responseTab, index);
            }
        };
        OCCUPANT_JOB_SUGGESTION = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 120;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4e0e[npc.Name]\u4ea4\u8c08", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (OccupantDialogue.hasJob()) {
                    UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_JOB_SUGGESTION_CHANGE", OccupantDialogue.occupant()));
                } else {
                    UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_JOB_SUGGESTION", OccupantDialogue.occupant()));
                }
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_JOB_SUGGESTION_MECHANICS", OccupantDialogue.occupant()));
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                final ArrayList<Occupation> availableOccuaptions = new ArrayList<Occupation>();
                for (Occupation occ : Occupation.values()) {
                    if (occ.isAvailableToPlayer() || !occ.isAvailable(OccupantDialogue.occupant()) || occ == Occupation.NPC_UNEMPLOYED || occ.isLowlife()) continue;
                    availableOccuaptions.add(occ);
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u8fd8\u662f\u4e0d\u544a\u8bc9[npc.name]\u4f60\u89c9\u5f97[npc.she]\u5e94\u8be5\u627e\u4efd\u4ec0\u4e48\u5de5\u4f5c\u4e86\u3002", new ParserTag[0]), isApartment ? OCCUPANT_APARTMENT : OCCUPANT_START);
                }
                if (index == 1) {
                    return new Response("[style.colourGood(\u5168\u9009)]", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u9009\u62e9\u6240\u6709\u7c7b\u578b\u7684\u5de5\u4f5c\uff0c\u8ba9[npc.name]\u90fd\u53ef\u4ee5\u53bb\u627e\u3002", new ParserTag[0]), OCCUPANT_JOB_SUGGESTION){

                        @Override
                        public void effects() {
                            for (Occupation occ : availableOccuaptions) {
                                OccupantDialogue.occupant().addDesiredJob(occ);
                            }
                        }
                    };
                }
                if (index == 2) {
                    return new Response("[style.colourBad(\u4e0d\u505a\u9009\u62e9)]", OccupantDialogue.occupant().hasJob() ? UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4e0d\u4e3a[npc.name]\u9009\u62e9\u8981\u627e\u7684\u5de5\u4f5c\uff0c\u8fd9\u4f1a\u8ba9[npc.herHim]\u4ecd\u7136\u505a\u4e00\u4e2a[npc.a_job]\u3002", new ParserTag[0]) : UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4e0d\u4e3a[npc.name]\u9009\u62e9\u8981\u627e\u7684\u5de5\u4f5c\uff0c\u8fd9\u4f1a\u8ba9[npc.herHim]\u7ee7\u7eed\u5931\u4e1a\u3002", new ParserTag[0]), OCCUPANT_JOB_SUGGESTION){

                        @Override
                        public void effects() {
                            OccupantDialogue.occupant().clearDesiredJobs();
                        }
                    };
                }
                if (index - 3 < availableOccuaptions.size()) {
                    final Occupation job = (Occupation)((Object)availableOccuaptions.get(index - 3));
                    String jobName = job.getName(OccupantDialogue.occupant());
                    if (OccupantDialogue.occupant().getHistory().equals((Object)job)) {
                        return new Response(Util.capitaliseSentence(jobName), UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "[npc.Name]\u5df2\u7ecf\u662f\u4e2a" + jobName + "\u4e86\u3002", new ParserTag[0]), null);
                    }
                    if (OccupantDialogue.occupant().getDesiredJobs().contains((Object)job)) {
                        return new Response(Util.capitaliseSentence(jobName), UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u544a\u8bc9[npc.name]\u4e0d\u8981\u518d\u627e" + jobName + "\u7684\u5de5\u4f5c\u4e86\u3002", new ParserTag[0]), OCCUPANT_JOB_SUGGESTION){

                            @Override
                            public Colour getHighlightColour() {
                                return PresetColour.GENERIC_MINOR_GOOD;
                            }

                            @Override
                            public void effects() {
                                OccupantDialogue.occupant().removeDesiredJob(job);
                            }
                        };
                    }
                    return new Response(Util.capitaliseSentence(jobName), UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u544a\u8bc9[npc.name][npc.she]\u5e94\u8be5\u627e\u4e2a" + jobName + "\u7684\u5de5\u4f5c\u3002", new ParserTag[0]), OCCUPANT_JOB_SUGGESTION){

                        @Override
                        public void effects() {
                            OccupantDialogue.occupant().addDesiredJob(job);
                        }
                    };
                }
                return null;
            }
        };
        OCCUPANT_JOB_QUIT = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 120;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4e0e[npc.Name]\u4ea4\u8c08", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return OCCUPANT_START.getResponse(responseTab, index);
            }
        };
        AFTER_SEX = new DialogueNode("\u7ed3\u675f", "", true){

            @Override
            public String getDescription() {
                return "\u8eba\u5728[npc.namePos]\u7684\u6c99\u53d1\u4e0a\uff0c\u7f13\u4e00\u53e3\u6c14\u3002";
            }

            @Override
            public String getContent() {
                if (Main.sex.getAllParticipants().size() > 2) {
                    return UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "AFTER_SEX_THREESOME", OccupantDialogue.occupant(), characterForSexSecondary);
                }
                if (Main.sex.getNumberOfOrgasms(OccupantDialogue.occupant()) >= OccupantDialogue.occupant().getOrgasmsBeforeSatisfied()) {
                    return UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "AFTER_SEX", OccupantDialogue.occupant());
                }
                return UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "AFTER_SEX_NO_ORGASM", OccupantDialogue.occupant());
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u79bb\u5f00", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), (String)(OccupantDialogue.occupant().isAsleep() ? "\u8ba9[npc.name]\u7ee7\u7eed\u7761\u89c9\uff0c\u79bb\u5f00[npc.her]\u7684" + (isApartment ? "\u516c\u5bd3" : "\u623f\u95f4") + "." : "\u7ed9[npc.name]\u4e00\u4e9b\u65f6\u95f4\u4f11\u606f"), new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "LEAVE_AFTER_SEX", OccupantDialogue.occupant()));
                        }
                    };
                }
                return null;
            }
        };
        OCCUPANT_KICK_OUT = new DialogueNode("\u9010\u5ba2", "", false){

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return Main.game.getDefaultDialogue(false).getResponse(responseTab, index);
            }
        };
        OCCUPANT_MOVE_OUT = new DialogueNode("\u642c\u51fa", "", true){

            @Override
            public int getSecondsPassed() {
                return 900;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_MOVE_OUT", OccupantDialogue.occupant());
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u62dc\u8bbf\u516c\u5bd3", "\u544a\u8bc9[npc.name]\u4f60\u60f3\u770b\u770b[npc.her]\u7684\u65b0\u516c\u5bd3\uff0c\u5e76\u4e14\u8ddf\u7740[npc.herHim]\u524d\u5f80\u3002<br/>[style.italicsGood(\u4fdd\u5b58\u8be5\u89d2\u8272\uff0c\u5c06\u5176\u79fb\u52a8\u81f3\u5fa1\u57ce\u533a\u4efb\u610f\u8857\u9053\u6216\u4e3b\u5e72\u9053\u533a\u5757\u3002)]", OCCUPANT_MOVE_OUT_APARTMENT){

                        @Override
                        public void effects() {
                            OccupantDialogue.occupant().setRandomUnoccupiedLocation(WorldType.DOMINION, true, PlaceType.DOMINION_STREET, PlaceType.DOMINION_STREET_HARPY_NESTS, PlaceType.DOMINION_BOULEVARD);
                            OccupantDialogue.occupant().setHomeLocation();
                            isApartment = true;
                            Main.game.getDialogueFlags().setManagementCompanion(OccupantDialogue.occupant());
                            Main.game.getPlayer().setLocation(OccupantDialogue.occupant().getWorldLocation(), OccupantDialogue.occupant().getLocation(), false);
                        }
                    };
                }
                if (index == 10) {
                    if (confirmKickOut) {
                        return new Response("\u786e\u8ba4\u79fb\u9664", "\u544a\u8bc9[npc.name][npc.she]\u5e94\u5f53\u7ee7\u7eed\u81ea\u5df1\u7684\u65b0\u751f\u6d3b\u3002<br/>[style.italicsBad(\u4ece\u6e38\u620f\u4e2d\u6c38\u4e45\u5220\u9664\u8be5\u89d2\u8272\u3002)]", OCCUPANT_KICK_OUT){

                            @Override
                            public Colour getHighlightColour() {
                                return PresetColour.GENERIC_NPC_REMOVAL;
                            }

                            @Override
                            public void effects() {
                                Main.game.getDialogueFlags().setManagementCompanion(null);
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_MOVE_OUT_REMOVE_CHARACTER", OccupantDialogue.occupant()));
                                Main.game.getPlayer().removeFriendlyOccupant(OccupantDialogue.occupant());
                                Main.game.banishNPC(OccupantDialogue.occupant());
                                confirmKickOut = false;
                            }
                        };
                    }
                    return new ResponseEffectsOnly("\u79fb\u9664\u89d2\u8272", "\u544a\u8bc9[npc.name][npc.she]\u5e94\u5f53\u7ee7\u7eed\u81ea\u5df1\u7684\u65b0\u751f\u6d3b\u3002<br/>[style.italicsMinorBad(\u9009\u62e9\u8be5\u884c\u52a8\u540e\uff0c\u4f60\u9700\u8981\u518d\u6b21\u786e\u8ba4\u4ee5\u5c06\u8be5\u89d2\u8272\u6c38\u4e45\u79fb\u51fa\u6e38\u620f\u3002(\u4e0d\u53ef\u64a4\u9500\uff01))]"){

                        @Override
                        public void effects() {
                            confirmKickOut = true;
                        }
                    };
                }
                return null;
            }
        };
        OCCUPANT_MOVE_OUT_APARTMENT = new DialogueNode("\u642c\u51fa", "", true, true){

            @Override
            public int getSecondsPassed() {
                return 3600;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "[npc.NamePos]\u7684\u516c\u5bd3", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_MOVE_OUT_APARTMENT", OccupantDialogue.occupant());
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_APARTMENT.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return OCCUPANT_APARTMENT.getResponse(responseTab, index);
            }
        };
        OCCUPANT_APARTMENT_NO_CONTENT = new DialogueNode("", "", true){

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "[npc.NamePos]\u7684\u516c\u5bd3", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_APARTMENT.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return OCCUPANT_APARTMENT.getResponse(responseTab, index);
            }
        };
        OCCUPANT_APARTMENT = new DialogueNode("\u642c\u51fa", "", true){

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "[npc.NamePos]\u7684\u516c\u5bd3", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(OccupantDialogue.getOccupantApartmentCoreContent());
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                if (OccupantDialogue.occupant().isAtHome()) {
                    if (index == 0) {
                        return "\u4e92\u52a8";
                    }
                    if (index == 1) {
                        return UtilText.parse("[style.colourSex(\u505a\u7231)]", new ParserTag[0]);
                    }
                    if (index == 2) {
                        return UtilText.parse("[style.colourCompanion(\u7ba1\u7406)]", new ParserTag[0]);
                    }
                }
                return null;
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (!OccupantDialogue.occupant().isAtHome()) {
                    if (index == 1) {
                        return new Response("\u79bb\u5f00", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "[npc.name]\u73b0\u5728\u4e0d\u5728\u5bb6\uff0c\u4f60\u65e0\u4e8b\u53ef\u505a\uff0c\u53ea\u80fd\u8fd4\u56de\u5fa1\u57ce\u533a\u3002", new ParserTag[0]), Main.game.getDefaultDialogue(false));
                    }
                    return null;
                }
                if (OccupantDialogue.occupant().isAsleep()) {
                    if (index == 1) {
                        return new Response(UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u53eb\u9192[npc.herHim]", new ParserTag[0]), UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u628a[npc.name]\u53eb\u9192\uff0c\u8fd9\u6837\u4f60\u5c31\u53ef\u4ee5\u548c[npc.herHim]\u8fdb\u884c\u4e92\u52a8\u3002<br/>[style.italicsMinorBad(\u8981\u662f\u628a[npc.She]\u5435\u9192\u4e86\uff0c[npc.herHim]\u80af\u5b9a\u4f1a\u5f88\u751f\u6c14\u7684\u2026\u2026)]", new ParserTag[0]), OCCUPANT_APARTMENT_NO_CONTENT){

                            @Override
                            public void effects() {
                                Main.game.appendToTextEndStringBuilder(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_ENTRY", OccupantDialogue.occupant()));
                                OccupantDialogue.occupant().wakeUp();
                                Main.game.appendToTextEndStringBuilder(UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "<p style='text-align:center;'>[style.italicsMinorBad([npc.Name]\u4e0d\u60f3\u88ab\u53eb\u9192\u2026\u2026)]</p>", new ParserTag[0]));
                                Main.game.appendToTextEndStringBuilder(OccupantDialogue.occupant().incrementAffection(Main.game.getPlayer(), -1.0f));
                                Main.game.appendToTextEndStringBuilder(OccupantDialogue.getOccupantApartmentCoreContent());
                            }
                        };
                    }
                    if (index == 0) {
                        return new Response("\u79bb\u5f00", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u79bb\u5f00\uff0c\u8ba9[npc.name]\u597d\u597d\u4f11\u606f", new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                            @Override
                            public void effects() {
                                Main.game.setResponseTab(0);
                                OccupantDialogue.applyReactionReset();
                                Main.game.getDialogueFlags().setManagementCompanion(null);
                            }
                        };
                    }
                    return null;
                }
                if (responseTab == 0) {
                    if (index == 1) {
                        if (!OccupantDialogue.occupant().NPCFlagValues.contains((Object)NPCFlagValue.occupantTalkLife)) {
                            return new Response("\u751f\u6d3b", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u8be2\u95ee[npc.name]\u8fc7\u53bb\u7684\u751f\u6d3b\u3002", new ParserTag[0]), OCCUPANT_APARTMENT_TALK_LIFE){

                                @Override
                                public void effects() {
                                    OccupantDialogue.applyReactionReset();
                                    OccupantDialogue.occupant().NPCFlagValues.add(NPCFlagValue.occupantTalkLife);
                                    Main.game.getTextEndStringBuilder().append(OccupantDialogue.occupant().incrementAffection(Main.game.getPlayer(), 5.0f));
                                }
                            };
                        }
                        return new Response("\u751f\u6d3b", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4f60\u5df2\u7ecf\u95ee\u8fc7[npc.name]\u8fc7\u53bb\u7684\u751f\u6d3b\u4e86\u3002", new ParserTag[0]), null);
                    }
                    if (index == 2) {
                        if (!OccupantDialogue.occupant().NPCFlagValues.contains((Object)NPCFlagValue.occupantTalkJob)) {
                            return new Response("\u5de5\u4f5c", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u95ee\u95ee[npc.name][npc.her]\u7684\u5de5\u4f5c\u3002", new ParserTag[0]), OCCUPANT_APARTMENT_TALK_JOB){

                                @Override
                                public void effects() {
                                    OccupantDialogue.applyReactionReset();
                                    OccupantDialogue.occupant().NPCFlagValues.add(NPCFlagValue.occupantTalkJob);
                                    Main.game.getTextEndStringBuilder().append(OccupantDialogue.occupant().incrementAffection(Main.game.getPlayer(), 5.0f));
                                }
                            };
                        }
                        return new Response("\u5de5\u4f5c", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u95ee\u8fc7[npc.Name][npc.her]\u7684\u5de5\u4f5c\u4e86\u3002", new ParserTag[0]), null);
                    }
                    if (index == 3) {
                        return new Response("\u4f11\u606f", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u8be2\u95ee[npc.name]\u80fd\u4e0d\u80fd\u5728[npc.her]\u7684\u6c99\u53d1\u4e0a\u5c0f\u7761\u56db\u4e2a\u5c0f\u65f6\u3002", new ParserTag[0]) + "\u4e0d\u4ec5\u4f1a\u6062\u590d" + Attribute.HEALTH_MAXIMUM.getName() + "\u4e0e" + Attribute.MANA_MAXIMUM.getName() + ", \u8fd8\u80fd\u83b7\u5f97\u201c\u5145\u5206\u4f11\u606f\u201d\u6548\u679c\u3002", OCCUPANT_APARTMENT_SLEEP_OVER){

                            @Override
                            public void effects() {
                                sleepTimeInMinutes = 240;
                                RoomPlayer.applySleep(sleepTimeInMinutes);
                            }
                        };
                    }
                    if (index == 4) {
                        final int timeUntilChange = Main.game.getMinutesUntilNextMorningOrEvening() + 5;
                        LocalDateTime[] sunriseSunset = DateAndTime.getTimeOfSolarElevationChange(Main.game.getDateNow(), SolarElevationAngle.SUN_ALTITUDE_SUNRISE_SUNSET, 51.4934, 0.0);
                        return new Response("\u4f11\u606f\u5230" + (Main.game.isDayTime() ? "\u65e5\u843d" : "\u65e5\u51fa"), UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u8be2\u95ee[npc.name]\u80fd\u4e0d\u80fd\u5728[npc.her]\u7684\u6c99\u53d1\u4e0a\u7761", new ParserTag[0]) + (String)(timeUntilChange >= 60 ? timeUntilChange / 60 + "\u5c0f\u65f6" : "") + (String)(timeUntilChange % 60 != 0 ? timeUntilChange % 60 + "\u5206\u949f" : "") + (Main.game.isDayTime() ? "\uff0c\u5373\u65e5\u843d\u540e\u4e94\u5206\u949f(" + Units.time(sunriseSunset[1].plusMinutes(5L)) + ")\u3002" : "\uff0c\u5373\u65e5\u51fa\u540e\u4e94\u5206\u949f(" + Units.time(sunriseSunset[0].plusMinutes(5L)) + ")\u3002") + "\u4e0d\u4ec5\u4f1a\u6062\u590d" + Attribute.HEALTH_MAXIMUM.getName() + "\u4e0e" + Attribute.MANA_MAXIMUM.getName() + ", \u8fd8\u80fd\u83b7\u5f97\u201c\u5145\u5206\u4f11\u606f\u201d\u6548\u679c\u3002", OCCUPANT_APARTMENT_SLEEP_OVER){

                            @Override
                            public void effects() {
                                sleepTimeInMinutes = timeUntilChange;
                                RoomPlayer.applySleep(sleepTimeInMinutes);
                            }
                        };
                    }
                    if (index == 5 && Main.getProperties().hasValue(PropertyValue.companionContent)) {
                        if (!Main.game.getPlayer().hasCompanion(OccupantDialogue.occupant())) {
                            if (!OccupantDialogue.occupant().isCompanionAvailable(Main.game.getPlayer())) {
                                return new Response("\u52a0\u5165\u961f\u4f0d", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "[npc.Name]\u4e0d\u80fd\u52a0\u5165\u4f60\u7684\u961f\u4f0d\uff01", new ParserTag[0]), null);
                            }
                            if (Main.game.getPlayer().canHaveMoreCompanions()) {
                                return new Response("\u52a0\u5165\u961f\u4f0d", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u95ee\u4e00\u95ee[npc.name]\u60f3\u4e0d\u60f3\u966a\u4f60\u4e00\u9635\u3002", new ParserTag[0]), OCCUPANT_APARTMENT){

                                    @Override
                                    public void effects() {
                                        OccupantDialogue.applyReactionReset();
                                        Main.game.getPlayer().addCompanion(OccupantDialogue.occupant());
                                    }
                                };
                            }
                            return new Response("\u52a0\u5165\u961f\u4f0d", "\u4f60\u7684\u961f\u4f0d\u6ee1\u5458\u4e86\uff01", null);
                        }
                        return new Response("\u4ece\u961f\u4f0d\u79fb\u9664", "\u547d\u4ee4[npc.name]\u4ece\u4f60\u7684\u961f\u4f0d\u91cc\u79bb\u5f00\u3002", OCCUPANT_APARTMENT){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                                Main.game.getPlayer().removeCompanion(OccupantDialogue.occupant());
                            }
                        };
                    }
                    if (index == 6) {
                        return new Response(OccupantDialogue.hasJob() ? "\u63d0\u8bae\u8df3\u69fd" : "\u4ecb\u7ecd\u5de5\u4f5c", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), (String)(OccupantDialogue.hasJob() ? "\u544a\u8bc9[npc.name][npc.her]\u73b0\u5728\u7684\u5de5\u4f5c" + UtilText.addDeterminer(occupant.getHistory().getName(OccupantDialogue.occupant())) + "\u4e0d\u9002\u5408[npc.herHim]\uff0c[npc.she]\u5e94\u8be5\u627e\u4e00\u4efd\u65b0\u5de5\u4f5c\u3002" : "\u544a\u8bc9[npc.name]\u4f60\u89c9\u5f97[npc.she]\u9002\u5408\u53bb\u627e\u4ec0\u4e48\u5de5\u4f5c\u3002"), new ParserTag[0]), OCCUPANT_JOB_SUGGESTION){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                            }
                        };
                    }
                    if (index == 8) {
                        return new Response("\u8c03\u95f9\u949f", "\u8c03\u4e2a\u624b\u673a\u95f9\u949f\uff0c\u8fd9\u6837\u4f60\u53ef\u4ee5\u5728\u7279\u5b9a\u7684\u65f6\u95f4\u9192\u6765\u3002", RoomPlayer.ROOM_SET_ALARM){

                            @Override
                            public void effects() {
                                Main.game.saveDialogueNode();
                            }
                        };
                    }
                    if (index == 9) {
                        long alarmTime = Main.game.getDialogueFlags().getSavedLong("player_phone_alarm");
                        if (alarmTime >= 0L) {
                            String alarmTimeStr = Main.game.getDisplayTime(LocalTime.ofSecondOfDay(alarmTime * 60L));
                            final int timeUntilAlarm = Main.game.getMinutesUntilTimeInMinutes((int)alarmTime - 1) + 1;
                            return new Response("\u7761\u5230\u95f9\u949f\u54cd(" + alarmTimeStr + ")", "\u8be2\u95ee[npc.name]\u80fd\u4e0d\u80fd\u5728[npc.her]\u7684\u6c99\u53d1\u4e0a\u7761" + (String)(timeUntilAlarm >= 60 ? timeUntilAlarm / 60 + "\u5c0f\u65f6\uff0c" : "") + (String)(timeUntilAlarm % 60 != 0 ? timeUntilAlarm % 60 + " \u5206\uff0c" : "") + "\u7761\u5230\u95f9\u949f\u54cd\u8d77\u3002\u9664\u4e86\u6062\u590d" + Attribute.HEALTH_MAXIMUM.getName() + "\u4e0e" + Attribute.MANA_MAXIMUM.getName() + "\uff0c\u8fd8\u80fd\u83b7\u5f97\u201c\u5145\u5206\u4f11\u606f\u201d\u6548\u679c\u3002", OCCUPANT_APARTMENT_SLEEP_OVER){

                                @Override
                                public void effects() {
                                    sleepTimeInMinutes = timeUntilAlarm;
                                    RoomPlayer.applySleep(sleepTimeInMinutes);
                                }
                            };
                        }
                        return new Response("\u7761\u5230\u95f9\u949f\u54cd(\u672a\u8bbe\u5b9a)", "<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u4f60\u8fd8\u6ca1\u6709\u8bbe\u5b9a\u95f9\u949f\uff01</span>", null);
                    }
                    if (index == 10) {
                        if (confirmKickOut) {
                            return new Response("\u786e\u8ba4\u79fb\u9664", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u544a\u8bc9[npc.name]\u4f60\u5f97\u7ee7\u7eed\u81ea\u5df1\u7684\u8def\uff0c\u518d\u4e5f\u4e0d\u4f1a\u89c1\u5230[npc.herHim]\u4e86\u3002<br/>[style.italicsBad([npc.name]\u5c06\u4f1a\u4ece\u6e38\u620f\u4e2d\u6c38\u4e45\u5220\u9664\uff01)]", new ParserTag[0]), OCCUPANT_APARTMENT_REMOVE){

                                @Override
                                public Colour getHighlightColour() {
                                    return PresetColour.GENERIC_NPC_REMOVAL;
                                }

                                @Override
                                public void effects() {
                                    OccupantDialogue.applyReactionReset();
                                    Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_REMOVE", OccupantDialogue.occupant()));
                                    Main.game.getPlayer().removeFriendlyOccupant(OccupantDialogue.occupant());
                                    Main.game.banishNPC(OccupantDialogue.occupant());
                                    confirmKickOut = false;
                                }
                            };
                        }
                        return new ResponseEffectsOnly("\u79fb\u9664\u89d2\u8272", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u544a\u8bc9[npc.name]\u4f60\u5f97\u7ee7\u7eed\u81ea\u5df1\u7684\u8def\uff0c\u518d\u4e5f\u4e0d\u4f1a\u89c1\u5230[npc.herHim]\u4e86\u3002<br/>[style.italicsMinorBad(\u505a\u51fa\u9009\u62e9\u540e\uff0c\u4f60\u9700\u8981\u518d\u6b21\u70b9\u51fb\u4ee5\u786e\u8ba4\u4ece\u6e38\u620f\u4e2d\u6c38\u4e45\u5220\u9664\u8be5\u89d2\u8272\u3002)]", new ParserTag[0])){

                            @Override
                            public void effects() {
                                confirmKickOut = true;
                            }
                        };
                    }
                    if (index == 0) {
                        return new Response("\u79bb\u5f00", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u544a\u8bc9[npc.name]\u4f60\u4f1a\u6362\u4e2a\u65f6\u95f4\u627e[npc.herHim]\u3002", new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                            @Override
                            public void effects() {
                                OccupantDialogue.applyReactionReset();
                                OccupantDialogue.exitDialogue();
                            }
                        };
                    }
                    return null;
                }
                if (responseTab == 1) {
                    if (index == 0) {
                        return new Response("\u79bb\u5f00", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), "\u544a\u8bc9[npc.name]\u4f60\u4f1a\u6362\u4e2a\u65f6\u95f4\u627e[npc.herHim]\u3002", new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                            @Override
                            public void effects() {
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "APARTMENT_LEAVING", OccupantDialogue.occupant()));
                                OccupantDialogue.applyReactionReset();
                                OccupantDialogue.exitDialogue();
                            }
                        };
                    }
                    return OCCUPANT_START.getResponse(responseTab, index);
                }
                if (responseTab == 2) {
                    return CompanionManagement.getManagementResponses(index);
                }
                return null;
            }
        };
        OCCUPANT_APARTMENT_TALK_LIFE = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getLabel() {
                return OCCUPANT_APARTMENT.getLabel();
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_TALK_LIFE", OccupantDialogue.occupant()));
                UtilText.nodeContentSB.append(OccupantDialogue.occupant().getPlayerRelationStatusDescription());
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_APARTMENT.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return OCCUPANT_APARTMENT.getResponse(responseTab, index);
            }
        };
        OCCUPANT_APARTMENT_TALK_JOB = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getLabel() {
                return OCCUPANT_APARTMENT.getLabel();
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_TALK_JOB", OccupantDialogue.occupant()));
                UtilText.nodeContentSB.append(OccupantDialogue.occupant().getPlayerRelationStatusDescription());
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_APARTMENT.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return OCCUPANT_APARTMENT.getResponse(responseTab, index);
            }
        };
        OCCUPANT_APARTMENT_SLEEP_OVER = new DialogueNode("", "", true){

            @Override
            public String getLabel() {
                return OCCUPANT_APARTMENT.getLabel();
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_SLEEP_OVER", OccupantDialogue.occupant()));
                UtilText.nodeContentSB.append(OccupantDialogue.occupant().getPlayerRelationStatusDescription());
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u9192\u6765", "\u8fc7\u4e86\u4e00\u4f1a\uff0c\u4f60\u9192\u4e86\u2026\u2026", OCCUPANT_APARTMENT_SLEEP_OVER_WAKE_UP);
                }
                return null;
            }
        };
        OCCUPANT_APARTMENT_SLEEP_OVER_WAKE_UP = new DialogueNode("", "", true){

            @Override
            public String getLabel() {
                return OCCUPANT_APARTMENT.getLabel();
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (!OccupantDialogue.occupant().isAtHome()) {
                    UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_SLEEP_OVER_WAKE_UP_ALONE", OccupantDialogue.occupant()));
                } else {
                    UtilText.nodeContentSB.append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "OCCUPANT_APARTMENT_SLEEP_OVER_WAKE_UP", OccupantDialogue.occupant()));
                    UtilText.nodeContentSB.append(OccupantDialogue.occupant().getPlayerRelationStatusDescription());
                }
                return UtilText.parse((GameCharacter)OccupantDialogue.occupant(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return OCCUPANT_APARTMENT.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (!OccupantDialogue.occupant().isAtHome()) {
                    if (index == 1) {
                        return new Response("\u5916\u9762", "\u4f60\u5df2\u7ecf\u5230\u4e86\u5916\u9762\uff0c\u5fa1\u57ce\u533a\u7684\u8857\u9053\u4e0a\u3002", Main.game.getDefaultDialogue(false)){

                            @Override
                            public void effects() {
                                OccupantDialogue.exitDialogue();
                            }
                        };
                    }
                    return null;
                }
                return OCCUPANT_APARTMENT.getResponse(responseTab, index);
            }
        };
        OCCUPANT_APARTMENT_REMOVE = new DialogueNode("", "", false){

            @Override
            public void applyPreParsingEffects() {
                OccupantDialogue.exitDialogue();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return Main.game.getDefaultDialogue(false).getResponse(responseTab, index);
            }
        };
        APARTMENT_AFTER_SEX = new DialogueNode("\u7ed3\u675f", "", true){

            @Override
            public String getDescription() {
                return "\u8eba\u5728[npc.namePos]\u7684\u6c99\u53d1\u4e0a\uff0c\u7f13\u4e00\u53e3\u6c14\u3002";
            }

            @Override
            public String getContent() {
                if (Main.sex.getAllParticipants().size() > 2) {
                    return UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "APARTMENT_AFTER_SEX_THREESOME", OccupantDialogue.occupant(), Main.game.getPlayer().getCompanions().get(0));
                }
                if (Main.sex.getNumberOfOrgasms(OccupantDialogue.occupant()) >= OccupantDialogue.occupant().getOrgasmsBeforeSatisfied()) {
                    return UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "APARTMENT_AFTER_SEX", OccupantDialogue.occupant());
                }
                return UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "APARTMENT_AFTER_SEX_NO_ORGASM", OccupantDialogue.occupant());
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u79bb\u5f00", UtilText.parse((GameCharacter)OccupantDialogue.occupant(), (String)(OccupantDialogue.occupant().isAsleep() ? "\u8ba9[npc.name]\u7ee7\u7eed\u7761\u89c9\uff0c\u79bb\u5f00[npc.her]\u7684" + (isApartment ? "\u516c\u5bd3" : "\u623f\u95f4") + "." : "\u7ed9[npc.name]\u4e00\u4e9b\u65f6\u95f4\u4f11\u606f"), new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile(OccupantDialogue.getTextFilePath(), "APARTMENT_LEAVE_AFTER_SEX", OccupantDialogue.occupant()));
                            OccupantDialogue.exitDialogue();
                        }
                    };
                }
                return null;
            }
        };
    }
}

