/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.companions;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AffectionLevel;
import com.lilithsthrone.game.character.attributes.ObedienceLevel;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.companions.CompanionManagement;
import com.lilithsthrone.game.dialogue.companions.OccupantSortingMethod;
import com.lilithsthrone.game.dialogue.eventLog.SlaveryEventLogEntry;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJob;
import com.lilithsthrone.game.occupantManagement.slaveEvent.SlaveEventType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.utils.comparators.SlaveFemininityComparator;
import com.lilithsthrone.utils.comparators.SlaveNameComparator;
import com.lilithsthrone.utils.comparators.SlaveRaceComparator;
import com.lilithsthrone.utils.comparators.SlaveRoomComparator;
import com.lilithsthrone.utils.comparators.SlaveValueComparator;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceUpgrade;
import com.lilithsthrone.world.places.GenericPlace;
import com.lilithsthrone.world.places.PlaceType;
import com.lilithsthrone.world.places.PlaceUpgrade;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class OccupantManagementDialogue {
    private static DialogueNode dialogueToExitTo = null;
    private static StringBuilder miscDialogueSB = new StringBuilder();
    private static int dayNumber = 1;
    private static DecimalFormat decimalFormat = new DecimalFormat("#0.00");
    private static List<SlaveEventType> eventTypeFilterExclusions = new ArrayList<SlaveEventType>();
    private static List<String> slaveIdFilterExclusions = new ArrayList<String>();
    private static OccupantSortingMethod sortingMethod = OccupantSortingMethod.NONE;
    private static boolean reverseSortSlaves = false;
    public static final DialogueNode OCCUPANT_OVERVIEW;
    public static final DialogueNode ROOM_MANAGEMENT;
    private static List<Cell> importantCells;
    public static Cell cellToInspect;
    public static final DialogueNode ROOM_UPGRADES;
    private static StringBuilder purchaseAvailability;
    public static final DialogueNode SLAVE_LIST;
    public static final DialogueNode SLAVE_LIST_MANAGEMENT;

    public static NPC characterSelected() {
        return Main.game.getDialogueFlags().getManagementCompanion();
    }

    public static DialogueNode getSlaveryOverviewDialogue(DialogueNode dialogueToExitTo) {
        OccupantManagementDialogue.dialogueToExitTo = dialogueToExitTo;
        dayNumber = Main.game.getDayNumber();
        Main.game.getDialogueFlags().setSlaveTrader(null);
        return OCCUPANT_OVERVIEW;
    }

    public static DialogueNode getSlaveryManagementDialogue(DialogueNode dialogueToExitTo, NPC slaveTrader) {
        OccupantManagementDialogue.dialogueToExitTo = dialogueToExitTo;
        dayNumber = Main.game.getDayNumber();
        Main.game.getDialogueFlags().setSlaveTrader(slaveTrader);
        return SLAVE_LIST_MANAGEMENT;
    }

    public static DialogueNode getSlaveryRoomListDialogue(DialogueNode dialogueToExitTo, NPC slaveTrader) {
        OccupantManagementDialogue.dialogueToExitTo = dialogueToExitTo;
        dayNumber = Main.game.getDayNumber();
        Main.game.getDialogueFlags().setSlaveTrader(slaveTrader);
        return SLAVE_LIST;
    }

    public static int getDayNumber() {
        return dayNumber;
    }

    public static void setDayNumber(int dayNumber) {
        OccupantManagementDialogue.dayNumber = Math.max(1, dayNumber);
    }

    public static OccupantSortingMethod setSlavesSortedBy() {
        return sortingMethod;
    }

    public static void setSlavesSortedBy(OccupantSortingMethod osm) {
        sortingMethod = osm;
    }

    public static boolean getSlavesAreInReverseOrder() {
        return reverseSortSlaves;
    }

    public static void setSlavesAreInReverseOrder(boolean truth) {
        reverseSortSlaves = truth;
    }

    private static Response getSlaveryResponse(int index) {
        if (index == 1) {
            return new Response("\u623f\u95f4\u5217\u8868", "\u67e5\u770b\u5168\u90e8\u623f\u95f4\u7684\u7ba1\u7406\u754c\u9762\u3002", ROOM_MANAGEMENT){

                @Override
                public void effects() {
                    Main.game.getDialogueFlags().setManagementCompanion(null);
                }
            };
        }
        if (index == 2) {
            return new Response("\u5165\u4f4f\u8005\u540d\u5355", "\u8fdb\u5165\u6240\u6709\u5974\u96b6\u548c\u53cb\u4eba\u4f4f\u5ba2\u7684\u7ba1\u7406\u754c\u9762\u3002", SLAVE_LIST_MANAGEMENT){

                @Override
                public DialogueNode getNextDialogue() {
                    return OccupantManagementDialogue.getSlaveryManagementDialogue(dialogueToExitTo, Main.game.getDialogueFlags().getSlaveTrader());
                }

                @Override
                public void effects() {
                    Main.game.getDialogueFlags().setManagementCompanion(null);
                }
            };
        }
        if (index == 5) {
            if (Main.game.getOccupancyUtil().getGeneratedBalance() == 0) {
                return new Response("\u6536\u96c6\uff1a" + UtilText.formatAsMoneyUncoloured(Main.game.getOccupancyUtil().getGeneratedBalance(), "span"), "\u4f60\u5f53\u524d\u7684\u7ed3\u4f59\u4e3a0\u2026\u2026", null);
            }
            if (Main.game.getOccupancyUtil().getGeneratedBalance() > 0) {
                return new Response("\u6536\u96c6\uff1a" + UtilText.formatAsMoney(Main.game.getOccupancyUtil().getGeneratedBalance(), "span"), "\u6536\u96c6\u7531\u4f7f\u5524\u5974\u96b6\u8d5a\u53d6\u7684\u5229\u6da6\u3002", OCCUPANT_OVERVIEW){

                    @Override
                    public DialogueNode getNextDialogue() {
                        return Main.game.getCurrentDialogueNode();
                    }

                    @Override
                    public void effects() {
                        Main.game.getOccupancyUtil().payOutBalance();
                    }
                };
            }
            if (Main.game.getPlayer().getMoney() < (long)Math.abs(Main.game.getOccupancyUtil().getGeneratedBalance())) {
                return new Response("\u652f\u4ed8: " + UtilText.formatAsMoneyUncoloured(Math.abs(Main.game.getOccupancyUtil().getGeneratedBalance()), "span"), "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u94b1\u6765\u507f\u8fd8\u7ef4\u62a4\u5974\u96b6\u548c\u623f\u95f4\u6240\u79ef\u7d2f\u7684\u503a\u52a1\u3002", null);
            }
            return new Response("\u652f\u4ed8: " + UtilText.formatAsMoney(Math.abs(Main.game.getOccupancyUtil().getGeneratedBalance()), "span", PresetColour.GENERIC_BAD), "\u8fd8\u6e05\u56e0\u7ef4\u62a4\u5974\u96b6\u548c\u623f\u95f4\u800c\u7d2f\u79ef\u7684\u503a\u52a1\u3002", OCCUPANT_OVERVIEW){

                @Override
                public DialogueNode getNextDialogue() {
                    return Main.game.getCurrentDialogueNode();
                }

                @Override
                public void effects() {
                    Main.game.getOccupancyUtil().payOutBalance();
                }
            };
        }
        if (index == 0) {
            return new Response("\u8fd4\u56de", "\u9000\u51fa\u4f4f\u6237\u540d\u5355\u3002", dialogueToExitTo == null ? Main.game.getDefaultDialogue() : dialogueToExitTo){

                @Override
                public void effects() {
                    Main.game.getDialogueFlags().setManagementCompanion(null);
                    Main.game.getDialogueFlags().setSlaveTrader(null);
                }
            };
        }
        return null;
    }

    private static String getRoomHeader() {
        return "<div class='container-full-width' style='margin-bottom:0;'><div style='width:15%; float:left; font-weight:bold; margin:0; padding:0;'>\u623f\u95f4\u540d\u79f0</div><div style='width:20%; float:left; font-weight:bold; margin:0; padding:0;'>\u4f4f\u6237</div><div style='float:left; width:10%; font-weight:bold; margin:0; padding:0;'><b>\u5bb9\u91cf</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.AFFECTION.toWebHexString() + ";'>\u597d\u611f</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.OBEDIENCE.toWebHexString() + ";'>\u670d\u4ece</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.CURRENCY_GOLD.toWebHexString() + ";'>\u7ef4\u62a4\u8d39</b></div><div style='float:left; width:10%; font-weight:bold; margin:0; padding:0;'>\u884c\u52a8</div></div>";
    }

    private static String getRoomEntry(boolean disabled, boolean currentLocation, Cell cell, List<NPC> occupants, float affectionChange, float obedienceChange) {
        miscDialogueSB.setLength(0);
        GenericPlace place = cell.getPlace();
        miscDialogueSB.append("<div class='container-full-width inner' style='margin-bottom:4px; margin-top:4px; " + (String)(!occupants.isEmpty() ? "background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'" : "'") + "'><div style='width:15%; float:left; margin:0; padding:0;'><span style='color:" + place.getColour().toWebHexString() + ";'>" + place.getName() + "</span><br/></div><div style='width:20%; float:left; margin:0; padding:0;'>");
        int i = 0;
        for (NPC occupant : occupants) {
            if (!occupant.isSlave()) continue;
            miscDialogueSB.append("<b style='color:" + occupant.getFemininity().getColour().toWebHexString() + ";'>" + occupant.getName(true) + "</b>" + (i + 1 == occupants.size() ? "" : "<br/>"));
            ++i;
        }
        if (i == 0) {
            miscDialogueSB.append("<b style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u7a7a\u95f2</b>");
        }
        miscDialogueSB.append("</div><div style='float:left; width:10%; margin:0; padding:0;'>" + i + "/" + place.getCapacity() + "</div><div style='float:left; width:15%; margin:0; padding:0;'><span style='color:" + (affectionChange == 0.0f ? PresetColour.BASE_GREY : (affectionChange > 0.0f ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_BAD)).toWebHexString() + ";'>" + (affectionChange > 0.0f ? "+" : "") + decimalFormat.format(affectionChange) + "</span>/\u5c0f\u65f6</div><div style='float:left; width:15%; margin:0; padding:0;'><span style='color:" + (obedienceChange == 0.0f ? PresetColour.BASE_GREY : (obedienceChange > 0.0f ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_BAD)).toWebHexString() + ";'>" + (obedienceChange > 0.0f ? "+" : "") + decimalFormat.format(obedienceChange) + "</span>/\u5c0f\u65f6</div><div style='float:left; width:15%; margin:0; padding:0;'>" + (disabled ? "[style.colourDisabled(N/A)]" : (place.getUpkeep() > 0 ? UtilText.formatAsMoney(-place.getUpkeep(), "span", PresetColour.GENERIC_BAD) : (place.getUpkeep() == 0 ? UtilText.formatAsMoney(-place.getUpkeep(), "span", PresetColour.TEXT_GREY) : UtilText.formatAsMoney(-place.getUpkeep(), "span", PresetColour.GENERIC_GOOD)))) + "/\u5929</div><div style='float:left; width:10%; margin:0 auto; padding:0; display:inline-block; text-align:center;'>" + (disabled ? "<div id='" + cell.getId() + (currentLocation ? "_PRESENT" : "") + "_DISABLED' class='square-button solo disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveInspectDisabled() + "</div></div>" : "<div id='" + cell.getId() + (currentLocation ? "_PRESENT" : "") + "' class='square-button solo'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveInspect() + "</div></div>") + "</div></div>");
        return miscDialogueSB.toString();
    }

    public static void resetImportantCells() {
        importantCells = new ArrayList<Cell>();
    }

    public static List<Cell> getImportantCells() {
        if (importantCells.isEmpty()) {
            AbstractWorldType[] importantWorlds;
            for (AbstractWorldType wt : importantWorlds = new AbstractWorldType[]{WorldType.LILAYAS_HOUSE_GROUND_FLOOR, WorldType.LILAYAS_HOUSE_FIRST_FLOOR, WorldType.getWorldTypeFromId("acexp_dungeon")}) {
                Cell[][] cellGrid = Main.game.getWorlds().get(wt).getCellGrid();
                for (int i = 0; i < cellGrid.length; ++i) {
                    for (int j = 0; j < cellGrid[0].length; ++j) {
                        if (cellGrid[i][j].getPlace().getPlaceType().equals(PlaceType.LILAYA_HOME_CORRIDOR) || cellGrid[i][j].getPlace().getPlaceType().equals(PlaceType.GENERIC_IMPASSABLE) || cellGrid[i][j].getPlace().getPlaceType().equals(PlaceType.getPlaceTypeFromId("acexp_dungeon_corridor")) || cellGrid[i][j].getPlace().getPlaceType().equals(PlaceType.getPlaceTypeFromId("acexp_dungeon_stairs")) || cellGrid[i][j].getPlace().getPlaceType().equals(PlaceType.getPlaceTypeFromId("acexp_dungeon_stairs_garden"))) continue;
                        importantCells.add(cellGrid[i][j]);
                    }
                }
            }
        }
        return importantCells;
    }

    private static String getWorldRooms(AbstractWorldType worldType) {
        StringBuilder worldRoomSB = new StringBuilder();
        worldRoomSB.append("<div class='container-full-width' style='text-align:center;'><h6 style='color:" + worldType.getColour().toWebHexString() + "; text-align:center;'>" + worldType.getName() + "</h6>" + OccupantManagementDialogue.getRoomHeader());
        Cell[][] cellGrid = Main.game.getWorlds().get(worldType).getCellGrid();
        ArrayList<Cell> sortingCells = new ArrayList<Cell>();
        for (int i = 0; i < cellGrid.length; ++i) {
            for (int j = 0; j < cellGrid[0].length; ++j) {
                if (cellGrid[i][j].getPlace().getPlaceUpgrades().isEmpty()) continue;
                sortingCells.add(cellGrid[i][j]);
            }
        }
        sortingCells.sort(Comparator.comparing(Cell::getPlaceName));
        for (Cell c : sortingCells) {
            GenericPlace place = c.getPlace();
            worldRoomSB.append(OccupantManagementDialogue.getRoomEntry(!place.isAbleToBeUpgraded(), false, c, Main.game.getCharactersTreatingCellAsHome(c), place.getHourlyAffectionChange(), place.getHourlyObedienceChange()));
        }
        worldRoomSB.append("</div>");
        return worldRoomSB.toString();
    }

    private static String getRoomUpgradeHeader() {
        return "<div class='container-full-width' style='margin-bottom:0;'><div style='width:30%; float:left; font-weight:bold; margin:0; padding:0;'>\u5347\u7ea7</div><div style='float:left; width:10%; font-weight:bold; margin:0; padding:0;'>\u5bb9\u91cf</div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><span style='color:" + PresetColour.AFFECTION.toWebHexString() + ";'>\u597d\u611f</span></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><span style='color:" + PresetColour.OBEDIENCE.toWebHexString() + ";'>\u670d\u4ece</span></div><div style='float:left; width:10%; font-weight:bold; margin:0; padding:0;'><span style='color:" + PresetColour.CURRENCY_GOLD.toWebHexString() + ";'>\u7ef4\u62a4\u8d39</span></div><div style='float:left; width:10%; font-weight:bold; margin:0; padding:0;'><span style='color:" + PresetColour.CURRENCY_GOLD.toWebHexString() + ";'>\u82b1\u8d39</span></div><div style='float:left; width:10%; font-weight:bold; margin:0; padding:0;'>\u884c\u52a8</div></div>";
    }

    private static String getUpgradeEntry(Cell cell, AbstractPlaceUpgrade upgrade) {
        boolean availableForPurchase;
        miscDialogueSB.setLength(0);
        GenericPlace place = cell.getPlace();
        float affectionChange = upgrade.getHourlyAffectionGain();
        float obedienceChange = upgrade.getHourlyObedienceGain();
        boolean owned = place.getPlaceUpgrades().contains(upgrade);
        boolean canBuy = availableForPurchase = upgrade.isPrerequisitesMet(place) && upgrade.getAvailability(cell).getKey() != false && (owned ? Main.game.getPlayer().getMoney() >= (long)upgrade.getRemovalCost() : Main.game.getPlayer().getMoney() >= (long)upgrade.getInstallCost());
        miscDialogueSB.append("<div class='container-full-width inner' style='margin-bottom:4px; margin-top:4px;" + (String)(owned ? "background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'" : "'") + "'><div style='width:5%; float:left; margin:0; padding:0;'><div class='title-button no-select' id='ROOM_MOD_INFO_" + PlaceUpgrade.getIdFromPlaceUpgrade(upgrade) + "' style='position:relative; top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getInformationIcon() + "</div></div><div style='width:25%; float:left; margin:0; padding:0;'>" + (owned ? "<b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>" + Util.capitaliseSentence(upgrade.getName()) + "</b>" : (!availableForPurchase ? "<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + Util.capitaliseSentence(upgrade.getName()) + "</b>" : "<b>" + Util.capitaliseSentence(upgrade.getName()) + "</b>")) + "</div><div style='width:10%; float:left; margin:0; padding:0;'>" + (String)(upgrade.getCapacity() > 0 ? "<b style='color:" + PresetColour.GENERIC_EXCELLENT.toWebHexString() + ";'>+" + upgrade.getCapacity() + "</b>" : (upgrade.getCapacity() < 0 ? "<b style='color:" + PresetColour.GENERIC_TERRIBLE.toWebHexString() + ";'>" + upgrade.getCapacity() + "</b>" : "[style.colourDisabled(0)]")) + "</div><div style='float:left; width:15%; margin:0; padding:0;'>" + (String)(affectionChange > 0.0f ? "<b style='color:" + PresetColour.AFFECTION.toWebHexString() + ";'>+" + decimalFormat.format(affectionChange) + "</b>/\u5c0f\u65f6" : (affectionChange < 0.0f ? "<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + decimalFormat.format(affectionChange) + "</b>/\u5c0f\u65f6" : "[style.colourDisabled(0)]/\u5c0f\u65f6")) + "</div><div style='float:left; width:15%; margin:0; padding:0;'>" + (String)(obedienceChange > 0.0f ? "<b style='color:" + PresetColour.OBEDIENCE.toWebHexString() + ";'>+" + decimalFormat.format(obedienceChange) + "</b>/\u5c0f\u65f6" : (obedienceChange < 0.0f ? "<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + decimalFormat.format(obedienceChange) + "</b>/\u5c0f\u65f6" : "[style.colourDisabled(0)]/\u5c0f\u65f6")) + "</div><div style='float:left; width:10%; margin:0; padding:0;'>" + (upgrade.getUpkeep() > 0 ? UtilText.formatAsMoney(upgrade.getUpkeep(), "b", PresetColour.GENERIC_BAD) : UtilText.formatAsMoney(upgrade.getUpkeep(), "b", PresetColour.GENERIC_GOOD)) + "/\u5929</div><div style='float:left; width:10%; margin:0; padding:0;'>" + (owned ? (upgrade.getRemovalCost() < 0 ? UtilText.formatAsMoney(upgrade.getRemovalCost(), "b", PresetColour.GENERIC_GOOD) : ((long)upgrade.getRemovalCost() < Main.game.getPlayer().getMoney() ? UtilText.formatAsMoney(upgrade.getRemovalCost(), "b") : UtilText.formatAsMoney(upgrade.getRemovalCost(), "b", PresetColour.GENERIC_BAD))) : (upgrade.getInstallCost() < 0 ? UtilText.formatAsMoney(upgrade.getInstallCost(), "b", PresetColour.GENERIC_GOOD) : ((long)upgrade.getInstallCost() < Main.game.getPlayer().getMoney() ? UtilText.formatAsMoney(upgrade.getInstallCost(), "b") : UtilText.formatAsMoney(upgrade.getInstallCost(), "b", PresetColour.GENERIC_BAD)))) + "</div><div style='float:left; width:10%; margin:0 auto; padding:0; display:inline-block; text-align:center;'>");
        if (owned) {
            if (Main.game.getPlayer().getMoney() < (long)upgrade.getRemovalCost() || !upgrade.getRemovalAvailability(cell).getKey().booleanValue()) {
                miscDialogueSB.append("<div id='" + PlaceUpgrade.getIdFromPlaceUpgrade(upgrade) + "_SELL_DISABLED' class='square-button solo disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getTransactionSellDisabled() + "</div></div>");
            } else {
                miscDialogueSB.append("<div id='" + PlaceUpgrade.getIdFromPlaceUpgrade(upgrade) + "_SELL' class='square-button solo'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getTransactionSell() + "</div></div>");
            }
        } else {
            if (Main.game.getPlayer().getMoney() < (long)upgrade.getInstallCost() || Main.game.getOccupancyUtil().getGeneratedBalance() < 0) {
                canBuy = false;
            }
            if (canBuy && !upgrade.getPrerequisites().isEmpty()) {
                for (AbstractPlaceUpgrade prereq : upgrade.getPrerequisites()) {
                    if (place.getPlaceUpgrades().contains(prereq)) continue;
                    canBuy = false;
                    break;
                }
            }
            if (canBuy) {
                miscDialogueSB.append("<div id='" + PlaceUpgrade.getIdFromPlaceUpgrade(upgrade) + "_BUY' class='square-button solo'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getTransactionBuy() + "</div></div>");
            } else {
                miscDialogueSB.append("<div id='" + PlaceUpgrade.getIdFromPlaceUpgrade(upgrade) + "_BUY_DISABLED' class='square-button solo disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getTransactionBuyDisabled() + "</div></div>");
            }
        }
        miscDialogueSB.append("</div>");
        if (!canBuy) {
            miscDialogueSB.append("<p><i>[style.colourBad(" + OccupantManagementDialogue.getPurchaseAvailabilityTooltipText(cellToInspect, upgrade) + ")]</i></p>");
        }
        miscDialogueSB.append("</div>");
        return miscDialogueSB.toString();
    }

    public static String getPurchaseAvailabilityTooltipText(Cell cell, AbstractPlaceUpgrade upgrade) {
        String availabilityDescription;
        GenericPlace place = cell.getPlace();
        boolean owned = place.getPlaceUpgrades().contains(upgrade);
        purchaseAvailability.setLength(0);
        if (owned) {
            if (Main.game.getPlayer().getMoney() < (long)upgrade.getRemovalCost()) {
                purchaseAvailability.append("<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u4f60\u8d1f\u62c5\u4e0d\u8d77\u62c6\u9664\u6539\u9020\u3002</span>");
            }
        } else {
            if (Main.game.getOccupancyUtil().getGeneratedBalance() < 0) {
                purchaseAvailability.append("<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u4f60\u8d1f\u503a\u65f6\u4e0d\u80fd\u652f\u4ed8\u4efb\u4f55\u6539\u9020\uff01</b>");
            }
            if (Main.game.getPlayer().getMoney() < (long)upgrade.getInstallCost()) {
                purchaseAvailability.append("<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u4f60\u652f\u4ed8\u4e0d\u8d77\u6539\u9020\u8d39\u7528\u3002</span>");
            }
            if (!upgrade.getPrerequisites().isEmpty()) {
                purchaseAvailability.append("\u4f60\u9700\u8981\u5148\u8d2d\u4e70\u4ee5\u4e0b:");
                for (AbstractPlaceUpgrade prereq : upgrade.getPrerequisites()) {
                    if (place.getPlaceUpgrades().contains(prereq)) {
                        purchaseAvailability.append("<br/><span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>" + prereq.getName() + "</span>");
                        continue;
                    }
                    purchaseAvailability.append("<br/><span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + prereq.getName() + "</span>");
                }
            }
        }
        if ((availabilityDescription = upgrade.getAvailability(cellToInspect).getValue()) != null && availabilityDescription.length() > 0) {
            purchaseAvailability.append("<br/><span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + availabilityDescription + "</span>");
        }
        return purchaseAvailability.toString();
    }

    private static String getSlaveryHeader() {
        return "<div class='container-full-width' style='margin-bottom:0;'><div style='width:20%; float:left; font-weight:bold; margin:0; padding:0;'>\u5974\u96b6</div><div style='width:20%; float:left; font-weight:bold; margin:0; padding:0;'>\u4f4d\u7f6e</div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.AFFECTION.toWebHexString() + ";'>\u597d\u611f</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.OBEDIENCE.toWebHexString() + ";'>\u670d\u4ece</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.CURRENCY_GOLD.toWebHexString() + ";'>\u4ef7\u503c</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'>\u884c\u52a8</div></div>";
    }

    private static String getOccupantHeader() {
        return "<div class='container-full-width' style='margin-bottom:0;'><div style='width:20%; float:left; font-weight:bold; margin:0; padding:0;'>\u53cb\u4eba\u4f4f\u5ba2</div><div style='width:20%; float:left; font-weight:bold; margin:0; padding:0;'>\u4f4d\u7f6e</div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.AFFECTION.toWebHexString() + ";'>\u597d\u611f</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.OBEDIENCE.toWebHexString() + ";'>\u670d\u4ece</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.CURRENCY_GOLD.toWebHexString() + ";'>\u4ef7\u503c</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'>\u884c\u52a8</div></div>";
    }

    private static String getSlaveryEntry(boolean slaveOwned, GenericPlace place, NPC slave, AffectionLevel affection, float affectionChange, ObedienceLevel obedience, float obedienceChange, boolean alternateBackground) {
        miscDialogueSB.setLength(0);
        miscDialogueSB.append("<div class='container-full-width inner' style='margin-bottom:0;" + (String)(alternateBackground ? "background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'" : "'") + "'><div style='width:20%; float:left; margin:0; padding:0;'><b style='color:" + slave.getFemininity().getColour().toWebHexString() + ";'>" + slave.getName(true) + "</b><br/><span style='color:" + slave.getRace().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence((slave.isPrependWingedToRaceName() ? "\u6709\u7ffc" : "") + (slave.isFeminine() ? slave.getSubspecies().getSingularFemaleName(slave.getBody()) : slave.getSubspecies().getSingularMaleName(slave.getBody()))) + "</span><br/><span style='color:" + slave.getFemininity().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(slave.getGender().getName()) + "</span></div><div style='width:20%; float:left; margin:0; padding:0;'><b style='color:" + slave.getLocationPlace().getColour().toWebHexString() + ";'>" + slave.getLocationPlace().getName() + "</b>,<br/><span style='color:" + slave.getWorldLocation().getColour().toWebHexString() + ";'>" + slave.getWorldLocation().getName() + "</span></div><div style='float:left; width:15%; margin:0; padding:0;'><b style='color:" + affection.getColour().toWebHexString() + ";'>" + slave.getAffection(Main.game.getPlayer()) + "</b><br/><span style='color:" + (affectionChange == 0.0f ? PresetColour.BASE_GREY : (affectionChange > 0.0f ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_BAD)).toWebHexString() + ";'>" + (affectionChange > 0.0f ? "+" : "") + decimalFormat.format(affectionChange) + "</span>/\u5929<br/><span style='color:" + affection.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(affection.getName()) + "</span></div><div style='float:left; width:15%; margin:0; padding:0;'><b style='color:" + obedience.getColour().toWebHexString() + ";'>" + slave.getObedienceValue() + "</b><br/><span style='color:" + (obedienceChange == 0.0f ? PresetColour.BASE_GREY : (obedienceChange > 0.0f ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_BAD)).toWebHexString() + ";'>" + (obedienceChange > 0.0f ? "+" : "") + decimalFormat.format(obedienceChange) + "</span>/\u5929<br/><span style='color:" + obedience.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(obedience.getName()) + "</span></div><div style='float:left; width:15%; margin:0; padding:0;'>" + (Main.game.getDialogueFlags().getSlaveTrader() != null ? (slaveOwned ? UtilText.formatAsMoney((int)((float)slave.getValueAsSlave(true) * Main.game.getDialogueFlags().getSlaveTrader().getBuyModifier()), "b", PresetColour.TEXT) : UtilText.formatAsMoney((int)((float)slave.getValueAsSlave(true) * Main.game.getDialogueFlags().getSlaveTrader().getSellModifier(null)), "b", (float)slave.getValueAsSlave(true) * Main.game.getDialogueFlags().getSlaveTrader().getSellModifier(null) > (float)Main.game.getPlayer().getMoney() ? PresetColour.GENERIC_BAD : PresetColour.TEXT)) : UtilText.formatAsMoney(slave.getValueAsSlave(true))) + "<br/><b>" + Util.capitaliseSentence(slave.getSlaveJob(Main.game.getHourOfDay()).getName(slave)) + "(\u73b0\u5728)</b><br/>" + UtilText.formatAsMoney(SlaveJob.getFinalDailyIncomeAfterModifiers(slave)) + "/\u5929</div>");
        miscDialogueSB.append("<div style='float:left; width:15%; margin:0 auto; padding:0; display:inline-block; text-align:center;'>");
        if (slaveOwned) {
            miscDialogueSB.append("<div id='" + slave.getId() + "' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveInspect() + "</div></div>");
            if (Main.game.getDialogueFlags().getSlaveTrader() == null) {
                miscDialogueSB.append("<div id='" + slave.getId() + "_JOB' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveJob() + "</div></div>");
                miscDialogueSB.append("<div id='" + slave.getId() + "_PERMISSIONS' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlavePermissions() + "</div></div>");
                miscDialogueSB.append("<div id='" + slave.getId() + "_INVENTORY' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getInventoryIcon() + "</div></div>");
                if (place.getCapacity() <= Main.game.getCharactersTreatingCellAsHome(Main.game.getPlayerCell()).size()) {
                    miscDialogueSB.append("<div id='" + slave.getId() + "_TRANSFER_DISABLED_FULL' class='square-button big disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveTransferDisabled() + "</div></div>");
                } else if (slave.isDoll() ? !place.getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_DOLL_CLOSET) : !place.isSlaveCell() || place.getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_DOLL_CLOSET)) {
                    miscDialogueSB.append("<div id='" + slave.getId() + "_TRANSFER_DISABLED_INAPPPROPRIATE' class='square-button big disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveTransferDisabled() + "</div></div>");
                } else if (slave.getLocation().equals(Main.game.getPlayer().getLocation()) && slave.getWorldLocation().equals(Main.game.getPlayer().getWorldLocation())) {
                    miscDialogueSB.append("<div id='" + slave.getId() + "_TRANSFER_DISABLED_ALREADY_HERE' class='square-button big disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveTransferDisabled() + "</div></div>");
                } else {
                    miscDialogueSB.append("<div id='" + slave.getId() + "_TRANSFER' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveTransfer() + "</div></div>");
                }
            }
            if (Main.game.getDialogueFlags().getSlaveTrader() == null || !slave.isAbleToBeSold()) {
                miscDialogueSB.append("<div id='" + slave.getId() + "_SELL_DISABLED' class='square-button big disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getTransactionSellDisabled() + "</div></div>");
            } else {
                miscDialogueSB.append("<div id='" + slave.getId() + "_SELL' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getTransactionSell() + "</div></div>");
            }
            if (Main.game.getDialogueFlags().getSlaveTrader() == null) {
                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.kateIntroduced)) {
                    miscDialogueSB.append("<div id='" + slave.getId() + "_COSMETICS' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveCosmetics() + "</div></div>");
                } else {
                    miscDialogueSB.append("<div id='" + slave.getId() + "_COSMETICS_DISABLED' class='square-button big disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveCosmeticsDisabled() + "</div></div>");
                }
            }
        } else {
            miscDialogueSB.append("<div id='" + slave.getId() + "_TRADER' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveInspect() + "</div></div>");
            if (Main.game.getPlayer().getMoney() < (long)((int)((float)slave.getValueAsSlave(true) * Main.game.getDialogueFlags().getSlaveTrader().getSellModifier(null)))) {
                miscDialogueSB.append("<div id='" + slave.getId() + "_BUY_DISABLED' class='square-button big disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getTransactionBuyDisabled() + "</div></div>");
            } else {
                miscDialogueSB.append("<div id='" + slave.getId() + "_BUY' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getTransactionBuy() + "</div></div>");
            }
        }
        miscDialogueSB.append("</div></div>");
        return miscDialogueSB.toString();
    }

    private static String getOccupantEntry(GenericPlace place, NPC occupant, AffectionLevel affection, float affectionChange, ObedienceLevel obedience, float obedienceChange, boolean alternateBackground) {
        miscDialogueSB.setLength(0);
        miscDialogueSB.append("<div class='container-full-width inner' style='margin-bottom:0;" + (String)(alternateBackground ? "background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'" : "'") + "'><div style='width:20%; float:left; margin:0; padding:0;'><b style='color:" + occupant.getFemininity().getColour().toWebHexString() + ";'>" + occupant.getName(true) + "</b><br/><span style='color:" + occupant.getRace().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence((occupant.isPrependWingedToRaceName() ? "\u6709\u7ffc" : "") + (occupant.isFeminine() ? occupant.getSubspecies().getSingularFemaleName(occupant.getBody()) : occupant.getSubspecies().getSingularMaleName(occupant.getBody()))) + "</span><br/><span style='color:" + occupant.getFemininity().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(occupant.getGender().getName()) + "</span></div><div style='width:20%; float:left; margin:0; padding:0;'>" + (occupant.getWorldLocation() == WorldType.EMPTY ? "<b style='color:" + PresetColour.BASE_GREY.toWebHexString() + ";'>\u5728\u5de5\u4f5c</b>,<br/><span style='color:" + WorldType.DOMINION.getColour().toWebHexString() + ";'>" + WorldType.DOMINION.getName() + "</span>" : "<b style='color:" + occupant.getLocationPlace().getColour().toWebHexString() + ";'>" + occupant.getLocationPlace().getName() + "</b>,<br/><span style='color:" + occupant.getWorldLocation().getColour().toWebHexString() + ";'>" + occupant.getWorldLocation().getName() + "</span>") + "</div><div style='float:left; width:15%; margin:0; padding:0;'><b style='color:" + affection.getColour().toWebHexString() + ";'>" + occupant.getAffection(Main.game.getPlayer()) + "</b><br/><span style='color:" + (affectionChange == 0.0f ? PresetColour.BASE_GREY : (affectionChange > 0.0f ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_BAD)).toWebHexString() + ";'>" + (affectionChange > 0.0f ? "+" : "") + decimalFormat.format(affectionChange) + "</span>/\u5929<br/><span style='color:" + affection.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(affection.getName()) + "</span></div><div style='float:left; width:15%; margin:0; padding:0;'><b style='color:" + obedience.getColour().toWebHexString() + ";'>" + occupant.getObedienceValue() + "</b><br/><span style='color:" + (obedienceChange == 0.0f ? PresetColour.BASE_GREY : (obedienceChange > 0.0f ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_BAD)).toWebHexString() + ";'>" + (obedienceChange > 0.0f ? "+" : "") + decimalFormat.format(obedienceChange) + "</span>/\u5929<br/><span style='color:" + obedience.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(obedience.getName()) + "</span></div><div style='float:left; width:15%; margin:0; padding:0;'><b>" + (String)(occupant.hasJob() || !occupant.hasAnySlaveJobAssigned() ? Util.capitaliseSentence(occupant.getHistory().getName(occupant)) : Util.capitaliseSentence(occupant.getSlaveJob(Main.game.getHourOfDay()).getName(occupant)) + " (\u73b0\u5728)") + "</b><br/>" + UtilText.formatAsMoney(occupant.hasJob() ? (long)PlaceUpgrade.LILAYA_GUEST_ROOM.getUpkeep() : (long)SlaveJob.getFinalDailyIncomeAfterModifiers(occupant)) + "/\u5929</div><div style='float:left; width:15%; margin:0 auto; padding:0; display:inline-block; text-align:center;'><div id='" + occupant.getId() + "' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveInspect() + "</div></div>" + (occupant.hasJob() ? "<div id='" + occupant.getId() + "_JOB' class='square-button big disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveJobDisabled() + "</div></div>" : "<div id='" + occupant.getId() + "_JOB' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveJob() + "</div></div>") + "<div id='" + occupant.getId() + "_PERMISSIONS' class='square-button big disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlavePermissionsDisabled() + "</div></div><div id='" + occupant.getId() + "_INVENTORY' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getInventoryIcon() + "</div></div><div " + (place.getCapacity() <= Main.game.getCharactersTreatingCellAsHome(Main.game.getPlayerCell()).size() || place.isSlaveCell() || occupant.getHomeWorldLocation() == WorldType.DOMINION || occupant.getLocation().equals(Main.game.getPlayer().getLocation()) && occupant.getWorldLocation().equals(Main.game.getPlayer().getWorldLocation()) ? " id='" + occupant.getId() + "_TRANSFER_DISABLED' class='square-button big disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveTransferDisabled() + "</div></div>" : " id='" + occupant.getId() + "_TRANSFER' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveTransfer() + "</div></div>"));
        if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.kateIntroduced)) {
            miscDialogueSB.append("<div id='" + occupant.getId() + "_COSMETICS' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveCosmetics() + "</div></div>");
        } else {
            miscDialogueSB.append("<div id='" + occupant.getId() + "_COSMETICS_DISABLED' class='square-button big disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getSlaveCosmeticsDisabled() + "</div></div>");
        }
        miscDialogueSB.append("</div></div>");
        return miscDialogueSB.toString();
    }

    static {
        decimalFormat.setRoundingMode(RoundingMode.HALF_EVEN);
        OCCUPANT_OVERVIEW = new DialogueNode("\u5974\u96b6\u603b\u89c8", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                int income = Main.game.getPlayer().getSlaveryTotalDailyIncome();
                int upkeep = Main.game.getPlayer().getSlaveryTotalDailyUpkeep();
                UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><h6 style='color:" + PresetColour.GENERIC_EXPERIENCE.toWebHexString() + "; text-align:center;'>\u603b\u8ba1</h6><div class='container-full-width' style='text-align:center; margin-bottom:0;'><div style='width:10%; float:left; font-weight:bold; margin:0; padding:0;'>\u5974\u96b6</div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u6536\u5165</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u7ef4\u62a4\u8d39</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.CURRENCY_GOLD.toWebHexString() + ";'>\u5229\u6da6</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u73b0\u6536\u5165</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u652f\u4ed8</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.CURRENCY_GOLD.toWebHexString() + ";'>\u6536\u652f</b></div></div><div class='container-full-width inner' style='text-align:center;'><div style='width:10%; float:left; margin:0; padding:0;'>" + Main.game.getPlayer().getSlavesOwned().size() + "</div><div style='float:left; width:15%; margin:0; padding:0;'>" + UtilText.formatAsMoney(income) + "/\u5929</div><div style='float:left; width:15%; margin:0; padding:0;'>" + UtilText.formatAsMoney(upkeep, "b", PresetColour.GENERIC_BAD) + "/\u5929</div><div style='float:left; width:15%; margin:0; padding:0;'>" + UtilText.formatAsMoney(income - upkeep, "b", income - upkeep < 0 ? PresetColour.GENERIC_BAD : PresetColour.TEXT) + "/\u5929</div><div style='width:15%; float:left; font-weight:bold; margin:0; padding:0;'>" + UtilText.formatAsMoney(Main.game.getOccupancyUtil().getGeneratedIncome(), "b") + "</div><div style='width:15%; float:left; font-weight:bold; margin:0; padding:0;'>" + UtilText.formatAsMoney(Main.game.getOccupancyUtil().getGeneratedUpkeep(), "b", PresetColour.GENERIC_BAD) + "</div><div style='width:15%; float:left; font-weight:bold; margin:0; padding:0;'>" + (Main.game.getOccupancyUtil().getGeneratedBalance() < 0 ? UtilText.formatAsMoney(Main.game.getOccupancyUtil().getGeneratedBalance(), "b", PresetColour.GENERIC_BAD) : UtilText.formatAsMoney(Main.game.getOccupancyUtil().getGeneratedBalance(), "b")) + "</div></div></div>");
                UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><h6 style='color:" + PresetColour.GENERIC_ARCANE.toWebHexString() + "; text-align:center;'>\u6d3b\u52a8\u65e5\u5fd7</h6>");
                for (int i = 6; i >= 0; --i) {
                    UtilText.nodeContentSB.append("<div id='SLAVE_DAY_" + i + "' class='normal-button' style='width:12%; margin:1%;" + (String)(Main.game.getDayNumber() - i == dayNumber ? "color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";" : "") + "'>" + (i == 0 ? "\u4eca\u5929" : (i == 1 ? "\u6628\u5929" : Main.game.getDateNow().minusDays(i).getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.CHINESE))) + "</div>");
                }
                UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center; margin-bottom:0;'><div style='width:10%; float:left; font-weight:bold; margin:0; padding:0;'>\u65f6\u95f4</div><div style='width:15%; float:left; font-weight:bold; margin:0; padding:0;'>\u5974\u96b6</div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'>\u4e8b\u4ef6</div><div style='float:left; width:60%; font-weight:bold; margin:0; padding:0;'>\u63cf\u8ff0</div></div><div class='container-full-width' style='text-align:center; margin-bottom:0;'>");
                int count = 0;
                if (Main.game.getSlaveryEvents(dayNumber) != null) {
                    ArrayList<SlaveryEventLogEntry> entries = new ArrayList<SlaveryEventLogEntry>(Main.game.getSlaveryEvents(dayNumber));
                    int filtered = 0;
                    for (SlaveryEventLogEntry entry : Main.game.getSlaveryEvents(dayNumber)) {
                        if (!eventTypeFilterExclusions.contains((Object)entry.getEvent().getType()) && (!slaveIdFilterExclusions.contains(entry.getSlaveID()) || !slaveIdFilterExclusions.containsAll(entry.getInvolvedSlaveIDs()))) continue;
                        ++filtered;
                        entries.remove(entry);
                    }
                    if (filtered > 0) {
                        UtilText.nodeContentSB.append("<div class='container-full-width inner' style='background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'>[style.italicsBad(\u8fc7\u6ee4\u4e8b\u4ef6: " + filtered + ")]</div>");
                    }
                    for (SlaveryEventLogEntry entry : entries) {
                        if (count % 2 == 0) {
                            UtilText.nodeContentSB.append("<div class='container-full-width inner' style='background:" + PresetColour.BACKGROUND.toWebHexString() + ";'>");
                        } else {
                            UtilText.nodeContentSB.append("<div class='container-full-width inner' style='background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'>");
                        }
                        UtilText.nodeContentSB.append("<div style='width:10%; float:left; margin:0; padding:0;'>" + String.format("%02d", entry.getTime()) + ":00<br/></div><div style='width:15%; float:left; margin:0; padding:0;'>" + entry.getSlaveName() + "</div><div style='width:15%; float:left; margin:0; padding:0;'>" + entry.getName() + "</div><div style='width:60%; float:left;  margin:0; padding:0;'>" + entry.getDescription() + "</div></div>");
                        ++count;
                    }
                }
                if (count == 0) {
                    UtilText.nodeContentSB.append("<div class='container-full-width inner' style='background:" + PresetColour.BACKGROUND.toWebHexString() + ";'>[style.colourDisabled(\u8fd9\u4e00\u5929\u6ca1\u6709\u4e8b\u4ef6\u2026\u2026)]</div>");
                }
                UtilText.nodeContentSB.append("</div></div>");
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getResponseTabTitle(int index) {
                if (index == 0) {
                    return "\u623f\u95f4";
                }
                if (index == 1) {
                    return "\u8fc7\u6ee4(\u7c7b\u578b)";
                }
                if (index == 2) {
                    return "\u8fc7\u6ee4(\u5974\u96b6)";
                }
                return null;
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (responseTab == 0) {
                    return OccupantManagementDialogue.getSlaveryResponse(index);
                }
                if (responseTab == 1) {
                    if (index == 0) {
                        return OccupantManagementDialogue.getSlaveryResponse(index);
                    }
                    if (index == 1) {
                        return new Response("\u6dfb\u52a0\u6240\u6709", "\u5c06\u6240\u6709\u7c7b\u578b\u90fd\u6dfb\u52a0\u81f3\u8fc7\u6ee4\u3002", OCCUPANT_OVERVIEW){

                            @Override
                            public Colour getHighlightColour() {
                                return PresetColour.GENERIC_GOOD;
                            }

                            @Override
                            public void effects() {
                                eventTypeFilterExclusions.clear();
                            }
                        };
                    }
                    if (index == 2) {
                        return new Response("\u6e05\u9664\u6240\u6709", "\u4ece\u8fc7\u6ee4\u4e2d\u79fb\u9664\u6240\u6709\u7c7b\u578b\u3002", OCCUPANT_OVERVIEW){

                            @Override
                            public Colour getHighlightColour() {
                                return PresetColour.GENERIC_BAD;
                            }

                            @Override
                            public void effects() {
                                eventTypeFilterExclusions.clear();
                                Collections.addAll(eventTypeFilterExclusions, SlaveEventType.values());
                            }
                        };
                    }
                    if (index - 3 < SlaveEventType.values().length) {
                        final SlaveEventType type = SlaveEventType.values()[index - 3];
                        return new Response(type.getName(), "\u901a\u8fc7\u70b9\u51fb\u8fc7\u6ee4\u8be5\u7c7b\u4e8b\u4ef6:<br/><i>" + type.getDescription() + "</i>", OCCUPANT_OVERVIEW){

                            @Override
                            public Colour getHighlightColour() {
                                if (eventTypeFilterExclusions.contains((Object)type)) {
                                    return PresetColour.TEXT_GREY;
                                }
                                return PresetColour.GENERIC_MINOR_GOOD;
                            }

                            @Override
                            public void effects() {
                                if (eventTypeFilterExclusions.contains((Object)type)) {
                                    eventTypeFilterExclusions.remove((Object)type);
                                } else {
                                    eventTypeFilterExclusions.add(type);
                                }
                            }
                        };
                    }
                } else if (responseTab == 2) {
                    final List<String> ownedSlaves = Main.game.getPlayer().getSlavesOwned();
                    if (index == 0) {
                        return OccupantManagementDialogue.getSlaveryResponse(index);
                    }
                    if (index == 1) {
                        return new Response("\u6dfb\u52a0\u6240\u6709", "\u5c06\u6240\u6709\u5974\u96b6\u6dfb\u52a0\u81f3\u8fc7\u6ee4\u3002", OCCUPANT_OVERVIEW){

                            @Override
                            public Colour getHighlightColour() {
                                return PresetColour.GENERIC_GOOD;
                            }

                            @Override
                            public void effects() {
                                slaveIdFilterExclusions.clear();
                            }
                        };
                    }
                    if (index == 2) {
                        return new Response("\u6e05\u9664\u6240\u6709", "\u4ece\u8fc7\u6ee4\u4e2d\u79fb\u9664\u6240\u6709\u5974\u96b6\u3002", OCCUPANT_OVERVIEW){

                            @Override
                            public Colour getHighlightColour() {
                                return PresetColour.GENERIC_BAD;
                            }

                            @Override
                            public void effects() {
                                slaveIdFilterExclusions.clear();
                                slaveIdFilterExclusions.addAll(ownedSlaves);
                            }
                        };
                    }
                    if (index - 3 < ownedSlaves.size()) {
                        final String slaveId = ownedSlaves.get(index - 3);
                        GameCharacter slave = null;
                        try {
                            slave = Main.game.getNPCById(slaveId);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (slave == null) {
                            return null;
                        }
                        final GameCharacter slaveInner = slave;
                        return new Response(UtilText.parse(slave, "[npc.Name]", new ParserTag[0]), "\u901a\u8fc7\u70b9\u51fb\u8fc7\u6ee4\u8be5\u5974\u96b6\u7684\u65f6\u95f4\u662f\u5426\u663e\u793a\u3002", OCCUPANT_OVERVIEW){

                            @Override
                            public Colour getHighlightColour() {
                                if (slaveIdFilterExclusions.contains(slaveId)) {
                                    return PresetColour.TEXT_GREY;
                                }
                                return slaveInner.getFemininity().getColour();
                            }

                            @Override
                            public void effects() {
                                if (slaveIdFilterExclusions.contains(slaveId)) {
                                    slaveIdFilterExclusions.remove(slaveId);
                                } else {
                                    slaveIdFilterExclusions.add(slaveId);
                                }
                            }
                        };
                    }
                }
                return null;
            }
        };
        ROOM_MANAGEMENT = new DialogueNode("\u7ba1\u7406\u623f\u95f4", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                Cell cell = Main.game.getPlayerCell();
                GenericPlace place = cell.getPlace();
                List<NPC> charactersPresent = Main.game.getCharactersTreatingCellAsHome(cell);
                float affectionChange = place.getHourlyAffectionChange();
                float obedienceChange = place.getHourlyObedienceChange();
                UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><h6 style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + "; text-align:center;'>\u5f53\u524d\u4f4d\u7f6e</h6>" + OccupantManagementDialogue.getRoomHeader() + OccupantManagementDialogue.getRoomEntry(!place.isAbleToBeUpgraded(), true, cell, charactersPresent, affectionChange, obedienceChange) + "</div>");
                UtilText.nodeContentSB.append(OccupantManagementDialogue.getWorldRooms(WorldType.LILAYAS_HOUSE_GROUND_FLOOR));
                UtilText.nodeContentSB.append(OccupantManagementDialogue.getWorldRooms(WorldType.LILAYAS_HOUSE_FIRST_FLOOR));
                UtilText.nodeContentSB.append(OccupantManagementDialogue.getWorldRooms(WorldType.SLAVER_ALLEY));
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u4e0a\u4e00\u754c\u9762\u3002", OCCUPANT_OVERVIEW);
                }
                return null;
            }
        };
        importantCells = new ArrayList<Cell>();
        ROOM_UPGRADES = new DialogueNode("\u7ba1\u7406\u623f\u95f4", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return "\u7ba1\u7406" + cellToInspect.getPlace().getName();
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><h6 style='color:" + PresetColour.GENERIC_EXCELLENT.toWebHexString() + "; text-align:center;'>\u603b\u89c8(\u8be5\u623f\u95f4\u7684\u6240\u6709\u6570\u636e)</h6><div class='container-full-width' style='margin-bottom:0;'><div style='width:20%; float:left; font-weight:bold; margin:0; padding:0;'>\u540d\u79f0</div><div style='width:20%; float:left; font-weight:bold; margin:0; padding:0;'>\u4f4f\u6237</div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b>\u5bb9\u91cf</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.AFFECTION.toWebHexString() + ";'>\u597d\u611f</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.OBEDIENCE.toWebHexString() + ";'>\u670d\u4ece</b></div><div style='float:left; width:15%; font-weight:bold; margin:0; padding:0;'><b style='color:" + PresetColour.CURRENCY_GOLD.toWebHexString() + ";'>\u7ef4\u62a4\u8d39</b></div></div>");
                GenericPlace place = cellToInspect.getPlace();
                float affectionChange = place.getHourlyAffectionChange();
                float obedienceChange = place.getHourlyObedienceChange();
                UtilText.nodeContentSB.append("<div class='container-full-width inner' style='margin-bottom:0;'><div style='width:20%; float:left; font-weight:bold; margin:0; padding:0;'><form style='float:left; width:85%; margin:0; padding:0;'><input type='text' id='nameInput' value='" + UtilText.parseForHTMLDisplay(cellToInspect.getPlace().getName()) + "' style='width:100%; margin:0; padding:0;'></form><div class='SM-button' id='rename_room_button' style='float:left; width:15%; height:22px; line-height:22px; margin:0; padding:0;'>&#10003;</div></div><div style='width:20%; float:left; margin:0; padding:0;'>");
                int i = 0;
                List<NPC> occupants = Main.game.getCharactersTreatingCellAsHome(cellToInspect);
                for (NPC occupant : occupants) {
                    if (!occupant.isSlave()) continue;
                    UtilText.nodeContentSB.append("<b style='color:" + occupant.getFemininity().getColour().toWebHexString() + ";'>" + occupant.getName(true) + "</b>" + (i + 1 == occupants.size() ? "" : "<br/>"));
                    ++i;
                }
                if (i == 0) {
                    UtilText.nodeContentSB.append("<b style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u7a7a\u95f2</b>");
                }
                UtilText.nodeContentSB.append("</div><div style='float:left; width:15%; margin:0; padding:0;'>" + i + "/" + place.getCapacity() + "</div><div style='float:left; width:15%; margin:0; padding:0;'><span style='color:" + (affectionChange == 0.0f ? PresetColour.BASE_GREY : (affectionChange > 0.0f ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_BAD)).toWebHexString() + ";'>" + (affectionChange > 0.0f ? "+" : "") + decimalFormat.format(affectionChange) + "</span>/\u5c0f\u65f6</div><div style='float:left; width:15%; margin:0; padding:0;'><span style='color:" + (obedienceChange == 0.0f ? PresetColour.BASE_GREY : (obedienceChange > 0.0f ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_BAD)).toWebHexString() + ";'>" + (obedienceChange > 0.0f ? "+" : "") + decimalFormat.format(obedienceChange) + "</span>/\u5c0f\u65f6</div><div style='float:left; width:15%; margin:0; padding:0;'>" + (place.getUpkeep() > 0 ? UtilText.formatAsMoney(-place.getUpkeep(), "span", PresetColour.GENERIC_BAD) : UtilText.formatAsMoney(-place.getUpkeep(), "span", PresetColour.GENERIC_GOOD)) + "/\u5929</div></div></div>");
                UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><h6 style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + "; text-align:center;'>\u6539\u9020</h6>" + OccupantManagementDialogue.getRoomUpgradeHeader());
                ArrayList<AbstractPlaceUpgrade> coreUpgrades = new ArrayList<AbstractPlaceUpgrade>();
                for (AbstractPlaceUpgrade upgrade : place.getPlaceType().getAvailablePlaceUpgrades(place.getPlaceUpgrades())) {
                    if (!upgrade.getAvailability(cellToInspect).getKey().booleanValue() && upgrade.getAvailability(cellToInspect).getValue().isEmpty()) continue;
                    if (upgrade.isCoreRoomUpgrade()) {
                        coreUpgrades.add(upgrade);
                        continue;
                    }
                    UtilText.nodeContentSB.append(OccupantManagementDialogue.getUpgradeEntry(cellToInspect, upgrade));
                    ++i;
                }
                if (i == 0) {
                    UtilText.nodeContentSB.append("<div class='container-full-width inner' style='background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'><b style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u65e0\u6539\u9020\u53ef\u7528</b></div>");
                }
                UtilText.nodeContentSB.append("</div>");
                UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><h6 style='color:" + PresetColour.GENERIC_ARCANE.toWebHexString() + "; text-align:center;'>\u6838\u5fc3\u6539\u9020</h6><p><i>\u8d2d\u4e70[style.boldArcane(\u6838\u5fc3\u6539\u9020)]\u4f1a\u79fb\u9664\u5f53\u524d\u623f\u95f4\u4f59\u4e0b\u7684[style.boldBad(\u6240\u6709)]\u6539\u9020\uff01</i></p>" + OccupantManagementDialogue.getRoomUpgradeHeader());
                i = 0;
                for (AbstractPlaceUpgrade upgrade : coreUpgrades) {
                    UtilText.nodeContentSB.append(OccupantManagementDialogue.getUpgradeEntry(cellToInspect, upgrade));
                    ++i;
                }
                if (i == 0) {
                    UtilText.nodeContentSB.append("<div class='container-full-width inner' style='background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'><b style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u65e0\u53ef\u7528\u7684\u5173\u952e\u4fee\u6539</b></div>");
                }
                UtilText.nodeContentSB.append("</div><p id='hiddenFieldName' style='display:none;'></p>");
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 5) {
                    if (Main.game.getOccupancyUtil().getGeneratedBalance() == 0) {
                        return new Response("\u6536\u96c6\uff1a" + UtilText.formatAsMoneyUncoloured(Main.game.getOccupancyUtil().getGeneratedBalance(), "span"), "\u4f60\u5f53\u524d\u7684\u7ed3\u4f59\u4e3a0\u2026\u2026", null);
                    }
                    if (Main.game.getOccupancyUtil().getGeneratedBalance() > 0) {
                        return new Response("\u6536\u96c6\uff1a" + UtilText.formatAsMoney(Main.game.getOccupancyUtil().getGeneratedBalance(), "span"), "\u6536\u96c6\u901a\u8fc7\u5974\u96b6\u6d3b\u52a8\u8d5a\u5f97\u7684\u91d1\u94b1\u3002", ROOM_UPGRADES){

                            @Override
                            public DialogueNode getNextDialogue() {
                                return Main.game.getCurrentDialogueNode();
                            }

                            @Override
                            public void effects() {
                                Main.game.getOccupancyUtil().payOutBalance();
                            }
                        };
                    }
                    if (Main.game.getPlayer().getMoney() < (long)Math.abs(Main.game.getOccupancyUtil().getGeneratedBalance())) {
                        return new Response("\u652f\u4ed8: " + UtilText.formatAsMoneyUncoloured(Math.abs(Main.game.getOccupancyUtil().getGeneratedBalance()), "span"), "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u94b1\u6765\u507f\u8fd8\u7ef4\u62a4\u5974\u96b6\u548c\u623f\u95f4\u6240\u79ef\u7d2f\u7684\u503a\u52a1\u3002", null);
                    }
                    return new Response("\u652f\u4ed8: " + UtilText.formatAsMoney(Math.abs(Main.game.getOccupancyUtil().getGeneratedBalance()), "span", PresetColour.GENERIC_BAD), "\u652f\u4ed8\u7531\u7ef4\u62a4\u5974\u96b6\u548c\u623f\u95f4\u6240\u79ef\u7d2f\u7684\u503a\u52a1\u3002", ROOM_UPGRADES){

                        @Override
                        public DialogueNode getNextDialogue() {
                            return Main.game.getCurrentDialogueNode();
                        }

                        @Override
                        public void effects() {
                            Main.game.getOccupancyUtil().payOutBalance();
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u4e0a\u4e00\u754c\u9762\u3002", ROOM_UPGRADES){

                        @Override
                        public DialogueNode getNextDialogue() {
                            return Main.game.getDefaultDialogue(false);
                        }
                    };
                }
                return null;
            }
        };
        purchaseAvailability = new StringBuilder();
        SLAVE_LIST = new DialogueNode("\u7ba1\u7406\u5974\u96b6&\u53cb\u4eba\u4f4f\u5ba2", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getContent() {
                void var4_14;
                OccupantSortingMethod[] npcsPresent;
                UtilText.nodeContentSB.setLength(0);
                if (Main.game.getDialogueFlags().getSlaveTrader() != null) {
                    UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><h6 style='color:" + PresetColour.CURRENCY_GOLD.toWebHexString() + "; text-align:center;'>\u5974\u96b6\u51fa\u552e</h6>" + OccupantManagementDialogue.getSlaveryHeader());
                    i = 0;
                    npcsPresent = new ArrayList<NPC>(Main.game.getCharactersTreatingCellAsHome(Main.game.getPlayerCell()));
                    npcsPresent.removeIf(npc -> !npc.isSlave());
                    for (NPC nPC : npcsPresent) {
                        if (nPC.getOwner().isPlayer()) continue;
                        affection = AffectionLevel.getAffectionLevelFromValue(nPC.getAffection(Main.game.getPlayer()));
                        obedience = ObedienceLevel.getObedienceLevelFromValue(nPC.getObedienceValue());
                        affectionChange = nPC.getDailyAffectionChange();
                        obedienceChange = nPC.getDailyObedienceChange();
                        place = Main.game.getPlayerCell().getPlace();
                        UtilText.nodeContentSB.append(OccupantManagementDialogue.getSlaveryEntry(false, place, nPC, affection, affectionChange, obedience, obedienceChange, i % 2 == 0));
                        ++i;
                    }
                    if (i == 0) {
                        UtilText.nodeContentSB.append("<div class='container-full-width inner'><h4 style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u6ca1\u6709\u5974\u96b6\u51fa\u552e\uff01</h4></div>");
                    }
                    UtilText.nodeContentSB.append("</div>");
                } else {
                    UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><h6 style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + "; text-align:center;'>\u53cb\u4eba\u4f4f\u5ba2</h6>" + OccupantManagementDialogue.getOccupantHeader());
                    if (Main.game.getPlayer().getFriendlyOccupants().isEmpty()) {
                        UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><p style='color:" + PresetColour.BASE_GREY.toWebHexString() + ";'>\u6ca1\u6709\u4eba\u8ddf\u4f60\u4f4f\u5728\u4e00\u8d77\u2026\u2026</p></div>");
                    } else {
                        i = 0;
                        for (String id : Main.game.getPlayer().getFriendlyOccupants()) {
                            try {
                                NPC nPC = (NPC)Main.game.getNPCById(id);
                                if (nPC.getHomeWorldLocation() == WorldType.DOMINION) continue;
                                affection = AffectionLevel.getAffectionLevelFromValue(nPC.getAffection(Main.game.getPlayer()));
                                obedience = ObedienceLevel.getObedienceLevelFromValue(nPC.getObedienceValue());
                                affectionChange = nPC.getDailyAffectionChange();
                                obedienceChange = nPC.getDailyObedienceChange();
                                place = Main.game.getPlayerCell().getPlace();
                                UtilText.nodeContentSB.append(OccupantManagementDialogue.getOccupantEntry(place, nPC, affection, affectionChange, obedience, obedienceChange, i % 2 == 0));
                                ++i;
                            }
                            catch (Exception exception) {
                                Util.logGetNpcByIdError("SLAVE_LIST.getResponse()", id);
                            }
                        }
                    }
                    UtilText.nodeContentSB.append("</div>");
                }
                UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><h6 style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + "; text-align:center;'>\u62e5\u6709\u7684\u5974\u96b6</h6>");
                String buttonStyle = "margin:2px; width:16%;";
                UtilText.nodeContentSB.append("<div class='container-full-width inner' style='text-align:center'>");
                UtilText.nodeContentSB.append("<div style='width:100%;font-weight:bold;margin-top:8px'>\u6392\u5e8f</div>");
                npcsPresent = OccupantSortingMethod.values();
                int id = npcsPresent.length;
                boolean bl = false;
                while (var4_14 < id) {
                    OccupantSortingMethod method = npcsPresent[var4_14];
                    UtilText.nodeContentSB.append("<div id='SORT_SLAVES_BY_" + method.toString() + "' class='normal-button" + (sortingMethod == method ? " selected" : "") + "' style='" + buttonStyle + "'>" + Util.capitaliseSentence(method.getName()) + "</div>");
                    ++var4_14;
                }
                UtilText.nodeContentSB.append("<div style='width:100%; height:0;'></div>");
                UtilText.nodeContentSB.append("<div id='SORT_SLAVES_ASC' class='normal-button" + (!reverseSortSlaves ? " selected" : "") + "' style='" + buttonStyle + "'>\u5347\u5e8f</div>");
                UtilText.nodeContentSB.append("<div id='SORT_SLAVES_DESC' class='normal-button" + (reverseSortSlaves ? " selected" : "") + "' style='" + buttonStyle + "'>\u964d\u5e8f</div>");
                UtilText.nodeContentSB.append("</div>");
                UtilText.nodeContentSB.append(OccupantManagementDialogue.getSlaveryHeader());
                if (Main.game.getPlayer().getSlavesOwned().isEmpty()) {
                    UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><p style='color:" + PresetColour.BASE_GREY.toWebHexString() + ";'>\u4f60\u8fd8\u6ca1\u62e5\u6709\u4efb\u4f55\u5974\u96b6\u2026\u2026</p></div>");
                } else {
                    void var4_22;
                    int i = 0;
                    List slaves = Main.game.getPlayer().getSlavesOwned().stream().filter(npcid -> Main.game.isCharacterExisting((String)npcid)).map(npcid -> {
                        try {
                            return (NPC)Main.game.getNPCById((String)npcid);
                        }
                        catch (Exception e) {
                            System.err.println("Main.game.getNPCById(" + npcid + ") returning null in: SLAVE_LIST.getContent()");
                            return null;
                        }
                    }).filter(npc -> npc != null).collect(Collectors.toList());
                    Object var4_15 = null;
                    switch (sortingMethod) {
                        case NAME: {
                            SlaveNameComparator slaveNameComparator = new SlaveNameComparator();
                            break;
                        }
                        case ROOM: {
                            SlaveRoomComparator slaveRoomComparator = new SlaveRoomComparator();
                            break;
                        }
                        case VALUE: {
                            SlaveValueComparator slaveValueComparator = new SlaveValueComparator();
                            break;
                        }
                        case FEMININITY: {
                            SlaveFemininityComparator slaveFemininityComparator = new SlaveFemininityComparator();
                            break;
                        }
                        case RACE: {
                            SlaveRaceComparator slaveRaceComparator = new SlaveRaceComparator();
                            break;
                        }
                        case NONE: {
                            Object var4_21 = null;
                        }
                    }
                    if (var4_22 != null) {
                        void var4_24;
                        if (reverseSortSlaves) {
                            Comparator comparator = Collections.reverseOrder(var4_22);
                        }
                        Collections.sort(slaves, var4_24);
                    }
                    for (NPC slave : slaves) {
                        AffectionLevel affection = AffectionLevel.getAffectionLevelFromValue(slave.getAffection(Main.game.getPlayer()));
                        ObedienceLevel obedience = ObedienceLevel.getObedienceLevelFromValue(slave.getObedienceValue());
                        float affectionChange = slave.getDailyAffectionChange();
                        float obedienceChange = slave.getDailyObedienceChange();
                        GenericPlace place = Main.game.getPlayerCell().getPlace();
                        UtilText.nodeContentSB.append(OccupantManagementDialogue.getSlaveryEntry(true, place, slave, affection, affectionChange, obedience, obedienceChange, i % 2 == 0));
                        ++i;
                    }
                }
                UtilText.nodeContentSB.append("</div>");
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getResponseTabTitle(int index) {
                if (index == 0) {
                    return UtilText.parse("[style.colourCompanion(\u7ba1\u7406)]", new ParserTag[0]);
                }
                if (index == 1 && (Main.game.getCurrentDialogueNode() == CompanionManagement.SLAVE_MANAGEMENT_JOBS || Main.game.getCurrentDialogueNode() == CompanionManagement.SLAVE_MANAGEMENT_PERMISSIONS)) {
                    return UtilText.parse("[style.colourBlueLight(\u66f4\u6539\u5974\u96b6)]", new ParserTag[0]);
                }
                return null;
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (responseTab == 0) {
                    return CompanionManagement.getManagementResponses(index);
                }
                List slaves = Main.game.getPlayer().getSlavesOwned().stream().filter(npcid -> Main.game.isCharacterExisting((String)npcid)).map(npcid -> {
                    try {
                        return (NPC)Main.game.getNPCById((String)npcid);
                    }
                    catch (Exception e) {
                        System.err.println("Main.game.getNPCById(" + npcid + ") returning null in: SLAVE_LIST.getResponse()");
                        return null;
                    }
                }).filter(npc -> npc != null).collect(Collectors.toList());
                Comparator<NPC> ssm = null;
                switch (sortingMethod) {
                    case NAME: {
                        ssm = new SlaveNameComparator();
                        break;
                    }
                    case ROOM: {
                        ssm = new SlaveRoomComparator();
                        break;
                    }
                    case VALUE: {
                        ssm = new SlaveValueComparator();
                        break;
                    }
                    case FEMININITY: {
                        ssm = new SlaveFemininityComparator();
                        break;
                    }
                    case RACE: {
                        ssm = new SlaveRaceComparator();
                        break;
                    }
                    case NONE: {
                        ssm = null;
                    }
                }
                if (ssm != null) {
                    if (reverseSortSlaves) {
                        ssm = Collections.reverseOrder(ssm);
                    }
                    Collections.sort(slaves, ssm);
                }
                int i = 0;
                for (final NPC slave : slaves) {
                    if (++i != index) continue;
                    return new Response(UtilText.parse((GameCharacter)slave, "<span style='color:" + slave.getFemininity().getColour().toWebHexString() + ";'>[npc.Name]</span>", new ParserTag[0]), UtilText.parse((GameCharacter)slave, "\u9009\u62e9[npc.name]\u2014\u2014\u4f60\u7684[npc.raceFull(true)]\u5974\u96b6\u3002", new ParserTag[0]), Main.game.getCurrentDialogueNode()){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setManagementCompanion(slave);
                        }
                    };
                }
                if (index == 0) {
                    return CompanionManagement.getManagementResponses(index);
                }
                return null;
            }
        };
        SLAVE_LIST_MANAGEMENT = new DialogueNode("\u5974\u96b6\u7ba1\u7406", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getContent() {
                return SLAVE_LIST.getContent();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    if (Main.game.getCurrentDialogueNode() == SLAVE_LIST_MANAGEMENT) {
                        return new Response("\u8fd4\u56de", "\u9000\u51fa\u5974\u96b6\u7ba1\u7406\u754c\u9762\u3002", dialogueToExitTo == null ? OCCUPANT_OVERVIEW : dialogueToExitTo);
                    }
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u5230\u7ba1\u7406\u754c\u9762\u3002", SLAVE_LIST_MANAGEMENT);
                }
                if (Main.game.getDialogueFlags().getSlaveTrader() == null) {
                    return SLAVE_LIST.getResponse(responseTab, index);
                }
                return null;
            }
        };
    }
}

