/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.encounters;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.dominion.EnforcerPatrol;
import com.lilithsthrone.game.character.npc.misc.NPCOffspring;
import com.lilithsthrone.game.character.npc.misc.OffspringSeed;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.dialogue.DialogueManager;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.encounters.Encounter;
import com.lilithsthrone.game.dialogue.encounters.EncounterType;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJob;
import com.lilithsthrone.game.occupantManagement.slave.SlavePermissionSetting;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public abstract class AbstractEncounter {
    protected static AbstractCoreItem randomItem;
    protected static final double INCEST_ENCOUNTER_RATE = (double)0.2f;
    protected static Map<String, List<AbstractEncounter>> additionalPlaceTypeEncounters;
    private boolean mod;
    private boolean fromExternalFile;
    private String author;
    private List<String> placeTypeIds;
    private List<ExternalEncounterData> possibleEncounters;

    protected static double IncestEncounterRate() {
        return 0.2f;
    }

    public AbstractEncounter() {
    }

    public AbstractEncounter(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.author = author;
                this.placeTypeIds = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("additionalPlaceTypeTriggers").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("additionalPlaceTypeTriggers").getAllOf("placeType")) {
                        this.placeTypeIds.add(e.getTextContent());
                    }
                }
                this.possibleEncounters = new ArrayList<ExternalEncounterData>();
                for (Element e : coreElement.getMandatoryFirstOf("possibleEncounters").getAllOf("encounter")) {
                    String name = e.getMandatoryFirstOf("name").getTextContent();
                    String chanceToTrigger = e.getMandatoryFirstOf("chanceToTrigger").getTextContent();
                    boolean opportunistic = Boolean.valueOf(e.getMandatoryFirstOf("chanceToTrigger").getAttribute("opportunisticEncounter").trim());
                    String dialogueId = e.getMandatoryFirstOf("dialogueReturned").getTextContent();
                    ExternalEncounterData data = new ExternalEncounterData(name, chanceToTrigger, opportunistic, dialogueId);
                    this.possibleEncounters.add(data);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("WorldType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getId() {
        return Encounter.getIdFromEncounter(this);
    }

    protected static void spawnEnforcers() {
        List<List<String>> savedEnforcerIds = Main.game.getSavedEnforcers(WorldType.DOMINION);
        Main.game.getDialogueFlags().setSavedLong("enforcer_encounter_minutes", Main.game.getMinutesPassed());
        float chanceOfNewEnforcers = 1.0f - 0.25f * (float)savedEnforcerIds.size();
        if (Math.random() < (double)chanceOfNewEnforcers) {
            try {
                ArrayList<String> enforcerIds = new ArrayList<String>();
                EnforcerPatrol npc = new EnforcerPatrol(Occupation.NPC_ENFORCER_PATROL_CONSTABLE, Gender.getGenderFromUserPreferences(false, false));
                Main.game.addNPC(npc, false);
                npc.setLevel(9 + Util.random.nextInt(4));
                npc.setWeapons("dsg_eep_pbweap_pbpistol");
                enforcerIds.add(npc.getId());
                EnforcerPatrol npc2 = new EnforcerPatrol(Occupation.NPC_ENFORCER_PATROL_CONSTABLE, Gender.getGenderFromUserPreferences(false, false));
                Main.game.addNPC(npc2, false);
                npc2.setLevel(4 + Util.random.nextInt(5));
                npc2.setWeapons("dsg_eep_taser_taser");
                enforcerIds.add(npc2.getId());
                Main.game.addSavedEnforcers(WorldType.DOMINION, enforcerIds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            List<String> enforcerIds = Util.randomItemFrom(savedEnforcerIds);
            for (String id : enforcerIds) {
                try {
                    Main.game.getNPCById(id).setLocation(Main.game.getPlayer(), false);
                }
                catch (Exception e) {
                    System.err.println("Error in Encounter.spawnEnforcers()");
                    e.printStackTrace();
                }
            }
        }
    }

    public static DialogueNode SpawnAndStartChildHere(List<OffspringSeed> offspringAvailable) {
        NPCOffspring offspring = new NPCOffspring(offspringAvailable.get(Util.random.nextInt(offspringAvailable.size())));
        offspring.setLocation(Main.game.getPlayer(), true);
        ((NPC)offspring).equipClothing(EquipClothingSetting.getAllClothingSettings());
        Main.game.setActiveNPC(offspring);
        return Main.game.getActiveNPC().getEncounterDialogue();
    }

    protected static NPC getSlaveWantingToUseYouInDominion() {
        ArrayList<NPC> slaves = new ArrayList<NPC>();
        ArrayList<NPC> hornySlaves = new ArrayList<NPC>();
        for (String id : Main.game.getPlayer().getSlavesOwned()) {
            try {
                NPC slave = (NPC)Main.game.getNPCById(id);
                if (!slave.hasSlavePermissionSetting(SlavePermissionSetting.SEX_INITIATE_PLAYER) || slave.getSlaveJob(Main.game.getHourOfDay()) != SlaveJob.IDLE || slave.getLocationPlace().getPlaceType() == PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION || !slave.hasSlavePermissionSetting(SlavePermissionSetting.GENERAL_OUTSIDE_FREEDOM) || Main.game.getPlayer().getLocationPlace().getPlaceType().isPopulated() && !slave.hasFetish(Fetish.FETISH_EXHIBITIONIST) || !slave.isAttractedTo(Main.game.getPlayer())) continue;
                if (slave.getLastTimeHadSex() + 240L < Main.game.getMinutesPassed()) {
                    slaves.add(slave);
                }
                if (!slave.hasStatusEffect(StatusEffect.PENT_UP_SLAVE)) continue;
                hornySlaves.add(slave);
            }
            catch (Exception e) {
                System.err.println("Main.game.getNPCById(" + id + ") returning null in getSlaveWantingToUseYouInDominion()");
            }
        }
        if (!hornySlaves.isEmpty()) {
            Collections.shuffle(hornySlaves);
            return (NPC)hornySlaves.get(0);
        }
        if (!slaves.isEmpty()) {
            Collections.shuffle(slaves);
            return (NPC)slaves.get(0);
        }
        return null;
    }

    protected static Util.Value<NPC, NPC> getSlaveUsingOtherSlaveInDominion() {
        NPC slave;
        HashMap hornySlaves = new HashMap();
        for (String id : Main.game.getPlayer().getSlavesOwned()) {
            try {
                slave = (NPC)Main.game.getNPCById(id);
                if (!slave.hasSlavePermissionSetting(SlavePermissionSetting.SEX_INITIATE_SLAVES) || slave.getSlaveJob(Main.game.getHourOfDay()) != SlaveJob.IDLE || slave.getLocationPlace().getPlaceType() == PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION || !slave.hasSlavePermissionSetting(SlavePermissionSetting.GENERAL_OUTSIDE_FREEDOM) || slave.getLastTimeHadSex() + 240L >= Main.game.getMinutesPassed()) continue;
                hornySlaves.put(slave, new ArrayList());
            }
            catch (Exception e) {
                System.err.println("Main.game.getNPCById(" + id + ") returning null in getSlaveUsingOtherSlaveInDominion() 1");
            }
        }
        for (String id : Main.game.getPlayer().getSlavesOwned()) {
            try {
                slave = (NPC)Main.game.getNPCById(id);
                if (!slave.hasSlavePermissionSetting(SlavePermissionSetting.SEX_RECEIVE_SLAVES) || slave.getSlaveJob(Main.game.getHourOfDay()) != SlaveJob.IDLE || slave.getLocationPlace().getPlaceType() == PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION || !slave.hasSlavePermissionSetting(SlavePermissionSetting.GENERAL_OUTSIDE_FREEDOM)) continue;
                for (NPC horny : hornySlaves.keySet()) {
                    if (horny.equals(slave) || !horny.isAttractedTo(slave) || !slave.isAttractedTo(horny) && (!horny.hasSlavePermissionSetting(SlavePermissionSetting.SEX_RAPIST) || !horny.isWillingToRape(slave))) continue;
                    ((List)hornySlaves.get(horny)).add(slave);
                }
            }
            catch (Exception e) {
                System.err.println("Main.game.getNPCById(" + id + ") returning null in getSlaveUsingOtherSlaveInDominion() 2");
            }
        }
        ArrayList keys = new ArrayList(hornySlaves.keySet());
        for (NPC key : keys) {
            if (!((List)hornySlaves.get(key)).isEmpty()) continue;
            hornySlaves.remove(key);
        }
        keys = new ArrayList(hornySlaves.keySet());
        if (!hornySlaves.isEmpty()) {
            Collections.shuffle(keys);
            return new Util.Value<NPC, NPC>((NPC)keys.get(0), (NPC)Util.randomItemFrom((List)hornySlaves.get(keys.get(0))));
        }
        return null;
    }

    protected static Util.Value<NPC, NPC> getSlaveUsingOtherSlaveInLilayaCorridor() {
        NPC slave;
        HashMap hornySlaves = new HashMap();
        for (String id : Main.game.getPlayer().getSlavesOwned()) {
            try {
                slave = (NPC)Main.game.getNPCById(id);
                if (!slave.hasSlavePermissionSetting(SlavePermissionSetting.SEX_INITIATE_SLAVES) || (slave.getSlaveJob(Main.game.getHourOfDay()) != SlaveJob.IDLE || slave.getLocationPlace().getPlaceUpgrades().stream().anyMatch(upgrade -> upgrade.getImmobilisationType() != null) || !slave.hasSlavePermissionSetting(SlavePermissionSetting.GENERAL_HOUSE_FREEDOM)) && slave.getSlaveJob(Main.game.getHourOfDay()) != SlaveJob.CLEANING || slave.getLocationPlace().getPlaceType() == PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION || slave.getLastTimeHadSex() + 240L >= Main.game.getMinutesPassed()) continue;
                hornySlaves.put(slave, new ArrayList());
            }
            catch (Exception e) {
                System.err.println("Main.game.getNPCById(" + id + ") returning null in getSlaveUsingOtherSlaveInLilayaCorridor() 1");
            }
        }
        for (String id : Main.game.getPlayer().getSlavesOwned()) {
            try {
                slave = (NPC)Main.game.getNPCById(id);
                if (!slave.hasSlavePermissionSetting(SlavePermissionSetting.SEX_RECEIVE_SLAVES) || (slave.getSlaveJob(Main.game.getHourOfDay()) != SlaveJob.IDLE || slave.getLocationPlace().getPlaceUpgrades().stream().anyMatch(upgrade -> upgrade.getImmobilisationType() != null) || !slave.hasSlavePermissionSetting(SlavePermissionSetting.GENERAL_HOUSE_FREEDOM)) && slave.getSlaveJob(Main.game.getHourOfDay()) != SlaveJob.CLEANING || slave.getLocationPlace().getPlaceType() == PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION) continue;
                for (NPC horny : hornySlaves.keySet()) {
                    if (horny.equals(slave) || !horny.isAttractedTo(slave) || !slave.isAttractedTo(horny) && (!horny.hasSlavePermissionSetting(SlavePermissionSetting.SEX_RAPIST) || !horny.isWillingToRape(slave))) continue;
                    ((List)hornySlaves.get(horny)).add(slave);
                }
            }
            catch (Exception e) {
                System.err.println("Main.game.getNPCById(" + id + ") returning null in getSlaveUsingOtherSlaveInLilayaCorridor() 2");
            }
        }
        ArrayList keys = new ArrayList(hornySlaves.keySet());
        for (NPC key : keys) {
            if (!((List)hornySlaves.get(key)).isEmpty()) continue;
            hornySlaves.remove(key);
        }
        keys = new ArrayList(hornySlaves.keySet());
        if (!hornySlaves.isEmpty()) {
            Collections.shuffle(keys);
            return new Util.Value<NPC, NPC>((NPC)keys.get(0), (NPC)Util.randomItemFrom((List)hornySlaves.get(keys.get(0))));
        }
        return null;
    }

    protected abstract DialogueNode initialiseEncounter(EncounterType var1);

    public abstract Map<EncounterType, Float> getDialogues();

    public boolean isAnyEncounterAvailable() {
        return this.getBaseRandomEncounter(true) != null;
    }

    public DialogueNode getRandomEncounter(boolean forceEncounter) {
        return this.getBaseRandomEncounter(forceEncounter);
    }

    public boolean isAnyBaseTriggerChanceOverOneHundred() {
        if (this.isFromExternalFile()) {
            for (ExternalEncounterData data : this.possibleEncounters) {
                if (!(data.getTriggerChance() > 100.0f)) continue;
                return true;
            }
        } else {
            for (Map.Entry<EncounterType, Float> e : this.getDialogues().entrySet()) {
                if (!(e.getValue().floatValue() > 100.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public float getTotalChanceValue() {
        float total = 0.0f;
        if (this.isFromExternalFile()) {
            for (ExternalEncounterData data : this.possibleEncounters) {
                float weighting = data.getTriggerChance();
                total += weighting;
            }
        } else {
            for (Map.Entry<EncounterType, Float> e : this.getDialogues().entrySet()) {
                float weighting = e.getValue().floatValue();
                total += weighting;
            }
        }
        return total;
    }

    private void setEncounterDialogue(DialogueNode dialogueNode, boolean forced) {
        if (forced) {
            Main.game.forcedEncounterAtSeconds = new Util.Value<Long, DialogueNode>(Main.game.getSecondsPassed(), dialogueNode);
        } else {
            Main.game.encounterAtSeconds = new Util.Value<Long, DialogueNode>(Main.game.getSecondsPassed(), dialogueNode);
        }
    }

    protected DialogueNode getBaseRandomEncounter(boolean forceEncounter) {
        if (forceEncounter) {
            if (Main.game.forcedEncounterAtSeconds.getKey().longValue() == Main.game.getSecondsPassed()) {
                return Main.game.forcedEncounterAtSeconds.getValue();
            }
        } else if (Main.game.encounterAtSeconds.getKey().longValue() == Main.game.getSecondsPassed()) {
            return Main.game.encounterAtSeconds.getValue();
        }
        float opportunisticMultiplier = 1.0f;
        if (Main.game.isOpportunisticAttackersEnabled()) {
            opportunisticMultiplier += Main.game.getPlayer().getLust() / 200.0f;
            opportunisticMultiplier += 0.25f - Main.game.getPlayer().getHealthPercentage() * 0.25f;
            if (Main.game.getPlayer().hasStatusEffect(StatusEffect.BODY_CUM) || Main.game.getPlayer().hasStatusEffect(StatusEffect.BODY_CUM_MASOCHIST)) {
                opportunisticMultiplier += 0.25f;
            }
            if (Main.game.getPlayer().hasStatusEffect(StatusEffect.CLOTHING_CUM) || Main.game.getPlayer().hasStatusEffect(StatusEffect.CLOTHING_CUM_MASOCHIST)) {
                opportunisticMultiplier += 0.25f;
            }
            if (!Collections.disjoint(Util.newArrayListOfValues(StatusEffect.EXPOSED_PLUS_BREASTS, StatusEffect.FETISH_EXHIBITIONIST_PLUS_BREASTS), Main.game.getPlayer().getStatusEffects())) {
                opportunisticMultiplier += 0.75f;
            } else if (!Collections.disjoint(Util.newArrayListOfValues(StatusEffect.EXPOSED, StatusEffect.EXPOSED_BREASTS, StatusEffect.FETISH_EXHIBITIONIST, StatusEffect.FETISH_EXHIBITIONIST_BREASTS), Main.game.getPlayer().getStatusEffects())) {
                opportunisticMultiplier += 0.5f;
            }
            if (!Collections.disjoint(Util.newArrayListOfValues(StatusEffect.DRUNK_3, StatusEffect.DRUNK_4, StatusEffect.DRUNK_5), Main.game.getPlayer().getStatusEffects())) {
                opportunisticMultiplier += 0.5f;
            }
        }
        if (this.isFromExternalFile()) {
            boolean debugText = false;
            if (debugText) {
                System.out.println("--- Encounter Generation Start ---");
            }
            float total = 0.0f;
            float opportunisticIncrease = 0.0f;
            HashMap<ExternalEncounterData, Float> finalMap = new HashMap<ExternalEncounterData, Float>();
            for (ExternalEncounterData data : this.possibleEncounters) {
                float weighting = data.getTriggerChance();
                if (this.isAnyBaseTriggerChanceOverOneHundred() && !(data.getTriggerChance() > 100.0f)) continue;
                if (data.isOpportunistic()) {
                    weighting *= opportunisticMultiplier;
                    opportunisticIncrease += opportunisticMultiplier;
                }
                total += weighting;
                finalMap.put(data, Float.valueOf(weighting));
                if (!debugText) continue;
                System.out.println("Weighting add: " + weighting + " (" + data.getName() + ")");
            }
            if (total == 0.0f) {
                this.setEncounterDialogue(null, forceEncounter);
                return null;
            }
            if (debugText) {
                System.out.println("Final total: " + total);
                System.out.println("Final opportunisticIncrease: " + opportunisticIncrease);
            }
            if (forceEncounter || Math.random() * (double)(100.0f + opportunisticIncrease) < (double)total) {
                DialogueNode dn = null;
                for (int tries = 0; dn == null && tries <= 3; ++tries) {
                    ExternalEncounterData encounter = (ExternalEncounterData)Util.getRandomObjectFromWeightedFloatMap(finalMap);
                    finalMap.remove(encounter);
                    dn = DialogueManager.getDialogueFromId(UtilText.parse(encounter.getDialogueId(), new ParserTag[0]).trim());
                }
                if (dn != null) {
                    if (debugText) {
                        System.out.println("Returning: " + dn.getId());
                        System.out.println("--- END ---");
                    }
                    this.setEncounterDialogue(dn, forceEncounter);
                    return dn;
                }
            }
            if (debugText) {
                System.out.println("--- END ---");
            }
        } else {
            boolean debugText = false;
            if (debugText) {
                System.out.println("--- Encounter Generation Start ---");
            }
            float total = 0.0f;
            float opportunisticIncrease = 0.0f;
            HashMap<EncounterType, Float> finalMap = new HashMap<EncounterType, Float>();
            for (Map.Entry<EncounterType, Float> e : this.getDialogues().entrySet()) {
                float weighting = e.getValue().floatValue();
                if (this.isAnyBaseTriggerChanceOverOneHundred() && !(weighting > 100.0f)) continue;
                if (e.getKey().isOpportunistic()) {
                    weighting *= opportunisticMultiplier;
                    opportunisticIncrease += opportunisticMultiplier;
                }
                total += weighting;
                finalMap.put(e.getKey(), Float.valueOf(weighting));
                if (!debugText) continue;
                System.out.println("Weighting add: " + weighting + " (" + e.getKey().name() + ")");
            }
            if (total == 0.0f) {
                this.setEncounterDialogue(null, forceEncounter);
                return null;
            }
            if (debugText) {
                System.out.println("Final total: " + total);
                System.out.println("Final opportunisticIncrease: " + opportunisticIncrease);
            }
            if (forceEncounter || Math.random() * (double)(100.0f + opportunisticIncrease) < (double)total) {
                DialogueNode dn = null;
                for (int tries = 0; dn == null && tries <= 3; ++tries) {
                    Object encounter = (EncounterType)((Object)Util.getRandomObjectFromWeightedFloatMap(finalMap));
                    finalMap.remove(encounter);
                    dn = this.initialiseEncounter((EncounterType)((Object)encounter));
                }
                if (dn != null) {
                    if (debugText) {
                        System.out.println("Returning: " + dn.getLabel());
                        System.out.println("--- END ---");
                    }
                    this.setEncounterDialogue(dn, forceEncounter);
                    return dn;
                }
            }
            if (debugText) {
                System.out.println("--- END ---");
            }
        }
        return null;
    }

    public static AbstractCoreItem getRandomItem() {
        return randomItem;
    }

    public List<String> getPlaceTypeIds() {
        return this.placeTypeIds;
    }

    public static Response exploreArea() {
        return AbstractEncounter.exploreArea("\u8be5\u533a\u57df");
    }

    public static Response exploreArea(String areaDescription) {
        return new ResponseEffectsOnly("\u63a2\u7d22", "\u63a2\u7d22" + areaDescription + "\u3002\u5c3d\u7ba1\u4f60\u89c9\u5f97\u4e0d\u592a\u53ef\u80fd\u627e\u5230\u4ec0\u4e48\u4e1c\u897f\uff0c\u4f46\u81f3\u5c11\u4e0d\u7528\u65e0\u6240\u4e8b\u4e8b\u5730\u6765\u56de\u6643\u60a0\u4e86\u2026\u2026"){

            @Override
            public int getSecondsPassed() {
                return 1800;
            }

            @Override
            public void effects() {
                DialogueNode dn = Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getDialogue(true, true);
                Main.game.setContent(new Response("", "", dn));
            }
        };
    }

    public static Response useOffspringMap() {
        if (!Main.game.getPlayer().hasItemType(ItemType.OFFSPRING_MAP)) {
            return new Response("\u540e\u4ee3\u5730\u56fe", UtilText.parse("\u4f60\u6ca1\u6709\u540e\u4ee3\u5730\u56fe...<br/><i>\u540e\u4ee3\u5730\u56fe\u53ef\u4ee5\u5411\u5e02\u653f\u5385\u7684[vanessa.name]\u8d2d\u4e70\u3002</i>", new ParserTag[0]), null);
        }
        if (!ItemType.OFFSPRING_MAP.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
            return new Response("\u540e\u4ee3\u5730\u56fe", ItemType.OFFSPRING_MAP.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
        }
        return new ResponseEffectsOnly("\u540e\u4ee3\u5730\u56fe", ItemType.OFFSPRING_MAP.getUseTooltipDescription(Main.game.getPlayer(), Main.game.getPlayer())){

            @Override
            public void effects() {
                Main.game.getPlayer().useItem(Main.game.getItemGen().generateItem(ItemType.OFFSPRING_MAP), null, false);
            }
        };
    }

    static {
        additionalPlaceTypeEncounters = new HashMap<String, List<AbstractEncounter>>();
    }

    private class ExternalEncounterData {
        private String name;
        private String triggerConditional;
        private boolean opportunistic;
        private String dialogueId;

        public ExternalEncounterData(String name, String triggerConditional, boolean opportunistic, String dialogueId) {
            this.name = name;
            this.triggerConditional = triggerConditional;
            this.opportunistic = opportunistic;
            this.dialogueId = dialogueId;
        }

        public float getTriggerChance() {
            try {
                return Float.valueOf(UtilText.parse(this.getTriggerConditional(), new ParserTag[0]).trim()).floatValue();
            }
            catch (Exception ex) {
                System.err.println("Error in AbstractEncounter's ExternalEncounterData: getTriggerChance() for '" + this.getName() + "' failed to parse!");
                ex.printStackTrace();
                return 0.0f;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getTriggerConditional() {
            return this.triggerConditional;
        }

        public boolean isOpportunistic() {
            return this.opportunistic;
        }

        public String getDialogueId() {
            return this.dialogueId;
        }
    }
}

