/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.encounters;

import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.encounters.AbstractEncounter;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;

public class BatCavernsEncounterDialogue {
    public static final DialogueNode FIND_ITEM = new DialogueNode("\u4e22\u5f03\u7684\u7269\u54c1", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.BAT_CAVERN_SLIME_QUEEN_LAIR) || Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.BAT_CAVERN_LIGHT)) {
                if (((AbstractItem)AbstractEncounter.getRandomItem()).getItemType() == ItemType.MUSHROOM) {
                    return UtilText.parseFromXMLFile("places/submission/batCaverns", "FIND_MUSHROOMS_LIGHT") + "<p style='text-align:center;'><b>" + AbstractEncounter.getRandomItem().getDisplayName(true) + "</b></p>";
                }
                return UtilText.parseFromXMLFile("places/submission/batCaverns", "FIND_ITEM_LIGHT") + "<p style='text-align:center;'><b>" + AbstractEncounter.getRandomItem().getDisplayName(true) + "</b></p>";
            }
            if (((AbstractItem)AbstractEncounter.getRandomItem()).getItemType() == ItemType.MUSHROOM) {
                return UtilText.parseFromXMLFile("places/submission/batCaverns", "FIND_MUSHROOMS_DARK") + "<p style='text-align:center;'><b>" + AbstractEncounter.getRandomItem().getDisplayName(true) + "</b></p>";
            }
            return UtilText.parseFromXMLFile("places/submission/batCaverns", "FIND_ITEM_DARK") + "<p style='text-align:center;'><b>" + AbstractEncounter.getRandomItem().getDisplayName(true) + "</b></p>";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u62ff\u8d70", "\u628a" + AbstractEncounter.getRandomItem().getName() + "\u52a0\u5165\u4f60\u7684\u7269\u54c1\u680f\u3002", Main.game.getDefaultDialogue(false)){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(Main.game.getPlayer().addItem((AbstractItem)AbstractEncounter.getRandomItem(), true, true));
                    }
                };
            }
            if (index == 2) {
                return new Response("\u79bb\u5f00", "\u628a" + AbstractEncounter.getRandomItem().getName() + "\u7559\u5728\u5730\u4e0a\u3002", Main.game.getDefaultDialogue(false));
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_DISCOVERED = new DialogueNode("\u5947\u602a\u7684\u62c9\u6746", "", true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getPlayerCell().getPlace().setPlaceType(PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_HANDLE);
            Main.game.getPlayerCell().getPlace().setName(PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_HANDLE.getName());
            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_HANDLE_REFUSED));
        }

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_DISCOVERED");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u62c9\u52a8\u62c9\u6746", "\u80fd\u6709\u4ec0\u4e48\u95ee\u9898\u5462\uff1f", REBEL_BASE_DOOR_NO_PASS);
            }
            if (index == 2) {
                return new Response("\u4e0d\u62c9\u52a8", "\u62c9\u52a8\u6d1e\u7a74\u4e2d\u672a\u77e5\u7684\u62c9\u6746\u4ece\u6765\u4e0d\u4f1a\u53d1\u751f\u4ec0\u4e48\u597d\u4e8b\u3002", PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_HANDLE.getDialogue(false));
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_DOOR_NO_PASS = new DialogueNode("\u5947\u602a\u7684\u62c9\u6746", "", true, true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_PASSWORD_PART_ONE));
        }

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_DOOR_NO_PASS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7528\u529b\u62c9", "\u62c9\u6746\u7eb9\u4e1d\u4e0d\u52a8\uff0c\u770b\u6765\u4f60\u9700\u8981\u4e2a\u5bc6\u7801\u3002", null);
            }
            if (index == 2) {
                return new Response("\u4e0d\u62c9\u52a8", "\u53bb\u5bfb\u627e\u5bc6\u7801\u5427\u3002", PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_HANDLE.getDialogue(false));
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_PASSWORD_ONE = new DialogueNode("\u65e5\u8bb0\u788e\u7247", "", true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_PASSWORD_PART_TWO));
            if (Main.game.getPlayer().getLocationPlace().getPlaceType() == PlaceType.BAT_CAVERN_DARK || Main.game.getPlayer().getLocationPlace().getPlaceType() == PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_HANDLE) {
                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.rebelBaseDarkPassFound, true);
            } else {
                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.rebelBaseLightPassFound, true);
            }
        }

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            if (Main.game.getPlayer().getLocationPlace().getPlaceType() == PlaceType.BAT_CAVERN_LIGHT) {
                sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_DOOR_PASS_LIGHT"));
            } else {
                sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_DOOR_PASS_DARK"));
            }
            sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_DOOR_PASS_ONE"));
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u8fd9\u53ea\u662f\u5bc6\u7801\u7684\u4e00\u90e8\u5206\uff0c\u8fd8\u9700\u8981\u627e\u5230\u5176\u4ed6\u7684", Main.game.getDefaultDialogue(false));
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_PASSWORD_TWO = new DialogueNode("\u53e6\u4e00\u5757\u65e5\u8bb0\u788e\u7247", "", true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_PASSWORD_COMPLETE));
        }

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            if (Main.game.getPlayer().getLocationPlace().getPlaceType() == PlaceType.BAT_CAVERN_LIGHT) {
                sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_DOOR_PASS_LIGHT"));
            } else {
                sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_DOOR_PASS_DARK"));
            }
            sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_DOOR_PASS_TWO"));
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u4f60\u5df2\u7ecf\u627e\u5230\u4e86\u4e24\u90e8\u5206\u5bc6\u7801\uff0c\u51c6\u5907\u597d\u4e4b\u540e\u5c31\u53ef\u4ee5\u56de\u5230\u90a3\u4e2a\u795e\u79d8\u7684\u62c9\u6746\u5904\u4e86\u3002", Main.game.getDefaultDialogue(false));
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_PASSWORD_SEARCH_FAILED = new DialogueNode("\u771f\u4e0d\u5e78", "", false, true){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_DOOR_PASS_SEARCH_FAIL");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_PASSWORD_SILLY = new DialogueNode("\u65f6\u95f4\u5b9d\u8d35", "", false){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_REBEL_BASE, Quest.SIDE_UTIL_COMPLETE));
        }

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_DOOR_PASS_SILLY");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u4f60\u8d62\u4e86\u3002\u4e07\u5c81\u3002", Main.game.getDefaultDialogue(false)){

                    @Override
                    public void effects() {
                        Main.game.getWorlds().get(WorldType.BAT_CAVERNS).getCell(PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_HANDLE).getPlace().setPlaceType(PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_EXTERIOR);
                        Main.game.getWorlds().get(WorldType.BAT_CAVERNS).getCell(PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_EXTERIOR).getPlace().setName(PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_EXTERIOR.getName());
                    }
                };
            }
            return null;
        }
    };
}

