/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.encounters;

import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.valueEnums.BodyMaterial;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.npc.dominion.Cultist;
import com.lilithsthrone.game.character.npc.dominion.DominionAlleywayAttacker;
import com.lilithsthrone.game.character.npc.dominion.DominionSuccubusAttacker;
import com.lilithsthrone.game.character.npc.dominion.HarpyNestsAttacker;
import com.lilithsthrone.game.character.npc.dominion.Lumi;
import com.lilithsthrone.game.character.npc.dominion.RentalMommy;
import com.lilithsthrone.game.character.npc.misc.OffspringSeed;
import com.lilithsthrone.game.character.npc.submission.BatCavernLurkerAttacker;
import com.lilithsthrone.game.character.npc.submission.BatCavernSlimeAttacker;
import com.lilithsthrone.game.character.npc.submission.ImpAttacker;
import com.lilithsthrone.game.character.npc.submission.RebelBaseInsaneSurvivor;
import com.lilithsthrone.game.character.npc.submission.SubmissionAttacker;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.encounters.AbstractEncounter;
import com.lilithsthrone.game.dialogue.encounters.BatCavernsEncounterDialogue;
import com.lilithsthrone.game.dialogue.encounters.DominionEncounterDialogue;
import com.lilithsthrone.game.dialogue.encounters.EncounterType;
import com.lilithsthrone.game.dialogue.encounters.SubmissionEncounterDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.DominionExpressCentaurDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.EnforcerAlleywayDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.SlaveEncountersDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.WesQuest;
import com.lilithsthrone.game.dialogue.places.dominion.DominionPark;
import com.lilithsthrone.game.dialogue.places.dominion.DominionPlaces;
import com.lilithsthrone.game.dialogue.places.submission.ratWarrens.VengarCaptiveDialogue;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJob;
import com.lilithsthrone.game.occupantManagement.slave.SlavePermissionSetting;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.world.Weather;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;
import java.io.File;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Encounter {
    public static AbstractEncounter LILAYAS_HOME_CORRIDOR;
    public static AbstractEncounter LILAYAS_DUNGEON_PASSAGEWAY;
    public static AbstractEncounter DOMINION_STREET;
    public static AbstractEncounter DOMINION_BOULEVARD;
    public static AbstractEncounter DOMINION_ALLEY;
    public static AbstractEncounter DOMINION_DARK_ALLEY;
    public static AbstractEncounter DOMINION_CANAL;
    public static AbstractEncounter DOMINION_EXPRESS;
    public static AbstractEncounter HARPY_NEST_WALKWAYS;
    public static AbstractEncounter HARPY_NEST_LOOK_FOR_TROUBLE;
    public static AbstractEncounter SUBMISSION_TUNNELS;
    public static AbstractEncounter BAT_CAVERN;
    public static AbstractEncounter REBEL_BASE;
    public static AbstractEncounter VENGAR_CAPTIVE_HALL;
    public static AbstractEncounter VENGAR_CAPTIVE_BEDROOM;
    public static AbstractEncounter DOMINION_PARK;
    public static List<AbstractEncounter> allEncounters;
    public static Map<AbstractEncounter, String> encounterToIdMap;
    public static Map<String, AbstractEncounter> idToEncounterMap;
    private static Map<String, List<AbstractEncounter>> addedEncounters;

    public static List<AbstractEncounter> getAddedEncounters(String placeTypeId) {
        addedEncounters.putIfAbsent(placeTypeId, new ArrayList());
        return addedEncounters.get(placeTypeId);
    }

    public static AbstractEncounter getEncounterFromId(String id) {
        id = Util.getClosestStringMatch(id, idToEncounterMap.keySet());
        return idToEncounterMap.get(id);
    }

    public static String getIdFromEncounter(AbstractEncounter encounter) {
        return encounterToIdMap.get(encounter);
    }

    public static List<AbstractEncounter> getAllEncounters() {
        return allEncounters;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var5_21;
        Field[] fieldArray;
        LILAYAS_HOME_CORRIDOR = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                return Util.newHashMapOfValues(Main.game.getCharactersPresent().isEmpty() ? new Util.Value<EncounterType, Float>(EncounterType.SLAVE_USES_YOU, Float.valueOf(5.0f)) : null, Main.game.getCharactersPresent().isEmpty() ? new Util.Value<EncounterType, Float>(EncounterType.SLAVE_USING_OTHER_SLAVE, Float.valueOf(5.0f)) : null);
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                if (node == EncounterType.SLAVE_USES_YOU) {
                    ArrayList<NPC> slaves = new ArrayList<NPC>();
                    ArrayList<NPC> hornySlaves = new ArrayList<NPC>();
                    for (String id : Main.game.getPlayer().getSlavesOwned()) {
                        try {
                            NPC slave2 = (NPC)Main.game.getNPCById(id);
                            if (!slave2.hasSlavePermissionSetting(SlavePermissionSetting.SEX_INITIATE_PLAYER) || slave2.getSlaveJob(Main.game.getHourOfDay()) != SlaveJob.IDLE || slave2.getLocationPlace().getPlaceUpgrades().stream().anyMatch(upgrade -> upgrade.getImmobilisationType() != null) || !slave2.hasSlavePermissionSetting(SlavePermissionSetting.GENERAL_HOUSE_FREEDOM) || !slave2.isAttractedTo(Main.game.getPlayer())) continue;
                            if (slave2.getLastTimeHadSex() + 240L < Main.game.getMinutesPassed()) {
                                slaves.add(slave2);
                            }
                            if (!slave2.hasStatusEffect(StatusEffect.PENT_UP_SLAVE)) continue;
                            hornySlaves.add(slave2);
                        }
                        catch (Exception e) {
                            System.err.println("Main.game.getNPCById(" + id + ") returning null in Encounter.LILAYAS_HOME_CORRIDOR");
                        }
                    }
                    slaves.removeIf(slave -> slave.getWorldLocation() == WorldType.SLAVER_ALLEY);
                    hornySlaves.removeIf(slave -> slave.getWorldLocation() == WorldType.SLAVER_ALLEY);
                    if (!hornySlaves.isEmpty()) {
                        Collections.shuffle(hornySlaves);
                        return SlaveEncountersDialogue.getSlaveUsesYou((NPC)hornySlaves.get(0));
                    }
                    if (!slaves.isEmpty()) {
                        Collections.shuffle(slaves);
                        return SlaveEncountersDialogue.getSlaveUsesYou((NPC)slaves.get(0));
                    }
                    return null;
                }
                if (node == EncounterType.SLAVE_USING_OTHER_SLAVE) {
                    Util.Value<NPC, NPC> slaves = 1.getSlaveUsingOtherSlaveInLilayaCorridor();
                    if (slaves == null || slaves.getKey() == null || slaves.getValue() == null) {
                        return null;
                    }
                    return SlaveEncountersDialogue.getSlaveUsingOtherSlaveLilayaCorridor(slaves);
                }
                return null;
            }
        };
        LILAYAS_DUNGEON_PASSAGEWAY = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                return Util.newHashMapOfValues(Main.game.getCharactersPresent().isEmpty() && Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.getDialogueFlagValueFromId("acexp_dungeon_explored")) ? new Util.Value<EncounterType, Float>(EncounterType.SLAVE_USES_YOU, Float.valueOf(5.0f)) : null);
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                if (node == EncounterType.SLAVE_USES_YOU) {
                    ArrayList<NPC> slaves = new ArrayList<NPC>();
                    ArrayList<NPC> hornySlaves = new ArrayList<NPC>();
                    for (String id : Main.game.getPlayer().getSlavesOwned()) {
                        try {
                            NPC slave2 = (NPC)Main.game.getNPCById(id);
                            if (!slave2.hasSlavePermissionSetting(SlavePermissionSetting.SEX_INITIATE_PLAYER) || slave2.getSlaveJob(Main.game.getHourOfDay()) != SlaveJob.IDLE || slave2.getLocationPlace().getPlaceUpgrades().stream().anyMatch(upgrade -> upgrade.getImmobilisationType() != null) || !slave2.hasSlavePermissionSetting(SlavePermissionSetting.GENERAL_HOUSE_FREEDOM) || !slave2.isAttractedTo(Main.game.getPlayer())) continue;
                            if (slave2.getLastTimeHadSex() + 240L < Main.game.getMinutesPassed()) {
                                slaves.add(slave2);
                            }
                            if (!slave2.hasStatusEffect(StatusEffect.PENT_UP_SLAVE)) continue;
                            hornySlaves.add(slave2);
                        }
                        catch (Exception e) {
                            System.err.println("Main.game.getNPCById(" + id + ") returning null in Encounter.LILAYAS_DUNGEON_PASSAGEWAY");
                        }
                    }
                    slaves.removeIf(slave -> slave.getWorldLocation() == WorldType.SLAVER_ALLEY);
                    hornySlaves.removeIf(slave -> slave.getWorldLocation() == WorldType.SLAVER_ALLEY);
                    if (!hornySlaves.isEmpty()) {
                        Collections.shuffle(hornySlaves);
                        return SlaveEncountersDialogue.getSlaveUsesYouDungeon((NPC)hornySlaves.get(0));
                    }
                    if (!slaves.isEmpty()) {
                        Collections.shuffle(slaves);
                        return SlaveEncountersDialogue.getSlaveUsesYouDungeon((NPC)slaves.get(0));
                    }
                    return null;
                }
                return null;
            }
        };
        DOMINION_STREET = new AbstractEncounter(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Map<EncounterType, Float> getDialogues() {
                boolean cultistAvailable;
                boolean bl = cultistAvailable = Main.game.getCurrentWeather() != Weather.MAGIC_STORM && Main.game.getDateNow().getMonth().equals(Month.OCTOBER) && Main.game.getNumberOfWitches() < 4 && Main.game.getPlayerCell().getPlace().getPlaceType().equals(PlaceType.DOMINION_STREET);
                if (cultistAvailable) {
                    void var4_8;
                    boolean cultistSuitableTile = true;
                    for (GameCharacter gameCharacter : Main.game.getNonCompanionCharactersPresent()) {
                        if (Main.game.getPlayer().getFriendlyOccupants().contains(gameCharacter.getId())) continue;
                        cultistSuitableTile = false;
                        break;
                    }
                    int[][] tileChecks = new int[][]{{-1, 0}, {0, -1}, {0, 1}, {1, 0}};
                    boolean bl2 = false;
                    while (var4_8 < tileChecks.length) {
                        int x = Main.game.getPlayer().getLocation().getX() + tileChecks[var4_8][0];
                        int y = Main.game.getPlayer().getLocation().getY() + tileChecks[var4_8][1];
                        try {
                            List<NPC> chPres = Main.game.getNonCompanionCharactersPresent(Main.game.getActiveWorld().getCell(x, y));
                            if (!chPres.isEmpty() && chPres.stream().anyMatch(c -> c instanceof Cultist)) {
                                cultistSuitableTile = false;
                                break;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++var4_8;
                    }
                    if (!cultistSuitableTile) {
                        cultistAvailable = false;
                    }
                }
                boolean wesQuestAvailable = false;
                if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_WES)) {
                    boolean harpyQuestTimePassed = false;
                    if (Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_HARPY_PACIFICATION)) {
                        if (!Main.game.getDialogueFlags().hasSavedLong("angry_harpies_completed")) {
                            Main.game.getDialogueFlags().setSavedLong("angry_harpies_completed", Main.game.getMinutesPassed());
                        } else {
                            harpyQuestTimePassed = Main.game.getMinutesPassed() - Main.game.getDialogueFlags().getSavedLong("angry_harpies_completed") > 7200L;
                        }
                    }
                    wesQuestAvailable = harpyQuestTimePassed && Main.game.getCurrentWeather() != Weather.MAGIC_STORM && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_C_WOLFS_DEN) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_HARPY_PACIFICATION) && Main.game.getHourOfDay() >= 17 && Main.game.getHourOfDay() <= 21;
                }
                AbstractClothing collar = Main.game.getPlayer().getClothingInSlot(InventorySlot.NECK);
                return Util.newHashMapOfValues(Main.game.getCurrentWeather() == Weather.MAGIC_STORM ? new Util.Value<EncounterType, Float>(EncounterType.DOMINION_STORM_ATTACK, Float.valueOf(15.0f)) : null, cultistAvailable ? new Util.Value<EncounterType, Float>(EncounterType.SPECIAL_DOMINION_CULTIST, Float.valueOf(5.0f)) : null, Main.game.getCurrentWeather() != Weather.MAGIC_STORM && collar != null && collar.getClothingType().getId().equals("innoxia_neck_filly_choker") ? new Util.Value<EncounterType, Float>(EncounterType.DOMINION_EXPRESS_CENTAUR, Float.valueOf(1.0f)) : null, Main.game.getCurrentWeather() != Weather.MAGIC_STORM && 3.getSlaveWantingToUseYouInDominion() != null ? new Util.Value<EncounterType, Float>(EncounterType.SLAVE_USES_YOU, Float.valueOf(5.0f)) : null, wesQuestAvailable ? new Util.Value<EncounterType, Float>(EncounterType.WES_QUEST_START, Float.valueOf(50.0f)) : null, Main.game.getPlayer().getName(false).equalsIgnoreCase("Kinariu") && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.foundHappiness) ? new Util.Value<EncounterType, Float>(EncounterType.DOMINION_STREET_FIND_HAPPINESS, Float.valueOf(10.0f)) : null);
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                NPC slave;
                if (node == EncounterType.DOMINION_STORM_ATTACK) {
                    DominionAlleywayAttacker npc = new DominionAlleywayAttacker(Gender.getGenderFromUserPreferences(false, false), false, NPCGenerationFlag.DIRTY);
                    try {
                        Main.game.addNPC(npc, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    npc.setLocation(Main.game.getPlayer(), true);
                    Main.game.setActiveNPC(npc);
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                if (node == EncounterType.SPECIAL_DOMINION_CULTIST) {
                    Main.game.setActiveNPC(new Cultist());
                    try {
                        Main.game.addNPC(Main.game.getActiveNPC(), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                if (node == EncounterType.DOMINION_EXPRESS_CENTAUR) {
                    return DominionExpressCentaurDialogue.initEncounter();
                }
                if (node == EncounterType.DOMINION_STREET_FIND_HAPPINESS) {
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.foundHappiness, true);
                    return DominionEncounterDialogue.DOMINION_STREET_FIND_HAPPINESS;
                }
                if (node == EncounterType.SLAVE_USES_YOU && (slave = 3.getSlaveWantingToUseYouInDominion()) != null) {
                    return SlaveEncountersDialogue.getSlaveUsesYouStreet(slave);
                }
                if (node == EncounterType.WES_QUEST_START) {
                    return WesQuest.WES_QUEST_START;
                }
                return null;
            }
        };
        DOMINION_BOULEVARD = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                HashMap<EncounterType, Float> dialogueMap = new HashMap<EncounterType, Float>();
                LocalDateTime time = Main.game.getDateNow();
                if (Main.game.getCurrentWeather() != Weather.MAGIC_STORM && time.getMonth().equals(Month.MAY) && time.getDayOfMonth() > 7 && time.getDayOfMonth() <= 14) {
                    if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.mommyFound)) {
                        dialogueMap.put(EncounterType.DOMINION_STREET_RENTAL_MOMMY, Float.valueOf(10.0f));
                    }
                    dialogueMap.put(EncounterType.DOMINION_STREET_PILL_HANDOUT, Float.valueOf(5.0f));
                }
                if (time.getMonth().equals(Month.JUNE) && time.getDayOfMonth() > 14 && time.getDayOfMonth() <= 21) {
                    dialogueMap.put(EncounterType.DOMINION_STREET_PILL_HANDOUT, Float.valueOf(5.0f));
                }
                AbstractClothing collar = Main.game.getPlayer().getClothingInSlot(InventorySlot.NECK);
                if (Main.game.getCurrentWeather() != Weather.MAGIC_STORM && collar != null && collar.getClothingType().getId().equals("innoxia_neck_filly_choker")) {
                    dialogueMap.put(EncounterType.DOMINION_EXPRESS_CENTAUR, Float.valueOf(2.5f));
                }
                if (Main.game.getCurrentWeather() != Weather.MAGIC_STORM && 4.getSlaveWantingToUseYouInDominion() != null) {
                    dialogueMap.put(EncounterType.SLAVE_USES_YOU, Float.valueOf(5.0f));
                }
                return dialogueMap;
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                NPC slave;
                AbstractClothing collar;
                if (node == EncounterType.DOMINION_STREET_RENTAL_MOMMY) {
                    Main.game.setActiveNPC(Main.game.getNpc(RentalMommy.class));
                    Main.game.getNpc(RentalMommy.class).setLocation(WorldType.DOMINION, Main.game.getPlayer().getLocation(), true);
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                if (node == EncounterType.DOMINION_STREET_PILL_HANDOUT) {
                    Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(Main.game.getItemGen().generateItem("innoxia_pills_fertility"), 3 + Util.random.nextInt(4), false, true));
                    return DominionEncounterDialogue.DOMINION_STREET_PILL_HANDOUT;
                }
                if (node == EncounterType.DOMINION_EXPRESS_CENTAUR && (collar = Main.game.getPlayer().getClothingInSlot(InventorySlot.NECK)) != null && collar.getClothingType().getId().equals("innoxia_neck_filly_choker")) {
                    return DominionExpressCentaurDialogue.initEncounter();
                }
                if (node == EncounterType.SLAVE_USES_YOU && (slave = 4.getSlaveWantingToUseYouInDominion()) != null) {
                    return SlaveEncountersDialogue.getSlaveUsesYouStreet(slave);
                }
                return null;
            }
        };
        DOMINION_ALLEY = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                LinkedHashMap<EncounterType, Float> map = Util.newHashMapOfValues(new Util.Value<EncounterType, Float>(EncounterType.DOMINION_FIND_ITEM, Float.valueOf(3.0f)), new Util.Value<EncounterType, Float>(EncounterType.DOMINION_FIND_CLOTHING, Float.valueOf(2.0f)), new Util.Value<EncounterType, Float>(EncounterType.DOMINION_FIND_WEAPON, Float.valueOf(1.0f)), Main.game.getCurrentWeather() != Weather.MAGIC_STORM && 5.getSlaveWantingToUseYouInDominion() != null ? new Util.Value<EncounterType, Float>(EncounterType.SLAVE_USES_YOU, Float.valueOf(5.0f)) : null, Main.game.getCurrentWeather() != Weather.MAGIC_STORM ? new Util.Value<EncounterType, Float>(EncounterType.SLAVE_USING_OTHER_SLAVE, Float.valueOf(5.0f)) : null);
                if (Main.game.isStarted() && DominionPlaces.isCloseToEnforcerHQ()) {
                    map.put(EncounterType.DOMINION_ALLEY_ATTACK, Float.valueOf(10.0f));
                    if (!(Main.game.getCurrentWeather() == Weather.MAGIC_STORM || Main.game.getDialogueFlags().hasSavedLong("enforcer_encounter_minutes") && Main.game.getDialogueFlags().getSavedLong("enforcer_encounter_minutes") + 240L >= Main.game.getMinutesPassed())) {
                        map.put(EncounterType.DOMINION_ALLEY_ENFORCERS, Float.valueOf(15.0f));
                    }
                } else {
                    map.put(EncounterType.DOMINION_ALLEY_ATTACK, Float.valueOf(15.0f));
                    if (!(Main.game.getCurrentWeather() == Weather.MAGIC_STORM || Main.game.getDialogueFlags().hasSavedLong("enforcer_encounter_minutes") && Main.game.getDialogueFlags().getSavedLong("enforcer_encounter_minutes") + 240L >= Main.game.getMinutesPassed())) {
                        map.put(EncounterType.DOMINION_ALLEY_ENFORCERS, Float.valueOf(2.5f));
                    }
                }
                return map;
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                if (node == EncounterType.DOMINION_ALLEY_ATTACK) {
                    List<OffspringSeed> offspringAvailable;
                    ArrayList<NPC> encounterPossibilities = new ArrayList<NPC>(Main.game.getNonCompanionCharactersPresent());
                    encounterPossibilities.removeIf(npc -> npc instanceof Lumi);
                    if (!encounterPossibilities.isEmpty()) {
                        NPC encounterNpc = Util.randomItemFrom(encounterPossibilities);
                        Main.game.setActiveNPC(encounterNpc);
                        return Main.game.getActiveNPC().getEncounterDialogue();
                    }
                    if (Math.random() < 5.IncestEncounterRate() && Main.game.isOffspringEncountersEnabled() && !(offspringAvailable = Main.game.getOffspringNotSpawned(os -> os.getSubspecies() == Subspecies.HALF_DEMON ? os.getHalfDemonSubspecies().isAbleToNaturallySpawnInLocation(WorldType.DOMINION, PlaceType.DOMINION_BACK_ALLEYS) : os.getSubspecies().isAbleToNaturallySpawnInLocation(WorldType.DOMINION, PlaceType.DOMINION_BACK_ALLEYS) || os.getSubspecies() == Subspecies.ANGEL || os.getSubspecies() == Subspecies.FOX_ASCENDANT || os.getSubspecies() == Subspecies.FOX_ASCENDANT_ARCTIC || os.getSubspecies() == Subspecies.FOX_ASCENDANT_FENNEC)).isEmpty()) {
                        return 5.SpawnAndStartChildHere(offspringAvailable);
                    }
                    DominionAlleywayAttacker npc2 = new DominionAlleywayAttacker(Gender.getGenderFromUserPreferences(false, false));
                    try {
                        Main.game.addNPC(npc2, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    npc2.setLocation(Main.game.getPlayer(), true);
                    Main.game.setActiveNPC(npc2);
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                if (node == EncounterType.DOMINION_FIND_ITEM) {
                    randomItem = !Main.game.isSillyModeEnabled() || Math.random() < (double)0.99f ? Main.game.getItemGen().generateItem(ItemType.getDominionAlleywayItems().get(Util.random.nextInt(ItemType.getDominionAlleywayItems().size()))) : (Math.random() < 0.5 ? Main.game.getItemGen().generateItem(ItemType.EGGPLANT) : Main.game.getItemGen().generateItem("innoxia_cheat_unlikely_whammer"));
                    Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addItem((AbstractItem)randomItem);
                    return DominionEncounterDialogue.ALLEY_FIND_ITEM;
                }
                if (node == EncounterType.DOMINION_FIND_CLOTHING) {
                    Main.game.generateAlleywayClothing();
                    randomItem = Main.game.getAlleywayClothing();
                    Main.game.getPlayerCell().getInventory().addClothing((AbstractClothing)randomItem);
                    return DominionEncounterDialogue.ALLEY_FIND_ITEM;
                }
                if (node == EncounterType.DOMINION_FIND_WEAPON) {
                    ArrayList<AbstractWeaponType> weapons = new ArrayList<AbstractWeaponType>(WeaponType.getAllWeapons());
                    weapons.removeIf(w -> !w.getItemTags().contains((Object)ItemTag.DOMINION_ALLEYWAY_SPAWN));
                    randomItem = Main.game.getItemGen().generateWeapon((AbstractWeaponType)weapons.get(Util.random.nextInt(weapons.size())));
                    Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addWeapon((AbstractWeapon)randomItem);
                    return DominionEncounterDialogue.ALLEY_FIND_ITEM;
                }
                if (node == EncounterType.DOMINION_ALLEY_ENFORCERS) {
                    5.spawnEnforcers();
                    return EnforcerAlleywayDialogue.ENFORCER_ALLEYWAY_START;
                }
                if (node == EncounterType.SLAVE_USES_YOU) {
                    NPC slave = 5.getSlaveWantingToUseYouInDominion();
                    if (slave != null) {
                        return SlaveEncountersDialogue.getSlaveUsesYouAlleyway(slave);
                    }
                } else if (node == EncounterType.SLAVE_USING_OTHER_SLAVE) {
                    Util.Value<NPC, NPC> slaves = 5.getSlaveUsingOtherSlaveInDominion();
                    if (slaves == null || slaves.getKey() == null || slaves.getValue() == null) {
                        return null;
                    }
                    return SlaveEncountersDialogue.getSlaveUsingOtherSlaveAlleyway(slaves);
                }
                return null;
            }
        };
        DOMINION_DARK_ALLEY = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                HashMap<EncounterType, Float> map = new HashMap<EncounterType, Float>();
                map.put(EncounterType.DOMINION_ALLEY_ATTACK, Float.valueOf(15.0f));
                return map;
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                ArrayList<NPC> encounterPossibilities = new ArrayList<NPC>(Main.game.getNonCompanionCharactersPresent());
                if (!encounterPossibilities.isEmpty()) {
                    NPC encounterNpc = Util.randomItemFrom(encounterPossibilities);
                    Main.game.setActiveNPC(encounterNpc);
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                Main.game.setActiveNPC(new DominionSuccubusAttacker());
                try {
                    Main.game.addNPC(Main.game.getActiveNPC(), false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return Main.game.getActiveNPC().getEncounterDialogue();
            }
        };
        DOMINION_CANAL = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                return Util.newHashMapOfValues(new Util.Value<EncounterType, Float>(EncounterType.DOMINION_ALLEY_ATTACK, Float.valueOf(10.0f)), new Util.Value<EncounterType, Float>(EncounterType.DOMINION_FIND_ITEM, Float.valueOf(3.0f)), new Util.Value<EncounterType, Float>(EncounterType.DOMINION_FIND_CLOTHING, Float.valueOf(2.0f)), new Util.Value<EncounterType, Float>(EncounterType.DOMINION_FIND_WEAPON, Float.valueOf(1.0f)), Main.game.getCurrentWeather() != Weather.MAGIC_STORM && (!Main.game.getDialogueFlags().hasSavedLong("enforcer_encounter_minutes") || Main.game.getDialogueFlags().getSavedLong("enforcer_encounter_minutes") + 240L < Main.game.getMinutesPassed()) ? new Util.Value<EncounterType, Float>(EncounterType.DOMINION_ALLEY_ENFORCERS, Float.valueOf(2.5f)) : null, Main.game.getCurrentWeather() != Weather.MAGIC_STORM && 7.getSlaveWantingToUseYouInDominion() != null ? new Util.Value<EncounterType, Float>(EncounterType.SLAVE_USES_YOU, Float.valueOf(5.0f)) : null);
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                if (node == EncounterType.DOMINION_ALLEY_ATTACK) {
                    List<OffspringSeed> offspringAvailable;
                    ArrayList<NPC> encounterPossibilities = new ArrayList<NPC>(Main.game.getNonCompanionCharactersPresent());
                    if (!encounterPossibilities.isEmpty()) {
                        NPC encounterNpc = Util.randomItemFrom(encounterPossibilities);
                        Main.game.setActiveNPC(encounterNpc);
                        return Main.game.getActiveNPC().getEncounterDialogue();
                    }
                    if (Math.random() < 7.IncestEncounterRate() && Main.game.isOffspringEncountersEnabled() && !(offspringAvailable = Main.game.getOffspringNotSpawned(os -> os.getSubspecies() == Subspecies.HALF_DEMON ? os.getHalfDemonSubspecies().isAbleToNaturallySpawnInLocation(WorldType.DOMINION, PlaceType.DOMINION_CANAL) || os.getHalfDemonSubspecies() == Subspecies.SLIME || os.getHalfDemonSubspecies() == Subspecies.ALLIGATOR_MORPH || os.getHalfDemonSubspecies() == Subspecies.RAT_MORPH : os.getSubspecies().isAbleToNaturallySpawnInLocation(WorldType.DOMINION, PlaceType.DOMINION_CANAL) || os.getSubspecies() == Subspecies.SLIME || os.getSubspecies() == Subspecies.ALLIGATOR_MORPH || os.getSubspecies() == Subspecies.RAT_MORPH)).isEmpty()) {
                        return 7.SpawnAndStartChildHere(offspringAvailable);
                    }
                    Main.game.setActiveNPC(new DominionAlleywayAttacker(Gender.getGenderFromUserPreferences(false, false)));
                    try {
                        Main.game.addNPC(Main.game.getActiveNPC(), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Main.game.getActiveNPC().setLocation(Main.game.getPlayer(), true);
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                if (node == EncounterType.DOMINION_FIND_ITEM) {
                    randomItem = !Main.game.isSillyModeEnabled() || Math.random() < (double)0.99f ? Main.game.getItemGen().generateItem(ItemType.getDominionAlleywayItems().get(Util.random.nextInt(ItemType.getDominionAlleywayItems().size()))) : (Math.random() < 0.5 ? Main.game.getItemGen().generateItem(ItemType.EGGPLANT) : Main.game.getItemGen().generateItem("innoxia_cheat_unlikely_whammer"));
                    Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addItem((AbstractItem)randomItem);
                    return DominionEncounterDialogue.ALLEY_FIND_ITEM;
                }
                if (node == EncounterType.DOMINION_FIND_CLOTHING) {
                    Main.game.generateAlleywayClothing();
                    randomItem = Main.game.getAlleywayClothing();
                    Main.game.getPlayerCell().getInventory().addClothing((AbstractClothing)randomItem);
                    return DominionEncounterDialogue.ALLEY_FIND_ITEM;
                }
                if (node == EncounterType.DOMINION_FIND_WEAPON) {
                    ArrayList<AbstractWeaponType> weapons = new ArrayList<AbstractWeaponType>(WeaponType.getAllWeapons());
                    weapons.removeIf(w -> !w.getItemTags().contains((Object)ItemTag.DOMINION_ALLEYWAY_SPAWN));
                    randomItem = Main.game.getItemGen().generateWeapon((AbstractWeaponType)weapons.get(Util.random.nextInt(weapons.size())));
                    Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addWeapon((AbstractWeapon)randomItem);
                    return DominionEncounterDialogue.ALLEY_FIND_ITEM;
                }
                if (node == EncounterType.DOMINION_ALLEY_ENFORCERS) {
                    7.spawnEnforcers();
                    return EnforcerAlleywayDialogue.ENFORCER_ALLEYWAY_START;
                }
                if (node == EncounterType.SLAVE_USES_YOU) {
                    NPC slave = 7.getSlaveWantingToUseYouInDominion();
                    if (slave == null) {
                        return null;
                    }
                    return SlaveEncountersDialogue.getSlaveUsesYouAlleyway(slave);
                }
                return null;
            }
        };
        DOMINION_EXPRESS = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                return Util.newHashMapOfValues(new Util.Value<EncounterType, Float>(EncounterType.DOMINION_EXPRESS_CENTAUR, Float.valueOf(10.0f)));
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                AbstractClothing collar;
                if (node == EncounterType.DOMINION_EXPRESS_CENTAUR && (collar = Main.game.getPlayer().getClothingInSlot(InventorySlot.NECK)) != null && collar.getClothingType().getId().equals("innoxia_neck_filly_choker")) {
                    return DominionExpressCentaurDialogue.initEncounter();
                }
                return null;
            }
        };
        HARPY_NEST_WALKWAYS = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                return Util.newHashMapOfValues(new Util.Value<EncounterType, Float>(EncounterType.HARPY_NEST_ATTACK, Float.valueOf(12.0f)), new Util.Value<EncounterType, Float>(EncounterType.HARPY_NEST_FIND_ITEM, Float.valueOf(4.0f)));
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                if (!(node != EncounterType.HARPY_NEST_ATTACK || Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_HARPY_PACIFICATION) && Main.game.getCurrentWeather() != Weather.MAGIC_STORM)) {
                    List<OffspringSeed> offspringAvailable;
                    ArrayList<NPC> encounterPossibilities = new ArrayList<NPC>(Main.game.getNonCompanionCharactersPresent());
                    if (!encounterPossibilities.isEmpty()) {
                        NPC encounterNpc = Util.randomItemFrom(encounterPossibilities);
                        Main.game.setActiveNPC(encounterNpc);
                        return Main.game.getActiveNPC().getEncounterDialogue();
                    }
                    if (Math.random() < 9.IncestEncounterRate() && Main.game.isOffspringEncountersEnabled() && !(offspringAvailable = Main.game.getOffspringNotSpawned(os -> os.getSubspecies() == Subspecies.HALF_DEMON ? os.getHalfDemonSubspecies().getRace() == Race.HARPY : os.getSubspecies().getRace() == Race.HARPY)).isEmpty()) {
                        return 9.SpawnAndStartChildHere(offspringAvailable);
                    }
                    Main.game.setActiveNPC(new HarpyNestsAttacker(Gender.getGenderFromUserPreferences(false, false)));
                    Main.game.getActiveNPC().setLocation(Main.game.getPlayer().getLocation());
                    try {
                        Main.game.addNPC(Main.game.getActiveNPC(), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                if (node == EncounterType.HARPY_NEST_FIND_ITEM) {
                    randomItem = Math.random() < 0.66 ? Main.game.getItemGen().generateItem("innoxia_race_harpy_harpy_perfume") : Main.game.getItemGen().generateItem(ItemType.getItemTypeFromId("innoxia_race_harpy_bubblegum_lollipop"));
                    Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addItem((AbstractItem)randomItem);
                    return DominionEncounterDialogue.HARPY_NESTS_FIND_ITEM;
                }
                return null;
            }
        };
        HARPY_NEST_LOOK_FOR_TROUBLE = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                return Util.newHashMapOfValues(new Util.Value<EncounterType, Float>(EncounterType.HARPY_NEST_ATTACK, Float.valueOf(12.0f)), new Util.Value<EncounterType, Float>(EncounterType.HARPY_NEST_FIND_ITEM, Float.valueOf(4.0f)));
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                if (node == EncounterType.HARPY_NEST_ATTACK) {
                    List<OffspringSeed> offspringAvailable;
                    ArrayList<NPC> encounterPossibilities = new ArrayList<NPC>(Main.game.getNonCompanionCharactersPresent());
                    if (!encounterPossibilities.isEmpty()) {
                        NPC encounterNpc = Util.randomItemFrom(encounterPossibilities);
                        Main.game.setActiveNPC(encounterNpc);
                        return Main.game.getActiveNPC().getEncounterDialogue();
                    }
                    if (Math.random() < 10.IncestEncounterRate() && Main.game.isOffspringEncountersEnabled() && !(offspringAvailable = Main.game.getOffspringNotSpawned(os -> os.getSubspecies() == Subspecies.HALF_DEMON ? os.getHalfDemonSubspecies().getRace() == Race.HARPY : os.getSubspecies().getRace() == Race.HARPY)).isEmpty()) {
                        return 10.SpawnAndStartChildHere(offspringAvailable);
                    }
                    Main.game.setActiveNPC(new HarpyNestsAttacker(Gender.getGenderFromUserPreferences(false, false)));
                    Main.game.getActiveNPC().setLocation(Main.game.getPlayer().getLocation());
                    try {
                        Main.game.addNPC(Main.game.getActiveNPC(), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                if (node == EncounterType.HARPY_NEST_FIND_ITEM) {
                    randomItem = Math.random() < 0.66 ? Main.game.getItemGen().generateItem("innoxia_race_harpy_harpy_perfume") : Main.game.getItemGen().generateItem(ItemType.getItemTypeFromId("innoxia_race_harpy_bubblegum_lollipop"));
                    Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addItem((AbstractItem)randomItem);
                    return DominionEncounterDialogue.HARPY_NESTS_FIND_ITEM;
                }
                return null;
            }
        };
        SUBMISSION_TUNNELS = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                HashMap<EncounterType, Float> map = new HashMap<EncounterType, Float>();
                map.put(EncounterType.SUBMISSION_TUNNEL_ATTACK, Float.valueOf(20.0f));
                map.put(EncounterType.SUBMISSION_FIND_ITEM, Float.valueOf(10.0f));
                return map;
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                if (node == EncounterType.SUBMISSION_TUNNEL_ATTACK) {
                    List<OffspringSeed> offspringAvailable;
                    ArrayList<String> impAdjectives = new ArrayList<String>();
                    if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_IMP_TUNNELS_ALPHA) && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressAlphaDefeated)) {
                        ArrayList<ImpAttacker> impGroup = new ArrayList<ImpAttacker>();
                        try {
                            ImpAttacker imp = new ImpAttacker(Subspecies.IMP_ALPHA, Gender.F_P_V_B_FUTANARI, false);
                            imp.setGenericName("\u963f\u5c14\u6cd5\u5c0f\u6076\u9b54\u9996\u9886");
                            imp.setLevel(8 + Util.random.nextInt(5));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            imp = new ImpAttacker(Subspecies.IMP_ALPHA, Gender.F_P_V_B_FUTANARI, false);
                            imp.setLevel(6 + Util.random.nextInt(3));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            imp = new ImpAttacker(Subspecies.IMP, Gender.getGenderFromUserPreferences(false, false), false);
                            impAdjectives.add(Main.game.getCharacterUtils().setGenericName(imp, impAdjectives));
                            imp.setLevel(3 + Util.random.nextInt(4));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            imp = new ImpAttacker(Subspecies.IMP, Gender.getGenderFromUserPreferences(false, false), false);
                            impAdjectives.add(Main.game.getCharacterUtils().setGenericName(imp, impAdjectives));
                            imp.setLevel(3 + Util.random.nextInt(4));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            for (GameCharacter gameCharacter : impGroup) {
                                ((NPC)gameCharacter).equipClothing(EquipClothingSetting.getAllClothingSettings());
                            }
                        }
                        catch (Exception imp) {
                            // empty catch block
                        }
                        return ((NPC)impGroup.get(0)).getEncounterDialogue();
                    }
                    if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_IMP_TUNNELS_DEMON) && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressDemonDefeated)) {
                        ArrayList<ImpAttacker> impGroup = new ArrayList<ImpAttacker>();
                        try {
                            ImpAttacker imp = new ImpAttacker(Subspecies.IMP_ALPHA, Gender.getGenderFromUserPreferences(false, false), false);
                            imp.setGenericName("\u963f\u5c14\u6cd5\u5c0f\u6076\u9b54\u5965\u672f\u5e08");
                            imp.setAttribute(Attribute.MAJOR_ARCANE, 50.0f);
                            imp.addSpell(Spell.ARCANE_AROUSAL);
                            imp.addSpell(Spell.FIREBALL);
                            imp.addSpell(Spell.ICE_SHARD);
                            imp.addSpell(Spell.TELEKENETIC_SHOWER);
                            imp.setLevel(12 + Util.random.nextInt(7));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            imp = new ImpAttacker(Subspecies.IMP, Gender.getGenderFromUserPreferences(false, false), false);
                            impAdjectives.add(Main.game.getCharacterUtils().setGenericName(imp, impAdjectives));
                            imp.setLevel(6 + Util.random.nextInt(4));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            imp = new ImpAttacker(Subspecies.IMP, Gender.getGenderFromUserPreferences(false, false), false);
                            impAdjectives.add(Main.game.getCharacterUtils().setGenericName(imp, impAdjectives));
                            imp.setLevel(3 + Util.random.nextInt(4));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            imp = new ImpAttacker(Subspecies.IMP, Gender.getGenderFromUserPreferences(false, false), false);
                            impAdjectives.add(Main.game.getCharacterUtils().setGenericName(imp, impAdjectives));
                            imp.setLevel(3 + Util.random.nextInt(4));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            for (GameCharacter gameCharacter : impGroup) {
                                ((NPC)gameCharacter).equipClothing(EquipClothingSetting.getAllClothingSettings());
                            }
                        }
                        catch (Exception imp) {
                            // empty catch block
                        }
                        return ((NPC)impGroup.get(0)).getEncounterDialogue();
                    }
                    if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_IMP_TUNNELS_FEMALES) && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressFemalesDefeated)) {
                        ArrayList<ImpAttacker> impGroup = new ArrayList<ImpAttacker>();
                        try {
                            ImpAttacker imp = new ImpAttacker(Subspecies.IMP_ALPHA, Gender.F_V_B_FEMALE, false);
                            imp.setGenericName("\u963f\u5c14\u6cd5\u5c0f\u6076\u9b54\u9996\u9886");
                            imp.setLevel(12 + Util.random.nextInt(7));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            imp.setBreastSize(imp.getBreastSize().getMeasurement() + 4);
                            imp = new ImpAttacker(Subspecies.IMP, Gender.F_V_B_FEMALE, false);
                            impAdjectives.add(Main.game.getCharacterUtils().setGenericName(imp, impAdjectives));
                            imp.setLevel(8 + Util.random.nextInt(3));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            imp = new ImpAttacker(Subspecies.IMP, Gender.F_V_B_FEMALE, false);
                            impAdjectives.add(Main.game.getCharacterUtils().setGenericName(imp, impAdjectives));
                            imp.setLevel(6 + Util.random.nextInt(3));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            imp = new ImpAttacker(Subspecies.IMP, Gender.F_V_B_FEMALE, false);
                            impAdjectives.add(Main.game.getCharacterUtils().setGenericName(imp, impAdjectives));
                            imp.setLevel(4 + Util.random.nextInt(3));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            for (GameCharacter gameCharacter : impGroup) {
                                ((NPC)gameCharacter).equipClothing(EquipClothingSetting.getAllClothingSettings());
                            }
                        }
                        catch (Exception imp) {
                            // empty catch block
                        }
                        return ((NPC)impGroup.get(0)).getEncounterDialogue();
                    }
                    if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_IMP_TUNNELS_MALES) && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressMalesDefeated)) {
                        ArrayList<ImpAttacker> impGroup = new ArrayList<ImpAttacker>();
                        try {
                            ImpAttacker imp = new ImpAttacker(Subspecies.IMP_ALPHA, Gender.M_P_MALE, false);
                            imp.setGenericName("\u963f\u5c14\u6cd5\u5c0f\u6076\u9b54\u9996\u9886");
                            imp.setLevel(12 + Util.random.nextInt(7));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            imp = new ImpAttacker(Subspecies.IMP_ALPHA, Gender.M_P_MALE, false);
                            impAdjectives.add(Main.game.getCharacterUtils().setGenericName(imp, impAdjectives));
                            imp.setLevel(8 + Util.random.nextInt(3));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            imp = new ImpAttacker(Subspecies.IMP, Gender.M_P_MALE, false);
                            impAdjectives.add(Main.game.getCharacterUtils().setGenericName(imp, impAdjectives));
                            imp.setLevel(6 + Util.random.nextInt(3));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            imp = new ImpAttacker(Subspecies.IMP, Gender.M_P_MALE, false);
                            impAdjectives.add(Main.game.getCharacterUtils().setGenericName(imp, impAdjectives));
                            imp.setLevel(4 + Util.random.nextInt(3));
                            Main.game.addNPC(imp, false);
                            impGroup.add(imp);
                            for (GameCharacter gameCharacter : impGroup) {
                                ((NPC)gameCharacter).equipClothing(EquipClothingSetting.getAllClothingSettings());
                            }
                        }
                        catch (Exception imp) {
                            // empty catch block
                        }
                        return ((NPC)impGroup.get(0)).getEncounterDialogue();
                    }
                    ArrayList<NPC> encounterPossibilities = new ArrayList<NPC>(Main.game.getNonCompanionCharactersPresent());
                    if (!encounterPossibilities.isEmpty()) {
                        NPC encounterNpc = Util.randomItemFrom(encounterPossibilities);
                        Main.game.setActiveNPC(encounterNpc);
                        return Main.game.getActiveNPC().getEncounterDialogue();
                    }
                    if (Math.random() < 11.IncestEncounterRate() && Main.game.isOffspringEncountersEnabled() && !(offspringAvailable = Main.game.getOffspringNotSpawned(os -> os.getSubspecies() == Subspecies.HALF_DEMON ? os.getHalfDemonSubspecies().isAbleToNaturallySpawnInLocation(WorldType.SUBMISSION, PlaceType.SUBMISSION_TUNNELS) : os.getSubspecies().isAbleToNaturallySpawnInLocation(WorldType.SUBMISSION, PlaceType.SUBMISSION_TUNNELS))).isEmpty()) {
                        return 11.SpawnAndStartChildHere(offspringAvailable);
                    }
                    Main.game.setActiveNPC(new SubmissionAttacker(Gender.getGenderFromUserPreferences(false, false)));
                    try {
                        Main.game.addNPC(Main.game.getActiveNPC(), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Main.game.getActiveNPC().setLocation(Main.game.getPlayer(), true);
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                if (node == EncounterType.SUBMISSION_FIND_ITEM) {
                    randomItem = Main.game.getItemGen().generateItem(ItemType.getSubmissionTunnelItems().get(Util.random.nextInt(ItemType.getSubmissionTunnelItems().size())));
                    Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addItem((AbstractItem)randomItem);
                    return SubmissionEncounterDialogue.FIND_ITEM;
                }
                return null;
            }
        };
        BAT_CAVERN = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                AbstractPlaceType playerPlaceType;
                Vector2i entranceLocation;
                Vector2i playerLocation;
                int distanceFromEntrance;
                HashMap<EncounterType, Float> map = new HashMap<EncounterType, Float>();
                map.put(EncounterType.BAT_CAVERN_LURKER_ATTACK, Float.valueOf(8.0f));
                map.put(EncounterType.BAT_CAVERN_SLIME_ATTACK, Float.valueOf(6.0f));
                map.put(EncounterType.BAT_CAVERN_FIND_ITEM, Float.valueOf(6.0f));
                if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_REBEL_BASE) && !Main.game.getPlayer().isQuestFailed(QuestLine.SIDE_REBEL_BASE) && Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_HANDLE_REFUSED) && Main.game.getPlayerCell().getPlace().getPlaceType().equals(PlaceType.BAT_CAVERN_DARK) && (distanceFromEntrance = (int)(playerLocation = Main.game.getPlayer().getLocation()).getDistanceToVector(entranceLocation = Main.game.getWorlds().get(WorldType.BAT_CAVERNS).getCell(PlaceType.BAT_CAVERN_ENTRANCE).getLocation())) >= 3) {
                    if (Main.game.getPlayer().hasTraitActivated(Perk.OBSERVANT)) {
                        map.put(EncounterType.BAT_CAVERN_REBEL_BASE_DISCOVERED, Float.valueOf(10.0f));
                    } else {
                        map.put(EncounterType.BAT_CAVERN_REBEL_BASE_DISCOVERED, Float.valueOf(5.0f));
                    }
                }
                if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_REBEL_BASE) && !Main.game.getPlayer().isQuestFailed(QuestLine.SIDE_REBEL_BASE) && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_HANDLE_REFUSED) && Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_PASSWORD_COMPLETE) && ((playerPlaceType = Main.game.getPlayerCell().getPlace().getPlaceType()).equals(PlaceType.BAT_CAVERN_DARK) || playerPlaceType.equals(PlaceType.BAT_CAVERN_LIGHT) || playerPlaceType.equals(PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_EXTERIOR))) {
                    boolean alreadyFound;
                    boolean bl = alreadyFound = playerPlaceType.equals(PlaceType.BAT_CAVERN_DARK) && Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.rebelBaseDarkPassFound) || playerPlaceType.equals(PlaceType.BAT_CAVERN_LIGHT) && Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.rebelBaseLightPassFound);
                    if (!alreadyFound) {
                        EncounterType nextEncounter = EncounterType.BAT_CAVERN_REBEL_PASSWORD_TWO;
                        if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_PASSWORD_PART_TWO)) {
                            nextEncounter = EncounterType.BAT_CAVERN_REBEL_PASSWORD_ONE;
                        }
                        if (Main.game.getPlayer().hasTraitActivated(Perk.OBSERVANT)) {
                            map.put(nextEncounter, Float.valueOf(5.0f));
                        } else {
                            map.put(nextEncounter, Float.valueOf(1.0f));
                        }
                    }
                }
                return map;
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                if (node == EncounterType.BAT_CAVERN_LURKER_ATTACK) {
                    List<OffspringSeed> offspringAvailable;
                    ArrayList<NPC> encounterPossibilities = new ArrayList<NPC>(Main.game.getNonCompanionCharactersPresent());
                    if (!encounterPossibilities.isEmpty()) {
                        NPC encounterNpc = Util.randomItemFrom(encounterPossibilities);
                        Main.game.setActiveNPC(encounterNpc);
                        return Main.game.getActiveNPC().getEncounterDialogue();
                    }
                    if (Math.random() < 12.IncestEncounterRate() && Main.game.isOffspringEncountersEnabled() && !(offspringAvailable = Main.game.getOffspringNotSpawned(os -> os.getSubspecies() == Subspecies.HALF_DEMON ? os.getHalfDemonSubspecies().isAbleToNaturallySpawnInLocation(WorldType.BAT_CAVERNS, PlaceType.BAT_CAVERN_DARK) : os.getSubspecies().isAbleToNaturallySpawnInLocation(WorldType.BAT_CAVERNS, PlaceType.BAT_CAVERN_DARK))).isEmpty()) {
                        return 12.SpawnAndStartChildHere(offspringAvailable);
                    }
                    Main.game.setActiveNPC(new BatCavernLurkerAttacker(Gender.getGenderFromUserPreferences(false, false)));
                    try {
                        Main.game.addNPC(Main.game.getActiveNPC(), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                if (node == EncounterType.BAT_CAVERN_SLIME_ATTACK) {
                    List<OffspringSeed> offspringAvailable;
                    Iterator<NPC> encounterPossibilities = Main.game.getNonCompanionCharactersPresent().iterator();
                    if (encounterPossibilities.hasNext()) {
                        NPC npc = encounterPossibilities.next();
                        Main.game.setActiveNPC(npc);
                        return Main.game.getActiveNPC().getEncounterDialogue();
                    }
                    if (Math.random() < 12.IncestEncounterRate() && Main.game.isOffspringEncountersEnabled() && !(offspringAvailable = Main.game.getOffspringNotSpawned(os -> os.getBodyMaterial() == BodyMaterial.SLIME)).isEmpty()) {
                        return 12.SpawnAndStartChildHere(offspringAvailable);
                    }
                    Main.game.setActiveNPC(new BatCavernSlimeAttacker(Gender.getGenderFromUserPreferences(false, false)));
                    try {
                        Main.game.addNPC(Main.game.getActiveNPC(), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                if (node == EncounterType.BAT_CAVERN_FIND_ITEM) {
                    randomItem = Main.game.getPlayerCell().getPlace().getPlaceType() == PlaceType.BAT_CAVERN_LIGHT && Math.random() < (double)0.8f ? Main.game.getItemGen().generateItem(ItemType.MUSHROOM) : Main.game.getItemGen().generateItem(ItemType.getBatCavernItems().get(Util.random.nextInt(ItemType.getBatCavernItems().size())));
                    Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addItem((AbstractItem)randomItem);
                    return BatCavernsEncounterDialogue.FIND_ITEM;
                }
                if (node == EncounterType.BAT_CAVERN_REBEL_BASE_DISCOVERED) {
                    return BatCavernsEncounterDialogue.REBEL_BASE_DISCOVERED;
                }
                if (node == EncounterType.BAT_CAVERN_REBEL_PASSWORD_ONE) {
                    return BatCavernsEncounterDialogue.REBEL_BASE_PASSWORD_ONE;
                }
                if (node == EncounterType.BAT_CAVERN_REBEL_PASSWORD_TWO) {
                    return BatCavernsEncounterDialogue.REBEL_BASE_PASSWORD_TWO;
                }
                return null;
            }
        };
        REBEL_BASE = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                HashMap<EncounterType, Float> map = new HashMap<EncounterType, Float>();
                if (Main.game.getPlayer().hasQuestInLine(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_EXPLORATION) && !Main.game.getDialogueFlags().values.contains(DialogueFlagValue.rebelBaseInsaneSurvivorEncountered)) {
                    map.put(EncounterType.REBEL_BASE_INSANE_SURVIVOR_ATTACK, Float.valueOf(100.0f));
                }
                return map;
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                if (node == EncounterType.REBEL_BASE_INSANE_SURVIVOR_ATTACK) {
                    Main.game.setActiveNPC(new RebelBaseInsaneSurvivor(Gender.getGenderFromUserPreferences(false, false)));
                    try {
                        Main.game.addNPC(Main.game.getActiveNPC(), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                return null;
            }
        };
        VENGAR_CAPTIVE_HALL = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                HashMap<EncounterType, Float> map = new HashMap<EncounterType, Float>();
                map.put(EncounterType.VENGAR_CAPTIVE_SERVE, Float.valueOf(40.0f));
                map.put(EncounterType.VENGAR_CAPTIVE_GROPED, Float.valueOf(20.0f));
                map.put(EncounterType.VENGAR_CAPTIVE_RAT_FUCK, Float.valueOf(10.0f));
                map.put(EncounterType.VENGAR_CAPTIVE_ORAL_UNDER_TABLE, Float.valueOf(5.0f));
                if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.vengarCaptiveVengarSatisfied)) {
                    map.put(EncounterType.VENGAR_CAPTIVE_VENGAR_FUCK, Float.valueOf(10.0f));
                }
                if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.vengarCaptiveGangBanged)) {
                    map.put(EncounterType.VENGAR_CAPTIVE_GROUP_SEX, Float.valueOf(2.0f));
                }
                return map;
            }

            @Override
            protected DialogueNode getBaseRandomEncounter(boolean forceEncounter) {
                if (!Main.game.isExtendedWorkTime()) {
                    return VengarCaptiveDialogue.VENGARS_HALL_NIGHT_TIME;
                }
                if (Main.game.getPlayer().hasStatusEffect(StatusEffect.PREGNANT_3)) {
                    return VengarCaptiveDialogue.VENGARS_HALL_DELIVERY;
                }
                if (Main.game.getPlayer().hasCompanions() && Main.game.getPlayer().getMainCompanion().hasStatusEffect(StatusEffect.PREGNANT_3)) {
                    return VengarCaptiveDialogue.VENGARS_HALL_DELIVERY;
                }
                return super.getBaseRandomEncounter(forceEncounter);
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                if (node == EncounterType.VENGAR_CAPTIVE_SERVE) {
                    return VengarCaptiveDialogue.VENGARS_HALL_SERVE;
                }
                if (node == EncounterType.VENGAR_CAPTIVE_GROPED) {
                    return VengarCaptiveDialogue.VENGARS_HALL_GROPED;
                }
                if (node == EncounterType.VENGAR_CAPTIVE_VENGAR_FUCK) {
                    return VengarCaptiveDialogue.VENGARS_HALL_VENGAR_FUCK;
                }
                if (node == EncounterType.VENGAR_CAPTIVE_RAT_FUCK) {
                    return VengarCaptiveDialogue.VENGARS_HALL_RAT_FUCK;
                }
                if (node == EncounterType.VENGAR_CAPTIVE_GROUP_SEX) {
                    return VengarCaptiveDialogue.VENGARS_HALL_GROUP_SEX;
                }
                return null;
            }
        };
        VENGAR_CAPTIVE_BEDROOM = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                HashMap<EncounterType, Float> map = new HashMap<EncounterType, Float>();
                if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.vengarCaptiveRoomCleaned)) {
                    map.put(EncounterType.VENGAR_CAPTIVE_CLEAN_ROOM, Float.valueOf(50.0f));
                }
                if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.vengarCaptiveShadowSatisfied) || !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.vengarCaptiveSilenceSatisfied)) {
                    map.put(EncounterType.VENGAR_CAPTIVE_SHADOW_SILENCE_DOMINATE, Float.valueOf(25.0f));
                }
                if (map.isEmpty()) {
                    map.put(EncounterType.VENGAR_CAPTIVE_ROOM_BARRED, Float.valueOf(80.0f));
                }
                return map;
            }

            @Override
            protected DialogueNode getBaseRandomEncounter(boolean forceEncounter) {
                if (!Main.game.isExtendedWorkTime()) {
                    return VengarCaptiveDialogue.VENGARS_BEDROOM_NIGHT_TIME;
                }
                return super.getBaseRandomEncounter(forceEncounter);
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                if (node == EncounterType.VENGAR_CAPTIVE_CLEAN_ROOM) {
                    return VengarCaptiveDialogue.VENGARS_BEDROOM_CLEAN;
                }
                if (node == EncounterType.VENGAR_CAPTIVE_SHADOW_SILENCE_DOMINATE) {
                    return VengarCaptiveDialogue.VENGARS_BEDROOM_SHADOW_SILENCE;
                }
                if (node == EncounterType.VENGAR_CAPTIVE_ROOM_BARRED) {
                    return VengarCaptiveDialogue.VENGARS_BEDROOM_BARRED;
                }
                return null;
            }
        };
        DOMINION_PARK = new AbstractEncounter(){

            @Override
            public Map<EncounterType, Float> getDialogues() {
                HashMap<EncounterType, Float> map = new HashMap<EncounterType, Float>();
                if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.natalyaParkEncounter) && Main.game.isHourBetween(9.0f, 15.0f) && Main.game.getCurrentWeather() != Weather.MAGIC_STORM && Main.game.getCurrentWeather() != Weather.MAGIC_STORM_GATHERING && !Main.game.getPlayer().isQuestFailed(QuestLine.ROMANCE_NATALYA) && (Main.game.getPlayer().isQuestCompleted(QuestLine.ROMANCE_NATALYA) || !Main.game.getPlayer().hasQuest(QuestLine.ROMANCE_NATALYA) && !Main.game.getPlayer().hasItemType(ItemType.NATALYA_BUSINESS_CARD)) && Main.game.getWorlds().get(WorldType.DOMINION).getCells(PlaceType.DOMINION_PARK).stream().filter(c -> c.isTravelledTo()).collect(Collectors.toList()).size() >= 2) {
                    map.put(EncounterType.DOMINION_PARK_NATALYA, Float.valueOf(100.0f));
                } else if (Main.game.getCurrentWeather() == Weather.MAGIC_STORM) {
                    map.put(EncounterType.DOMINION_STORM_ATTACK, Float.valueOf(15.0f));
                } else {
                    map.put(EncounterType.DOMINION_EXPRESS_CENTAUR, Float.valueOf(1.0f));
                    if (16.getSlaveWantingToUseYouInDominion() != null) {
                        map.put(EncounterType.SLAVE_USES_YOU, Float.valueOf(5.0f));
                    }
                }
                return map;
            }

            @Override
            protected DialogueNode initialiseEncounter(EncounterType node) {
                AbstractClothing collar;
                if (node == EncounterType.DOMINION_PARK_NATALYA) {
                    return DominionPark.NATALYA_ENCOUNTER_START;
                }
                if (node == EncounterType.DOMINION_STORM_ATTACK && Main.game.getCurrentWeather() == Weather.MAGIC_STORM) {
                    DominionAlleywayAttacker npc = new DominionAlleywayAttacker(Gender.getGenderFromUserPreferences(false, false), false, NPCGenerationFlag.DIRTY);
                    try {
                        Main.game.addNPC(npc, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    npc.setLocation(Main.game.getPlayer(), true);
                    Main.game.setActiveNPC(npc);
                    return Main.game.getActiveNPC().getEncounterDialogue();
                }
                if (node == EncounterType.DOMINION_EXPRESS_CENTAUR && (collar = Main.game.getPlayer().getClothingInSlot(InventorySlot.NECK)) != null && collar.getClothingType().getId().equals("innoxia_neck_filly_choker")) {
                    return DominionExpressCentaurDialogue.initEncounter();
                }
                if (node == EncounterType.SLAVE_USES_YOU) {
                    NPC slave = 16.getSlaveWantingToUseYouInDominion();
                    if (slave == null) {
                        return null;
                    }
                    return SlaveEncountersDialogue.getSlaveUsesYouStreet(slave);
                }
                return null;
            }
        };
        encounterToIdMap = new HashMap<AbstractEncounter, String>();
        idToEncounterMap = new HashMap<String, AbstractEncounter>();
        addedEncounters = new HashMap<String, List<AbstractEncounter>>();
        allEncounters = new ArrayList<AbstractEncounter>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/encounters");
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> entry2 : entry.getValue().entrySet()) {
                try {
                    AbstractEncounter abstractEncounter = new AbstractEncounter(entry2.getValue(), entry.getKey(), true){

                        @Override
                        protected DialogueNode initialiseEncounter(EncounterType node) {
                            return null;
                        }

                        @Override
                        public Map<EncounterType, Float> getDialogues() {
                            return null;
                        }
                    };
                    allEncounters.add(abstractEncounter);
                    encounterToIdMap.put(abstractEncounter, entry2.getKey());
                    idToEncounterMap.put(entry2.getKey(), abstractEncounter);
                }
                catch (Exception exception) {
                    System.err.println("Loading modded encounter failed at 'Encounter'. File path: " + entry2.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    exception.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/encounters");
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> entry3 : entry.getValue().entrySet()) {
                try {
                    AbstractEncounter encounter = new AbstractEncounter(entry3.getValue(), entry.getKey(), false){

                        @Override
                        protected DialogueNode initialiseEncounter(EncounterType node) {
                            return null;
                        }

                        @Override
                        public Map<EncounterType, Float> getDialogues() {
                            return null;
                        }
                    };
                    String id = "innoxia_" + entry3.getKey();
                    allEncounters.add(encounter);
                    encounterToIdMap.put(encounter, id);
                    idToEncounterMap.put(id, encounter);
                }
                catch (Exception ex) {
                    System.err.println("Loading encounter failed at 'Encounter'. File path: " + entry3.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
        Field[] fieldArray2 = fieldArray = Encounter.class.getFields();
        int n = fieldArray2.length;
        boolean bl = false;
        while (var5_21 < n) {
            Field f = fieldArray2[var5_21];
            if (AbstractEncounter.class.isAssignableFrom(f.getType())) {
                try {
                    AbstractEncounter encounter = (AbstractEncounter)f.get(null);
                    encounterToIdMap.put(encounter, f.getName());
                    idToEncounterMap.put(f.getName(), encounter);
                    allEncounters.add(encounter);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            ++var5_21;
        }
        for (AbstractEncounter abstractEncounter : allEncounters) {
            if (abstractEncounter.getPlaceTypeIds() == null) continue;
            for (String placeId : abstractEncounter.getPlaceTypeIds()) {
                addedEncounters.putIfAbsent(placeId, new ArrayList());
                addedEncounters.get(placeId).add(abstractEncounter);
            }
        }
    }
}

