/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.eventLog;

import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.dialogue.eventLog.EventLogEntry;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;

public class EventLogEntryAttributeChange
extends EventLogEntry {
    private AbstractAttribute attribute;
    private float change;

    public EventLogEntryAttributeChange(AbstractAttribute attribute, float change, boolean isCore) {
        super(isCore ? "<span style='color:" + attribute.getColour().toWebHexString() + ";'>\u6838\u5fc3" + Util.capitaliseSentence(attribute.getName()) + "</span>" : "<span style='color:" + attribute.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(attribute.getName()) + "</span>", isCore ? (change > 0.0f ? "<span style='color:" + PresetColour.GENERIC_EXCELLENT.toWebHexString() + ";'>+" + change + "</span>" : "<span style='color:" + PresetColour.GENERIC_TERRIBLE.toWebHexString() + ";'>" + change + "</span>") : (change > 0.0f ? "<span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>+" + change + "</span>" : "<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + change + "</span>"));
        this.attribute = attribute;
        this.change = change;
    }

    @Override
    public String getFormattedEntry() {
        return this.name + ": " + this.description;
    }

    @Override
    public String getMainDialogueDescription() {
        return Main.game.getPlayer().getAttributeChangeText(this.attribute, this.change);
    }
}

