/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.npcDialogue.dominion;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseSex;
import com.lilithsthrone.game.dialogue.responses.ResponseTag;
import com.lilithsthrone.game.dialogue.responses.ResponseTrade;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.sex.managers.universal.SMGeneric;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;

public class ReindeerOverseerDialogue {
    public static final DialogueNode ENCOUNTER_START = new DialogueNode("\u9a6f\u9e7f\u76d1\u5de5", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/reindeerOverseer", "ENCOUNTER_START", ReindeerOverseerDialogue.getReindeer());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return ReindeerOverseerDialogue.getDefaultResponses(index);
        }
    };
    public static final DialogueNode ENCOUNTER_WORK = new DialogueNode("\u9a6f\u9e7f\u76d1\u5de5", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/reindeerOverseer", "ENCOUNTER_WORK", ReindeerOverseerDialogue.getReindeer());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u94f2\u96ea", UtilText.parse((GameCharacter)ReindeerOverseerDialogue.getReindeer(), "\u544a\u8bc9[npc.name]\u4f60\u53ef\u4ee5\u8ddf\u5176\u4ed6\u5de5\u4eba\u4e00\u8d77\u94f2\u96ea\u3002<br/>\u8868\u73b0\u548c\u62a5\u916c\u57fa\u4e8e\u4f60\u7684[style.italicsStrength(" + Attribute.MAJOR_PHYSIQUE.getName() + ")]\u3002", new ParserTag[0]), ENCOUNTER_WORK_FINISHED){

                    @Override
                    public void effects() {
                        int money = 100 + (int)(Main.game.getPlayer().getAttributeValue(Attribute.MAJOR_PHYSIQUE) * 1.5f);
                        UtilText.addSpecialParsingString(Util.intToString(money), true);
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/reindeerOverseer", "ENCOUNTER_WORK_SHOVEL_SNOW", ReindeerOverseerDialogue.getReindeer()));
                        Main.game.getTextStartStringBuilder().append(Main.game.getPlayer().incrementMoney(money));
                    }
                };
            }
            if (index == 2) {
                return new Response("\u4f7f\u7528\u653e\u70ed\u677f", UtilText.parse((GameCharacter)ReindeerOverseerDialogue.getReindeer(), "\u544a\u8bc9[npc.name]\u4f60\u53ef\u4ee5\u62ff\u4e00\u5757\u653e\u70ed\u677f\uff0c\u4e00\u884c\u4e00\u884c\u5730\u9664\u96ea\u3002<br/>\u8868\u73b0\u548c\u62a5\u916c\u57fa\u4e8e\u4f60\u7684[style.italicsIntelligence(" + Attribute.MAJOR_ARCANE.getName() + ")]\u3002", new ParserTag[0]), ENCOUNTER_WORK_FINISHED){

                    @Override
                    public void effects() {
                        int money = 100 + (int)(Main.game.getPlayer().getAttributeValue(Attribute.MAJOR_ARCANE) * 1.5f);
                        UtilText.addSpecialParsingString(Util.intToString(money), true);
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/reindeerOverseer", "ENCOUNTER_WORK_HEAT_STAVE", ReindeerOverseerDialogue.getReindeer()));
                        Main.game.getTextStartStringBuilder().append(Main.game.getPlayer().incrementMoney(money));
                    }
                };
            }
            if (index == 3) {
                return new Response("\u201c\u6fc0\u52b1\u201d", UtilText.parse((GameCharacter)ReindeerOverseerDialogue.getReindeer(), "\u544a\u8bc9[npc.name]\u4f60\u6700\u9002\u5408\u9012\u9001\u996e\u6599\u548c\u201c\u6fc0\u52b1\u201d\u5de5\u4eba\u3002<br/>\u8868\u73b0\u548c\u62a5\u916c\u57fa\u4e8e\u4f60\u7684[style.italicsCorruption(" + Attribute.MAJOR_CORRUPTION.getName() + ")]\u3002", new ParserTag[0]), ENCOUNTER_WORK_FINISHED){

                    @Override
                    public void effects() {
                        int money = 100 + (int)(Main.game.getPlayer().getAttributeValue(Attribute.MAJOR_CORRUPTION) * 1.5f);
                        UtilText.addSpecialParsingString(Util.intToString(money), true);
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/reindeerOverseer", "ENCOUNTER_WORK_ENCOURAGEMENT", ReindeerOverseerDialogue.getReindeer()));
                        Main.game.getTextStartStringBuilder().append(Main.game.getPlayer().incrementMoney(money));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ENCOUNTER_WORK_FINISHED = new DialogueNode("\u9a6f\u9e7f\u76d1\u5de5", "", true){

        @Override
        public int getSecondsPassed() {
            return 14400;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/reindeerOverseer", "ENCOUNTER_WORK_FINISHED", ReindeerOverseerDialogue.getReindeer());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return ReindeerOverseerDialogue.getDefaultResponses(index);
        }
    };
    public static final DialogueNode AFTER_SEX = new DialogueNode("\u7ed3\u675f", "", true){

        @Override
        public String getDescription() {
            return UtilText.parse((GameCharacter)ReindeerOverseerDialogue.getReindeer(), "[npc.Name]\u5df2\u7ecf\u723d\u591f\u4e86\uff0c\u6027\u7231\u5c31\u6b64\u7ed3\u675f\u2026\u2026", new ParserTag[0]);
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/reindeerOverseer", "AFTER_SEX", ReindeerOverseerDialogue.getReindeer());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return ReindeerOverseerDialogue.getDefaultResponses(index);
        }
    };

    private static NPC getReindeer() {
        return Main.game.getActiveNPC();
    }

    private static Response getDefaultResponses(int index) {
        if (index == 1) {
            return new ResponseTrade("\u4ea4\u6613", UtilText.parse((GameCharacter)ReindeerOverseerDialogue.getReindeer(), "\u95ee\u95ee[npc.name]\u90fd\u5356\u4ec0\u4e48\u5723\u8bde\u793c\u7269\u3002", new ParserTag[0]), ReindeerOverseerDialogue.getReindeer()){

                @Override
                public void effects() {
                    Main.game.getDialogueFlags().addReindeerEncountered(ReindeerOverseerDialogue.getReindeer().getId());
                }
            };
        }
        if (index == 2) {
            if (Main.game.getDialogueFlags().hasWorkedForReindeer(ReindeerOverseerDialogue.getReindeer().getId())) {
                return new Response("\u5de5\u4f5c", UtilText.parse((GameCharacter)ReindeerOverseerDialogue.getReindeer(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u5e2e[npc.name]\u5b8c\u6210\u4e86\u6240\u6709\u5de5\u4f5c\uff0c\u5982\u679c\u8fd8\u60f3\u5e2e\u5fd9\u5c31\u7b49\u5230\u660e\u5929\u518d\u6765\u3002", new ParserTag[0]), null);
            }
            return new Response("\u5de5\u4f5c", "\u4e3b\u52a8\u63d0\u51fa\u5e2e\u9a6f\u9e7f\u5316\u5f62\u5de5\u4f5c\u3002", ENCOUNTER_WORK){

                @Override
                public void effects() {
                    Main.game.getDialogueFlags().addReindeerEncountered(ReindeerOverseerDialogue.getReindeer().getId());
                    Main.game.getDialogueFlags().addReindeerDailyWorkedFor(ReindeerOverseerDialogue.getReindeer().getId());
                }
            };
        }
        if (index == 3) {
            if (!Main.game.getDialogueFlags().hasWorkedForReindeer(ReindeerOverseerDialogue.getReindeer().getId())) {
                return new Response("\u7f13\u89e3\u538b\u529b", UtilText.parse((GameCharacter)ReindeerOverseerDialogue.getReindeer(), "[npc.Name]\u5fd9\u7740\u624b\u5934\u4e0a\u7684\u5de5\u4f5c\u3002\u5982\u679c\u4f60\u80fd\u5148\u5e2e\u4e00\u628a\uff0c[npc.she]\u6216\u8bb8\u5c31\u6709\u4e8b\u4ef6\u8ddf\u4f60\u505a\u4e86\u2026\u2026", new ParserTag[0]), null);
            }
            if (!ReindeerOverseerDialogue.getReindeer().isAttractedTo(Main.game.getPlayer())) {
                return new Response("\u7f13\u89e3\u538b\u529b", UtilText.parse((GameCharacter)ReindeerOverseerDialogue.getReindeer(), "[npc.Name]\u5e76\u6ca1\u6709\u88ab\u4f60\u5438\u5f15\uff0c\u56e0\u800c[npc.sheIs]\u4e5f\u4e0d\u613f\u610f\u8ddf\u4f60\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
            }
            return new ResponseSex("\u7f13\u89e3\u538b\u529b", UtilText.parse((GameCharacter)ReindeerOverseerDialogue.getReindeer(), "\u8be2\u95ee[npc.name]\u613f\u4e0d\u613f\u610f\u8ddf\u4f60\u5ba3\u6cc4\u4e00\u756a\u3002", new ParserTag[0]), true, true, new SMGeneric(Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(ReindeerOverseerDialogue.getReindeer()), null, null, new ResponseTag[0]){

                @Override
                public boolean isPublicSex() {
                    return false;
                }
            }, AFTER_SEX, UtilText.parseFromXMLFile("characters/dominion/reindeerOverseer", "SEX_START")){

                @Override
                public void effects() {
                    Main.game.getDialogueFlags().addReindeerEncountered(ReindeerOverseerDialogue.getReindeer().getId());
                }
            };
        }
        if (index == 0) {
            return new Response("\u79bb\u5f00", UtilText.parse((GameCharacter)ReindeerOverseerDialogue.getReindeer(), "\u544a\u8bc9[npc.name]\u4f60\u53ef\u80fd\u4e4b\u540e\u518d\u56de\u6765\uff0c\u7136\u540e\u79bb\u5f00\u3002", new ParserTag[0]), ENCOUNTER_START){

                @Override
                public void effects() {
                    Main.game.getDialogueFlags().addReindeerEncountered(ReindeerOverseerDialogue.getReindeer().getId());
                }

                @Override
                public DialogueNode getNextDialogue() {
                    return Main.game.getDefaultDialogue(false);
                }
            };
        }
        return null;
    }
}

